/*
 * Decompiled with CFR 0.152.
 */
package ibase.system.config.resource;

import ibase.planner.utility.ITMException;
import ibase.system.config.BaseStatement;
import ibase.system.config.ConnectionMonitor;
import ibase.system.config.resource.BasePreparedStatement;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;

public class BaseDBConnection
implements Connection {
    private Connection wrappedConnection = null;
    CommonConstants commonConstants = new CommonConstants();
    private boolean isPool = false;
    private UserInfoBean userInfo = new UserInfoBean();

    public BaseDBConnection(String driver_name, String driver_url, String database_username, String database_password, String isAutoCommit) throws SQLException, ClassNotFoundException {
        try {
            Class.forName(driver_name);
            this.isPool = false;
            if (CommonConstants.DB_NAME.trim().equalsIgnoreCase("oracle")) {
                this.wrappedConnection = driver_name.trim().equalsIgnoreCase("oracle.jdbc.driver.OracleDriver") ? (OracleConnection)DriverManager.getConnection(driver_url, database_username, database_password) : DriverManager.getConnection(driver_url, database_username, database_password);
                if (driver_url.trim().indexOf("Excel") == -1) {
                    if (isAutoCommit != null && isAutoCommit.length() != 0) {
                        this.wrappedConnection.setAutoCommit(Boolean.valueOf(isAutoCommit));
                    } else {
                        this.wrappedConnection.setAutoCommit(false);
                    }
                }
            } else {
                this.wrappedConnection = DriverManager.getConnection(driver_url, database_username, database_password);
            }
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateConnectionDetails(stackTraceElements, "dirty");
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            throw cnfe;
        }
    }

    public BaseDBConnection(String driver_name, String driver_url, String database_username, String database_password, String isAutoCommit, UserInfoBean userInfo) throws SQLException, ClassNotFoundException {
        try {
            Class.forName(driver_name);
            this.isPool = false;
            this.userInfo = userInfo;
            if (CommonConstants.DB_NAME.trim().equalsIgnoreCase("oracle")) {
                this.wrappedConnection = driver_name.trim().equalsIgnoreCase("oracle.jdbc.driver.OracleDriver") ? (OracleConnection)DriverManager.getConnection(driver_url, database_username, database_password) : DriverManager.getConnection(driver_url, database_username, database_password);
                if (driver_url.trim().indexOf("Excel") == -1) {
                    if (isAutoCommit != null && isAutoCommit.length() != 0) {
                        this.wrappedConnection.setAutoCommit(Boolean.valueOf(isAutoCommit));
                    } else {
                        this.wrappedConnection.setAutoCommit(false);
                    }
                }
            } else {
                this.wrappedConnection = DriverManager.getConnection(driver_url, database_username, database_password);
            }
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateConnectionDetails(stackTraceElements, "dirty");
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            throw cnfe;
        }
    }

    public BaseDBConnection(String dataSourceName, String isAutoCommit) throws Exception {
        try {
            this.isPool = true;
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup("java:/" + dataSourceName);
            this.wrappedConnection = ds.getConnection();
            if (isAutoCommit != null && isAutoCommit.length() != 0) {
                this.wrappedConnection.setAutoCommit(Boolean.valueOf(isAutoCommit));
            } else if (!CommonConstants.DB_NAME.equalsIgnoreCase("mysql")) {
                this.wrappedConnection.setAutoCommit(false);
            }
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateConnectionDetails(stackTraceElements, "dirty");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: BaseDBConnection " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    public BaseDBConnection(String dataSourceName, String isAutoCommit, UserInfoBean userInfo) throws Exception {
        try {
            this.isPool = true;
            this.userInfo = userInfo;
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup("java:/" + dataSourceName);
            this.wrappedConnection = ds.getConnection();
            if (isAutoCommit != null && isAutoCommit.length() != 0) {
                this.wrappedConnection.setAutoCommit(Boolean.valueOf(isAutoCommit));
            } else if (!CommonConstants.DB_NAME.equalsIgnoreCase("mysql")) {
                this.wrappedConnection.setAutoCommit(false);
            }
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateConnectionDetails(stackTraceElements, "dirty");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: BaseDBConnection " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.wrappedConnection.close();
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateConnectionDetails(stackTraceElements, "clean");
        }
        catch (SQLException sqle) {
            BaseLogger.log("0", null, null, "Exception in close:[" + sqle.getMessage() + "]");
            sqle.printStackTrace();
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateConnectionDetails(stackTraceElements, "exceptionInClose");
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        String retSql = null;
        try {
            retSql = this.wrappedConnection.nativeSQL(sql);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        return retSql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            if (!CommonConstants.DB_NAME.equalsIgnoreCase("mysql")) {
                this.wrappedConnection.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        boolean isAutoCommit;
        try {
            isAutoCommit = this.wrappedConnection.getAutoCommit();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        return isAutoCommit;
    }

    @Override
    public void commit() throws SQLException {
        try {
            if (!CommonConstants.DB_NAME.equalsIgnoreCase("mysql")) {
                this.wrappedConnection.commit();
            }
            String className = "";
            String methodName = "";
            int lineNumber = 0;
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            if (stackTraceElements != null && stackTraceElements.length >= 2) {
                className = stackTraceElements[2].getFileName();
                methodName = stackTraceElements[2].getMethodName();
                lineNumber = stackTraceElements[2].getLineNumber();
            }
            BaseLogger.log("0", null, null, "BaseDBConnection.commit() method called from class [" + className + "] method [" + methodName + "] line number [" + lineNumber + "]");
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            if (!CommonConstants.DB_NAME.equalsIgnoreCase("mysql")) {
                this.wrappedConnection.rollback();
            }
            String className = "";
            String methodName = "";
            int lineNumber = 0;
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            if (stackTraceElements != null && stackTraceElements.length >= 2) {
                className = stackTraceElements[2].getFileName();
                methodName = stackTraceElements[2].getMethodName();
                lineNumber = stackTraceElements[2].getLineNumber();
            }
            BaseLogger.log("0", null, null, "BaseDBConnection.rollback() method called from class [" + className + "] method [" + methodName + "] line number [" + lineNumber + "]");
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        boolean isClosed;
        try {
            isClosed = this.wrappedConnection.isClosed();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        return isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaData databaseMetaData = null;
        try {
            databaseMetaData = this.wrappedConnection.getMetaData();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        return databaseMetaData;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.wrappedConnection.setReadOnly(true);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        boolean isReadOnly;
        try {
            isReadOnly = this.wrappedConnection.isReadOnly();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        return isReadOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            this.wrappedConnection.setCatalog(catalog);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        String catalog = null;
        try {
            catalog = this.wrappedConnection.getCatalog();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        return catalog;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.wrappedConnection.setTransactionIsolation(level);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        int level;
        try {
            level = this.wrappedConnection.getTransactionIsolation();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        return level;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sqlWarning = null;
        try {
            sqlWarning = this.wrappedConnection.getWarnings();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        return sqlWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.wrappedConnection.clearWarnings();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        BaseStatement statement = null;
        try {
            statement = new BaseStatement(this.wrappedConnection);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        BaseStatement statement = null;
        try {
            statement = new BaseStatement(this.wrappedConnection, resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        BaseStatement statement = null;
        try {
            statement = new BaseStatement(this.wrappedConnection, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        BasePreparedStatement pstat = null;
        try {
            pstat = new BasePreparedStatement(this.wrappedConnection, sql, this.isPool);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        catch (ITMException e) {
            e.printStackTrace();
        }
        return pstat;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        BasePreparedStatement preStatement = null;
        try {
            preStatement = new BasePreparedStatement(this.wrappedConnection, sql, resultSetType, resultSetConcurrency, this.isPool);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        catch (ITMException e) {
            e.printStackTrace();
        }
        return preStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        BasePreparedStatement preStatement = null;
        try {
            preStatement = new BasePreparedStatement(this.wrappedConnection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, this.isPool);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        catch (ITMException e) {
            e.printStackTrace();
        }
        return preStatement;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement cs = null;
        try {
            cs = this.wrappedConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        return cs;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement callablestat = null;
        try {
            callablestat = this.wrappedConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        return callablestat;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement callablestat = null;
        try {
            callablestat = this.wrappedConnection.prepareCall(sql);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        return callablestat;
    }

    public Map getTypeMap() throws SQLException {
        Map<String, Class<?>> typeMap = null;
        try {
            typeMap = this.wrappedConnection.getTypeMap();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        return typeMap;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        BasePreparedStatement prepareStatement = null;
        try {
            prepareStatement = new BasePreparedStatement(this.wrappedConnection, sql, autoGeneratedKeys, this.isPool);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        catch (ITMException e) {
            e.printStackTrace();
        }
        return prepareStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        BasePreparedStatement prepareStatement = null;
        try {
            prepareStatement = new BasePreparedStatement(this.wrappedConnection, sql, columnIndexes, this.isPool);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        catch (ITMException e) {
            e.printStackTrace();
        }
        return prepareStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        BasePreparedStatement prepareStatement = null;
        try {
            prepareStatement = new BasePreparedStatement(this.wrappedConnection, sql, columnNames, this.isPool);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        catch (ITMException e) {
            e.printStackTrace();
        }
        return prepareStatement;
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            this.wrappedConnection.setTypeMap(map);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        try {
            this.wrappedConnection.setHoldability(holdability);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        int holdability;
        try {
            holdability = this.wrappedConnection.getHoldability();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        return holdability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        Savepoint savepoint = null;
        try {
            savepoint = this.wrappedConnection.setSavepoint();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        return savepoint;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        Savepoint savepoint = null;
        try {
            savepoint = this.wrappedConnection.setSavepoint(name);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        return savepoint;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.wrappedConnection.rollback(savepoint);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.wrappedConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return false;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    private void updateConnectionDetails(StackTraceElement[] stackTraceElements, String status) {
        String className = "";
        String methodName = "";
        int lineNo = 0;
        try {
            String stackTrace = this.getStackTrace(stackTraceElements);
            if (stackTraceElements != null && stackTraceElements.length >= 6) {
                className = stackTraceElements[4].getFileName();
                methodName = stackTraceElements[4].getMethodName();
                lineNo = stackTraceElements[4].getLineNumber();
                if (className != null && (className.contains("ValidatorEJB") || className.contains("ActionHandlerEJB") || className.contains("ProcessEJB"))) {
                    className = stackTraceElements[5].getFileName();
                    methodName = stackTraceElements[5].getMethodName();
                    lineNo = stackTraceElements[5].getLineNumber();
                }
            }
            ConnectionMonitor connenctionInfo = new ConnectionMonitor(this.userInfo.getLoginCode(), this.userInfo.getTransDB(), new Date(), new Date(), "" + this.wrappedConnection.hashCode(), status, this.userInfo.getRemoteHost(), className, methodName, lineNo, stackTrace);
            connenctionInfo.updateConnectionMonitorDetails();
            connenctionInfo = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in updateConnectionDetails:[" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    private String getStackTrace(StackTraceElement[] stackTraceElements) {
        StringBuilder sb = new StringBuilder();
        try {
            if (stackTraceElements != null && stackTraceElements.length >= 7) {
                int i = 3;
                while (i < 6) {
                    sb.append("\n " + stackTraceElements[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in getStackTrace:[" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return sb.toString();
    }
}

