/*
 * Decompiled with CFR 0.152.
 */
package ibase.system.config;

import ibase.system.config.StatementMonitor;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Date;
import oracle.jdbc.OracleStatement;

public class BaseStatement
implements Statement {
    Statement stmt = null;
    OracleStatement oraStmt = null;
    private Connection wrappedConnection = null;
    private String sqlTemplate;

    public BaseStatement(Connection con) throws SQLException {
        try {
            this.wrappedConnection = con;
            this.stmt = con.createStatement();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public BaseStatement(Connection con, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.wrappedConnection = con;
            this.stmt = con.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public BaseStatement(Connection con, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.wrappedConnection = con;
            this.stmt = con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet rs = null;
        try {
            BaseLogger.log("3", null, null, "BaseStatement sql 71:[" + sql + "]");
            this.stmt.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            rs = this.stmt.executeQuery(sql);
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", sql);
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return rs;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        int updatedRows;
        try {
            BaseLogger.log("3", null, null, "BaseStatement sql 92:[" + sql + "]");
            this.stmt.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            updatedRows = this.stmt.executeUpdate(sql);
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", sql);
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return updatedRows;
    }

    @Override
    public void close() throws SQLException {
        try {
            this.stmt.close();
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "clean", "");
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        int maxFieldSize = -1;
        try {
            maxFieldSize = this.stmt.getMaxFieldSize();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        int maxRows = -1;
        try {
            maxRows = this.stmt.getMaxRows();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        try {
            this.stmt.setMaxRows(max);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            this.stmt.setEscapeProcessing(enable);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        int queryTimeout = -1;
        try {
            queryTimeout = this.stmt.getQueryTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            this.stmt.setQueryTimeout(seconds);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this.stmt.cancel();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sqlWarning = null;
        try {
            sqlWarning = this.stmt.getWarnings();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return sqlWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.stmt.clearWarnings();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        try {
            this.stmt.setCursorName(name);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean isResultset;
        try {
            BaseLogger.log("3", null, null, "BaseStatement sql 272:[" + sql + "]");
            this.stmt.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            isResultset = this.stmt.execute(sql);
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", sql);
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return isResultset;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = this.stmt.getResultSet();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        int updateCount = -1;
        try {
            updateCount = this.stmt.getUpdateCount();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return updateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        boolean isResultset;
        try {
            isResultset = this.stmt.getMoreResults();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return isResultset;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            this.stmt.setFetchDirection(direction);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        int fetchDirection = -1;
        try {
            fetchDirection = this.stmt.getFetchDirection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            this.stmt.setFetchSize(rows);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        int fetchSize = -1;
        try {
            fetchSize = this.stmt.getFetchSize();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        int rsConcurrency = -1;
        try {
            rsConcurrency = this.stmt.getResultSetConcurrency();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return rsConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        int resultSetType = -1;
        try {
            resultSetType = this.stmt.getResultSetType();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return resultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            this.stmt.addBatch(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this.stmt.clearBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] batchCmdArr;
        try {
            batchCmdArr = this.stmt.executeBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return batchCmdArr;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection con = null;
        try {
            con = this.stmt.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return con;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        boolean isResultSet;
        try {
            isResultSet = this.stmt.getMoreResults(current);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return isResultSet;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        ResultSet rs = null;
        try {
            rs = this.stmt.getGeneratedKeys();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return rs;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        int updatedRows = -1;
        try {
            BaseLogger.log("3", null, null, "BaseStatement sql 512:[" + sql + "]");
            this.stmt.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            updatedRows = this.stmt.executeUpdate(sql, autoGeneratedKeys);
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", sql);
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return updatedRows;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        int updatedRows = -1;
        try {
            BaseLogger.log("3", null, null, "BaseStatement sql 532:[" + sql + "]");
            this.stmt.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            updatedRows = this.stmt.executeUpdate(sql, columnIndexes);
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", sql);
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return updatedRows;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        int updatedRows = -1;
        try {
            BaseLogger.log("3", null, null, "BaseStatement sql 553:[" + sql + "]");
            this.stmt.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            updatedRows = this.stmt.executeUpdate(sql, columnNames);
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", sql);
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return updatedRows;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean isResultSet;
        try {
            BaseLogger.log("3", null, null, "BaseStatement sql 574:[" + sql + "]");
            this.stmt.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            isResultSet = this.stmt.execute(sql, autoGeneratedKeys);
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", sql);
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return isResultSet;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean isResultSet;
        try {
            BaseLogger.log("3", null, null, "BaseStatement sql 595:[" + sql + "]");
            this.stmt.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            isResultSet = this.stmt.execute(sql, columnIndexes);
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", sql);
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return isResultSet;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean isResultSet;
        try {
            BaseLogger.log("3", null, null, "BaseStatement sql 616:[" + sql + "]");
            this.stmt.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            isResultSet = this.stmt.execute(sql, columnNames);
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", sql);
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return isResultSet;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        int rsHoldability = -1;
        try {
            this.stmt.getResultSetHoldability();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return rsHoldability;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return 0L;
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return 0L;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return null;
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return 0L;
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0L;
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0L;
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0L;
    }

    private void updateStatementDetails(StackTraceElement[] stackTraceElements, String status, String sql) {
        String className = "";
        String methodName = "";
        int lineNo = 0;
        try {
            String stackTrace = this.getStackTrace(stackTraceElements);
            if (stackTraceElements != null && stackTraceElements.length >= 2) {
                className = stackTraceElements[2].getFileName();
                methodName = stackTraceElements[2].getMethodName();
                lineNo = stackTraceElements[2].getLineNumber();
            }
            StatementMonitor statementMonitor = new StatementMonitor("" + this.stmt.getConnection().hashCode(), "" + this.stmt.hashCode(), "Statement", sql, status, new Date(), new Date(), className, methodName, lineNo, stackTrace);
            statementMonitor.updateStatementMonitorDetails();
            statementMonitor = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in updateStatementDetails BaseStatement:[" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    private String getStackTrace(StackTraceElement[] stackTraceElements) {
        StringBuilder sb = new StringBuilder();
        try {
            if (stackTraceElements != null && stackTraceElements.length >= 4) {
                int i = 1;
                while (i < 4) {
                    sb.append("\n " + stackTraceElements[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in getStackTrace BaseStatement:[" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return sb.toString();
    }

    private String getStackTrace(Exception ex) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] elements = ex.getStackTrace();
        sb.append(String.valueOf(ex.getClass().getSimpleName()) + " : " + ex.getMessage() + "\n");
        StackTraceElement[] stackTraceElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            sb.append("\tat " + element.toString());
            ++n2;
        }
        return sb.toString();
    }
}

