/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.notification.ejb;

import ibase.ejb.E12NotificationLog;
import ibase.scheduler.ejb.BaseRegisteredEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.notification.ejb.NotificationEJBRemote;
import ibase.webitm.notification.ejb.NotificationMessage;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import javax.ejb.Stateless;
import org.json.JSONArray;
import org.json.JSONObject;

@Stateless
public class NotificationEJB
extends BaseRegisteredEJB
implements NotificationEJBRemote {
    @Override
    public String getMessagesXML(String userCode) throws RemoteException, ITMException {
        StringBuffer msgXml;
        block18: {
            msgXml = new StringBuffer("<MESSAGES>");
            Connection connectionObject = null;
            PreparedStatement pstmtDescr = null;
            ResultSet rs = null;
            String sql = "";
            E12GenericUtility genUtil = new E12GenericUtility();
            try {
                try {
                    ConnDriver connDriver = new ConnDriver();
                    connectionObject = connDriver.getConnectDB("Driver");
                    sql = "SELECT DISTINCT(a.MSGID),a.STATUS,b.MESSAGE,b.FROMCODE,b.LOGTIME FROM NOTIFICATION_LOG a,NOTIFICATION_MSG b WHERE a.TOCODE = ? AND a.STATUS = 0 AND a.MSGID = b.MSGID  ORDER BY b.LOGTIME DESC";
                    pstmtDescr = connectionObject.prepareStatement(sql);
                    pstmtDescr.setString(1, userCode);
                    rs = pstmtDescr.executeQuery();
                    while (rs.next()) {
                        msgXml.append("<MESSAGE");
                        msgXml.append(" id='" + rs.getLong(1) + "' ");
                        msgXml.append(" status='" + rs.getInt(2) + "'>");
                        msgXml.append("<FROM>");
                        msgXml.append(rs.getString(4));
                        msgXml.append("</FROM>");
                        msgXml.append("<TEXT>");
                        msgXml.append(rs.getString(3));
                        msgXml.append("</TEXT>");
                        msgXml.append("<TIME>");
                        String dateTime = "";
                        try {
                            Date date = rs.getDate(5);
                            dateTime = genUtil.getValidDateTimeString(date, genUtil.getDispDateTimeFormat());
                        }
                        catch (Exception e) {
                            Date date = rs.getDate(5);
                            dateTime = date.toString();
                            BaseLogger.log("0", null, null, "LOGTIME Date Format error" + e.getMessage());
                        }
                        msgXml.append(dateTime);
                        msgXml.append("</TIME>");
                        msgXml.append("</MESSAGE>");
                    }
                    if (pstmtDescr != null) {
                        pstmtDescr.close();
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception in NotificationEJB  == >");
                    e.printStackTrace();
                    try {
                        if (connectionObject != null && !connectionObject.isClosed()) {
                            connectionObject.close();
                        }
                        break block18;
                    }
                    catch (Exception e2) {
                        BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e2.getMessage());
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (connectionObject != null && !connectionObject.isClosed()) {
                        connectionObject.close();
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e.getMessage());
                }
                throw throwable;
            }
            try {
                if (connectionObject != null && !connectionObject.isClosed()) {
                    connectionObject.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e.getMessage());
            }
        }
        msgXml.append("</MESSAGES>");
        return msgXml.toString();
    }

    @Override
    public String getPermissionsForUser(String userCode) throws RemoteException, ITMException {
        StringBuffer msgXml;
        block18: {
            msgXml = new StringBuffer("<PERMISSIONS>");
            Connection connectionObject = null;
            PreparedStatement pstmtDescr = null;
            ResultSet rs = null;
            String sql = "";
            try {
                try {
                    ConnDriver connDriver = new ConnDriver();
                    connectionObject = connDriver.getConnectDB("Driver");
                    sql = "SELECT GROUPCODE FROM USERGROUPS WHERE USERCODE = ?";
                    pstmtDescr = connectionObject.prepareStatement(sql);
                    pstmtDescr.setString(1, userCode);
                    rs = pstmtDescr.executeQuery();
                    msgXml.append("<SELECTED>");
                    while (rs.next()) {
                        msgXml.append("<GROUP>");
                        msgXml.append(rs.getString("GROUPCODE"));
                        msgXml.append("</GROUP>");
                    }
                    msgXml.append("</SELECTED>");
                    if (pstmtDescr != null) {
                        pstmtDescr.close();
                    }
                    sql = "SELECT DISTINCT(GROUPCODE) FROM GROUPS WHERE GROUPCODE NOT IN (SELECT GROUPCODE FROM USERGROUPS WHERE USERCODE = ?)";
                    pstmtDescr = connectionObject.prepareStatement(sql);
                    pstmtDescr.setString(1, userCode);
                    rs = pstmtDescr.executeQuery();
                    msgXml.append("<UNSELECTED>");
                    while (rs.next()) {
                        msgXml.append("<GROUP>");
                        msgXml.append(rs.getString("GROUPCODE"));
                        msgXml.append("</GROUP>");
                    }
                    msgXml.append("</UNSELECTED>");
                    if (pstmtDescr != null) {
                        pstmtDescr.close();
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception in NotificationEJB  == >");
                    e.printStackTrace();
                    try {
                        if (connectionObject != null && !connectionObject.isClosed()) {
                            connectionObject.close();
                        }
                        break block18;
                    }
                    catch (Exception e2) {
                        BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e2.getMessage());
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (connectionObject != null && !connectionObject.isClosed()) {
                        connectionObject.close();
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e.getMessage());
                }
                throw throwable;
            }
            try {
                if (connectionObject != null && !connectionObject.isClosed()) {
                    connectionObject.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e.getMessage());
            }
        }
        msgXml.append("</PERMISSIONS>");
        return msgXml.toString();
    }

    @Override
    public String addGroup(String groupCode) throws RemoteException, ITMException {
        String msg;
        block17: {
            msg = "";
            Connection connectionObject = null;
            PreparedStatement pstmtDescr = null;
            ResultSet rs = null;
            String sql = "";
            try {
                try {
                    ConnDriver connDriver = new ConnDriver();
                    connectionObject = connDriver.getConnectDB("Driver");
                    sql = "SELECT COUNT(*) FROM GROUPS WHERE GROUPCODE = ?";
                    pstmtDescr = connectionObject.prepareStatement(sql);
                    pstmtDescr.setString(1, groupCode);
                    rs = pstmtDescr.executeQuery();
                    int groupCount = 0;
                    if (rs.next()) {
                        groupCount = rs.getInt(1);
                    }
                    if (pstmtDescr != null) {
                        pstmtDescr.close();
                    }
                    if (groupCount > 0) {
                        msg = "Group Already Exist";
                        break block17;
                    }
                    sql = "INSERT INTO GROUPS(GROUPCODE) VALUES(?)";
                    pstmtDescr = connectionObject.prepareStatement(sql);
                    pstmtDescr.setString(1, groupCode);
                    pstmtDescr.executeUpdate();
                    if (pstmtDescr != null) {
                        pstmtDescr.close();
                    }
                    msg = "SUCCESS";
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception in NotificationEJB  == >");
                    e.printStackTrace();
                    try {
                        if (connectionObject != null && !connectionObject.isClosed()) {
                            connectionObject.close();
                        }
                    }
                    catch (Exception e2) {
                        BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e2.getMessage());
                    }
                }
            }
            finally {
                try {
                    if (connectionObject != null && !connectionObject.isClosed()) {
                        connectionObject.close();
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e.getMessage());
                }
            }
        }
        return msg;
    }

    @Override
    public void updatePermissions(String userId, ArrayList<String> groupNames) throws RemoteException, ITMException {
        Connection connectionObject = null;
        PreparedStatement pstmtDescr = null;
        String sql = "";
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connectionObject = connDriver.getConnectDB("Driver");
                sql = "DELETE FROM USERGROUPS WHERE USERCODE = ?";
                pstmtDescr = connectionObject.prepareStatement(sql);
                pstmtDescr.setString(1, userId);
                pstmtDescr.executeUpdate();
                if (pstmtDescr != null) {
                    pstmtDescr.close();
                }
                if (groupNames != null && groupNames.size() > 0) {
                    sql = "INSERT INTO USERGROUPS(USERCODE,GROUPCODE) VALUES(?,?)";
                    pstmtDescr = connectionObject.prepareStatement(sql);
                    for (String g : groupNames) {
                        pstmtDescr.setString(1, userId);
                        pstmtDescr.setString(2, g);
                        pstmtDescr.executeUpdate();
                    }
                    if (pstmtDescr != null) {
                        pstmtDescr.close();
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in NotificationEJB  == >");
                e.printStackTrace();
                try {
                    if (connectionObject != null && !connectionObject.isClosed()) {
                        connectionObject.close();
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e2.getMessage());
                }
            }
        }
        finally {
            try {
                if (connectionObject != null && !connectionObject.isClosed()) {
                    connectionObject.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e.getMessage());
            }
        }
    }

    @Override
    public String getUsersXML(String loginCode, String userLevel, String searchParam) throws RemoteException, ITMException {
        JSONObject respJSONObj;
        block17: {
            respJSONObj = new JSONObject();
            ResultSet rs = null;
            String sql = "";
            PreparedStatement pstmtDescr = null;
            Connection connectionObject = null;
            try {
                try {
                    BaseLogger.log("3", null, null, "getUsersXml");
                    ConnDriver connDriver = new ConnDriver();
                    connectionObject = connDriver.getConnectDB("Driver");
                    if ("0".equalsIgnoreCase(userLevel) || "1".equalsIgnoreCase(userLevel)) {
                        sql = "SELECT DISTINCT(CODE) AS USERCODE, NAME AS USERNAME FROM USERS WHERE NAME LIKE '%" + searchParam + "%'";
                        pstmtDescr = connectionObject.prepareStatement(sql);
                    } else {
                        sql = " SELECT SALES_PERS.SALES_PERS AS USERCODE, SALES_PERS.SP_NAME AS USERNAME FROM SALES_PERS, EMPLOYEE A, EMPLOYEE B  WHERE A.EMP_CODE=SALES_PERS.SALES_PERS AND  (SALES_PERS.SP_NAME LIKE '%" + searchParam + "%' OR " + " SALES_PERS.SALES_PERS LIKE '%" + searchParam + "%' ) AND " + " '" + searchParam + "' IS NOT NULL AND " + " LENGTH(TRIM('" + searchParam + "')) > 2 AND " + " B.EMP_CODE(+) = A.REPORT_TO START WITH A.EMP_CODE = ? CONNECT BY PRIOR A.EMP_CODE = A.REPORT_TO";
                        pstmtDescr = connectionObject.prepareStatement(sql);
                        pstmtDescr.setString(1, loginCode);
                    }
                    BaseLogger.log("3", null, null, "getUsersXml sql >>" + sql);
                    rs = pstmtDescr.executeQuery();
                    LinkedList<JSONObject> pophelpJSONObj = new LinkedList<JSONObject>();
                    while (rs.next()) {
                        JSONObject detailObj = new JSONObject();
                        String userName = E12GenericUtility.checkNull(rs.getString("USERNAME"));
                        String userCode = E12GenericUtility.checkNull(rs.getString("USERCODE"));
                        detailObj.put("USERNAME", (Object)userName);
                        detailObj.put("USERCODE", (Object)userCode);
                        detailObj.put("label", (Object)(String.valueOf(userName) + "(" + userCode + ")"));
                        pophelpJSONObj.add(detailObj);
                    }
                    JSONArray jsonPophelpArray = new JSONArray(pophelpJSONObj);
                    respJSONObj.put("DETAILS", (Object)jsonPophelpArray);
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception in NotificationEJB  == >" + e.getMessage());
                    e.printStackTrace();
                    try {
                        if (connectionObject != null && !connectionObject.isClosed()) {
                            connectionObject.close();
                        }
                        break block17;
                    }
                    catch (Exception e2) {
                        BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e2.getMessage());
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (connectionObject != null && !connectionObject.isClosed()) {
                        connectionObject.close();
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e.getMessage());
                }
                throw throwable;
            }
            try {
                if (connectionObject != null && !connectionObject.isClosed()) {
                    connectionObject.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e.getMessage());
            }
        }
        BaseLogger.log("2", null, null, "respJSONObj[" + respJSONObj.toString() + "]");
        return respJSONObj.toString();
    }

    @Override
    public List<String> getUsersForGroups(List<String> groupNames) throws RemoteException, ITMException {
        ArrayList<String> users = new ArrayList<String>();
        ResultSet rs = null;
        String sql = "";
        Statement stmt = null;
        Connection connectionObject = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connectionObject = connDriver.getConnectDB("Driver");
                sql = "SELECT DISTINCT(USERCODE) FROM USERGROUPS WHERE GROUPCODE IN (";
                for (String g : groupNames) {
                    sql = String.valueOf(sql) + "'" + g + "',";
                }
                sql = sql.substring(0, sql.length() - 1);
                sql = String.valueOf(sql) + ")";
                BaseLogger.log("3", null, null, "SQL :" + sql);
                stmt = connectionObject.createStatement();
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    users.add(rs.getString(1));
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in NotificationEJB  == >");
                e.printStackTrace();
                try {
                    if (connectionObject != null && !connectionObject.isClosed()) {
                        connectionObject.close();
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e2.getMessage());
                }
            }
        }
        finally {
            try {
                if (connectionObject != null && !connectionObject.isClosed()) {
                    connectionObject.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e.getMessage());
            }
        }
        return users;
    }

    @Override
    public List<String> saveNotificationMessagesForUsers(NotificationMessage message, List<String> usersList, String notificationType) throws RemoteException, ITMException {
        String sql = "";
        String userIdTo = "";
        String sendToId = "";
        String msgText = "";
        String userIdSend = "";
        String xmlData = "";
        Statement pstmtDescr = null;
        Connection connectionObject = null;
        ArrayList<String> userUUIdList = new ArrayList<String>();
        try {
            try {
                BaseLogger.log("3", null, null, "saveNotificationMessagesForUsers :: [" + usersList + "]");
                ConnDriver connDriver = new ConnDriver();
                connectionObject = connDriver.getConnectDB("Driver");
                E12NotificationLog e12NotificationLog = new E12NotificationLog();
                msgText = message.getMessage();
                userIdSend = message.getFromCode();
                long msgId = message.getId();
                int status = message.getStatus();
                sql = "INSERT INTO NOTIFICATION_MSG(MSGID,MESSAGE,FROMCODE,LOGTIME,REF_SER,REF_ID,LINE_NO,MSG_ORIGIN) VALUES(?,?,?,?,?,?,?,?)";
                pstmtDescr = connectionObject.prepareStatement(sql);
                pstmtDescr.setLong(1, message.getId());
                pstmtDescr.setString(2, message.getMessage());
                pstmtDescr.setString(3, message.getFromCode());
                pstmtDescr.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
                pstmtDescr.setString(5, message.getRefSer());
                if (message.getRefId().indexOf(":") > 0) {
                    String refId = message.getRefId().substring(0, message.getRefId().indexOf(":"));
                    BaseLogger.log("3", null, null, "NotificationEJB.saveNotificationMessagesForUsers() refId :: " + refId);
                    pstmtDescr.setString(6, refId);
                } else {
                    pstmtDescr.setString(6, message.getRefId());
                }
                pstmtDescr.setLong(7, message.getLineNo());
                pstmtDescr.setString(8, this.checkNull(message.getMsgOrigin()));
                pstmtDescr.executeUpdate();
                if (pstmtDescr != null) {
                    pstmtDescr.close();
                }
                connectionObject.commit();
                if (usersList != null && usersList.size() > 0) {
                    for (String u : usersList) {
                        String uuId = UUID.randomUUID().toString();
                        int firstIndex = u.indexOf(":");
                        userIdTo = this.checkNull(u.substring(0, firstIndex));
                        sendToId = this.checkNull(u.substring(firstIndex + 1));
                        notificationType = this.checkNull(notificationType);
                        BaseLogger.log("3", null, null, "NotificationEJB notificationType [" + notificationType + "] userIdTo [" + userIdTo + "] sendToId [" + sendToId + "] u [" + u + "]");
                        if (notificationType.equals("approvals")) {
                            notificationType = "A";
                        }
                        if (notificationType != null && notificationType.length() > 0) {
                            xmlData = message.getXmlData();
                            e12NotificationLog.notificationLog(sendToId, notificationType, userIdTo, userIdSend, xmlData, "NotificationEJB", uuId, msgId, status);
                        } else {
                            e12NotificationLog.notificationLog(sendToId, "N", userIdTo, userIdSend, msgText, "NotificationEJB", uuId, msgId, status);
                        }
                        userUUIdList.add(String.valueOf(this.checkNull(u.substring(firstIndex + 1))) + ":" + uuId);
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in NotificationEJB  == >");
                e.printStackTrace();
                try {
                    if (pstmtDescr != null) {
                        pstmtDescr.close();
                    }
                    if (connectionObject != null && !connectionObject.isClosed()) {
                        connectionObject.close();
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e2.getMessage());
                }
            }
        }
        finally {
            try {
                if (pstmtDescr != null) {
                    pstmtDescr.close();
                }
                if (connectionObject != null && !connectionObject.isClosed()) {
                    connectionObject.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e.getMessage());
            }
        }
        return userUUIdList;
    }

    @Override
    public void saveMessagesForUsers(NotificationMessage message, List<String> usersList) throws RemoteException, ITMException {
        String sql = "";
        Statement pstmtDescr = null;
        Connection connectionObject = null;
        try {
            try {
                BaseLogger.log("3", null, null, "saveMessagesForUsers:" + usersList);
                ConnDriver connDriver = new ConnDriver();
                connectionObject = connDriver.getConnectDB("Driver");
                sql = "INSERT INTO NOTIFICATION_MSG(MSGID,MESSAGE,FROMCODE,LOGTIME) VALUES(?,?,?,?)";
                pstmtDescr = connectionObject.prepareStatement(sql);
                pstmtDescr.setLong(1, message.getId());
                pstmtDescr.setString(2, message.getMessage());
                pstmtDescr.setString(3, message.getFromCode());
                pstmtDescr.setTimestamp(4, message.getTime());
                pstmtDescr.executeUpdate();
                if (pstmtDescr != null) {
                    pstmtDescr.close();
                }
                connectionObject.commit();
                if (usersList != null && usersList.size() > 0) {
                    sql = "INSERT INTO NOTIFICATION_LOG(TOCODE,MSGID,STATUS) VALUES (?,?,?)";
                    for (String u : usersList) {
                        pstmtDescr = connectionObject.prepareStatement(sql);
                        pstmtDescr.setString(1, u);
                        pstmtDescr.setLong(2, message.getId());
                        pstmtDescr.setInt(3, message.getStatus());
                        pstmtDescr.executeUpdate();
                        if (pstmtDescr != null) {
                            pstmtDescr.close();
                        }
                        connectionObject.commit();
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in NotificationEJB  == >");
                e.printStackTrace();
                try {
                    if (pstmtDescr != null) {
                        pstmtDescr.close();
                    }
                    if (connectionObject != null && !connectionObject.isClosed()) {
                        connectionObject.close();
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e2.getMessage());
                }
            }
        }
        finally {
            try {
                if (pstmtDescr != null) {
                    pstmtDescr.close();
                }
                if (connectionObject != null && !connectionObject.isClosed()) {
                    connectionObject.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e.getMessage());
            }
        }
    }

    @Override
    public void saveMessagesNotForUsers(NotificationMessage message, List<String> usersList) throws RemoteException, ITMException {
        ResultSet rs = null;
        String sql = "";
        Statement stmt = null;
        Connection connectionObject = null;
        try {
            try {
                BaseLogger.log("3", null, null, "saveMessagesNotForUsers:" + usersList);
                ConnDriver connDriver = new ConnDriver();
                connectionObject = connDriver.getConnectDB("Driver");
                ArrayList<String> notUsersList = new ArrayList<String>();
                if (usersList != null && usersList.size() > 0) {
                    sql = "SELECT DISTINCT(CODE) FROM USERS WHERE CODE NOT IN (";
                    for (String u : usersList) {
                        sql = String.valueOf(sql) + "'" + u + "',";
                    }
                    sql = sql.substring(0, sql.length() - 1);
                    sql = String.valueOf(sql) + ")";
                    BaseLogger.log("3", null, null, "SQL :" + sql);
                } else {
                    sql = "SELECT DISTINCT(CODE) FROM USERS";
                }
                stmt = connectionObject.createStatement();
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    notUsersList.add(rs.getString(1));
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (notUsersList.size() > 0) {
                    this.saveMessagesForUsers(message, notUsersList);
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in NotificationEJB  == >");
                e.printStackTrace();
                try {
                    if (connectionObject != null && !connectionObject.isClosed()) {
                        connectionObject.close();
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e2.getMessage());
                }
            }
        }
        finally {
            try {
                if (connectionObject != null && !connectionObject.isClosed()) {
                    connectionObject.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e.getMessage());
            }
        }
    }

    @Override
    public void updateStatus(String userId, long msgId, int status) throws RemoteException, ITMException {
        Object rs = null;
        String sql = "";
        PreparedStatement pstmtDescr = null;
        Connection connectionObject = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connectionObject = connDriver.getConnectDB("Driver");
                sql = "UPDATE NOTIFICATION_LOG SET STATUS = ? WHERE TOCODE = ? AND MSGID = ?";
                pstmtDescr = connectionObject.prepareStatement(sql);
                pstmtDescr.setInt(1, status);
                pstmtDescr.setString(2, userId);
                pstmtDescr.setLong(3, msgId);
                pstmtDescr.executeUpdate();
                if (pstmtDescr != null) {
                    pstmtDescr.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in NotificationEJB  == >");
                e.printStackTrace();
                try {
                    if (connectionObject != null && !connectionObject.isClosed()) {
                        connectionObject.close();
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e2.getMessage());
                }
            }
        }
        finally {
            try {
                if (connectionObject != null && !connectionObject.isClosed()) {
                    connectionObject.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e.getMessage());
            }
        }
    }

    @Override
    public ArrayList<String> saveMessagesForAllUsers(NotificationMessage dbMessage, String loginCode, String userLevel) {
        ResultSet rs = null;
        String sql = "";
        PreparedStatement pstmtDescr = null;
        Connection connectionObject = null;
        ArrayList<String> usersList = new ArrayList<String>();
        try {
            try {
                BaseLogger.log("3", null, null, "saveMessagesForAllUsers");
                ConnDriver connDriver = new ConnDriver();
                connectionObject = connDriver.getConnectDB("Driver");
                if ("0".equalsIgnoreCase(userLevel) || "1".equalsIgnoreCase(userLevel)) {
                    sql = "SELECT DISTINCT(CODE) AS USERCODE, NAME AS USERNAME FROM USERS";
                    pstmtDescr = connectionObject.prepareStatement(sql);
                } else {
                    sql = " SELECT SALES_PERS.SALES_PERS AS USERCODE, SALES_PERS.SP_NAME AS USERNAME FROM SALES_PERS, EMPLOYEE A, EMPLOYEE B  WHERE A.EMP_CODE=SALES_PERS.SALES_PERS AND  B.EMP_CODE(+) = A.REPORT_TO START WITH A.EMP_CODE = ? CONNECT BY PRIOR A.EMP_CODE = A.REPORT_TO";
                    pstmtDescr = connectionObject.prepareStatement(sql);
                    pstmtDescr.setString(1, loginCode);
                }
                BaseLogger.log("3", null, null, "getUsersXml sql >>" + sql);
                rs = pstmtDescr.executeQuery();
                while (rs.next()) {
                    usersList.add(E12GenericUtility.checkNull(rs.getString("USERCODE")));
                }
                BaseLogger.log("3", null, null, "getUsersXml usersList >>" + usersList);
                this.saveMessagesForUsers(dbMessage, usersList);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in NotificationEJB  == >" + e.getMessage());
                e.printStackTrace();
                try {
                    if (connectionObject != null && !connectionObject.isClosed()) {
                        connectionObject.close();
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e2.getMessage());
                }
            }
        }
        finally {
            try {
                if (connectionObject != null && !connectionObject.isClosed()) {
                    connectionObject.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :NotificationEJB :==>\n" + e.getMessage());
            }
        }
        return usersList;
    }

    @Override
    public ArrayList<String> getRegisteredIdList(String deviceOS, ArrayList<String> userList) throws RemoteException, BaseException {
        ArrayList<String> registeredList = new ArrayList<String>();
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB("Driver");
                StringBuilder sb = new StringBuilder();
                String userIds = "";
                if (userList != null) {
                    for (String userId : userList) {
                        sb.append("'").append(userId.trim()).append("',");
                    }
                    if (userList.size() > 0) {
                        userIds = sb.toString();
                        userIds = userIds.substring(0, userIds.lastIndexOf(","));
                    }
                }
                String sql = " SELECT USER_ID, DEVICE_ID__PUSH FROM USER_DEVICE WHERE DEVICE_OS = ? AND ACTIVE='Y' AND USER_ID IN ( " + userIds + " ) ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, deviceOS);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    BaseLogger.log("3", null, null, "DEVICE_ID__PUSH [" + rs.getString("DEVICE_ID__PUSH") + "]");
                    registeredList.add(rs.getString("DEVICE_ID__PUSH"));
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
            catch (Exception exp) {
                BaseLogger.log("0", null, null, "Excepton in getRegisteredIdList -- >" + exp.getMessage());
                exp.printStackTrace();
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException se) {
                    se.printStackTrace();
                    throw new ITMException(se);
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
                throw new ITMException(se);
            }
        }
        return registeredList;
    }

    @Override
    public String getNotificationLogData(String loginUserId) throws ITMException {
        StringBuffer notificationLogData;
        block21: {
            BaseLogger.log("2", null, null, "======NotificationEJB.java====getNotificationLogData===loginUserId====[" + loginUserId + "]");
            notificationLogData = new StringBuffer("<Root>");
            Statement pStmt = null;
            ResultSet rs = null;
            Connection conn = null;
            ConnDriver connDriver = new ConnDriver();
            try {
                try {
                    conn = connDriver.getConnectDB("Driver");
                    String sqlStr = " SELECT NM.MSGID, NM.MESSAGE, NM.FROMCODE, U.NAME, NL.MSG_TEXT  FROM NOTIFICATION_LOG NL, NOTIFICATION_MSG NM, USERS U  WHERE NM.MSGID = NL.MSGID AND U.CODE=NM.FROMCODE AND NL.STATUS = '0' AND NL.TOCODE = ? ";
                    pStmt = conn.prepareStatement(sqlStr);
                    pStmt.setString(1, loginUserId);
                    rs = pStmt.executeQuery();
                    while (rs.next()) {
                        notificationLogData.append("<Detail>");
                        notificationLogData.append("<msg_id>").append("<![CDATA[" + rs.getString("MSGID") + "]]>").append("</msg_id>");
                        notificationLogData.append("<message>").append("<![CDATA[" + rs.getString("MESSAGE") + "]]>").append("</message>");
                        notificationLogData.append("<from_code>").append("<![CDATA[" + rs.getString("FROMCODE") + "]]>").append("</from_code>");
                        notificationLogData.append("<user_name>").append("<![CDATA[" + rs.getString("NAME") + "]]>").append("</user_name>");
                        notificationLogData.append("<msg_txt>").append("<![CDATA[" + rs.getString("MSG_TEXT") + "]]>").append("</msg_txt>");
                        notificationLogData.append("</Detail>");
                    }
                    notificationLogData.append("</Root>");
                    rs.close();
                    rs = null;
                    pStmt.close();
                    pStmt = null;
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception in getNotificationLogData [" + e.getMessage() + "]");
                    e.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pStmt != null) {
                            pStmt.close();
                            pStmt = null;
                        }
                        if (conn != null && !conn.isClosed()) {
                            conn.close();
                        }
                        break block21;
                    }
                    catch (Exception e2) {
                        BaseLogger.log("0", null, null, "Exception : DBAccessEJB : getSiteCodeDetails()" + e2.getMessage());
                        throw new ITMException(e2);
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    if (conn != null && !conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : DBAccessEJB : getSiteCodeDetails()" + e.getMessage());
                    throw new ITMException(e);
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : DBAccessEJB : getSiteCodeDetails()" + e.getMessage());
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", null, null, "Return from getNotificationLogData [" + notificationLogData.toString() + "]");
        return notificationLogData.toString();
    }

    @Override
    public String updateNotificationLogStatus(String messageIds, String loginUserId) throws ITMException {
        String returnString = "Success";
        boolean updStatus = true;
        Statement pStmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            try {
                BaseLogger.log("3", null, null, "======NotificationEJB.java====updateNotificationLogStatus===messageIds====[" + messageIds + "]");
                ArrayList<String> msgIdAL = new ArrayList<String>();
                String tableName = " NOTIFICATION_LOG ";
                String columnName = " MSGID ";
                String condition = " STATUS = '1' AND TOCODE ='" + loginUserId + "' ";
                ArrayList<String> existMSGIds = this.getDBColumnValues(tableName.trim(), columnName.trim(), condition.trim());
                BaseLogger.log("3", null, null, " existMSGIds[" + existMSGIds + "]");
                StringTokenizer st = new StringTokenizer(messageIds, ",");
                while (st.hasMoreElements()) {
                    String msgId = (String)st.nextElement();
                    msgIdAL.add(msgId);
                }
                msgIdAL.removeAll(existMSGIds);
                BaseLogger.log("3", null, null, " msgIdAL[" + msgIdAL + "]");
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB("Driver");
                String sql = " UPDATE NOTIFICATION_LOG SET STATUS = '1' WHERE MSGID = ? AND TOCODE = ? ";
                pStmt = conn.prepareStatement(sql);
                for (String msgId : msgIdAL) {
                    pStmt.setString(1, msgId);
                    pStmt.setString(2, loginUserId);
                    pStmt.addBatch();
                }
                int[] updatedRecords = pStmt.executeBatch();
                BaseLogger.log("3", null, null, "updatedRecords[" + updatedRecords.length + "]");
                pStmt.close();
                pStmt = null;
            }
            catch (SQLException e) {
                returnString = "Failure";
                updStatus = false;
                BaseLogger.log("0", null, null, "SQLException in updateNotificationLogStatus [" + e.getMessage() + "]");
                e.printStackTrace();
                throw new ITMException(e);
            }
            catch (Exception e) {
                returnString = "Failure";
                updStatus = false;
                BaseLogger.log("0", null, null, "Exception in getNotificationLogData [" + e.getMessage() + "]");
                e.printStackTrace();
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    if (updStatus) {
                        conn.commit();
                    } else {
                        conn.rollback();
                    }
                    if (conn != null && !conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", null, null, "Exception : DBAccessEJB : getSiteCodeDetails()" + e2.getMessage());
                    throw new ITMException(e2);
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (updStatus) {
                    conn.commit();
                } else {
                    conn.rollback();
                }
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : DBAccessEJB : getSiteCodeDetails()" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return returnString;
    }

    public ArrayList<String> getDBColumnValues(String tableName, String columnName, String condition) {
        ArrayList<String> columnValues;
        block21: {
            columnValues = new ArrayList<String>();
            Connection mConnection = null;
            Statement mStmt = null;
            ResultSet rs = null;
            try {
                try {
                    ConnDriver mConnDriver = new ConnDriver();
                    mConnection = mConnDriver.getConnectDB("Driver");
                    String mQuery = " SELECT " + columnName + " FROM " + tableName + " WHERE " + condition;
                    BaseLogger.log("3", null, null, "mQuery [" + mQuery + "]");
                    mStmt = mConnection.createStatement();
                    rs = mStmt.executeQuery(mQuery);
                    while (rs.next()) {
                        columnValues.add(this.checkNull(rs.getString(columnName)));
                    }
                    rs.close();
                    rs = null;
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception :NotificationEJB :getDBColumnValue() :==>\n" + e.getMessage());
                    e.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (mStmt != null) {
                            mStmt.close();
                            mStmt = null;
                        }
                        if (mConnection != null) {
                            mConnection.close();
                            mConnection = null;
                        }
                        break block21;
                    }
                    catch (Exception e2) {
                        System.err.println("Exception :DBAccessEJB :getTransetupColumnValue() :==>finally" + e2.getMessage());
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (mStmt != null) {
                        mStmt.close();
                        mStmt = null;
                    }
                    if (mConnection != null) {
                        mConnection.close();
                        mConnection = null;
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception :DBAccessEJB :getTransetupColumnValue() :==>finally" + e.getMessage());
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (mStmt != null) {
                    mStmt.close();
                    mStmt = null;
                }
                if (mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :DBAccessEJB :getTransetupColumnValue() :==>finally" + e.getMessage());
            }
        }
        BaseLogger.log("2", null, null, String.valueOf(tableName) + "." + columnName + " [" + columnValues + "]");
        return columnValues;
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    @Override
    public String getNotificationLogCounter(String loginUserId) throws ITMException {
        StringBuffer notificationLogCounter;
        block23: {
            BaseLogger.log("2", null, null, "======NotificationEJB.java====getNotificationLogCounter===loginUserId====[" + loginUserId + "]");
            notificationLogCounter = new StringBuffer("<Root>");
            Statement pStmt = null;
            ResultSet rs = null;
            Connection conn = null;
            ConnDriver connDriver = new ConnDriver();
            try {
                try {
                    conn = connDriver.getConnectDB("Driver");
                    ArrayList<String> menuCntList = new ArrayList<String>();
                    String sql = " SELECT DISTINCT NM.MSG_ORIGIN, COUNT(NL.MSGID) AS CNT FROM NOVA.NOTIFICATION_LOG NL,  NOVA.NOTIFICATION_MSG NM WHERE NL.TOCODE = ? AND NM.MSGID = NL.MSGID AND NL.STATUS IN ('0','1')  AND NM.MSG_ORIGIN IS NOT NULL GROUP BY NM.MSG_ORIGIN ";
                    pStmt = conn.prepareStatement(sql);
                    pStmt.setString(1, loginUserId.trim());
                    BaseLogger.log("3", null, null, "Sql getNotificationLogCounter [" + sql + "]");
                    rs = pStmt.executeQuery();
                    while (rs.next()) {
                        String menuCnt = String.valueOf(rs.getString("MSG_ORIGIN")) + ":" + rs.getString("CNT");
                        BaseLogger.log("3", null, null, "getNotificationLogCounter =======menuCnt[" + menuCnt + "]");
                        menuCntList.add(menuCnt);
                    }
                    for (String menuCnt : menuCntList) {
                        notificationLogCounter.append("<MENU>");
                        String[] eachMenuCnt = menuCnt.split(":");
                        notificationLogCounter.append("<MENUNAME>").append("<![CDATA[" + this.getMenuName(this.checkNull(eachMenuCnt[0])) + "]]>").append("</MENUNAME>");
                        notificationLogCounter.append("<MENUCOUNT>").append("<![CDATA[" + this.checkNull(eachMenuCnt[1]) + "]]>").append("</MENUCOUNT>");
                        if ("S".equals(this.checkNull(eachMenuCnt[0])) && !"".equals(this.checkNull(eachMenuCnt[1]))) {
                            notificationLogCounter.append(this.checkNull(this.getCollabGroupCount(loginUserId)));
                        }
                        notificationLogCounter.append("</MENU>");
                    }
                    notificationLogCounter.append("</Root>");
                    rs.close();
                    rs = null;
                    pStmt.close();
                    pStmt = null;
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception in getNotificationLogCounter [" + e.getMessage() + "]");
                    e.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pStmt != null) {
                            pStmt.close();
                            pStmt = null;
                        }
                        if (conn != null && !conn.isClosed()) {
                            conn.close();
                        }
                        break block23;
                    }
                    catch (Exception e2) {
                        BaseLogger.log("0", null, null, "Exception : NotificationEJB : getNotificationLogCounter()" + e2.getMessage());
                        throw new ITMException(e2);
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    if (conn != null && !conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : NotificationEJB : getNotificationLogCounter()" + e.getMessage());
                    throw new ITMException(e);
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : NotificationEJB : getNotificationLogCounter()" + e.getMessage());
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", null, null, "Return from getNotificationLogCounter [" + notificationLogCounter.toString() + "]");
        return notificationLogCounter.toString();
    }

    public String getMenuName(String menuInitial) {
        String menuName = "";
        if ("S".equalsIgnoreCase(menuInitial)) {
            menuName = "SOCIAL";
        } else if ("W".equalsIgnoreCase(menuInitial)) {
            menuName = "WORKFLOW";
        } else if ("T".equalsIgnoreCase(menuInitial)) {
            menuName = "TRANSACTION";
        } else if ("R".equalsIgnoreCase(menuInitial)) {
            menuName = "REPORT";
        }
        return menuName;
    }

    @Override
    public String getCollabGroupCount(String loginUserId) throws ITMException {
        StringBuffer notificationGroupLogCounter;
        block21: {
            Statement pStmt = null;
            ResultSet rs = null;
            Connection conn = null;
            ConnDriver connDriver = new ConnDriver();
            notificationGroupLogCounter = new StringBuffer();
            try {
                try {
                    conn = connDriver.getConnectDB("Driver");
                    String sql = "SELECT DISTINCT CP.GROUP_ID__COLLAB, COUNT (NL.MSGID) AS CNT  FROM NOVA.NOTIFICATION_LOG NL, NOVA.NOTIFICATION_MSG NM, COLLAB_POSTS CP  WHERE NL.TOCODE =? AND STATUS IN ('0','1') AND NM.REF_SER = 'COLPST'  AND NM.MSG_ORIGIN = 'S' AND NM.MSGID = NL.MSGID AND NM.REF_ID = CP.POST_ID  GROUP BY CP.GROUP_ID__COLLAB ";
                    pStmt = conn.prepareStatement(sql);
                    pStmt.setString(1, loginUserId.trim());
                    BaseLogger.log("3", null, null, "Sql getCollabGroupCount [" + sql + "]");
                    rs = pStmt.executeQuery();
                    while (rs.next()) {
                        notificationGroupLogCounter.append("<GROUP>");
                        notificationGroupLogCounter.append("<GROUPNAME>").append("<![CDATA[" + this.checkNull(rs.getString("GROUP_ID__COLLAB")) + "]]>").append("</GROUPNAME>");
                        notificationGroupLogCounter.append("<GROUPCOUNT>").append("<![CDATA[" + this.checkNull(rs.getString("CNT")) + "]]>").append("</GROUPCOUNT>");
                        notificationGroupLogCounter.append("</GROUP>");
                    }
                    rs.close();
                    rs = null;
                    pStmt.close();
                    pStmt = null;
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception in getCollabGroupCount [" + e.getMessage() + "]");
                    e.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pStmt != null) {
                            pStmt.close();
                            pStmt = null;
                        }
                        if (conn != null && !conn.isClosed()) {
                            conn.close();
                        }
                        break block21;
                    }
                    catch (Exception e2) {
                        BaseLogger.log("0", null, null, "Exception : NotificationEJB : getCollabGroupCount()" + e2.getMessage());
                        throw new ITMException(e2);
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    if (conn != null && !conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : NotificationEJB : getCollabGroupCount()" + e.getMessage());
                    throw new ITMException(e);
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : NotificationEJB : getCollabGroupCount()" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return notificationGroupLogCounter.toString();
    }

    @Override
    public void updateNotificationStatus(String openTarget, String group, String loginUserId, String currentStatus, String newStatus) throws ITMException {
        BaseLogger.log("2", null, null, "======NotificationEJB.java====updateNotificationStatus===openTarget[" + openTarget + "]" + "===group[" + group + "]===loginUserId====[" + loginUserId + "]======currentStatus===[" + currentStatus + "]" + "======newStatus===[" + newStatus + "]");
        ArrayList<Object> existMSGIds = new ArrayList();
        String columnName = "";
        String tableName = "";
        String condition = "";
        if (!"".equals(this.checkNull(group))) {
            columnName = " NL.MSGID ";
            tableName = " COLLAB_POSTS CP, NOVA.NOTIFICATION_LOG NL, NOVA.NOTIFICATION_MSG NM ";
            condition = " NM.REF_ID = CP.POST_ID AND NM.MSGID=NL.MSGID AND NL.TOCODE = '" + loginUserId + "' " + " AND CP.GROUP_ID__COLLAB = '" + group + "' AND NL.STATUS in (" + currentStatus + ") ";
        } else {
            columnName = " NL.MSGID ";
            tableName = " NOVA.NOTIFICATION_LOG NL, NOVA.NOTIFICATION_MSG NM ";
            condition = " NM.MSGID=NL.MSGID\tAND NL.TOCODE ='" + loginUserId + "' AND NL.STATUS = (" + currentStatus + ") " + " AND NM.MSG_ORIGIN = '" + openTarget + "' ";
        }
        existMSGIds = this.getDBColumnValues(tableName.trim(), columnName.trim(), condition.trim());
        Statement pStmt = null;
        Connection conn = null;
        ConnDriver connDriver = new ConnDriver();
        try {
            try {
                conn = connDriver.getConnectDB("Driver");
                String sql = "UPDATE NOTIFICATION_LOG SET STATUS = ? WHERE MSGID = ? AND TOCODE = ? ";
                pStmt = conn.prepareStatement(sql);
                for (String string : existMSGIds) {
                    pStmt.setString(1, newStatus);
                    pStmt.setString(2, string);
                    pStmt.setString(3, loginUserId);
                    BaseLogger.log("3", null, null, "Sql updateNotificationStatus [" + sql + "]");
                    pStmt.addBatch();
                }
                int[] nArray = pStmt.executeBatch();
                BaseLogger.log("3", null, null, "modifiedRecords[" + nArray.length + "]");
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in updateNotificationStatus [" + e.getMessage() + "]");
                e.printStackTrace();
                try {
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    if (conn != null && !conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", null, null, "Exception : NotificationEJB : updateNotificationStatus()" + e2.getMessage());
                    throw new ITMException(e2);
                }
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : NotificationEJB : updateNotificationStatus()" + e.getMessage());
                throw new ITMException(e);
            }
        }
    }

    @Override
    public String getImpNotificationLogData(String loginUserId) throws ITMException {
        StringBuffer notificationLogData;
        block21: {
            BaseLogger.log("2", null, null, "======NotificationEJB.java====getNotificationLogData===loginUserId====[" + loginUserId + "]");
            notificationLogData = new StringBuffer("<Root>");
            Statement pStmt = null;
            ResultSet rs = null;
            Connection conn = null;
            ConnDriver connDriver = new ConnDriver();
            try {
                try {
                    conn = connDriver.getConnectDB("Driver");
                    String sqlStr = " SELECT NL.TOCODE, NM.MSGID, NM.MESSAGE, NM.FROMCODE, U.NAME, NL.NOTIFIC_TYPE, NL.MSG_TEXT FROM NOTIFICATION_LOG NL,  NOTIFICATION_MSG NM, USERS U WHERE NM.MSGID = NL.MSGID AND U.CODE = NM.FROMCODE AND NL.STATUS  = '0'  AND NL.NOTIFIC_TYPE = 'I' AND NM.MSG_ORIGIN = 'D' AND NL.TOCODE = ? ";
                    pStmt = conn.prepareStatement(sqlStr);
                    pStmt.setString(1, loginUserId);
                    rs = pStmt.executeQuery();
                    while (rs.next()) {
                        notificationLogData.append("<Detail>");
                        notificationLogData.append("<msg_id>").append("<![CDATA[" + rs.getString("MSGID") + "]]>").append("</msg_id>");
                        notificationLogData.append("<message>").append("<![CDATA[" + rs.getString("MESSAGE") + "]]>").append("</message>");
                        notificationLogData.append("<from_code>").append("<![CDATA[" + rs.getString("FROMCODE") + "]]>").append("</from_code>");
                        notificationLogData.append("<user_name>").append("<![CDATA[" + rs.getString("NAME") + "]]>").append("</user_name>");
                        notificationLogData.append("<msg_txt>").append("<![CDATA[" + rs.getString("MSG_TEXT") + "]]>").append("</msg_txt>");
                        notificationLogData.append("</Detail>");
                    }
                    notificationLogData.append("</Root>");
                    rs.close();
                    rs = null;
                    pStmt.close();
                    pStmt = null;
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception in getNotificationLogData [" + e.getMessage() + "]");
                    e.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pStmt != null) {
                            pStmt.close();
                            pStmt = null;
                        }
                        if (conn != null && !conn.isClosed()) {
                            conn.close();
                        }
                        break block21;
                    }
                    catch (Exception e2) {
                        BaseLogger.log("0", null, null, "Exception : DBAccessEJB : getSiteCodeDetails()" + e2.getMessage());
                        throw new ITMException(e2);
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    if (conn != null && !conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : DBAccessEJB : getSiteCodeDetails()" + e.getMessage());
                    throw new ITMException(e);
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : DBAccessEJB : getSiteCodeDetails()" + e.getMessage());
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", null, null, "Return from getNotificationLogData [" + notificationLogData.toString() + "]");
        return notificationLogData.toString();
    }
}

