/*
 * Decompiled with CFR 0.152.
 */
package ibase.bankIntegration.unsHsbc.servlet;

import ibase.bankIntegration.CommonMethods;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.json.JsonObject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONException;
import org.json.JSONObject;

public class ProcessPaymentServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    UserInfoBean userInfoGlobal = new UserInfoBean();
    E12GenericUtility genericUtility = new E12GenericUtility();

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        BaseLogger.log((String)"3", null, null, (Object)"Inside the ProcessPaymentServlet => ");
        HttpSession session = request.getSession();
        this.userInfoGlobal = (UserInfoBean)session.getAttribute("USER_INFO");
        BaseLogger.log((String)"3", null, null, (Object)("Inside the ProcessPaymentServlet => [" + this.userInfoGlobal + "]"));
        String bankCode = request.getParameter("BANK_CODE");
        BaseLogger.log((String)"3", null, null, (Object)("Inside the ProcessPaymentServlet => bankCode[" + bankCode + "]"));
        response.setContentType("application/json");
        JSONObject jsonResponse = new JSONObject();
        CommonMethods commonMethods = new CommonMethods();
        String uploadFileToSFTPresult = "";
        try {
            uploadFileToSFTPresult = commonMethods.uploadFileToSFTP(bankCode, this.userInfoGlobal);
        }
        catch (ITMException itmE) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in uploadSingleFile. [" + E12GenericUtility.getStackTrace((Exception)((Object)itmE)) + "]"));
        }
        BaseLogger.log((String)"3", null, null, (Object)("Inside the ProcessPaymentServlet => uploadFileToSFTPresult[" + uploadFileToSFTPresult + "]"));
        String logFileName = "";
        String fileName = "";
        if (!uploadFileToSFTPresult.equalsIgnoreCase("No XML files found in the specified directory.")) {
            fileName = uploadFileToSFTPresult.substring(uploadFileToSFTPresult.lastIndexOf(":") + 2);
            System.out.println("Filename: " + fileName);
            DBAccessEJB dbAccessEJB = new DBAccessEJB();
            String payIntArgs = "";
            try {
                payIntArgs = dbAccessEJB.getDBColumnValue("BANK", "PAY_INT_ARGS", "BANK_CODE  = '" + bankCode + "'", this.userInfoGlobal.getTransDB());
            }
            catch (ITMException | RemoteException e1) {
                e1.printStackTrace();
            }
            BaseLogger.log((String)"3", null, null, (Object)("Inside actionHandler generateXML.. payIntArgs[ " + payIntArgs + "]"));
            JsonObject payIntArgsJSON = CommonMethods.parseJsonString(payIntArgs);
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            String localFolderPath = CommonMethods.getValueFromJson(payIntArgsJSON, "bank_specific_folder");
            String logFilePath = String.valueOf(localFolderPath) + File.separator + "Log";
            File logDirectory = new File(logFilePath);
            if (!logDirectory.exists()) {
                logDirectory.mkdirs();
            }
            logFileName = String.valueOf(logFilePath) + File.separator + "logfile_" + timestamp + ".txt";
        } else {
            uploadFileToSFTPresult = "There are no transactions to process.";
        }
        try {
            jsonResponse.put("message", (Object)("Processing result: " + uploadFileToSFTPresult));
            this.logServletCall(request, this.userInfoGlobal, logFileName, fileName);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        PrintWriter out = response.getWriter();
        out.print(jsonResponse.toString());
        out.flush();
    }

    private void logServletCall(HttpServletRequest request, UserInfoBean userInfo, String logFilePath, String consolidatedFileName) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(logFilePath, true));){
                File logFile = new File(logFilePath);
                if (!logFile.exists()) {
                    logFile.createNewFile();
                }
                writer.write(LocalDateTime.now() + " - JSP called from IP:" + request.getRemoteAddr() + " User Code: " + userInfo.getLoginCode() + " Consolidated XML File Name: " + consolidatedFileName + "\n");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

