package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class RetailSchemeClaimPosSave extends ValidatorEJB

{
	public String postSave(String domString, String tranId,String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{
		String errString = " ",errorType = "",userId= "",updateFlag="";
		Document dom = null;
		String errCode = null;
		int count = 0;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		E12GenericUtility genericUtility =new E12GenericUtility();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>"); 
		try
		{
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			int ctr;
			String childNodeName = "";
			String status="";
			String columnValue ="";
			dom = genericUtility.parseString(domString);
			NodeList parentNodeList = dom.getElementsByTagName("Detail1");
			int parentNodeListLength = parentNodeList.getLength();
			for(int parent = 0; parent < parentNodeListLength; parent++)
			{
				Node parentNode = parentNodeList.item(parent);
				NodeList childNodeList = parentNode.getChildNodes();

				int childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{
					Node childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					columnValue = "";
					if( childNode.getFirstChild() != null)
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						
					}
					if(childNodeName.equalsIgnoreCase("wf_status"))
					{
						status = columnValue;
					}
				}
			}
			
			
			NodeList parentNodeListDetail = dom.getElementsByTagName("Detail2");
			if(parentNodeListDetail.getLength() != 0)
			{
				
				for( int i=0; i<parentNodeListDetail.getLength(); i++ )
				{
					Node detailNode = parentNodeListDetail.item(i); 
					if (detailNode.hasAttributes() )
					{
						NodeList detailChildList = detailNode.getChildNodes();
						for (int k = 0; k <detailChildList.getLength(); k++)
						{
							Node childNode = detailChildList.item(k);

							if( "attribute".equalsIgnoreCase(childNode.getNodeName()) )
							{
								if( childNode.hasAttributes() )
								{
									NamedNodeMap attrNodeMap = childNode.getAttributes();
									updateFlag = attrNodeMap.getNamedItem("updateFlag").getNodeValue();
									if(updateFlag.equalsIgnoreCase("D"))
									{
										count++;
									}
								}
							}
						}

					}
				}
			}
			if( status.equalsIgnoreCase("S") && (parentNodeListDetail.getLength() == count))
			{
				errCode = "VCLAMBLNK";
				errList.add(errCode);
				errFields.add(childNodeName.toLowerCase());
			}
		
		int errListSize = errList.size();
		int cnt = 0;
		String errFldName = null;
		if ((errList != null) && (errListSize > 0))
		{
			for (cnt = 0; cnt < errListSize; cnt++)
			{
				errCode = (String) errList.get(cnt);
				errFldName = (String) errFields.get(cnt);
				errString = getErrorString(errFldName, errCode, userId);
				errorType = errorType(conn, errCode);
				if (errString.length() > 0)
				{
					String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
					bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
					errStringXml.append(bifurErrString);
					errString = "";
				}
				if (errorType.equalsIgnoreCase("E"))
				{
					break;
				}
			}
			errStringXml.append("</Errors> </Root> \r\n");
		}
		else
		{
			errStringXml = new StringBuffer("");
		}
	}
	catch (Exception e) {
		e.printStackTrace();
		errString = e.getMessage();
		throw new ITMException(e);
	}
	errString = errStringXml.toString();
	return errString;
	}
	
	private String errorType(Connection conn, String errorCode) throws ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			try {
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return msgType;
	}
	
}
