/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.bean;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.ITMFilterModel;
import ibase.webitm.bean.ITMTransactionModel;
import ibase.webitm.bean.Messages;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.MasterStatefulRemote;
import ibase.webitm.ejb.XSLBuilderEJB;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ITMTransactionCoreModel
extends ITMTransactionModel
implements Serializable {
    public UserInfoBean userInfo = null;
    public String objName = "";
    public int coreModelId = -1;
    public int noOfForms = -1;
    private ArrayList contextTitlesList;
    public String editFlag = "V";
    private ArrayList scanFlagList;
    private ArrayList scanMetadataList;
    private ArrayList autoAcceptScanList;
    private boolean isDetailRepeat = false;
    private boolean isDataFound = true;
    public String pkValues = null;
    public String argFieldValues = null;
    public String chgStr = null;
    public String valXMLStr = null;
    public ITMFilterModel itmFilterModel = null;
    public String user_lang = "en";
    public String user_country = "US";
    public MasterStatefulRemote masterStateful = null;
    private boolean isEditFromWF = false;
    private DBAccessEJB dbAccess = null;
    private ArrayList taxList = null;
    private String editor = "WebEditor";
    private boolean isTransCopied = false;

    public String getEditor() {
        return this.editor;
    }

    public void setEditor(String editor) {
        this.editor = editor;
    }

    public void setIsEditFromWF(boolean isEditFromWorkflow) {
        BaseLogger.log("2", this.userInfo, null, "Amit....setIsEditFromWF --" + isEditFromWorkflow);
        this.isEditFromWF = isEditFromWorkflow;
    }

    public boolean getIsEditFromWF() {
        return this.isEditFromWF;
    }

    public ITMTransactionCoreModel() {
        this(null, null);
    }

    public ITMTransactionCoreModel(String objName) {
        this(objName, null);
    }

    public ITMTransactionCoreModel(String objName, String pkNames) {
        this.objName = objName;
    }

    public void setCoreModelId(int trancoreModelId) {
        try {
            this.coreModelId = trancoreModelId;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setObjName(String objName) throws ITMException {
        try {
            this.objName = objName;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    @Override
    public String getObjName() {
        return this.objName;
    }

    @Override
    public void setUserInfo(UserInfoBean userInfo) throws ITMException {
        try {
            if (userInfo != null) {
                this.userInfo = userInfo;
                if (this.masterStateful == null) {
                    InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
                    this.masterStateful = (MasterStatefulRemote)ctx.lookup("ibase/MasterStatefulEJB/remote");
                    this.masterStateful.setUserInfo(userInfo);
                    this.masterStateful.setCoreModelId(this.coreModelId);
                    this.masterStateful.setEditor(this.getEditor());
                    if (this.isEditFromWF) {
                        this.masterStateful.setTransactionEditforWF(true);
                    }
                }
            } else {
                throw new Exception("Invalid UserInfo");
            }
            this.dbAccess = new DBAccessEJB();
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    @Override
    public UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    @Override
    public void setITMFilterModel(ITMFilterModel itmFilterModel) throws ITMException {
        try {
            this.itmFilterModel = itmFilterModel;
            String transDB = this.userInfo.getTransDB();
            BaseLogger.log("3", this.userInfo, null, "transDB =[" + transDB + "]");
            if (transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0) {
                if (this.itmFilterModel == null) {
                    this.itmFilterModel = new ITMFilterModel(this.objName, this.userInfo);
                }
                this.contextTitlesList = this.masterStateful.getContextTitlesList(this.objName, this.userInfo);
                this.noOfForms = this.contextTitlesList.size();
                this.scanFlagList = this.masterStateful.getScanFlagList(this.objName);
                this.scanMetadataList = this.masterStateful.getScanMetadataList(this.objName);
                this.autoAcceptScanList = this.masterStateful.getAutoAcceptScanList(this.objName);
                this.isDetailRepeat = this.masterStateful.getIsDetailRepeat(this.objName);
                HashMap objDetailMap = this.dbAccess.getObjDetailMap(this.objName, this.userInfo);
                if (objDetailMap != null) {
                    this.taxList = this.getTokenList((String)objDetailMap.get("TAX_FORMS"), ",");
                }
            } else {
                if (this.itmFilterModel == null) {
                    this.itmFilterModel = new ITMFilterModel(this.objName);
                }
                this.contextTitlesList = this.masterStateful.getContextTitlesList(this.objName);
                this.noOfForms = this.contextTitlesList.size();
                this.scanFlagList = this.masterStateful.getScanFlagList(this.objName);
                this.scanMetadataList = this.masterStateful.getScanMetadataList(this.objName);
                this.autoAcceptScanList = this.masterStateful.getAutoAcceptScanList(this.objName);
                this.isDetailRepeat = this.masterStateful.getIsDetailRepeat(this.objName);
                HashMap objDetailMap = this.dbAccess.getObjDetailMap(this.objName, this.userInfo);
                if (objDetailMap != null) {
                    this.taxList = this.getTokenList((String)objDetailMap.get("TAX_FORMS"), ",");
                }
            }
            BaseLogger.log("3", this.userInfo, null, "this.scanFlagList [" + this.scanFlagList + "]");
            BaseLogger.log("3", this.userInfo, null, "this.scanMetadataList [" + this.scanMetadataList + "]");
            BaseLogger.log("3", this.userInfo, null, "this.autoAcceptScanList [" + this.autoAcceptScanList + "]");
        }
        catch (ITMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    @Override
    public ITMFilterModel getITMFilterModel() {
        return this.itmFilterModel;
    }

    @Override
    public void setEditFlag(String editFlag) {
        this.editFlag = editFlag;
    }

    @Override
    public String getEditFlag() {
        return this.editFlag;
    }

    @Override
    public int getNoOfForms() {
        return this.noOfForms;
    }

    public boolean isDataFound() {
        return this.isDataFound;
    }

    public String getContextTitle(int formNo) {
        return (String)this.contextTitlesList.get(formNo - 1);
    }

    public ArrayList getScanFlagList() {
        return this.scanFlagList;
    }

    public ArrayList getScanMetadataList() {
        return this.scanMetadataList;
    }

    public ArrayList getAutoAcceptScanList() {
        return this.autoAcceptScanList;
    }

    public boolean getIsDetailRepeat() {
        return this.isDetailRepeat;
    }

    @Override
    public void setPKValues(String pkValues) {
        if (!"null".equalsIgnoreCase(pkValues) && !"".equals(pkValues) && pkValues != null) {
            this.pkValues = pkValues;
        }
    }

    @Override
    public MasterStatefulRemote getMasterStateful() {
        return this.masterStateful;
    }

    public String getXMLData(String objContext, String editFlag, String pgContext, String requestParamStr) throws ITMException {
        String retXMLStr = null;
        try {
            if (this.userInfo != null) {
                boolean isValid;
                if (this.masterStateful == null) {
                    InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
                    this.masterStateful = (MasterStatefulRemote)ctx.lookup("ibase/MasterStatefulEJB/remote");
                    this.masterStateful.setUserInfo(this.userInfo);
                }
                if (this.isEditFromWF) {
                    this.masterStateful.setTransactionEditforWF(true);
                }
                BaseLogger.log("3", this.userInfo, null, "ITMTransactionCoreModel.getXMLData() Setting TransInfo to MasterStateful pkValues :[" + this.pkValues + "]");
                if (this.itmFilterModel != null) {
                    BaseLogger.log("3", this.userInfo, null, "ITMTransactionCoreModel.getXMLData() this.itmFilterModel is not null this.itmFilterModel.getFormalFilterValuesString():[" + this.itmFilterModel.getFormalFilterValuesString() + "]");
                    this.masterStateful.setTransInfo(this.pkValues, this.itmFilterModel.getFormalFilterValuesString());
                }
                this.masterStateful.setCoreModelId(this.coreModelId);
                this.masterStateful.setEditor(this.getEditor());
                BaseLogger.log("3", this.userInfo, null, "1234567890 from model");
                retXMLStr = this.chgStr != null && this.chgStr.length() > 0 ? this.masterStateful.validateAndPerformAction(this.chgStr, "VAL_DATA") : "";
                boolean bl = isValid = retXMLStr.indexOf("<Errors>") == -1;
                if (isValid) {
                    this.masterStateful.setRequestParamStr(requestParamStr);
                    BaseLogger.log("3", this.userInfo, null, "In ITMTransactionCoreModel this.editFlag[" + this.editFlag + "] pkValues[" + this.pkValues + "] requestParamStr[" + requestParamStr + "]");
                    this.masterStateful.setTransCopy(true);
                    BaseLogger.log("3", this.userInfo, null, "In ITMTransactionCoreModel isTransCopied[" + this.isTransCopied + "]");
                    if ("A".equalsIgnoreCase(this.editFlag) && this.pkValues != null && !this.isTransCopied()) {
                        retXMLStr = this.masterStateful.getTransCopyXMLString(this.objName, objContext, this.pkValues, null, false);
                        this.setTransCopied(true);
                    } else {
                        retXMLStr = this.masterStateful.getDataXML(objContext, "1", editFlag, pgContext);
                    }
                    this.masterStateful.setTransCopy(false);
                }
            } else {
                retXMLStr = Messages.getString("ITMTransactionCoreModel_userInfoNotInSession");
            }
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retXMLStr;
    }

    public String getHTMLData(String objContext, String editFlag, String pgContext, String requestParamStr) throws ITMException, IOException {
        String retHTMLStr = "";
        try {
            String xslFileName = this.getXSLFileName(objContext, editFlag, pgContext);
            String targetDir = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp";
            String xmlData = this.getXMLData(objContext, editFlag, pgContext, requestParamStr);
            if (xmlData != null && xmlData.length() > 0) {
                E12GenericUtility genericUtility = new E12GenericUtility();
                Document dataDom = genericUtility.parseString(xmlData);
                NodeList detailNodeList = dataDom.getElementsByTagName("Detail1");
                if (detailNodeList.item(0) != null) {
                    retHTMLStr = genericUtility.transformToString(xslFileName, xmlData, targetDir, "Output", ".html");
                } else {
                    this.isDataFound = false;
                }
            } else {
                this.isDataFound = false;
            }
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        BaseLogger.log("2", this.userInfo, null, "this.isDataFound " + this.isDataFound);
        return retHTMLStr;
    }

    public String getHTMLData(String objContext, String editFlag, String pgContext, String requestParamStr, String profileIdRes) throws ITMException, IOException, UnsupportedEncodingException {
        String retHTMLStr = "";
        try {
            String xslFileName = this.getXSLFileName(objContext, editFlag, pgContext, profileIdRes);
            String targetDir = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "temp";
            String xmlData = this.getXMLData(objContext, editFlag, pgContext, requestParamStr);
            if (xmlData != null && xmlData.length() > 0) {
                E12GenericUtility genericUtility = new E12GenericUtility();
                Document dataDom = genericUtility.parseString(xmlData);
                NodeList detailNodeList = dataDom.getElementsByTagName("Detail1");
                if (detailNodeList.item(0) != null) {
                    retHTMLStr = genericUtility.transformToString(xslFileName, xmlData, targetDir, "Output", ".html");
                } else {
                    this.isDataFound = false;
                }
            } else {
                this.isDataFound = false;
            }
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        BaseLogger.log("2", this.userInfo, null, "this.isDataFound " + this.isDataFound);
        return retHTMLStr;
    }

    public String getXSLFileName(String objContext, String editFlag, String pgContext) throws ITMException {
        String retFileName = null;
        String transDB = "";
        try {
            String defaultPath = null;
            String fileName = String.valueOf(this.objName) + pgContext + objContext + "_" + this.userInfo.getUserLanguage() + "_" + this.userInfo.getUserCountry() + "_" + editFlag + ".xsl";
            HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
            if (this.userInfo != null) {
                propEditorInfoMap.put("PROFILE_ID_RES", this.userInfo.getProfileIdRes());
                propEditorInfoMap.put("ENTERPRISE_ID_RES", this.userInfo.getEnterprise());
                propEditorInfoMap.put("USER_ID", this.userInfo.getLoginCode());
            }
            propEditorInfoMap.put("EDITOR", this.getEditor());
            defaultPath = new E12GenericUtility().getWebEditorXslPath(propEditorInfoMap, this.userInfo.getTransDB());
            File xslFile = new File(defaultPath, fileName);
            if (xslFile.exists()) {
                retFileName = xslFile.getAbsolutePath();
            } else {
                InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
                XSLBuilderEJB xslBuilderEJB = new XSLBuilderEJB();
                transDB = this.userInfo.getTransDB();
                BaseLogger.log("3", this.userInfo, null, "getXSLFileName1 .transDB...." + transDB);
                String xslString = "";
                xslString = transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0 ? xslBuilderEJB.buildXSLString(this.objName, objContext, this.userInfo.getUserLanguage(), this.userInfo.getUserCountry(), pgContext, editFlag, CommonConstants.APPLICATION_CONTEXT, this.userInfo) : xslBuilderEJB.buildXSLString(this.objName, objContext, this.userInfo.getUserLanguage(), this.userInfo.getUserCountry(), pgContext, editFlag, CommonConstants.APPLICATION_CONTEXT, this.userInfo);
                if (!xslString.endsWith(".xsl")) {
                    byte[] buffer = xslString.getBytes();
                    int bytes = buffer.length;
                    FileOutputStream fos = new FileOutputStream(xslFile);
                    fos.write(buffer, 0, bytes);
                    fos.flush();
                    fos.close();
                    fos = null;
                    retFileName = xslFile.getAbsolutePath();
                } else {
                    retFileName = xslString;
                }
                xslBuilderEJB = null;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retFileName;
    }

    public String getXSLFileName(String objContext, String editFlag, String pgContext, String profileIdRes) throws ITMException {
        String retFileName = null;
        try {
            String defaultPath = null;
            String fileName = String.valueOf(this.objName) + pgContext + objContext + "_" + this.userInfo.getUserLanguage() + "_" + this.userInfo.getUserCountry() + "_" + editFlag + ".xsl";
            HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
            propEditorInfoMap.put("PROFILE_ID_RES", profileIdRes);
            if (this.userInfo != null) {
                propEditorInfoMap.put("ENTERPRISE_ID_RES", this.userInfo.getEnterprise());
                propEditorInfoMap.put("USER_ID", this.userInfo.getLoginCode());
            }
            propEditorInfoMap.put("EDITOR", this.getEditor());
            defaultPath = new E12GenericUtility().getWebEditorXslPath(propEditorInfoMap, this.userInfo.getTransDB());
            File xslFile = new File(defaultPath, fileName);
            if (xslFile.exists()) {
                retFileName = xslFile.getAbsolutePath();
            } else {
                InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
                XSLBuilderEJB xslBuilderEJB = new XSLBuilderEJB();
                String transDB = "";
                String profileId = "";
                if (this.userInfo != null) {
                    transDB = this.userInfo.getTransDB();
                    profileId = this.userInfo.getProfileId();
                }
                String propertyEditorDtl = String.valueOf(profileIdRes) + "~~SEP~~" + this.getEditor();
                String xslString = "";
                BaseLogger.log("3", this.userInfo, null, "getXSLFileName2 .transDB...." + transDB);
                xslString = transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0 ? xslBuilderEJB.buildXSLString(this.objName, objContext, this.userInfo.getUserLanguage(), this.userInfo.getUserCountry(), pgContext, editFlag, CommonConstants.APPLICATION_CONTEXT, propertyEditorDtl, this.userInfo) : xslBuilderEJB.buildXSLString(this.objName, objContext, this.userInfo.getUserLanguage(), this.userInfo.getUserCountry(), pgContext, editFlag, CommonConstants.APPLICATION_CONTEXT, propEditorInfoMap, this.userInfo);
                if (!xslString.endsWith(".xsl")) {
                    byte[] buffer = xslString.getBytes(CommonConstants.ENCODING);
                    int bytes = buffer.length;
                    FileOutputStream fos = new FileOutputStream(xslFile);
                    fos.write(buffer, 0, bytes);
                    fos.flush();
                    fos.close();
                    fos = null;
                    retFileName = xslFile.getAbsolutePath();
                } else {
                    retFileName = xslString;
                }
                xslBuilderEJB = null;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retFileName;
    }

    @Override
    public String toString() {
        return null;
    }

    public void remove() {
        try {
            this.userInfo = null;
            this.objName = null;
            this.contextTitlesList = null;
            this.editFlag = null;
            this.scanFlagList = null;
            this.scanMetadataList = null;
            this.autoAcceptScanList = null;
            this.pkValues = null;
            this.argFieldValues = null;
            this.chgStr = null;
            this.valXMLStr = null;
            this.itmFilterModel = null;
            this.user_lang = null;
            this.user_country = null;
            if (this.masterStateful != null) {
                this.masterStateful.remove();
                this.masterStateful = null;
            }
            if (this.dbAccess != null) {
                this.dbAccess.remove();
                this.dbAccess = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isTaxApplicable(String objContext) {
        boolean isTaxApplicable = false;
        if (this.taxList != null && this.taxList.contains(objContext)) {
            isTaxApplicable = new Boolean(true);
        }
        return isTaxApplicable;
    }

    private ArrayList getTokenList(String tokenString, String delimiter) throws Exception {
        BaseLogger.log("2", this.userInfo, null, "[MasterStatefulEJB]Getting arraylist from the string :" + tokenString + ": delimiter :" + delimiter + ":");
        ArrayList<String> returnList = null;
        if (tokenString != null && tokenString.length() > 0 && tokenString != "") {
            returnList = new ArrayList<String>();
            if (delimiter.length() == 1) {
                while (tokenString.indexOf(delimiter) != -1) {
                    int endIndex = tokenString.indexOf(delimiter);
                    returnList.add(tokenString.substring(0, endIndex));
                    tokenString = tokenString.substring(endIndex + 1, tokenString.length());
                }
                returnList.add(tokenString.substring(0, tokenString.length()));
            } else if (delimiter.length() == 2 && (delimiter.equals("[]") || delimiter.equals("{}") || delimiter.equals("()"))) {
                while (tokenString.indexOf(delimiter.substring(0, 1)) != -1) {
                    int endIndex = tokenString.indexOf(delimiter.substring(1));
                    returnList.add(tokenString.substring(1, endIndex));
                    tokenString = tokenString.substring(endIndex + 1, tokenString.length());
                }
            }
        }
        return returnList;
    }

    public boolean isTransCopied() {
        return this.isTransCopied;
    }

    public void setTransCopied(boolean isTransCopied) {
        this.isTransCopied = isTransCopied;
    }

    public void addDetailDataInCache() {
        if (this.masterStateful != null) {
            this.masterStateful.addDetailDataInCache();
        }
    }
}

