package ibase.webitm.ejb.wsfa.transactions;

import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.TransIDGenerator;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.system.config.ConnDriver;
import java.rmi.RemoteException;
import java.sql.DriverManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.DOMException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.ejb.Stateless;
import javax.ejb.CreateException;
import java.text.SimpleDateFormat;//by bharath - 13/02/09()
import java.util.Vector;

//Modified by Santosh on [14/09/2012][To not allow to process the Stockist if the status is changed from other than Y or N][Start]
import javax.naming.InitialContext;
import ibase.webitm.ejb.*;
import ibase.system.config.*;
//Modified by Santosh on [14/09/2012][To not allow to process the Stockist if the status is changed from other than Y or N][End]


@Stateless
public class SprsStockistStatusChgPrc extends ProcessEJB implements SprsStockistStatusChgPrcLocal,SprsStockistStatusChgPrcRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();

	public String process() throws RemoteException,ITMException
	{
		return "";
	}
	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		Document headerDom = null;
		Document detailDom = null;
		System.out.println("windowName:::::::::::::"+ windowName);
		String  rtrStr ="";
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				//System.out.println("XML String :"+xmlString);
				headerDom = genericUtility.parseString(xmlString); 				
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				//System.out.println("XML String :"+xmlString2);
				detailDom = genericUtility.parseString(xmlString2); 				
			}
			rtrStr = getData(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{
			System.out.println("Exception :SprsStockistStatusChgPrcEJB :getData(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			rtrStr = e.getMessage();
		}
		return rtrStr; 
	}//END OF GETDATA(1)
	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String salesPerson = "";
		String resultString = "";
		String selectSql = "";
		String errString = "";

		int cnt = 0;

		ResultSet rs = null, rs1 = null;
		Statement stmt = null, stmt1 = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		StringBuffer retTabSepStrBuff = new StringBuffer();

		try
		{
			//Commented by vinayak on [11/07/2016] [start]
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");*/
			//Commented by vinayak on [11/07/2016] [end]
			conn = getConnection();//Added by vinayak on [08/07/2016] to get connection.
		}
		catch (Exception e)
		{
			System.out.println("Exception :SprsStockistStatusChgPrcEJB :getData :Connection Creation Error :==>"+e);
		} 
		try
		{
			salesPerson = genericUtility.getColumnValue("sprs_code",headerDom);
			System.out.println("SalesPerson stockistchgprc"+salesPerson);
			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][Start]
			//StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<DocumentRoot>\r\n<description>Datawindow Root</description>\r\n<group0>\r\n<description>Group0 description</description>\r\n<Header0>\r\n<description>Header0 members</description>\r\n");
			StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='UTF-8'?>\r\n<DocumentRoot>\r\n<description>Datawindow Root</description>\r\n<group0>\r\n<description>Group0 description</description>\r\n<Header0>\r\n<description>Header0 members</description>\r\n");
			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][End]
			selectSql = "  SELECT SPRS_STOCKIST.SPRS_CODE,SPRS_STOCKIST.CUST_CODE,SPRS_STOCKIST.STATUS,"
				+" CUSTOMER.CUST_NAME,LOCALITY.DESCR,SPRS_STOCKIST.STATUS STATUS_OLD FROM CUSTOMER,"
				+" SPRS_STOCKIST,LOCALITY WHERE ( CUSTOMER.CUST_CODE = SPRS_STOCKIST.CUST_CODE ) AND "
				+" ( CUSTOMER.LOCALITY_CODE = LOCALITY.LOCALITY_CODE ) AND ( SPRS_STOCKIST.SPRS_CODE = '"+ salesPerson +"' )";
			System.out.println("selectSql :: "+selectSql);
			stmt = conn.createStatement();
			rs = stmt.executeQuery(selectSql);
			int domID = 2;
			while (rs.next())
			{
				/*			
				retTabSepStrBuff.append(rs.getString("SPRS_CODE")).append("\t");
				retTabSepStrBuff.append(rs.getString("CUST_CODE")).append("\t");
				retTabSepStrBuff.append(rs.getString("STATUS")).append("\t");
				retTabSepStrBuff.append(rs.getString("CUST_NAME")).append("\t");
				retTabSepStrBuff.append(rs.getString("DESCR")).append("\t");
				retTabSepStrBuff.append(rs.getString("STATUS_OLD")).append("\t");
				retTabSepStrBuff.append("\n");
				*/
				valueXmlString.append("<Detail2 domID='"+domID+"' >\r\n");
				valueXmlString.append("<attribute updateFlag='N' selected='N' />\r\n");
				valueXmlString.append("<cust_code><![CDATA[").append(checkNull(rs.getString("CUST_CODE"))).append("]]></cust_code>\r\n");
				valueXmlString.append("<cust_name><![CDATA[").append(checkNull(rs.getString("CUST_NAME"))).append("]]></cust_name>\r\n");
				valueXmlString.append("<status><![CDATA[").append(checkNull(rs.getString("STATUS"))).append("]]></status>\r\n");
				valueXmlString.append("<locality_descr><![CDATA[").append(checkNull(rs.getString("DESCR"))).append("]]></locality_descr>\r\n");
				valueXmlString.append("<sprs_code><![CDATA[").append(checkNull(rs.getString("SPRS_CODE"))).append("]]></sprs_code>\r\n");
				valueXmlString.append("<status_old><![CDATA[").append(checkNull(rs.getString("STATUS_OLD"))).append("]]></status_old>\r\n");
				valueXmlString.append("</Detail2>\r\n");	
				domID++;
				
				cnt = cnt + 1;
			}
			rs.close();rs = null;
			stmt.close();stmt = null;
			
			valueXmlString.append("</Header0>\r\n");
			valueXmlString.append("</group0>\r\n");	
			valueXmlString.append("</DocumentRoot>\r\n");
			
			System.out.println("cnt :: "+cnt);
			//System.out.println("retTabSepStrBuff:::::::::::::"+retTabSepStrBuff);
			System.out.println("valueXmlString:::::::::::::"+valueXmlString);
			resultString = valueXmlString.toString();
			//resultString = retTabSepStrBuff.toString();
		}
		catch (SQLException e)
		{
			System.out.println("SQLException :SprsStockistStatusChgPrcEJB :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		catch (Exception e)
		{
			System.out.println("Exception :SprsStockistStatusChgPrcEJB :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Closing Connection..............");
				retTabSepStrBuff = null;
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (stmt != null)
				{
					stmt.close();
					stmt = null;
				}
				if(conn != null)
				{					
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				errString = e.getMessage();
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return resultString;	
	}//END OF GETDATA
	//PROCESS
	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
			String retStr = "";
			Document detailDom = null;
			Document headerDom = null;
			try
			{	
				if(xmlString != null && xmlString.trim().length()!=0)
				{
					headerDom = genericUtility.parseString(xmlString); 
					System.out.println("headerDom" + headerDom);
				}
				if(xmlString2 != null && xmlString2.trim().length()!=0)
				{
					detailDom = genericUtility.parseString(xmlString2); 
					System.out.println("detailDom" + detailDom);
				}
										
			    retStr = process(headerDom, detailDom, windowName, xtraParams);
			}
			catch (Exception e)
			{
				System.out.println("Exception :SprsStockistStatusChgPrcEJB :process(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
				e.printStackTrace();
				retStr = e.getMessage();
			}
			return retStr;
		
	}//END OF PROCESS (1)
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}
	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		//Start changed by bharath - 13/02/09
		String termId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
		System.out.println("termId"+termId);
		String currentDate = null;
		java.sql.Timestamp sysDate = null;
        //End changed by bharath - 13/02/09
		String salesPerson = "";
		String status = "";
		String statusOld = "";
		String custCode = "";
		String custName = "";
		String updateSql = "";
		String selectSql = "";
		String locDescr = "";
		String isSelect = "";
		String localityCode = "";
		String routeID = "";
		String routeStatus = "";

		int shortID = 0;
		int updCnt = 0;
		int updCntSt = 0;
		int cntrCust = 0;
		int msgCntr = 0;
		int noOfSelect = 0;

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		int parentNodeListLength =0;
		int childNodeListLength = 0;
		String childNodeName = "";
		Node parentNode = null;
		Node childNode = null;

		Connection conn = null;
		ResultSet rs = null;
		Statement stmt = null;
		PreparedStatement pstmt = null;
		String errString = "";
		StringBuffer strBuff = new StringBuffer();
		StringBuffer msgBuff = new StringBuffer(); //Gulzar - 05/12/2008
		int msgCtr = 0; //Gulzar - 05/12/2008

		String chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"chgTerm");

		try
		{
			//Commented by vinayak on [11/07/2016] [start]
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");*/
			//Commented by vinayak on [11/07/2016] [end]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			conn.setAutoCommit(false);
            //Start changed by bharath - 13/02/09()
            SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			currentDate = sdf.format(new java.util.Date());
			sysDate = java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(currentDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
            //End changed by bharath - 13/02/09()

			parentNodeList = detailDom.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength(); 
			
			salesPerson = genericUtility.getColumnValue("sprs_code",headerDom);

			selectSql = "SELECT CASE WHEN MAX(SHORT_ID) IS NULL THEN 0 ELSE MAX(SHORT_ID) END "+
						"FROM SPRS_STOCKIST WHERE SPRS_CODE = '"+salesPerson+"' AND STATUS = 'Y' ";
			System.out.println("selectSql:: "+selectSql);
			stmt = conn.createStatement();
			rs = stmt.executeQuery(selectSql);
			if ( rs.next() )
			{
				shortID = rs.getInt(1);
			}
			rs.close();
			stmt.close();
			//strBuff.append("Salese Person :: ["+salesPerson+"] And customers ["); //Gulzar - 05/12/2008
			//Added - Gulzar - 05/12/2008 Req ID : 
			strBuff.append("For the Following Sales Person and Customer The Status is Changed\n"); 
			strBuff.append("Sales Person            Customer\n"); 
			strBuff.append("------------------      ----------------------------------\n"); 
			msgBuff.append("\n\nFor the Following Sales Person and Item The Status is not Changed\n");
			msgBuff.append("Sales Person            Customer\n"); 
			msgBuff.append("------------------      ----------------------------------\n"); 
			//End Added - Gulzar - 05/12/2008 Req ID : 

			//Modified by Santosh on [14/09/2012][To not allow to process the Stockist if the status is changed from other than Y or N][Start]
			//commented by saiprasad G.
			/*InitialContext ctx = getInitialContext();
			ITMDBAccessLocal itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup( "ibase/ITMDBAccessEJB/local" );*/
			ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
			Boolean isErrStringFound = false;
			String chkStatus = null;
			String chkStatusx = null;
			ResultSet rs1 = null;
			Statement stmt1 = null;
			// Modified by Ganesh [24/02/2014] [To does not allow for defined route type inside property table for add psr list and change psr for Doctor] [Start]					
			String [] arrPropValue = null;
			String propValues = "";
			String routeType = "";
			Vector vector = new Vector();
			Boolean isNonCoverageRTypeDefined = false;
			propValues = getAllowedRouteType( salesPerson, conn );
			if (propValues.trim().length() > 0)
			{
				if(propValues.indexOf(',')>0)
				{
					arrPropValue = propValues.split(",");
				}
				else 
				{
					arrPropValue = new String[1];
					arrPropValue[0] = propValues;
				}
				for(int k=0 ; k<arrPropValue.length ; k++)
				{
					vector.add(arrPropValue[k]);
				}
				System.out.println("[SprsStockistStatusChgPrc][process()][Vector::] " +vector);
				isNonCoverageRTypeDefined = true;
			}
			// Modified by Ganesh [24/02/2014] [To does not allow for defined route type inside property table for add psr list and change psr for Doctor][End]
			for (int parentListRow = 0; parentListRow < parentNodeListLength; parentListRow++)
			{
				parentNode = parentNodeList.item(parentListRow);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				chkStatus = "";
				chkStatusx = "";

				for (int childListRow = 0; childListRow < childNodeListLength; childListRow++)
				{
					childNode = childNodeList.item(childListRow);
					childNodeName = childNode.getNodeName();

					if (childNodeName.equals("status"))
					{
						if(childNode.getFirstChild()!=null)
						{
							chkStatus = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("[StrgSerChgStatPrc][process()][chkStatus:::forVal]" +chkStatus);
					}
					if(childNodeName.equals("status_old"))
					{
						if(childNode.getFirstChild()!=null)
							{
								chkStatusx = childNode.getFirstChild().getNodeValue();
							}
							System.out.println("[StrgSerChgStatPrc][process()][status_old:::forVal]" +chkStatusx);
					}
					//Modified by Ganesh on [24/02/2014] [To does not allow for defined route type inside property table for add psr list and change psr for Doctor] [Start]
					if (childNodeName.equals("cust_code"))
					{
						if (childNode.getFirstChild()!=null)
						{
							custCode = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("custCode ::"+custCode);
					}
					//Modified by Ganesh on [24/02/2014] [To does not allow for defined route type inside property table for add psr list and change psr for Doctor] [End]

				}
				if( !chkStatus.equalsIgnoreCase(chkStatusx) )
				{
					//if((chkStatus != null) && (!chkStatus.equalsIgnoreCase("Y") && !chkStatus.equalsIgnoreCase("N")))
					if((!chkStatus.equalsIgnoreCase("Y") && !chkStatus.equalsIgnoreCase("N")))
					{
						isErrStringFound = true;

						//Modified by Ramchandra on[04/10/2012][To change different message id of Status other than Y/N for stockist]
						//errString = itmDBAccessLocal.getErrorString( "status", "YNSTATUS", userId );
						System.out.println("[SprsStockistStatusChgPrc][process()][Invalid Status::]");
						errString = itmDBAccessLocal.getErrorString( "status", "VSTKSTATUS", userId );
						break;
					}
					//Modified by Ganesh on [24/02/2014] [To does not allow for defined route type inside property table for add psr list and change psr for Doctor] [Start]
					else if (chkStatus != null && chkStatus.equalsIgnoreCase("Y"))
					{
						selectSql = "SELECT ROUTE_ID FROM SPRS_STOCKIST WHERE SPRS_CODE = '"+salesPerson+"' AND CUST_CODE = '"+custCode+"' ";
						stmt = conn.createStatement();
						rs = stmt.executeQuery(selectSql);
						System.out.println("selectSql:: "+selectSql);
						if ( rs.next() )
						{															
							routeID = rs.getString("ROUTE_ID");
						}
						if(rs != null)
						{
							rs.close();	
							rs = null;																			
						}
						if(stmt != null)
						{
							stmt.close();
							stmt = null;
						}
						System.out.println("selectSql:: "+selectSql);				
						selectSql =  "SELECT ROUTE_TYPE FROM SPRS_ROUTE WHERE SPRS_CODE = '"+salesPerson+"' AND ROUTE_ID = '"+routeID+"' ";								
						stmt = conn.createStatement();
						rs = stmt.executeQuery(selectSql);
						System.out.println("selectSql:: "+selectSql);
						if ( rs.next() )
						{						
							routeType = rs.getString("ROUTE_TYPE");
						}	
						if(rs != null)
						{
							rs.close();	
							rs = null;																			
						}
						if(stmt != null)
						{
							stmt.close();
							stmt = null;
						}
						System.out.println("Inside isNonCoverageRTypeDefined and routte type is :::"+routeType);				
						if (isNonCoverageRTypeDefined)
						{							
							if(vector.contains(routeType))
							{
								isErrStringFound = true;
								System.out.println("Inside isNonCoverageRTypeDefined in vector");
								//Modified by Aadesh on [26/09/2014][To change msg no as "VPDTROUTE5"][Start]
								System.out.println("message changed in SprsStockistStatusChgPrc deployment");
								//errString = itmDBAccessLocal.getErrorString("status","VPDTROUTE4",userId);
								errString = itmDBAccessLocal.getErrorString("status","VPDTROUTE5",userId);
								System.out.println("message changed in SprsStockistStatusChgPrc deployment");
								//Modified by Aadesh on [26/09/2014][To change msg no as "VPDTROUTE5"][End]
								break;
							}
						}																		
					}
					//Modified by Ganesh on [24/02/2014] [To does not allow for defined route type inside property table for add psr list and change psr for Doctor] [End]
				}
				
				
			}
			if( isErrStringFound == false )//Added if loop
			{
			//Modified by Santosh on [14/09/2012][To not allow to process the Stockist if the status is changed from other than Y or N][End]
 				for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
				{
					parentNode = parentNodeList.item(selectedRow);
					System.out.println("parentNode:::::::::::::: "+ parentNode);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					System.out.println("childNodeListLength::: "+ childNodeListLength);

					for (int childRow = 0; childRow < childNodeListLength; childRow++)
					{
						childNode = childNodeList.item(childRow);
						childNodeName = childNode.getNodeName(); 
						//System.out.println("childNodeName::::::::"+childNodeName);
						if (childNodeName.equals("sprs_code"))
						{
							if(childNode.getFirstChild()!=null)
							{
								salesPerson = childNode.getFirstChild().getNodeValue();
							}
							//System.out.println("salesPerson ::"+salesPerson);
						}
						if (childNodeName.equals("cust_code"))
						{
							if (childNode.getFirstChild()!=null)
							{
								custCode = childNode.getFirstChild().getNodeValue();
							}
							//System.out.println("custCode ::"+custCode);
						}
						if (childNodeName.equals("status")) 
						{
							if (childNode.getFirstChild()!=null)
							{
								if (childNode.getFirstChild().getNodeValue()!=null)
								{
									status = childNode.getFirstChild().getNodeValue();
								}
							}
							//System.out.println("status ::"+status);
						}
						if (childNodeName.equals("status_old"))
						{
							if (childNode.getFirstChild()!=null)
							{
								if (childNode.getFirstChild().getNodeValue()!=null)
								{
									statusOld = childNode.getFirstChild().getNodeValue();
								}
							}
							//System.out.println("statusOld ::"+statusOld);
						}
						if (childNodeName.equals("cust_name"))
						{
							if (childNode.getFirstChild()!=null)
							{
								custName = childNode.getFirstChild().getNodeValue();
							}
							//System.out.println("custName ::"+custName);
						}
						if (childNodeName.equals("locality_descr"))
						{
							if (childNode.getFirstChild()!=null)
							{
								locDescr = childNode.getFirstChild().getNodeValue();
							}
							//System.out.println("locDescr ::"+locDescr);
						}
					}//End Of for (int childRow = 0; childRow < childNodeListLength; childRow++)
					if ( !status.equals(statusOld) )
					{
						if ( status.equals("Y") || status.equals("N") )
						{
							if ( status.equals("Y") )
							{
								selectSql = "SELECT COUNT(*) FROM CUSTOMER WHERE CUST_CODE = '"+ custCode +"' AND BLACK_LISTED = 'Y' ";
								System.out.println("selectSql:: "+selectSql);
								stmt = conn.createStatement();
								rs = stmt.executeQuery(selectSql);
								if ( rs.next() )
								{
									cntrCust = rs.getInt(1);
								}
								rs.close();
								//stmt.close();
								if (cntrCust > 0)
								{							
									System.out.println("Customer is black listed:: " + custCode);
									msgBuff.append(""+salesPerson+"                  " + custCode.trim() + " \n");
									msgCtr++;
									continue;
								}

								//Added - Gulzar - 05/12/2008
								selectSql = "SELECT ROUTE_ID FROM SPRS_STOCKIST WHERE SPRS_CODE = '"+salesPerson+"' AND CUST_CODE = '"+custCode+"' ";
								System.out.println("selectSql:: "+selectSql);
								//stmt = conn.createStatement();
								rs = stmt.executeQuery(selectSql);
								if ( rs.next() )
								{
									routeID = rs.getString("ROUTE_ID");
								}
								rs.close();																
								selectSql =  "SELECT STATUS FROM SPRS_ROUTE WHERE SPRS_CODE = '"+salesPerson+"' AND ROUTE_ID = '"+routeID+"' ";
								rs = stmt.executeQuery(selectSql);
								System.out.println("selectSql:: "+selectSql);
								if ( rs.next() )
								{
									routeStatus = rs.getString("STATUS");
								}
								rs.close();
								stmt.close();
								if ( routeStatus != null && routeStatus.trim().equalsIgnoreCase("N"))
								{
									System.out.println("Root is Inactive in spsr_route :: " + routeStatus);
									msgBuff.append(""+salesPerson+"                  " + custCode.trim() + " \n");
									msgCtr++;
									continue;
								}
								//End Changes - Gulzar - 05/12/2008
								strBuff.append(""+salesPerson+"                  " + custCode.trim() + " \n"); //Gulzar - 05/12/2008
								//shortID++;//Commented by bharath - 13/02/09()

								//Start Commented and changes below by bharath, to Update CHG_DATE,CHG_USER,CHG_TERM- 13/02/09()
								//updateSql = "UPDATE SPRS_STOCKIST SET SHORT_ID = ?  ,  REPLY_STATUS = '0' "+
								//			"WHERE SPRS_CODE = '"+salesPerson+"' AND CUST_CODE = '"+custCode+"' ";
								/*--Commented and code shifted to below by Gulzar - 14/08/10 [WS90SUN049]
								updateSql = "UPDATE SPRS_STOCKIST SET SHORT_ID = ?, CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ?,  REPLY_STATUS = '0' "+
											"WHERE SPRS_CODE = '"+salesPerson+"' AND CUST_CODE = '"+custCode+"' ";
								//End changes by bharath - 13/02/09()

								System.out.println("updateSql:: "+updateSql);
								pstmt = conn.prepareStatement(updateSql);
								pstmt.setInt(1, shortID);
								//Start changed by bharath - 13/02/09()
								pstmt.setTimestamp(2, sysDate);
								pstmt.setString(3, userId);
								pstmt.setString(4, termId);
								//End changed by bharath - 13/02/09()
								updCnt = pstmt.executeUpdate();
								if ( updCnt > 0 )
								{
									System.out.println("Updated into SPRS_STOCKIST Successfully [updCnt] ::"+updCnt);
									conn.commit();
									//strBuff.append(custCode.trim()+","); //Gulzar - 05/12/2008
									msgCntr ++;
								}
								*/
								//End Comment Gulzar - 14/08/10 [WS90SUN049]
							}
							else
							{
								strBuff.append(""+salesPerson+"                  " + custCode.trim() + " \n");//Gulzar - 05/12/2008

								//Start Commented and changes below by bharath, to Update CHG_DATE,CHG_USER,CHG_TERM- 13/02/09()
								//updateSql = "UPDATE SPRS_STOCKIST SET REPLY_STATUS = '0' "+
								//			"WHERE SPRS_CODE = '"+salesPerson+"' AND CUST_CODE = '"+custCode+"' ";
								/*--Commented and code shifted to below by Gulzar - 14/08/10 [WS90SUN049]
								updateSql = "UPDATE SPRS_STOCKIST SET REPLY_STATUS = '0', CHG_DATE = ?, CHG_USER= ?, CHG_TERM = ? "+
										  "WHERE SPRS_CODE = '"+salesPerson+"' AND CUST_CODE = '"+custCode+"' ";
								//End changes by bharath - 13/02/09()

								System.out.println("updateSql:: "+updateSql);
								pstmt = conn.prepareStatement(updateSql);
								//Start changed by bharath - 13/02/09 ()
								pstmt.setTimestamp(1, sysDate);
								pstmt.setString(2, userId);
								pstmt.setString(3, termId);
								//End changed by bharath - 13/02/09 ()
								updCnt = pstmt.executeUpdate();
								if ( updCnt > 0 )
								{
									System.out.println("Updated into SPRS_STOCKIST Successfully [updCnt] ::"+updCnt);
									conn.commit();
									//strBuff.append(custCode.trim()+","); //Gulzar - 05/12/2008
									msgCntr ++;
								}
								*/
								//End Comment Gulzar - 14/08/10 [WS90SUN049]
							}
							//Start Commented and changes below by bharath, to Update CHG_DATE,CHG_USER,CHG_TERM- 13/02/09()
							//updateSql = "UPDATE SPRS_STOCKIST SET STATUS = '"+status+"' "+
							//			"WHERE SPRS_CODE = '"+salesPerson+"' AND CUST_CODE = '"+custCode+"' ";
							//set reply_status = 0 by gulzar - 14/08/10 [WS90SUN049]
							updateSql = "UPDATE SPRS_STOCKIST SET STATUS = '"+status+"', REPLY_STATUS = '0', "+
										"CHG_DATE = ?, CHG_USER= ?, CHG_TERM = ? "+
										"WHERE SPRS_CODE = '"+salesPerson+"' AND CUST_CODE = '"+custCode+"' ";
							//End changes by bharath - 13/02/09()

							System.out.println("updateSql:: "+updateSql);
							pstmt = conn.prepareStatement(updateSql);
							//Start changed by bharath - 13/02/09()
							pstmt.setTimestamp(1, sysDate);
							pstmt.setString(2, userId);
							//pstmt.setString(3, termId);//Gulzar - 14/08/10[WS90SUN049] as terId is updated as 'BASE'
							pstmt.setString(3, termId);//Gulzar - 14/08/10[WS90SUN049]
							//End changed by bharath - 13/02/09()
							updCntSt = pstmt.executeUpdate();
							if ( updCntSt > 0 )
							{
								System.out.println("Updated into SPRS_STOCKIST Successfully [updCnt] ::"+updCntSt);
								conn.commit();
								msgCntr ++;
							}
							pstmt.close();
							pstmt = null;
						}
						else //Added - Gulzar - 13/11/08 - Req ID : 
						{
							msgBuff.append(""+salesPerson+"                  " + custCode.trim() + " \n");
							msgCtr++;
						}
					}
					else
					{
						System.out.println("Same Status................");
						continue;
					}
				}//End Of for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
				//strBuff.append("]"); //Gulzar - 05/12/2008
				if ( msgCtr > 0 ) //Gulzar - 05/12/2008
				{
					strBuff.append(msgBuff);
				}
				if (msgCntr > 0)
				{
					//Added by Ganesh [29/06/2013] [To change message for process][Start]
					//errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"VPROCESS\" type=\"E\" column_name=\"\"><message>Process Done Successfully"+"\n"+"Status is Chnged for "+"</message><description>"+strBuff.toString()+"</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
					errString = itmDBAccessLocal.getErrorString( "status", "VPROCESS", userId );
					//Added by Ganesh [29/06/2013] [To change message for process][End]
				}
				else if( msgCtr > 0 )
				{
					errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"VPROCESS\" type=\"E\" column_name=\"\"><message>Process Not Done </message><description>"+msgBuff.toString()+"</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
				}
				else
				{
					errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"VPROCESS1\" type=\"E\" column_name=\"\"><message>Process Not Done </message><description>No data Found For Process </description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";	
				}
			//Modified by Santosh on [14/09/2012][To not allow to process the Stockist if the status is changed from other than Y or N]
			}// if isErrStringFound
		}//try end	
		catch(SQLException se)
		{
			System.out.println("Exception : SprsStockistStatusChgPrcEJB : process():" +se.getMessage());
			try
			{
				conn.rollback();
			}
			catch(Exception se1){}
			throw new ITMException(se);
		}
		catch(Exception e)
		{
			System.out.println("Exception :SprsStockistStatusChgPrcEJB :process():"+e.getMessage());
			try
			{
				conn.rollback();
			}
			catch(Exception e1){}
			throw new ITMException(e);
		}
		finally
		{
			System.out.println("Closing Connection....");
			try
			{
				if(rs != null)
				{ 
					rs.close();
					rs = null;
				}
				if( stmt != null )
				{ 
					stmt.close();
					stmt = null;
				}
				if(pstmt != null)
				{ 
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				errString = e.getMessage();
				e.printStackTrace();
			}
		}
		System.out.println("errString...:: "+errString);
		return errString;
	}//END OF PROCESS(2)

	//Modified by Santosh on [14/09/2012][To not allow to process the Stockist if the status is changed from other than Y or N][Start]
	protected InitialContext getInitialContext() throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :[StrgSerChgStatPrc][getInitialContext() :==>]");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :[StrgSerChgStatPrc][getInitialContext()  :==>]");
			throw new ITMException(e);
		}
		return ctx;
	}
	//Modified by Santosh on [14/09/2012][To not allow to process the Stockist if the status is changed from other than Y or N][End]
	//Modified by Ganesh on [24/02/2014] [To does not allow for defined route type inside property table for add psr list and change psr for Doctor] [Start]
	private String getAllowedRouteType( String loginEmpCode, Connection conn ) throws ITMException
	{
		Statement cstmt = null;
		ResultSet rst = null;
		String propValue = "";
		String propSql = "";
		Statement cstmt1 = null;
		ResultSet rst1 = null;
		String propSql1 = "";
		Boolean isPropFound = false;
		try
		{		
			propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'SPRSALLOWEDROUTETYPE' AND ITEM_SER = (SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = '"+loginEmpCode+"') "  ;
			cstmt = conn.createStatement();
			rst = cstmt.executeQuery(propSql);	
			System.out.println("[SprsStockistStatusChgPrc] [getAllowedRouteType()][QUERY::] " +propSql);
			if(rst.next())
			{
				propValue = rst.getString("PROP_VALUE");	
				isPropFound = true;
			}
			System.out.println("propValue:::"+propValue);
			if(isPropFound == false)
			{
				propSql1 = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'SPRSALLOWEDROUTETYPE' AND ITEM_SER ='ALL' "  ;
				cstmt1 = conn.createStatement();
				rst1 = cstmt1.executeQuery(propSql1);	
				System.out.println("[SprsStockistStatusChgPrc] [getAllowedRouteType()][QUERY@IF::] " +propSql1);
				if(rst1.next())
				{
					propValue = rst1.getString("PROP_VALUE");	
				}
				System.out.println("[SprsStockistStatusChgPrc] [getAllowedRouteType()][propValue@IF:::] " +propValue);
			}
			
			if (rst != null)
			{
				rst.close();
				rst = null;
			}
			if ( cstmt != null )
			{
				cstmt.close();
				cstmt = null;
			}
			if (rst1 != null)
			{
				rst1.close();
				rst1 = null;
			}
			if ( cstmt1 != null )
			{
				cstmt1.close();
				cstmt1 = null;
			}
			if (propValue == null)
			{
				propValue = "";
			}

		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rst != null)
				{
					rst.close();
					rst = null;
				}
				if ( cstmt != null )
				{
					cstmt.close();
					cstmt = null;
				}
				if (rst1 != null)
				{
					rst1.close();
					rst1 = null;
				}
				if ( cstmt1 != null )
				{
					cstmt1.close();
					cstmt1 = null;
				}
			}
			catch(Exception e1){}
		}
		return propValue;
	}
	//Modified by Ganesh on [24/02/2014] [To does not allow for defined route type inside property table for add psr list and change psr for Doctor] [End]
}//END OF EJB
