/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.DocumentHandlerServiceUtility;
import ibase.webitm.utility.RestAPIServiceUtility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentViewerServiceUtility
extends RestAPIServiceUtility {
    public byte[] getPreviewImage(String objName, String refId, String tokenIDfromHeader) {
        BaseLogger.log("3", null, null, " getPreviewImage method call: ");
        UserInfoBean userInfo = null;
        if (userInfo == null) {
            APIUtility apiUtility = new APIUtility();
            userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
            BaseLogger.log("3", null, null, "USER_INFO created from TOKEN: [" + userInfo + "]");
        }
        DocumentHandlerServiceUtility documentHandlerServiceUtility = new DocumentHandlerServiceUtility();
        String responseData = null;
        String refCol = "";
        String dataFormat = "xml";
        byte[] byteArray = null;
        try {
            responseData = new String(documentHandlerServiceUtility.getDocumentData(objName, refId, refCol, dataFormat, tokenIDfromHeader));
            BaseLogger.log("3", null, null, "responseData ==> " + responseData);
            ArrayList<String> docIds = new ArrayList<String>();
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                InputSource is = new InputSource(new StringReader(responseData));
                Document doc = builder.parse(is);
                NodeList docIdNodes = doc.getElementsByTagName("Document_Id");
                int i = 0;
                while (i < docIdNodes.getLength()) {
                    Node docIdNode = docIdNodes.item(i);
                    if (docIdNode.getNodeType() == 1) {
                        Element docIdElement = (Element)docIdNode;
                        String docId = docIdElement.getTextContent();
                        docIds.add(docId);
                        BaseLogger.log("3", null, null, "DocumentViewerServlet docIDs : [" + docIds + "]");
                    }
                    ++i;
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                BaseLogger.log("3", null, null, "Error parsing XML response: " + e.getMessage());
                e.printStackTrace();
            }
            for (String docId : docIds) {
                try {
                    BaseLogger.log("3", null, null, "DocumentViewerServlet :: docID [" + docId + "]");
                    byteArray = this.getPreviewImageAgainstDocId(docId, userInfo);
                }
                catch (Exception ex) {
                    BaseLogger.log("3", null, null, "Exception in DocumentViewerServlet :: handleDocument() : " + ex);
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Exception :: " + e);
            e.printStackTrace();
        }
        return byteArray;
    }

    private byte[] getPreviewImageAgainstDocId(String docId, UserInfoBean userInfo) {
        BaseLogger.log("3", null, null, "getPreviewImageAgainstDocId Service Called");
        byte[] byteArray = null;
        try {
            BaseLogger.log("3", null, null, "DocumentViewerServlet :: handleDocument() : GET_VIDEO_FRAME : docID [" + docId + "]");
            byteArray = docId == null || "".equals(docId.trim()) ? new byte[1] : ((byteArray = this.getVideoFrame(docId, userInfo)) == null ? new byte[1] : byteArray);
        }
        catch (Exception ex) {
            BaseLogger.log("3", null, null, "Exception in DocumentViewerServlet :: handleDocument() : " + ex);
            ex.printStackTrace();
        }
        BaseLogger.log("3", null, null, "byteArray:: " + byteArray);
        return byteArray;
    }

    private byte[] getVideoFrame(String docId, UserInfoBean userInfo) {
        BaseLogger.log("3", null, null, "getVideoFrame() Called");
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        InputStream inputStream = null;
        byte[] iconByteArray = new byte[1];
        BaseLogger.log("3", null, null, " getVideoFrame method call: ");
        try {
            try {
                String sql = "SELECT ICON FROM DOC_CONTENTS WHERE DOC_ID = " + docId;
                BaseLogger.log("3", userInfo, null, "DocumentViewerServlet :: getVideoFrame() : sql [" + sql + "]");
                String transDB = userInfo.getTransDB();
                conn = new ConnDriver().getConnectDB(transDB);
                st = conn.createStatement();
                rs = st.executeQuery(sql);
                if (rs.next() && (inputStream = rs.getBinaryStream(1)) != null) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int i = 0;
                    while ((i = inputStream.read()) != -1) {
                        byteArrayOutputStream.write(i);
                    }
                    iconByteArray = byteArrayOutputStream.toByteArray();
                }
            }
            catch (Exception ex) {
                BaseLogger.log("3", userInfo, null, "Exception in DocumentViewerServlet :: getVideoFrame() : " + ex);
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (st != null) {
                        st.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (st != null) {
                    st.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
        return iconByteArray;
    }
}

