/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

public class ExcelToCSV {
    public String excelToCSV(File uploadedFile, UserInfoBean userInfo, String extractTempl) throws Exception {
        String responseString = "";
        E12GenericUtility e12GenericUtility = new E12GenericUtility();
        try {
            String xmlPath = E12GenericUtility.checkNull(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + "common" + File.separator + "xml" + File.separator + extractTempl + ".xml");
            BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() schema xmlPath:[" + xmlPath + "] uploadedFile [" + uploadedFile.getName() + "]");
            File schemaFile = new File(xmlPath);
            if (schemaFile.exists()) {
                String xmlData = E12GenericUtility.checkNull(e12GenericUtility.readFile(xmlPath));
                if (xmlData != null) {
                    JSONObject json = XML.toJSONObject((String)xmlData);
                    JSONObject hrmaster = json.getJSONObject("HR_Master");
                    JSONArray jsonColumns = new JSONArray();
                    if (hrmaster.get("COLUMNS") instanceof JSONArray) {
                        jsonColumns = hrmaster.getJSONArray("COLUMNS");
                    } else if (hrmaster.get("COLUMNS") instanceof JSONObject) {
                        jsonColumns.put(hrmaster.get("COLUMNS"));
                    }
                    String dataLakePath = "";
                    if (hrmaster.has("data_lake_path")) {
                        dataLakePath = E12GenericUtility.checkNull(hrmaster.getString("data_lake_path"));
                        BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() dataLakePath:[" + dataLakePath + "]");
                    }
                    if ("".equals(dataLakePath)) {
                        responseString = "DataLakePath is not defined in schema xml file " + xmlPath;
                    } else {
                        FileInputStream fis = new FileInputStream(uploadedFile);
                        XSSFWorkbook workbook = null;
                        String ext = FilenameUtils.getExtension((String)uploadedFile.toString());
                        if (ext.equalsIgnoreCase("xlsx")) {
                            workbook = new XSSFWorkbook((InputStream)fis);
                        } else if (ext.equalsIgnoreCase("xls")) {
                            workbook = new HSSFWorkbook((InputStream)fis);
                        }
                        ExcelToCSV.transpose((Workbook)workbook, true, jsonColumns, dataLakePath, userInfo, FilenameUtils.getBaseName((String)uploadedFile.toString()));
                        responseString = "CSV file successfully created on path " + dataLakePath;
                    }
                } else {
                    responseString = "Schema file is blank on path " + xmlPath;
                }
            } else {
                responseString = "Schema file is not exists on path " + xmlPath;
            }
        }
        catch (Exception ioe) {
            BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() Exception : [" + E12GenericUtility.getStackTrace(ioe) + "]");
            throw ioe;
        }
        BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() responseString : [" + responseString + "]");
        return responseString;
    }

    private static void transpose(Workbook workbook, boolean replaceOriginalSheet, JSONArray jsonColumns, String dataLakePath, UserInfoBean userInfo, String fileName) throws Exception {
        BaseLogger.log("3", userInfo, null, "ExcelToCSV.transpose()");
        int j = 0;
        while (j < jsonColumns.length()) {
            Sheet sheet;
            int startRow = 0;
            int endRow = 0;
            int startColumn = 0;
            int endColumn = 0;
            String transpose = null;
            String tableName = null;
            JSONObject object = jsonColumns.getJSONObject(j);
            if (object.has("TABLE_NAME")) {
                tableName = object.getString("TABLE_NAME");
                BaseLogger.log("3", userInfo, null, "ExcelToCSV.transpose() schema tableName : [" + tableName + "]");
            }
            if ((sheet = workbook.getSheet(tableName)) == null) {
                BaseLogger.log("3", userInfo, null, "ExcelToCSV.transpose() sheet not found against the schema table [" + tableName + "] in uploaded Excel file");
            } else {
                if (object.has("TRASPOSE")) {
                    transpose = object.getString("TRASPOSE");
                    BaseLogger.log("3", userInfo, null, "ExcelToCSV.transpose() transpose : [" + transpose + "]");
                }
                if ("Y".equals(transpose)) {
                    if (object.has("START_ROW")) {
                        startRow = object.getInt("START_ROW");
                        BaseLogger.log("3", userInfo, null, "ExcelToCSV.transpose() startRow : [" + startRow + "]");
                    }
                    if (object.has("END_ROW")) {
                        endRow = object.getInt("END_ROW");
                        BaseLogger.log("3", userInfo, null, "ExcelToCSV.transpose() endRow : [" + endRow + "]");
                    }
                    if (object.has("START_COLUMN")) {
                        startColumn = object.getInt("START_COLUMN");
                        BaseLogger.log("3", userInfo, null, "ExcelToCSV.transpose() startColumn : [" + startColumn + "]");
                    }
                    if (object.has("END_COLUMN")) {
                        endColumn = object.getInt("END_COLUMN");
                        BaseLogger.log("3", userInfo, null, "ExcelToCSV.transpose() endColumn : [" + endColumn + "]");
                    }
                    ArrayList<CellModel> allCells = new ArrayList<CellModel>();
                    int rowNum = startRow;
                    while (rowNum <= endRow) {
                        Row row = sheet.getRow(rowNum);
                        if (row != null) {
                            int columnNum = startColumn;
                            while (columnNum < endColumn) {
                                Cell cell = row.getCell(columnNum);
                                allCells.add(new CellModel(cell));
                                ++columnNum;
                            }
                        }
                        ++rowNum;
                    }
                    String sheetName = sheet.getSheetName();
                    BaseLogger.log("3", userInfo, null, "ExcelToCSV.transpose() sheetName : [" + sheetName + "]");
                    int pos = workbook.getSheetIndex(sheet);
                    workbook.removeSheetAt(pos);
                    Sheet tSheet = workbook.createSheet(sheetName);
                    for (CellModel cm : allCells) {
                        if (cm.isBlank()) continue;
                        int tRow = cm.getColNum();
                        int tColumn = cm.getRowNum();
                        Row row = tSheet.getRow(tRow);
                        if (row == null) {
                            row = tSheet.createRow(tRow);
                        }
                        Cell cell = row.createCell(tColumn);
                        cm.insertInto(cell, userInfo);
                    }
                    BaseLogger.log("3", userInfo, null, "ExcelToCSV.transpose() sheet transpose successfully.");
                    ExcelToCSV.excelToCSV(tSheet, dataLakePath, userInfo, object, fileName, startRow, endRow, startColumn, endColumn);
                } else {
                    ExcelToCSV.excelToCSV(sheet, dataLakePath, userInfo, object, fileName, startRow, endRow, startColumn, endColumn);
                }
            }
            ++j;
        }
    }

    private static void excelToCSV(Sheet sheet, String dataLakePath, UserInfoBean userInfo, JSONObject object, String fileName, int startRow, int endRow, int startColumn, int endColumn) throws IOException, JSONException {
        StringBuffer data = new StringBuffer();
        JSONArray jsonColumn = object.getJSONArray("COLUMN");
        ArrayList<String> setjsonColumn = new ArrayList<String>(jsonColumn.length());
        LinkedHashMap<String, String> sourceColumnMap = new LinkedHashMap<String, String>();
        BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() schema Column length:[" + jsonColumn.length() + "]");
        int i = 0;
        while (i < jsonColumn.length()) {
            JSONObject jsonobject = jsonColumn.getJSONObject(i);
            String columnName = jsonobject.getString("NAME");
            BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() columnName:[" + columnName.toUpperCase() + "]");
            setjsonColumn.add(columnName.toUpperCase());
            if (jsonobject.has("SOURCE_COLUMN") && jsonobject.getString("SOURCE_COLUMN").length() > 0) {
                sourceColumnMap.put(jsonobject.getString("SOURCE_COLUMN").toUpperCase(), columnName.toUpperCase());
                BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() SOURCE_COLUMN:[" + jsonobject.getString("SOURCE_COLUMN").toUpperCase() + "]");
            }
            data.append(String.valueOf(columnName) + ",");
            ++i;
        }
        if (data.length() > 0) {
            data.deleteCharAt(data.length() - 1);
        }
        data.append('\n');
        BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() schema columnMap:[" + setjsonColumn.toString() + "]");
        BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() schema sourceColumnMap:[" + sourceColumnMap.toString() + "]");
        BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() schema columnMap size :[" + setjsonColumn.size() + "]");
        BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() schema sourceColumnMap size :[" + sourceColumnMap.size() + "]");
        BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() sheetName:[" + sheet.getSheetName() + "]");
        BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() heading data:[" + data + "]");
        try {
            int maxNumOfCells = 0;
            LinkedHashMap<Integer, Integer> columnIndexMap = new LinkedHashMap<Integer, Integer>();
            Iterator rowIteratordata = sheet.iterator();
            if (rowIteratordata.hasNext()) {
                Row rowData = (Row)rowIteratordata.next();
                Iterator cellDataIterator = rowData.cellIterator();
                int index = 0;
                while (cellDataIterator.hasNext()) {
                    Cell cellData = (Cell)cellDataIterator.next();
                    String tempCellData = E12GenericUtility.checkNull(cellData.toString()).toUpperCase();
                    BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() heading column name:[" + tempCellData + "]");
                    if (setjsonColumn.contains(tempCellData)) {
                        columnIndexMap.put(setjsonColumn.indexOf(tempCellData), index);
                    } else if (sourceColumnMap.containsKey(tempCellData)) {
                        String columnName = (String)sourceColumnMap.get(tempCellData);
                        columnIndexMap.put(setjsonColumn.indexOf(columnName), index);
                    }
                    ++index;
                }
                maxNumOfCells = index;
            }
            BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() maxNumOfCells :[" + maxNumOfCells + "]");
            BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() columnIndexMap :[" + columnIndexMap + "]");
            BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() columnIndexMap size :[" + columnIndexMap.size() + "]");
            BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() startColumn : [" + startColumn + "]");
            BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() startRow : [" + startRow + "]");
            while (rowIteratordata.hasNext()) {
                Row row = (Row)rowIteratordata.next();
                int j = 0;
                while (j < setjsonColumn.size()) {
                    if (columnIndexMap.containsKey(j)) {
                        Integer cellIndex = (Integer)columnIndexMap.get(j);
                        if (row.getCell((cellIndex = Integer.valueOf(cellIndex + startRow)).intValue()) == null) {
                            data.append(",");
                            BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() " + cellIndex + " index cell is blank");
                        } else {
                            Cell cell = row.getCell(cellIndex.intValue());
                            ExcelToCSV.appendCSVData(data, cell);
                        }
                    } else {
                        BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() " + j + " index not present in map");
                        data.append(",");
                    }
                    ++j;
                }
                if (data.length() > 0) {
                    data.deleteCharAt(data.length() - 1);
                }
                data.append('\n');
            }
            if (data.length() > 0) {
                data.deleteCharAt(data.length() - 1);
            }
            BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() data:[" + data + "]");
            dataLakePath = String.valueOf(dataLakePath) + File.separator + sheet.getSheetName();
            File datalakepath = new File(dataLakePath);
            if (!datalakepath.exists()) {
                datalakepath.mkdirs();
            }
            String outputFilePath = String.valueOf(dataLakePath) + File.separator + fileName + ".csv";
            BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() CSV File Path :[" + outputFilePath + "]");
            File outputFile = new File(outputFilePath);
            FileOutputStream fos = new FileOutputStream(outputFile);
            fos.write(data.toString().getBytes());
            fos.close();
            datalakepath = null;
            outputFile = null;
            BaseLogger.log("3", userInfo, null, "ExcelToCSV.excelToCSV() CSV file created successfully on path : [" + outputFilePath + "]");
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            throw ioe;
        }
    }

    private static StringBuffer appendCSVData(StringBuffer data, Cell cell) {
        BaseLogger.log("3", null, null, "ExcelToCSV.appendCSVData() cell :[" + cell.toString() + "]");
        BaseLogger.log("3", null, null, "ExcelToCSV.appendCSVData() cell.getCellType() :[" + cell.getCellType() + "]");
        block0 : switch (cell.getCellType()) {
            case BOOLEAN: {
                data.append(String.valueOf(cell.getBooleanCellValue()) + ",");
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
                    data.append(String.valueOf(dateFormat.format(cell.getDateCellValue())) + ",");
                    break;
                }
                data.append(String.valueOf(cell.getNumericCellValue()) + ",");
                break;
            }
            case STRING: {
                data.append(String.valueOf(cell.getStringCellValue()) + ",");
                break;
            }
            case BLANK: {
                data.append(",");
                break;
            }
            case FORMULA: {
                switch (cell.getCachedFormulaResultType()) {
                    case BOOLEAN: {
                        data.append(String.valueOf(cell.getBooleanCellValue()) + ",");
                        break block0;
                    }
                    case NUMERIC: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
                            data.append(String.valueOf(dateFormat.format(cell.getDateCellValue())) + ",");
                            break block0;
                        }
                        data.append(String.valueOf(cell.getNumericCellValue()) + ",");
                        break block0;
                    }
                    case STRING: {
                        data.append(String.valueOf(cell.getStringCellValue()) + ",");
                        break block0;
                    }
                }
                break;
            }
            case ERROR: {
                data.append(String.valueOf(cell.getErrorCellValue()) + ",");
                break;
            }
            default: {
                data.append(cell + ",");
            }
        }
        BaseLogger.log("3", null, null, "ExcelToCSV.appendCSVData() data :[" + data.toString() + "]");
        return data;
    }

    static class CellModel {
        private int rowNum = -1;
        private int colNum = -1;
        private CellStyle cellStyle;
        private CellType cellType;
        private Object cellValue;
        private String cellFormula;

        public CellModel(Cell cell) {
            if (cell != null) {
                this.rowNum = cell.getRowIndex();
                this.colNum = cell.getColumnIndex();
                this.cellStyle = cell.getCellStyle();
                this.cellType = cell.getCellType();
                BaseLogger.log("3", null, null, "ExcelToCSV.CellModel() getColumnIndex : [" + cell.getColumnIndex() + "]");
                BaseLogger.log("3", null, null, "ExcelToCSV.CellModel() getRowIndex : [" + cell.getRowIndex() + "]");
                BaseLogger.log("3", null, null, "ExcelToCSV.CellModel() getCellStyle : [" + cell.getCellStyle() + "]");
                BaseLogger.log("3", null, null, "ExcelToCSV.CellModel() getCellType : [" + cell.getCellType() + "]");
                block0 : switch (this.cellType) {
                    case BLANK: {
                        break;
                    }
                    case BOOLEAN: {
                        this.cellValue = cell.getBooleanCellValue();
                        break;
                    }
                    case ERROR: {
                        this.cellValue = cell.getErrorCellValue();
                        break;
                    }
                    case FORMULA: {
                        this.cellFormula = cell.getCellFormula();
                        BaseLogger.log("3", null, null, "ExcelToCSV.CellModel() cellFormula : [" + this.cellFormula + "]");
                        switch (cell.getCachedFormulaResultType()) {
                            case BOOLEAN: {
                                this.cellValue = cell.getBooleanCellValue();
                                break block0;
                            }
                            case NUMERIC: {
                                this.cellValue = cell.getNumericCellValue();
                                break block0;
                            }
                            case STRING: {
                                this.cellValue = cell.getStringCellValue();
                                break block0;
                            }
                        }
                        break;
                    }
                    case NUMERIC: {
                        this.cellValue = cell.getNumericCellValue();
                        break;
                    }
                    case STRING: {
                        this.cellValue = cell.getRichStringCellValue();
                        break;
                    }
                }
            }
        }

        public void insertInto(Cell cell, UserInfoBean userInfo) {
            if (this.isBlank()) {
                return;
            }
            cell.setCellStyle(this.cellStyle);
            BaseLogger.log("3", userInfo, null, "ExcelToCSV.CellModel.insertInto() this.cellType:[" + this.cellType + "]");
            BaseLogger.log("3", userInfo, null, "ExcelToCSV.CellModel.insertInto() this.cellValue:[" + this.cellValue + "]");
            if (this.cellType == CellType.FORMULA) {
                BaseLogger.log("3", userInfo, null, "ExcelToCSV.CellModel.insertInto() this.cellFormula:[" + this.cellFormula + "] cell.getCellType() [" + cell.getCellType() + "]");
                cell.setCellFormula(this.cellFormula);
                this.cellType = cell.getCellType();
            }
            block0 : switch (this.cellType) {
                case BLANK: {
                    break;
                }
                case BOOLEAN: {
                    if (this.cellValue == null) break;
                    cell.setCellValue(((Boolean)this.cellValue).booleanValue());
                    break;
                }
                case ERROR: {
                    if (this.cellValue == null) break;
                    cell.setCellErrorValue(((Byte)this.cellValue).byteValue());
                    break;
                }
                case FORMULA: {
                    BaseLogger.log("3", userInfo, null, "ExcelToCSV.CellModel.insertInto() cell.getCellFormula():[" + cell.getCellFormula() + "]");
                    switch (cell.getCachedFormulaResultType()) {
                        case BOOLEAN: {
                            if (this.cellValue == null) break block0;
                            cell.setCellValue(((Boolean)this.cellValue).booleanValue());
                            break block0;
                        }
                        case NUMERIC: {
                            if (this.cellValue == null) break block0;
                            cell.setCellValue(((Double)this.cellValue).doubleValue());
                            break block0;
                        }
                        case STRING: {
                            if (this.cellValue == null) break block0;
                            cell.setCellValue((RichTextString)this.cellValue);
                            break block0;
                        }
                    }
                    break;
                }
                case NUMERIC: {
                    if (this.cellValue == null) break;
                    cell.setCellValue(((Double)this.cellValue).doubleValue());
                    break;
                }
                case STRING: {
                    if (this.cellValue == null) break;
                    cell.setCellValue((RichTextString)this.cellValue);
                    break;
                }
            }
        }

        public boolean isBlank() {
            return this.cellType == CellType.BLANK && this.rowNum == -1 && this.colNum == -1;
        }

        public CellStyle getCellStyle() {
            return this.cellStyle;
        }

        public CellType getCellType() {
            return this.cellType;
        }

        public Object getCellValue() {
            return this.cellValue;
        }

        public int getRowNum() {
            return this.rowNum;
        }

        public int getColNum() {
            return this.colNum;
        }
    }
}

