/*
 * Decompiled with CFR 0.152.
 */
package ibase.planner.servlet;

import ibase.planner.ejb.PlannerEJB;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import ibase.wrkflw.E12FollowUpActionEJB;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Node;

public class PlannerProcessServlet
extends HttpServlet {
    ServletContext servletContext = null;
    ServletConfig servletConfig = null;
    private String mesg = "Error";

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        this.servletContext = servletConfig.getServletContext();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String retVal = null;
        BaseLogger.log("2", null, null, "******************PlannerProcessServlet Called**************");
        try {
            HttpSession session = request.getSession();
            UserInfoBean userInfo = (UserInfoBean)session.getAttribute("USER_INFO");
            if (userInfo != null) {
                String loginEmpCode = userInfo.getLoginCode();
                String loginCode = this.checkNull(this.getEmpCode(loginEmpCode, userInfo));
                String period = request.getParameter("Period");
                String planFrequency = request.getParameter("TARGET_VIEW");
                String SelectedDate = request.getParameter("SELECTED_DATE");
                String action = this.checkNull(request.getParameter("ACTION"));
                BaseLogger.log("3", null, null, "-----Suraj--Planner Process Servlet ----[" + planFrequency + "]");
                String forceSave = request.getParameter("FORCESAVE");
                BaseLogger.log("3", null, null, "-----Suraj--Planner Process Servlet ----[" + planFrequency + "]---[" + SelectedDate + "]---action---[" + action + "]--forceSave--[" + forceSave + "]");
                String xtraParams = this.getXtraParameter(userInfo);
                PlannerEJB plannerRemote = new PlannerEJB();
                HashMap paramMap = this.getParamMap(request);
                retVal = plannerRemote.validatePlan(loginCode, period, xtraParams, paramMap, SelectedDate, planFrequency, action, forceSave, userInfo);
                String tranID = "";
                String workflow = "";
                String loginEmpId = userInfo.getLoginCode();
                String userId = this.checkNull(this.getEmpCode(loginEmpId, userInfo));
                String planRetVal = retVal;
                String messageId = "";
                if (planRetVal.indexOf("<status>SUCCESS</status>") != -1) {
                    Node tranIdNode = new E12GenericUtility().parseString(planRetVal).getElementsByTagName("TranID").item(0);
                    Node workflowNode = new E12GenericUtility().parseString(planRetVal).getElementsByTagName("workflow").item(0);
                    Node messageIdNode = new E12GenericUtility().parseString(planRetVal).getElementsByTagName("messageid").item(0);
                    if (tranIdNode != null && tranIdNode.getFirstChild() != null) {
                        tranID = this.checkNull(tranIdNode.getFirstChild().getNodeValue());
                    }
                    if (workflowNode != null && workflowNode.getFirstChild() != null) {
                        workflow = this.checkNull(workflowNode.getFirstChild().getNodeValue());
                    }
                    if (messageIdNode != null && messageIdNode.getFirstChild() != null) {
                        messageId = this.checkNull(messageIdNode.getFirstChild().getNodeValue());
                    }
                    retVal = this.getErrorMessage(messageId, userInfo);
                    BaseLogger.log("3", null, null, "tranID - [" + tranID + "]");
                    if ("Y".equalsIgnoreCase(workflow) && tranID.trim().length() > 0) {
                        this.addFollowUpAction(userId, tranID, tranID, "sprs_plan_aprv", userInfo);
                    }
                }
                BaseLogger.log("3", null, null, "retVal => " + retVal);
                response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
                response.setHeader("Cache-Control", "no-cache");
                response.getWriter().write(retVal);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : ==>" + e.toString());
            e.printStackTrace();
        }
    }

    private HashMap getParamMap(HttpServletRequest request) {
        HashMap paramMap = null;
        HttpSession session = request.getSession();
        if (session.getAttribute("PARAM_MAP") != null) {
            paramMap = (HashMap)session.getAttribute("PARAM_MAP");
        }
        return paramMap;
    }

    public String getXtraParameter(UserInfoBean userInfo) {
        String XTRA_PARAMS_SEPARATOR = "~~";
        StringBuffer xtraParamsBuff = new StringBuffer();
        xtraParamsBuff.append("loginCode=" + userInfo.getLoginCode());
        xtraParamsBuff.append("~~").append("loginEmpCode=" + userInfo.getEmpCode());
        xtraParamsBuff.append("~~").append("loginSiteCode=" + userInfo.getSiteCode());
        xtraParamsBuff.append("~~").append("entityCode=" + userInfo.getEntityCode());
        xtraParamsBuff.append("~~").append("profileId=" + userInfo.getProfileId());
        xtraParamsBuff.append("~~").append("userType=" + userInfo.getUserType());
        xtraParamsBuff.append("~~").append("termId=" + userInfo.getRemoteHost());
        xtraParamsBuff.append("~~").append("chgTerm=" + userInfo.getRemoteHost());
        return xtraParamsBuff.toString();
    }

    private String checkNull(String input) {
        if (input == null) {
            input = "";
        }
        return input;
    }

    private void addFollowUpAction(String userId, String editorId, String tranId, String objName, UserInfoBean userInfo) {
        try {
            String pendingWrkflwMapKey = String.valueOf(userId) + "~" + editorId;
            String pendingWrkflwMapValue = String.valueOf(objName) + "~" + tranId;
            Map<String, String> pendingWrkflwMap = new HashMap();
            if (this.servletContext.getAttribute("pendingWrkflwMap") != null) {
                pendingWrkflwMap = (Map)this.servletContext.getAttribute("pendingWrkflwMap");
                if (pendingWrkflwMap != null) {
                    pendingWrkflwMap.put(pendingWrkflwMapKey, pendingWrkflwMapValue);
                }
                AppConnectParm appConnect = new AppConnectParm();
                InitialContext ctx = new InitialContext(appConnect.getProperty());
                E12FollowUpActionEJB followUpActionEJB = new E12FollowUpActionEJB();
                followUpActionEJB.followUpAction(pendingWrkflwMapKey, this.servletContext, userInfo);
            }
            BaseLogger.log("3", null, null, "pendingWrkflwMap - " + this.servletContext.getAttribute("pendingWrkflwMap"));
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception - " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String getErrorMessage(String mesgID, UserInfoBean userInfo) {
        Statement stmt = null;
        ResultSet rs = null;
        String message = "";
        Connection conn = null;
        try {
            try {
                if (userInfo != null && userInfo.getTransDB() != null) {
                    String transDB = E12GenericUtility.checkNull(userInfo.getTransDB());
                    ConnDriver connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(transDB);
                }
                stmt = conn.createStatement();
                String sql = "SELECT MSG_DESCR FROM MESSAGES WHERE MSG_NO = '" + mesgID + "'";
                BaseLogger.log("3", userInfo, null, "Sql : " + sql);
                rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    message = rs.getString("MSG_DESCR");
                }
                rs.close();
                stmt.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.commit();
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.commit();
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return message;
    }

    public String getEmpCode(String userId, UserInfoBean userInfo) throws ITMException {
        String empCode = "";
        String entityCode = "";
        boolean isLocalConn = false;
        PreparedStatement pstmtSelect = null;
        ResultSet resultSelect = null;
        Connection conn = null;
        try {
            try {
                if (userInfo != null && userInfo.getTransDB() != null) {
                    String transDB = E12GenericUtility.checkNull(userInfo.getTransDB());
                    ConnDriver connDriver = new ConnDriver();
                    System.out.println("transDB::" + transDB);
                    conn = connDriver.getConnectDB(transDB);
                }
                String selectMsgDescrSql = "SELECT EMP_CODE,ENTITY_CODE FROM USERS WHERE CODE= ? ";
                pstmtSelect = conn.prepareStatement(selectMsgDescrSql);
                pstmtSelect.setString(1, userId);
                resultSelect = pstmtSelect.executeQuery();
                if (resultSelect.next()) {
                    empCode = this.checkNull(resultSelect.getString("EMP_CODE"));
                    entityCode = this.checkNull(resultSelect.getString("ENTITY_CODE"));
                }
                if (resultSelect != null) {
                    resultSelect.close();
                    resultSelect = null;
                }
                if (pstmtSelect != null) {
                    pstmtSelect.close();
                    pstmtSelect = null;
                }
                if (empCode == null || empCode.trim().length() == 0) {
                    empCode = entityCode;
                }
            }
            catch (Exception e) {
                System.out.println("Exception :SprsPlanBifurGWTIC:getEmpCode():==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (resultSelect != null) {
                    resultSelect.close();
                    resultSelect = null;
                }
                if (pstmtSelect != null) {
                    pstmtSelect.close();
                    pstmtSelect = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        return empCode;
    }
}

