/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.scheduler.ejb.BaseRegisteredEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.SearchHistoryLocal;
import ibase.webitm.ejb.SearchHistoryRemote;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import javax.ejb.Stateless;

@Stateless
public class SearchHistoryEJB
extends BaseRegisteredEJB
implements SearchHistoryRemote,
SearchHistoryLocal {
    @Override
    public String saveSearchHistory(String objName, String userId, String searchString, String searchContext, UserInfoBean userInfo) throws RemoteException, ITMException {
        String retString = "";
        Connection conn = null;
        ConnDriver mConnDriver = null;
        Statement mPstmt = null;
        String transDB = "";
        try {
            try {
                mConnDriver = new ConnDriver();
                transDB = userInfo.getTransDB();
                conn = mConnDriver.getConnectDB(transDB);
                BaseLogger.log("3", userInfo, null, "Before insert into search_histoy...");
                String insertQry = "INSERT INTO SEARCH_HISTORY(OBJ_NAME,SEARCH_CONTEXT,USER_ID,SEARCH_STRING,DATE_TIME) VALUES(?, ?, ?, ?, ?)";
                mPstmt = conn.prepareStatement(insertQry);
                mPstmt.setString(1, objName);
                mPstmt.setString(2, searchContext);
                mPstmt.setString(3, userId);
                mPstmt.setString(4, searchString);
                mPstmt.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
                int noOfRows = mPstmt.executeUpdate();
                mPstmt.close();
                mPstmt = null;
                conn.commit();
                BaseLogger.log("3", userInfo, null, "Inserted new search into search_histoy sucessfully..." + noOfRows);
                retString = "<Root><Detail>Success</Detail></Root>";
            }
            catch (SQLException ie) {
                BaseLogger.log("0", userInfo, null, "SQLException :SearchHistoryEJB :saveSearchHistory:==>" + ie);
                ie.printStackTrace();
                throw new ITMException(ie);
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :SearchHistoryEJB :saveSearchHistory :==>" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (mPstmt != null) {
                        mPstmt.close();
                        mPstmt = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return retString;
    }

    @Override
    public void saveSearchTop() throws RemoteException, ITMException {
        Connection conn = null;
        ConnDriver mConnDriver = null;
        Statement stmt = null;
        ResultSet rs = null;
        Statement insertPstmt = null;
        try {
            try {
                mConnDriver = new ConnDriver();
                conn = mConnDriver.getConnectDB("Driver");
                this.deleteSearchTop();
                StringBuilder selectSearchHistoryQuery = new StringBuilder("");
                if ("mysql".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                    selectSearchHistoryQuery.append("SELECT SEARCH_CONTEXT, SEARCH_STRING, OBJ_NAME, @rnk:=IF(@preval <=> COUNTSTRING, @rnk, @row+1 ) AS \"RANK\", ");
                    selectSearchHistoryQuery.append(" @row:= @row+1 , @preval:=COUNTSTRING  ");
                    selectSearchHistoryQuery.append(" FROM (SELECT COUNT(SEARCH_STRING) \"COUNTSTRING\", SEARCH_CONTEXT, SEARCH_STRING,OBJ_NAME ");
                    selectSearchHistoryQuery.append(" FROM SEARCH_HISTORY  WHERE DATE_TIME > (CURRENT_DATE-1) GROUP BY SEARCH_CONTEXT, OBJ_NAME, SEARCH_STRING ORDER BY COUNTSTRING DESC) t, ");
                    selectSearchHistoryQuery.append(" (SELECT  @rnk:=0, @preval:=null, @row:=0) var ");
                } else {
                    selectSearchHistoryQuery.append("SELECT SEARCH_CONTEXT, SEARCH_STRING, OBJ_NAME, DENSE_RANK() OVER (ORDER BY COUNTSTRING DESC) \"RANK\"  FROM ");
                    selectSearchHistoryQuery.append(" (SELECT COUNT(SEARCH_STRING) \"COUNTSTRING\", SEARCH_CONTEXT, SEARCH_STRING,OBJ_NAME ");
                    selectSearchHistoryQuery.append(" FROM SEARCH_HISTORY  WHERE DATE_TIME > (CURRENT_DATE-1) GROUP BY SEARCH_CONTEXT, OBJ_NAME, SEARCH_STRING) ");
                }
                BaseLogger.log("3", null, null, "saveSearchTop : selectQuery : " + selectSearchHistoryQuery.toString());
                stmt = conn.createStatement();
                rs = stmt.executeQuery(selectSearchHistoryQuery.toString());
                String insertQry = "INSERT INTO SEARCH_TOPS(OBJ_NAME, SEARCH_CONTEXT, SEARCH_STRING, SEARCH_RANK) VALUES(?, ?, ?, ?)";
                insertPstmt = conn.prepareStatement(insertQry);
                while (rs.next()) {
                    insertPstmt.setString(1, rs.getString("OBJ_NAME"));
                    insertPstmt.setString(2, rs.getString("SEARCH_CONTEXT"));
                    insertPstmt.setString(3, rs.getString("SEARCH_STRING"));
                    insertPstmt.setInt(4, Integer.parseInt(rs.getString("RANK")));
                    insertPstmt.addBatch();
                }
                insertPstmt.executeBatch();
                stmt.close();
                stmt = null;
                insertPstmt.close();
                insertPstmt = null;
                conn.commit();
                BaseLogger.log("3", null, null, "Inserted into search_tops sucessfully...");
            }
            catch (SQLException ie) {
                BaseLogger.log("0", null, null, "SQLException :SearchHistoryEJB :saveSearchTop:==>" + ie);
                ie.printStackTrace();
                throw new ITMException(ie);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :SearchHistoryEJB :saveSearchTop :==>" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (insertPstmt != null) {
                        insertPstmt.close();
                        insertPstmt = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
    }

    @Override
    public String getSearchTop(String objName, String searchContext, UserInfoBean userInfo) throws RemoteException, ITMException {
        Connection conn = null;
        ConnDriver mConnDriver = null;
        Statement mPstmt = null;
        ResultSet rs = null;
        StringBuilder strBuild = new StringBuilder();
        try {
            try {
                int topRows = 10;
                mConnDriver = new ConnDriver();
                String transDB = userInfo.getTransDB();
                conn = mConnDriver.getConnectDB(transDB);
                String selectQuery = "SELECT SEARCH_STRING FROM SEARCH_TOPS WHERE OBJ_NAME = ? AND SEARCH_CONTEXT = ? ORDER BY SEARCH_RANK";
                BaseLogger.log("3", userInfo, null, "saveSearchTop : selectQuery : " + selectQuery);
                mPstmt = conn.prepareStatement(selectQuery);
                mPstmt.setString(1, objName);
                mPstmt.setString(2, searchContext);
                BaseLogger.log("3", userInfo, null, "Before fetch data from search_top...");
                rs = mPstmt.executeQuery();
                strBuild.append("<Root>");
                while (rs.next()) {
                    if (topRows-- <= 0) break;
                    strBuild.append("<SEARCH_STRING><![CDATA[" + rs.getString("SEARCH_STRING") + "]]></SEARCH_STRING>");
                }
                strBuild.append("</Root>");
                mPstmt.close();
                mPstmt = null;
                conn.commit();
                BaseLogger.log("3", userInfo, null, "Fetched data from search_top sucessfully...");
            }
            catch (SQLException ie) {
                BaseLogger.log("0", userInfo, null, "SQLException :SearchHistoryEJB :getSearchTop:==>" + ie);
                ie.printStackTrace();
                throw new ITMException(ie);
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :SearchHistoryEJB :getSearchTop :==>" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (mPstmt != null) {
                        mPstmt.close();
                        mPstmt = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return strBuild.toString();
    }

    public void deleteSearchTop() throws RemoteException, ITMException {
        Connection conn = null;
        ConnDriver mConnDriver = null;
        Statement mPstmt = null;
        try {
            try {
                mConnDriver = new ConnDriver();
                conn = mConnDriver.getConnectDB("Driver");
                String deleteQuery = "DELETE FROM SEARCH_TOPS";
                BaseLogger.log("3", null, null, "Before delete of from search_top...");
                mPstmt = conn.prepareStatement(deleteQuery);
                mPstmt.executeUpdate();
                mPstmt.close();
                mPstmt = null;
                conn.commit();
                BaseLogger.log("3", null, null, "Deleted data of search_top sucessfully...");
            }
            catch (SQLException ie) {
                BaseLogger.log("0", null, null, "SQLException :SearchHistoryEJB :deleteSearchTop:==>" + ie);
                ie.printStackTrace();
                throw new ITMException(ie);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :SearchHistoryEJB :deleteSearchTop :==>" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (mPstmt != null) {
                        mPstmt.close();
                        mPstmt = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
    }

    @Override
    public String schedulePriority(String wrkflwPriority) throws RemoteException, ITMException {
        return this.schedule("");
    }

    @Override
    public String schedule(HashMap map) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String schedule(String scheduleParamXML) throws RemoteException, ITMException {
        this.saveSearchTop();
        return "";
    }
}

