/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.bean.ExtAuthApplicationBean;
import ibase.bean.ExtAuthRespBean;
import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CryptographyUtil;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.utility.entityInfo.CustomerUserInfo;
import ibase.utility.entityInfo.StrgCustUserInfo;
import ibase.utility.entityInfo.SupplierUserInfo;
import ibase.utility.entityInfo.TransporterUserInfo;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.RestAPIServiceUtility;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.sql.CLOB;

public class APIUtility {
    String responseID;

    public String getResponseID() {
        return this.responseID;
    }

    public void setResponseID(String responseID) {
        this.responseID = responseID;
    }

    public void writeApiCallLog(UserInfoBean userInfo, StringBuffer responseInfo, String callStatus, String appId, String ipAddress) throws ITMException {
        this.writeApiCallLog(userInfo, responseInfo.toString(), callStatus, appId, ipAddress, "", "", "", "", "", "", "");
    }

    public String writeApiCallLog(UserInfoBean userInfo, String responseInfo, String callStatus, String appId, String ipAddress, String requestData, String apiName, String apiURL, String apiScope, String apiType, String refId, String refSer) throws ITMException {
        BaseLogger.log("3", null, null, "userInfo:: APIUtility[" + userInfo + "]");
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String tranID = "";
        CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
        ConnDriver connDriver = new ConnDriver();
        String siteCode = "NA";
        String userCode = "NA";
        String chgTerm = ipAddress;
        String enterprise = "NA";
        try {
            try {
                if (userInfo != null) {
                    conn = connDriver.getConnectDB(userInfo);
                    siteCode = userInfo.getSiteCode();
                    userCode = userInfo.getLoginCode();
                    enterprise = userInfo.getEnterprise();
                } else {
                    conn = connDriver.getConnectDB("Driver");
                }
                tranID = commonDBAccessEJB.generateSeq("comm_log_seq", 15, "Driver");
                String responseInfoString = responseInfo.toString();
                BaseLogger.log("3", null, null, "APIUtility.writeApiCallLog() siteCode : [" + siteCode + "]");
                BaseLogger.log("3", null, null, "APIUtility.writeApiCallLog() userCode : [" + userCode + "]");
                BaseLogger.log("3", null, null, "APIUtility.writeApiCallLog() chgTerm  : [" + chgTerm + "]");
                DatabaseMetaData md = conn.getMetaData();
                rs = md.getColumns(null, null, "API_CALL_LOG", "APP_ID");
                String sqlQuery = "";
                if (rs.next()) {
                    sqlQuery = "INSERT INTO API_CALL_LOG (TRAN_ID,CALL_DATE,SITE_CODE,USER_ID,CALL_TYPE,REC_TYPE,NO_OF_RECORDS,CALL_STATUS,RESPONSE_ID,RESPONSE_INFO,CHG_USER,CHG_DATE,CHG_TERM,APP_ID, ENTERPRISE, REQUEST_DATA, API_NAME, API_TYPE, API_URL, API_SCOPE, REF_ID, REF_SER ) \nVALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    pstmt = conn.prepareStatement(sqlQuery);
                    pstmt.setString(1, tranID);
                    pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                    pstmt.setString(3, siteCode);
                    pstmt.setString(4, userCode);
                    pstmt.setString(5, "E");
                    pstmt.setString(6, "");
                    pstmt.setString(7, "");
                    pstmt.setString(8, callStatus);
                    pstmt.setString(9, this.getResponseID());
                    CLOB responseInfoClob = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                    responseInfoClob.putString(1L, responseInfoString);
                    pstmt.setClob(10, (Clob)responseInfoClob);
                    pstmt.setString(11, userCode);
                    pstmt.setTimestamp(12, new Timestamp(System.currentTimeMillis()));
                    pstmt.setString(13, chgTerm);
                    pstmt.setString(14, appId);
                    pstmt.setString(15, enterprise);
                    CLOB requestDataClob = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                    requestDataClob.putString(1L, requestData);
                    pstmt.setClob(16, (Clob)requestDataClob);
                    pstmt.setString(17, apiName);
                    pstmt.setString(18, apiType);
                    pstmt.setString(19, apiURL);
                    pstmt.setString(20, apiScope);
                    pstmt.setString(21, refId);
                    pstmt.setString(22, refSer);
                    int insCnt = pstmt.executeUpdate();
                    if (insCnt > 0) {
                        conn.commit();
                    }
                    BaseLogger.log("3", null, null, "APIUtility.writeApiCallLog() APP_ID EXISTS");
                } else {
                    sqlQuery = "INSERT INTO API_CALL_LOG (TRAN_ID,CALL_DATE,SITE_CODE,USER_ID,CALL_TYPE,REC_TYPE,NO_OF_RECORDS,CALL_STATUS,RESPONSE_ID,RESPONSE_INFO,CHG_USER,CHG_DATE,CHG_TERM, ENTERPRISE, REQUEST_DATA, API_NAME, API_TYPE, API_URL, API_SCOPE, REF_ID, REF_SER) \nVALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    pstmt = conn.prepareStatement(sqlQuery);
                    pstmt.setString(1, tranID);
                    pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                    pstmt.setString(3, siteCode);
                    pstmt.setString(4, userCode);
                    pstmt.setString(5, "E");
                    pstmt.setString(6, "");
                    pstmt.setString(7, "");
                    pstmt.setString(8, callStatus);
                    pstmt.setString(9, this.getResponseID());
                    CLOB responseInfoClob = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                    responseInfoClob.putString(1L, responseInfoString);
                    pstmt.setClob(10, (Clob)responseInfoClob);
                    pstmt.setString(11, userCode);
                    pstmt.setTimestamp(12, new Timestamp(System.currentTimeMillis()));
                    pstmt.setString(13, chgTerm);
                    pstmt.setString(14, enterprise);
                    CLOB requestDataClob = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                    requestDataClob.putString(1L, requestData);
                    pstmt.setClob(15, (Clob)requestDataClob);
                    pstmt.setString(16, apiName);
                    pstmt.setString(17, apiType);
                    pstmt.setString(18, apiURL);
                    pstmt.setString(19, apiScope);
                    pstmt.setString(20, refId);
                    pstmt.setString(21, refSer);
                    int insCnt = pstmt.executeUpdate();
                    if (insCnt > 0) {
                        conn.commit();
                    }
                    BaseLogger.log("3", null, null, "APIUtility.writeApiCallLog() APP_ID DOESN'T EXISTS");
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "APIUtility.writeApiCallLog() Exception message.........:" + E12GenericUtility.getStackTrace(e));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "APIUtility.writeApiCallLog() finally Exception message.........:" + E12GenericUtility.getStackTrace(e));
            }
        }
        BaseLogger.log("3", null, null, "APIUtility.writeApiCallLog() returning tranID : [" + tranID + "]");
        return tranID;
    }

    public void updateApiCallLog(UserInfoBean userInfo, String responseInfo, String callStatus, String appId, String ipAddress, String requestData, String apiName, String apiURL, String apiScope, String apiType, String refId, String refSer, String tranId) throws ITMException {
        Connection conn = null;
        Statement pstmt = null;
        Statement preparedStatement = null;
        ResultSet rs = null;
        ConnDriver connDriver = new ConnDriver();
        String siteCode = "NA";
        String userCode = "NA";
        String chgTerm = ipAddress;
        try {
            try {
                if (userInfo != null) {
                    conn = connDriver.getConnectDB(userInfo);
                    siteCode = userInfo.getSiteCode();
                    userCode = userInfo.getLoginCode();
                } else {
                    conn = connDriver.getConnectDB();
                }
                String responseInfoString = responseInfo.toString();
                BaseLogger.log("3", null, null, "APIUtility.updateApiCallLog() tranId : [" + tranId + "]");
                BaseLogger.log("3", null, null, "APIUtility.updateApiCallLog() siteCode : [" + siteCode + "]");
                BaseLogger.log("3", null, null, "APIUtility.updateApiCallLog() userCode : [" + userCode + "]");
                BaseLogger.log("3", null, null, "APIUtility.updateApiCallLog() chgTerm  : [" + chgTerm + "]");
                String sqlQuery = "SELECT COUNT(*) AS COUNT FROM API_CALL_LOG WHERE TRAN_ID = '" + tranId + "'";
                preparedStatement = conn.prepareStatement(sqlQuery);
                rs = preparedStatement.executeQuery();
                if (rs.next()) {
                    int logCount = rs.getInt("COUNT");
                    BaseLogger.log("3", null, null, "APIUtility.updateApiCallLog() logCount = [" + logCount + "]");
                    if (logCount > 0) {
                        sqlQuery = "UPDATE API_CALL_LOG SET CALL_DATE = ?, CALL_STATUS = ?, RESPONSE_INFO = ?, REQUEST_DATA = ?, CHG_USER = ?, CHG_DATE = ?, CHG_TERM = ? WHERE TRAN_ID = ?";
                        pstmt = conn.prepareStatement(sqlQuery);
                        pstmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                        pstmt.setString(2, callStatus);
                        CLOB responseInfoClob = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                        responseInfoClob.putString(1L, responseInfoString);
                        pstmt.setClob(3, (Clob)responseInfoClob);
                        CLOB requestDataClob = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                        requestDataClob.putString(1L, requestData);
                        pstmt.setClob(4, (Clob)requestDataClob);
                        pstmt.setString(5, userCode);
                        pstmt.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                        pstmt.setString(7, chgTerm);
                        pstmt.setString(8, tranId);
                        int updateCount = pstmt.executeUpdate();
                        BaseLogger.log("3", null, null, "APIUtility.updateApiCallLog() updateCount = [" + updateCount + "]");
                        if (updateCount > 0) {
                            conn.commit();
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                    } else {
                        this.writeApiCallLog(userInfo, responseInfoString, callStatus, appId, ipAddress, requestData, apiName, apiURL, apiScope, apiType, refId, refSer);
                    }
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                    preparedStatement = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "APIUtility.updateApiCallLog() Exception message.........:" + E12GenericUtility.getStackTrace(e));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                    preparedStatement = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "APIUtility.updateApiCallLog() finally Exception message.........:" + E12GenericUtility.getStackTrace(e));
            }
        }
    }

    public ArrayList<String> getAPIKey(UserInfoBean userInfo, String apiName) {
        String resultStr = "";
        Connection con = null;
        Statement stmt = null;
        ResultSet mResultSet = null;
        Statement entStmt = null;
        ResultSet entResultSet = null;
        ArrayList<String> apiKeyParams = new ArrayList<String>();
        String sql = "";
        String licenseKey = "";
        String apiScope = "";
        ConnDriver mConnDriver = new ConnDriver();
        try {
            try {
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("dd-MMM-yy");
                LocalDateTime now = LocalDateTime.now();
                String sysDate = dtf.format(now);
                con = mConnDriver.getConnectDB("Driver");
                sql = "select COUNT(*) AS count from ENT_EXT_API_KEY where ENTERPRISE = ? AND API_NAME = ? AND API_SCOPE = ? AND EFF_FROM <= ? AND (VALID_UPTO is null OR VALID_UPTO = '' OR VALID_UPTO >= ?)";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, userInfo.getEnterprise());
                stmt.setString(2, apiName);
                stmt.setString(3, "E");
                stmt.setString(4, sysDate);
                stmt.setString(5, sysDate);
                mResultSet = stmt.executeQuery();
                while (mResultSet.next()) {
                    int cnt = mResultSet.getInt("count");
                    if (cnt > 0) {
                        sql = "select API_KEY from ENT_EXT_API_KEY where ENTERPRISE = ? AND API_NAME = ? AND API_SCOPE = ? AND EFF_FROM <= ? AND (VALID_UPTO is null OR VALID_UPTO = '' OR VALID_UPTO >= ?)";
                        entStmt = con.prepareStatement(sql);
                        entStmt.setString(1, userInfo.getEnterprise());
                        entStmt.setString(2, apiName);
                        entStmt.setString(3, "E");
                        entStmt.setString(4, sysDate);
                        entStmt.setString(5, sysDate);
                        entResultSet = entStmt.executeQuery();
                        while (entResultSet.next()) {
                            apiKeyParams.add(entResultSet.getString("API_KEY"));
                            apiKeyParams.add("E");
                        }
                        BaseLogger.log("3", null, null, "InvoiceReader readInvoice() apiKeyParams 490:::" + apiKeyParams);
                        entResultSet.close();
                        entResultSet = null;
                        entStmt.close();
                        entStmt = null;
                        continue;
                    }
                    sql = "select * from ENT_EXT_API_KEY where API_NAME = ? AND API_SCOPE = ?  AND EFF_FROM <= ? AND (VALID_UPTO is null OR VALID_UPTO = '' OR VALID_UPTO >= ?)";
                    entStmt = con.prepareStatement(sql);
                    entStmt.setString(1, apiName);
                    entStmt.setString(2, "G");
                    entStmt.setString(3, sysDate);
                    entStmt.setString(4, sysDate);
                    entResultSet = entStmt.executeQuery();
                    while (entResultSet.next()) {
                        apiKeyParams.add(entResultSet.getString("API_KEY"));
                        apiKeyParams.add("G");
                    }
                    BaseLogger.log("3", null, null, "InvoiceReader readInvoice() apiKeyParams 511:::" + apiKeyParams);
                    entResultSet.close();
                    entResultSet = null;
                    entStmt.close();
                    entStmt = null;
                }
                try {
                    if (mResultSet != null) {
                        mResultSet.close();
                        mResultSet = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (con != null) {
                        con.close();
                        con = null;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, "APIUTILITY.getAPIKey()", "Exception in getAPIKey : " + e);
                try {
                    if (mResultSet != null) {
                        mResultSet.close();
                        mResultSet = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (con != null) {
                        con.close();
                        con = null;
                    }
                    if (con != null) {
                        con.close();
                    }
                    if (entStmt != null) {
                        entStmt.close();
                    }
                    if (entResultSet != null) {
                        entResultSet.close();
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (mResultSet != null) {
                    mResultSet.close();
                    mResultSet = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
                if (con != null) {
                    con.close();
                }
                if (entStmt != null) {
                    entStmt.close();
                }
                if (entResultSet != null) {
                    entResultSet.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return apiKeyParams;
    }

    public boolean checkDailyAPILimit(UserInfoBean userInfo) throws ITMException {
        boolean dailyAPILimitExceed = false;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        Connection conn = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(userInfo.getTransDB());
                int dailyAPILimit = 0;
                String apiLimitSQL = "SELECT DAILY_API_LIMIT FROM ENTERPRISE WHERE ENTERPRISE = ?";
                preparedStatement = conn.prepareStatement(apiLimitSQL);
                preparedStatement.setString(1, userInfo.getEnterprise());
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    dailyAPILimit = resultSet.getInt("DAILY_API_LIMIT");
                }
                BaseLogger.log("3", userInfo, null, "APIUtility.checkDailyAPILimit() DAILY_API_LIMIT against enterprise [" + userInfo.getEnterprise() + "] " + ": [" + dailyAPILimit + "]");
                preparedStatement.close();
                preparedStatement = null;
                resultSet.close();
                resultSet = null;
                int apiCallCount = 0;
                String bathlodCountSQL = "SELECT COUNT(*) AS COUNT FROM API_CALL_LOG A, USERS U WHERE A.CHG_USER = U.CODE AND U.ENTERPRISE = ? AND TRUNC(A.CHG_DATE) = TO_DATE(SYSDATE, 'dd-mm-yy')";
                String dbName = connDriver.getDBName(conn);
                bathlodCountSQL = "db2".equalsIgnoreCase(dbName) || "mysql".equalsIgnoreCase(dbName) || "pgsql".equalsIgnoreCase(dbName) ? "SELECT COUNT(*) AS COUNT FROM API_CALL_LOG A, USERS U WHERE A.CHG_USER = U.CODE AND U.ENTERPRISE = ? AND CAST(A.CHG_DATE AS DATE) = CAST(CURRENT_DATE AS DATE)" : ("mssql".equalsIgnoreCase(dbName) ? "SELECT COUNT(*) AS COUNT FROM API_CALL_LOG A, USERS U WHERE A.CHG_USER = U.CODE AND U.ENTERPRISE = ? AND CAST(A.CHG_DATE AS DATE) = convert(date,GETDATE())" : "SELECT COUNT(*) AS COUNT FROM API_CALL_LOG A, USERS U WHERE A.CHG_USER = U.CODE AND U.ENTERPRISE = ? AND TRUNC(A.CHG_DATE) = trunc(SYSDATE)");
                preparedStatement = conn.prepareStatement(bathlodCountSQL);
                preparedStatement.setString(1, userInfo.getEnterprise());
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    apiCallCount = resultSet.getInt("COUNT");
                }
                BaseLogger.log("3", userInfo, null, "APIUtility.checkDailyAPILimit() apiCallCount : [" + apiCallCount + "]");
                preparedStatement.close();
                preparedStatement = null;
                resultSet.close();
                resultSet = null;
                if (dailyAPILimit != 0 && apiCallCount > dailyAPILimit) {
                    dailyAPILimitExceed = true;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "APIUtility.checkDailyAPILimit() Exception : [" + E12GenericUtility.getStackTrace(e) + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                        preparedStatement = null;
                    }
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
            }
            catch (Exception e2) {
                BaseLogger.log("0", userInfo, null, "APIUtility.checkDailyAPILimit() Exception in finally : [" + E12GenericUtility.getStackTrace(e2) + "]");
            }
        }
        BaseLogger.log("2", userInfo, null, "APIUtility.checkDailyAPILimit() dailyAPILimitExceed : [" + dailyAPILimitExceed + "]");
        return dailyAPILimitExceed;
    }

    public String getJWTToken(String userCode, ExtAuthApplicationBean applicationBean) throws BaseException, Exception {
        BaseLogger.log("2", null, null, "ExtAuthAppService :: getJWTToken");
        RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
        ExtAuthRespBean userBean = restapiserviceutility.getCommonDBAccess().getExtAuthRespBean(userCode);
        String jwtToken = CryptographyUtil.createBase64EncodedJWT(applicationBean, userBean, "");
        BaseLogger.log("2", null, null, "ExtAuthAppService :: getJWTToken: jwtToken : [" + jwtToken + "]");
        return jwtToken;
    }

    public String getJWTToken(String entityCode, ExtAuthApplicationBean applicationBean, String entityType, String enterprise, String chatID) throws BaseException, Exception {
        BaseLogger.log("2", null, null, "APIUtility :: getJWTToken: userCode[" + entityCode + "]" + "applicationBean [" + applicationBean + "]" + "entityType [" + entityType + "]");
        String jwtToken = "";
        UserInfoBean userInfo = new UserInfoBean();
        switch (entityType.toUpperCase()) {
            case "C": {
                BaseLogger.log("2", null, null, "APIUtility :: Inside case CUSTOMER");
                CustomerUserInfo customerUserInfo = new CustomerUserInfo();
                userInfo = customerUserInfo.createCustomerUserInfo(entityCode, enterprise, chatID);
                break;
            }
            case "S": {
                BaseLogger.log("2", null, null, "APIUtility :: Inside case SUPPLIER");
                SupplierUserInfo supplierUserInfo = new SupplierUserInfo();
                userInfo = supplierUserInfo.createSupplierUserInfo(entityCode, enterprise, chatID);
                break;
            }
            case "G": {
                BaseLogger.log("2", null, null, "APIUtility :: Inside case STRG_CUSTOMER");
                StrgCustUserInfo strgCustUserInfo = new StrgCustUserInfo();
                userInfo = strgCustUserInfo.createStrgCustUserInfo(entityCode, enterprise, chatID);
                break;
            }
            case "T": {
                BaseLogger.log("2", null, null, "APIUtility :: Inside case TRANSPORTER");
                TransporterUserInfo transporterUserInfo = new TransporterUserInfo();
                userInfo = transporterUserInfo.createTransporterUserInfo(entityCode, enterprise, chatID);
                break;
            }
        }
        BaseLogger.log("2", null, null, "ExtAuthAppService gsb :: getJWTToken: userInfo : [" + userInfo + "]");
        jwtToken = CryptographyUtil.createBase64EncodedJWT(applicationBean, userInfo, "");
        BaseLogger.log("2", null, null, "ExtAuthAppService :: getJWTToken: jwtToken : [" + jwtToken + "]");
        return jwtToken;
    }

    public UserInfoBean getEntityUserInfo(String entityCode, ExtAuthApplicationBean applicationBean, String entityType, String enterprise, String chatID) throws BaseException, Exception {
        BaseLogger.log("2", null, null, "APIUtility :: getJWTToken: userCode[" + entityCode + "]" + "applicationBean [" + applicationBean + "]" + "entityType [" + entityType + "]");
        UserInfoBean userInfo = new UserInfoBean();
        switch (entityType.toUpperCase()) {
            case "C": {
                BaseLogger.log("2", null, null, "APIUtility :: Inside case CUSTOMER");
                CustomerUserInfo customerUserInfo = new CustomerUserInfo();
                userInfo = customerUserInfo.createCustomerUserInfo(entityCode, enterprise, chatID);
                break;
            }
            case "S": {
                BaseLogger.log("2", null, null, "APIUtility :: Inside case SUPPLIER");
                SupplierUserInfo supplierUserInfo = new SupplierUserInfo();
                userInfo = supplierUserInfo.createSupplierUserInfo(entityCode, enterprise, chatID);
                break;
            }
            case "G": {
                BaseLogger.log("2", null, null, "APIUtility :: Inside case STRG_CUSTOMER");
                StrgCustUserInfo strgCustUserInfo = new StrgCustUserInfo();
                userInfo = strgCustUserInfo.createStrgCustUserInfo(entityCode, enterprise, chatID);
                break;
            }
            case "T": {
                BaseLogger.log("2", null, null, "APIUtility :: Inside case TRANSPORTER");
                TransporterUserInfo transporterUserInfo = new TransporterUserInfo();
                userInfo = transporterUserInfo.createTransporterUserInfo(entityCode, enterprise, chatID);
                break;
            }
        }
        BaseLogger.log("2", null, null, "ExtAuthAppService gsb :: getJWTToken: userInfo : [" + userInfo + "]");
        return userInfo;
    }

    public UserInfoBean createUserInfoFromJWTToken(String tokenID) {
        System.out.println("createUserInfoFromJWTToken tokenId[" + tokenID + "]");
        UserInfoBean userInfo = new UserInfoBean();
        String sharedKey = "a3edd11a09ea4e0ccd09c6cd2828021b";
        HashMap<String, String> jwtData = CryptographyUtil.parseBase64EncodedJWTToken(tokenID, sharedKey);
        System.out.println("createUserInfoFromJWTToken jwtData hmp[" + jwtData + "]");
        userInfo = this.createUserInfo(jwtData);
        if (E12GenericUtility.checkNull(userInfo.getLoginCode()).equalsIgnoreCase("")) {
            BaseLogger.log("2", userInfo, null, "userInfo null gsb");
            return null;
        }
        return userInfo;
    }

    public UserInfoBean createUserInfoUsingJWTToken(String tokenID) {
        System.out.println("createUserInfoUsingJWTToken tokenId[" + tokenID + "]");
        UserInfoBean userInfo = new UserInfoBean();
        String sharedKey = "a3edd11a09ea4e0ccd09c6cd2828021b";
        HashMap<String, String> jwtData = CryptographyUtil.parseBase64EncodedJWTToken(tokenID, sharedKey);
        System.out.println("createUserInfoUsingJWTToken jwtData hmp[" + jwtData + "]");
        if (jwtData.containsKey("status")) {
            System.out.println("Status Key result t or f jwtData.containsKey(\"status\")[" + jwtData.containsKey("status") + "]");
            String statusValue = jwtData.get("status");
            System.out.println("Status Value==" + statusValue);
            if (statusValue.equalsIgnoreCase("invalid")) {
                System.out.println("setting userinfo null");
                userInfo = null;
            } else {
                userInfo = this.createUserInfo(jwtData);
            }
        } else {
            userInfo = this.createUserInfo(jwtData);
        }
        if (E12GenericUtility.checkNull(userInfo.getLoginCode()).equalsIgnoreCase("")) {
            BaseLogger.log("2", userInfo, null, "userInfo null gsb");
            return null;
        }
        return userInfo;
    }

    public String getAppIdFromJWTToken(String tokenID) {
        String appId = "";
        String sharedKey = "a3edd11a09ea4e0ccd09c6cd2828021b";
        HashMap<String, String> jwtData = CryptographyUtil.parseBase64EncodedJWTToken(tokenID, sharedKey);
        appId = jwtData.get("applicationId");
        return appId;
    }

    public String getAPIUrl(UserInfoBean userInfo, String apiName) {
        Connection con = null;
        Statement stmt = null;
        ResultSet mResultSet = null;
        Statement entStmt = null;
        ResultSet entResultSet = null;
        String apiUrl = "";
        String sql = "";
        ConnDriver mConnDriver = new ConnDriver();
        try {
            try {
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("dd-MMM-yy");
                LocalDateTime now = LocalDateTime.now();
                String sysDate = dtf.format(now);
                con = mConnDriver.getConnectDB("Driver");
                sql = "select COUNT(*) AS count from ENT_EXT_API_KEY where ENTERPRISE = ? AND API_NAME = ? AND API_SCOPE = ? AND EFF_FROM <= ? AND (VALID_UPTO is null OR VALID_UPTO = '' OR VALID_UPTO >= ?)";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, userInfo.getEnterprise());
                stmt.setString(2, apiName);
                stmt.setString(3, "E");
                stmt.setString(4, sysDate);
                stmt.setString(5, sysDate);
                mResultSet = stmt.executeQuery();
                while (mResultSet.next()) {
                    int cnt = mResultSet.getInt("count");
                    if (cnt > 0) {
                        sql = "select API_URL from ENT_EXT_API_KEY where ENTERPRISE = ? AND API_NAME = ? AND API_SCOPE = ? AND EFF_FROM <= ? AND (VALID_UPTO is null OR VALID_UPTO = '' OR VALID_UPTO >= ?)";
                        entStmt = con.prepareStatement(sql);
                        entStmt.setString(1, userInfo.getEnterprise());
                        entStmt.setString(2, apiName);
                        entStmt.setString(3, "E");
                        entStmt.setString(4, sysDate);
                        entStmt.setString(5, sysDate);
                        entResultSet = entStmt.executeQuery();
                        while (entResultSet.next()) {
                            apiUrl = entResultSet.getString("API_URL");
                        }
                        BaseLogger.log("3", null, null, "ApiUtility getAPIUrl() apiUrl 649::::::" + apiUrl);
                        entResultSet.close();
                        entResultSet = null;
                        entStmt.close();
                        entStmt = null;
                        continue;
                    }
                    sql = "select * from ENT_EXT_API_KEY where API_NAME = ? AND API_SCOPE = ?  AND EFF_FROM <= ? AND (VALID_UPTO is null OR VALID_UPTO = '' OR VALID_UPTO >= ?)";
                    entStmt = con.prepareStatement(sql);
                    entStmt.setString(1, apiName);
                    entStmt.setString(2, "G");
                    entStmt.setString(3, sysDate);
                    entStmt.setString(4, sysDate);
                    entResultSet = entStmt.executeQuery();
                    while (entResultSet.next()) {
                        apiUrl = entResultSet.getString("API_URL");
                    }
                    BaseLogger.log("3", null, null, "ApiUtility getAPIUrl() apiUrl 669::::::" + apiUrl);
                    entResultSet.close();
                    entResultSet = null;
                    entStmt.close();
                    entStmt = null;
                }
                try {
                    if (mResultSet != null) {
                        mResultSet.close();
                        mResultSet = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (con != null) {
                        con.close();
                        con = null;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, "APIUTILITY.getAPIUrl()", "Exception in getAPIUrl : " + e);
                try {
                    if (mResultSet != null) {
                        mResultSet.close();
                        mResultSet = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (con != null) {
                        con.close();
                        con = null;
                    }
                    if (entStmt != null) {
                        entStmt.close();
                    }
                    if (entResultSet != null) {
                        entResultSet.close();
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (mResultSet != null) {
                    mResultSet.close();
                    mResultSet = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
                if (entStmt != null) {
                    entStmt.close();
                }
                if (entResultSet != null) {
                    entResultSet.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return apiUrl;
    }

    public UserInfoBean createUserInfo(HashMap<String, String> jwtData) {
        System.out.println("Inside createUserInfo gsbgsb[" + jwtData + "]");
        UserInfoBean basicInfo = null;
        if (jwtData != null) {
            basicInfo = new UserInfoBean();
            basicInfo.setLoginCode(E12GenericUtility.checkNull(jwtData.get("userId")));
            basicInfo.setLoginUserId(E12GenericUtility.checkNull(jwtData.get("userId")));
            basicInfo.setLoginMobileNo(E12GenericUtility.checkNull(jwtData.get("loginMobileNo")));
            basicInfo.setLoginEmailId(jwtData.get("email"));
            basicInfo.setProfileId(E12GenericUtility.checkNull(jwtData.get("profileId")));
            basicInfo.setSiteCode(E12GenericUtility.checkNull(jwtData.get("loginSite")));
            basicInfo.setSiteDescr(E12GenericUtility.checkNull(jwtData.get("siteDescr")));
            basicInfo.setEmpCode(E12GenericUtility.checkNull(jwtData.get("empCode")));
            basicInfo.setEmpName(E12GenericUtility.checkNull(jwtData.get("empName")));
            basicInfo.setEmpFName(E12GenericUtility.checkNull(jwtData.get("empFName")));
            basicInfo.setEmpLName(E12GenericUtility.checkNull(jwtData.get("empLName")));
            basicInfo.setEmpMName(E12GenericUtility.checkNull(jwtData.get("empMName")));
            basicInfo.setReportTo(E12GenericUtility.checkNull(jwtData.get("reportTo")));
            basicInfo.setDeptCode(E12GenericUtility.checkNull(jwtData.get("deptCode")));
            basicInfo.setDeptCode(E12GenericUtility.checkNull(jwtData.get("deptDescr")));
            basicInfo.setEmailIdOff(E12GenericUtility.checkNull(jwtData.get("emailIdOff")));
            basicInfo.setEntityCode(E12GenericUtility.checkNull(jwtData.get("entityCode")));
            basicInfo.setUserLevel(E12GenericUtility.checkNull(jwtData.get("userLevel")));
            basicInfo.setUserType(E12GenericUtility.checkNull(jwtData.get("userType")));
            basicInfo.setItemSer(E12GenericUtility.checkNull(jwtData.get("itemSer")));
            basicInfo.setDeviceID(E12GenericUtility.checkNull(jwtData.get("deviceID")));
            basicInfo.setDeviceType(E12GenericUtility.checkNull(jwtData.get("deviceType")));
            basicInfo.setEnterprise(E12GenericUtility.checkNull(jwtData.get("enterprise")));
            basicInfo.setSocialOpt(E12GenericUtility.checkNull(jwtData.get("socialOpt")));
            basicInfo.setEnterpriseDescr(E12GenericUtility.checkNull(jwtData.get("enterpriseDescr")));
            basicInfo.setInMemUserName(E12GenericUtility.checkNull(jwtData.get("inMemUserName")));
            basicInfo.setInMemPassword(E12GenericUtility.checkNull(jwtData.get("inMemPassword")));
            basicInfo.setInMemUrl(E12GenericUtility.checkNull(jwtData.get("inMemUrl")));
            basicInfo.setSessTimeoutInSec(E12GenericUtility.checkNull(jwtData.get("sessTimeoutInSecs")));
            basicInfo.setDocServerID(E12GenericUtility.checkNull(jwtData.get("docServerID")));
            basicInfo.setSmtpFallback(E12GenericUtility.checkNull(jwtData.get("smtpFallback")));
            basicInfo.setCumulativeLoggedInTimeForTheDay(E12GenericUtility.checkNull(jwtData.get("cumulativeLoggedInTimeForTheDay")));
            basicInfo.setCity(E12GenericUtility.checkNull(jwtData.get("city")));
            basicInfo.setFin_entity(E12GenericUtility.checkNull(jwtData.get("fin_entity")));
            basicInfo.setFacility_code(E12GenericUtility.checkNull(jwtData.get("facility_code")));
            basicInfo.setEntryType(E12GenericUtility.checkNull(jwtData.get("entryType")));
            basicInfo.setEntryId(E12GenericUtility.checkNull(jwtData.get("setEntryId")));
            basicInfo.setSmtpHost(E12GenericUtility.checkNull(jwtData.get("smtpHost")));
            basicInfo.setSmtpPort(E12GenericUtility.checkNull(jwtData.get("smtpPort")));
            basicInfo.setSmtpUser(E12GenericUtility.checkNull(jwtData.get("smtpUser")));
            basicInfo.setSmtpPassWD(E12GenericUtility.checkNull(jwtData.get("smtpPassWD")));
            basicInfo.setSmtpProtocolType(E12GenericUtility.checkNull(jwtData.get("smtpProtocolType")));
            basicInfo.setSmtpMailFrom(E12GenericUtility.checkNull(jwtData.get("smtpMailFrom")));
            basicInfo.setAdminEmailId(E12GenericUtility.checkNull(jwtData.get("adminEmailId")));
            basicInfo.setUserName(E12GenericUtility.checkNull(jwtData.get("userName")));
            basicInfo.setIsPasswordStore(E12GenericUtility.checkNull(jwtData.get("isPasswordStore")));
            basicInfo.setDefaultMenu(E12GenericUtility.checkNull(jwtData.get("defaultMenu")));
            basicInfo.setFeatures(E12GenericUtility.checkNull(jwtData.get("features")));
            basicInfo.setCharEnc(E12GenericUtility.checkNull(jwtData.get("charEnc")));
            basicInfo.setRemoteHost(E12GenericUtility.checkNull(jwtData.get("remoteHost")));
            basicInfo.setRemoteHostName(E12GenericUtility.checkNull(jwtData.get("remoteHostName")));
            basicInfo.setProfileIdRes(E12GenericUtility.checkNull(jwtData.get("remoteHostName")));
            basicInfo.setStanCode(E12GenericUtility.checkNull(jwtData.get("stanCode")));
            basicInfo.setDesignation(E12GenericUtility.checkNull(jwtData.get("designation")));
            basicInfo.setDateJoin(E12GenericUtility.checkNull(jwtData.get("dateJoin")));
            basicInfo.setDivision(E12GenericUtility.checkNull(jwtData.get("division")));
            basicInfo.setUserLanguage(E12GenericUtility.checkNull(jwtData.get("userLanguage")));
            basicInfo.setLoggerType(E12GenericUtility.checkNull(jwtData.get("loggerType")));
            basicInfo.setTransDB(E12GenericUtility.checkNull(jwtData.get("transDB")));
            basicInfo.setUserTheme(E12GenericUtility.checkNull(jwtData.get("userTheme")));
            basicInfo.setUxInterface(E12GenericUtility.checkNull(jwtData.get("uxInterface")));
            basicInfo.setTimeZone(E12GenericUtility.checkNull(jwtData.get("timeZone")));
            basicInfo.setHostName(E12GenericUtility.checkNull(jwtData.get("hostName")));
            basicInfo.setHostIP(E12GenericUtility.checkNull(jwtData.get("hostIP")));
            basicInfo.setProfileDescr(E12GenericUtility.checkNull(jwtData.get("profileDescr")));
            basicInfo.setUserGeoFence(E12GenericUtility.checkNull(jwtData.get("userGeoFence")));
            basicInfo.setDataMode(E12GenericUtility.checkNull(jwtData.get("dataMode")));
            basicInfo.setGeoPosOption(E12GenericUtility.checkNull(jwtData.get("geoPosOption")));
            basicInfo.setCurrentGeoPOSName(E12GenericUtility.checkNull(jwtData.get("geoPosOption")));
            basicInfo.setGeoPosAccuracy(E12GenericUtility.checkNull(jwtData.get("geoPosAccuracy")));
            basicInfo.setLogInInterface(E12GenericUtility.checkNull(jwtData.get("geoPosAccuracy")));
            basicInfo.setTermId(E12GenericUtility.checkNull(jwtData.get("geoPosAccuracy")));
            basicInfo.setMacAddress(E12GenericUtility.checkNull(jwtData.get("macAddress")));
            basicInfo.setRemoteAddress(E12GenericUtility.checkNull(jwtData.get("remoteAddress")));
            basicInfo.setUserNetworkOption(E12GenericUtility.checkNull(jwtData.get("userNetworkOption")));
            basicInfo.setAuthenticatedUsing(E12GenericUtility.checkNull(jwtData.get("authenticatedUsing")));
            basicInfo.setSessionId(E12GenericUtility.checkNull(jwtData.get("sessionId")));
            basicInfo.setIsAllowOfflineEdit(E12GenericUtility.checkNull(jwtData.get("isAllowOfflineEdit")));
            basicInfo.setIsAllowOfflineDelete(E12GenericUtility.checkNull(jwtData.get("isAllowOfflineDelete")));
            basicInfo.setSiteCode(E12GenericUtility.checkNull(jwtData.get("siteCode")));
        }
        return basicInfo;
    }

    public HashMap<String, String> getAPIDetail(UserInfoBean userInfo, String apiName) {
        Connection con = null;
        Statement stmt = null;
        ResultSet mResultSet = null;
        Statement entStmt = null;
        ResultSet entResultSet = null;
        HashMap<String, String> apiKeyParams = new HashMap<String, String>();
        ResultSetMetaData resultMetaData = null;
        String sql = "";
        ConnDriver mConnDriver = new ConnDriver();
        try {
            try {
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("dd-MMM-yy");
                LocalDateTime now = LocalDateTime.now();
                String sysDate = dtf.format(now);
                con = mConnDriver.getConnectDB("Driver");
                sql = "select COUNT(*) AS count from ENT_EXT_API_KEY where ENTERPRISE = ? AND API_NAME = ? AND API_SCOPE = ? AND EFF_FROM <= ? AND (VALID_UPTO is null OR VALID_UPTO = '' OR VALID_UPTO >= ?)";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, userInfo.getEnterprise());
                stmt.setString(2, apiName);
                stmt.setString(3, "E");
                stmt.setString(4, sysDate);
                stmt.setString(5, sysDate);
                mResultSet = stmt.executeQuery();
                while (mResultSet.next()) {
                    String colName;
                    int colCount;
                    int numberOfColumns;
                    int cnt = mResultSet.getInt("count");
                    if (cnt > 0) {
                        sql = "select ENTEXTAPIKEY.* from ENT_EXT_API_KEY ENTEXTAPIKEY where ENTERPRISE = ? AND API_NAME = ? AND API_SCOPE = ? AND EFF_FROM <= ? AND (VALID_UPTO is null OR VALID_UPTO = '' OR VALID_UPTO >= ?)";
                        entStmt = con.prepareStatement(sql);
                        entStmt.setString(1, userInfo.getEnterprise());
                        entStmt.setString(2, apiName);
                        entStmt.setString(3, "E");
                        entStmt.setString(4, sysDate);
                        entStmt.setString(5, sysDate);
                        entResultSet = entStmt.executeQuery();
                        resultMetaData = entResultSet.getMetaData();
                        numberOfColumns = resultMetaData.getColumnCount();
                        while (entResultSet.next()) {
                            colCount = 1;
                            while (colCount <= numberOfColumns) {
                                colName = resultMetaData.getColumnLabel(colCount).toUpperCase();
                                apiKeyParams.put(colName, E12GenericUtility.checkNull(entResultSet.getString(colName)));
                                ++colCount;
                            }
                        }
                        BaseLogger.log("3", null, null, "InvoiceReader readInvoice() apiKeyParams 490:::" + apiKeyParams);
                        entResultSet.close();
                        entResultSet = null;
                        entStmt.close();
                        entStmt = null;
                        continue;
                    }
                    sql = "select ENTEXTAPIKEY.* from ENT_EXT_API_KEY ENTEXTAPIKEY where API_NAME = ? AND API_SCOPE = ?  AND EFF_FROM <= ? AND (VALID_UPTO is null OR VALID_UPTO = '' OR VALID_UPTO >= ?)";
                    entStmt = con.prepareStatement(sql);
                    entStmt.setString(1, apiName);
                    entStmt.setString(2, "G");
                    entStmt.setString(3, sysDate);
                    entStmt.setString(4, sysDate);
                    entResultSet = entStmt.executeQuery();
                    resultMetaData = entResultSet.getMetaData();
                    numberOfColumns = resultMetaData.getColumnCount();
                    while (entResultSet.next()) {
                        colCount = 1;
                        while (colCount <= numberOfColumns) {
                            colName = resultMetaData.getColumnLabel(colCount).toUpperCase();
                            apiKeyParams.put(colName, E12GenericUtility.checkNull(entResultSet.getString(colName)));
                            ++colCount;
                        }
                    }
                    BaseLogger.log("3", null, null, "InvoiceReader readInvoice() apiKeyParams 511:::" + apiKeyParams);
                    entResultSet.close();
                    entResultSet = null;
                    entStmt.close();
                    entStmt = null;
                }
                try {
                    if (mResultSet != null) {
                        mResultSet.close();
                        mResultSet = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (con != null) {
                        con.close();
                        con = null;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, "APIUTILITY.getAPIKey()", "Exception in getAPIKey : " + e);
                try {
                    if (mResultSet != null) {
                        mResultSet.close();
                        mResultSet = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (entStmt != null) {
                        entStmt.close();
                        entStmt = null;
                    }
                    if (entResultSet != null) {
                        entResultSet.close();
                        entResultSet = null;
                    }
                    if (con != null) {
                        con.close();
                        con = null;
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (mResultSet != null) {
                    mResultSet.close();
                    mResultSet = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (entStmt != null) {
                    entStmt.close();
                    entStmt = null;
                }
                if (entResultSet != null) {
                    entResultSet.close();
                    entResultSet = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return apiKeyParams;
    }
}

