/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.ejb.session;

import ibase.bi.utility.BIException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DrillParser {
    String[] values;
    TreeMap treemap;
    Document doc;
    DocumentBuilder db;

    public DrillParser(String baName) throws Exception {
        try {
            this.db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            String xmlfile = String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + "common" + File.separator + "xml" + File.separator + baName + ".xml";
            this.doc = this.db.parse(xmlfile);
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private ArrayList getValuesByID(String id) throws Exception {
        this.treemap = new TreeMap();
        ArrayList<Object> values = new ArrayList<Object>();
        NodeList ndlist = this.doc.getElementsByTagName("hierarchie");
        int i = 0;
        while (i < ndlist.getLength()) {
            Node node = ndlist.item(i);
            NamedNodeMap attr = node.getAttributes();
            int x = 0;
            while (x < attr.getLength()) {
                Node attrnode = attr.item(x);
                if (attrnode.getNodeValue().equalsIgnoreCase(id)) {
                    NodeList childnodes = node.getChildNodes();
                    int y = 0;
                    while (y < childnodes.getLength()) {
                        if (!childnodes.item(y).getNodeName().equalsIgnoreCase("#text")) {
                            Node rightnode = childnodes.item(y);
                            String nodename = rightnode.getNodeName();
                            NamedNodeMap map = rightnode.getAttributes();
                            String nodevalue = map.getNamedItem("level").getNodeValue();
                            this.treemap.put(nodevalue, nodename);
                        }
                        ++y;
                    }
                }
                ++x;
            }
            ++i;
        }
        Collection col = this.treemap.values();
        Object[] obj = col.toArray();
        int i2 = 0;
        while (i2 < obj.length) {
            values.add(obj[i2]);
            ++i2;
        }
        return values;
    }

    public ArrayList getDisplayNames() throws Exception {
        ArrayList values = new ArrayList();
        try {
            NodeList ndlist = this.doc.getElementsByTagName("hierarchie");
            int i = 0;
            while (i < ndlist.getLength()) {
                TreeMap<String, String> sortmap = new TreeMap<String, String>();
                ArrayList<String> al = new ArrayList<String>();
                Node node = ndlist.item(i);
                NodeList childnodes = node.getChildNodes();
                int x = 0;
                while (x < childnodes.getLength()) {
                    if (childnodes.item(x).getNodeType() == 1) {
                        NamedNodeMap map = childnodes.item(x).getAttributes();
                        Node nd = map.getNamedItem("level");
                        Node displayname = map.getNamedItem("displayName");
                        sortmap.put(nd.getNodeValue(), displayname.getNodeValue());
                    }
                    ++x;
                }
                Collection coll = sortmap.values();
                al.add(node.getAttributes().getNamedItem("id").getNodeValue());
                Iterator itr = coll.iterator();
                while (itr.hasNext()) {
                    al.add((String)itr.next());
                }
                values.add(al);
                ++i;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return values;
    }

    public ArrayList getTagNames() throws Exception {
        ArrayList values = new ArrayList();
        try {
            NodeList ndlist = this.doc.getElementsByTagName("hierarchie");
            int i = 0;
            while (i < ndlist.getLength()) {
                TreeMap<String, String> sortmap = new TreeMap<String, String>();
                ArrayList<String> al = new ArrayList<String>();
                Node node = ndlist.item(i);
                NodeList childnodes = node.getChildNodes();
                int x = 0;
                while (x < childnodes.getLength()) {
                    if (childnodes.item(x).getNodeType() == 1) {
                        NamedNodeMap map = childnodes.item(x).getAttributes();
                        Node nd = map.getNamedItem("level");
                        Node displayname = map.getNamedItem("displayName");
                        sortmap.put(nd.getNodeValue(), childnodes.item(x).getNodeName());
                    }
                    ++x;
                }
                Collection coll = sortmap.values();
                al.add(node.getAttributes().getNamedItem("id").getNodeValue());
                Iterator itr = coll.iterator();
                while (itr.hasNext()) {
                    al.add((String)itr.next());
                }
                values.add(al);
                ++i;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return values;
    }

    private String getPreviousTag(String Id, String tname) throws Exception {
        String tag = "";
        int intval = 0;
        boolean found = false;
        NodeList ndlist = this.doc.getElementsByTagName("hierarchie");
        int i = 0;
        while (i < ndlist.getLength()) {
            Node node = ndlist.item(i);
            NamedNodeMap attr = node.getAttributes();
            Node idnode = attr.getNamedItem("id");
            if (idnode.getNodeValue().equalsIgnoreCase(Id)) {
                String value;
                NodeList childlist = node.getChildNodes();
                int y = 0;
                while (y < childlist.getLength()) {
                    if (childlist.item(y).getNodeType() == 1 && childlist.item(y).getNodeName().equalsIgnoreCase(tname)) {
                        value = childlist.item(y).getAttributes().getNamedItem("level").getNodeValue();
                        value = value.trim();
                        intval = Integer.parseInt(value);
                        --intval;
                        break;
                    }
                    ++y;
                }
                y = 0;
                while (y < childlist.getLength()) {
                    if (childlist.item(y).getNodeType() == 1) {
                        value = childlist.item(y).getAttributes().getNamedItem("level").getNodeValue();
                        if (intval == Integer.parseInt(value = value.trim())) {
                            found = true;
                            tag = childlist.item(y).getNodeName();
                            break;
                        }
                    }
                    ++y;
                }
            }
            ++i;
        }
        if (found) {
            return tag;
        }
        return null;
    }

    public String getNextDrillColumn(String drillFromLogicalName) throws Exception {
        String retValue = null;
        try {
            NodeList hierList = this.doc.getElementsByTagName("hierarchie");
            int i = 0;
            while (i < hierList.getLength()) {
                Node currHierNode = hierList.item(i);
                NodeList hierChildList = currHierNode.getChildNodes();
                int noOfChilds = hierChildList.getLength();
                int ctr = 0;
                block3: while (ctr < noOfChilds) {
                    if (hierChildList.item(ctr).getNodeType() == 1) {
                        BaseLogger.log("3", null, null, "Hierarchy child :" + hierChildList.item(ctr).getNodeName() + ":");
                        if (hierChildList.item(ctr).getNodeName().equalsIgnoreCase(drillFromLogicalName) && ctr + 1 != noOfChilds) {
                            int cctr = ctr + 1;
                            while (cctr < noOfChilds) {
                                if (hierChildList.item(cctr).getNodeType() == 1) {
                                    retValue = hierChildList.item(cctr).getNodeName();
                                    BaseLogger.log("3", null, null, "retValue :" + retValue + ":");
                                    break block3;
                                }
                                ++cctr;
                            }
                            break;
                        }
                    }
                    ++ctr;
                }
                if (retValue == null) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            retValue = null;
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return retValue;
    }

    public HashMap getHierarchieMap() throws Exception {
        try {
            HashMap hierMap = new HashMap();
            NodeList hierList = this.doc.getElementsByTagName("hierarchie");
            Node targetHier = null;
            int noOfHier = hierList.getLength();
            int i = 0;
            while (i < noOfHier) {
                ArrayList<String> colList = new ArrayList<String>();
                targetHier = hierList.item(i);
                String dimName = targetHier.getAttributes().getNamedItem("name").getNodeValue();
                NodeList hierChildList = targetHier.getChildNodes();
                int noOfChilds = hierChildList.getLength();
                int ctr = 0;
                while (ctr < noOfChilds) {
                    if (hierChildList.item(ctr).getNodeType() == 1) {
                        colList.add(hierChildList.item(ctr).getNodeName());
                    }
                    ++ctr;
                }
                hierMap.put(dimName, colList);
                ++i;
            }
            BaseLogger.log("3", null, null, "hierMap (getHierarchieMap):" + hierMap);
            return hierMap;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public String getPreviousDrillColumn(String drillFromLogicalName) throws Exception {
        String retValue = null;
        try {
            NodeList hierList = this.doc.getElementsByTagName("hierarchie");
            int i = 0;
            while (i < hierList.getLength()) {
                Node currHierNode = hierList.item(i);
                NodeList hierChildList = currHierNode.getChildNodes();
                int noOfChilds = hierChildList.getLength();
                int ctr = 0;
                block3: while (ctr < noOfChilds) {
                    if (hierChildList.item(ctr).getNodeType() == 1 && hierChildList.item(ctr).getNodeName().equalsIgnoreCase(drillFromLogicalName) && ctr - 1 >= 0) {
                        int cctr = ctr - 1;
                        while (cctr >= 0) {
                            if (hierChildList.item(cctr).getNodeType() == 1) {
                                retValue = hierChildList.item(cctr).getNodeName();
                                break block3;
                            }
                            --cctr;
                        }
                        break;
                    }
                    ++ctr;
                }
                if (retValue == null) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            retValue = null;
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return retValue;
    }
}

