package ibase.utility.training;

import java.io.File;
import java.io.FileOutputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;

import javax.annotation.PostConstruct;
import javax.naming.InitialContext;

import org.w3c.dom.Document;

import ibase.scheduler.ejb.BaseRegisteredEJB;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.BatchUploadFileLocal;
import ibase.webitm.ejb.BatchUploadFileRemote;
import ibase.webitm.ejb.MasterApplyEJB;
import ibase.webitm.utility.ITMException;

@javax.ejb.Stateless 
public class BatchUploadFileEJB extends BaseRegisteredEJB implements BatchUploadFileRemote,BatchUploadFileLocal //implements SessionBean 
{
		
	@PostConstruct
	public void ejbCreate()
	{
		try
		{
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}			
	}
	
	public String schedule( HashMap map )throws RemoteException, ITMException
	{
		return "";
	}
	public String schedulePriority( String wrkflwPriority )throws RemoteException, ITMException
	{
		return schedule("");
	}
	public String schedule( String scheduleParamXML )throws RemoteException, ITMException
	{		
		try
		{
			BaseLogger.log("3", null, null,"BatchUploadFileEJB : schedule() : scheduleParamXML["+scheduleParamXML+"]");
			batchUpload( scheduleParamXML );
		}
		catch(Exception e)
		{
			BaseLogger.log("3", null, null,"Exception : BatchUploadFileEJB :==>Schedule()");
			e.printStackTrace();
		}
		return "";
	}
	public void batchUpload( String scheduleParamXML ) throws Exception
	{
		BaseLogger.log("2", null, null,"BatchUploadFileEJB : batchUpload( )");
		Connection connection = null;
		Statement statement = null;
		ResultSet resultSet = null;
		String batchId = null;
		ibase.utility.UserInfoBean userInfoBean = new ibase.utility.UserInfoBean( scheduleParamXML );
		String objName="";
		String query="";
		String transDB = "";
		try 
		{
			E12GenericUtility genericUtility= new E12GenericUtility();
			BaseLogger.log("3", null, null,"scheduleParamXML-----"+scheduleParamXML);
			ConnDriver mConnDriver = new ConnDriver();
			//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
			transDB = userInfoBean.getTransDB();
			connection = mConnDriver.getConnectDB(transDB);
			Document dom=genericUtility.parseString(scheduleParamXML);
			//Condition Added By Manoj 25/01/2013 to load batch Win Name wise.
			objName=genericUtility.getColumnValue("ACTUALPARAMETER",dom);
			if(objName==null)
			{
				//Changed By Mahesh Patidar on 23-SEP-13[to avoid batchloading if tran_id_ref is not null]
//				query = "SELECT BATCH_ID FROM BATCHLOAD WHERE LOAD_STAT = 'N' ";
//old sql		query = "SELECT BATCH_ID FROM BATCHLOAD WHERE LOAD_STAT = 'N' AND TRAN_ID__REF IS NULL ";
				query=  "SELECT BATCH_ID FROM BATCHLOAD WHERE (LOAD_STAT ='N' OR ERROR_MSG LIKE '%File not found%') AND RETRY_CTR < 3";
				//Ended By Mahesh Patidar on 23-SEP-13[to avoid batchloading if tran_id_ref is not null]
			}
			else
			{
				//Changed By Mahesh Patidar on 23-SEP-13[to avoid batchloading if tran_id_ref is not null]
//				query = "SELECT BATCH_ID FROM BATCHLOAD WHERE LOAD_STAT = 'N' and WIN_NAME='"+objName+"'";
//OLD SQL		query = "SELECT BATCH_ID FROM BATCHLOAD WHERE LOAD_STAT = 'N' and WIN_NAME='"+objName+"'  AND TRAN_ID__REF IS NULL ";
				query="SELECT BATCH_ID FROM BATCHLOAD WHERE LOAD_STAT = 'N' AND WIN_NAME='"+objName+"' AND RETRY_CTR < 3";
				//Ended By Mahesh Patidar on 23-SEP-13[to avoid batchloading if tran_id_ref is not null]
			}
			BaseLogger.log("3", null, null,"Query executed [" + query + "]");
			statement = connection.createStatement();
			resultSet = statement.executeQuery( query );
			String xtraParams = null;
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext ctx = new InitialContext ( appConnect.getProperty() );
			//MasterApplyEJBLocal masterApplyLocal = ( MasterApplyEJBLocal ) ctx.lookup("ibase/MasterApplyEJB/local");
			MasterApplyEJB masterApplyEJB = new MasterApplyEJB();
			while( resultSet.next())
			{
				batchId = resultSet.getString( "BATCH_ID" );
				try 
				{
					masterApplyEJB.applyMasterTable( batchId, xtraParams, userInfoBean );
					masterApplyEJB = null;
				}
				catch (Exception e) 
				{
					e.printStackTrace();
					FileOutputStream fileOutputStream = new FileOutputStream( CommonConstants.JBOSSHOME + File.separator +"LOG"+File.separator+userInfoBean.getEmpCode()+"_"+batchId+"_BatchUpload.log" );
					byte convertStringToByte[] = e.toString().getBytes();
					fileOutputStream.write( convertStringToByte );
					fileOutputStream.close( );
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			if(resultSet != null)
			{
				resultSet.close();
				resultSet = null;
			}
			if(statement != null)
			{
				statement.close();
				statement = null;
			}
			if(connection != null)
			{
				connection.close();
				connection = null;
			}
		}
	}
	
}