/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.notification.ejb;

import ibase.bean.UserSessionInfoBean;
import ibase.sessionnotification.ClientWebsocketNotification;
import ibase.system.config.ConnDriver;
import ibase.utility.ApplicationTO;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.notification.bean.AndroidNotification;
import ibase.webitm.notification.bean.IOSNotification;
import ibase.webitm.notification.bean.NotifiactionMetadata;
import ibase.webitm.notification.ejb.NotificationEJB;
import ibase.webitm.notification.ejb.NotificationMessage;
import ibase.webitm.notification.ejb.PublishPushNotificationLocal;
import ibase.webitm.notification.ejb.PublishPushNotificationRemote;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.ejb.Stateless;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

@Stateless
public class PublishPushNotificationEJB
implements PublishPushNotificationLocal,
PublishPushNotificationRemote {
    private HashMap<String, HashMap<String, String>> deviceAppIDMap = new HashMap();

    @Override
    public void invockPushNotification(String message, String postOwnerName, String openTarget, String tranId, ArrayList<String> userIdList, String xmlData, UserInfoBean userInfoBean) throws RemoteException, ITMException {
        try {
            this.invockPushNotification(message, postOwnerName, openTarget, tranId, userIdList, xmlData, null, null, null, 0, userInfoBean);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    @Override
    @Deprecated
    public void invockPushNotification(String message, String postOwnerName, String openTarget, String tranId, ArrayList<String> userIdList, String xmlData, String refId, String refSer, String currentUserID, int lineNo, UserInfoBean userInfoBean) throws RemoteException, ITMException {
        BaseLogger.log("2", null, "PublishPushNotificationEJB.invockPushNotification(args.length=11)", "Calling deprecated method for sending notifications");
        try {
            this.invockPushNotification(message, postOwnerName, openTarget, tranId, userIdList, xmlData, refId, refSer, currentUserID, lineNo, null, userInfoBean);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    @Override
    public void invockPushNotification(String message, String postOwnerName, String openTarget, String tranId, ArrayList<String> userIdList, String xmlData, String refId, String refSer, String currentUserID, int lineNo, String notificationType, UserInfoBean userInfoBean) throws RemoteException, ITMException {
        try {
            this.invockPushNotification(message, postOwnerName, openTarget, tranId, userIdList, xmlData, refId, refSer, currentUserID, lineNo, notificationType, userInfoBean, null, CommonConstants.WebSocketMessageType.GROUP_POST);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void invockPushNotification(String message, String postOwnerName, String openTarget, String tranId, ArrayList<String> userIdList, String xmlData, String refId, String refSer, String currentUserID, int lineNo, String notificationType, UserInfoBean userInfoBean, String notificationOption, CommonConstants.WebSocketMessageType type) throws RemoteException, ITMException {
        BaseLogger.log("2", null, null, "Notification Option [" + notificationOption + "] CommonConstants.NOTIFICATION_OPT [" + CommonConstants.NOTIFICATION_OPT + "] openTarget [" + openTarget + "]");
        BaseLogger.log("2", null, null, "Type [" + String.valueOf((Object)type) + "]");
        boolean sendDeviceNotification = false;
        if (!"1".equals(notificationOption) && ("0".equals(CommonConstants.NOTIFICATION_OPT) || "2".equals(CommonConstants.NOTIFICATION_OPT))) {
            sendDeviceNotification = true;
        }
        BaseLogger.log("3", null, null, "Android/IOS Noti [" + sendDeviceNotification + "]");
        if ("0".equals(CommonConstants.NOTIFICATION_OPT) || "1".equals(CommonConstants.NOTIFICATION_OPT)) {
            org.json.JSONObject wsMessage = new org.json.JSONObject();
            JSONArray userIds = new JSONArray(userIdList);
            try {
                String wsMessageStr = String.valueOf(postOwnerName) + "~" + message + "~" + xmlData;
                wsMessage.put("user_ids", (Object)userIds);
                org.json.JSONObject webSocketMsgWithType = new org.json.JSONObject();
                webSocketMsgWithType.put("type", (Object)String.valueOf((Object)type));
                webSocketMsgWithType.put("data", (Object)wsMessageStr);
                wsMessage.put("message", (Object)webSocketMsgWithType);
                BaseLogger.log("2", null, null, "wsMessageStr [" + wsMessageStr + "]");
                ClientWebsocketNotification clientWebsocketNotification = new ClientWebsocketNotification();
                clientWebsocketNotification.sendMessage(wsMessage);
            }
            catch (JSONException ex) {
                BaseLogger.log("0", null, null, "Exception in PublishPushNotificationEJB.invockPushNotification() : " + (Object)((Object)ex));
            }
        }
        BaseLogger.log("3", null, null, "@@@@@ PublishPushNotificationEJB :: invockPushNotification() : tranId[" + tranId + "] userIdList[" + userIdList + "] notificationType [" + notificationType + "]");
        if (sendDeviceNotification) {
            notificationType = this.checkNull(notificationType).length() > 0 ? notificationType : "";
            NotifiactionMetadata notifyMetadataSession = new NotifiactionMetadata(openTarget, tranId);
            notifyMetadataSession.setMessage(message);
            notifyMetadataSession.setXMLData(xmlData);
            notifyMetadataSession.setUserName(postOwnerName);
            NotifiactionMetadata notifyMetadataAndroid = new NotifiactionMetadata(openTarget, tranId);
            notifyMetadataAndroid.setMessage(message);
            notifyMetadataAndroid.setXMLData(xmlData);
            notifyMetadataAndroid.setUserName(postOwnerName);
            notifyMetadataAndroid.setNotificationType(notificationType);
            NotifiactionMetadata notifyMetadataIOS = new NotifiactionMetadata(openTarget, tranId);
            notifyMetadataIOS.setMessage(message);
            notifyMetadataIOS.setXMLData(xmlData);
            notifyMetadataIOS.setUserName(postOwnerName);
            notifyMetadataIOS.setNotificationType(notificationType);
            ArrayList<String> userSessionUserList = new ArrayList<String>();
            ArrayList<String> userSessionUserDeviceIDList = new ArrayList<String>();
            HashMap applLevUserInfo = ApplicationTO.getApplLevUserInfo();
            if (applLevUserInfo != null && applLevUserInfo.size() > 0) {
                for (String userInfoMap : applLevUserInfo.keySet()) {
                    UserSessionInfoBean sbi = (UserSessionInfoBean)applLevUserInfo.get(userInfoMap);
                    String userID = userInfoMap.split(":")[0];
                    String deviceId = sbi.getDeviceId();
                    if (this.checkNull(deviceId).length() <= 0) continue;
                    userSessionUserDeviceIDList.add(deviceId);
                    userSessionUserList.add(userID);
                }
            }
            BaseLogger.log("3", null, null, "@@@@@@@userSessionUserDeviceIDList:" + userSessionUserDeviceIDList);
            BaseLogger.log("3", null, null, "@@@@@@@userSessionUserList:" + userSessionUserList);
            BaseLogger.log("3", null, null, "@@@@@@@userIdList:" + userIdList);
            ArrayList<HashMap<String, String>> notificationInfo = this.getDeviceInfoFromDB(userIdList);
            BaseLogger.log("3", null, null, "@@@@@@@ notificationInfo : [" + notificationInfo + "]");
            HashMap<String, HashMap<String, String>> userWiseNotificationDataMap = this.getDeviceAppIdDataMapFromDB(userIdList);
            BaseLogger.log("3", null, null, "@@@@@@@ userWiseNotificationDataMap : [" + userWiseNotificationDataMap + "]");
            ArrayList<String> userDeviceList = this.getUserDeviceList(notificationInfo);
            BaseLogger.log("3", null, null, "@@@@@@@ userDeviceList : [" + userDeviceList + "]");
            List<Object> userUUIdList = new ArrayList();
            if (!"".equals(E12GenericUtility.checkNull(refId)) || "D".equalsIgnoreCase(openTarget) || "V".equalsIgnoreCase(openTarget)) {
                NotificationMessage notificationMessage = new NotificationMessage();
                notificationMessage.setId(new Date().getTime());
                notificationMessage.setMessage(message);
                notificationMessage.setFromCode(currentUserID);
                notificationMessage.setTime(new Timestamp(new Date().getTime()));
                notificationMessage.setRefId(refId);
                notificationMessage.setRefSer(refSer);
                notificationMessage.setLineNo(lineNo);
                notificationMessage.setMsgOrigin(openTarget);
                notificationMessage.setXmlData(xmlData);
                try {
                    NotificationEJB notificationEJB = new NotificationEJB();
                    if (userIdList != null && userIdList.size() > 0) {
                        userUUIdList = notificationEJB.saveNotificationMessagesForUsers(notificationMessage, userDeviceList, notificationType);
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception while saving notification message::: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            for (HashMap<String, String> hashMap : notificationInfo) {
                if (hashMap == null) continue;
                String deviceOS = hashMap.get("deviceOs");
                String userId = hashMap.get("userId");
                String pushDeviceTokenId = hashMap.get("deviceIdPush");
                String deviceAppId = hashMap.get("deviceAppId");
                deviceAppId = E12GenericUtility.checkNull(deviceAppId);
                BaseLogger.log("3", null, null, "----userId[" + userId + "]----");
                BaseLogger.log("3", null, null, "----DeviceOS[" + deviceOS + "]----");
                BaseLogger.log("3", null, null, "----pushDeviceTokenId[" + pushDeviceTokenId + "]----");
                BaseLogger.log("3", null, null, "----deviceAppId[" + deviceAppId + "]----");
                String uuId = "";
                for (String string : userUUIdList) {
                    if (!string.startsWith(pushDeviceTokenId.trim())) continue;
                    int lastIndex = string.lastIndexOf(":");
                    uuId = string.substring(lastIndex + 1, string.length());
                }
                if (notificationType.equals("C") && userSessionUserDeviceIDList.size() > 0 && !userSessionUserDeviceIDList.contains(String.valueOf(userId.trim()) + pushDeviceTokenId) || userId.trim().equals(userInfoBean.getLoginCode()) && !"D".equalsIgnoreCase(openTarget) && !"V".equalsIgnoreCase(openTarget) && !"C".equalsIgnoreCase(openTarget)) continue;
                BaseLogger.log("3", null, null, String.valueOf(userId) + "----notifyMetadataAndroid 242----");
                if ("Android".equalsIgnoreCase(deviceOS) && pushDeviceTokenId != null && !"".equals(pushDeviceTokenId)) {
                    notifyMetadataAndroid.setPushDeviceTokenId(String.valueOf(userId) + pushDeviceTokenId, pushDeviceTokenId);
                    notifyMetadataAndroid.setUserId(userId);
                    notifyMetadataAndroid.setUuid(uuId);
                    if (userWiseNotificationDataMap != null && userWiseNotificationDataMap.size() > 0) {
                        userId = E12GenericUtility.checkNull(userId);
                        pushDeviceTokenId = E12GenericUtility.checkNull(pushDeviceTokenId);
                        String string = String.valueOf(userId) + "~" + pushDeviceTokenId + "~" + deviceAppId;
                        notifyMetadataAndroid.setDeviceAppIdDataMap(userWiseNotificationDataMap.get(string));
                    }
                    if ("D".equalsIgnoreCase(openTarget) || "V".equalsIgnoreCase(openTarget)) {
                        void var33_42;
                        String string = "";
                        if ("V".equalsIgnoreCase(openTarget)) {
                            String string2 = this.generateNewJsonDataForDatamodel(xmlData, userId, userInfoBean);
                        } else {
                            String string3 = this.generateNewXmlDataForDatamodel(xmlData, userId, userInfoBean);
                        }
                        if (!"".equalsIgnoreCase(this.checkNull((String)var33_42))) {
                            notifyMetadataAndroid.setXMLData((String)var33_42);
                        }
                    }
                    BaseLogger.log("3", null, null, String.valueOf(userId) + "----notifyMetadataAndroid uuId[" + uuId + "]----");
                    AndroidNotification androidNotification = new AndroidNotification();
                    androidNotification.publish(notifyMetadataAndroid);
                    continue;
                }
                if (!"IOS".equalsIgnoreCase(deviceOS) || pushDeviceTokenId == null || "".equals(pushDeviceTokenId)) continue;
                notifyMetadataIOS.setPushDeviceTokenId(String.valueOf(userId) + pushDeviceTokenId, pushDeviceTokenId);
                notifyMetadataIOS.setUserId(userId);
                notifyMetadataIOS.setUuid(uuId);
                BaseLogger.log("3", null, null, String.valueOf(userId) + "----notifyMetadataIOS uuId[" + uuId + "]----");
                if (userWiseNotificationDataMap != null && userWiseNotificationDataMap.size() > 0) {
                    userId = E12GenericUtility.checkNull(userId);
                    pushDeviceTokenId = E12GenericUtility.checkNull(pushDeviceTokenId);
                    String string = String.valueOf(userId) + "~" + pushDeviceTokenId + "~" + deviceAppId;
                    notifyMetadataIOS.setDeviceAppIdDataMap(userWiseNotificationDataMap.get(string));
                }
                IOSNotification iOSNotification = new IOSNotification();
                iOSNotification.publish(notifyMetadataIOS);
            }
        }
    }

    public ArrayList<HashMap<String, String>> getDeviceInfoFromDB(ArrayList<String> userIdList) throws ITMException {
        ArrayList<HashMap<String, String>> notificationInfo = new ArrayList<HashMap<String, String>>();
        if (userIdList.size() == 0) {
            return notificationInfo;
        }
        StringBuilder inParamSB = new StringBuilder();
        for (String userId : userIdList) {
            inParamSB.append("'").append(userId).append("', ");
        }
        String inParam = inParamSB.substring(0, inParamSB.lastIndexOf(","));
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean isError = false;
        StringBuilder sql = new StringBuilder();
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB("Driver");
                BaseLogger.log("3", null, null, "-----Creating connection-----");
                conn.setAutoCommit(false);
                BaseLogger.log("3", null, null, "-----Prparing Query-----");
                sql.append("SELECT USER_ID, DEVICE_ID__PUSH, DEVICE_OS, DEVICE_TYPE, APP_ID FROM USER_DEVICE WHERE ACTIVE = 'Y' AND USER_ID IN (" + inParam + ") ");
                pstmt = conn.prepareStatement(sql.toString());
                BaseLogger.log("3", null, null, "-----Executing Query-----");
                rs = pstmt.executeQuery();
                BaseLogger.log("3", null, null, "-----Query Executed-----");
                while (rs.next()) {
                    HashMap<String, String> notificationData = new HashMap<String, String>();
                    notificationData.put("userId", rs.getString("USER_ID"));
                    String deviceId = E12GenericUtility.checkNull(rs.getString("DEVICE_ID__PUSH"));
                    deviceId = deviceId.indexOf("SEPARATOR") != -1 ? deviceId.substring(0, deviceId.indexOf("SEPARATOR")) : deviceId;
                    notificationData.put("deviceIdPush", deviceId);
                    notificationData.put("deviceOs", rs.getString("DEVICE_OS"));
                    notificationData.put("deviceType", rs.getString("DEVICE_TYPE"));
                    notificationData.put("deviceAppId", rs.getString("APP_ID"));
                    notificationInfo.add(notificationData);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null && !conn.isClosed()) {
                    BaseLogger.log("3", null, null, "@V@ Finaly conn not close");
                    if (!isError) {
                        BaseLogger.log("3", null, null, "@V@ Commiting connection");
                        conn.commit();
                    } else {
                        BaseLogger.log("3", null, null, "@V@ Connection rollback");
                        conn.rollback();
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "@V@ finaly excep:-" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return notificationInfo;
    }

    public ArrayList<String> getUserDeviceList(ArrayList<HashMap<String, String>> userMap) {
        ArrayList<String> userDeviceList = new ArrayList<String>();
        for (HashMap<String, String> hashMap : userMap) {
            if (hashMap == null) continue;
            String userId = hashMap.get("userId");
            String pushDeviceTokenId = hashMap.get("deviceIdPush");
            userDeviceList.add(String.valueOf(userId.trim()) + ":" + pushDeviceTokenId);
        }
        return userDeviceList;
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    @Override
    public void invockPushNotification(String message, String postOwnerName, String openTarget, String tranId, ArrayList<String> userId, String xmlData, String refId, String refSer, String currentUserID, int lineNo, String notificationType, String notificationOption, UserInfoBean userInfoBean) throws RemoteException, BaseException {
        this.invockPushNotification(message, postOwnerName, openTarget, tranId, userId, xmlData, refId, refSer, currentUserID, lineNo, notificationType, userInfoBean, notificationOption, CommonConstants.WebSocketMessageType.DEFAULT);
    }

    public String generateNewXmlDataForDatamodel(String dataModelName, String userCode, UserInfoBean userInfoBean) {
        StringBuilder xmlData;
        block20: {
            Connection conn = null;
            ResultSet rs = null;
            PreparedStatement pstmt = null;
            xmlData = new StringBuilder();
            xmlData.append("<Root>").append("<DATAMODEL_NAME><![CDATA[").append(dataModelName).append("]]></DATAMODEL_NAME>");
            xmlData.append("<OPEN_TARGET><![CDATA[").append("D").append("]]></OPEN_TARGET>");
            xmlData.append("<USER_CODE><![CDATA[").append(this.checkNull(userCode)).append("]]></USER_CODE>");
            try {
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(userInfoBean.getTransDB());
                BaseLogger.log("3", null, null, "-----Creating connection-----");
                conn.setAutoCommit(false);
                BaseLogger.log("3", null, null, "-----Prparing Query-----");
                String selectSql = "SELECT DU.SCOPE_KEY,DM.SYNC_DATA_MODEL FROM DATA_MODEL_USER DU INNER JOIN DATA_MODEL DM ON DU.DATA_MODEL = ? AND DU.USER_CODE = ? AND DM.DATA_MODEL = DU.DATA_MODEL";
                pstmt = conn.prepareStatement(selectSql);
                pstmt.setString(1, dataModelName);
                pstmt.setString(2, this.checkNull(userCode));
                BaseLogger.log("3", null, null, "-----Executing Query-----");
                rs = pstmt.executeQuery();
                BaseLogger.log("3", null, null, "-----Query Executed-----");
                while (rs.next()) {
                    String scopeValue = this.checkNull(rs.getString("SCOPE_KEY"));
                    String syncDataModel = this.checkNull(rs.getString("SYNC_DATA_MODEL"));
                    if ("".equalsIgnoreCase(syncDataModel)) {
                        syncDataModel = "0";
                    }
                    xmlData.append("<SCOPE_PARAMETERS><![CDATA[").append(this.checkNull(scopeValue)).append("]]></SCOPE_PARAMETERS>");
                    xmlData.append("<SYNC_DATA_MODEL><![CDATA[").append(syncDataModel).append("]]></SYNC_DATA_MODEL>");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "SQLException inside generateNewXmlDataForDatamodel " + e);
                try {
                    if (conn != null && !conn.isClosed()) {
                        conn.close();
                        conn = null;
                    }
                    break block20;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    BaseLogger.log("0", null, null, "Exception inside generateNewXmlDataForDatamodel " + e2);
                }
                break block20;
            }
            catch (Exception e) {
                try {
                    BaseLogger.log("0", null, null, "Exception inside generateNewXmlDataForDatamodel " + e);
                    break block20;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (conn != null && !conn.isClosed()) {
                            conn.close();
                            conn = null;
                        }
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                        BaseLogger.log("0", null, null, "Exception inside generateNewXmlDataForDatamodel " + e3);
                    }
                }
            }
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "Exception inside generateNewXmlDataForDatamodel " + e);
            }
        }
        xmlData.append("</Root>");
        BaseLogger.log("2", null, null, "response from generateNewXmlDataForDatamodel " + xmlData.toString());
        return xmlData.toString();
    }

    private String generateNewJsonDataForDatamodel(String jsonString, String userCode, UserInfoBean userInfoBean) {
        org.json.JSONObject jsonData = new org.json.JSONObject();
        try {
            org.json.JSONObject jsonObj = new org.json.JSONObject(jsonString);
            BaseLogger.log("3", null, null, "jsonData :: " + jsonObj.length());
            jsonData.put("NOTIFICATION_RESP", (Object)jsonObj);
            jsonData.put("OPEN_TARGET", (Object)"V");
            jsonData.put("USER_CODE", (Object)userCode);
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Exception in generateNewJsonDataForDatamodel" + e.getMessage());
        }
        return jsonData.toString();
    }

    public HashMap<String, HashMap<String, String>> getDeviceAppIdDataMapFromDB(ArrayList<String> userIdList) throws ITMException {
        HashMap<String, HashMap<String, String>> userWiseNotificationDataMap = new HashMap<String, HashMap<String, String>>();
        if (userIdList.size() == 0) {
            return userWiseNotificationDataMap;
        }
        StringBuilder inParamSB = new StringBuilder();
        for (String userId : userIdList) {
            inParamSB.append("'").append(userId).append("', ");
        }
        String inParam = inParamSB.substring(0, inParamSB.lastIndexOf(","));
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean isError = false;
        StringBuilder sql = new StringBuilder();
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB("Driver");
                BaseLogger.log("3", null, null, "-----Creating connection-----");
                conn.setAutoCommit(false);
                BaseLogger.log("3", null, null, "-----Prparing Query-----");
                sql.append("SELECT USER_ID, DEVICE_ID__PUSH, APP_ID FROM USER_DEVICE WHERE ACTIVE = 'Y' AND USER_ID IN (" + inParam + ") ");
                pstmt = conn.prepareStatement(sql.toString());
                BaseLogger.log("3", null, null, "-----Executing Query-----");
                rs = pstmt.executeQuery();
                BaseLogger.log("3", null, null, "-----Query Executed-----");
                while (rs.next()) {
                    String userID = E12GenericUtility.checkNull(rs.getString("USER_ID"));
                    String deviceAppID = E12GenericUtility.checkNull(rs.getString("APP_ID"));
                    String deviceId = E12GenericUtility.checkNull(rs.getString("DEVICE_ID__PUSH"));
                    deviceId = deviceId.indexOf("SEPARATOR") != -1 ? deviceId.substring(0, deviceId.indexOf("SEPARATOR")) : deviceId;
                    BaseLogger.log("3", null, null, "[getDeviceAppIdDataMapFromDB] deviceAppID::[" + deviceAppID + "]");
                    if (deviceAppID.length() <= 0) continue;
                    this.readPushNotificationJSONFile(deviceAppID, deviceId, userID, userWiseNotificationDataMap);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null && !conn.isClosed()) {
                    BaseLogger.log("3", null, null, "@V@ Finaly conn not close");
                    if (!isError) {
                        BaseLogger.log("3", null, null, "@V@ Commiting connection");
                        conn.commit();
                    } else {
                        BaseLogger.log("3", null, null, "@V@ Connection rollback");
                        conn.rollback();
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "@V@ finaly excep:-" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return userWiseNotificationDataMap;
    }

    public HashMap<String, HashMap<String, String>> readPushNotificationJSONFile(String deviceAppID, String pushDeviceTokenId, String userID, HashMap<String, HashMap<String, String>> userWiseNotificationDataMap) {
        HashMap<String, String> appIDDataMAP = new HashMap<String, String>();
        JSONParser jsonParser = new JSONParser();
        String suffix = ".json";
        try {
            userID = E12GenericUtility.checkNull(userID);
            pushDeviceTokenId = E12GenericUtility.checkNull(pushDeviceTokenId);
            deviceAppID = E12GenericUtility.checkNull(deviceAppID);
            String pushNotificationAppIdkey = String.valueOf(userID) + "~" + pushDeviceTokenId + "~" + deviceAppID;
            deviceAppID = deviceAppID.substring(deviceAppID.lastIndexOf(".") + 1);
            BaseLogger.log("3", null, null, "[readPushNotificationJSON] deviceAppID::[" + deviceAppID + "]");
            if (this.deviceAppIDMap.containsKey(deviceAppID)) {
                HashMap<String, String> map = this.deviceAppIDMap.get(deviceAppID);
                userWiseNotificationDataMap.put(pushNotificationAppIdkey, map);
                return userWiseNotificationDataMap;
            }
            String fileName = String.valueOf(deviceAppID) + "-" + "push-notification" + suffix;
            BaseLogger.log("3", null, null, "[readPushNotificationJSON] fileName::[" + fileName + "]");
            String filePath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + fileName;
            BaseLogger.log("3", null, null, "[readPushNotificationJSON] filePath::[" + filePath + "]");
            File file = new File(filePath);
            if (!file.exists()) {
                BaseLogger.log("3", null, null, "[readPushNotificationJSON] File not exists.");
                return userWiseNotificationDataMap;
            }
            FileReader fileReader = new FileReader(file);
            Object object = jsonParser.parse((Reader)fileReader);
            JSONObject pushNotificationJson = (JSONObject)object;
            if (pushNotificationJson != null && pushNotificationJson.size() > 0) {
                for (String pushNotificationkey : pushNotificationJson.keySet()) {
                    if (pushNotificationJson.get((Object)pushNotificationkey) == null) continue;
                    String pushNotificationValue = (String)pushNotificationJson.get((Object)pushNotificationkey);
                    appIDDataMAP.put(pushNotificationkey, pushNotificationValue);
                }
                if (appIDDataMAP.size() > 0) {
                    userWiseNotificationDataMap.put(pushNotificationAppIdkey, appIDDataMAP);
                }
                this.deviceAppIDMap.put(deviceAppID, appIDDataMAP);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("3", null, null, "[readPushNotificationJSON] Exception is::[" + e + "]");
        }
        return userWiseNotificationDataMap;
    }
}

