package ibase.bankIntegration.scheduledSFTP;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.json.JsonObject;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.bankIntegration.CommonMethods;
import ibase.bankIntegration.unsHsbc.SFTPFileUploader;
import ibase.bankIntegration.unsHsbc.UNSHSBC;
import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;

public class ScheduledSFTPUploader implements Schedule {
	
	E12GenericUtility e12GenericUtility = new E12GenericUtility();
	boolean bankCodeBool = false;
	String formattedTime="";
	String bankCode = "";
	String scheduleId="";

	UserInfoBean userInfoGlobal = new UserInfoBean();
	NodeList argNodeList = null;

	@Override
	public String schedule(HashMap arg0) throws Exception {
		return null;
	}

	@Override
	public String schedule(String name) throws Exception {
		BaseLogger.log("3", null, null, "ScheduledSFTPUploader gsb calling test 29-jan------------------");
		BaseLogger.log("3", null, null, "name::[ " + name + " ]");

		Document schdulerInfoDocument = e12GenericUtility.parseString(name);
		
		NodeList scheduleList = schdulerInfoDocument.getElementsByTagName("SCHEDULE");
        if (scheduleList.getLength() > 0) {
            Element scheduleElement = (Element) scheduleList.item(0);
            String idValue = scheduleElement.getAttribute("id");
            scheduleId = idValue; 
            System.out.println("scheduleId value:: " + idValue);
        }
		
		UserInfoBean userInfo = new UserInfoBean(e12GenericUtility.serializeDom(
				schdulerInfoDocument.getElementsByTagName("USERINFOXML").item(0).getChildNodes().item(0)));
		userInfoGlobal = userInfo;

		argNodeList = schdulerInfoDocument.getElementsByTagName("ACTUALPARAMETER");
		for (int i = 0; i < argNodeList.getLength(); i++) {
			Node childNode = argNodeList.item(i);
			if (childNode.getNodeType() != Node.ELEMENT_NODE) {
				continue;
			}
			if (childNode != null) {
				System.out.println("childNode gsb=[" + childNode + "]");
				bankCodeBool = isParameterPresent(childNode, "BANK_CODE");

				if (bankCodeBool) {
					if (childNode.getAttributes().getNamedItem("name").getNodeValue().equalsIgnoreCase("BANK_CODE")) {
						bankCode = E12GenericUtility.checkNull(childNode.getFirstChild().getNodeValue());
						System.out.println("BankCode = [" + bankCode + "]");
					}
				}
			}
		}
		
		String uploadFileToSFTPResult = "";
		CommonMethods commonMethods= new CommonMethods();
		
		DBAccessEJB dbAccessEJB = new DBAccessEJB();
		String payIntArgs = dbAccessEJB.getDBColumnValue("BANK", "PAY_INT_ARGS", "BANK_CODE  = '" + bankCode + "'",
				userInfo.getTransDB());
		BaseLogger.log("3", null, null, "Inside actionHandler generateXML.. payIntArgs[ " + payIntArgs + "]");
		JsonObject payIntArgsJSON = CommonMethods.parseJsonString(payIntArgs);
		String localFolderPath = CommonMethods.getValueFromJson(payIntArgsJSON, "bank_specific_folder");
		localFolderPath = localFolderPath + File.separator + "XML_files";
		BaseLogger.log("3", null, null, "Inside localFolderPath[ " + localFolderPath + "]");
	
		//to count files uploaded 
		int fileCount = 0;
		File localFolder = new File(localFolderPath);

		if (localFolder.exists() && localFolder.isDirectory()) {
		    File[] files = localFolder.listFiles((directory, fileName) -> fileName.endsWith(".xml")); 
		    if (files != null) {
		        fileCount = files.length-1; //(-1) due to templeate xml aleready present
		    }
		}
		
		//count files which confirmed in misc_payment table 
		BaseLogger.log("3", null, null, "Number of XML files in the local folder: " + fileCount);
		
		// Timestamp  when  uploadFileToSFTP()  called 
			LocalDateTime currentTime = LocalDateTime.now();
			DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
			String	formattedTime = currentTime.format(formatter); 
			BaseLogger.log("3", null, null, "File uploaded at Time : " + formattedTime);
			Timestamp startingTimestamp = getStartingTimestamp(scheduleId,userInfo);
			BaseLogger.log("3", null, null, "startingTimestampTime : " + startingTimestamp);

		
		int count = getConfirmedTransactionCount(scheduleId, userInfo, formattedTime);
		BaseLogger.log("3", null, null, "Trancasction confirm in misc_payment table Count: " + count);

		Timestamp currentTimestamp = new Timestamp(System.currentTimeMillis());
		if (fileCount ==count) {
			uploadFileToSFTPResult = commonMethods.uploadFileToSFTP(bankCode, userInfo);

		}
		else if (fileCount < count) {
		   BaseLogger.log("3", null, null, "Calling processMissingFiles at: " + currentTimestamp);
		   boolean processMissingFilesResult=  processMissingFiles(localFolderPath, startingTimestamp, currentTimestamp, userInfo);
		  if(processMissingFilesResult)
		   {
			  uploadFileToSFTPResult = commonMethods.uploadFileToSFTP(bankCode, userInfo);
		   }
		  else {
		        BaseLogger.log("3", null, null, "Process failed....");
		    }
		    
		}
		System.out.println("uploadFileToSFTPResult gsb=[" + uploadFileToSFTPResult + "]");
		
		return null;
	}
		
		
		@Override
		public String schedulePriority(String arg0) throws Exception {
			return null;
		}

		private boolean isParameterPresent(Node childNode, String attribName) throws ITMException {
			boolean attribFound = false;
			try {
				System.out.println("attribFound test= [" + childNode.getAttributes() + "]");
				if (childNode != null && childNode.getAttributes() != null) {
					System.out.println(
							"attribFound name= [" + childNode.getAttributes().getNamedItem("name").getNodeValue() + "]");
					if (childNode.getAttributes().getNamedItem("name").getNodeValue().equalsIgnoreCase(attribName)) {
						attribFound = true;
					}
				}

			} catch (Exception e) {
				throw new ITMException(e);
			}
			System.out.println("attribFound = [" + attribFound + "]");
			return attribFound;
		}
		
	    // Method Added by Amol S on 23-Jan to identify the starting time stamp of schId --Start
		 public Timestamp getStartingTimestamp(String scheduleId, UserInfoBean userInfo) throws Exception {
             BaseLogger.log("3", null, null, "Inside the method getStartingTimestamp:: 	");

		        Connection connection = null;
		        PreparedStatement preparedStatement = null;
		        ResultSet resultSet = null;
		        Timestamp startingTimestamp = null;
		        try {
		            // Obtain a connection
		            ConnDriver connDriver = new ConnDriver();
		            String transDB = userInfo.getTransDB();
		            connection = connDriver.getConnectDB(transDB);

		            // Define the query
		            String query = "SELECT LAST_EXE_DATE " +
		                           "FROM schedule_log " +
		                           "WHERE SCH_ID = ? " +
		                           "ORDER BY LAST_EXE_DATE DESC " +
		                           "FETCH FIRST 1 ROW ONLY";

		            // Prepare the statement
		            preparedStatement = connection.prepareStatement(query);
		            preparedStatement.setString(1, scheduleId);

		            // Execute the query and process the result
		            resultSet = preparedStatement.executeQuery();
		            if (resultSet.next()) {
		                startingTimestamp = resultSet.getTimestamp("LAST_EXE_DATE");
		            }
		        } catch (Exception e) {
		            BaseLogger.log("3", null, null, "Error in getStartingTimestamp: [" + E12GenericUtility.getStackTrace(e) + "]");
		            throw new Exception("Error fetching the starting timestamp: " + e.getMessage(), e);
		        } finally {
		            if (resultSet != null) {
		                try {
		                    resultSet.close();
		                } catch (Exception e) {
		                    BaseLogger.log("3", null, null, "Error closing ResultSet: [" + E12GenericUtility.getStackTrace(e) + "]");
		                }
		            }
		            if (preparedStatement != null) {
		                try {
		                    preparedStatement.close();
		                } catch (Exception e) {
		                    BaseLogger.log("3", null, null, "Error closing PreparedStatement: [" + E12GenericUtility.getStackTrace(e) + "]");
		                }
		            }
		            if (connection != null) {
		                try {
		                    connection.close();
		                } catch (Exception e) {
		                    BaseLogger.log("3", null, null, "Error closing Connection: [" + E12GenericUtility.getStackTrace(e) + "]");
		                }
		            }
		        }
		        BaseLogger.log("3", null, null, "startingTimestamp ===> [" + startingTimestamp + "]");

		        return startingTimestamp;
		    }
		  // Method Added by Amol S on 23-Jan  to identify the starting time stamp of schId --End
		 
		 //Method Added by Amol S on 23-Jan  to identify the confirm transactions --Start 
		 public int getConfirmedTransactionCount(String scheduleId, UserInfoBean userInfo, String formattedTime) throws Exception {
         BaseLogger.log("3", null, null, "Inside the method getConfirmedTransactionCount--> 	");

			 String query = "SELECT COUNT(*) AS total_confirmed_transactions " +
		               "FROM misc_payment " +
		               "WHERE CONFIRMED = 'Y' " +  
		               "AND net_amt > 0 " +
		               "AND conf_date BETWEEN ? AND ?";

			    int totalCount = 0;
			    Connection connection = null;
			    PreparedStatement preparedStatement = null;
			    ResultSet resultSet = null;

			    try {
			        ConnDriver connDriver = new ConnDriver();
			        connection = connDriver.getConnectDB(userInfo.getTransDB());

			        // Get the starting timestamp
			        
			        Timestamp startingTimestamp = getStartingTimestamp(scheduleId, userInfo);

			        preparedStatement = connection.prepareStatement(query);
			        preparedStatement.setTimestamp(1, startingTimestamp); // Starting timestamp
			        preparedStatement.setTimestamp(2, Timestamp.valueOf(formattedTime)); // Current timestamp

			        resultSet = preparedStatement.executeQuery();

			        if (resultSet.next()) {
			            totalCount = resultSet.getInt("total_confirmed_transactions");
			            
			        }
			    } catch (Exception e) {
			        throw new Exception("Error fetching confirmed transaction count: " + e.getMessage(), e);
			    } finally {
			        if (resultSet != null) resultSet.close();
			        if (preparedStatement != null) preparedStatement.close();
			        if (connection != null) connection.close();
			    }
		        BaseLogger.log("3", null, null, "totalCount of transactions:: ===> [" + totalCount + "]");

			    return totalCount;
			}

		 //Method Added by Amol S on 23-Jan-25  to identify the confirm transactions --End 
		 
		 //Method Added by Amol S on 24-Jan-25  to find the missing generated files  --Start 
		 public List<String> findMissingGeneratedFiles(String localFolderPath, Timestamp startingTimestamp, Timestamp currentTimestamp, UserInfoBean userInfo) throws Exception {
			    BaseLogger.log("3", null, null, "Inside findMissingGeneratedFiles...");
			    List<String> missingFiles = new ArrayList<>();
			    // 1️⃣ Fetch confirmed transaction IDs
			    List<String> confirmedTranIds = getConfirmedTransactionIds(startingTimestamp, currentTimestamp, userInfo);
			    BaseLogger.log("3", null, null, "Confirmed Transactions: " + confirmedTranIds);

			    // 2️⃣ Get all XML file names from local folder
			    File localFolder = new File(localFolderPath);
			    Set<String> localFileNames = new HashSet<>();

			    if (localFolder.exists() && localFolder.isDirectory()) {
			        File[] files = localFolder.listFiles((dir, name) -> name.endsWith(".xml"));
			        if (files != null) {
			            for (File file : files) {
			                localFileNames.add(file.getName().trim()); 
			            }
			        }
			    }
			    BaseLogger.log("3", null, null, "Files in Local Folder: " + localFileNames);
			    // 3️⃣ Compare each `tranId` with filenames
			    for (String tranId : confirmedTranIds) {
		            boolean isFileFound = false;

		            for (String fileName : localFileNames) {
		                if (fileName.startsWith(tranId)) { 
		                    isFileFound = true;
		                    break;
		                }
		            }
		            if (!isFileFound) {
		                System.out.println("Missing file for transaction: " + tranId);
		                missingFiles.add(tranId); 
		            }
		        }
			    BaseLogger.log("3", null, null, "Final Missing Files: " + missingFiles);
			    return missingFiles;
			}

		 //Method Added by Amol S on 24-Jan-25  to find the missing generated files  --End 

		 //Method Added by Amol S on 24-Jan-25  to find the confirm Transactions ID from misc_payment table   --Start 
		private List<String> getConfirmedTransactionIds(Timestamp startingTimestamp, Timestamp currentTimestamp, UserInfoBean userInfo) throws Exception {
	         BaseLogger.log("3", null, null, "Inside the method getConfirmedTransactionIds::::: 	");
   
			String query = "SELECT tran_id " +
			                   "FROM misc_payment " +
			                   "WHERE CONFIRMED = 'Y' " +
			                   "AND conf_date BETWEEN ? AND ?";
			    
			    List<String> confirmedTranIds = new ArrayList<>();
			    Connection connection = null;
			    PreparedStatement preparedStatement = null;
			    ResultSet resultSet = null;

			    try {
			        ConnDriver connDriver = new ConnDriver();
			        connection = connDriver.getConnectDB(userInfo.getTransDB());
			        
			        preparedStatement = connection.prepareStatement(query);
			        preparedStatement.setTimestamp(1, startingTimestamp);
			        preparedStatement.setTimestamp(2, currentTimestamp);

			        resultSet = preparedStatement.executeQuery();

			        while (resultSet.next()) {
			            confirmedTranIds.add(resultSet.getString("tran_id").trim());
			        }
			    } catch (Exception e) {
			        throw new Exception("Error fetching confirmed transaction IDs: " + e.getMessage(), e);
			    } finally {
			        if (resultSet != null) resultSet.close();
			        if (preparedStatement != null) preparedStatement.close();
			        if (connection != null) connection.close();
			    }
		         BaseLogger.log("3", null, null, "confirmedTranIds in getConfirmedTransactionIds :::-->  	" +confirmedTranIds);

			    return confirmedTranIds;
			}
		//Method Added by Amol S on 24-Jan-25  to find the confirm Transactions ID from misc_payment table   --End 
 
		//Method added by Amol S on 29-jan to proces the xml files   --START
		public boolean processMissingFiles(String localFolderPath, Timestamp startingTimestamp, Timestamp currentTimestamp, UserInfoBean userInfo) throws Exception {
	      BaseLogger.log("3", null, null, "Inside the method processMissingFiles....	");
	      BaseLogger.log("3", null, null, "startingTimestamp:::	" +startingTimestamp);
	      BaseLogger.log("3", null, null, "currentTimestamp	"+currentTimestamp);

	      
			UNSHSBC unshsbc =new UNSHSBC();
		    List<String> missingFiles = findMissingGeneratedFiles(localFolderPath, startingTimestamp, currentTimestamp, userInfo);
		    for (String tranID : missingFiles) {
			      BaseLogger.log("3", null, null, "TranId....	" +tranID);

		        try {
		            String result = unshsbc.generateBankSpecificXML(userInfo, tranID);
		            BaseLogger.log("3", null, null, "XML generated for Tran ID: " + tranID + " - Result: " + result);
		        } catch (ITMException e) {
		            BaseLogger.log("3", null, null, "Error generating XML for Tran ID: " + tranID + " - " + e.getMessage());
					return false;
		        }
		    }
			return true;
		}
		//Method added by Amol S on 29-jan to proces the xml files   --END

}
