/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.PopUpBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.InfinispanLocal;
import ibase.webitm.ejb.PopUpDataAccessEJB;
import ibase.webitm.ejb.PopUpLocal;
import ibase.webitm.ejb.PopUpRemote;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.PopUpProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.ejb.EJBHome;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class PopUpEJB
implements PopUpRemote,
PopUpLocal {
    private HashMap<String, PopUpProperties> popUpMap;
    private static HashMap<String, HashMap<String, PopUpProperties>> transPopUpMap;
    static InfinispanLocal infinispanEJB;
    static Hashtable<String, String> jndiProperties;
    static InitialContext ctx;

    static {
        infinispanEJB = null;
        jndiProperties = null;
        ctx = null;
        try {
            if (CommonConstants.CACHE_OPT != 0) {
                jndiProperties = new Hashtable();
                jndiProperties.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
                ctx = new InitialContext(jndiProperties);
                infinispanEJB = (InfinispanLocal)ctx.lookup("ibase/InfinispanEJB/local");
                BaseLogger.log("1", null, null, "PopUpEJB infinispanLocalObj created.....");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in PopUpEJB static block:[" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    public PopUpEJB() {
        transPopUpMap = null;
        this.popUpMap = null;
    }

    public void ejbCreate() {
        transPopUpMap = null;
        this.popUpMap = null;
    }

    public void ejbRemove() {
        transPopUpMap = null;
        this.popUpMap = null;
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext mSessionContext) {
    }

    @Override
    public void createPopUpList(String transDB) throws RemoteException {
        BaseLogger.log("3", null, null, "PopUpEJB createPopUpList with 1 Parameter");
        this.createPopUpList(transDB, null);
    }

    public void createPopUpList(String transDB, UserInfoBean userInfo) throws RemoteException {
        BaseLogger.log("3", null, null, "PopUpEJB createPopUpList with 2 Parameters");
        try {
            if (CommonConstants.CACHE_OPT != 0 && infinispanEJB != null) {
                this.popUpMap = infinispanEJB.getPopupMetadata(transDB);
                if (this.popUpMap == null) {
                    this.popUpMap = infinispanEJB.getPopupMetadata("DEFAULT");
                }
            } else if (transPopUpMap != null && (transPopUpMap.containsKey("DEFAULT") || transPopUpMap.containsKey(transDB))) {
                this.popUpMap = transPopUpMap.get(transDB);
                if (this.popUpMap == null) {
                    this.popUpMap = transPopUpMap.get("DEFAULT");
                }
            }
            if (this.popUpMap == null) {
                AppConnectParm appConnect = new AppConnectParm();
                Properties props = appConnect.getProperty();
                InitialContext ctx = new InitialContext(props);
                BaseLogger.log("3", null, null, "Looking Up for PopUpDataAccess EJB");
                PopUpDataAccessEJB popUpDataAccess = new PopUpDataAccessEJB();
                BaseLogger.log("3", null, null, "PopUpDataAccess EJb Created userInfo [" + userInfo + "]");
                String popUpString = "";
                popUpString = userInfo != null ? popUpDataAccess.getAllPopUpString(userInfo) : popUpDataAccess.getAllPopUpString(transDB);
                this.popUpMap = this.getPopUpList(popUpString);
                if (CommonConstants.CACHE_OPT != 0 && infinispanEJB != null) {
                    infinispanEJB.setPopupMetadata(transDB, this.popUpMap);
                } else {
                    transPopUpMap = new HashMap();
                    transPopUpMap.put(transDB, this.popUpMap);
                }
                BaseLogger.log("3", null, null, "New HashMap Created");
                popUpDataAccess = null;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in PopUpEJB.createPopUpList()" + e.getMessage());
        }
    }

    private HashMap<String, PopUpProperties> getPopUpList(String popUpString) {
        this.popUpMap = new HashMap();
        if (popUpString != null && popUpString.length() > 0) {
            try {
                String popupXML = "";
                String modName = "";
                E12GenericUtility e12GenericUtility = new E12GenericUtility();
                Document doc = e12GenericUtility.parseString(popUpString);
                NodeList popUpTags = doc.getElementsByTagName("POPUP");
                int popUpTagsLength = popUpTags.getLength();
                int ctr = 0;
                while (ctr < popUpTagsLength) {
                    Node eachPopUp = popUpTags.item(ctr);
                    PopUpProperties popUpProperties = this.createPopUpProperties(eachPopUp);
                    this.popUpMap.put(popUpProperties.getID(), popUpProperties);
                    ++ctr;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception while parsing the returned popUpString");
                this.popUpMap = null;
            }
        } else {
            this.popUpMap = null;
        }
        return this.popUpMap;
    }

    private PopUpProperties createPopUpProperties(Node popUpTag) {
        PopUpProperties popUpProperties = new PopUpProperties();
        try {
            String popupXML = new E12GenericUtility().serializeDom(popUpTag);
            popUpProperties.setXML_STR(popupXML);
        }
        catch (ITMException e) {
            e.printStackTrace();
        }
        NamedNodeMap attributeMap = popUpTag.getAttributes();
        int attributeMapLength = attributeMap.getLength();
        int ctr = 0;
        while (ctr < attributeMapLength) {
            Node eachAttribute = attributeMap.item(ctr);
            String attributeName = eachAttribute.getNodeName().trim();
            String attributeValue = eachAttribute.getNodeValue().trim();
            if (attributeName.equalsIgnoreCase("ID")) {
                popUpProperties.setID(attributeValue);
            } else if (attributeName.equalsIgnoreCase("SQL_STR")) {
                popUpProperties.setSQL_STR(attributeValue);
            } else if (attributeName.equalsIgnoreCase("DW_OBJECT")) {
                popUpProperties.setDW_OBJECT(attributeValue);
            } else if (attributeName.equalsIgnoreCase("MSG_TITLE")) {
                popUpProperties.setMSG_TITLE(attributeValue);
            } else if (attributeName.equalsIgnoreCase("WIDTH")) {
                popUpProperties.setWIDTH(attributeValue);
            } else if (attributeName.equalsIgnoreCase("HEIGHT")) {
                popUpProperties.setHEIGHT(attributeValue);
            } else if (attributeName.equalsIgnoreCase("CHG_DATE")) {
                popUpProperties.setCHG_DATE(attributeValue);
            } else if (attributeName.equalsIgnoreCase("CHG_USER")) {
                popUpProperties.setCHG_USER(attributeValue);
            } else if (attributeName.equalsIgnoreCase("CHG_TERM")) {
                popUpProperties.setCHG_TERM(attributeValue);
            } else if (attributeName.equalsIgnoreCase("DIST_OPT")) {
                popUpProperties.setDIST_OPT(attributeValue);
            } else if (attributeName.equalsIgnoreCase("FILTER_STRING")) {
                popUpProperties.setFILTER_STRING(attributeValue);
            } else if (attributeName.equalsIgnoreCase("SQL_INPUT")) {
                popUpProperties.setSQL_INPUT(attributeValue);
            } else if (attributeName.equalsIgnoreCase("DEFAULT_COL")) {
                popUpProperties.setDEFAULT_COL(attributeValue);
            } else if (attributeName.equalsIgnoreCase("POP_ALIGN")) {
                popUpProperties.setPOP_ALIGN(attributeValue);
            } else if (attributeName.equalsIgnoreCase("QUERY_MODE")) {
                popUpProperties.setQUERY_MODE(attributeValue);
            } else if (attributeName.equalsIgnoreCase("POPHELP_SOURCE")) {
                popUpProperties.setPOPHELP_SOURCE(attributeValue);
            } else if (attributeName.equalsIgnoreCase("POPHELP_COLS")) {
                popUpProperties.setPOPHELP_COLS(attributeValue);
            } else if (attributeName.equalsIgnoreCase("MULTI_OPT")) {
                popUpProperties.setMultiOptionPopUp(Integer.parseInt(attributeValue));
            } else if (attributeName.equalsIgnoreCase("HELP_OPTION")) {
                popUpProperties.setHELP_OPTION(Integer.parseInt(attributeValue));
            } else if (attributeName.equalsIgnoreCase("AUTO_FILL_LEN")) {
                popUpProperties.setAUTO_FILL_LEN(Integer.parseInt(attributeValue));
            } else if (attributeName.equalsIgnoreCase("THUMB_OBJ")) {
                popUpProperties.setTHUMB_OBJ(attributeValue);
            } else if (attributeName.equalsIgnoreCase("THUMB_IMAGE_COL")) {
                popUpProperties.setTHUMB_IMAGE_COL(attributeValue);
            } else if (attributeName.equalsIgnoreCase("THUMB_ALT_COL")) {
                popUpProperties.setTHUMB_ALT_COL(attributeValue);
            } else if (attributeName.equalsIgnoreCase("OBJ_NAME__DS")) {
                popUpProperties.setOBJ_NAME__DS(attributeValue);
            } else if (attributeName.equalsIgnoreCase("MOD_NAME")) {
                popUpProperties.setMOD_NAME(attributeValue);
            } else if (attributeName.equalsIgnoreCase("DATA_MODEL_NAME")) {
                popUpProperties.setDATA_MODEL_NAME(attributeValue);
            } else if (attributeName.equalsIgnoreCase("FILTER_EXPR")) {
                popUpProperties.setFILTER_EXPR(attributeValue);
            } else if (attributeName.equalsIgnoreCase("ITEM_CHANGE")) {
                popUpProperties.setITEM_CHANGE(attributeValue);
            } else if (attributeName.equalsIgnoreCase("VALIDATE_DATA")) {
                popUpProperties.setVALIDATE_DATA(attributeValue);
            } else if (attributeName.equalsIgnoreCase("LAYOUT")) {
                popUpProperties.setLAYOUT(attributeValue);
            } else if (attributeName.equalsIgnoreCase("FIELD_NAME")) {
                popUpProperties.setFIELD_NAME(attributeValue);
            }
            ++ctr;
        }
        return popUpProperties;
    }

    @Override
    public String getFieldPopUpString(String fieldName, String modName, int pgContext) throws RemoteException {
        String retString = "";
        StringBuffer popUpInfoBuffer = new StringBuffer();
        fieldName = fieldName.trim().toUpperCase();
        modName = "W_" + modName.toUpperCase();
        pgContext = 0;
        boolean isPresent = false;
        String key = String.valueOf(fieldName) + "~" + modName.toUpperCase() + "~" + pgContext;
        if (this.popUpMap.containsKey(key)) {
            isPresent = true;
        } else {
            key = String.valueOf(fieldName) + "~X~" + pgContext;
            if (this.popUpMap.containsKey(key)) {
                isPresent = true;
            } else {
                if (fieldName.indexOf("__") != -1) {
                    fieldName = fieldName.substring(0, fieldName.indexOf("__"));
                }
                if (this.popUpMap.containsKey(key = String.valueOf(fieldName) + "~" + modName.toUpperCase() + "~" + pgContext)) {
                    isPresent = true;
                } else {
                    modName = "X";
                    key = String.valueOf(fieldName) + "~" + modName + "~" + pgContext;
                    if (this.popUpMap.containsKey(key)) {
                        isPresent = true;
                    }
                }
            }
        }
        if (isPresent) {
            PopUpProperties popUpProperties = this.popUpMap.get(key);
            String colName = key.substring(0, key.indexOf("~"));
            if (popUpProperties.getSQL_INPUT() != null) {
                popUpInfoBuffer.append(popUpProperties.getSQL_INPUT());
            } else {
                popUpInfoBuffer.append("NOPARAM");
            }
        }
        retString = popUpInfoBuffer.length() > 0 ? popUpInfoBuffer.toString() : null;
        return retString;
    }

    @Override
    public String getPopUpValues(String objName, String pageContext, String fieldName, String[] parameters, String userinfoStr, String allDetailXml) throws RemoteException, ITMException {
        String key;
        String retString = "";
        String data = "";
        fieldName = fieldName.trim().toUpperCase();
        String modName = "W_" + objName.toUpperCase();
        pageContext = "0";
        int pgContext = 0;
        if (pageContext != null && pageContext.length() > 0) {
            pgContext = Integer.parseInt(pageContext);
        }
        if (!this.popUpMap.containsKey(key = String.valueOf(fieldName) + "~" + modName.toUpperCase() + "~" + pgContext) && !this.popUpMap.containsKey(key = String.valueOf(fieldName) + "~X~" + pgContext)) {
            if (fieldName.indexOf("__") != -1) {
                fieldName = fieldName.substring(0, fieldName.indexOf("__"));
            }
            if (this.popUpMap.containsKey(key = String.valueOf(fieldName) + "~" + modName.toUpperCase() + "~" + pgContext) || this.popUpMap.containsKey(key = String.valueOf(fieldName) + "~X~" + pgContext)) {
                // empty if block
            }
        }
        BaseLogger.log("3", null, null, "Key==>" + key);
        String dataQuery = "";
        PopUpProperties popUpProperties = this.popUpMap.get(key);
        int distOption = 0;
        String filterString = popUpProperties.getFILTER_STRING();
        if (distOption == 0) {
            dataQuery = popUpProperties.getSQL_STR();
            retString = data = this.getFilteredData(filterString, dataQuery, parameters, null, popUpProperties, userinfoStr, allDetailXml);
        } else if (distOption == 1) {
            retString = null;
        } else if (distOption == 2) {
            retString = null;
        } else if (distOption == 3) {
            String fileName = String.valueOf(fieldName) + "_" + modName + "_" + pgContext;
            File file = new File(".." + File.separator + "popupxml" + File.separator + fileName + ".xml");
            if (file.exists()) {
                BaseLogger.log("3", null, null, "FIlE EXISTS");
                retString = data = this.getFilteredData(filterString, file);
            } else {
                BaseLogger.log("3", null, null, "FIlE Doesn't EXIST");
                dataQuery = popUpProperties.getSQL_STR();
                retString = data = this.getFilteredData(filterString, dataQuery, parameters, fileName, popUpProperties, userinfoStr, allDetailXml);
            }
        }
        return retString;
    }

    @Override
    public String getPopUpValues(String objName, String pageContext, String fieldName, String[] parameters, String userinfoStr, HashMap parameterMap, String allDetailXml) throws RemoteException, ITMException {
        String key;
        BaseLogger.log("2", null, null, "PopUpEJB :: getPopUpValues()   parameterMap: [" + parameterMap + "]");
        String retString = "";
        String data = "";
        fieldName = fieldName.trim().toUpperCase();
        String modName = "W_" + objName.toUpperCase();
        pageContext = "0";
        int pgContext = 0;
        if (pageContext != null && pageContext.length() > 0) {
            pgContext = Integer.parseInt(pageContext);
        }
        if (!this.popUpMap.containsKey(key = String.valueOf(fieldName) + "~" + modName.toUpperCase() + "~" + pgContext) && !this.popUpMap.containsKey(key = String.valueOf(fieldName) + "~X~" + pgContext)) {
            if (fieldName.indexOf("__") != -1) {
                fieldName = fieldName.substring(0, fieldName.indexOf("__"));
            }
            if (this.popUpMap.containsKey(key = String.valueOf(fieldName) + "~" + modName.toUpperCase() + "~" + pgContext) || this.popUpMap.containsKey(key = String.valueOf(fieldName) + "~X~" + pgContext)) {
                // empty if block
            }
        }
        BaseLogger.log("3", null, null, "Key==>" + key);
        String dataQuery = "";
        PopUpProperties popUpProperties = this.popUpMap.get(key);
        int distOption = 0;
        String filterString = popUpProperties.getFILTER_STRING();
        BaseLogger.log("3", null, null, "PopUpEJB ::  getPopUpValues() popUpProperties.getPOPHELP_SOURCE() [" + popUpProperties.getPOPHELP_SOURCE() + "]");
        if (distOption == 0) {
            dataQuery = popUpProperties.getSQL_STR();
            data = "E".equalsIgnoreCase(popUpProperties.getPOPHELP_SOURCE()) ? this.getFilteredData(filterString, dataQuery, parameters, null, popUpProperties, userinfoStr, parameterMap) : this.getFilteredData(filterString, dataQuery, parameters, null, popUpProperties, userinfoStr, allDetailXml);
            retString = data;
        } else if (distOption == 1) {
            retString = null;
        } else if (distOption == 2) {
            retString = null;
        } else if (distOption == 3) {
            String fileName = String.valueOf(fieldName) + "_" + modName + "_" + pgContext;
            File file = new File(".." + File.separator + "popupxml" + File.separator + fileName + ".xml");
            if (file.exists()) {
                BaseLogger.log("3", null, null, "FIlE EXISTS");
                retString = data = this.getFilteredData(filterString, file);
            } else {
                BaseLogger.log("3", null, null, "FIlE Doesn't EXIST");
                dataQuery = popUpProperties.getSQL_STR();
                data = "E".equalsIgnoreCase(popUpProperties.getPOPHELP_SOURCE()) ? this.getFilteredData(filterString, dataQuery, parameters, fileName, popUpProperties, userinfoStr, parameterMap) : this.getFilteredData(filterString, dataQuery, parameters, fileName, popUpProperties, userinfoStr, allDetailXml);
                retString = data;
            }
        }
        return retString;
    }

    @Override
    public String getPopHelpColsNSrc(String fieldName, String modName, int pgContext) throws RemoteException {
        StringBuffer popHelpColsNSrc = new StringBuffer("<Root>");
        fieldName = fieldName.trim().toUpperCase();
        modName = "W_" + modName.toUpperCase();
        pgContext = 0;
        boolean isPresent = false;
        String key = String.valueOf(fieldName) + "~" + modName.toUpperCase() + "~" + pgContext;
        if (this.popUpMap.containsKey(key)) {
            BaseLogger.log("3", null, null, "popUpMap contains the key.");
            isPresent = true;
        } else {
            key = String.valueOf(fieldName) + "~X~" + pgContext;
            if (this.popUpMap.containsKey(key)) {
                isPresent = true;
            } else {
                if (fieldName.indexOf("__") != -1) {
                    fieldName = fieldName.substring(0, fieldName.indexOf("__"));
                }
                if (this.popUpMap.containsKey(key = String.valueOf(fieldName) + "~" + modName.toUpperCase() + "~" + pgContext)) {
                    isPresent = true;
                } else {
                    modName = "X";
                    key = String.valueOf(fieldName) + "~" + modName + "~" + pgContext;
                    if (this.popUpMap.containsKey(key)) {
                        isPresent = true;
                    }
                }
            }
        }
        if (isPresent) {
            PopUpProperties popUpProperties = this.popUpMap.get(key);
            String propVal = "";
            propVal = popUpProperties.getPOPHELP_COLS() != null ? popUpProperties.getPOPHELP_COLS() : "";
            popHelpColsNSrc.append("<POPHELP_COLS>").append(propVal).append("</POPHELP_COLS>");
            propVal = popUpProperties.getPOPHELP_SOURCE() != null ? popUpProperties.getPOPHELP_SOURCE() : "";
            popHelpColsNSrc.append("<POPHELP_SOURCE>").append(propVal).append("</POPHELP_SOURCE>");
            propVal = popUpProperties.getMultiOptionPopUp() == 1 ? "" + popUpProperties.getMultiOptionPopUp() : "0";
            popHelpColsNSrc.append("<MULTI_OPT_POPUP>").append(propVal).append("</MULTI_OPT_POPUP>");
            popHelpColsNSrc.append("<HELP_OPTION>").append(popUpProperties.getHELP_OPTION()).append("</HELP_OPTION>");
            popHelpColsNSrc.append("<AUTO_FILL_LEN>").append(popUpProperties.getAUTO_FILL_LEN()).append("</AUTO_FILL_LEN>");
        }
        popHelpColsNSrc.append("</Root>");
        return popHelpColsNSrc.toString();
    }

    private String getFilteredData(String filterString, File file) {
        String retString = "";
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            byte[] xmlBytes = new byte[new Long(raf.length()).intValue()];
            raf.readFully(xmlBytes);
            String allData = new String(xmlBytes);
            raf.close();
            retString = this.applyFilter(filterString, allData);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception while finding file with the specified name");
            retString = null;
        }
        return retString;
    }

    private String getFilteredData(String filterString, String query, String[] parameters, String fileName, PopUpProperties popUpProperties, String userinfoStr, String allDetailXml) throws ITMException {
        String retString = "";
        try {
            AppConnectParm appConnect = new AppConnectParm();
            Properties props = appConnect.getProperty();
            InitialContext ctx = new InitialContext(props);
            BaseLogger.log("3", null, null, "Looking Up for PopUpDataAccess EJB with Properties==>\n" + props);
            PopUpDataAccessEJB popUpDataAccess = new PopUpDataAccessEJB();
            BaseLogger.log("3", null, null, "PopUpDataAccess EJb Created");
            UserInfoBean userInfo = null;
            if (userinfoStr != null && userinfoStr.length() > 0) {
                userInfo = new UserInfoBean(userinfoStr);
            }
            String allData = popUpDataAccess.getPopUpData(query, parameters, popUpProperties, userinfoStr, allDetailXml);
            String data = "<?xml version='1.0' encoding='" + (userInfo != null ? userInfo.getCharEnc() : CommonConstants.ENCODING) + "'?>" + "<?xml-stylesheet type=\"text/xsl\" href=\"../xsl/popup.xsl\"?>" + "<?xml-stylesheet type=\"text/css\" href=\"../css/xtree.css\"?>" + "<DOCUMENTROOT>" + "<DESCRIPTION></DESCRIPTION>" + this.getMetaData(popUpProperties) + this.getObjNameDSRights(popUpProperties, userInfo) + "<GROUP0>" + "<DESCRIPTION></DESCRIPTION>" + "<HEADER0>" + allData + "<DESCRIPTION></DESCRIPTION>" + "</HEADER0>" + "</GROUP0>" + "</DOCUMENTROOT>";
            retString = this.applyFilter(filterString, data);
            if (fileName != null) {
                this.savePopUp(fileName, data);
            }
            BaseLogger.log("3", userInfo, null, "\nSaved Pop Up Data into file :" + fileName);
            popUpDataAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in PopUpEJB.getFilteredData()");
            throw new ITMException(e);
        }
        return retString;
    }

    private String applyFilter(String filterString, String data) {
        return data;
    }

    private String getFilteredData(String filterString, String query, String[] parameters, String fileName, PopUpProperties popUpProperties, String userinfoStr, HashMap parameterMap) throws ITMException {
        BaseLogger.log("2", null, null, "POPEJB:: getFilteredData()  query [" + query + "] parameterMap [" + parameterMap + "]");
        String retString = "";
        String allData = "";
        try {
            UserInfoBean userInfo = null;
            if (userinfoStr != null && userinfoStr.length() > 0) {
                userInfo = new UserInfoBean(userinfoStr);
            }
            Class[] paramSpec = new Class[4];
            Object[] params = new Object[4];
            Class<?> stringClass = Class.forName("java.lang.String");
            Class<?> objectClass = Class.forName("java.lang.Object");
            Class<?> popUpPropertiesClass = Class.forName("ibase.webitm.utility.PopUpProperties");
            Class<?> hashMapClass = Class.forName("java.util.HashMap");
            paramSpec[0] = objectClass;
            paramSpec[1] = popUpPropertiesClass;
            paramSpec[2] = stringClass;
            paramSpec[3] = hashMapClass;
            params[0] = parameters;
            params[1] = popUpProperties;
            params[2] = userinfoStr;
            params[3] = parameterMap;
            Object classObj = null;
            AppConnectParm appConnectParm = new AppConnectParm();
            Properties properties = appConnectParm.getProperty();
            InitialContext inctx = new InitialContext(properties);
            Object ejbRemoteObj = this.getObj(query);
            Method method = ejbRemoteObj.getClass().getDeclaredMethod("getPopUpData", paramSpec);
            allData = (String)method.invoke(ejbRemoteObj, params);
            BaseLogger.log("3", userInfo, null, " From query[" + query + "]EJB : allData [" + allData + "]");
            String data = "<?xml version='1.0' encoding='" + (userInfo != null ? userInfo.getCharEnc() : CommonConstants.ENCODING) + "'?>" + "<?xml-stylesheet type=\"text/xsl\" href=\"../xsl/popup.xsl\"?>" + "<?xml-stylesheet type=\"text/css\" href=\"../css/xtree.css\"?>" + "<DOCUMENTROOT>" + "<DESCRIPTION></DESCRIPTION>" + this.getMetaData(popUpProperties) + this.getObjNameDSRights(popUpProperties, userInfo) + "<GROUP0>" + "<DESCRIPTION></DESCRIPTION>" + "<HEADER0>" + "<DESCRIPTION></DESCRIPTION>" + allData + "</HEADER0>" + "</GROUP0>" + "</DOCUMENTROOT>";
            retString = this.applyFilter(filterString, data);
            if (fileName != null) {
                this.savePopUp(fileName, data);
            }
            BaseLogger.log("3", userInfo, null, "\nSaved Pop Up Data into file :" + fileName);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in PopUpEJB.getFilteredData(userinfo)");
            e.printStackTrace();
            retString = null;
        }
        return retString;
    }

    private Object getObj(String lookupName) throws Exception {
        BaseLogger.log("2", null, null, " in  getObj(): lookupName[" + lookupName + "] ");
        EJBHome obHome = this.getHome(lookupName);
        Method methode = obHome.getClass().getDeclaredMethod("create", new Class[0]);
        Object obj = methode.invoke((Object)obHome, new Object[0]);
        return obj;
    }

    private EJBHome getHome(String lookupName) throws Exception {
        BaseLogger.log("2", null, null, " in  getHome(): lookupName[" + lookupName + "] ");
        AppConnectParm appConnect = new AppConnectParm();
        Properties p = appConnect.getProperty();
        InitialContext ctx = new InitialContext(p);
        Object home = ctx.lookup(lookupName);
        EJBHome obHome = (EJBHome)PortableRemoteObject.narrow((Object)home, EJBHome.class);
        return obHome;
    }

    private void savePopUp(String fileName, String content) {
        try {
            File file = new File("..\\popupxml\\" + fileName + ".xml");
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(content.getBytes(CommonConstants.ENCODING));
            fos.close();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in writing to the newly created XML file");
        }
    }

    private String getMetaData(PopUpProperties popUpProperties) {
        StringBuffer metaDataBuffer = new StringBuffer();
        metaDataBuffer.append("<METADATA><FIELD_NAME>" + popUpProperties.getFIELD_NAME() + "</FIELD_NAME>" + "<MOD_NAME>" + popUpProperties.getMOD_NAME() + "</MOD_NAME>" + "<SQL_STR><![CDATA[[" + popUpProperties.getSQL_STR() + "]]></SQL_STR>" + "<DW_OBJECT>" + popUpProperties.getDW_OBJECT() + "</DW_OBJECT>" + "<MSG_TITLE>" + popUpProperties.getMSG_TITLE() + "</MSG_TITLE>" + "<WIDTH>" + popUpProperties.getWIDTH() + "</WIDTH>" + "<HEIGHT>" + popUpProperties.getHEIGHT() + "</HEIGHT>" + "<CHG_DATE>" + popUpProperties.getCHG_DATE() + "</CHG_DATE>" + "<CHG_USER>" + popUpProperties.getCHG_USER() + "</CHG_USER>" + "<CHG_TERM>" + popUpProperties.getCHG_TERM() + "</CHG_TERM>" + "<DIST_OPT>" + popUpProperties.getDIST_OPT() + "</DIST_OPT>" + "<FILTER_STRING>" + popUpProperties.getFILTER_STRING() + "</FILTER_STRING>" + "<SQL_INPUT>" + popUpProperties.getSQL_INPUT() + "</SQL_INPUT>" + "<DEFAULT_COL>" + popUpProperties.getDEFAULT_COL() + "</DEFAULT_COL>" + "<POP_ALIGN>" + popUpProperties.getPOP_ALIGN() + "</POP_ALIGN>" + "<QUERY_MODE>" + popUpProperties.getQUERY_MODE() + "</QUERY_MODE>" + "<PAGE_CONTEXT>" + popUpProperties.getPAGE_CONTEXT() + "</PAGE_CONTEXT>" + "<MULTIPLE_OPT>" + popUpProperties.getMultiOptionPopUp() + "</MULTIPLE_OPT>" + "<POPHELP_SOURCE>" + popUpProperties.getPOPHELP_SOURCE() + "</POPHELP_SOURCE>" + "<THUMB_OBJ>" + popUpProperties.getTHUMB_OBJ() + "</THUMB_OBJ>" + "<THUMB_IMAGE_COL>" + popUpProperties.getTHUMB_IMAGE_COL() + "</THUMB_IMAGE_COL>" + "<THUMB_ALT_COL>" + popUpProperties.getTHUMB_ALT_COL() + "</THUMB_ALT_COL>" + "<OBJ_NAME__DS>" + popUpProperties.getOBJ_NAME__DS() + "</OBJ_NAME__DS>" + "<DATA_MODEL_NAME>" + popUpProperties.getDATA_MODEL_NAME() + "</DATA_MODEL_NAME>" + "<VALIDATE_DATA>" + popUpProperties.getVALIDATE_DATA() + "</VALIDATE_DATA>" + "<ITEM_CHANGE>" + popUpProperties.getITEM_CHANGE() + "</ITEM_CHANGE>" + "</METADATA>");
        return metaDataBuffer.toString();
    }

    @Override
    public String getpopUpKeyStr(String objName, String fieldName, String paramXmlStr, UserInfoBean userInfo, String allDetailXml, String formNo, String reqParams) throws ITMException {
        String popupStr = "";
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        StringTokenizer st = null;
        String[] parameters = null;
        String[] parametersVal = null;
        String xmlString = "";
        E12GenericUtility genUtility = new E12GenericUtility();
        String transDB = null;
        HashMap<String, String> paramsMap = null;
        String objContext = E12GenericUtility.checkNull(formNo);
        String nodevalue = "";
        try {
            try {
                paramsMap = this.createParamsMap(reqParams);
                ConnDriver connDriver = new ConnDriver();
                transDB = userInfo.getTransDB();
                if (transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0) {
                    connection = connDriver.getConnectDB(transDB);
                }
                String sqlInputStr = "";
                String modname = "W_" + objName.trim().toUpperCase();
                String popupXML = "";
                sqlInputStr = this.getSqlInput("0", fieldName, modname);
                if (sqlInputStr != null && !"".equalsIgnoreCase(sqlInputStr)) {
                    popupStr = sqlInputStr;
                } else {
                    String objStr = "W_" + objName.trim().toUpperCase();
                    String query = "SELECT Sql_input FROM pophelp WHERE mod_name ='" + objStr + "' AND field_name = '" + fieldName.toUpperCase() + "'";
                    preparedStatement = connection.prepareStatement(query);
                    resultSet = preparedStatement.executeQuery();
                    BaseLogger.log("3", userInfo, null, "Query " + query);
                    while (resultSet.next()) {
                        popupStr = String.valueOf(popupStr) + resultSet.getString(1);
                    }
                    BaseLogger.log("3", userInfo, null, "After while popstr " + popupStr);
                    if (preparedStatement != null) {
                        preparedStatement.close();
                        preparedStatement = null;
                    }
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (popupStr == null || popupStr == "" || popupStr.length() == 0) {
                        String query1 = "SELECT Sql_input FROM pophelp WHERE mod_name = 'X' AND field_name = '" + fieldName.toUpperCase() + "'";
                        preparedStatement = connection.prepareStatement(query1);
                        resultSet = preparedStatement.executeQuery();
                        BaseLogger.log("3", userInfo, null, "Query " + query1);
                        while (resultSet.next()) {
                            popupStr = String.valueOf(popupStr) + resultSet.getString(1);
                        }
                        if (preparedStatement != null) {
                            preparedStatement.close();
                            preparedStatement = null;
                        }
                        if (resultSet != null) {
                            resultSet.close();
                            resultSet = null;
                        }
                    }
                }
                BaseLogger.log("3", userInfo, null, "popupStr [" + popupStr + "] ");
                if (popupStr != null) {
                    st = (popupStr = popupStr.substring(1).trim()).indexOf(";") != -1 ? new StringTokenizer(popupStr, ";") : new StringTokenizer(popupStr, ":");
                }
                if (st != null && st.countTokens() > 1) {
                    parameters = new String[st.countTokens()];
                    parametersVal = new String[st.countTokens()];
                    int ctr = 0;
                    boolean flag = false;
                    while (st.hasMoreTokens()) {
                        String curToken = st.nextToken();
                        BaseLogger.log("3", userInfo, null, " current token " + curToken);
                        flag = true;
                        BaseLogger.log("3", userInfo, null, "curToken: " + curToken);
                        parameters[ctr] = curToken;
                        ++ctr;
                    }
                } else {
                    parameters = new String[1];
                    parametersVal = new String[1];
                    BaseLogger.log("3", userInfo, null, " current token for single input >>" + popupStr);
                    parameters[0] = popupStr;
                }
                PopUpBean popUpBean = new PopUpBean(userInfo);
                popUpBean.setObjName(objName);
                BaseLogger.log("3", userInfo, null, "fieldName[" + fieldName + "]");
                if (paramXmlStr != null && !paramXmlStr.equalsIgnoreCase("null")) {
                    Document currentDom = null;
                    if (paramXmlStr != null && paramXmlStr.length() > 0) {
                        currentDom = genUtility.parseString(paramXmlStr);
                    }
                    Document allDetailXmlDom = null;
                    if (allDetailXml != null && allDetailXml.length() > 0) {
                        BaseLogger.log("3", userInfo, null, "inside popupejb 112 allDetailXml ==> " + allDetailXml);
                        allDetailXmlDom = genUtility.parseString(allDetailXml);
                    }
                    int i = 0;
                    while (i < parameters.length) {
                        objContext = formNo;
                        String param = parameters[i];
                        if (param.indexOf(".") != -1) {
                            objContext = param.substring(0, param.indexOf("."));
                            int objContext1 = Integer.parseInt(objContext) + 1;
                            objContext = "" + objContext1;
                            param = param.substring(param.indexOf(".") + 1);
                        }
                        BaseLogger.log("3", userInfo, null, "param - [" + param + "], parametersVal - [" + parametersVal + "], objContext - [" + objContext + "]");
                        if (param.indexOf(",") != -1) {
                            param = param.substring(0, param.indexOf(","));
                        }
                        if (paramsMap != null && paramsMap.containsKey(param)) {
                            parametersVal[i] = paramsMap.get(param);
                        } else {
                            param = param.toLowerCase();
                            BaseLogger.log("3", userInfo, null, "inside popupejb 1135 param [" + param + "]");
                            int currentobjContext = 1;
                            if (objContext != null && objContext.length() > 0) {
                                currentobjContext = Integer.parseInt(objContext);
                            }
                            if (objContext != null && objContext.length() > 0 && objContext.equals("0")) {
                                objContext = "1";
                            }
                            String currObjContext = "" + currentobjContext;
                            BaseLogger.log("3", userInfo, null, "objContext @[" + objContext + "], formNo - [" + formNo + "] currObjContext - [" + currObjContext + "]");
                            NodeList detailNodeList = null;
                            if (currObjContext.equalsIgnoreCase(formNo) && currentDom != null) {
                                parametersVal[i] = genUtility.getColumnValue(param.toLowerCase(), currentDom);
                            } else if (allDetailXmlDom != null) {
                                Node detailNode;
                                detailNodeList = allDetailXmlDom.getElementsByTagName("Detail" + objContext);
                                if (detailNodeList != null && (detailNode = detailNodeList.item(0)) != null) {
                                    detailNodeList = detailNode.getChildNodes();
                                    int cnt = 0;
                                    while (cnt < detailNodeList.getLength()) {
                                        detailNode = detailNodeList.item(cnt);
                                        if (detailNode.getFirstChild() != null && detailNode.getNodeName().equalsIgnoreCase(param)) {
                                            nodevalue = detailNode.getFirstChild().getNodeValue();
                                            break;
                                        }
                                        ++cnt;
                                    }
                                }
                                parametersVal[i] = nodevalue;
                            }
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < parametersVal.length) {
                        BaseLogger.log("3", userInfo, null, "inside popupejb 1170 parametersVal[" + i + "] ==> " + parametersVal[i]);
                        ++i;
                    }
                    xmlString = popUpBean.getPopUpXML(fieldName, parametersVal, "");
                } else {
                    xmlString = popUpBean.getPopUpXML(fieldName, parameters, "");
                }
            }
            catch (Exception ex) {
                BaseLogger.log("0", userInfo, null, "Exception : " + ex.getMessage());
                ex.printStackTrace();
                throw new ITMException(ex);
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                    preparedStatement = null;
                }
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception ex) {
                BaseLogger.log("0", userInfo, null, "Finally Exception : " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return xmlString;
    }

    private String getSqlInput(String pageContext, String fieldName, String modName) {
        String sqlInput = "";
        try {
            int pgContext = 0;
            pageContext = "0";
            if (pageContext != null && pageContext.length() > 0) {
                pgContext = Integer.parseInt(pageContext);
            }
            String key = String.valueOf(fieldName.toUpperCase()) + "~" + modName + "~" + pgContext;
            BaseLogger.log("3", null, null, "1324 Key==>" + key);
            if (!this.popUpMap.containsKey(key) && !this.popUpMap.containsKey(key = String.valueOf(fieldName) + "~X~" + pgContext)) {
                if (fieldName.indexOf("__") != -1) {
                    fieldName = fieldName.substring(0, fieldName.indexOf("__"));
                }
                if (!this.popUpMap.containsKey(key = String.valueOf(fieldName) + "~" + modName.toUpperCase() + "~" + pgContext)) {
                    BaseLogger.log("3", null, null, "else cond of popupEJB 1342!!!");
                    key = String.valueOf(fieldName.toUpperCase()) + "~X~" + pgContext;
                    if (this.popUpMap.containsKey(key)) {
                        // empty if block
                    }
                }
            }
            BaseLogger.log("3", null, null, "Key==>" + key);
            String dataQuery = "";
            PopUpProperties popUpProperties = this.popUpMap.get(key);
            sqlInput = this.checkNull(popUpProperties.getSQL_INPUT());
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception while getting sqlInput value : [" + e.getMessage() + "]");
        }
        return sqlInput;
    }

    @Override
    public void createPopUpList(UserInfoBean userInfo) throws RemoteException {
        try {
            String transDB = userInfo.getTransDB();
            if (transDB != null && transDB.trim().length() > 0 && !"null".equalsIgnoreCase(transDB)) {
                if (CommonConstants.CACHE_OPT != 0 && infinispanEJB != null) {
                    this.popUpMap = infinispanEJB.getPopupMetadata(transDB);
                } else if (transPopUpMap != null && transPopUpMap.containsKey(transDB)) {
                    this.popUpMap = transPopUpMap.get(transDB);
                }
                if (this.popUpMap == null) {
                    BaseLogger.log("3", userInfo, null, "Inside createPopUpList() for transDB ");
                    AppConnectParm appConnect = new AppConnectParm();
                    Properties props = appConnect.getProperty();
                    InitialContext ctx = new InitialContext(props);
                    BaseLogger.log("3", userInfo, null, "Looking Up for PopUpDataAccess EJB2 ");
                    PopUpDataAccessEJB popUpDataAccess = new PopUpDataAccessEJB();
                    BaseLogger.log("3", userInfo, null, "PopUpDataAccess EJb Created");
                    String popUpString = popUpDataAccess.getAllPopUpString(userInfo);
                    this.popUpMap = this.getPopUpList(popUpString);
                    if (CommonConstants.CACHE_OPT != 0 && infinispanEJB != null) {
                        infinispanEJB.setPopupMetadata(transDB, this.popUpMap);
                    } else {
                        transPopUpMap = new HashMap();
                        transPopUpMap.put(transDB, this.popUpMap);
                    }
                    BaseLogger.log("3", userInfo, null, "New HashMap Created");
                    popUpDataAccess = null;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception in PopUpEJB.createPopUpList(userInfo)--1225");
        }
    }

    @Override
    public ArrayList<String> getPopUpLst(String objName, String objType, UserInfoBean userInfo) {
        BaseLogger.log("2", userInfo, null, "Getting list of all popHelp for objName [" + objName + "] & objType [" + objType + "]");
        ArrayList<String> popUpLst = new ArrayList<String>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String transDB = "";
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                transDB = userInfo.getTransDB();
                connection = connDriver.getConnectDB(transDB);
                statement = connection.createStatement();
                String modName = "W_" + objName.trim().toUpperCase();
                String query = "select FIELD_NAME from popHelp where mod_name = '" + modName + "'";
                resultSet = statement.executeQuery(query);
                BaseLogger.log("3", userInfo, null, "popHelpLstQuery[" + query + "]");
                while (resultSet.next()) {
                    popUpLst.add(resultSet.getString("FIELD_NAME"));
                }
            }
            catch (Exception ex) {
                BaseLogger.log("0", userInfo, null, "Exception : " + ex.getMessage());
                ex.printStackTrace();
                try {
                    resultSet.close();
                    resultSet = null;
                    statement.close();
                    statement = null;
                    connection.close();
                    connection = null;
                }
                catch (Exception ex2) {
                    BaseLogger.log("0", userInfo, null, "Finally Exception : " + ex2.getMessage());
                    ex2.printStackTrace();
                }
                return null;
            }
        }
        finally {
            try {
                resultSet.close();
                resultSet = null;
                statement.close();
                statement = null;
                connection.close();
                connection = null;
            }
            catch (Exception ex) {
                BaseLogger.log("0", userInfo, null, "Finally Exception : " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return popUpLst;
    }

    @Override
    public String getPopUpJSONValues(String objName, String pageContext, String fieldName, String[] parameters, String userinfoStr, String isBiPophelp) throws RemoteException, ITMException {
        String retString = "";
        String data = "";
        String modName = "";
        String key = "";
        fieldName = fieldName.trim().toUpperCase();
        pageContext = "0";
        int pgContext = 0;
        if (pageContext != null && pageContext.length() > 0) {
            pgContext = Integer.parseInt(pageContext);
        }
        System.out.println("INside getPopUpJSONValues objName " + objName + " fieldName " + fieldName + " isBiPophelp " + isBiPophelp);
        if (isBiPophelp.equalsIgnoreCase("true")) {
            System.out.println("INside bi pophelp");
            modName = objName;
            key = String.valueOf(fieldName) + "~" + modName + "~" + pgContext;
        } else {
            modName = "W_" + objName.toUpperCase();
            key = String.valueOf(fieldName) + "~" + modName.toUpperCase() + "~" + pgContext;
        }
        System.out.println("Inside getPopUpJSONValues modName " + modName);
        System.out.println("Inside popup map key " + key + " containsKey " + this.popUpMap.containsKey(key));
        if (!this.popUpMap.containsKey(key) && !this.popUpMap.containsKey(key = String.valueOf(fieldName) + "~X~" + pgContext)) {
            if (fieldName.indexOf("__") != -1) {
                fieldName = fieldName.substring(0, fieldName.indexOf("__"));
            }
            if (this.popUpMap.containsKey(key = String.valueOf(fieldName) + "~" + modName.toUpperCase() + "~" + pgContext) || this.popUpMap.containsKey(key = String.valueOf(fieldName) + "~X~" + pgContext)) {
                // empty if block
            }
        }
        BaseLogger.log("3", null, null, "Key==>" + key);
        String dataQuery = "";
        PopUpProperties popUpProperties = this.popUpMap.get(key);
        boolean distOption = false;
        String filterString = popUpProperties.getFILTER_STRING();
        if (!distOption) {
            dataQuery = popUpProperties.getSQL_STR();
            retString = data = this.getFilteredJSONData(filterString, dataQuery, parameters, null, popUpProperties, userinfoStr, isBiPophelp);
        }
        return retString;
    }

    private String getFilteredJSONData(String filterString, String query, String[] parameters, String fileName, PopUpProperties popUpProperties, String userinfoStr) throws ITMException {
        return this.getFilteredJSONData(filterString, query, parameters, fileName, popUpProperties, userinfoStr, "false");
    }

    private String getFilteredJSONData(String filterString, String query, String[] parameters, String fileName, PopUpProperties popUpProperties, String userinfoStr, String isBiPophelp) throws ITMException {
        String jsonData = "";
        try {
            AppConnectParm appConnect = new AppConnectParm();
            Properties props = appConnect.getProperty();
            InitialContext ctx = new InitialContext(props);
            BaseLogger.log("3", null, null, "Looking Up for PopUpDataAccess EJB with Properties==>\n" + props);
            PopUpDataAccessEJB popUpDataAccess = new PopUpDataAccessEJB();
            BaseLogger.log("3", null, null, "PopUpDataAccess EJb Created");
            UserInfoBean userInfo = null;
            if (userinfoStr != null && userinfoStr.length() > 0) {
                userInfo = new UserInfoBean(userinfoStr);
            }
            if ((jsonData = popUpDataAccess.getPopUpJSONData(query, parameters, popUpProperties, userinfoStr, isBiPophelp)) != null) {
                BaseLogger.log("3", userInfo, null, "\n JSON DATA :" + jsonData.length());
            }
            popUpDataAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in PopUpEJB.getFilteredJSONData()---1416:[" + E12GenericUtility.getStackTrace(e) + "]");
            throw new ITMException(e);
        }
        return jsonData;
    }

    @Override
    public String getpopUpKeyStrJSON(String objName, String fieldName, String reqParams, UserInfoBean userInfo, String allDetailXml, String sqlInput, String formNo, String detailXml) throws ITMException {
        String popupStr = "";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        StringTokenizer st = null;
        String[] parameters = null;
        String[] parametersVal = null;
        E12GenericUtility e12GenericUtility = new E12GenericUtility();
        String objContext = E12GenericUtility.checkNull(formNo);
        String xmlString = "";
        String nodevalue = "";
        String transDB = null;
        HashMap<String, String> paramsMap = null;
        boolean isNewConn = false;
        try {
            try {
                paramsMap = this.createParamsMap(reqParams);
                if ("".equals(E12GenericUtility.checkNull(sqlInput))) {
                    ConnDriver connDriver = new ConnDriver();
                    transDB = userInfo.getTransDB();
                    connection = connDriver.getConnectDB(transDB);
                    isNewConn = true;
                    statement = connection.createStatement();
                    String objStr = "W_" + objName.trim().toUpperCase();
                    String query = "SELECT Sql_input FROM pophelp WHERE mod_name ='" + objStr + "' AND field_name = '" + fieldName.toUpperCase() + "'";
                    resultSet = statement.executeQuery(query);
                    BaseLogger.log("3", userInfo, null, "Query " + query);
                    while (resultSet.next()) {
                        popupStr = String.valueOf(popupStr) + resultSet.getString(1);
                    }
                    BaseLogger.log("3", userInfo, null, "After while popstr " + popupStr);
                    if (popupStr == null || "null".equalsIgnoreCase(popupStr) || popupStr == "" || popupStr.length() == 0) {
                        String query1 = "SELECT Sql_input FROM pophelp WHERE mod_name = 'X' AND field_name = '" + fieldName.toUpperCase() + "'";
                        resultSet = statement.executeQuery(query1);
                        BaseLogger.log("3", userInfo, null, "Query " + query1);
                        while (resultSet.next()) {
                            popupStr = String.valueOf(popupStr) + resultSet.getString(1) + " & ";
                        }
                    }
                } else {
                    popupStr = sqlInput;
                }
                BaseLogger.log("3", userInfo, null, "popupStr [" + popupStr + "] ");
                BaseLogger.log("3", userInfo, null, "popupStr [" + popupStr + "] ");
                if (popupStr != null && !"null".equalsIgnoreCase(popupStr) && popupStr.length() > 0) {
                    st = (popupStr = popupStr.substring(1).trim()).indexOf(";") != -1 ? new StringTokenizer(popupStr, ";") : new StringTokenizer(popupStr, ":");
                }
                if (st != null && st.countTokens() > 1) {
                    parameters = new String[st.countTokens()];
                    parametersVal = new String[st.countTokens()];
                    int ctr = 0;
                    boolean flag = false;
                    while (st.hasMoreTokens()) {
                        String curToken = st.nextToken();
                        BaseLogger.log("3", userInfo, null, " current token " + curToken);
                        flag = true;
                        BaseLogger.log("3", userInfo, null, "curToken: " + curToken);
                        parameters[ctr] = this.checkNull(curToken).toUpperCase();
                        ++ctr;
                    }
                } else {
                    parameters = new String[1];
                    parametersVal = new String[1];
                    if (popupStr != null && popupStr.indexOf(":") != -1) {
                        popupStr = popupStr.substring(popupStr.indexOf(":") + 1);
                    }
                    BaseLogger.log("3", userInfo, null, " current token for single input >>" + popupStr);
                    parameters[0] = this.checkNull(popupStr).toUpperCase();
                }
                PopUpBean popUpBean = new PopUpBean(userInfo);
                popUpBean.setObjName(objName);
                BaseLogger.log("3", userInfo, null, "fieldName[" + fieldName + "] paramsMap [" + paramsMap + "] paramXmlStr [" + detailXml + "]");
                if (detailXml != null && !detailXml.equalsIgnoreCase("null")) {
                    Document currentDom = null;
                    if ((detailXml = E12GenericUtility.checkNull(detailXml)) != null && detailXml.length() > 0) {
                        currentDom = e12GenericUtility.parseString(detailXml);
                    }
                    Document allDetailXmlDom = null;
                    if ((allDetailXml = E12GenericUtility.checkNull(allDetailXml)) != null && allDetailXml.length() > 0) {
                        allDetailXmlDom = e12GenericUtility.parseString(allDetailXml);
                    }
                    int i = 0;
                    while (i < parameters.length) {
                        nodevalue = "";
                        BaseLogger.log("3", userInfo, null, "parameters[" + i + "]=[" + parameters[i] + "]");
                        objContext = formNo;
                        String param = parameters[i];
                        if (param.indexOf(".") != -1) {
                            objContext = param.substring(0, param.indexOf("."));
                            int objContext1 = Integer.parseInt(objContext) + 1;
                            objContext = "" + objContext1;
                            param = param.substring(param.indexOf(".") + 1);
                        }
                        BaseLogger.log("3", userInfo, null, "curToken param - [" + param + "], parametersVal - [" + parametersVal + "], objContext - [" + objContext + "]");
                        if (param.indexOf(",") != -1) {
                            param = param.substring(0, param.indexOf(","));
                        }
                        if (paramsMap != null && paramsMap.containsKey(param)) {
                            parametersVal[i] = paramsMap.get(param);
                        } else {
                            param = param.toLowerCase();
                            BaseLogger.log("3", userInfo, null, "inside popupejb 1135 param [" + param + "]");
                            int currentobjContext = 1;
                            if (objContext != null && objContext.length() > 0) {
                                currentobjContext = Integer.parseInt(objContext);
                            }
                            if (objContext != null && objContext.length() > 0 && objContext.equals("0")) {
                                objContext = "1";
                            }
                            String currObjContext = "" + currentobjContext;
                            BaseLogger.log("3", userInfo, null, "objContext @[" + objContext + "], formNo - [" + formNo + "] currObjContext - [" + currObjContext + "]");
                            NodeList detailNodeList = null;
                            if (objContext.equalsIgnoreCase(formNo) && currentDom != null) {
                                parametersVal[i] = e12GenericUtility.getColumnValue(param.toLowerCase(), currentDom);
                            } else if (allDetailXmlDom != null) {
                                Node detailNode;
                                detailNodeList = allDetailXmlDom.getElementsByTagName("Detail" + objContext);
                                if (detailNodeList != null && (detailNode = detailNodeList.item(0)) != null) {
                                    detailNodeList = detailNode.getChildNodes();
                                    int cnt = 0;
                                    while (cnt < detailNodeList.getLength()) {
                                        detailNode = detailNodeList.item(cnt);
                                        if (detailNode.getFirstChild() != null && detailNode.getNodeName().equalsIgnoreCase(param)) {
                                            nodevalue = detailNode.getFirstChild().getNodeValue();
                                            break;
                                        }
                                        ++cnt;
                                    }
                                    BaseLogger.log("3", userInfo, null, "nodevalue[" + nodevalue + "]");
                                }
                                parametersVal[i] = nodevalue;
                            }
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < parametersVal.length) {
                        BaseLogger.log("3", userInfo, null, "inside popupejb 1170 parametersVal[" + i + "] ==> " + parametersVal[i]);
                        ++i;
                    }
                    xmlString = popUpBean.getPopUpJSON(fieldName, parametersVal, "false");
                } else if (paramsMap != null) {
                    int i = 0;
                    while (i < parameters.length) {
                        BaseLogger.log("3", userInfo, null, "1918 parameters[" + i + "]=[" + parameters[i] + "]");
                        String param = parameters[i];
                        if (param.indexOf(".") != -1) {
                            objContext = param.substring(0, param.indexOf("."));
                            int objContext1 = Integer.parseInt(objContext) + 1;
                            objContext = "" + objContext1;
                            param = param.substring(param.indexOf(".") + 1);
                        }
                        BaseLogger.log("3", userInfo, null, "1929 curToken param - [" + param + "], parametersVal - [" + parametersVal + "], objContext - [" + objContext + "]");
                        if (param.indexOf(",") != -1) {
                            param = param.substring(0, param.indexOf(","));
                        }
                        if (paramsMap.containsKey(param)) {
                            parametersVal[i] = paramsMap.get(param);
                        }
                        BaseLogger.log("3", userInfo, null, "1938 parametersVal[" + i + "]=[" + parametersVal[i] + "]");
                        ++i;
                    }
                    xmlString = popUpBean.getPopUpJSON(fieldName, parametersVal, "false");
                } else {
                    xmlString = popUpBean.getPopUpJSON(fieldName, parameters, "false");
                }
            }
            catch (Exception ex) {
                BaseLogger.log("0", userInfo, null, "Exception : " + ex.getMessage());
                ex.printStackTrace();
                throw new ITMException(ex);
            }
        }
        finally {
            try {
                if (isNewConn) {
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
            }
            catch (Exception ex) {
                BaseLogger.log("0", userInfo, null, "Finally Exception : " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return xmlString;
    }

    private HashMap<String, String> createParamsMap(String params) {
        HashMap<String, String> paramsMap = null;
        if (params != null) {
            paramsMap = new HashMap<String, String>();
            String[] paramsArr = params.split("~SEP~");
            int i = 0;
            while (i < paramsArr.length) {
                String param = this.checkNull(paramsArr[i]);
                String[] paramArr = param.split("=");
                String paramKey = "";
                String paramValue = "";
                if (paramArr.length > 0) {
                    paramKey = this.checkNull(paramArr[0]).toUpperCase();
                }
                if (paramArr.length > 1) {
                    paramValue = this.checkNull(paramArr[1]);
                }
                paramsMap.put(paramKey, paramValue);
                ++i;
            }
        }
        BaseLogger.log("2", null, null, "paramsMap[" + paramsMap + "]");
        return paramsMap;
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input;
    }

    @Override
    public String getPopxmlData(String objName, UserInfoBean userInfo) {
        String popupXML = "";
        String transDB = "";
        try {
            if (userInfo != null) {
                transDB = userInfo.getTransDB();
            }
            if (CommonConstants.CACHE_OPT != 0 && infinispanEJB != null) {
                this.popUpMap = infinispanEJB.getPopupMetadata(transDB);
                if (this.popUpMap == null) {
                    this.popUpMap = infinispanEJB.getPopupMetadata("DEFAULT");
                }
            } else if (transPopUpMap != null && (transPopUpMap.get("DEFAULT") != null || transPopUpMap.get(transDB) != null)) {
                this.popUpMap = transPopUpMap.get(transDB);
                if (this.popUpMap == null) {
                    this.popUpMap = transPopUpMap.get("DEFAULT");
                }
            }
            if (this.popUpMap == null) {
                this.createPopUpList(transDB, userInfo);
            }
            if (this.popUpMap != null) {
                String modname = "W_" + objName.toUpperCase();
                popupXML = "X".equalsIgnoreCase(objName) ? this.popUpMap.entrySet().stream().filter(e -> "X".equals(((PopUpProperties)e.getValue()).getMOD_NAME())).map(e -> String.valueOf(((PopUpProperties)e.getValue()).getXML_STR())).collect(Collectors.joining("")) : this.popUpMap.entrySet().stream().filter(e -> modname.equals(((PopUpProperties)e.getValue()).getMOD_NAME())).map(e -> String.valueOf(((PopUpProperties)e.getValue()).getXML_STR())).collect(Collectors.joining(""));
            }
        }
        catch (Exception e2) {
            BaseLogger.log("0", null, null, "Exception in getPopxmlData - [" + e2.getMessage() + "]");
        }
        return popupXML;
    }

    private String getObjNameDSRights(PopUpProperties popUpProperties, UserInfoBean userInfo) {
        StringBuffer metaDataBuffer = new StringBuffer();
        try {
            String objNameDS = this.checkNull(popUpProperties.getOBJ_NAME__DS());
            BaseLogger.log("3", userInfo, null, "In PopupEJB getObjNameDSRights objNameDS[" + objNameDS + "]");
            if (!"".equalsIgnoreCase(objNameDS)) {
                AppConnectParm appConnect = new AppConnectParm();
                Properties props = appConnect.getProperty();
                InitialContext ctx = new InitialContext(props);
                String objActionsDetails = "";
                DBAccessEJB dbAccess = new DBAccessEJB();
                objActionsDetails = dbAccess.getUserRightsString(objNameDS, userInfo.getProfileId(), userInfo.getUserLevel(), userInfo.getTransDB(), userInfo);
                metaDataBuffer.append("<OBJ_NAME__DS_RIGHTS><![CDATA[" + objActionsDetails + "]]></OBJ_NAME__DS_RIGHTS>");
                dbAccess = null;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception while parsing the returned getObjWisePopUpList" + e.getMessage());
        }
        return metaDataBuffer.toString();
    }
}

