/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.webitm.bean.MachineConnection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WeighUtil {
    String responseStr = "";
    private static Map<String, MachineConnection> machineConns = new HashMap<String, MachineConnection>();
    private static Date LAST_CHANGE_DATE = null;

    public static WeighUtil getInstance() {
        return new WeighUtil();
    }

    public String getWeighData(String machineCode) {
        block53: {
            BaseLogger.log("2", null, null, "XXXXXXXXXXXXXXXXXXXXXX[ WeighUtil ]XXXXXXXXXXXXXXXXXXXX");
            Socket clientSocket = null;
            BufferedWriter out = null;
            BufferedReader in = null;
            String errorStr = "";
            try {
                try {
                    this.initMachineParams();
                    if (machineConns == null || machineCode == null || machineCode.isEmpty()) break block53;
                    MachineConnection connection = machineConns.get(machineCode);
                    if (connection != null) {
                        String respSep = ",";
                        int port = connection.getPort();
                        String telnetServer = connection.getIp();
                        String dataformat = connection.getDataFormat();
                        try {
                            if (clientSocket == null || clientSocket.isClosed()) {
                                clientSocket = new Socket(telnetServer, port);
                                clientSocket.setKeepAlive(true);
                            }
                        }
                        catch (Exception ce) {
                            errorStr = "TELNET_MESSAGE : " + ce.getMessage();
                            BaseLogger.log("3", null, null, "Message ::" + errorStr);
                            this.responseStr = errorStr;
                        }
                        if (clientSocket != null && !clientSocket.isClosed()) {
                            out = new BufferedWriter(new OutputStreamWriter(clientSocket.getOutputStream()));
                            in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                            this.responseStr = "";
                            if (dataformat != null && dataformat.equalsIgnoreCase("GNT")) {
                                String telnetResponse = in.readLine();
                                while (telnetResponse != null && telnetResponse.trim().length() > 0) {
                                    this.responseStr = String.valueOf(this.responseStr) + telnetResponse + respSep;
                                    BaseLogger.log("3", null, null, "responseStr[" + this.responseStr + "]");
                                    telnetResponse = in.readLine();
                                }
                            } else if (dataformat != null && dataformat.equalsIgnoreCase("dprint-GNT")) {
                                StringBuilder data = new StringBuilder();
                                Boolean dprintStartFound = false;
                                Boolean isDataFound = false;
                                String dprint = "";
                                int count = 0;
                                String telnetResponse = in.readLine();
                                BaseLogger.log("3", null, null, telnetResponse);
                                telnetResponse = in.readLine();
                                BaseLogger.log("3", null, null, telnetResponse);
                                out.write("user admin \n");
                                out.flush();
                                telnetResponse = in.readLine();
                                BaseLogger.log("3", null, null, telnetResponse);
                                telnetResponse = in.readLine();
                                BaseLogger.log("3", null, null, telnetResponse);
                                out.write("printout 1\n");
                                out.flush();
                                BaseLogger.log("3", null, null, "Ready: " + in.ready());
                                while (in.ready()) {
                                    telnetResponse = in.readLine();
                                    if (telnetResponse == null) continue;
                                    if ((telnetResponse = telnetResponse.trim()).contains("</dprint>") && telnetResponse.length() > "</dprint>".length()) {
                                        telnetResponse = telnetResponse.replaceAll("</dprint>", "");
                                        telnetResponse = telnetResponse.trim();
                                    }
                                    if (telnetResponse.indexOf("<dprint>") != -1) {
                                        dprintStartFound = true;
                                        dprint = telnetResponse;
                                    }
                                    if (telnetResponse.indexOf("<dprint>") == -1 && telnetResponse.indexOf("</dprint>") == -1 && telnetResponse.indexOf("number PRINTOUT streams") == -1 && !telnetResponse.trim().equalsIgnoreCase(">")) {
                                        data.append(String.valueOf(telnetResponse) + respSep + " ");
                                        isDataFound = true;
                                        ++count;
                                    }
                                    if (!dprintStartFound.booleanValue() && count == 3) {
                                        int lastIndex = data.toString().lastIndexOf(respSep);
                                        this.responseStr = "<dprint> " + data.toString().substring(0, lastIndex).replaceAll(">", "") + " </dprint>";
                                        BaseLogger.log("3", null, null, this.responseStr);
                                        count = 0;
                                    } else {
                                        if (!dprintStartFound.booleanValue() || count != 2) continue;
                                        dprintStartFound = false;
                                        count = 0;
                                        int lastIndex = data.toString().lastIndexOf(respSep);
                                        String dataStr = String.valueOf(dprint) + ", " + data.toString().substring(0, lastIndex) + " </dprint>";
                                        int index = dataStr.toString().indexOf("<dprint>");
                                        if (index != -1) {
                                            dataStr = dataStr.substring(index);
                                        }
                                        data = new StringBuilder(dataStr);
                                        BaseLogger.log("3", null, null, "Expected format[<dprint> 123.4 kg T , 123.4 kg N , 123.4 kg </dprint>]");
                                        BaseLogger.log("3", null, null, "Current data[" + data.toString() + "]");
                                        this.responseStr = data.toString();
                                    }
                                    break;
                                }
                            } else if (dataformat != null && dataformat.equalsIgnoreCase("dprint-G")) {
                                StringBuilder data = new StringBuilder();
                                Boolean dprintStartFound = false;
                                Boolean isDataFound = false;
                                String dprint = "";
                                int count = 0;
                                String telnetResponse = in.readLine();
                                BaseLogger.log("3", null, null, telnetResponse);
                                telnetResponse = in.readLine();
                                BaseLogger.log("3", null, null, telnetResponse);
                                out.write("user admin \n");
                                out.flush();
                                telnetResponse = in.readLine();
                                BaseLogger.log("3", null, null, telnetResponse);
                                telnetResponse = in.readLine();
                                BaseLogger.log("3", null, null, telnetResponse);
                                out.write("printout 1\n");
                                out.flush();
                                BaseLogger.log("3", null, null, "Ready: " + in.ready());
                                while (in.ready()) {
                                    telnetResponse = in.readLine();
                                    if (telnetResponse == null) continue;
                                    BaseLogger.log("3", null, null, "telnetResponse[" + telnetResponse + "]");
                                    telnetResponse = telnetResponse.trim();
                                    if (telnetResponse.contains("</dprint>") && telnetResponse.length() > "</dprint>".length()) {
                                        telnetResponse = telnetResponse.replaceAll("</dprint>", "");
                                        telnetResponse = telnetResponse.trim();
                                    }
                                    if (telnetResponse.indexOf("<dprint>") != -1 && telnetResponse.indexOf(">") + 1 != telnetResponse.trim().length()) {
                                        dprintStartFound = true;
                                        dprint = telnetResponse;
                                    }
                                    if (telnetResponse.indexOf("<dprint>") == -1 && telnetResponse.indexOf("</dprint>") == -1 && telnetResponse.indexOf("number PRINTOUT streams") == -1 && !telnetResponse.trim().equalsIgnoreCase(">")) {
                                        data.append(String.valueOf(telnetResponse) + " ");
                                        isDataFound = true;
                                        ++count;
                                    }
                                    if (!dprintStartFound.booleanValue() && count == 1) {
                                        this.responseStr = "<dprint> " + data.toString().replaceAll(">", "") + " </dprint>";
                                        BaseLogger.log("3", null, null, this.responseStr);
                                        count = 0;
                                    } else {
                                        if (!dprintStartFound.booleanValue() || count != 0) continue;
                                        dprintStartFound = false;
                                        String dataStr = String.valueOf(dprint) + " </dprint>";
                                        int index = dataStr.toString().indexOf("<dprint>");
                                        if (index != -1) {
                                            dataStr = dataStr.substring(index);
                                        }
                                        data = new StringBuilder(dataStr);
                                        BaseLogger.log("3", null, null, data.toString());
                                        this.responseStr = data.toString();
                                    }
                                    break;
                                }
                            }
                            out.close();
                            in.close();
                        }
                        BaseLogger.log("3", null, null, "dataformat[" + dataformat + "] responseStr[" + this.responseStr + "]");
                        break block53;
                    }
                    this.responseStr = "TELNET_MESSAGE : Either MachineConnections.xml not present or Machine code not configure in MachineConnections.xml !";
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception :WeighUtil: doPost :==>" + e.getMessage());
                    this.responseStr = "TELNET_MESSAGE :" + e.getMessage();
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            BaseLogger.log("0", null, null, e2.getMessage());
                        }
                    }
                    if (clientSocket != null && !clientSocket.isClosed()) {
                        try {
                            clientSocket.close();
                        }
                        catch (IOException e3) {
                            BaseLogger.log("0", null, null, e3.getMessage());
                        }
                    }
                }
                catch (Error er) {
                    block55: {
                        BaseLogger.log("0", null, null, "Inside error");
                        er.printStackTrace();
                        if (in == null) break block55;
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            BaseLogger.log("0", null, null, e.getMessage());
                        }
                    }
                    if (clientSocket != null && !clientSocket.isClosed()) {
                        try {
                            clientSocket.close();
                        }
                        catch (IOException e) {
                            BaseLogger.log("0", null, null, e.getMessage());
                        }
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        BaseLogger.log("0", null, null, e.getMessage());
                    }
                }
                if (clientSocket != null && !clientSocket.isClosed()) {
                    try {
                        clientSocket.close();
                    }
                    catch (IOException e) {
                        BaseLogger.log("0", null, null, e.getMessage());
                    }
                }
            }
        }
        return this.responseStr;
    }

    private void initMachineParams() {
        String pathname = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "machineConnection.xml";
        try {
            File fXmlFile = new File(pathname);
            if (fXmlFile != null) {
                Date date = new Date(fXmlFile.lastModified());
                if (LAST_CHANGE_DATE == null) {
                    LAST_CHANGE_DATE = date;
                    machineConns = this.getMachineParams(fXmlFile);
                }
                if (!date.equals(LAST_CHANGE_DATE)) {
                    BaseLogger.log("3", null, null, "pathname[" + pathname + "] LAST_MODIFIED_DATE[" + LAST_CHANGE_DATE + "] readFile date[" + date + "]");
                    LAST_CHANGE_DATE = date;
                    machineConns = this.getMachineParams(fXmlFile);
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, e.getMessage());
        }
    }

    private Map<String, MachineConnection> getMachineParams(File fXmlFile) {
        try {
            if (fXmlFile != null) {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(fXmlFile);
                doc.getDocumentElement().normalize();
                BaseLogger.log("3", null, null, "Root element :" + doc.getDocumentElement().getNodeName());
                NodeList nList = doc.getElementsByTagName("machine");
                BaseLogger.log("3", null, null, "----------------------------");
                int temp = 0;
                while (temp < nList.getLength()) {
                    Node nNode = nList.item(temp);
                    BaseLogger.log("3", null, null, "\nCurrent Element :" + nNode.getNodeName());
                    if (nNode.getNodeType() == 1) {
                        Element eElement = (Element)nNode;
                        MachineConnection connection = new MachineConnection();
                        String mcCode = eElement.getAttribute("code");
                        String type = eElement.getElementsByTagName("type").item(0).getTextContent();
                        String ip = eElement.getElementsByTagName("ip").item(0).getTextContent();
                        String protocol = eElement.getElementsByTagName("protocol").item(0).getTextContent();
                        String port = eElement.getElementsByTagName("port").item(0).getTextContent();
                        String dataFormat = eElement.getElementsByTagName("dataformat").item(0).getTextContent();
                        connection.setType(type);
                        connection.setProtocol(protocol);
                        connection.setPort(Integer.parseInt(port));
                        connection.setIp(ip);
                        connection.setDataFormat(dataFormat);
                        machineConns.put(mcCode, connection);
                    }
                    ++temp;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in getMachineParams :: " + e.getMessage());
        }
        return machineConns;
    }
}

