/*
 * Decompiled with CFR 0.152.
 */
package ibase.hibernate.dao;

import ibase.ejb.CommonDBAccessEJB;
import ibase.hibernate.bean.DocTypeProc;
import ibase.hibernate.utility.HibernateUtil;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import org.json.JSONObject;

public class DocTypeProcDAO {
    public void saveOverviewData(UserInfoBean userInfo, JSONObject overViewObj) throws ITMException {
        DocTypeProc docTypeProcDoc = null;
        try {
            String transDB = userInfo.getTransDB();
            String userID = userInfo.getLoginCode();
            String docType = this.checkNull(overViewObj.optString("doc_type"));
            String entType = this.checkNull(overViewObj.optString("ent_type"));
            String entCode = this.checkNull(overViewObj.optString("ent_code"));
            String fileType = this.checkNull(overViewObj.optString("file_type"));
            String chgTerm = userInfo.getRemoteAddress();
            Session session = HibernateUtil.getSessionFactory(transDB).openSession();
            Transaction tx = session.beginTransaction();
            docTypeProcDoc = this.getDocTypeProcObj(docType, entType, entCode, fileType, transDB);
            if (docTypeProcDoc == null) {
                BaseLogger.log("3", userInfo, null, "In if DocTypeProc is null");
                docTypeProcDoc = new DocTypeProc();
                docTypeProcDoc.setDocType(this.checkNull(overViewObj.optString("doc_type")));
                docTypeProcDoc.setEntType(this.checkNull(overViewObj.optString("ent_type")));
                docTypeProcDoc.setEntCode(this.checkNull(overViewObj.optString("ent_code")));
                docTypeProcDoc.setFileType(this.checkNull(overViewObj.optString("file_type")));
            }
            docTypeProcDoc.setEntName(this.checkNull(overViewObj.optString("ent_name")));
            docTypeProcDoc.setProcMtd(this.checkNull(overViewObj.optString("proc_mtd")));
            docTypeProcDoc.setProcInstr(this.checkNull(overViewObj.optString("proc_instr")));
            BaseLogger.log("2", userInfo, null, "In saveOverviewData data to insert or update :[" + docTypeProcDoc + "]");
            session.saveOrUpdate((Object)docTypeProcDoc);
            session.flush();
            tx.commit();
            session.close();
        }
        catch (HibernateException he) {
            BaseLogger.log("0", userInfo, null, "HibernateException in saveOverviewData :[" + E12GenericUtility.getStackTrace((Exception)((Object)he)) + "]");
            he.printStackTrace();
            throw new ITMException((Exception)((Object)he));
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception in saveOverviewData :[" + E12GenericUtility.getStackTrace(e) + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    public JSONObject getDocTypeProcParams(UserInfoBean userInfo, String docType, String entType, String entCode, String fileType) throws ITMException {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
        ConnDriver connDriver = new ConnDriver();
        JSONObject docTypeProcObj = new JSONObject();
        String prcMethod = "";
        String prcInstr = "";
        try {
            try {
                docTypeProcObj.put("doc_type", (Object)docType);
                docTypeProcObj.put("ent_type", (Object)entType);
                docTypeProcObj.put("ent_code", (Object)entCode);
                docTypeProcObj.put("file_type", (Object)fileType);
                conn = connDriver.getConnectDB(userInfo);
                String sql = "SELECT PROC_MTD, PROC_INSTR, ENT_NAME FROM DOC_TYPE_PROC WHERE DOC_TYPE = ? AND ENT_TYPE = ? AND ENT_CODE = ? AND FILE_TYPE = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, docType);
                pstmt.setString(2, entType);
                pstmt.setString(3, entCode);
                pstmt.setString(4, fileType);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    docTypeProcObj.put("proc_mtd", (Object)rs.getString("PROC_MTD"));
                    docTypeProcObj.put("proc_instr", (Object)rs.getString("PROC_INSTR"));
                    docTypeProcObj.put("ent_name", (Object)rs.getString("ENT_NAME"));
                    BaseLogger.log("3", null, null, "docTypeProcObj :: configured proc_mtd & proc_instr : [" + docTypeProcObj.toString() + "]");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if ("".equalsIgnoreCase(E12GenericUtility.checkNull(docTypeProcObj.optString("proc_mtd"))) || "".equalsIgnoreCase(E12GenericUtility.checkNull(docTypeProcObj.optString("proc_instr")))) {
                    String defaultSql = "SELECT DEF_PROC_MTD, DEF_PROC_INSTR FROM DOC_TYPE WHERE DOC_TYPE=?";
                    pstmt = conn.prepareStatement(defaultSql);
                    pstmt.setString(1, docType);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        if ("".equalsIgnoreCase(E12GenericUtility.checkNull(docTypeProcObj.optString("proc_mtd")))) {
                            docTypeProcObj.put("proc_mtd", (Object)rs.getString("DEF_PROC_MTD"));
                        }
                        if ("".equalsIgnoreCase(E12GenericUtility.checkNull(docTypeProcObj.optString("proc_instr")))) {
                            docTypeProcObj.put("proc_instr", (Object)rs.getString("DEF_PROC_INSTR"));
                        }
                        BaseLogger.log("3", null, null, "docTypeProcObj :: default proc_mtd & proc_instr : [" + docTypeProcObj.toString() + "]");
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, "DocTypeProcDAO.getDocTypeProcParams()", " Exception in getDocTypeProcParams : " + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, "DocTypeProcDAO.getDocTypeProcParams()", " Exception in getDocTypeProcParams Finally : " + e);
            }
        }
        return docTypeProcObj;
    }

    public String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    private DocTypeProc getDocTypeProcObj(String docType, String entType, String entCode, String fileType, String transDB) {
        DocTypeProc docTypeProc = null;
        try {
            Session session = HibernateUtil.getSessionFactory(transDB).openSession();
            Query query = session.createQuery("from DocTypeProc where docType='" + docType + "' and entType='" + entType + "' and entCode='" + entCode + "' and fileType='" + fileType + "'");
            List docTypeProcList = query.getResultList();
            BaseLogger.log("3", null, null, "data for geting getDocTypeProcObj in docTypeProcList:::" + docTypeProcList);
            if (docTypeProcList != null && docTypeProcList.size() > 0) {
                docTypeProc = (DocTypeProc)docTypeProcList.get(0);
                BaseLogger.log("3", null, null, "data for geting getDocTypeProcObj in docTypeProc:::" + docTypeProc);
            }
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException getDocTypeProcObj :");
            BaseLogger.log("0", null, null, e.getMessage());
            BaseLogger.log("0", null, null, "Exception in [getDocTypeProcObj]:::" + e.getMessage());
        }
        return docTypeProc;
    }
}

