/*
 * Decompiled with CFR 0.152.
 */
package ibase.sd.project.deploy.wrkflw;

import ibase.sd.project.deploy.ObjDeployment;
import ibase.sd.project.deploy.wrkflw.WFDesign;
import ibase.sd.project.deploy.wrkflw.WrkflwXPDLObject;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.EventManagerEJB;
import ibase.webitm.ejb.InfinispanLocal;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.InitialContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ObjDeploymentWorkflow
implements ObjDeployment {
    static InfinispanLocal infinispanLocalObj = null;
    static Hashtable jndiProperties = null;
    static InitialContext ctx = null;
    private String objName = "";

    static {
        try {
            if (CommonConstants.CACHE_OPT != 0) {
                jndiProperties = new Hashtable();
                jndiProperties.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
                ctx = new InitialContext(jndiProperties);
                infinispanLocalObj = (InfinispanLocal)ctx.lookup("ibase/InfinispanEJB/local");
                BaseLogger.log((String)"1", null, null, (Object)"DBAccessEJB infinispanLocalObj created.....");
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception in ObjDeploymentWorkflow static block:[" + e.getMessage() + "]"));
            e.printStackTrace();
        }
    }

    public String getObjName() {
        return this.objName;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    @Override
    public String initiateDeployment(String enterpriseUrl, String appId, String jwtToken, String designId, String projectId, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("initiateDeployment :: appId : [" + appId + "] enterpriseUrl : [" + enterpriseUrl + "] jwtToken : [" + jwtToken + "]"));
        JSONObject responseJson = new JSONObject();
        String result = "";
        String status = "error";
        try {
            JSONObject resultJson = new JSONObject();
            String response = "";
            int deployCtr = 0;
            DBAccessEJB dbAccess = new DBAccessEJB();
            String objName = dbAccess.getDBColumnValue("WF_DESIGN", "OBJ_NAME__INVOKE", " WF_DESIGN_ID = '" + designId + "' ", userInfo.getTransDB());
            this.setObjName(objName);
            dbAccess = null;
            WFDesign wfDesign = new WFDesign();
            JSONObject wfDesignJson = wfDesign.getWFDesign(designId, userInfo);
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("wfDesignJson : [" + wfDesignJson + "]"));
            JSONObject fileData = new JSONObject();
            fileData.put("file_name", (Object)designId);
            fileData.put("file_loc", (Object)("deploy" + File.separator + projectId));
            fileData.put("file_type", (Object)"json");
            StringBuffer queryParam = new StringBuffer();
            queryParam.append("fileData=").append(wfDesignJson.toString());
            queryParam.append("&fileDetails=").append(fileData.toString());
            queryParam.append("&JWT=").append(jwtToken);
            queryParam.append("&APP_ID=").append(appId);
            String requestURL = String.valueOf(enterpriseUrl) + "/ibase/rest/ExtAuthAppService/fileWrite";
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("requestURL [" + requestURL + "]"));
            JSONObject serviceResponseJson = E12GenericUtility.callJsonResponseService((String)requestURL, (String)queryParam.toString(), null);
            String responseStatus = serviceResponseJson.getString("status");
            response = serviceResponseJson.getString("results");
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("response : [" + response + "]"));
            if (!"success".equalsIgnoreCase(responseStatus)) {
                return serviceResponseJson.toString();
            }
            JSONObject fileWriteRespJson = new JSONObject(response);
            String fileLoc = fileWriteRespJson.getString("file_loc");
            String fileName = fileWriteRespJson.getString("file_name");
            response = String.valueOf(fileName) + " file has been written successfully to the '" + fileLoc + "' path";
            resultJson.put("" + ++deployCtr, (Object)response);
            WrkflwXPDLObject wfXpdlObject = new WrkflwXPDLObject();
            String xpdlFilePath = wfXpdlObject.buildWrkflwXPDL(designId, userInfo);
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("xpdlFileName [" + xpdlFilePath + "]"));
            String xpdlFileName = xpdlFilePath.substring(xpdlFilePath.lastIndexOf(File.separator) + 1, xpdlFilePath.lastIndexOf("."));
            fileData = new JSONObject();
            fileData.put("file_name", (Object)xpdlFileName);
            fileData.put("file_loc", (Object)("deploy" + File.separator + projectId));
            fileData.put("file_type", (Object)"xml");
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            paramsMap.put("file", new File(xpdlFilePath));
            paramsMap.put("fileDetails", fileData.toString());
            paramsMap.put("JWT", jwtToken);
            paramsMap.put("APP_ID", appId);
            requestURL = String.valueOf(enterpriseUrl) + "/ibase/rest/ExtAuthAppService/writeFileObject";
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("requestURL [" + requestURL + "]"));
            serviceResponseJson = E12GenericUtility.callMultipartJsonResponseService((String)requestURL, paramsMap);
            responseStatus = serviceResponseJson.getString("status");
            response = serviceResponseJson.getString("results");
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("response : [" + response + "]"));
            if (!"success".equalsIgnoreCase(responseStatus)) {
                return serviceResponseJson.toString();
            }
            JSONObject fileWriteRespJson2 = new JSONObject(response);
            String fileLoc2 = fileWriteRespJson2.getString("file_loc");
            String fileName2 = fileWriteRespJson2.getString("file_name");
            response = String.valueOf(fileName2) + " file object has been written successfully to the '" + fileLoc2 + "' path";
            resultJson.put("" + ++deployCtr, (Object)response);
            queryParam = new StringBuffer();
            queryParam.append("PROJECT_ID=").append(projectId);
            queryParam.append("&DESIGN_ID=").append(designId);
            queryParam.append("&JWT=").append(jwtToken);
            queryParam.append("&APP_ID=").append(appId);
            requestURL = String.valueOf(enterpriseUrl) + "/ibase/rest/WorkFlowService/deployComponents";
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("requestURL [" + requestURL + "]"));
            serviceResponseJson = E12GenericUtility.callJsonResponseService((String)requestURL, (String)queryParam.toString(), null);
            responseStatus = serviceResponseJson.getString("status");
            response = serviceResponseJson.getString("results");
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("response : [" + response + "]"));
            if (!"success".equalsIgnoreCase(responseStatus)) {
                return serviceResponseJson.toString();
            }
            JSONArray deployResponseJsonArr = new JSONArray(response);
            int respCtr = 0;
            while (respCtr < deployResponseJsonArr.length()) {
                response = deployResponseJsonArr.getString(respCtr);
                resultJson.put("" + ++deployCtr, (Object)response);
                ++respCtr;
            }
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("response : [" + response + "]"));
            status = "success";
            responseJson = new JSONObject();
            responseJson.put("status", (Object)status);
            responseJson.put("results", (Object)resultJson);
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
            BaseLogger.log((String)"0", null, null, (Object)("UnsupportedOperationException :: writeFileObject : [" + e.getMessage() + "]"));
            try {
                result = new E12GenericUtility().createErrorString((Exception)e);
                status = "exception";
                responseJson = new JSONObject();
                responseJson.put("status", (Object)status);
                responseJson.put("results", (Object)result);
            }
            catch (JSONException e1) {
                e1.printStackTrace();
                throw new ITMException((Exception)e);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            BaseLogger.log((String)"0", null, null, (Object)("JSONException :: writeFileObject : [" + e.getMessage() + "]"));
            try {
                result = new E12GenericUtility().createErrorString((Exception)((Object)e));
                status = "exception";
                responseJson = new JSONObject();
                responseJson.put("status", (Object)status);
                responseJson.put("results", (Object)result);
            }
            catch (JSONException e1) {
                e1.printStackTrace();
                throw new ITMException((Exception)((Object)e));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            BaseLogger.log((String)"0", null, null, (Object)("IOException :: writeFileObject : [" + e.getMessage() + "]"));
            try {
                result = new E12GenericUtility().createErrorString((Exception)e);
                status = "exception";
                responseJson = new JSONObject();
                responseJson.put("status", (Object)status);
                responseJson.put("results", (Object)result);
            }
            catch (JSONException e1) {
                e1.printStackTrace();
                throw new ITMException((Exception)e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log((String)"0", null, null, (Object)("Exception :: writeFileObject : [" + e.getMessage() + "]"));
            try {
                result = new E12GenericUtility().createErrorString(e);
                status = "exception";
                responseJson = new JSONObject();
                responseJson.put("status", (Object)status);
                responseJson.put("results", (Object)result);
            }
            catch (JSONException e1) {
                e1.printStackTrace();
                throw new ITMException(e);
            }
        }
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("resultJson : [" + responseJson + "]"));
        return responseJson.toString();
    }

    @Override
    public String deploy(String projectId, String designId, UserInfoBean userInfo) throws ITMException {
        JSONArray resultJsonArr = new JSONArray();
        boolean isError = false;
        Connection mConnection = null;
        Statement pStmt = null;
        ResultSet mRs = null;
        try {
            try {
                BaseLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("deploy :: designId [" + designId + "], projectId [" + projectId + "], userInfo [" + userInfo + "]"));
                String response = "";
                ConnDriver mConnDriver = new ConnDriver();
                String transDB = userInfo.getTransDB();
                mConnection = mConnDriver.getConnectDB(transDB);
                mConnDriver = null;
                mConnection.setAutoCommit(false);
                E12GenericUtility genericUtility = new E12GenericUtility();
                String objName = "";
                String invokeMethod = "";
                String xpdlFileName = "";
                String dumpedFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "dump" + File.separator + "deploy" + File.separator + projectId;
                JSONObject workFlowJson = null;
                File designDetJsonFile = new File(String.valueOf(dumpedFilePath) + File.separator + designId + ".json");
                if (designDetJsonFile.exists()) {
                    String wfDesignDetailData = genericUtility.readFile(String.valueOf(dumpedFilePath) + File.separator + designId + ".json");
                    workFlowJson = new JSONObject(wfDesignDetailData);
                } else {
                    WFDesign wfDesign = new WFDesign();
                    workFlowJson = wfDesign.getWFDesign(designId, userInfo);
                }
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("wfDesignJson : [" + workFlowJson + "]"));
                if (workFlowJson != null) {
                    JSONArray wfDesignDataArr = workFlowJson.getJSONArray("WF_DESIGN");
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("wfDesignDataArr : [" + wfDesignDataArr + "]"));
                    JSONObject wfDesignData = wfDesignDataArr.getJSONObject(0);
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("wfDesignData : [" + wfDesignData + "]"));
                    objName = wfDesignData.getString("OBJ_NAME__INVOKE");
                    invokeMethod = wfDesignData.getString("INVOKE_METHOD");
                    xpdlFileName = wfDesignData.getString("XPDL_FILE");
                    response = this.deployWrkFlwXML(projectId, xpdlFileName, userInfo);
                    resultJsonArr.put((Object)response);
                    this.setObjName(objName);
                    String wrkflwOpt = "";
                    if (invokeMethod.equalsIgnoreCase("0")) {
                        wrkflwOpt = "2";
                    } else if (invokeMethod.equalsIgnoreCase("1")) {
                        wrkflwOpt = "4";
                    }
                    String insertSql = "UPDATE TRANSETUP SET WORKFLOW_OPT = ?, WRKFLW_INIT = ? WHERE TRAN_WINDOW = ?";
                    pStmt = mConnection.prepareStatement(insertSql);
                    pStmt.setString(1, wrkflwOpt);
                    pStmt.setString(2, xpdlFileName);
                    pStmt.setString(3, "w_" + objName);
                    int updateCnt = pStmt.executeUpdate();
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    response = updateCnt > 0 ? "WORKFLOW_OPT = '" + wrkflwOpt + "' has been updated in TRANSETUP for " + objName + " object" : "TRANSETUP has not been updated due to some reason";
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("response : [" + response + "]"));
                    resultJsonArr.put((Object)response);
                    JSONArray wfRoleDataArr = workFlowJson.getJSONArray("WF_DESIGN_ROLE");
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("wfRoleDataArr : [" + wfRoleDataArr + "]"));
                    int insertCnt = 0;
                    int roleCtr = 0;
                    while (roleCtr < wfRoleDataArr.length()) {
                        wfDesignData = wfRoleDataArr.getJSONObject(roleCtr);
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("wfDesignRoleData : [" + wfDesignData + "]"));
                        String roleCode = wfDesignData.getString("ROLE_CODE");
                        boolean isRoleExist = true;
                        String wfRoleSql = "SELECT COUNT(*) FROM WF_ROLE WHERE ROLE_CODE = ?";
                        pStmt = mConnection.prepareStatement(wfRoleSql);
                        pStmt.setString(1, roleCode);
                        mRs = pStmt.executeQuery();
                        if (mRs.next() && mRs.getInt(1) == 0) {
                            isRoleExist = false;
                        }
                        if (mRs != null) {
                            mRs.close();
                            mRs = null;
                        }
                        if (pStmt != null) {
                            pStmt.close();
                            pStmt = null;
                        }
                        if (!isRoleExist) {
                            String insertWfRoleSql = "INSERT INTO WF_ROLE (ROLE_CODE,ROLE_TYPE,EVENT_CARR,DESCR,USER_ID,SUBJECT_STR,INCLUDE_DATA,EMAIL_ADDR,ROLE_ENTITY,ROLE_ENTITY_SQL,DYN_ROLE_REF,CHG_DATE,CHG_USER,CHG_TERM) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                            pStmt = mConnection.prepareStatement(insertWfRoleSql);
                            String roleType = wfDesignData.getString("ROLE_TYPE");
                            pStmt.setString(1, wfDesignData.getString("ROLE_CODE"));
                            pStmt.setString(2, roleType);
                            pStmt.setString(3, wfDesignData.getString("EVENT_CARR"));
                            pStmt.setString(4, wfDesignData.getString("DESCR"));
                            pStmt.setString(5, wfDesignData.getString("USER_ID"));
                            pStmt.setString(6, wfDesignData.getString("SUBJECT_STR"));
                            pStmt.setString(7, wfDesignData.getString("INCLUDE_DATA"));
                            pStmt.setString(8, wfDesignData.getString("EMAIL_ADDR"));
                            pStmt.setString(9, wfDesignData.getString("ROLE_ENTITY"));
                            pStmt.setString(10, wfDesignData.getString("ROLE_ENTITY_SQL"));
                            pStmt.setString(11, wfDesignData.getString("DYN_ROLE_REF"));
                            pStmt.setTimestamp(12, new Timestamp(System.currentTimeMillis()));
                            pStmt.setString(13, userInfo.getLoginCode());
                            pStmt.setString(14, userInfo.getTermId());
                            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("(" + (insertCnt += pStmt.executeUpdate()) + ") record inserted"));
                            if (pStmt != null) {
                                pStmt.close();
                                pStmt = null;
                            }
                            response = String.valueOf(roleCode) + " has been inserted successfully in WF_ROLE";
                            resultJsonArr.put((Object)response);
                            if ("S".equalsIgnoreCase(roleType)) {
                                if ("".equals(E12GenericUtility.checkNull((String)wfDesignData.getString("USER_ID")))) {
                                    response = String.valueOf(roleCode) + " role has not been inserted in WF_ROLE_USERS due to USERID is blank";
                                } else {
                                    String insertWfRoleUsersSql = "INSERT INTO WF_ROLE_USERS (ROLE_CODE,USERID,CHG_DATE,CHG_USER,CHG_TERM) VALUES (?,?,?,?,?)";
                                    pStmt = mConnection.prepareStatement(insertWfRoleUsersSql);
                                    pStmt.setString(1, wfDesignData.getString("ROLE_CODE"));
                                    pStmt.setString(2, wfDesignData.getString("USER_ID"));
                                    pStmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                                    pStmt.setString(4, userInfo.getLoginCode());
                                    pStmt.setString(5, userInfo.getTermId());
                                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("(" + (insertCnt += pStmt.executeUpdate()) + ") record inserted"));
                                    if (pStmt != null) {
                                        pStmt.close();
                                        pStmt = null;
                                    }
                                    response = String.valueOf(roleCode) + " has been inserted successfully in WF_ROLE_USERS";
                                }
                                resultJsonArr.put((Object)response);
                            }
                        } else {
                            response = String.valueOf(roleCode) + " role has not been inserted due to already exist in WF_ROLE";
                            resultJsonArr.put((Object)response);
                        }
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("response : [" + response + "]"));
                        ++roleCtr;
                    }
                    if (invokeMethod.equalsIgnoreCase("1")) {
                        boolean isSubmitEntryExist = true;
                        String serviceCode = "wf_submit_auto";
                        String objActionSql = "SELECT COUNT(1) FROM OBJ_ACTIONS WHERE OBJ_NAME = ? AND TITLE = ? AND SERVICE_CODE = ?";
                        pStmt = mConnection.prepareStatement(objActionSql);
                        pStmt.setString(1, objName);
                        pStmt.setString(2, "Submit");
                        pStmt.setString(3, serviceCode);
                        mRs = pStmt.executeQuery();
                        if (mRs.next() && mRs.getInt(1) == 0) {
                            isSubmitEntryExist = false;
                        }
                        if (mRs != null) {
                            mRs.close();
                            mRs = null;
                        }
                        if (pStmt != null) {
                            pStmt.close();
                            pStmt = null;
                        }
                        if (!isSubmitEntryExist) {
                            String termId;
                            int maxLineNo = 0;
                            objActionSql = "SELECT MAX(LINE_NO) AS LINE_NO FROM OBJ_ACTIONS WHERE OBJ_NAME = ?";
                            pStmt = mConnection.prepareStatement(objActionSql);
                            pStmt.setString(1, objName);
                            mRs = pStmt.executeQuery();
                            if (mRs.next()) {
                                maxLineNo = mRs.getInt("LINE_NO");
                            }
                            if (mRs != null) {
                                mRs.close();
                                mRs = null;
                            }
                            if (pStmt != null) {
                                pStmt.close();
                                pStmt = null;
                            }
                            if ((termId = userInfo.getTermId()) != null && termId.length() > 10) {
                                termId = termId.substring(0, 9);
                            }
                            String insertObjActionSql = "INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,ACTION_TYPE,CHG_DATE,CHG_TERM,CHG_USER) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                            pStmt = mConnection.prepareStatement(insertObjActionSql);
                            pStmt.setString(1, objName);
                            pStmt.setInt(2, ++maxLineNo);
                            pStmt.setString(3, "ibase/resource/objaction/submit.svg");
                            pStmt.setString(4, "Workflow Submit");
                            pStmt.setString(5, serviceCode);
                            pStmt.setString(6, "a");
                            pStmt.setString(7, "S");
                            pStmt.setString(8, "Submit");
                            pStmt.setString(9, "1");
                            pStmt.setString(10, "2");
                            pStmt.setString(11, "U");
                            pStmt.setTimestamp(12, new Timestamp(System.currentTimeMillis()));
                            pStmt.setString(13, userInfo.getLoginCode());
                            pStmt.setString(14, termId);
                            insertCnt = pStmt.executeUpdate();
                            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("(" + insertCnt + ") record inserted"));
                            if (pStmt != null) {
                                pStmt.close();
                                pStmt = null;
                            }
                            response = String.valueOf(serviceCode) + " has been inserted successfully in OBJ_ACTIONS";
                            resultJsonArr.put((Object)response);
                            if (insertCnt > 0 && CommonConstants.CACHE_OPT != 0 && infinispanLocalObj != null) {
                                infinispanLocalObj.clearFormDataCache(null);
                                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"infinispan data cleared");
                            }
                            int updateRightsCnt = 0;
                            try {
                                String updateUserRights = "UPDATE USER_RIGHTS SET RIGHTS = (RIGHTS || 'S') WHERE OBJ_NAME = ? AND RIGHTS <> '*'";
                                pStmt = mConnection.prepareStatement(updateUserRights);
                                pStmt.setString(1, objName);
                                updateRightsCnt = pStmt.executeUpdate();
                                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("(" + updateRightsCnt + ") record updated"));
                                if (pStmt != null) {
                                    pStmt.close();
                                    pStmt = null;
                                }
                            }
                            catch (SQLException e) {
                                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"SQLException :: while updating user_rights");
                                e.printStackTrace();
                                response = "Getting exception (" + e.getMessage() + ") while updating USER_RIGHTS";
                            }
                            if (updateRightsCnt > 0) {
                                response = "Submit action has been updated in USER_RIGHTS";
                            }
                            resultJsonArr.put((Object)response);
                            EventManagerEJB eventManager = new EventManagerEJB();
                            boolean isWfSubmitEventExist = eventManager.isEventExist(objName, serviceCode, userInfo);
                            eventManager = null;
                            if (!isWfSubmitEventExist) {
                                String insertSystemEvents = "INSERT INTO SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,RESULT_HANDLE,COMP_TYPE,COMP_NAME,CHG_DATE,CHG_USER,CHG_TERM)  VALUES ( ?,?,?,?,?,?,?,?,?,?,?,? ) ";
                                pStmt = mConnection.prepareStatement(insertSystemEvents);
                                pStmt.setString(1, objName);
                                pStmt.setString(2, serviceCode);
                                pStmt.setString(3, "1");
                                pStmt.setString(4, "prcm_default_ejb");
                                pStmt.setNull(5, 12);
                                pStmt.setString(6, "0");
                                pStmt.setString(7, "2");
                                pStmt.setString(8, "JB");
                                pStmt.setString(9, "ibase.webitm.utility.GenericSubmit");
                                pStmt.setTimestamp(10, new Timestamp(System.currentTimeMillis()));
                                pStmt.setString(11, userInfo.getLoginCode());
                                pStmt.setString(12, termId);
                                int insertSystemEventsCnt = pStmt.executeUpdate();
                                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("(" + insertSystemEventsCnt + ") record inserted into SYSTEM_EVENTS"));
                                if (pStmt != null) {
                                    pStmt.close();
                                    pStmt = null;
                                }
                                if (insertSystemEventsCnt > 0) {
                                    response = String.valueOf(serviceCode) + " event has been added in SYSTEM_EVENTS";
                                    resultJsonArr.put((Object)response);
                                }
                            } else {
                                response = String.valueOf(serviceCode) + " event has not been inserted due to already exist in SYSTEM_EVENTS";
                                resultJsonArr.put((Object)response);
                            }
                        } else {
                            response = String.valueOf(serviceCode) + " action has not been inserted due to already exist in OBJ_ACTIONS";
                            resultJsonArr.put((Object)response);
                        }
                    }
                    JSONArray wfRouteDataArr = workFlowJson.getJSONArray("WF_DESIGN_ROUTE");
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("wfRouteDataArr : [" + wfRouteDataArr + "]"));
                    int routeCtr = 0;
                    while (routeCtr < wfRouteDataArr.length()) {
                        wfDesignData = wfRouteDataArr.getJSONObject(routeCtr);
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("wfDesignRoleData : [" + wfDesignData + "]"));
                        if (wfDesignData.has("ACTIVITY_INPUT")) {
                            String activityInput = wfDesignData.getString("ACTIVITY_INPUT");
                            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("activityInput : [" + activityInput + "]"));
                            if (activityInput != null && activityInput.length() > 0) {
                                JSONObject activityInputJson = new JSONObject(activityInput);
                                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("activityInputJson : [" + activityInputJson + "]"));
                                if (activityInputJson.has("xsl_file_name")) {
                                    String xslFileName = activityInputJson.getString("xsl_file_name");
                                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("xslFileName : [" + xslFileName + "]"));
                                    response = this.deployWrkFlwXSL(projectId, xslFileName, objName, userInfo);
                                    resultJsonArr.put((Object)response);
                                }
                            }
                        }
                        ++routeCtr;
                    }
                }
                if (mConnection != null) {
                    mConnection.commit();
                }
            }
            catch (ITMException itme) {
                isError = true;
                BaseLogger.log((String)"0", null, null, (Object)("ITMException :: ObjDeploymentWorkflow : deploy : [" + itme.getMessage() + "]"));
                itme.printStackTrace();
                throw itme;
            }
            catch (Exception e) {
                isError = true;
                BaseLogger.log((String)"0", null, null, (Object)("Exception :: ObjDeploymentWorkflow : deploy : [" + e.getMessage() + "]"));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mRs != null) {
                    mRs.close();
                    mRs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (mConnection != null) {
                    if (!isError) {
                        mConnection.commit();
                    } else {
                        mConnection.rollback();
                    }
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("responseJson : [" + resultJsonArr + "]"));
        return resultJsonArr.toString();
    }

    private String deployWrkFlwXML(String projectId, String xpdlFileName, UserInfoBean userInfo) throws ITMException {
        String response = "";
        E12GenericUtility genericUtility = new E12GenericUtility();
        String dumpedFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "dump" + File.separator + "deploy" + File.separator + projectId;
        String xpdlFileDeployPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator + "wrkflw";
        File src = new File(String.valueOf(dumpedFilePath) + File.separator + xpdlFileName + ".xml");
        if (src.exists()) {
            File dest = new File(String.valueOf(xpdlFileDeployPath) + File.separator + xpdlFileName + ".xml");
            if (!dest.exists()) {
                genericUtility.copyFile(src, dest);
                response = String.valueOf(xpdlFileName) + ".xml" + " file copied successfully to the '" + xpdlFileDeployPath + "' path";
            } else {
                response = String.valueOf(xpdlFileName) + ".xml" + " file has not been copied due to already exist at '" + xpdlFileDeployPath + "' path";
            }
        }
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("deployWrkFlwXML :: response : [" + response + "]"));
        return response;
    }

    private String deployWrkFlwXSL(String projectId, String xslFileName, String objName, UserInfoBean userInfo) throws ITMException {
        String response = "";
        E12GenericUtility genericUtility = new E12GenericUtility();
        String dumpedXSLFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "dump" + File.separator + "deploy" + File.separator + projectId;
        String summaryXSLFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator + "webitm" + File.separator + "xsl" + File.separator + "Standard";
        String xslFileDeployPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "xsl";
        File xslFileSrc = new File(String.valueOf(dumpedXSLFilePath) + File.separator + xslFileName + ".xsl");
        if (xslFileSrc.exists()) {
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"xslFileSrc is exist");
            File xslFileDest = new File(String.valueOf(xslFileDeployPath) + File.separator + xslFileName + ".xsl");
            if (!xslFileDest.exists()) {
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"xslFileDest is not exist");
                genericUtility.copyFile(xslFileSrc, xslFileDest);
                response = String.valueOf(xslFileName) + ".xsl" + " file copied successfully to the '" + xslFileDeployPath + "' path";
            } else {
                response = String.valueOf(xslFileName) + ".xsl" + " file has not been copied due to already exist at '" + xslFileDeployPath + "' path";
            }
        } else {
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"xslFileSrc is not exist");
            xslFileSrc = new File(String.valueOf(summaryXSLFilePath) + File.separator + objName + "_preview" + ".xsl");
            if (xslFileSrc.exists()) {
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"summaryXSLFile is exist");
                File xslFileDest = new File(String.valueOf(xslFileDeployPath) + File.separator + xslFileName + ".xsl");
                if (!xslFileDest.exists()) {
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"xslFileDest is not exist");
                    genericUtility.copyFile(xslFileSrc, xslFileDest);
                    response = String.valueOf(xslFileName) + ".xsl" + " file copied successfully to the '" + xslFileDeployPath + "' path";
                } else {
                    response = String.valueOf(xslFileName) + ".xsl" + " file has not been copied due to already exist at '" + xslFileDeployPath + "' path";
                }
            }
        }
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("deployWrkFlwXSL :: response : [" + response + "]"));
        return response;
    }
}

