/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.webitm.utility.ITMException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class Decryption {
    private Cipher cipher = null;

    public String decrypt(String inputData, String cryptoAlgo, String secrtKey) throws ITMException {
        BaseLogger.log("3", null, null, "Inside decrypt String");
        BaseLogger.log("3", null, null, "inputData::: " + inputData);
        BaseLogger.log("3", null, null, "cryptoAlgo::: " + cryptoAlgo);
        BaseLogger.log("3", null, null, "secrtKey::: " + secrtKey);
        this.cipher = null;
        BaseLogger.log("3", null, null, "cryptoAlgo : [" + cryptoAlgo + "]");
        switch (cryptoAlgo) {
            case "RSA": {
                return this.decryptRSAData(inputData, secrtKey);
            }
            case "AES": {
                return this.decryptAESData(inputData, secrtKey);
            }
            case "AES256": {
                return this.decryptAES256Data(inputData, secrtKey);
            }
        }
        return "";
    }

    public JSONObject decrypt(JSONObject inputDataJson, String cryptoAlgo, String secrtKey) throws ITMException {
        BaseLogger.log("3", null, null, "Inside decrypt JSONObject");
        BaseLogger.log("3", null, null, "inputDataJson::: " + inputDataJson);
        BaseLogger.log("3", null, null, "cryptoAlgo::: " + cryptoAlgo);
        BaseLogger.log("3", null, null, "secrtKey::: " + secrtKey);
        this.cipher = null;
        BaseLogger.log("3", null, null, "cryptoAlgo : [" + cryptoAlgo + "]");
        switch (cryptoAlgo) {
            case "RSA": {
                return this.decryptRSAData(inputDataJson, secrtKey);
            }
            case "AES": {
                return this.decryptAESData(inputDataJson, secrtKey);
            }
            case "AES256": {
                return this.decryptAES256Data(inputDataJson, secrtKey);
            }
        }
        return inputDataJson;
    }

    private void setRSACipher(String secrtKey) throws ITMException {
        BaseLogger.log("3", null, null, "In the setRSACipher");
        BaseLogger.log("3", null, null, "secrtKey::: " + secrtKey);
        try {
            String secretKeyFilePath = new File(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + secrtKey;
            BaseLogger.log("3", null, null, "secretKeyFilePath : [" + secretKeyFilePath + "]");
            PrivateKey privateKey = Decryption.readPrivatekey(secretKeyFilePath);
            BaseLogger.log("3", null, null, "privateKey.getAlgorithm : [" + privateKey.getAlgorithm() + "]");
            this.cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            this.cipher.init(2, privateKey);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: setRSACipher : [" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    private String decryptRSAData(String inputData, String secrtKey) throws ITMException {
        BaseLogger.log("3", null, null, "In the decryptRSAData String");
        BaseLogger.log("3", null, null, "inputData::: " + inputData);
        BaseLogger.log("3", null, null, "secrtKey::: " + secrtKey);
        String decryptedData = "";
        try {
            this.setRSACipher(secrtKey);
            decryptedData = this.decryptData(inputData);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: decryptRSAData : [" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return decryptedData;
    }

    private JSONObject decryptRSAData(JSONObject inputDataJson, String secrtKey) throws ITMException {
        BaseLogger.log("3", null, null, "In the decryptRSAData JSONObject");
        BaseLogger.log("3", null, null, "inputDataJson::: " + inputDataJson);
        BaseLogger.log("3", null, null, "secrtKey::: " + secrtKey);
        try {
            this.setRSACipher(secrtKey);
            inputDataJson = this.decryptJSONObjectValues(inputDataJson);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: decryptRSAData : [" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return inputDataJson;
    }

    private PrivateKey readRSAPrivateKey(String filePath) {
        BaseLogger.log("3", null, null, "Inside readRSAPrivateKey");
        BaseLogger.log("3", null, null, "filePath::: " + filePath);
        PrivateKey pvt = null;
        try {
            Path path = Paths.get(filePath, new String[0]);
            byte[] bytes = Files.readAllBytes(path);
            PKCS8EncodedKeySpec ks = new PKCS8EncodedKeySpec(bytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            pvt = kf.generatePrivate(ks);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: readRSAPrivateKey : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return pvt;
    }

    private void setAESCipher(String secret) throws ITMException {
        BaseLogger.log("3", null, null, "Inside setAESCipher");
        BaseLogger.log("3", null, null, "secret::: " + secret);
        try {
            ArrayList keylist = this.getAESKey(secret);
            SecretKeySpec secretKey = (SecretKeySpec)keylist.get(1);
            this.cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
            this.cipher.init(2, secretKey);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: setAESCipher : [" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    private String decryptAESData(String inputData, String secret) throws ITMException {
        BaseLogger.log("3", null, null, "Inside decryptAESData String");
        BaseLogger.log("3", null, null, "inputData::: " + inputData);
        BaseLogger.log("3", null, null, "secret::: " + secret);
        String decryptedData = "";
        try {
            this.setAESCipher(secret);
            decryptedData = this.decryptData(inputData);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: decryptAESData : [" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return decryptedData;
    }

    private JSONObject decryptAESData(JSONObject inputDataJson, String secret) throws ITMException {
        BaseLogger.log("3", null, null, "Inside decryptAESData JSONObject");
        BaseLogger.log("3", null, null, "inputDataJson::: " + inputDataJson);
        BaseLogger.log("3", null, null, "secret::: " + secret);
        try {
            this.setAESCipher(secret);
            inputDataJson = this.decryptJSONObjectValues(inputDataJson);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: decryptAESData : [" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return inputDataJson;
    }

    private ArrayList getAESKey(String myKey) {
        BaseLogger.log("3", null, null, "Inside getAESKey");
        BaseLogger.log("3", null, null, "myKey::: " + myKey);
        ArrayList<Object> keyList = new ArrayList<Object>();
        SecretKeySpec secretKey = null;
        byte[] key = null;
        MessageDigest sha = null;
        try {
            key = myKey.getBytes("UTF-8");
            sha = MessageDigest.getInstance("SHA-1");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            secretKey = new SecretKeySpec(key, "AES");
        }
        catch (NoSuchAlgorithmException e) {
            BaseLogger.log("0", null, null, "NoSuchAlgorithmException :: getAESKey : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            BaseLogger.log("0", null, null, "UnsupportedEncodingException :: getAESKey : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        keyList.add(key);
        keyList.add(secretKey);
        return keyList;
    }

    private void setAES256Cipher(String secrtKey) throws ITMException {
        BaseLogger.log("3", null, null, "Inside setAES256Cipher");
        BaseLogger.log("3", null, null, "secrtKey::: " + secrtKey);
        try {
            String[] key = secrtKey.split(":");
            BaseLogger.log("3", null, null, "SECRET_KEY : [" + key[0] + "] SALT: [" + key[1] + "]");
            String SECRET_KEY = key[0];
            String SALT = key[1];
            byte[] iv = new byte[16];
            IvParameterSpec ivspec = new IvParameterSpec(iv);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(SECRET_KEY.toCharArray(), SALT.getBytes(), 65536, 256);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secretKey = new SecretKeySpec(tmp.getEncoded(), "AES");
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            this.cipher.init(2, (Key)secretKey, ivspec);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: setAES256Cipher : [" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    private String decryptAES256Data(String inputData, String secrtKey) throws ITMException {
        BaseLogger.log("3", null, null, "Inside decryptAES256Data String");
        BaseLogger.log("3", null, null, "inputData::: " + inputData);
        BaseLogger.log("3", null, null, "secrtKey::: " + secrtKey);
        String decryptedData = "";
        try {
            this.setAES256Cipher(secrtKey);
            decryptedData = this.decryptData(inputData);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: decryptAES256Data : [" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return decryptedData;
    }

    private JSONObject decryptAES256Data(JSONObject inputDataJson, String secrtKey) throws ITMException {
        BaseLogger.log("3", null, null, "Inside decryptAES256Data JSONObject");
        BaseLogger.log("3", null, null, "inputDataJson::: " + inputDataJson);
        BaseLogger.log("3", null, null, "secrtKey::: " + secrtKey);
        try {
            this.setAES256Cipher(secrtKey);
            inputDataJson = this.decryptJSONObjectValues(inputDataJson);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: decryptAES256Data : [" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return inputDataJson;
    }

    private String decryptData(String inputData) throws ITMException {
        BaseLogger.log("3", null, null, "Inside decryptData");
        BaseLogger.log("3", null, null, "inputData::: " + inputData);
        try {
            inputData = inputData.replace("\\/", "/");
            if (this.cipher != null) {
                BaseLogger.log("3", null, null, "cipher.toString() : [" + this.cipher.toString() + "]");
                BaseLogger.log("3", null, null, "cipher.getAlgorithm() : [" + this.cipher.getAlgorithm() + "]");
                return new String(this.cipher.doFinal(Base64.getDecoder().decode(inputData)));
            }
        }
        catch (IllegalBlockSizeException e) {
            BaseLogger.log("0", null, null, "IllegalBlockSizeException :: getDecryptedData : [" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
        catch (BadPaddingException e) {
            BaseLogger.log("0", null, null, "BadPaddingException :: getDecryptedData : [" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return null;
    }

    public JSONObject decryptJSONObjectValues(JSONObject jsonObject) throws JSONException, ITMException {
        BaseLogger.log("3", null, null, "Inside decryptJSONObjectValues(JSONObject jsonObject)");
        BaseLogger.log("3", null, null, "jsonObject::: " + jsonObject);
        if (jsonObject != null) {
            Iterator jsonObjectIterator = jsonObject.keys();
            String string = "";
            while (jsonObjectIterator.hasNext()) {
                String key = (String)jsonObjectIterator.next();
                Object value = jsonObject.get(key);
                String string2 = string = value instanceof String ? (String)value : null;
                if (string instanceof String) {
                    jsonObject.put(key, (Object)this.decryptData(string));
                    continue;
                }
                this.updateJSONValue(key, value);
            }
        }
        return jsonObject;
    }

    public void decryptJSONArray(String key, JSONArray jsonArray) throws JSONException, ITMException {
        BaseLogger.log("3", null, null, "Inside decryptJSONArray(String key, JSONArray jsonArray)");
        BaseLogger.log("3", null, null, "key::: " + key);
        BaseLogger.log("3", null, null, "jsonArray::: " + jsonArray);
        if (jsonArray != null) {
            int jsonArrItr = 0;
            while (jsonArrItr < jsonArray.length()) {
                Object element = jsonArray.get(jsonArrItr);
                this.updateJSONValue(key, element);
                ++jsonArrItr;
            }
        }
    }

    public void updateJSONValue(String key, Object value) throws JSONException, ITMException {
        BaseLogger.log("3", null, null, "Inside updateJSONValue(String key, Object value)");
        BaseLogger.log("3", null, null, "key::: " + key);
        BaseLogger.log("3", null, null, "value::: " + value);
        if (value instanceof JSONArray) {
            this.decryptJSONArray(key, (JSONArray)value);
        } else if (value instanceof JSONObject) {
            this.decryptJSONObjectValues((JSONObject)value);
        }
    }

    private static String readFile(String fileName) throws Exception {
        BaseLogger.log("3", null, null, "Inside readFile");
        BaseLogger.log("3", null, null, "fileName::: " + fileName);
        StringBuffer fileContent = new StringBuffer();
        BufferedReader bfr = null;
        FileInputStream fMainIn = null;
        String outTempStr = null;
        try {
            System.out.println("readFile : fileName :" + fileName);
            fMainIn = new FileInputStream(fileName);
            bfr = new BufferedReader(new InputStreamReader((InputStream)fMainIn, "UTF-8"));
            while ((outTempStr = bfr.readLine()) != null) {
                fileContent.append(outTempStr);
            }
            bfr.close();
            bfr = null;
        }
        finally {
            block18: {
                try {
                    try {
                        if (bfr != null) {
                            bfr.close();
                            bfr = null;
                        }
                        if (fMainIn != null) {
                            fMainIn.close();
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Exception in releasing file resource :[" + fileName + "]");
                        e.printStackTrace();
                        fMainIn = null;
                        outTempStr = null;
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    fMainIn = null;
                    outTempStr = null;
                    throw throwable;
                }
                fMainIn = null;
                outTempStr = null;
            }
        }
        return fileContent.toString();
    }

    private static PrivateKey readPrivatekey(String filePath) {
        BaseLogger.log("3", null, null, "Inside readPrivatekey");
        BaseLogger.log("3", null, null, "filePath::: " + filePath);
        PrivateKey privateKey = null;
        try {
            String content = Decryption.readFile(filePath);
            System.out.println("content :" + content);
            byte[] decoded = Base64.getDecoder().decode(content);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(decoded);
            privateKey = keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            System.out.println("In readPrivatekey Exception :: [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return privateKey;
    }
}

