package ibase.webitm.utility;

import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.activemq.artemis.api.jms.ActiveMQJMSConstants;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
 
public class JMSSender 
{
	public final static String JMS_USERNAME=CommonConstants.JMS_USERNAME;       //  The role for this user is "guest" in ApplicationRealm
  	public final static String JMS_PASSWORD=CommonConstants.JMS_PASSWORD;  
  	public final static String JMS_CONNECTION_FACTORY=CommonConstants.JMS_CONNECTION_FACTORY;
  	public final static String JMS_QUEUE=CommonConstants.JMS_QUEUE;
 
  	private QueueConnectionFactory qconFactory;
	private QueueConnection qcon;
	private QueueSession qsession;
	private QueueSender qsender;
	private Queue queue;
	private TextMessage message;
	private UserInfoBean userInfo;
 
	public JMSSender( UserInfoBean userInfo ) 
	{
		try 
		{
			this.userInfo = userInfo;
			init();
			JMSLogger.log("3",userInfo,null,"JMS Ready To Send Messages" );
		}
		catch( Exception e ) 
		{
			JMSLogger.log("3",userInfo,null,"In JMSSender Exception:[ "+ E12GenericUtility.getStackTrace(e) +"]" );
		}
	}

	public void init() throws NamingException, JMSException 
	{
		JMSLogger.log("3",userInfo,null,"JMSSender.init()");
		InitialContext ctx = new InitialContext();
		qconFactory = (QueueConnectionFactory) ctx.lookup( JMS_CONNECTION_FACTORY );
	    qcon = qconFactory.createQueueConnection( JMSSender.JMS_USERNAME, JMSSender.JMS_PASSWORD );
	    qsession = qcon.createQueueSession(false, ActiveMQJMSConstants.INDIVIDUAL_ACKNOWLEDGE);
	    queue = (Queue) ctx.lookup( JMS_QUEUE );
	    qsender = qsession.createSender( queue );
	    message = qsession.createTextMessage();
	    qcon.start();
	}
 
	public void send( String jmsData ) throws JMSException 
	{
		// Added by Rahul P. on 26-Dec-23 to add Log in JMS_LOGS table -- [START]
		String sendStatus = "S";
		E12GenericUtility genericUtility = new E12GenericUtility();
		String msgType =  message.getJMSType();
		JMSLogger.log("3",userInfo,null,"In JMSSender.send() => msgType : ["+msgType+"] => calling jmsLog().." );
		
		try {
			
			genericUtility.jmsLog(jmsData, sendStatus, "", msgType);	// changed by Rahul P. on [16-Jan-24] for WORKFLOW and UPDATE_DIRTY_DATAMODEL msgType
			
		} catch (Exception e) {
			
			JMSLogger.log("3",userInfo,null,"In JMSSender.send() => Exception in catch block :[ "+ E12GenericUtility.getStackTrace(e) +"]" );
			
		}
		// Added by Rahul P. on 26-Dec-23 to add Log in JMS_LOGS table -- [END]
		
		try 
		{
			JMSLogger.log("3",userInfo,null,"JMSSender.send() jmsData:["+ jmsData +"]" );
			message.setText( jmsData );
			qsender.send(message);
			
			close();
		}
		catch (Exception e) 
		{
			// Added by Rahul P. on 26-Dec-23 to add Log in JMS_LOGS table -- [START]
			sendStatus = "E";
			try {
				
				genericUtility.jmsLog(jmsData, sendStatus, "", msgType);	// changed by Rahul P. on [16-Jan-24] for WORKFLOW and UPDATE_DIRTY_DATAMODEL msgType
				
			} catch (Exception e1) {
				
				JMSLogger.log("3",userInfo,null,"In JMSSender.send() => Exception in catch block :[ "+ E12GenericUtility.getStackTrace(e1) +"]" );
				
			}
			// Added by Rahul P. on 26-Dec-23 to add Log in JMS_LOGS table -- [END]
			
			JMSLogger.log("3",userInfo,null,"In JMSSender.send() Exception:[ "+ E12GenericUtility.getStackTrace(e) +"]" );
		}
	}
 
	public void close() throws JMSException 
	{
		JMSLogger.log("3",userInfo,null,"JMSSender.close()");
	    qsender.close();
	    qsession.close();
	    qcon.close();
	}
 
	public TextMessage getMessage() 
	{
		return message;
	}

	public void setMessage(TextMessage message) 
	{
		this.message = message;
	}
	
	public QueueConnection getConnection()
	{
		return qcon;
	}
}