package ibase.webitm.ejb.wsfa.transactions;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

import javax.naming.InitialContext;
//Added by Sainath T. on 09/10/2018-start[to store details in doc_usage_log table]-START
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.DOMException;
//Added by Sainath T. on 09/10/2018-start[to store details in doc_usage_log table]-END
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.itextpdf.text.log.SysoCounter;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.webitm.bean.wsfa.DARCommonBean;
import ibase.webitm.ejb.DocumentHandlerWrapperEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistStkUpd;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

/**
 * Session Bean implementation class RealTimeReportPos
 */
//@Stateless		commented by Sagar M [22 Nov 2018].
public class RealTimeReportPos extends ValidatorEJB implements RealTimeReportPosRemote, RealTimeReportPosLocal
{
	/**
	 * Default constructor.
	 */
	private E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

	public RealTimeReportPos()
	{
		// TODO Auto-generated constructor stub
	}
	protected static String database = CommonConstants.DB_NAME;

	
	public String postSave() throws RemoteException, ITMException
	{
		return "";
	}

	public String postSave(String tranId, String editFlag, String xtraParams, Connection conn, String domString) throws RemoteException, ITMException
	{
		String resString="",dcrIdSql="",dcrDate="";
		String retString = "",dcrID="",salesPersql="",updateStrgMeetSql="",updateStrgMeetItemsSql="",updateStrgMeetteamSql="";
		boolean isError = false;
		boolean isLocalConn = false;
		boolean isSuccess=false;
		Document dom = null;
		PreparedStatement pstmtInsertSprsActTran=null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		String sql = "",strgCode="",custType="",insertSql="",deleteSql="",countSql="";
		String loginCode = "",salesPers="",updateStrgBrandPitchSql="";
		int count = 0,cnt=0;
		String dcrId = "";
		String activityType="";
		String unlistedStrgCode="";
		String cAStrgCode=""; //Added by bhagyashri For Lifescan Coaching issue[18/05/2022]
		int chemCnt=0;
		int drChemCnt=0;
		int pteCnt = 0;
		try
		{
			loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			System.out.println("xmlStringAll::"+domString);
			dom = genericUtility.parseString(domString);
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			String objectName = getObjNameFromDom( dom, "objName" , 1);
			String winName = "w_"+objectName;
			dcrDate = checkNull(genericUtility.getColumnValue("event_date", dom, "1"));
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date newDate = Calendar.getInstance().getTime();
			String currNewDate = dtFormat.format( newDate );

			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//ITMDBAccessLocal itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
			DARCommonBean darCommonBean= new DARCommonBean();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]
			// added by mrunalini sinkar on 10/02/18 for inserting event_time in strg_meet table(start)
			String eventTimeEnd = checkNull(genericUtility.getColumnValue("event_time_end", dom, "1"));
			if((eventTimeEnd == null || eventTimeEnd.length() == 0) && tranId != null)
			{
				String endTime = geteventTime();
				System.out.println("endTime  is:"+endTime);
				if(endTime!=null && tranId!=null)
				{
					if(dcrDate.equals(currNewDate))
					{
						sql="UPDATE STRG_MEET SET EVENT_TIME_END=? WHERE TRAN_ID=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, endTime);
						pstmt.setString(2, tranId);
						int endTimeCnt= pstmt.executeUpdate();
						if(endTimeCnt > 0)
						{
							System.out.println("updates successfully endtime"+endTimeCnt);
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
				}
			}

			String callOutcome = checkNull(genericUtility.getColumnValue("call_outcome", dom, "1"));
			String strgType = checkNull(genericUtility.getColumnValue("strg_type", dom, "1"));
			// added by mrunalini sinkar on 10/02/18 for inserting event_time in strg_meet table(end)
			String actType = checkNull(genericUtility.getColumnValue("activity_type", dom, "1"));
			String eventType = checkNull(genericUtility.getColumnValue("event_type", dom, "1"));
			// added and commentted by rupali on 23/08/18 for applying E-detailing validation for vacant team only in case of manager reporting
			String gradeType = checkNull(genericUtility.getColumnValue("grade_type", dom, "1"));
			String visitedWith = checkNull(genericUtility.getColumnValue("visited_with", dom, "1"));
			String placeRequired = checkNull(genericUtility.getColumnValue( "place_required" , dom ,"1"));//added by mrunalini sinkar on 09-sep-2018 for place required changes (start)
			String custCode = checkNull(genericUtility.getColumnValue( "strg_code" , dom ,"1"));
			String customerType = checkNull(genericUtility.getColumnValue( "cust_type" , dom ,"1"));
			String routeType = checkNull((genericUtility.getColumnValue("route_type", dom, "1")));
			String totalAmount = checkNull(genericUtility.getColumnValue( "amount", dom, "1" )); //added by prachi on 15-sep-2022
			String collectionFormNo = checkNull(genericUtility.getColumnValue( "collection_form_no", dom, "1" )); //added by prachi on 15-sep-2022

			String minimumInvoiceId = checkNull(genericUtility.getColumnValue( "minimum_invoice", dom, "1"  )); //added by prachi on 15-sep-2022
			String invoiceNo = checkNull(genericUtility.getColumnValue( "invoice_no", dom, "1"  )); //added by prachi on 15-sep-2022

			System.out.println("collectionFormNo::: =["+collectionFormNo+"] minimumInvoiceId["+minimumInvoiceId+"]");

			if(!"LISTED".equalsIgnoreCase(customerType) && custCode.contains("UCO"))
			{
				unlistedStrgCode = generateCustomerCode(conn);

				updateStrgCode(tranId,unlistedStrgCode,conn);
			}
			
			//Added by bhagyashri For Lifescan Coaching issue[18/05/2022]start
			if("CA".equalsIgnoreCase(eventType) && ("NA".equalsIgnoreCase(custCode) || custCode.trim().length()<=0 ))
			{
				cAStrgCode = generateCAStrgcode(conn,"CA");

				updateStrgCode(tranId,cAStrgCode,conn);
			}
			//Added by bhagyashri For Lifescan Coaching issue[18/05/2022]End
			
			System.out.println("callOutcome::: =["+callOutcome+"] strgType::: =["+strgType+"] actType::: =["+actType+"] gradeType::: =["+gradeType+"] visitedWith::: =["+visitedWith+"]");
			//Changed by Pooja S on 14/08/2020 [manager related form validation, related to coaching]
			//if(actType.equalsIgnoreCase("FW") && !"0".equalsIgnoreCase(callOutcome) && "D".equalsIgnoreCase(strgType)) // added by mrunalini sinkar on 16-feb-2018
			if(actType.equalsIgnoreCase("FW") && (!"0".equalsIgnoreCase(callOutcome) && !"9".equalsIgnoreCase(callOutcome))  )
			{
				// added by rupali on 09/01/18 for applying validation if brand is not selected [start]
				String parmAct = "",paramActMandatory="";
				String parmVal = "",parmValMandatory = "";
				String [] actTempArr = null;
				String sfaParmSql;
				if( "M".equalsIgnoreCase(gradeType))
				{
					if( "SELF".equalsIgnoreCase(visitedWith) )
					{
						sfaParmSql = "SELECT ACTIVE,PARM_VALUE FROM SFAPARM WHERE PARM_NAME='MGR_FORM_MANDATORY' AND ORG_UNIT = 'SELF' ";
					}
					else
					{
						sfaParmSql = "SELECT ACTIVE,PARM_VALUE FROM SFAPARM WHERE PARM_NAME='MGR_FORM_MANDATORY' AND ORG_UNIT = 'ALL' ";
					}
				}
				else
				{
					sfaParmSql = "SELECT ACTIVE,PARM_VALUE FROM SFAPARM WHERE PARM_NAME='IS_FORM_MANDATORY' ";
				}

				pstmt = conn.prepareStatement(sfaParmSql);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					parmAct = checkNull(rs.getString("ACTIVE"));
					parmVal = checkNull(rs.getString("PARM_VALUE"));
				}//Changed by Pooja S on 14/08/2020 [manager related form validation, related to coaching] START
				else
				{
					sfaParmSql = "SELECT ACTIVE,PARM_VALUE FROM SFAPARM WHERE PARM_NAME='IS_FORM_MANDATORY' ";
					pstmt1 = conn.prepareStatement(sfaParmSql);
					rs1 = pstmt1.executeQuery();
					if (rs1.next())
					{
						parmAct = checkNull(rs1.getString("ACTIVE"));
						parmVal = checkNull(rs1.getString("PARM_VALUE"));
					}
					if(rs1 != null)
					{
						rs1.close();
						rs1 = null;
					}
					if(pstmt1 != null)
					{
						pstmt1.close();
						pstmt1 = null;
					}
				}
				//Changed by Pooja S on 14/08/2020 [manager related form validation, related to coaching] END
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				String sfaParmSqlQuery = "SELECT ACTIVE,PARM_VALUE FROM SFAPARM WHERE PARM_NAME='ACTWISE_FORM_NOT_MANDATORY' AND ORG_UNIT = ? ";
				pstmt = conn.prepareStatement(sfaParmSqlQuery);
				pstmt.setString(1, eventType);
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					paramActMandatory = checkNull(rs.getString("ACTIVE"));
					parmValMandatory = checkNull(rs.getString("PARM_VALUE"));
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( !"".equalsIgnoreCase(parmValMandatory) && parmValMandatory.length() > 0)
				{
					actTempArr = parmValMandatory.split(",");
				}
				if("Y".equalsIgnoreCase(parmAct))
				{
					String subFormName = "";
					String [] temp = parmVal.split(",");
					List<String> list = new ArrayList<String>();
					if( actTempArr != null && actTempArr.length > 0)
					{
						list = new ArrayList<String>(Arrays.asList(actTempArr));
					}
					for(int i = 0 ;i < temp.length;i++)
					{
						if(!list.contains(temp[i]) )
						{
							if(subFormName == null || subFormName.trim().length() == 0)
							{
								subFormName = temp[i];
							}
							else
							{
								subFormName = subFormName + "','" + temp[i];
							}
						}
					}
					subFormName = "'" + subFormName + "'";
					String isFortuneActivity = checkNull(getSfaParmValue(loginCode, "IS_FORTUNE_ACTIVITY", conn));
					String objFormSql= "SELECT FORM_NAME, FORM_NO, TITLE FROM OBJ_FORMS WHERE WIN_NAME= ? AND FORM_NAME IN("+subFormName+") ";
					pstmt = conn.prepareStatement(objFormSql);
					pstmt.setString(1, winName);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						String formName = checkNull(rs.getString("FORM_NAME"));
						String formNo = checkNull(rs.getString("FORM_NO"));
						String formTitle = checkNull(rs.getString("TITLE"));
						try
						{
							NodeList parentNodeList = dom.getElementsByTagName("Detail"+formNo);
							int nodeListLen = parentNodeList.getLength();
							System.out.println("nodeListLen:::::: =["+nodeListLen+"]");
							//if(nodeListLen == 0 && !"0".equalsIgnoreCase(callOutcome))
							if(nodeListLen == 0)
							{
								if("Y".equalsIgnoreCase(isFortuneActivity))
								{
									System.out.println("formName  for validation for fortune:::::: =["+isFortuneActivity+"]");
									if(formName.trim().equalsIgnoreCase("brand") )
									{
										System.out.println("formName  for validation is for fortune brand:::::: =["+formName+"]");
										resString = itmDBAccessLocal.getErrorString( "brand_code", "FORMNOTSEL", loginCode );
										resString = getModifiedErrorString(resString, formTitle);
										System.out.println("resString:::::: =["+resString+"]");
										return resString;
									}
									if(formName.trim().equalsIgnoreCase("team"))
									{
										System.out.println("formName  for validation is for fortune team :::::: =["+formName+"]");
										resString = itmDBAccessLocal.getErrorString( "strg_code", "FORMNOTSEL", loginCode );
										resString = getModifiedErrorString(resString, formTitle);
										System.out.println("resString:::::: =["+resString+"]");
										return resString;
									}
								}
								else if(formName.trim().equalsIgnoreCase("brand") && "D".equalsIgnoreCase(strgType))
								{
									System.out.println("formName  for validation is :::::: =["+formName+"]");
									resString = itmDBAccessLocal.getErrorString( "brand_code", "FORMNOTSEL", loginCode );
									resString = getModifiedErrorString(resString, formTitle);
									System.out.println("resString:::::: =["+resString+"]");
									return resString;
								}
								else if(formName.trim().equalsIgnoreCase("invoice"))
								{
									System.out.println("formName  for validation is :::::: =["+formName+"]");
									resString = itmDBAccessLocal.getErrorString( "item_code", "MANFORMSEL", "" );
									resString = getModifiedErrorString(resString, formTitle);
									System.out.println("resString n:::::: =["+resString+"]");
									return resString;
								}
								else if(formName.trim().equalsIgnoreCase("collection"))
								{
									System.out.println("formName  for validation is :::::: =["+formName+"]");
									resString = itmDBAccessLocal.getErrorString( "pay_mode", "MANFORMSEL", "" );
									resString = getModifiedErrorString(resString, formTitle);
									System.out.println("resString n:::::: =["+resString+"]");
									return resString;
								}
							}
							//added by mrunalini sinkar for validation if detail length is greater tahn 0 but data is not selected on 27-07-2018(start)
							else
							{
								Node childNode = null;
								Node parentNode=null;
								NodeList childList =null;
								boolean flg=true;
								for (int prntCtr = 0; prntCtr < nodeListLen; prntCtr++ )
								{
									String updateFlag = "";

									parentNode = parentNodeList.item(prntCtr);
									childList = parentNode.getChildNodes();
									int noOfChilds = childList.getLength();
									for(int ctr = 0; ctr < noOfChilds; ctr++)
									{
										childNode = childList.item(ctr);
										if( childNode.getNodeType() != Node.ELEMENT_NODE )
										{
											continue;
										}
										String childNodeName = childNode.getNodeName();
										if(childNodeName.equalsIgnoreCase("attribute"))
										{
											if(childNode.getAttributes().getNamedItem("updateFlag") != null)
											{
												updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
											}
										}
										if(!updateFlag.equalsIgnoreCase("D"))
										{
											childNode = childList.item(ctr);
											if(childNode.getFirstChild() != null)
											{
												flg=false;
												break;
											}

										}
									}


								}
								if(flg==true)
								{
									System.out.println("formName  for validation in flg :::::: =["+flg+"]");
									if(formName.trim().equalsIgnoreCase("brand") && "D".equalsIgnoreCase(strgType))
									{
										resString = itmDBAccessLocal.getErrorString( "brand_code", "FORMNOTSEL", loginCode );
										resString = getModifiedErrorString(resString, formTitle);
										return resString;
									}
									else if(formName.trim().equalsIgnoreCase("invoice"))
									{
										System.out.println("formName  for validation is :::::: =["+formName+"]");
										resString = itmDBAccessLocal.getErrorString( "item_code", "MANFORMSEL", "" );
										resString = getModifiedErrorString(resString, formTitle);
										System.out.println("resString n:::::: =["+resString+"]");
										return resString;
									}
									else if(formName.trim().equalsIgnoreCase("collection"))
									{
										System.out.println("formName  for validation is :::::: =["+formName+"]");
										resString = itmDBAccessLocal.getErrorString( "pay_mode", "MANFORMSEL", "" );
										resString = getModifiedErrorString(resString, formTitle);
										System.out.println("resString n:::::: =["+resString+"]");
										return resString;
									}
								}


							}
							//added by mrunalini sinkar for validation if detail length is greater tahn 0 but data is not selected on 27-07-2018(end)
						}
						catch(Exception e)
						{
							System.out.println("Exception  :==>\n" + e.getMessage());
							throw new ITMException(e);
						}
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
				// added by rupali on 09/01/18 for applying validation if brand is not selected [end]
			}
			
			//added by prachi for collection subform Validation [W22FBAS009]
			if ( "FW".equalsIgnoreCase( actType.trim() ) )
			{
				resString = darCommonBean.collectionValidateAmount(dom, conn, winName, totalAmount,"collection");
				if(resString!=null && resString.trim().length()>0)
				{
					return resString;
				}
			}
			
			// added by rupali on 09/05/18 for single screen manager reporting [start]
			salesPers = checkNull(genericUtility.getColumnValue( "sales_pers", dom, "1" ));
			RealTimeReportEJB realTimeReport = new RealTimeReportEJB();
			String mgrCode = realTimeReport.getMGREmployee(salesPers, conn);
			// added by rupali on 09/05/18 for single screen manager reporting [end]
			//added by mrunalini sinkar for member present (start)
			String isMemberPresnt  = checkNull(getSfaParmValue(salesPers,"HIDE_UNLIST_DET",conn));

			if(!isMemberPresnt.equalsIgnoreCase("Y") && !"M".equalsIgnoreCase(routeType))
			{
				sql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_ADD WHERE TRAN_ID = ?";
				pstmt = conn.prepareStatement( sql );
				pstmt.setString( 1, tranId);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					count = rs.getInt("COUNT");
				}
				if (rs.next())
				{
					count = rs.getInt("COUNT");
				}

				if ( rs != null )
				{
					rs.close();
					rs = null;
				}

				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}


				if( count == 0 )
				{
					String stockistTable = getSfaParmValue(salesPers,"GET_STOCKIST_DETAILS",conn);
					if ( strgType.equalsIgnoreCase("S") && stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
					{
						//Change by sadique shaikh 04-03-2020 [unlisted customer event info realted changes] //age,QUALIFICATION added by prachi
						insertSql = " INSERT INTO STRG_CUST_ADD(DCR_ID, TRAN_ID, SALES_PERS, EVENT_DATE, EVENT_TYPE, " +
								" STRG_CODE, ADDRESS_AS, STRG_NAME, STRG_TYPE, GENDER, REMARKS, LOCALITY_CODE," +
								" CONFIRMED, CONF_DATE, WF_STATUS, CHG_DATE, CHG_USER, CHG_TERM, ADDR1, ADDR2, ADDR3,AGE,QUALIFICATION," +
								" MOBILE_NO, EMAIL_ADDR, STRG_CLASS_CODE,SPL_CODE," +
								"PROMOTER_NAME,MAN_POWER,IMAGE_ID,GST_NO,SUBCLASS_CODE,PIN,ROUTE_ID,strg_event_info, reg_no )" +
								" (SELECT DCR_ID, TRAN_ID, SALES_PERS, EVENT_DATE, EVENT_TYPE, " +
								" STRG_CODE, ADDRESS_AS, STRG_NAME, STRG_TYPE, (CASE WHEN GENDER is null then 'M' ELSE GENDER END ) AS GENDER, REMARKS, LOCALITY_CODE," +
								" CONFIRMED, CONF_DATE, WF_STATUS, CHG_DATE, CHG_USER, CHG_TERM, ADDR1, ADDR2, ADDR3,AGE,QUALIFICATION," +
								" MOBILE_NO, EMAIL_ADDR, STRG_CLASS_CODE,SPL_CODE," +
								"PROMOTER_NAME,MAN_POWER,IMAGE_ID,GST_NO,SUBCLASS_CODE,PIN,ROUTE_ID,strg_event_info, reg_no " +
								" FROM STRG_MEET " +
								" WHERE TRAN_ID = ? AND STRG_CODE NOT IN(SELECT CUST.CUST_CODE FROM CUSTOMER CUST))";
					}
					else
					{
						//Change by sadique shaikh 04-03-2020 [unlisted customer event info realted changes]
						insertSql = " INSERT INTO STRG_CUST_ADD(DCR_ID, TRAN_ID, SALES_PERS, EVENT_DATE, EVENT_TYPE, " +
								" STRG_CODE, ADDRESS_AS, STRG_NAME, STRG_TYPE, GENDER, REMARKS, LOCALITY_CODE," +
								" CONFIRMED, CONF_DATE, WF_STATUS, CHG_DATE, CHG_USER, CHG_TERM, ADDR1, ADDR2, ADDR3,AGE,QUALIFICATION," +
								" MOBILE_NO, EMAIL_ADDR, STRG_CLASS_CODE,SPL_CODE," +
								"PROMOTER_NAME,MAN_POWER,IMAGE_ID,GST_NO,SUBCLASS_CODE,PIN,ROUTE_ID,strg_event_info, reg_no)" + // added by rupali on 18/01/19 for adding fields in realtime report
								" (SELECT DCR_ID, TRAN_ID, SALES_PERS, EVENT_DATE, EVENT_TYPE, " +
								" STRG_CODE, ADDRESS_AS, STRG_NAME, STRG_TYPE, (CASE WHEN GENDER is null then 'M' ELSE GENDER END ) AS GENDER, REMARKS, LOCALITY_CODE," +
								" CONFIRMED, CONF_DATE, WF_STATUS, CHG_DATE, CHG_USER, CHG_TERM, ADDR1, ADDR2, ADDR3,AGE,QUALIFICATION," +
								" MOBILE_NO, EMAIL_ADDR, STRG_CLASS_CODE,SPL_CODE," +
								"PROMOTER_NAME,MAN_POWER,IMAGE_ID,GST_NO,SUBCLASS_CODE,PIN,ROUTE_ID,strg_event_info, reg_no " + // added by rupali on 18/01/19 for adding fields in realtime report
								" FROM STRG_MEET " +
								" WHERE TRAN_ID = ? AND STRG_CODE NOT IN(SELECT SC.SC_CODE FROM STRG_CUSTOMER SC))";
					}

					pstmt = conn.prepareStatement(insertSql);
					pstmt.setString(1, tranId);
					int strgCustCnt = pstmt.executeUpdate();
					if(strgCustCnt > 0)
					{
						System.out.println("Strg Cust Inserted Successfully =["+strgCustCnt+"]");
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
				}

				//dcrDate = checkNull(genericUtility.getColumnValue("event_date", dom, "1"));
				String dcrIdCnt="";
				String dcrSql = "SELECT DCR_ID FROM STRG_CUST_ADD WHERE EVENT_DATE = ? AND SALES_PERS = ?";
				pstmt = conn.prepareStatement( dcrSql );
				pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmt.setString(2, loginCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					dcrIdCnt = rs.getString("DCR_ID");
					System.out.println("dcr_id is:"+dcrIdCnt);
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}

				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}

				countSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_ADD WHERE TRAN_ID = ?";
				pstmt = conn.prepareStatement( countSql );
				pstmt.setString( 1, tranId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					cnt = rs.getInt("COUNT");
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}

				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if(cnt > 0)
				{
					deleteSql = "DELETE FROM STRG_CUST_ADD WHERE DCR_ID = ? AND STRG_CODE NOT IN(SELECT STRG_CODE FROM STRG_MEET WHERE DCR_ID = ?)";
					pstmt = conn.prepareStatement( deleteSql );
					pstmt.setString(1, dcrIdCnt);
					pstmt.setString(2, dcrIdCnt);
					int deleteCount = pstmt.executeUpdate();

					if(deleteCount > 0)
					{
						System.out.println("DELETED SUCCESSFULLY");
					}
					if(pstmt!=null)
		    	    {
			    	    pstmt.close();
				        pstmt = null;
			        }
				}


			}


			String activityCode = checkNull(genericUtility.getColumnValue( "event_type", dom, "1" ));
			System.out.println("ACTIVITY CODE IS:"+activityCode);
			salesPers = checkNull(genericUtility.getColumnValue( "sales_pers", dom, "1" ));
			System.out.println("salesPers  IS:"+salesPers);
			String eventDate = checkNull(genericUtility.getColumnValue( "event_date", dom, "1" ));
			System.out.println("eventDate  IS:"+eventDate);

			String sqlActType = "SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE= ?";
			PreparedStatement pstmtActType = conn.prepareStatement( sqlActType );
			pstmtActType.setString(1, activityCode);
			ResultSet rsActType = pstmtActType.executeQuery();
			if ( rsActType.next() )
			{
				activityType = rsActType.getString("ACTIVITY_TYPE");
			}
			if(rsActType!=null)
			{
				rsActType.close();
				rsActType = null;
			}
			if(pstmtActType!=null)
			{
				pstmtActType.close();
				pstmtActType = null;
			}

			String objName = "strg_meet_dcr_realtime_wiz"; //added by rupali on 15/09/17 for worked with field

			System.out.println("[activityCode = " + activityCode + "]" + "[salesPers = " + salesPers + "]" + "[eventDate = " + eventDate + "]" + "[activityType = " + activityType + "]");
			String pDate = genericUtility.getValidDateTimeString( eventDate , getApplDateFormat() , getDBDateFormat());//Added By Shahu Mali  on 09/02/13
			//added by mrunalini sinkar on 09-sep-2018 for place required changes (start)
			//if (activityType != null && ("LEAVE".equalsIgnoreCase(activityType.trim()) || "NFW".equalsIgnoreCase(activityType.trim()) ))//commented by mrunalini sinkar to remove nfw case
			if (activityType != null && !"Y".equalsIgnoreCase(placeRequired) && !"FW".equalsIgnoreCase(activityType))
			{
				if(salesPers != null && eventDate != null)
				{
					insertIntoSprsTravel( conn, salesPers.trim(), eventDate.trim(), tranId.trim(),activityCode.trim(),xtraParams.trim() );

				}
			}
			//added by mrunalini sinkar on 09-sep-2018 for place required changes (end)
			
			// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
			//String isFortuneActivity = checkNull(getSfaParmValue(salesPers, "IS_FORTUNE_ACTIVITY", conn));
			
				//if(isFortuneActivity.trim().equalsIgnoreCase("Y"))
				//{
					int count1=0;
					String actCode="";
					String visitTimeFr="";
					String visitTimeTo="";
					String activitySql = "SELECT ACTIVITY_CODE, VISIT_TIME_FR, VISIT_TIME_TO,REMARK  FROM  SPRS_ACTIVITY WHERE SALES_PERS = ? AND EVENT_DATE = ? AND ACTIVITY_CODE =? ";
					pstmt = conn.prepareStatement( activitySql );
					pstmt.setString( 1, salesPers);
					pstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					pstmt.setString( 3, activityCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						actCode = rs.getString("ACTIVITY_CODE");
						visitTimeFr = rs.getString("VISIT_TIME_FR");
						visitTimeTo = rs.getString("VISIT_TIME_TO");
						count1++;
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("[actCode =   " + actCode + "]");
					System.out.println("[activityCode =   " + activityCode + "]");
					if(count1 > 0)
					{
						System.out.println("[activityCode = updateSprsActivity " + activityCode + "]");
						updateSprsActivity( conn, salesPers.trim(), eventDate.trim(),activityCode.trim(), tranId.trim(), dom, visitTimeFr, visitTimeTo );
						//insertIntosprsActivityDetails( conn, salesPers.trim(), eventDate.trim(), tranId.trim(),activityCode.trim(),xtraParams.trim(), dom );

					}
					else
					{
						System.out.println("[activityCode = insertIntosprsActivityDetails " + activityCode + "]");
						insertIntosprsActivityDetails( conn, salesPers.trim(), eventDate.trim(), tranId.trim(),activityCode.trim(),xtraParams.trim(), dom );
					}
				//}
				// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]

			//added by rupali on 15/09/17 for worked with field [start]
			System.out.println("mgrCode is:::::::["+mgrCode+"]");
			if("strg_meet_dcr_realtime_wiz".equalsIgnoreCase(objName) && mgrCode.trim().length() == 0) // added condition by rupali on 09/05/18 for single screen manager reporting
			{
				createSalesPersonTeam(domString, tranId, editFlag, xtraParams, conn);
			}
			//added by rupali on 15/09/17 for worked with field [end]
			// added by rupali on 25/06/18 for geeting travel_mode for expense process related changes [start]
			String travelMode = checkNull(genericUtility.getColumnValue( "travel_mode", dom, "1" ));
			if(travelMode != null && travelMode.trim().length() != 0)
			{
				String updateTravelsql ="UPDATE SPRS_TRAVEL SET TRAVEL_MODE = ? WHERE  TRAN_ID = ? AND SALES_PERS = ? ";
				pstmt = conn.prepareStatement(updateTravelsql);
				pstmt.setString(1, travelMode);
				pstmt.setString(2, tranId);
				pstmt.setString(3, salesPers.trim());
				int updateTravelsqlCnt= pstmt.executeUpdate();
				if(updateTravelsqlCnt > 0)
				{
					System.out.println("updates successfully updateSprsTravelsql"+updateTravelsqlCnt);
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			// added by rupali on 25/06/18 for geeting travel_mode for expense process related changes [end]
			//addded by mrunalini sinkar on 18-sep-2018 to update change date (start)
			/*String chgDate = checkNull(genericUtility.getColumnValue( "chg_date", dom, "1" ));
			String isAuto = checkNull(genericUtility.getColumnValue( "is_auto", dom, "1" ));
			if("Y".equalsIgnoreCase(isAuto) && chgDate!=null)
			{
				Calendar c = Calendar.getInstance();
				DateFormat applFormat = new SimpleDateFormat(getApplDateFormat());
				String[] dateArray =chgDate.split("/");
				int year=Integer.parseInt(dateArray[2].trim());
				int month=Integer.parseInt(dateArray[1].trim());
				int date=Integer.parseInt(dateArray[0].trim());
				c.set(year, month - 1, date, 0, 0);
				java.util.Date currentDate = c.getTime();
				String currDate = applFormat.format( currentDate );
				String currDbDate=genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
				System.out.println("currDbDate is:["+currDbDate+"]");

				if(currDbDate != null && currDbDate.trim().length() != 0)
				{
					System.out.println("Inside update strgmeet");
					String updatechgDatesql ="UPDATE STRG_MEET SET CHG_DATE = ? WHERE  TRAN_ID = ? AND SALES_PERS = ? ";
					pstmt = conn.prepareStatement(updatechgDatesql);
					pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(currDbDate));
					pstmt.setString(2, tranId);
					pstmt.setString(3, salesPers.trim());
					int updateChgDateCnt= pstmt.executeUpdate();
					if(updateChgDateCnt > 0)
					{
						System.out.println("updates successfully updateSprsTravelsql"+updateChgDateCnt);
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}*/

			//addded by mrunalini sinkar on 18-sep-2018 to update change date (end)

			// added by rupali on 12/09/18 for adding survey subform in DAR [start]
			if ( "FW".equalsIgnoreCase( activityType.trim() ) )
			{
				if(salesPers != null && eventDate != null)
				{
					String dcrid = getDCRId(conn, salesPers, dcrDate);
					String scCode = checkNull(genericUtility.getColumnValue( "strg_code" , dom ,"1"));
					String prefferdStockCode = checkNull(genericUtility.getColumnValue( "stockist_code" , dom ,"1"));

					updateStrgSurveyRes( dom, dcrid.trim(),unlistedStrgCode, conn,salesPers.trim());
					//Added by Amey W. [to set coaching form values] on 11-12-2019
					updateCoachingDetail( dom, dcrid.trim(), unlistedStrgCode, conn );
	            	updateStrgMeetEntry(dcrid,tranId,conn);
					updatPOBValue(tranId,scCode,conn);
					//System.out.println("scCode is before insert into entity_contact:::::::["+scCode+"]");
					insertentitycontact(tranId,scCode,conn);
					//System.out.println("scCode is after insert into entity_contact:::::::["+tranId+"]");
					if(prefferdStockCode!=null && prefferdStockCode.trim().length()>0)
					{
						updatPrefferdStockistValue(tranId,scCode,prefferdStockCode,conn);
					}
					String planDevParm=getSfaParmValue(salesPers, "VAL_ROUTE_DEVIATE", conn);
					boolean beatDeviationCheck=false;
					System.out.println("mgrCode is:::["+mgrCode+"]");

					if(mgrCode.trim().length()!= 0)
					{
						String sprsCodeWW=checkNull(genericUtility.getColumnValue( "sprs_code__ww", dom, "1" ));
						System.out.println("sprsCodeWW is:::["+sprsCodeWW+"]");
						if(sprsCodeWW.equalsIgnoreCase(salesPers))
						{
							beatDeviationCheck=true;
						}
					}
					else
					{
						beatDeviationCheck=true;
					}
	            	String routeId = checkNull(genericUtility.getColumnValue( "route_id", dom, "1" ));
	            	String remark = checkNull(genericUtility.getColumnValue( "plan_chg_reas", dom, "1" ));
	            	String weekDays = checkNull(genericUtility.getColumnValue( "event_week_day", dom, "1" ));
	            	System.out.println("routeId["+routeId+"]remark["+remark+"]weekDays["+weekDays+"]beatDeviationCheck["+beatDeviationCheck+"]");
					if(beatDeviationCheck && "Y".equalsIgnoreCase(planDevParm))
					{
						int routeCnt=0;
						int travelCnt=0;
						int planDayCnt=0;
						String routeSql="SELECT COUNT(*) AS PLAN_DAYS_CNT FROM SPRS_ROUTE WHERE TRIM(SPRS_CODE)=? AND STATUS='Y' AND PLAN_DAYS like'%"+checkNull(weekDays)+"%'";
						pstmt = conn.prepareStatement(routeSql);
						pstmt.setString(1, salesPers);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							planDayCnt = rs.getInt("PLAN_DAYS_CNT");
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						System.out.println("planDayCnt["+planDayCnt+"]");

						if(planDayCnt>0 && weekDays!=null && weekDays.trim().length()>0)
						{
							String sql1="SELECT COUNT(*) AS ROUTE_CNT FROM SPRS_ROUTE WHERE TRIM(SPRS_CODE)=? AND STATUS='Y' AND PLAN_DAYS like'%"+checkNull(weekDays)+"%' AND TRIM(ROUTE_ID)=?";
							pstmt = conn.prepareStatement(sql1);
							pstmt.setString(1, salesPers);
							pstmt.setString(2, routeId);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								routeCnt = rs.getInt("ROUTE_CNT");
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							System.out.println("routeCnt["+routeCnt+"]remark["+remark+"]weekDays["+weekDays+"]");

							if(routeCnt==0)
							{
								String sql2="SELECT COUNT(*) AS TRAVEL_CNT FROM STRG_MEET WHERE TRIM(SALES_PERS)=? AND EVENT_DATE=? AND TRIM(ROUTE_ID)=? AND TRAN_ID<>?";
								pstmt = conn.prepareStatement(sql2);
								pstmt.setString(1, salesPers);
								pstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
								pstmt.setString(3, routeId);
								pstmt.setString(4, tranId);

								rs = pstmt.executeQuery();
								if(rs.next())
								{
									travelCnt = rs.getInt("TRAVEL_CNT");
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								System.out.println("routeCnt["+routeCnt+"]travelCnt["+travelCnt+"]weekDays["+weekDays+"]");

								if(travelCnt==0)
								{
									System.out.println("routeCnt["+routeCnt+"]travelCnt["+travelCnt+"]remark["+remark+"]");

									if(remark == null || remark.trim().length()==0 )
									{
										System.out.println("Inside remark is nul:::");

										resString = itmDBAccessLocal.getErrorString( "remarks", "ISDTPLNNED", loginCode );
										return resString;
									}
									else if("1".equalsIgnoreCase(remark) )
									{
										System.out.println("Inside remark is nul:::");
										resString = itmDBAccessLocal.getErrorString( "remarks", "ISDTPLNNED", loginCode );
										return resString;
									}
									else
									{
										System.out.println("Inside remark is not  nul:::");
										String refSer = getRefser(objName,conn);
										String reportTo=getEmpReportTo(salesPers,conn);
										String formatCode = "PLAN_DEVIATION";
										String rejectMailSent=sendMailStatus(salesPers, domString,formatCode,objName,refSer,reportTo,conn);
									}
								}
							}
						}
					}

	            	String ordSql="SELECT FORM_NO, TITLE FROM OBJ_FORMS WHERE WIN_NAME=? AND FORM_NAME IN('sampleorder')" ;
	            	pstmt = conn.prepareStatement(ordSql);
					pstmt.setString(1, winName);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						String formNo = checkNull(rs.getString("FORM_NO"));
						try
						{
							NodeList parentNodeList = dom.getElementsByTagName("Detail"+formNo);
							int nodeListLen = parentNodeList.getLength();
							System.out.println("nodeListLen:::::: =["+nodeListLen+"]orderFormNo:::["+formNo+"]");
							if(nodeListLen == 0)
							{

							}
							else
							{
								Node childNode = null;
								Node parentNode=null;
								NodeList childList =null;
								boolean ordFlag=true;
								for (int prntCtr = 0; prntCtr < nodeListLen; prntCtr++ )
								{
									String updateFlag = "";

									parentNode = parentNodeList.item(prntCtr);
									childList = parentNode.getChildNodes();
									int noOfChilds = childList.getLength();
									for(int ctr = 0; ctr < noOfChilds; ctr++)
									{
										childNode = childList.item(ctr);
										if( childNode.getNodeType() != Node.ELEMENT_NODE )
										{
											continue;
										}
										String childNodeName = childNode.getNodeName();
										if(childNodeName.equalsIgnoreCase("attribute"))
										{
											if(childNode.getAttributes().getNamedItem("updateFlag") != null)
											{
												updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
											}
										}
										if(!updateFlag.equalsIgnoreCase("D"))
										{
											childNode = childList.item(ctr);
											if(childNode.getFirstChild() != null)
											{
												ordFlag=false;
												break;
											}

										}
									}


								}
								System.out.println("ordFlag:::::: =["+ordFlag+"]orderFormNo:::["+formNo+"]");

								if(ordFlag==false)
								{
									String stockistCode = checkNull(genericUtility.getColumnValue( "stockist_code", dom, "1" ));
									System.out.println("ordFlag:::::: =["+ordFlag+"]stockistCode:::["+stockistCode+"]");
									String isPrefStockReq = checkNull(getSfaParmValue(loginCode, "IS_PREF_STOCK_REQ", conn));//added by Bhagyashri T for fortune validation[16-12-21]
									System.out.println("before validation isPrefStockReq::"+isPrefStockReq);
									if(isPrefStockReq.equalsIgnoreCase("Y"))
									{
										if(stockistCode==null || stockistCode.trim().length()==0)
										{
											System.out.println("inside validation");
											resString = itmDBAccessLocal.getErrorString( "stockist_code", "STOCKMANDT", loginCode );
											return resString;
										}
									}
								}
							}
							//added by mrunalini sinkar for validation if detail length is greater tahn 0 but data is not selected on 27-07-2018(end)
						}
						catch(Exception e)
						{
							System.out.println("Exception  :==>\n" + e.getMessage());
							throw new ITMException(e);
						}
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
	            		
					//Added by saiprasad G.on 27-12-19 For the coaching post save logic in user_tasks table[START]
					//Commented by sadique shaikh 02-01-2019
					//createUserTasks( dom, xtraParams, conn );
					//Added by saiprasad G.on 27-12-19 For the coaching post save logic in user_tasks table[END]
				}
			}
			// added by rupali on 12/09/18 for adding survey subform in DAR [end]

			//Added by Sainath T. on 09/10/2018 [to store details in doc_usage_log table]-START
			saveDocContentUsage( dom );
			//Added by Sainath T. on 09/10/2018 [to store details in doc_usage_log table]-END
			// Added by mrunalini sinkar on  26-02-2019 to insert display & survey into day end reporting (start)
			int dispCount=0;
			String dispSql="SELECT COUNT(*) AS COUNT FROM STRG_ITEM_DISPLAY WHERE TRAN_ID= ? ";
			pstmt=conn.prepareStatement(dispSql) ;
			pstmt.setString(1, tranId);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				dispCount = rs.getInt("COUNT");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(dispCount > 0)
			{
				String dispDataSql="SELECT DOC_ID FROM STRG_ITEM_DISPLAY WHERE TRAN_ID = ?";
				pstmt=conn.prepareStatement(dispDataSql) ;
				pstmt.setString(1, tranId);
				rs=pstmt.executeQuery();
				while(rs.next())
				{
					insertIntoDocTransactionLink(checkNull(rs.getString("DOC_ID")),"R-DCR",conn);
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}

			int surveyCount=0;
			String surveySql="SELECT COUNT(*) AS COUNT FROM STRG_SURV_RES WHERE TRAN_ID= ? ";
			pstmt=conn.prepareStatement(surveySql) ;
			pstmt.setString(1, tranId);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				surveyCount = rs.getInt("COUNT");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(surveyCount > 0)
			{
				String survDataSql="SELECT DOC_ID_2 FROM STRG_SURV_RES WHERE TRAN_ID = ?";
				pstmt=conn.prepareStatement(survDataSql) ;
				pstmt.setString(1, tranId);
				rs=pstmt.executeQuery();
				while(rs.next())
				{
					insertIntoDocTransactionLink(checkNull(rs.getString("DOC_ID_2")),"R-DCR",conn);
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			// Added by mrunalini sinkar on  26-02-2019 to insert display & survey into day end reporting (end)

			//Added by Mrunalini SInkar to update old table data(start)
			if(!isMemberPresnt.equalsIgnoreCase("Y"))
			{


				String dcrIds = checkNull(getDCRId(conn, salesPers, dcrDate));
				String chemSql = "SELECT COUNT(*) AS COUNT FROM STRG_MEET SM,STRG_CUSTOMER SC WHERE DCR_ID = ? AND STRG_TYPE ='C'  AND  SM.STRG_CODE=SC.SC_CODE AND SM.STRG_TYPE=SC.CUST_TYPE";
				pstmt = conn.prepareStatement( chemSql );
				pstmt.setString( 1, dcrIds);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					chemCnt = rs.getInt("COUNT");
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("chemCnt is["+chemCnt+"]");

				if(chemCnt>0)
				{
					String drChemSql="SELECT COUNT(*) AS COUNT FROM DR_CHEMIST_VISIT WHERE SALES_PERS=? AND WORK_DATE=?";
					pstmt = conn.prepareStatement( drChemSql );
					pstmt.setString(1, salesPers);
					pstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						drChemCnt = rs.getInt("COUNT");
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("drChemCnt is["+drChemCnt+"]");
					if(drChemCnt>0)
					{

						updateOldTableData(dcrIds,dcrDate, salesPers,chemCnt, conn);
					}
				}
			}
			//Added by Mrunalini SInkar to update old table data(end)
			/*--Commented by Gulzar on 14-MAR-2024 as if min invoice id is blank then invoice id gets updated as blank. This is not required
			if(collectionFormNo!=null && collectionFormNo.trim().length()>0)
			{
				updateInvoiceId(dom,minimumInvoiceId,tranId,collectionFormNo,invoiceNo,conn);

			}
			*/
			
			//Added  by Jay Kesur to insert data in Place_time_ent(Start)
			String strgCodePte = checkNull(genericUtility.getColumnValue( "strg_code", dom, "1" ));

			String salesPersPte = checkNull(genericUtility.getColumnValue( "sales_pers", dom, "1" ));

			String checkSql = "SELECT COUNT(*) AS COUNT FROM PLACE_TIME_ENT WHERE ENTITY_CODE=? AND USER_ID=?";
			
			pstmt = conn.prepareStatement(checkSql);
			pstmt.setString(1, strgCodePte);
			pstmt.setString(2, salesPersPte);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				pteCnt = rs.getInt("COUNT");
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			if (pteCnt == 0)
			{
				getNextSequence(domString, conn);
				
			}
			
			//Added  by Jay Kesur to insert data in Place_time_ent(End)
			
			String dcrIdCnt="";
			String dcrSql = "SELECT DCR_ID FROM STRG_MEET WHERE EVENT_DATE = ? AND SALES_PERS = ?";
			pstmt = conn.prepareStatement( dcrSql );
			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmt.setString(2, salesPers);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				dcrIdCnt = rs.getString("DCR_ID");
				System.out.println("dcr_id is:"+dcrIdCnt);
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}

			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			String invoiceFormNo = getFormNo("strg_meet_dcr_realtime_wiz", "invoice", conn);
			System.out.println("InvoiceFormNo is::"+invoiceFormNo);
			// Changes by Hariom S for All sfa client if invoice form not present then lbc invoice form data should not allocate on stock tables. -- 05-Oct-2023 [Start]
			if(invoiceFormNo != null && invoiceFormNo.length() != 0)
			{
				String invoiceTranId = checkNull(genericUtility.getColumnValue("tran_id", dom, invoiceFormNo));
				//Added condition if invoiceId null then get from Doctor Form[01-DEC-23]
				if(invoiceTranId == null || invoiceTranId.trim().length() == 0)
				{
					invoiceTranId = checkNull(genericUtility.getColumnValue("tran_id", dom, "1"));
				}
				//Added condition if invoiceId null then get from Doctor Form[01-DEC-23]
				System.out.println("invoiceTranId[ "+invoiceTranId+"]");
				resString=executepostSaveRec(dom,invoiceTranId,dcrDate, salesPers,xtraParams, conn);
				//System.out.println("resString =====possave==="+resString);
			}
			// Changes by Hariom S for All sfa client if invoice form not present then lbc invoice form data should not allocate on stock tables. -- 05-Oct-2023 [End]
			
		}
		catch (Exception e)
		{
			System.out.println("Exception  :==>\n" + e.getMessage());
			throw new ITMException(e);
		} finally
		{
			try
			{
				System.out.println("isError [" + isError + "]");
				System.out.println("isLocalConn [" + isLocalConn + "]");
				if (conn != null)
				{
					/*if (isError)
					{
						conn.rollback();
					}*/
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs1 != null)
					{
						rs1.close();
						rs1 = null;
					}
					if(pstmt1 != null)
					{
						pstmt1.close();
						pstmt1 = null;
					}
					if(pstmtInsertSprsActTran != null )
					{
						pstmtInsertSprsActTran.close();
						pstmtInsertSprsActTran = null;
					}

					if (isLocalConn)
					{
						/*if (!isError)
						{
							conn.commit();
						}*/
						conn.close();
						conn = null;
					}

				}
			}
			catch (Exception e)
			{
				System.out.println("Exception :==>\n" + e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("Return string :" + retString);
		return resString;
	}
	
	//Added by Jay kesur to get pte_id sequence and insert data into place_time_ent table (Start)
	private String getNextSequence(String domString,Connection conn ) throws Exception
	{

		Document dom = null;
		ResultSet rs = null;
		PreparedStatement pstmtInsertPte=null;
		PreparedStatement seqQuery = null;
		dom = genericUtility.parseString(domString);
		InetAddress ownIP=InetAddress.getLocalHost();
		String squence = "";
		int pteId = 0;
		
		try
		{
			// 1. Create Query
			String seq ="SELECT pte_seq.nextVal AS PTEid FROM DUAL";
			seqQuery = conn.prepareStatement(seq);
			rs = seqQuery.executeQuery();
			if (rs.next())
			{
				pteId = rs.getInt("PTEid");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(seqQuery != null)
			{
				seqQuery.close();
				seqQuery = null;
			}
			squence = String.format(String.format("%%0%dd", 10), pteId);
			
			String userId = checkNull(genericUtility.getColumnValue( "sales_pers", dom, "1" ));
			String descr = checkNull(genericUtility.getColumnValue( "strg_name", dom, "1" ));
			String geopos = checkNull(genericUtility.getColumnValue( "chg_geopos", dom, "1" ));
						
			String fromTime = "";
			String toTime = "";
			
			String entityType = checkNull(genericUtility.getColumnValue( "strg_class_code", dom, "1" ));

			String entityCode = checkNull(genericUtility.getColumnValue( "strg_code", dom, "1" ));

			String addDate = checkNull(genericUtility.getColumnValue( "event_date", dom, "1" ));
			
			String addUser = checkNull(genericUtility.getColumnValue( "sales_pers", dom, "1" ));

			String addTerm = ownIP.getHostAddress();

			String chgDate = checkNull(genericUtility.getColumnValue( "chg_date", dom, "1" ));

			String chgUser = checkNull(genericUtility.getColumnValue( "chg_user", dom, "1" ));

			String chgTerm = ownIP.getHostAddress();

			String locType = "C";
			String recStat = "";
			String status = "Y";
			String addr1 = checkNull(genericUtility.getColumnValue( "addr1", dom, "1" ));
			String addr2 = checkNull(genericUtility.getColumnValue( "addr2", dom, "1" ));
			String addr3 = checkNull(genericUtility.getColumnValue( "addr3", dom, "1" ));
			String geoposAddr=addr1+" "+addr2+" "+addr3;
			
			
			String insertSqlPte = "INSERT INTO PLACE_TIME_ENT (PTE_ID, USER_ID , DESCR , GEO_POS , FROM_TIME , TO_TIME , ENTITY_TYPE , ENTITY_CODE , ADD_USER , ADD_DATE , ADD_TERM , CHG_USER , CHG_DATE , CHG_TERM , LOCATION_TYPE ,REC_STAT , STATUS , GEO_POS_ADDR) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			
			pstmtInsertPte = conn.prepareStatement(insertSqlPte);
			pstmtInsertPte.setString(1, squence.trim());
			pstmtInsertPte.setString(2, userId.trim());
			pstmtInsertPte.setString(3, descr.trim());
			pstmtInsertPte.setString(4, geopos.trim());
			pstmtInsertPte.setString(5, fromTime.trim());
			pstmtInsertPte.setString(6, toTime.trim());
			pstmtInsertPte.setString(7, entityType.trim());
			pstmtInsertPte.setString(8, entityCode.trim());
			pstmtInsertPte.setString(9, addUser.trim());
			pstmtInsertPte.setTimestamp(10, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( addDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));			
			pstmtInsertPte.setString(11, addTerm.trim());
			pstmtInsertPte.setString(12, chgUser.trim());
			pstmtInsertPte.setTimestamp(13, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( chgDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));		
			pstmtInsertPte.setString(14, chgTerm.trim());
			pstmtInsertPte.setString(15, locType.trim());
			pstmtInsertPte.setString(16, recStat.trim());
			pstmtInsertPte.setString(17, status.trim());
			pstmtInsertPte.setString(18, geoposAddr.trim());

			int pstmtInsertPteCnt = pstmtInsertPte.executeUpdate();

			if(pstmtInsertPteCnt > 0)
			{
				System.out.println("Inserted successfully into Table table =["+pstmtInsertPteCnt+"]");
			}

			if(pstmtInsertPte != null)
			{
				pstmtInsertPte.close();
				pstmtInsertPte = null;
			}
			
			
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,e.getMessage());
		}
		finally {
			try {
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(seqQuery != null)
				{
					seqQuery.close();
					seqQuery = null;
				}
				if(pstmtInsertPte != null)
				{
					pstmtInsertPte.close();
					pstmtInsertPte = null;
				}
			} catch (Exception e2) {
				// TODO: handle exception
			}              
			
			
		}
					
		return squence;
	}
	//Added by Jay kesur to get pte_id sequence and insert data into place_time_ent table (End)

	private boolean updateRecordsOnEdit( Connection conn, String salesPers, String editFlag, String tranId, Document dom,String xtraParams ) throws ITMException
	{
		boolean isSuccess = false;
		PreparedStatement pstmt3=null;
		PreparedStatement pStmt1=null;
		PreparedStatement pstmtInsertDrSampleDistr=null;
		ResultSet rs1=null;
		String loginCode = "",localitySql="", locality="",visitTimFrm="",visitTimTo;
		String  updateSprsTravelsql="",localityCode="" ,stanCode="",localityDescr="", stanCodeDescrSql="";
		String clientName="",phoneNo="",address="",emailId="",itemQty="",dcrDate="";
		String stanCodeDescr="", routeIdsql="",routeId="", routeDescr="",itemCode="",salesS="",strgCode="",custType="",salesPerns="";
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr = 0;
		int noOfChilds = 0;
		int count=0;
		String columnValueItm = "",columnValueItmQty="";
		String childNodeName = "",columnValue="";
		try
		{
			System.out.println("updateRecordsOnEdit is called...........");
			loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			System.out.println(" loginCode [" + loginCode + "]");
			String empcode=genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			InetAddress ownIP=InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			System.out.println("tran_id>>>::"+tranId);
			//currDate = genericUtility.getValidDateString(currDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat());
			currDate = genericUtility.getValidDateTimeString(currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			dcrDate=genericUtility.getColumnValue("event_date",dom);
			strgCode=genericUtility.getColumnValue("strg_code",dom,"1");
			custType=genericUtility.getColumnValue("cust_type",dom);
			locality=genericUtility.getColumnValue("locality",dom);
			visitTimFrm=genericUtility.getColumnValue("event_time_start",dom);
			visitTimTo=genericUtility.getColumnValue("event_time_end",dom);
			System.out.println("strgCode>>::"+strgCode);
			clientName=genericUtility.getColumnValue("client_name",dom);
			phoneNo=genericUtility.getColumnValue("phone_no",dom);
			address=genericUtility.getColumnValue("address",dom);
			emailId=genericUtility.getColumnValue("email_id",dom);
			itemCode=genericUtility.getColumnValue("item_code",dom);
			itemQty=genericUtility.getColumnValue("quantity",dom);

			String isFortuneActivity = checkNull(getSfaParmValue(salesPers, "IS_FORTUNE_ACTIVITY", conn));// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
			
			System.out.println("IN EDIT FLAG>>+::"+editFlag);
			if ("F".equalsIgnoreCase(custType.trim()) || "L".equalsIgnoreCase(custType.trim()) )
			{
				localitySql ="SELECT LOCALITY_CODE,STAN_CODE,DESCR FROM LOCALITY WHERE LOCALITY_CODE = (SELECT LOCALITY_CODE FROM STRG_CUSTOMER WHERE SC_CODE =  ? ) ";
				pStmt1 = conn.prepareStatement(localitySql);
				pStmt1.setString(1, strgCode);
			}
			else
			{
				localitySql ="SELECT LOCALITY_CODE,STAN_CODE,DESCR FROM LOCALITY WHERE LOCALITY_CODE = ? ";
				pStmt1 = conn.prepareStatement(localitySql);
				pStmt1.setString(1, locality);
			}
			rs1 = pStmt1.executeQuery();
			if(rs1.next())
			{
				localityCode=checkNull(rs1.getString("LOCALITY_CODE").trim());
				stanCode=checkNull(rs1.getString("STAN_CODE").trim());
				localityDescr=checkNull(rs1.getString("DESCR").trim());
			}
			rs1 = ( rs1!=null )? null : rs1;
			pStmt1 = ( pStmt1!=null )? null : pStmt1;

			stanCodeDescrSql ="SELECT DESCR FROM STATION WHERE STAN_CODE = ? ";
			pStmt1 = conn.prepareStatement(stanCodeDescrSql);
			pStmt1.setString(1, stanCode);
			rs1 = pStmt1.executeQuery();
			if(rs1.next())
			{
				stanCodeDescr=checkNull(rs1.getString("DESCR").trim());
			}
			rs1 = ( rs1!=null )? null : rs1;
			pStmt1 = ( pStmt1!=null )? null : pStmt1;


			routeIdsql ="SELECT ROUTE_ID ,DESCR FROM SPRS_ROUTE WHERE SPRS_CODE= ?  AND LOCALITY_CODE= ?  ";
			pStmt1 = conn.prepareStatement(routeIdsql);
			pStmt1.setString(1, salesPers);
			pStmt1.setString(2, localityCode);
			rs1 = pStmt1.executeQuery();
			if(rs1.next())
			{
				routeId=checkNull(rs1.getString("ROUTE_ID").trim());
				routeDescr=checkNull(rs1.getString("DESCR").trim());
			}
			rs1 = ( rs1!=null )? null : rs1;
			pStmt1 = ( pStmt1!=null )? null : pStmt1;

			//UPDATE STRG_MEET_ITEMS UPDATE UPDATE STRG_MEET_ITEMS SET STRG_CODE = ? WHERE TRAN_ID= ?
			//UPDATE STRG_MEET_TEAM SET STRG_CODE = ? WHERE TRAN_ID= ?
			if ("F".equalsIgnoreCase(custType.trim()) || "L".equalsIgnoreCase(custType.trim()) )
			{
				String updateStrgMeetItemsdSql= "UPDATE STRG_MEET_ITEMS SET STRG_CODE = ? WHERE TRAN_ID= ?";
				pstmt3 = conn.prepareStatement(updateStrgMeetItemsdSql);
				pstmt3.setString(1, strgCode.trim());
				pstmt3.setString(2, tranId.trim());
				int updateStrgMeetItemsSqlCnt= pstmt3.executeUpdate();
				if(updateStrgMeetItemsSqlCnt > 0)
				{
					isSuccess=true;
					System.out.println("updates successfully updateStrgMeetItemsdSql"+updateStrgMeetItemsSqlCnt);
				}
				pstmt3 = ( pstmt3!=null )? null : pstmt3;

				String updateStrgMeetTeamdSql= "UPDATE STRG_MEET_TEAM SET STRG_CODE = ? WHERE TRAN_ID= ? ";
				pstmt3 = conn.prepareStatement(updateStrgMeetTeamdSql);
				pstmt3.setString(1, strgCode.trim());
				pstmt3.setString(2, tranId.trim());
				int updateStrgMeetTeamSqlCnt= pstmt3.executeUpdate();
				if(updateStrgMeetTeamSqlCnt > 0)
				{
					isSuccess=true;
					System.out.println("updates successfully updateStrgMeetTeamSqlCnt"+updateStrgMeetTeamSqlCnt);
				}
				pstmt3 = ( pstmt3!=null )? null : pstmt3;
			}

			// Dr_maiN updated
			String salePernsSql="SELECT SALES_PERS FROM STRG_MEET_TEAM WHERE TRAN_ID = ?";
			pStmt1 = conn.prepareStatement(salePernsSql);
			pStmt1.setString(1, tranId);
			rs1 = pStmt1.executeQuery();
			while(rs1.next())
			{
				salesPerns=checkNull(rs1.getString("SALES_PERS").trim());
				System.out.println("salesPerns>>::"+salesPerns);
				salesS=salesS + salesPerns +",";
				System.out.println("salesS>>::"+salesS);
			}
			System.out.println("salesSsalesS>>::"+salesS);
			salesPerns=salesS.substring(0,salesS.lastIndexOf(","));
			System.out.println("salesPernssalesPerns>>::"+salesPerns);
			rs1 = ( rs1!=null )? null : rs1;
			pStmt1 = ( pStmt1!=null )? null : pStmt1;

			String updateDrMainSql= "UPDATE DR_MAIN SET  ROUTE_ID__START = ? ," +
					" ROUTE_DESCR__START = ? , STAN_CODE__START = ? ,WORK_WITH_MGR = ?  WHERE SALES_PERS = ? AND WORK_DATE = ?";
			// LAST_UPDATE = ? , UPDATEd_BY = ?  submission_date = ?
			pstmt3 = conn.prepareStatement(updateDrMainSql);
			pstmt3.setString(1, routeId.trim());
			pstmt3.setString(2, routeDescr.trim());
			pstmt3.setString(3, stanCode.trim());
			pstmt3.setString(4, salesPerns.trim());
			pstmt3.setString(5, salesPers.trim());
			pstmt3.setTimestamp(6, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
			int updateDrMainSqlCnt= pstmt3.executeUpdate();
			if(updateDrMainSqlCnt > 0)
			{
				isSuccess=true;
				System.out.println("updates successfully updateDrMainSqlCnt"+updateDrMainSqlCnt);
			}
			pstmt3 = ( pstmt3!=null )? null : pstmt3;

			//Sprs Travel updated
			updateSprsTravelsql ="UPDATE SPRS_TRAVEL SET LOCALITY_CODE = ? , STAN_CODE = ? , STAN_CODE__FROM = ?   WHERE  TRAN_ID = ? AND SALES_PERS = ? ";
			//, LINE_NO = ?
			pstmt3 = conn.prepareStatement(updateSprsTravelsql);
			pstmt3.setString(1, localityCode.trim());
			pstmt3.setString(2, stanCode.trim());
			pstmt3.setString(3, stanCode.trim());
			pstmt3.setString(4, tranId);
			pstmt3.setString(5, salesPers.trim());

			int updateSprsTravelsqlCnt= pstmt3.executeUpdate();
			if(updateSprsTravelsqlCnt > 0)
			{
				isSuccess=true;
				System.out.println("updates successfully updateSprsTravelsql"+updateSprsTravelsqlCnt);
			}
			pstmt3 = ( pstmt3!=null )? null : pstmt3;

			//Dr Travele details update
			String updateDrTravelDetailSql= "UPDATE DR_TRAVEL_DETAILS  SET WORK_STAN_CODE = ? , FROM_STAN_CODE = ? ," +
					" WORK_ROUTE_ID = ? , FROM_ROUTE_ID = ? ,  WRK_ROUTE_DESCR = ? , FROM_ROUTE_DESCR = ? ,  WORK_STAN_DESCR = ? , " +
					"WORK_LOCALITY_CODE = ? , WORK_LOCALITY_DESCR = ? , VISIT_TIME_FR = ? ,  VISIT_TIME_TO = ? WHERE SALES_PERS = ? AND WORK_DATE = ? ";
			// LAST_UPDATE = ? , LAST_UPDATE = ? , LINE_NO = ? ,
			pstmt3 = conn.prepareStatement(updateDrTravelDetailSql);
			pstmt3.setString(1, stanCode.trim());
			pstmt3.setString(2, stanCode.trim());
			pstmt3.setString(3, routeId.trim());
			pstmt3.setString(4, routeId.trim());
			pstmt3.setString(5, routeDescr.trim());
			pstmt3.setString(6, routeDescr.trim());
			pstmt3.setString(7, stanCodeDescr.trim());
			pstmt3.setString(8, localityCode.trim());
			pstmt3.setString(9, localityDescr.trim());
			pstmt3.setString(10, visitTimFrm.trim());
			pstmt3.setString(11, visitTimTo.trim());
			pstmt3.setString(12, salesPers.trim());
			pstmt3.setTimestamp(13, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
			int updateDrTraveldeatilSqlCnt= pstmt3.executeUpdate();
			if(updateDrTraveldeatilSqlCnt > 0)
			{
				isSuccess=true;
				System.out.println("updates successfully updateDrTraveldeatilSqlCnt"+updateDrTraveldeatilSqlCnt);
			}
			pstmt3 = ( pstmt3!=null )? null : pstmt3;

			//Dr Activity Details  update
			String updateDrActivityDetailSql= "UPDATE DR_ACTIVITY_DETAILS SET VISIT_TIME_FR = ? ,VISIT_TIME_TO = ? WHERE SALES_PERS = ? AND WORK_DATE = ? ";
			pstmt3 = conn.prepareStatement(updateDrActivityDetailSql);
			pstmt3.setString(1, visitTimFrm);
			pstmt3.setString(2, visitTimTo);
			pstmt3.setString(3, salesPers);
			pstmt3.setTimestamp(4, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
			int updateDrAcivitydeatilSqlCnt= pstmt3.executeUpdate();
			if(updateDrAcivitydeatilSqlCnt > 0)
			{
				isSuccess=true;
				System.out.println("updates successfully updateDrAcivitydeatilSqlCnt"+updateDrAcivitydeatilSqlCnt);
			}
			pstmt3 = ( pstmt3!=null )? null : pstmt3;

			// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
			if (isFortuneActivity.trim().equalsIgnoreCase("Y"))
			{
				String updateDrActivityDetailSql1= "UPDATE DR_ACTIVITY_DETAILS SET VISIT_TIME_FR = ? ,VISIT_TIME_TO = ? WHERE SALES_PERS = ? AND WORK_DATE = ? ";
				pstmt3 = conn.prepareStatement(updateDrActivityDetailSql1);
				pstmt3.setString(1, visitTimFrm);
				pstmt3.setString(2, visitTimTo);
				pstmt3.setString(3, salesPers);
				pstmt3.setTimestamp(4, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
				int updateDrAcivitydeatilSqlCnt1= pstmt3.executeUpdate();
				if(updateDrAcivitydeatilSqlCnt1 > 0)
				{
					isSuccess=true;
					System.out.println("updates successfully updateDrAcivitydeatilSqlCnt"+updateDrAcivitydeatilSqlCnt1);
				}
				pstmt3 = ( pstmt3!=null )? null : pstmt3;
			}
			// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
			//Dr Doctor Visit update
			if("L".equalsIgnoreCase(custType) || "F".equalsIgnoreCase(custType))
			{
				String updateDrDoctorVisitSql= "UPDATE DR_DOCTOR_VISIT SET SC_CODE = ? , WORK_ROUTE_ID = ? ,  WORK_LOCALITY_CODE  = ?, WORK_LOCALITY_DESCR = ? , " +
						"WORK_STAN_CODE = ? ,  WORK_STAN_DESCR = ? , VISIT_TIME_FR = ? ,  VISIT_TIME_TO = ?  WHERE SALES_PERS = ? AND WORK_DATE = ?  ";
				// LAST_UPDATE = ? , UPDATED_BY = ?
				pstmt3 = conn.prepareStatement(updateDrDoctorVisitSql);
				pstmt3.setString(1, strgCode.trim());
				pstmt3.setString(2, routeId.trim());
				pstmt3.setString(3, localityCode.trim());
				pstmt3.setString(4, localityDescr.trim());
				pstmt3.setString(5, stanCode.trim());
				pstmt3.setString(6, stanCodeDescr.trim());
				pstmt3.setString(7, visitTimFrm.trim());
				pstmt3.setString(8, visitTimTo.trim());
				pstmt3.setString(9, salesPers.trim());
				pstmt3.setTimestamp(10, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));

				int updateDrDoctorVisitSqlCnt= pstmt3.executeUpdate();
				if(updateDrDoctorVisitSqlCnt > 0)
				{
					isSuccess=true;
					System.out.println("updates successfully updateDrDoctorVisitSqlCnt"+updateDrDoctorVisitSqlCnt);
				}
				pstmt3 = ( pstmt3!=null )? null : pstmt3;

				//DR_SAMPLE_DISTRIBUTED update

				parentList = dom.getElementsByTagName("Detail3");
				int parentNodeListLength = parentList.getLength();
				System.out.println("parentNodeListLength(INSERTT IN DRSAMPLDISTRIBUTED)[" + parentNodeListLength + "]");
				if (parentNodeListLength > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++)
					{
						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						for (ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if (childNode.getNodeType() != Node.ELEMENT_NODE)
							{
								continue;
							}
							if (childNode != null && childNode.getFirstChild() != null)
							{
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								System.out.println("columnValue  :::::@@@@  " + columnValue);
							}
							childNodeName = childNode.getNodeName();
							System.out.println("childNodeName[" + childNodeName + "] columnValue>>::"+columnValue);
							if (childNodeName.equalsIgnoreCase("item_code"))
							{
								columnValueItm= childNode.getFirstChild().getNodeValue();
								System.out.println("columnValueItm>>satre[" + columnValueItm + "]");
							}
							System.out.println("columnValueItmaftr >>satre[" + columnValueItm + "]");
							if (childNodeName.equalsIgnoreCase("quantity"))
							{
								columnValueItmQty= childNode.getFirstChild().getNodeValue();
								System.out.println("columnValueItmDescr>>satre[" + columnValueItmQty + "]");
							}
							System.out.println("columnValueItmDescr afrt>>satre[" + columnValueItmQty + "]");
						}

						String drsampleSql ="SELECT COUNT(*) AS COUNT FROM DR_SAMPLE_DISTRIBUTED WHERE SALES_PERS = ? AND WORK_DATE = ?  AND ITEM_CODE = ? ";
						System.out.println( " sql sss item[" + drsampleSql + "]" );
						pStmt1 = conn.prepareStatement(drsampleSql);
						pStmt1.setString(1, salesPers.trim());
						pStmt1.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
						pStmt1.setString(3, columnValueItm.trim());
						ResultSet rs = pStmt1.executeQuery();
						if(rs.next())
						{
							count=rs.getInt("COUNT");
							System.out.println("Count in rs::>>"+count);
						}
						System.out.println("Count in after rs::>>"+count);
						if(count > 0)
						{
							System.out.println("Count in count ::>>"+count);
							System.out.println("in update record on edit mode");
							String updateDrSampleDistrbtdSql= "UPDATE DR_SAMPLE_DISTRIBUTED SET SC_CODE = ? , ITEM_QTY = ?  WHERE SALES_PERS = ? AND WORK_DATE = ?  AND  ITEM_CODE = ?";
							// LAST_UPDATE = ? , LAST_UPDATE = ? ,
							pstmt3 = conn.prepareStatement(updateDrSampleDistrbtdSql);
							pstmt3.setString(1, strgCode.trim());
							pstmt3.setString(2, columnValueItmQty.trim());
							pstmt3.setString(3, salesPers.trim());
							pstmt3.setTimestamp(4, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
							pstmt3.setString(5, columnValueItm.trim());
							int updateDrdoctrvisitSqlCnt= pstmt3.executeUpdate();

							if(updateDrdoctrvisitSqlCnt > 0)
							{
								isSuccess=true;
								System.out.println("updates successfully updateDrdoctrvisitSqlCnt"+updateDrdoctrvisitSqlCnt);
							}
							pstmt3 = ( pstmt3!=null )? null : pstmt3;
						}
						else
						{
							System.out.println("when Count is zero how much time get zeros::>>"+count);

							String insertDrSampleDistrSql = "INSERT INTO DR_SAMPLE_DISTRIBUTED (SALES_PERS , WORK_DATE , SC_CODE , SC_TYPE ," +
									" ITEM_CODE , ITEM_QTY , LAST_UPDATE , UPDATED_BY , FLG_SAMPLE_GIFT ) VALUES (? ,? , ? , ?, ? , ?, ?, ? , ? )";

							pstmtInsertDrSampleDistr = conn.prepareStatement(insertDrSampleDistrSql);
							pstmtInsertDrSampleDistr.setString(1, salesPers.trim());
							pstmtInsertDrSampleDistr.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
							pstmtInsertDrSampleDistr.setString(3, strgCode.trim());
							pstmtInsertDrSampleDistr.setString(4, custType.trim());
							pstmtInsertDrSampleDistr.setString(5, columnValueItm.trim());
							pstmtInsertDrSampleDistr.setString(6, columnValueItmQty.trim());
							pstmtInsertDrSampleDistr.setTimestamp(7,java.sql.Timestamp.valueOf(currDate));
							pstmtInsertDrSampleDistr.setString(8,  empcode.trim());
							pstmtInsertDrSampleDistr.setString(9, "");

							int insertDrSanpleDistrCnt = pstmtInsertDrSampleDistr.executeUpdate();
							System.out.println("pstmtInsertDrActivityDetails =["+insertDrSanpleDistrCnt+"]");

							if(insertDrSanpleDistrCnt > 0)
							{
								isSuccess = true;
								System.out.println("Inserted successfully into insertDrSanpleDistrCnt table =["+insertDrSanpleDistrCnt+"]");
							}
							System.out.println("in add records on edit mode>>::"+isSuccess);
						}
						System.out.println("Count in after count is zeros>>::>>"+count);
						rs = ( rs!=null )? null : rs;
						pStmt1 = ( pStmt1!=null )? null : pStmt1;
					}
				}
			}
			else
			{
				// dr Unlist visit update
				if("U".equalsIgnoreCase(custType))
				{
					custType="L";
				}
				else if("V".equalsIgnoreCase(custType))
				{
					custType="F";
				}

				String updateDrUnlistVisitSql= "UPDATE DR_UNLIST_VISIT SET CLIENT_NAME = ? , PHONE_NO = ? ,  ADDRESS = ? , EMAIL_ID = ? , LOCALITY_CODE = ? ," +
						" VISIT_TIME_FR = ? ,  VISIT_TIME_TO = ? WHERE SALES_PERS = ? AND WORK_DATE = ? ";
				// LAST_UPDATE = ? , UPDATED_BY = ?
				pstmt3 = conn.prepareStatement(updateDrUnlistVisitSql);
				pstmt3.setString(1, clientName.trim());
				pstmt3.setString(2, phoneNo.trim());
				pstmt3.setString(3, address.trim());
				pstmt3.setString(4, emailId.trim());
				pstmt3.setString(5, localityCode.trim());
				pstmt3.setString(6, visitTimFrm.trim());
				pstmt3.setString(7, visitTimTo.trim());
				pstmt3.setString(8, salesPers.trim());
				pstmt3.setTimestamp(9, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
				int updateDrUnlistVisitSqlCnt= pstmt3.executeUpdate();
				if(updateDrUnlistVisitSqlCnt > 0)
				{
					isSuccess=true;
					System.out.println("updates successfully updateDrUnlistVisitSqlCnt"+updateDrUnlistVisitSqlCnt);
				}
				pstmt3 = ( pstmt3!=null )? null : pstmt3;

				//DR_SAMPLE_DISTRIBUTED update

				parentList = dom.getElementsByTagName("Detail3");
				int parentNodeListLength = parentList.getLength();
				System.out.println("parentNodeListLength(INSERTT IN DRSAMPLDISTRIBUTED)[" + parentNodeListLength + "]");
				if (parentNodeListLength > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++)
					{
						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						for (ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if (childNode.getNodeType() != Node.ELEMENT_NODE)
							{
								continue;
							}
							if (childNode != null && childNode.getFirstChild() != null)
							{
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								System.out.println("columnValue  :::::@@@@  " + columnValue);
							}
							childNodeName = childNode.getNodeName();
							System.out.println("childNodeName[" + childNodeName + "] columnValue>>::"+columnValue);
							if (childNodeName.equalsIgnoreCase("item_code"))
							{
								columnValueItm= childNode.getFirstChild().getNodeValue();
								System.out.println("columnValueItm>>satre[" + columnValueItm + "]");
							}
							System.out.println("columnValueItmaftr >>satre[" + columnValueItm + "]");
							if (childNodeName.equalsIgnoreCase("quantity"))
							{
								columnValueItmQty= childNode.getFirstChild().getNodeValue();
								System.out.println("columnValueItmDescr>>satre[" + columnValueItmQty + "]");
							}
							System.out.println("columnValueItmDescr afrt>>satre[" + columnValueItmQty + "]");
						}

						String drsampleSql ="SELECT COUNT(*) AS COUNT FROM DR_SAMPLE_DISTRIBUTED WHERE SALES_PERS = ? AND WORK_DATE = ?  AND ITEM_CODE = ? ";
						pStmt1 = conn.prepareStatement(drsampleSql);
						pStmt1.setString(1, salesPers.trim());
						pStmt1.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
						pStmt1.setString(3, columnValueItm.trim());
						ResultSet rs = pStmt1.executeQuery();
						if(rs.next())
						{
							count=rs.getInt("COUNT");
							System.out.println("Count in rs::>>"+count);
						}
						System.out.println("Count in after rs::>>"+count);
						rs = ( rs!=null )? null : rs;
						pStmt1 = ( pStmt1!=null )? null : pStmt1;

						if(count > 0)
						{
							System.out.println("Count in count ::>>"+count);
							System.out.println("in update record on edit mode");
							String updateDrSampleDistrbtdSql= " UPDATE DR_SAMPLE_DISTRIBUTED SET ITEM_QTY = ?  WHERE SALES_PERS = ? AND WORK_DATE = ? AND ITEM_CODE = ?";
							// LAST_UPDATE = ? , LAST_UPDATE_BY = ? ,
							pstmt3 = conn.prepareStatement(updateDrSampleDistrbtdSql);
							pstmt3.setString(1, columnValueItmQty.trim());
							pstmt3.setString(2, salesPers.trim());
							pstmt3.setTimestamp(3, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
							pstmt3.setString(4, columnValueItm.trim());
							int updateDrSamplDistrtdSqlCnt= pstmt3.executeUpdate();
							if(updateDrSamplDistrtdSqlCnt > 0)
							{
								isSuccess=true;
								System.out.println("updates successfully updateDrSamplDistrtdSqlCnt"+updateDrSamplDistrtdSqlCnt);
							}
							pstmt3 = ( pstmt3!=null )? null : pstmt3;
						}
						else
						{
							String drUnlistSql ="SELECT SC_CODE FROM DR_UNLIST_VISIT WHERE SALES_PERS = ? AND WORK_DATE = ? ";
							System.out.println( " drUnlistSql sss item[" + drUnlistSql + "]" );
							pStmt1 = conn.prepareStatement(drUnlistSql);
							pStmt1.setString(1, salesPers.trim());
							pStmt1.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
							rs = pStmt1.executeQuery();
							if(rs.next())
							{
								strgCode=rs.getString("SC_CODE");
								System.out.println("strgCode in rs::>>"+count);
							}
							System.out.println("strgCode in after rs::>>"+count);
							rs = ( rs!=null )? null : rs;
							pStmt1 = ( pStmt1!=null )? null : pStmt1;


							String insertDrSampleDistrSql = "INSERT INTO DR_SAMPLE_DISTRIBUTED (SALES_PERS , WORK_DATE , SC_CODE , SC_TYPE ," +
									" ITEM_CODE , ITEM_QTY , LAST_UPDATE , UPDATED_BY , FLG_SAMPLE_GIFT ) VALUES (? ,? , ? , ?, ? , ?, ?, ? , ? )";

							pstmtInsertDrSampleDistr = conn.prepareStatement(insertDrSampleDistrSql);
							pstmtInsertDrSampleDistr.setString(1, salesPers.trim());
							pstmtInsertDrSampleDistr.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
							pstmtInsertDrSampleDistr.setString(3, strgCode.trim());
							pstmtInsertDrSampleDistr.setString(4, custType.trim());
							pstmtInsertDrSampleDistr.setString(5, columnValueItm.trim());
							pstmtInsertDrSampleDistr.setString(6, columnValueItmQty.trim());
							pstmtInsertDrSampleDistr.setTimestamp(7,java.sql.Timestamp.valueOf(currDate));
							pstmtInsertDrSampleDistr.setString(8,  empcode.trim());
							pstmtInsertDrSampleDistr.setString(9, "");

							int insertDrSanpleDistrCnt = pstmtInsertDrSampleDistr.executeUpdate();
							System.out.println("pstmtInsertDrActivityDetails =["+insertDrSanpleDistrCnt+"]");

							if(insertDrSanpleDistrCnt > 0)
							{
								isSuccess = true;
								System.out.println("Inserted successfully into insertDrSanpleDistrCnt table =["+insertDrSanpleDistrCnt+"]");
							}
							pstmtInsertDrSampleDistr.clearParameters();
							if(pstmtInsertDrSampleDistr != null)
							{
								pstmtInsertDrSampleDistr.close(); pstmtInsertDrSampleDistr = null;
							}
							System.out.println("in add records on edit mode>>::"+isSuccess);
						}
						System.out.println("Count in after count is zeros>>::>>"+count);
					}
				}
			}
		}
		catch(Exception exp)
		{
			System.out.println("Exception : updateRecordOnEdit :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		return isSuccess;
	}

	/*private boolean insertIntoSprsActTran( Connection conn, String salesPers, String dcrDate, String dcrID, String tranId, Document dom,String xtraParams ) throws ITMException
	{
		boolean isSuccess = false;
		PreparedStatement pstmtInsertSprsActTran=null;
		PreparedStatement pStmt=null;
		try
		{
			System.out.println("insertIntoSprsActTran is called...........");
			String empcode=genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			InetAddress ownIP=InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString(currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			String sql = "DELETE FROM SPRS_ACT_TRAN  WHERE SALES_PERS = ? AND EVENT_DATE = ?";
			pStmt = conn.prepareStatement( sql );
			pStmt.setString( 1, salesPers);
			pStmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			int updateCnt = pStmt.executeUpdate();
			System.out.println(" Gaurav :: Update Count for deleting from SPRS_ACT_TRAN ::: ["+updateCnt+"]");
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}

			String insertSprsActTranSql = " INSERT INTO SPRS_ACT_TRAN(TRAN_ID, EVENT_DATE, ACTIVITY_CODE, SALES_PERS, SPRS_CODE__WW, CHG_DATE, CHG_USER, CHG_TERM, DCR_ID) "+
										  " VALUES(?,?,?,?,?,?,?,?,?)";

			pstmtInsertSprsActTran = conn.prepareStatement(insertSprsActTranSql);
			pstmtInsertSprsActTran.setString(1, tranId);
			pstmtInsertSprsActTran.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
			pstmtInsertSprsActTran.setString(3, "FW");
			pstmtInsertSprsActTran.setString(4, salesPers.trim());
			pstmtInsertSprsActTran.setString(5,"");//SPRS_CODE__WW
			pstmtInsertSprsActTran.setTimestamp(6, java.sql.Timestamp.valueOf(currDate));
			pstmtInsertSprsActTran.setString(7, empcode.trim());
			pstmtInsertSprsActTran.setString(8, chgTerm);
			pstmtInsertSprsActTran.setString(9, dcrID);

			int insertSprsActTranCnt = pstmtInsertSprsActTran.executeUpdate();

			System.out.println("insertSprsActTranCnt =["+insertSprsActTranCnt+"]");
			if(insertSprsActTranCnt > 0)
			{
				isSuccess = true;
				System.out.println("Inserted successfully into sprs_act_tran table =["+insertSprsActTranCnt+"]");
			}
			pstmtInsertSprsActTran.clearParameters();

			if(pstmtInsertSprsActTran != null)
			{
				pstmtInsertSprsActTran.close();
				pstmtInsertSprsActTran = null;
			}
			//conn.commit();
		}
		catch(Exception exp)
		{
			System.out.println("Exception : insertIntoSprsActTran :::==>\n");
			throw new ITMException(exp);
		}
		return isSuccess;
	}*/

	private boolean insertIntoSprsTravel( Connection conn, String salesPers, String dcrDate, String dcrID, String tranId, Document dom,String xtraParams ) throws ITMException
	{
		boolean isSuccess = false;
		int lineNo=0;
		PreparedStatement pstmtInsertSprsTravel=null;
		PreparedStatement pStmt1=null;
		ResultSet rs1=null;
		String localitySql="",localityCode="",stanCode="",strgCode="",loginCode="",locality="",custType="";
		try
		{
			System.out.println("insertIntoSprsTravel is called...........");
			strgCode = genericUtility.getColumnValue("strg_code",dom);
			locality = genericUtility.getColumnValue("locality_code",dom);
			custType = genericUtility.getColumnValue("cust_type",dom);
			loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			System.out.println(" loginCode[" + loginCode + "]");
			String empcode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			InetAddress ownIP = InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			// currDate = genericUtility.getValidDateString(currDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat());
			currDate = genericUtility.getValidDateTimeString(currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			if ("F".equalsIgnoreCase(custType.trim()) || "L".equalsIgnoreCase(custType.trim()) )
			{
				localitySql ="SELECT LOCALITY_CODE,STAN_CODE FROM LOCALITY WHERE LOCALITY_CODE = (SELECT LOCALITY_CODE FROM STRG_CUSTOMER WHERE SC_CODE =  ? ) ";
				pStmt1 = conn.prepareStatement(localitySql);
				pStmt1.setString(1, strgCode);
			}
			else
			{
				localitySql ="SELECT LOCALITY_CODE,STAN_CODE FROM LOCALITY WHERE LOCALITY_CODE = ? ";
				pStmt1 = conn.prepareStatement(localitySql);
				pStmt1.setString(1, locality);
			}
			rs1 = pStmt1.executeQuery();
			if(rs1.next())
			{
				localityCode=checkNull(rs1.getString("LOCALITY_CODE"));
				stanCode=checkNull(rs1.getString("STAN_CODE"));
			}
			rs1 = ( rs1!=null )? null : rs1;
			pStmt1 = ( pStmt1!=null )? null : pStmt1;

			String insertSprsTravelSql = "INSERT INTO SPRS_TRAVEL(TRAN_ID, SALES_PERS, TRAVEL_DATE, LOCALITY_CODE, STAN_CODE, STAN_CODE__FROM, TRAVEL_MODE," +
					" OVER_NIGHT, ACTIVITY_CODE, CHG_DATE, CHG_USER, CHG_TERM, OTH_PARTICIPANT, SPRS_CODE__WW, ORDER_OF_VISIT, DCR_ID, LINE_NO) "+
					"VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			//,LOCALITY_CODE_FROM
			pstmtInsertSprsTravel = conn.prepareStatement(insertSprsTravelSql);

			lineNo++;
			pstmtInsertSprsTravel.setString(1, tranId.trim());
			pstmtInsertSprsTravel.setString(2, salesPers.trim());
			pstmtInsertSprsTravel.setTimestamp(3, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
			pstmtInsertSprsTravel.setString(4, localityCode.trim());
			pstmtInsertSprsTravel.setString(5, stanCode.trim());
			pstmtInsertSprsTravel.setString(6, stanCode.trim());
			pstmtInsertSprsTravel.setString(7, "ROAD");
			pstmtInsertSprsTravel.setString(8, "N");
			pstmtInsertSprsTravel.setString(9, "FW");
			pstmtInsertSprsTravel.setTimestamp(10, java.sql.Timestamp.valueOf(currDate));
			pstmtInsertSprsTravel.setString(11, empcode.trim());
			pstmtInsertSprsTravel.setString(12, chgTerm.trim());
			pstmtInsertSprsTravel.setString(13, "");
			pstmtInsertSprsTravel.setString(14, "");
			pstmtInsertSprsTravel.setString(15, "1");
			pstmtInsertSprsTravel.setString(16, dcrID.trim());
			pstmtInsertSprsTravel.setInt(17, lineNo);
			//pstmtInsertSprsTravel.setString(18, localityCode.trim());//LOCALITY_CODE_FROM
			int insertSprsTravelCnt = pstmtInsertSprsTravel.executeUpdate();
			System.out.println("insertSprsTravelCnt =["+insertSprsTravelCnt+"]");
			pstmtInsertSprsTravel.clearParameters();
			if (insertSprsTravelCnt > 0)
			{
				isSuccess = true;
				System.out.println("inserted successfully into sprs travel =["+insertSprsTravelCnt+"]");
			}
			if(pstmtInsertSprsTravel != null)
			{
				pstmtInsertSprsTravel.close(); pstmtInsertSprsTravel = null;
			}
		}
		catch(Exception exp)
		{
			System.out.println("Exception : insertIntoSprsTravel :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		return isSuccess;
	}

	private void insertIntoSprsTravel( Connection conn, String salesPers, String dcrDate, String tranID,String activityCode,String xtraParams ) throws ITMException
	{
		try
		{
			System.out.println("insertIntoSprsTravel is called...........");
			//changed by Rahul Barve on 3-sep-2014
			//GenericUtility genericUtility = GenericUtility.getInstance();
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			String dcrID = "";
			String stanCodeHq = "";
			String localityCode = "",routeId="",stationType="";
			String geoLongitude = "";
			String geoLatitude = "";
			String addGeoPos = "";
			String currentGeoPos = "";
			System.out.println("currentGeoPosition is[" +currentGeoPos +"]");

			String sqlHq = "select stan_code__hq from employee where emp_code= ? ";
			PreparedStatement pstmtHq = conn.prepareStatement( sqlHq );
			pstmtHq.setString(1, salesPers);
			ResultSet rsHq = pstmtHq.executeQuery();
			if ( rsHq.next() )
			{
				stanCodeHq =   (rsHq.getString("STAN_CODE__HQ") == null) ? "" : rsHq.getString("STAN_CODE__HQ").trim();
			}
			rsHq.close(); rsHq = null;
			pstmtHq.close(); pstmtHq = null;

			System.out.println("[stanCodeHq = " + stanCodeHq + "]");

			String sql1 = "select dcr_id from strg_meet where tran_id = ?";
			PreparedStatement pstmtDcr = conn.prepareStatement(sql1);
			pstmtDcr.setString(1, tranID);
			ResultSet rsDcr = pstmtDcr.executeQuery();
			if(rsDcr.next())
			{
				dcrID = rsDcr.getString("dcr_id");
			}
			pstmtDcr.close(); pstmtDcr = null;
			rsDcr.close(); rsDcr = null;

			//Inserting into sprs_travel table
			String insertSprsTravelSql = "INSERT INTO SPRS_TRAVEL(TRAN_ID, SALES_PERS, TRAVEL_DATE, LOCALITY_CODE, STAN_CODE, STAN_CODE__FROM, TRAVEL_MODE," +
					" OVER_NIGHT, ACTIVITY_CODE, CHG_DATE, CHG_USER, CHG_TERM, OTH_PARTICIPANT, SPRS_CODE__WW, ORDER_OF_VISIT, DCR_ID, LINE_NO,ADD_GEOPOS,CHG_GEOPOS,ROUTE_ID,ROUTE_ID_FROM,LOCALITY_CODE_FROM,STATION_TYPE) "+
					"VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

			PreparedStatement pstmtInsertStrgMeet = conn.prepareStatement(insertSprsTravelSql);

			String sationType = "HQ";
			//commented & added by mrunalini sinkar for remove hardcode HQ changes [S18EMES002](start)

			//String getLocalitySql = "select sr.locality_code,loc.longitude,loc.latitude  from sprs_route sr,locality loc where sr.stan_code = ? and sr.station_type = ? and sr.locality_code = loc.locality_code ";
			String getLocalitySql = "select sr.locality_code,loc.longitude,loc.latitude,sr.route_id,sr.station_type  from sprs_route sr,locality loc "
					+ "where sr.stan_code = ? and sr.sprs_code = ? and sr.status='Y' and sr.locality_code = loc.locality_code ";
			//commented & added by mrunalini sinkar for remove hardcode HQ changes [S18EMES002](end)

			PreparedStatement pstmtLocality = conn.prepareStatement(getLocalitySql);
			pstmtLocality.setString(1, stanCodeHq);
			pstmtLocality.setString(2, salesPers);

			ResultSet rsGetLocality = pstmtLocality.executeQuery();
			if(rsGetLocality.next())
			{
				localityCode =   (rsGetLocality.getString("LOCALITY_CODE") == null) ? "" : rsGetLocality.getString("LOCALITY_CODE").trim();
				routeId = checkNull(rsGetLocality.getString("ROUTE_ID") );
				stationType = checkNull(rsGetLocality.getString("STATION_TYPE") );
				System.out.println("[localityCode = " + localityCode + "]");
				geoLongitude = (rsGetLocality.getString("LONGITUDE") == null) ? "" :rsGetLocality.getString("LONGITUDE").trim();
				geoLatitude = (rsGetLocality.getString("LATITUDE") == null) ? "" :rsGetLocality.getString("LATITUDE").trim();
				System.out.println("[geoLongitude = " + geoLongitude + "]"+"[geoLatitude =" + geoLatitude + "]");
			}
			rsGetLocality.close(); rsGetLocality = null;
			pstmtLocality.close(); pstmtLocality = null;

			if(geoLongitude.length()>0 && geoLatitude.length()>0)
			{
				addGeoPos = geoLongitude+ "," + geoLatitude;
			}

			else
			{
				addGeoPos=null;
			}

			System.out.println("--------------salesPers ---------------" + salesPers + "-----------------localityCode -----------------" + localityCode + "------------stanCodeHq----------------------" + stanCodeHq + "-------------------activityCode------------ " + activityCode + "-------------dcrID------------------------" + dcrID);

			pstmtInsertStrgMeet.setString(1, tranID);
			pstmtInsertStrgMeet.setString(2, salesPers);
			pstmtInsertStrgMeet.setTimestamp(3, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
			pstmtInsertStrgMeet.setString(4, localityCode);
			pstmtInsertStrgMeet.setString(5, stanCodeHq);
			pstmtInsertStrgMeet.setString(6, stanCodeHq);
			pstmtInsertStrgMeet.setString(7, "1");
			pstmtInsertStrgMeet.setString(8, "");
			pstmtInsertStrgMeet.setString(9, activityCode);
			pstmtInsertStrgMeet.setTimestamp(10, java.sql.Timestamp.valueOf(currDate));
			pstmtInsertStrgMeet.setString(11, "SYSTEM");
			pstmtInsertStrgMeet.setString(12, "SYSTEM");
			pstmtInsertStrgMeet.setString(13, "");
			pstmtInsertStrgMeet.setString(14, "");
			pstmtInsertStrgMeet.setString(15, "1");
			pstmtInsertStrgMeet.setString(16, dcrID);
			pstmtInsertStrgMeet.setString(17, "1");
			pstmtInsertStrgMeet.setString(18, addGeoPos);
			pstmtInsertStrgMeet.setString(19, currentGeoPos);
			pstmtInsertStrgMeet.setString(20, routeId);
			pstmtInsertStrgMeet.setString(21, routeId);
			pstmtInsertStrgMeet.setString(22, localityCode);
			pstmtInsertStrgMeet.setString(23, stationType);


			int insertSprsTravelCnt = pstmtInsertStrgMeet.executeUpdate();
			System.out.println("insertSprsTravelCnt =["+insertSprsTravelCnt+"]");

			pstmtInsertStrgMeet.clearParameters();
			if (insertSprsTravelCnt > 0)
			{
				System.out.println("inserted successfully into sprs travel =["+insertSprsTravelCnt+"]");
			}

			if(pstmtInsertStrgMeet != null)
			{
				pstmtInsertStrgMeet.close(); pstmtInsertStrgMeet = null;
			}
		}
		catch(Exception exp)
		{
			System.out.println("Exception : insertIntoSprsTravel :generateTransID :==>\n");
			throw new ITMException(exp);
		}
	}

	private boolean insertIntoDrTravelDetails( Connection conn, String salesPers, String dcrDate, String dcrID, String tranId, Document dom,String xtraParams ) throws ITMException
	{
		boolean isSuccess = false;
		int lineNo=0;
		PreparedStatement pstmtInsertDrTravelDetails=null;
		PreparedStatement pStmt1=null;
		ResultSet rs1=null;
		String localitySql="",localityCode="",stanCode="",strgCode="",loginCode="",custType="",remarks="",visitTimFrm="",visitTimTo="",localityDescr="";
		String routeIdsql="",routeId="",stanCodeDescr="",stanCodeDescrSql="",routeDescr="",locality="";
		try
		{
			System.out.println("insertIntoDrTravelDetails is called...........");
			strgCode=genericUtility.getColumnValue("strg_code",dom);
			custType=genericUtility.getColumnValue("cust_type",dom);
			locality=genericUtility.getColumnValue("locality_code",dom);
			remarks=genericUtility.getColumnValue("remarks",dom);
			visitTimFrm=genericUtility.getColumnValue("event_time_start",dom);
			visitTimTo=genericUtility.getColumnValue("event_time_end",dom);
			loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			System.out.println(" loginCode[" + loginCode + "]");
			String empcode=genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			InetAddress ownIP=InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			// currDate = genericUtility.getValidDateString(currDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat());
			currDate = genericUtility.getValidDateTimeString(currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			if ("F".equalsIgnoreCase(custType.trim()) || "L".equalsIgnoreCase(custType.trim()) )
			{
				localitySql ="SELECT LOCALITY_CODE,STAN_CODE,DESCR FROM LOCALITY WHERE LOCALITY_CODE = (SELECT LOCALITY_CODE FROM STRG_CUSTOMER WHERE SC_CODE =  ? ) ";
				pStmt1 = conn.prepareStatement(localitySql);
				pStmt1.setString(1, strgCode);
			}
			else
			{
				localitySql ="SELECT LOCALITY_CODE,STAN_CODE,DESCR FROM LOCALITY WHERE LOCALITY_CODE = ? ";
				pStmt1 = conn.prepareStatement(localitySql);
				pStmt1.setString(1, locality);
			}
			rs1 = pStmt1.executeQuery();
			if(rs1.next())
			{
				localityCode=checkNull(rs1.getString("LOCALITY_CODE").trim());
				stanCode=checkNull(rs1.getString("STAN_CODE").trim());
				localityDescr=checkNull(rs1.getString("DESCR").trim());
			}
			rs1 = ( rs1!=null )? null : rs1;
			pStmt1 = ( pStmt1!=null )? null : pStmt1;

			stanCodeDescrSql ="SELECT DESCR FROM STATION WHERE STAN_CODE = ? ";
			pStmt1 = conn.prepareStatement(stanCodeDescrSql);
			pStmt1.setString(1, stanCode);
			rs1 = pStmt1.executeQuery();
			if(rs1.next())
			{
				stanCodeDescr=checkNull(rs1.getString("DESCR").trim());
			}
			rs1 = ( rs1!=null )? null : rs1;
			pStmt1 = ( pStmt1!=null )? null : pStmt1;

			routeIdsql ="SELECT ROUTE_ID ,DESCR FROM SPRS_ROUTE WHERE SPRS_CODE= ?  AND LOCALITY_CODE= ?  ";
			pStmt1 = conn.prepareStatement(routeIdsql);
			pStmt1.setString(1, salesPers);
			pStmt1.setString(2, localityCode);
			rs1 = pStmt1.executeQuery();
			if(rs1.next())
			{
				routeId=checkNull(rs1.getString("ROUTE_ID").trim());
				routeDescr=checkNull(rs1.getString("DESCR").trim());
			}
			rs1 = ( rs1!=null )? null : rs1;
			pStmt1 = ( pStmt1!=null )? null : pStmt1;


			String insertDrDoctorVisitSql = "INSERT INTO DR_TRAVEL_DETAILS (SALES_PERS , WORK_DATE , WORK_STAN_CODE , FROM_STAN_CODE , TRAVEL_MODE_ID , LAST_UPDATE , " +
					"UPDATED_BY , ACTIVITY_CODE , WORK_ROUTE_ID , FROM_ROUTE_ID , WRK_ROUTE_DESCR , SALES_PERS_MGR , FROM_ROUTE_DESCR , LINE_NO , LOCALITY_TYPE , " +
					"STATION_TYPE , NIGHT_STAY , DR_VISITED ,WORK_STAN_DESCR , WORK_LOCALITY_CODE, WORK_LOCALITY_DESCR , VISIT_TIME_FR , VISIT_TIME_TO  ) " +
					"VALUES( ? ,? ,? ,? ,? ,? ,? ,? , ?, ?, ?, ?, ?, ? ,? ,? ,? ,? ,? ,? ,? ,? ,? )";

			pstmtInsertDrTravelDetails = conn.prepareStatement(insertDrDoctorVisitSql);

			lineNo++;
			pstmtInsertDrTravelDetails.setString(1, salesPers.trim());
			pstmtInsertDrTravelDetails.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
			pstmtInsertDrTravelDetails.setString(3, stanCode.trim());
			pstmtInsertDrTravelDetails.setString(4, stanCode.trim());
			pstmtInsertDrTravelDetails.setString(5, "");
			pstmtInsertDrTravelDetails.setTimestamp(6,java.sql.Timestamp.valueOf(currDate));
			pstmtInsertDrTravelDetails.setString(7, empcode);
			pstmtInsertDrTravelDetails.setString(8, "FW");
			pstmtInsertDrTravelDetails.setString(9, routeId.trim());//WORK_ROUTE_ID
			pstmtInsertDrTravelDetails.setString(10, routeId.trim());//FROM_ROUTE_ID
			pstmtInsertDrTravelDetails.setString(11, routeDescr.trim());//WRK_ROUTE_DESCR
			pstmtInsertDrTravelDetails.setString(12, salesPers.trim());//SALES_PERS_MGR
			pstmtInsertDrTravelDetails.setString(13, routeDescr.trim());//FROM_ROUTE_DESCR
			pstmtInsertDrTravelDetails.setInt(14, lineNo);//
			pstmtInsertDrTravelDetails.setString(15, "");//locality_type
			pstmtInsertDrTravelDetails.setString(16, "");//STATION_TYPE
			pstmtInsertDrTravelDetails.setString(17, "");//NIGHT_STAY
			pstmtInsertDrTravelDetails.setString(18, "");//DR_VISITED
			pstmtInsertDrTravelDetails.setString(19, stanCodeDescr.trim());
			pstmtInsertDrTravelDetails.setString(20, localityCode.trim());
			pstmtInsertDrTravelDetails.setString(21, localityDescr.trim());
			pstmtInsertDrTravelDetails.setString(22, visitTimFrm.trim());
			pstmtInsertDrTravelDetails.setString(23, visitTimTo.trim());

			int insertDrTravelCnt = pstmtInsertDrTravelDetails.executeUpdate();
			System.out.println("insertIntoDrTravelDetailscnt =["+insertDrTravelCnt+"]");

			pstmtInsertDrTravelDetails.clearParameters();
			if (insertDrTravelCnt > 0)
			{
				isSuccess = true;
				System.out.println("inserted successfully into insertIntoDrTravelDetails cnttravel =["+insertDrTravelCnt+"]");
			}
			if(pstmtInsertDrTravelDetails != null)
			{
				pstmtInsertDrTravelDetails.close(); pstmtInsertDrTravelDetails = null;
			}
		}
		catch(Exception exp)
		{
			System.out.println("Exception : insertIntoDrTravelDetails :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		return isSuccess;
	}

	private boolean insertIntoDrActivityDetails( Connection conn, String salesPers, String dcrDate, String dcrID, String tranId, Document dom,String xtraParams ) throws ITMException
	{
		boolean isSuccess = false;
		PreparedStatement pstmtInsertDrActivityDetails=null;
		String loginCode="",visitTimFrm="",visitTimTo="",remarks="";
		try
		{
			System.out.println("insertIntoDrActivityDetails is called...........");
			visitTimFrm = genericUtility.getColumnValue("event_time_start",dom);
			visitTimTo = genericUtility.getColumnValue("event_time_end",dom);
			remarks = genericUtility.getColumnValue("remarks",dom);
			loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			System.out.println(" loginCode[" + loginCode + "]");
			String empcode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			InetAddress ownIP = InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			//currDate = genericUtility.getValidDateString(currDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat());
			currDate = genericUtility.getValidDateTimeString(currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			String insertSprsActTranSql = "INSERT INTO DR_ACTIVITY_DETAILS (SALES_PERS, WORK_DATE, ACTIVITY_CODE, VISIT_TIME_FR, VISIT_TIME_TO , REMARK )" +
					" VALUES  (?, ? ,?, ? ,? , ? )";

			pstmtInsertDrActivityDetails = conn.prepareStatement(insertSprsActTranSql);
			//String dcrID = generateDCRId(conn);
			pstmtInsertDrActivityDetails.setString(1, salesPers.trim());
			pstmtInsertDrActivityDetails.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
			pstmtInsertDrActivityDetails.setString(3, "FW");
			pstmtInsertDrActivityDetails.setString(4, visitTimFrm.trim());
			pstmtInsertDrActivityDetails.setString(5, visitTimTo.trim());
			pstmtInsertDrActivityDetails.setString(6, remarks);

			int insertSprsActTranCnt = pstmtInsertDrActivityDetails.executeUpdate();
			System.out.println("pstmtInsertDrActivityDetails =["+insertSprsActTranCnt+"]");
			if(insertSprsActTranCnt > 0)
			{
				isSuccess = true;
				System.out.println("Inserted successfully into pstmtInsertDrActivityDetails table =["+insertSprsActTranCnt+"]");
			}
			pstmtInsertDrActivityDetails.clearParameters();

			if(pstmtInsertDrActivityDetails != null)
			{
				pstmtInsertDrActivityDetails.close(); pstmtInsertDrActivityDetails = null;
			}
		}
		catch(Exception exp)
		{
			System.out.println("Exception : insertIntoDrActivityDetails :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		return isSuccess;
	}
	// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
	private boolean insertIntosprsActivityDetails( Connection conn, String salesPers, String dcrDate, String tranID,String activityCode,String xtraParams, Document dom) throws ITMException	
	{
		boolean isSuccess = false;
		PreparedStatement pstmtInsertDrActivityDetails=null;
		String loginCode="",visitTimFrm="",visitTimTo="",remarks="";
		String dcrID="";
		try
		{
			
			
			System.out.println("insertIntoDrActivityDetails is called...........");
			visitTimFrm = genericUtility.getColumnValue("event_time_start",dom);
			visitTimTo = genericUtility.getColumnValue("event_time_end",dom);
			remarks = genericUtility.getColumnValue("remarks",dom);
			loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			System.out.println(" loginCode[" + loginCode + "]");
			String empcode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			InetAddress ownIP = InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			//currDate = genericUtility.getValidDateString(currDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat());
			currDate = genericUtility.getValidDateTimeString(currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			String sql1 = "select dcr_id from strg_meet where tran_id = ?";
			PreparedStatement pstmtDcr = conn.prepareStatement(sql1);
			pstmtDcr.setString(1, tranID);
			ResultSet rsDcr = pstmtDcr.executeQuery();
			if(rsDcr.next())
			{
				dcrID = rsDcr.getString("dcr_id");
			}
			pstmtDcr.close(); pstmtDcr = null;
			rsDcr.close(); rsDcr = null;
			
			
			
			String insertSprsActTranSql = "INSERT INTO SPRS_ACTIVITY (dcr_id ,SALES_PERS, EVENT_DATE, ACTIVITY_CODE, VISIT_TIME_FR, VISIT_TIME_TO , REMARK )" +
					" VALUES  (?, ? ,?, ? ,? , ?, ? )";

			pstmtInsertDrActivityDetails = conn.prepareStatement(insertSprsActTranSql);
			//String dcrID = generateDCRId(conn);
			pstmtInsertDrActivityDetails.setString(1, dcrID.trim());
			pstmtInsertDrActivityDetails.setString(2, salesPers.trim());
			pstmtInsertDrActivityDetails.setTimestamp(3, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
			pstmtInsertDrActivityDetails.setString(4, activityCode);
			pstmtInsertDrActivityDetails.setString(5, visitTimFrm.trim());
			pstmtInsertDrActivityDetails.setString(6, visitTimTo.trim());
			pstmtInsertDrActivityDetails.setString(7, remarks);

			int insertSprsActTranCnt = pstmtInsertDrActivityDetails.executeUpdate();
			System.out.println("insertIntosprsActivityDetails =["+insertSprsActTranCnt+"]");
			if(insertSprsActTranCnt > 0)
			{
				isSuccess = true;
				System.out.println("Inserted successfully into insertIntosprsActivityDetails table =["+insertSprsActTranCnt+"]");
			}
			pstmtInsertDrActivityDetails.clearParameters();

			if(pstmtInsertDrActivityDetails != null)
			{
				pstmtInsertDrActivityDetails.close(); pstmtInsertDrActivityDetails = null;
			}
		}
		catch(Exception exp)
		{
			System.out.println("Exception : insertIntosprsActivityDetails :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		return isSuccess;
	}
	// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
	private boolean insertIntoDrSampleDistributed( Connection conn, String salesPers, String dcrDate,Document dom,String xtraParams,String strgCode ) throws ITMException

	{
		boolean isSuccess = false;
		PreparedStatement pstmtInsertDrSampleDistr=null;
		PreparedStatement pStmt1=null;
		ResultSet rs1=null;
		String loginCode="",itemCode="",quantity="",custType="";

		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr = 0;
		int noOfChilds = 0;
		String columnValueItm = "",columnValueItmQty="";
		String childNodeName = "",columnValue="";
		try
		{
			System.out.println("insertIntoDrActivityDetails is called...........");
			//strgCode=genericUtility.getColumnValue("strg_code",dom);
			custType=genericUtility.getColumnValue("cust_type",dom);
			itemCode=genericUtility.getColumnValue("item_code",dom);
			quantity=genericUtility.getColumnValue("quantity",dom);

			loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			System.out.println(" loginCode[" + loginCode + "]");
			String empcode=genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			InetAddress ownIP=InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			//currDate = genericUtility.getValidDateString(currDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat());
			currDate = genericUtility.getValidDateTimeString(currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			parentList = dom.getElementsByTagName("Detail3");
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentNodeListLength(INSERTT IN DRSAMPLDISTRIBUTED)[" + parentNodeListLength + "]");
			if (parentNodeListLength > 0)
			{
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++)
				{
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if (childNode.getNodeType() != Node.ELEMENT_NODE)
						{
							continue;
						}
						if (childNode != null && childNode.getFirstChild() != null)
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
							System.out.println("columnValue  :::::@@@@  " + columnValue);
						}
						childNodeName = childNode.getNodeName();
						System.out.println("childNodeName[" + childNodeName + "] columnValue>>::"+columnValue);
						if (childNodeName.equalsIgnoreCase("item_code"))
						{
							columnValueItm= childNode.getFirstChild().getNodeValue();
							System.out.println("columnValueItm>>satre[" + columnValueItm + "]");
						}
						System.out.println("columnValueItmaftr >>satre[" + columnValueItm + "]");
						if (childNodeName.equalsIgnoreCase("quantity"))
						{
							columnValueItmQty= childNode.getFirstChild().getNodeValue();
							System.out.println("columnValueItmDescr>>satre[" + columnValueItmQty + "]");
						}
						System.out.println("columnValueItmDescr afrt>>satre[" + columnValueItmQty + "]");
					}
					if("U".equalsIgnoreCase(custType))
					{
						custType="L";
					}
					else if("V".equalsIgnoreCase(custType))
					{
						custType="F";
					}
					String insertDrSampleDistrSql = "INSERT INTO DR_SAMPLE_DISTRIBUTED (SALES_PERS , WORK_DATE , SC_CODE , SC_TYPE ," +
							" ITEM_CODE , ITEM_QTY , LAST_UPDATE , UPDATED_BY , FLG_SAMPLE_GIFT ) VALUES (? ,? , ? , ?, ? , ?, ?, ? , ? )";

					pstmtInsertDrSampleDistr = conn.prepareStatement(insertDrSampleDistrSql);
					pstmtInsertDrSampleDistr.setString(1, salesPers.trim());
					pstmtInsertDrSampleDistr.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
					pstmtInsertDrSampleDistr.setString(3, strgCode.trim());
					pstmtInsertDrSampleDistr.setString(4, custType.trim());
					pstmtInsertDrSampleDistr.setString(5, columnValueItm.trim());
					pstmtInsertDrSampleDistr.setString(6, columnValueItmQty.trim());
					pstmtInsertDrSampleDistr.setTimestamp(7,java.sql.Timestamp.valueOf(currDate));
					pstmtInsertDrSampleDistr.setString(8,  empcode.trim());
					pstmtInsertDrSampleDistr.setString(9, "");

					int insertDrSanpleDistrCnt = pstmtInsertDrSampleDistr.executeUpdate();
					System.out.println("pstmtInsertDrActivityDetails =["+insertDrSanpleDistrCnt+"]");
					if(insertDrSanpleDistrCnt > 0)
					{
						isSuccess = true;
						System.out.println("Inserted successfully into insertDrSanpleDistrCnt table =["+insertDrSanpleDistrCnt+"]");
					}
				}
			}
			if(pstmtInsertDrSampleDistr != null)
			{
				pstmtInsertDrSampleDistr.clearParameters();
				pstmtInsertDrSampleDistr.close(); pstmtInsertDrSampleDistr = null;
			}
		}
		catch(Exception exp)
		{
			System.out.println("Exception : insertIntoDrActivityDetails :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		return isSuccess;
	}

	private boolean insertIntoDrDoctorVisit( Connection conn, String salesPers, String dcrDate, String dcrID, String tranId, Document dom,String xtraParams ) throws ITMException
	{
		boolean isSuccess = false;
		int lineNo=0;
		PreparedStatement pstmtInsertDrDoctorVisit=null,pstmt3=null;
		PreparedStatement pStmt1=null;
		ResultSet rs1=null,rs3=null;
		int count=0;
		String localitySql="",localityCode="",stanCode="",strgCode="",loginCode="",custType="",remarks="",visitTimFrm="",visitTimTo="",localityDescr="";
		String routeIdsql="",routeId="",stanCodeDescr="",stanCodeDescrSql="",locality="";
		try
		{
			System.out.println("insertIntoDrDoctorVisit is called...........");
			strgCode=genericUtility.getColumnValue("strg_code",dom);
			custType=genericUtility.getColumnValue("cust_type",dom);
			remarks=genericUtility.getColumnValue("remarks",dom);
			visitTimFrm=genericUtility.getColumnValue("event_time_start",dom);
			visitTimTo=genericUtility.getColumnValue("event_time_end",dom);
			locality=genericUtility.getColumnValue("locality_code",dom);
			loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			System.out.println(" loginCode[" + loginCode + "]");
			String empcode=genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			InetAddress ownIP=InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			//currDate = genericUtility.getValidDateString(currDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat());
			currDate = genericUtility.getValidDateTimeString(currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			if ("F".equalsIgnoreCase(custType.trim()) || "L".equalsIgnoreCase(custType.trim()) )
			{
				localitySql ="SELECT LOCALITY_CODE,STAN_CODE,DESCR FROM LOCALITY WHERE LOCALITY_CODE = (SELECT LOCALITY_CODE FROM STRG_CUSTOMER WHERE SC_CODE =  ? ) ";
				pStmt1 = conn.prepareStatement(localitySql);
				pStmt1.setString(1, strgCode);
			}
			else
			{
				localitySql ="SELECT LOCALITY_CODE,STAN_CODE,DESCR FROM LOCALITY WHERE LOCALITY_CODE = ? ";
				pStmt1 = conn.prepareStatement(localitySql);
				pStmt1.setString(1, locality);
			}
			pStmt1 = conn.prepareStatement(localitySql);
			pStmt1.setString(1, strgCode);
			rs1 = pStmt1.executeQuery();
			if(rs1.next())
			{
				localityCode=checkNull(rs1.getString("LOCALITY_CODE").trim());
				stanCode=checkNull(rs1.getString("STAN_CODE").trim());
				localityDescr=checkNull(rs1.getString("DESCR").trim());
			}
			rs1 = ( rs1!=null )? null : rs1;
			pStmt1 = ( pStmt1!=null )? null : pStmt1;

			stanCodeDescrSql ="SELECT DESCR FROM STATION WHERE STAN_CODE = ? ";
			pStmt1 = conn.prepareStatement(stanCodeDescrSql);
			pStmt1.setString(1, stanCode);
			rs1 = pStmt1.executeQuery();
			if(rs1.next())
			{
				stanCodeDescr=checkNull(rs1.getString("DESCR").trim());
			}
			rs1 = ( rs1!=null )? null : rs1;
			pStmt1 = ( pStmt1!=null )? null : pStmt1;

			routeIdsql ="SELECT ROUTE_ID FROM SPRS_ROUTE WHERE SPRS_CODE= ?  AND LOCALITY_CODE= ?  ";
			pStmt1 = conn.prepareStatement(routeIdsql);
			pStmt1.setString(1, salesPers);
			pStmt1.setString(2, localityCode);
			rs1 = pStmt1.executeQuery();
			if(rs1.next())
			{
				routeId=checkNull(rs1.getString("ROUTE_ID").trim());
			}
			rs1 = ( rs1!=null )? null : rs1;
			pStmt1 = ( pStmt1!=null )? null : pStmt1;

			String insertDrDoctorVisitSql = "INSERT INTO DR_DOCTOR_VISIT (SALES_PERS , WORK_DATE, SC_CODE , SC_TYPE , REMARK ,LAST_UPDATE , UPDATED_BY , VISITED_WITH_OTHER," +
					"VISITED_WITH_OTHER_NAME,DOCTOR_POB, NOOF_DOCT, CLASS_CODE,NO_VISIT,SPL_CODE,WORK_ROUTE_ID,SALES_PERS_MGR,  WORK_LOCALITY_CODE, WORK_LOCALITY_DESCR ," +
					" WORK_STAN_CODE ,WORK_STAN_DESCR,VISIT_TIME_FR, VISIT_TIME_TO )  " +
					"VALUES (? , ? , ? , ? , ? , ? , ? , ? , ? ,? , ? , ?, ?, ?, ? ,? ,? ,?, ? , ?,? ,?)";
			pstmtInsertDrDoctorVisit = conn.prepareStatement(insertDrDoctorVisitSql);
			pstmtInsertDrDoctorVisit.setString(1, salesPers.trim());
			pstmtInsertDrDoctorVisit.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
			pstmtInsertDrDoctorVisit.setString(3, strgCode.trim());
			pstmtInsertDrDoctorVisit.setString(4, custType.trim());
			pstmtInsertDrDoctorVisit.setString(5, remarks);
			pstmtInsertDrDoctorVisit.setTimestamp(6,java.sql.Timestamp.valueOf(currDate));
			pstmtInsertDrDoctorVisit.setString(7, empcode.trim());
			pstmtInsertDrDoctorVisit.setString(8, "");//VISITED_WITH_OTHER
			pstmtInsertDrDoctorVisit.setString(9, "");//VISITED_WITH_OTHER_NAME
			pstmtInsertDrDoctorVisit.setString(10, "");//DOCTOR_POB
			pstmtInsertDrDoctorVisit.setString(11, "");//NOOF_DOCT
			pstmtInsertDrDoctorVisit.setString(12, "");//CLASS_CODE
			pstmtInsertDrDoctorVisit.setString(13, "");//NO_VISIT
			pstmtInsertDrDoctorVisit.setString(14, "");//SPL_CODE
			pstmtInsertDrDoctorVisit.setString(15, routeId.trim());
			pstmtInsertDrDoctorVisit.setString(16, salesPers.trim());//sales_pers_mgr
			pstmtInsertDrDoctorVisit.setString(17, localityCode.trim());//WORK_LOCALITY_CODE
			pstmtInsertDrDoctorVisit.setString(18, localityDescr);//
			pstmtInsertDrDoctorVisit.setString(19, stanCode.trim());//
			pstmtInsertDrDoctorVisit.setString(20, stanCodeDescr);//
			pstmtInsertDrDoctorVisit.setString(21, visitTimFrm.trim());//
			pstmtInsertDrDoctorVisit.setString(22, visitTimTo.trim());//

			int insertSprsTravelCnt = pstmtInsertDrDoctorVisit.executeUpdate();
			System.out.println("insertSprsTravelCnt =["+insertSprsTravelCnt+"]");
			pstmtInsertDrDoctorVisit.clearParameters();
			if (insertSprsTravelCnt > 0)
			{
				isSuccess = true;
				System.out.println("inserted successfully into insertIntoDrDoctorVisit travel =["+insertSprsTravelCnt+"]");
			}

			String sql = "SELECT COUNT(*) AS COUNT FROM STRG_MEET_ITEMS WHERE TRAN_ID = ? ";

			pstmt3 = conn.prepareStatement( sql );
			pstmt3.setString( 1, tranId);
			rs3 = pstmt3.executeQuery();
			if (rs3.next())
			{
				count = rs3.getInt("COUNT");
			}

			if ( rs3 != null )
			{
				rs3.close();
				rs3 = null;
			}

			if ( pstmt3 != null )
			{
				pstmt3.close();
				pstmt3 = null;
			}
			if( count > 0 )
			{
				isSuccess=insertIntoDrSampleDistributed( conn, salesPers, dcrDate, dom,xtraParams,strgCode );//NEED TO ADD MULTIPLE RECORDS AS PER ADDING ITEMS
			}

			if(pstmtInsertDrDoctorVisit != null)
			{
				pstmtInsertDrDoctorVisit.close(); pstmtInsertDrDoctorVisit = null;
			}
		}
		catch(Exception exp)
		{
			System.out.println("Exception : insertIntoDrDoctorVisit :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		return isSuccess;
	}

	private boolean insertIntoDrUnlistVisit( Connection conn, String salesPers, String dcrDate, String dcrID, String tranId, Document dom,String xtraParams ) throws ITMException
	{
		boolean isSuccess = false;
		int lineNo=0;
		PreparedStatement pstmtInsertDrUnlistVisit=null,pstmt3=null;
		ResultSet rs1=null,rs3=null;
		int count=0;
		String localityCode="",stanCode="",loginCode="",custType="",strgCode="",locality="";
		String clientName="",phoneNo="",address="",emailId="",visitTimFrm="",visitTimTo="",remarks="";
		try
		{
			System.out.println("insertIntoDrUnlistVisit is called...........");
			loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			System.out.println(" loginCode[" + loginCode + "]");
			String empcode=genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			custType=genericUtility.getColumnValue("cust_type",dom);
			InetAddress ownIP=InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			//currDate = genericUtility.getValidDateString(currDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat());
			currDate = genericUtility.getValidDateTimeString(currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			clientName=genericUtility.getColumnValue("strg_name",dom);
			phoneNo=genericUtility.getColumnValue("phone_no",dom);
			address=genericUtility.getColumnValue("address",dom);
			emailId=genericUtility.getColumnValue("email_id",dom);
			visitTimFrm=genericUtility.getColumnValue("event_time_start",dom);
			visitTimTo=genericUtility.getColumnValue("event_time_end",dom);
			remarks=genericUtility.getColumnValue("remarks",dom);
			locality=genericUtility.getColumnValue("unlist_locality",dom);
			strgCode=genericUtility.getColumnValue("sc_code",dom);

			String drUnlistSql ="INSERT INTO DR_UNLIST_VISIT (SALES_PERS,WORK_DATE,CLIENT_NAME, PHONE_NO ,ADDRESS ,EMAIL_ID, CUST_TYPE , VISIT_TIME_FR , VISIT_TIME_TO ,LOCALITY_CODE ,DOCTOR_POB ,REMARK , CLIENT_TYPE,CLIENT_CLASS,CLIENT_CATEGORY, SC_CODE ) " +
					"VALUES (?, ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? ) ";
			pstmtInsertDrUnlistVisit = conn.prepareStatement(drUnlistSql);

			if("U".equalsIgnoreCase(custType))
			{
				custType="L";
			}
			else if("V".equalsIgnoreCase(custType))
			{
				custType="F";
			}
			//strgCode=getUnlistSccode(conn,custType);
			pstmtInsertDrUnlistVisit.setString(1, salesPers.trim());
			pstmtInsertDrUnlistVisit.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
			pstmtInsertDrUnlistVisit.setString(3, clientName.trim());
			pstmtInsertDrUnlistVisit.setString(4, phoneNo.trim());
			pstmtInsertDrUnlistVisit.setString(5, address);
			pstmtInsertDrUnlistVisit.setString(6, emailId);
			pstmtInsertDrUnlistVisit.setString(7, custType.trim());
			pstmtInsertDrUnlistVisit.setString(8, visitTimFrm.trim());
			pstmtInsertDrUnlistVisit.setString(9, visitTimTo.trim());
			pstmtInsertDrUnlistVisit.setString(10, locality.trim());//LOCALITY_CODE
			pstmtInsertDrUnlistVisit.setString(11, "");//DOCTOR_POB
			pstmtInsertDrUnlistVisit.setString(12, remarks);
			pstmtInsertDrUnlistVisit.setString(13, "");//CLIENT_TYPE
			pstmtInsertDrUnlistVisit.setString(14, "");//CLIENT_CLASS
			pstmtInsertDrUnlistVisit.setString(15, "");//CLIENT_CATEGORY
			pstmtInsertDrUnlistVisit.setString(16, strgCode.trim());

			int insertDrUnlistVisitCnt = pstmtInsertDrUnlistVisit.executeUpdate();
			System.out.println("dr unlist visit cnt =["+insertDrUnlistVisitCnt+"]");
			pstmtInsertDrUnlistVisit.clearParameters();
			if (insertDrUnlistVisitCnt > 0)
			{
				isSuccess = true;
				System.out.println("inserted successfully into dr unlist visit =["+insertDrUnlistVisitCnt+"]");
			}
			String updateStrgMeetItemsdSql= "UPDATE STRG_MEET_ITEMS SET STRG_CODE = ? WHERE TRAN_ID= ?";
			pstmt3 = conn.prepareStatement(updateStrgMeetItemsdSql);
			pstmt3.setString(1, strgCode.trim());
			pstmt3.setString(2, tranId.trim());
			int updateStrgMeetItemsSqlCnt= pstmt3.executeUpdate();
			if(updateStrgMeetItemsSqlCnt > 0)
			{
				isSuccess=true;
				System.out.println("updates successfully updateStrgMeetItemsdSql"+updateStrgMeetItemsSqlCnt);
			}
			pstmt3 = ( pstmt3!=null )? null : pstmt3;

			String updateStrgMeetTeamdSql= "UPDATE STRG_MEET_TEAM SET STRG_CODE = ? WHERE TRAN_ID= ? ";
			pstmt3 = conn.prepareStatement(updateStrgMeetTeamdSql);
			pstmt3.setString(1, strgCode.trim());
			pstmt3.setString(2, tranId.trim());
			int updateStrgMeetTeamSqlCnt= pstmt3.executeUpdate();
			if(updateStrgMeetTeamSqlCnt > 0)
			{
				isSuccess=true;
				System.out.println("updates successfully updateStrgMeetTeamSqlCnt"+updateStrgMeetTeamSqlCnt);
			}
			pstmt3 = ( pstmt3!=null )? null : pstmt3;

			String sql = "SELECT COUNT(*) AS COUNT FROM STRG_MEET_ITEMS WHERE TRAN_ID = ? ";

			pstmt3 = conn.prepareStatement( sql );
			pstmt3.setString( 1, tranId);
			rs3 = pstmt3.executeQuery();
			if (rs3.next())
			{
				count = rs3.getInt("COUNT");
			}

			if ( rs3 != null )
			{
				rs3.close();
				rs3 = null;
			}

			if ( pstmt3 != null )
			{
				pstmt3.close();
				pstmt3 = null;
			}
			if( count > 0 )
			{
				isSuccess=insertIntoDrSampleDistributed( conn, salesPers, dcrDate, dom,xtraParams,strgCode );//NEED TO ADD MULTIPLE RECORDS AS PER ADDING ITEMS
			}
			//isSuccess=insertIntoDrSampleDistributed( conn, salesPers, dcrDate, dom,xtraParams,strgCode );//NEED TO ADD MULTIPLE RECORDS AS PER ADDING ITEMS

			if(pstmtInsertDrUnlistVisit != null)
			{
				pstmtInsertDrUnlistVisit.close(); pstmtInsertDrUnlistVisit = null;
			}
		}
		catch(Exception exp)
		{
			System.out.println("Exception : insertIntoSprsTravel :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		return isSuccess;
	}

	private boolean insertIntoDrMain( Connection conn, String salesPers, String dcrDate, String dcrID, String tranId, Document dom,String xtraParams ) throws ITMException
	{
		boolean isSuccess = false;
		int lineNo=0;
		PreparedStatement pstmtInsertDrMain=null;
		PreparedStatement pStmt1=null;
		ResultSet rs1=null;
		String localitySql="",localityCode="",stanCode="",strgCode="",loginCode="",custType="",remarks="",visitTimFrm="",visitTimTo="",localityDescr="";
		String routeIdsql="",routeId="",stanCodeDescr="",stanCodeDescrSql="",routeDescr="",locality="";
		String salesPerns="",salesS="";
		try
		{
			System.out.println("insertIntoDrMain is called...........");
			strgCode=genericUtility.getColumnValue("strg_code",dom);
			custType=genericUtility.getColumnValue("cust_type",dom);
			remarks=genericUtility.getColumnValue("remarks",dom);
			visitTimFrm=genericUtility.getColumnValue("event_time_start",dom);
			visitTimTo=genericUtility.getColumnValue("event_time_end",dom);
			locality=genericUtility.getColumnValue("locality",dom);
			loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			System.out.println(" loginCode[" + loginCode + "]");
			String empcode=genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			InetAddress ownIP=InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			//currDate = genericUtility.getValidDateString(currDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat());
			currDate = genericUtility.getValidDateTimeString(currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			if ("F".equalsIgnoreCase(custType.trim()) || "L".equalsIgnoreCase(custType.trim()) )
			{
				localitySql ="SELECT LOCALITY_CODE,STAN_CODE,DESCR FROM LOCALITY WHERE LOCALITY_CODE = (SELECT LOCALITY_CODE FROM STRG_CUSTOMER WHERE SC_CODE =  ? ) ";
				pStmt1 = conn.prepareStatement(localitySql);
				pStmt1.setString(1, strgCode);
			}
			else
			{
				localitySql ="SELECT LOCALITY_CODE,STAN_CODE,DESCR FROM LOCALITY WHERE LOCALITY_CODE = ? ";
				pStmt1 = conn.prepareStatement(localitySql);
				pStmt1.setString(1, locality);
			}
			rs1 = pStmt1.executeQuery();
			if(rs1.next())
			{
				localityCode=checkNull(rs1.getString("LOCALITY_CODE").trim());
				stanCode=checkNull(rs1.getString("STAN_CODE").trim());
				localityDescr=checkNull(rs1.getString("DESCR").trim());
			}
			rs1 = ( rs1!=null )? null : rs1;
			pStmt1 = ( pStmt1!=null )? null : pStmt1;

			stanCodeDescrSql ="SELECT DESCR FROM STATION WHERE STAN_CODE = ? ";
			pStmt1 = conn.prepareStatement(stanCodeDescrSql);
			pStmt1.setString(1, stanCode);
			rs1 = pStmt1.executeQuery();
			if(rs1.next())
			{
				stanCodeDescr=checkNull(rs1.getString("DESCR").trim());
			}
			rs1 = ( rs1!=null )? null : rs1;
			pStmt1 = ( pStmt1!=null )? null : pStmt1;

			routeIdsql ="SELECT ROUTE_ID ,DESCR FROM SPRS_ROUTE WHERE SPRS_CODE= ?  AND LOCALITY_CODE= ?  ";
			pStmt1 = conn.prepareStatement(routeIdsql);
			pStmt1.setString(1, salesPers);
			pStmt1.setString(2, localityCode);
			rs1 = pStmt1.executeQuery();
			if(rs1.next())
			{
				routeId=checkNull(rs1.getString("ROUTE_ID").trim());
				routeDescr=checkNull(rs1.getString("DESCR").trim());
			}
			rs1 = ( rs1!=null )? null : rs1;
			pStmt1 = ( pStmt1!=null )? null : pStmt1;

			String salePernsSql="SELECT SALES_PERS FROM STRG_MEET_TEAM WHERE TRAN_ID = ?";
			pStmt1 = conn.prepareStatement(salePernsSql);
			pStmt1.setString(1, tranId);
			rs1 = pStmt1.executeQuery();
			while(rs1.next())
			{
				salesPerns = checkNull(rs1.getString("SALES_PERS").trim());
				System.out.println("salesPerns>>::"+salesPerns);
				salesS = salesS + salesPerns +",";
				System.out.println("salesS>>::"+salesS);
			}
			System.out.println("salesSsalesS>>::"+salesS);
			if( salesS != null && salesS.trim().length() > 0 && salesS.indexOf(",") != -1 )
			{
				salesPerns = salesS.substring(0,salesS.lastIndexOf(","));
				salesPerns = salesPerns.trim();
				System.out.println("salesPernssalesPerns>>::"+salesPerns);
			}
			rs1 = ( rs1!=null )? null : rs1;
			pStmt1 = ( pStmt1!=null )? null : pStmt1;

			String insertDrMainSql = "INSERT INTO DR_MAIN ( SALES_PERS , WORK_DATE , SUBMISSION_DATE , REMARK , PROD_COMPLAINT , COMPLETION_FLAG , LAST_UPDATE , UPDATED_BY , " +
					"CONFIRMATION_FLAG , GENERAL_REMARK , CHG_DATE ,CHG_USER ,CHG_TERM ,MODE_REPO , ACTIVITY_CODE , ROUTE_ID__START , DESIGNATION , ROUTE_DESCR__START ,REPORT_TO , STAN_CODE__START ," +
					" ITEM_SER,STAN_CODE__HQ , GRADE , WORK_WITH_MGR , SALES_PERS_MGR , SALES_PERS_MGR_FLG )  " +
					" VALUES( ? ,? ,? ,? ,? ,? ,? ,? , ?, ?, ?, ?, ?, ? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? , ?,?)";

			pstmtInsertDrMain = conn.prepareStatement(insertDrMainSql);

			lineNo++;
			pstmtInsertDrMain.setString(1, salesPers.trim());
			pstmtInsertDrMain.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
			pstmtInsertDrMain.setTimestamp(3, java.sql.Timestamp.valueOf(currDate));
			pstmtInsertDrMain.setString(4, "");//REMARK
			pstmtInsertDrMain.setString(5,"");//PROD_COMPLAINT
			pstmtInsertDrMain.setString(6, "");//COMPLETION_FLAG
			pstmtInsertDrMain.setTimestamp(7, java.sql.Timestamp.valueOf(currDate));
			pstmtInsertDrMain.setString(8, empcode.trim());//UPDATED_BY
			pstmtInsertDrMain.setString(9, "");//CONFIRMATION_FLAG
			pstmtInsertDrMain.setString(10, "");//GENERAL_REMARK
			pstmtInsertDrMain.setTimestamp(11, java.sql.Timestamp.valueOf(currDate));//CHG_DATE
			pstmtInsertDrMain.setString(12, empcode.trim());//CHG_USER
			pstmtInsertDrMain.setString(13, chgTerm);//chgTerm
			pstmtInsertDrMain.setString(14, "");//MODE_REPO
			pstmtInsertDrMain.setString(15, "FW");//ACTIVITY_CODE
			pstmtInsertDrMain.setString(16, routeId.trim());//ROUTE_ID__START
			pstmtInsertDrMain.setString(17, "");//DESIGNATION
			pstmtInsertDrMain.setString(18, routeDescr.trim());//ROUTE_DESCR__START
			pstmtInsertDrMain.setString(19, "");//REPORT_TO
			pstmtInsertDrMain.setString(20, stanCode.trim());//STAN_CODE__STAR
			pstmtInsertDrMain.setString(21, "");//ITEM_SER
			pstmtInsertDrMain.setString(22, "");//STAN_CODE__HQ
			pstmtInsertDrMain.setString(23, "");//GRADE
			pstmtInsertDrMain.setString(24, salesPerns);//WORK_WITH_MGR
			pstmtInsertDrMain.setString(25, "");//SALES_PERS_MGR
			pstmtInsertDrMain.setString(26, "");//SALES_PERS_MGR_FLG

			int insertDrTravelCnt = pstmtInsertDrMain.executeUpdate();
			System.out.println("insertIntoDrMaincnt =["+insertDrTravelCnt+"]");
			pstmtInsertDrMain.clearParameters();
			if (insertDrTravelCnt > 0)
			{
				isSuccess = true;
				System.out.println("inserted successfully into insertIntoDrMain travel =["+insertDrTravelCnt+"]");
			}
			if(pstmtInsertDrMain != null)
			{
				pstmtInsertDrMain.close(); pstmtInsertDrMain = null;
			}
		}
		catch(Exception exp)
		{
			System.out.println("Exception : insertIntoDrMain ::==>\n");
			throw new ITMException(exp);
		}
		return isSuccess;
	}

	private String getUnlistSccode(Connection conn, String scType)throws ITMException
	{
		String unlistScCode ="";
		PreparedStatement pstmtNextSeq = null;
		ResultSet rsNextSeq = null;
		try
		{
			String nextSeq = "";
			String tempScCode = "0000000000";
			String getNextSeqSql = "SELECT dr_unlist_client_seq.NEXTVAL AS NEXT_SEQ FROM DUAL";
			pstmtNextSeq = conn.prepareStatement(getNextSeqSql);
			rsNextSeq = pstmtNextSeq.executeQuery();
			if(rsNextSeq.next())
			{
				nextSeq = rsNextSeq.getString("NEXT_SEQ");
			}
			tempScCode = tempScCode + nextSeq;
			unlistScCode = scType + tempScCode.substring(tempScCode.length()-9);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsNextSeq != null)
				{
					rsNextSeq.close();
					rsNextSeq = null;
				}
				if (pstmtNextSeq != null)
				{
					pstmtNextSeq.close();
					pstmtNextSeq = null;
				}
			}
			catch(Exception e)
			{

			}
		}
		return unlistScCode;
	}

	private String getObjNameFromDom(Document dom, String attribute) throws RemoteException, ITMException
	{
		NodeList detailList = null;
		Node currDetail = null, reqDetail = null;
		String objName = "";
		int detailListLength = 0;

		detailList = dom.getElementsByTagName("Detail1");
		detailListLength = detailList.getLength();
		for (int ctr = 0; ctr < detailListLength; ctr++)
		{
			currDetail = detailList.item(ctr);
			objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();

		}
		return objName;
	}

	private String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}

	/*	private String insertIntoDrUnlistVisit( String workDate, String sprsCode, String strgType, Connection conn )throws ITMException
	{
		String count = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			String insertSql = " INSERT INTO DR_UNLIST_VISIT(SALES_PERS , WORK_DATE , CLIENT_NAME , PHONE_NO , ADDRESS , EMAIL_ID , CUST_TYPE , VISIT_TIME_FR , VISIT_TIME_TO , DOCTOR_POB , SC_CODE ) " +
							   " VALUES (?,?,?,?,?, ?,?,?,?,?, ?)";
			PreparedStatement pstmtIns = conn.prepareStatement( insertSql );
			pstmtIns.setString(1, sprsCode);
			pstmtIns.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmtIns.setString(3, "-NA-");
			pstmtIns.setString(4, "-NA-");
			pstmtIns.setString(5, "-NA-");
			pstmtIns.setString(6, "-NA-");
			pstmtIns.setString(7, strgType);
			pstmtIns.setString(8, "-NA-");
			pstmtIns.setString(9, "-NA-");
			pstmtIns.setString(10, "0");
			pstmtIns.setString(11, "NOTMET");

			int insCount = pstmtIns.executeUpdate();
			if (pstmtIns != null)
			{
				pstmtIns.close();
				pstmtIns = null;
			}
			System.out.println("insCount into dr_unlist_visit = ["+insCount+"]");

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{


			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return count;
	}
	 */
	private String getDCRId(Connection conn, String salesPers, String dcrDate) throws Exception
	{
		String dcrID = "";
		PreparedStatement pstmtDCRID = null;
		ResultSet rsDCRID = null;
		try
		{
			dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			String dcrSql = "SELECT DCR_ID FROM SPRS_ACT_TRAN A, FIELDACTIVITY B WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.EVENT_DATE = ? AND A.SALES_PERS = ? AND B.ACTIVITY_TYPE <>'PR'" ;

			pstmtDCRID = conn.prepareStatement( dcrSql );
			pstmtDCRID.setTimestamp(1, java.sql.Timestamp.valueOf(dcrDate));
			pstmtDCRID.setString(2, salesPers);
			rsDCRID = pstmtDCRID.executeQuery();
			if( rsDCRID.next() )
			{
				dcrID = (rsDCRID.getString("DCR_ID") == null )?"":rsDCRID.getString("DCR_ID");
			}
			if (rsDCRID != null)
			{
				rsDCRID.close();
				rsDCRID = null;
			}
			if(pstmtDCRID !=null)
			{
				pstmtDCRID.close();
				pstmtDCRID = null;
			}

		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsDCRID != null)
				{
					rsDCRID.close();
					rsDCRID = null;
				}
				if(pstmtDCRID !=null)
				{
					pstmtDCRID.close();
					pstmtDCRID = null;
				}
			}
			catch(Exception e1){}
		}
		System.out.println("dcrID =["+dcrID+"]");
		return dcrID;
	}

	private boolean updateSprsActTran( Connection conn, String salesPers, String dcrDate, String dcrID, String tranId ) throws ITMException
	{
		boolean isSuccess = false;
		PreparedStatement pstmtUpdSprsActTran=null;
		ResultSet rs=null;
		try
		{

			dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			System.out.println("updateSprsActTran is called...........");
			String updateStrgMeetSql ="UPDATE SPRS_ACT_TRAN SET DCR_ID = ? ,ACTIVITY_CODE = ?, TRAN_ID = ? WHERE EVENT_DATE = ? AND SALES_PERS = ? ";
			pstmtUpdSprsActTran = conn.prepareStatement(updateStrgMeetSql);
			pstmtUpdSprsActTran.setString(1, dcrID);
			pstmtUpdSprsActTran.setString(2, "FW");
			pstmtUpdSprsActTran.setString(3, tranId);
			pstmtUpdSprsActTran.setTimestamp(4, java.sql.Timestamp.valueOf(dcrDate));
			pstmtUpdSprsActTran.setString(5, salesPers);
			int Cnt= pstmtUpdSprsActTran.executeUpdate();
			if(Cnt > 0)
			{
				System.out.println("updates successfully SPRS_ACT_TRAN :: ["+Cnt+"]");
			}
			if(pstmtUpdSprsActTran != null)
			{
				pstmtUpdSprsActTran.close();
				pstmtUpdSprsActTran = null;
			}
		}
		catch(Exception exp)
		{
			System.out.println("Exception : updateSprsActTran ::==>\n");
			throw new ITMException(exp);
		}
		return isSuccess;
	}

	private boolean updateStrgBrandPitch( Connection conn, String dcrID, String tranId ) throws ITMException
	{
		boolean isSuccess = false;
		PreparedStatement pstmt3=null;
		ResultSet rs=null;
		try
		{
			System.out.println("STRG_BRAND_PITCH is called...........");
			String updateStrgBrandPitchSql ="UPDATE STRG_BRAND_PITCH SET DCR_ID = ?  WHERE TRAN_ID = ?  ";
			pstmt3 = conn.prepareStatement(updateStrgBrandPitchSql);
			pstmt3.setString(1, dcrID);
			pstmt3.setString(2, tranId);
			int cntStrgBrandPitchCnt= pstmt3.executeUpdate();
			if(cntStrgBrandPitchCnt > 0)
			{
				System.out.println("updates successfully cntStrgBrandPitchCnt"+cntStrgBrandPitchCnt);
			}
			pstmt3 = ( pstmt3!=null )? null : pstmt3;
		}
		catch(Exception exp)
		{
			System.out.println("Exception : STRG_BRAND_PITCH ::==>\n");
			throw new ITMException(exp);
		}
		return isSuccess;
	}

	private boolean updateStrgMeetItems( Connection conn, String dcrID, String tranId ) throws ITMException
	{
		boolean isSuccess = false;
		PreparedStatement pstmt3=null;
		ResultSet rs=null;
		try
		{
			System.out.println("updateStrgMeetItems is called...........");
			String updateStrgMeetItemsSql ="UPDATE STRG_MEET_ITEMS SET DCR_ID = ?   WHERE TRAN_ID = ? ";
			pstmt3 = conn.prepareStatement(updateStrgMeetItemsSql);
			pstmt3.setString(1, dcrID);
			pstmt3.setString(2, tranId);
			int cntStrgMeetItemsCnt= pstmt3.executeUpdate();
			if(cntStrgMeetItemsCnt > 0)
			{
				System.out.println("updates successfully items"+cntStrgMeetItemsCnt);
			}
			pstmt3 = ( pstmt3!=null )? null : pstmt3;
		}
		catch(Exception exp)
		{
			System.out.println("Exception : updateStrgMeetItems ::==>\n");
			throw new ITMException(exp);
		}
		return isSuccess;
	}

	private boolean updateStrgMeetTeams( Connection conn, String dcrID, String tranId ) throws ITMException
	{
		boolean isSuccess = false;
		PreparedStatement pstmt3=null;
		ResultSet rs=null;
		try
		{
			System.out.println("updateStrgMeetTeams is called...........");
			String updateStrgMeetteamSql ="UPDATE STRG_MEET_TEAM SET DCR_ID = ?   WHERE TRAN_ID = ? ";
			pstmt3 = conn.prepareStatement(updateStrgMeetteamSql);
			pstmt3.setString(1, dcrID);
			pstmt3.setString(2, tranId);
			int cntStrgMeetteamCnt= pstmt3.executeUpdate();
			if(cntStrgMeetteamCnt > 0)
			{
				System.out.println("updates successfully teams"+cntStrgMeetteamCnt);
			}
			pstmt3 = ( pstmt3!=null )? null : pstmt3;
		}
		catch(Exception exp)
		{
			System.out.println("Exception : updateStrgMeetTeams ::==>\n");
			throw new ITMException(exp);
		}
		return isSuccess;
	}

	private boolean updateStrgMeet( Connection conn, String dcrID, String tranId ) throws ITMException
	{
		boolean isSuccess = false;
		PreparedStatement pstmt3=null;
		ResultSet rs=null;
		try
		{
			System.out.println("updateStrgMeetTeams is called...........");
			String updateStrgMeetSql ="UPDATE STRG_MEET SET DCR_ID = ? ,EVENT_TYPE = ? WHERE TRAN_ID = ? ";
			pstmt3 = conn.prepareStatement(updateStrgMeetSql);
			pstmt3.setString(1, dcrID);
			pstmt3.setString(2, "FW");
			pstmt3.setString(3, tranId);
			int cntStrgMeetCnt= pstmt3.executeUpdate();
			if(cntStrgMeetCnt > 0)
			{
				System.out.println("updates successfully doctor"+cntStrgMeetCnt);
			}
			pstmt3 = ( pstmt3!=null )? null : pstmt3;
		}
		catch(Exception exp)
		{
			System.out.println("Exception : updateStrgMeetTeams ::==>\n");
			throw new ITMException(exp);
		}
		return isSuccess;
	}

	//added by rupali on 15/09/17 for worked with field [start]
	private String createSalesPersonTeam( String xmlStringAll, String tranID, String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{

		System.out.println("createSalesPersonTeam is Called:::");

		Document dom=null;
		PreparedStatement pstmtStrgMeet = null;
		PreparedStatement pstmtInsertStrgMeetTeam = null;
		PreparedStatement pstmtSelectStrgMeetTeam = null;
		PreparedStatement pstmtSelect = null;

		ResultSet rsStrgMeet = null;
		ResultSet rsStrgMeetTeam = null;
		ResultSet rsStmt=null;

		String strgCode = "";
		String retString="";
		String roleCode="";
		RealTimeReportEJB realTimeReportEJB=new RealTimeReportEJB();
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		ArrayList strgCodeList = new ArrayList();
		try
		{
			if( xmlStringAll != null && xmlStringAll.trim().length() > 0 )
			{
				dom = genericUtility.parseString(xmlStringAll);
			}

			String objName = getObjNameFromDom( dom, "objName" , 1);
			String winName = "w_"+objName;

			String deSelecTeamListStr = "";

			HashMap deSelectTeamMap = new HashMap();
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			String siteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
			userId = realTimeReportEJB.getEmpCode(userId, conn);
			String objFormSql= "SELECT FORM_NAME, FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= ? AND FORM_NAME IN('team') ";
			PreparedStatement pstmtForm = conn.prepareStatement(objFormSql);
			pstmtForm.setString(1, winName);
			ResultSet rsForm = pstmtForm.executeQuery();
			while(rsForm.next())
			{
				String formName = checkNull(rsForm.getString("FORM_NAME"));
				String formNo = checkNull(rsForm.getString("FORM_NO"));

				NodeList parentNodeList = dom.getElementsByTagName("Detail"+formNo);
				int nodeListLen = parentNodeList.getLength();
				for(int i = 0; i<nodeListLen; i++)
				{
					String updateFlag = "";
					Node parentNode = parentNodeList.item(i);
					String scCode = checkNull(genericUtility.getColumnValueFromNode("strg_code", parentNode));
					String salesPersTeam = checkNull(genericUtility.getColumnValueFromNode("sales_pers", parentNode));

					System.out.println("scCode =["+scCode+"], salesPersTeam=["+salesPersTeam+"]");

					NodeList childNodeList = parentNode.getChildNodes();
					int childListLen = childNodeList.getLength();
					for(int j = 0; j<childListLen; j++)
					{
						Node childNode = childNodeList.item(j);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}

						String nodeName = childNode.getNodeName();
						if("attribute".equalsIgnoreCase(nodeName) && childNode.getAttributes().getNamedItem("updateFlag") != null)
						{

							updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							System.out.println("updateFlag =["+updateFlag+"]");

							if("D".equalsIgnoreCase(updateFlag))
							{
								if(deSelectTeamMap.containsKey(scCode))
								{
									String team = (String)deSelectTeamMap.get(scCode);

									deSelectTeamMap.put(scCode, (team+":"+salesPersTeam));
								}
								else
								{
									deSelectTeamMap.put(scCode, salesPersTeam);
								}
								deSelecTeamListStr = deSelecTeamListStr+","+salesPersTeam;
							}
						}
					}
				}
			}
			if(rsForm != null)
			{
				rsForm.close();
				rsForm = null;
			}
			if(pstmtForm != null)
			{
				pstmtForm.close();
				pstmtForm = null;
			}
			System.out.println("deSelectTeamMap ::"+deSelectTeamMap);

			if(deSelecTeamListStr != null && deSelecTeamListStr.indexOf(",") != -1)
			{
				deSelecTeamListStr = "'"+deSelecTeamListStr.replaceAll(",", "','")+"'";
			}
			System.out.println("deSelecTeamListStr ::"+deSelecTeamListStr);

			//Getting the team member selected in the activity screen : form No -1
			//String teamMembers = checkNull(genericUtility.getColumnValue( "visited_with", dom, "1" ));// //changed by kailash on:22-03-17 :start
			//String teamMembers = checkNull(genericUtility.getColumnValue( "visited_with_code", dom, "1" ));// //changed by kailash on:22-03-17 :start
			String teamMembers = checkNull(genericUtility.getColumnValue( "visited_with", dom, "1" ));// Asses by Hariom for scaminput data insert -23-July-2021

			System.out.println("teamMembers =["+teamMembers+"]");
			int count=0;
			String sql="select count(*) as count from strg_meet_team where tran_id=? " ;
			pstmtSelect =  conn.prepareStatement(sql);
			pstmtSelect.setString(1,tranID);
			rsStmt = pstmtSelect.executeQuery();
			if(rsStmt.next())
			{
				count=rsStmt.getInt("count");
				System.out.println("count["+count+"]");

			}
			rsStmt.close(); rsStmt = null;
			pstmtSelect.close(); pstmtSelect = null;
			String mgrCode = realTimeReportEJB.getMGREmployee(userId, conn);
			//if any team member is selected
			if ( teamMembers.length() > 0)
			{
				String dcrID = "";
				//Delete those record from strg_meet_team whose strg_code ='0000000000'
				String deleteStrgMeetTeamSql = "DELETE FROM STRG_MEET_TEAM WHERE STRG_CODE = '0000000000' AND TRAN_ID = ? ";
				PreparedStatement pstmtDeleteStrgMeetTeam =  conn.prepareStatement(deleteStrgMeetTeamSql);
				pstmtDeleteStrgMeetTeam.setString(1,tranID);
				int deleteCnt = pstmtDeleteStrgMeetTeam.executeUpdate();
				if( deleteCnt > 0 )
				{
					System.out.println("Deleted sucessfully from strg_meet_team =["+deleteCnt+"]");
				}
				pstmtDeleteStrgMeetTeam.close(); pstmtDeleteStrgMeetTeam = null;

				//Getting the doctor code which is not in the strg_meet_team
				String selectStrgMeetsql = "select strg_code,dcr_id from strg_meet where strg_code not in(select distinct strg_code from strg_meet_team where tran_id= ?) and tran_id = ?";

				pstmtStrgMeet =  conn.prepareStatement(selectStrgMeetsql);
				pstmtStrgMeet.setString(1,tranID);
				pstmtStrgMeet.setString(2,tranID);
				rsStrgMeet = pstmtStrgMeet.executeQuery();
				while(rsStrgMeet.next())
				{
					strgCode = checkNull(rsStrgMeet.getString("strg_code")).trim();
					dcrID = checkNull(rsStrgMeet.getString("dcr_id")).trim();
					if (strgCode.trim().length() > 0 )
					{
						strgCodeList.add(strgCode);
					}
				}
				rsStrgMeet.close(); rsStrgMeet = null;
				pstmtStrgMeet.close(); pstmtStrgMeet = null;
				System.out.println("strgCodeList ="+strgCodeList);

				strgCode = "";
				//End

				//formating the team members
				//Added by Pooja S on [9-JAN-2020] - if visited_with without (emp_code) then pass code  start
				String[] temp = teamMembers.split( "," );
				ArrayList<String> defaultTeamList = new ArrayList<String>();
				System.out.println("temp.length >==="+temp.length );
				System.out.println("temp.length >==="+teamMembers );
				System.out.println("!\"SELF\".equalsIgnoreCase(teamMembers) >==="+!"SELF".equalsIgnoreCase(teamMembers) );

				if( teamMembers.indexOf('(') != -1)
				{
					
					 defaultTeamList = getTeamList(teamMembers);
				}
				//Added By Nilesh if manager select the pophelp data in thar case self is seleced so in this case visited_with_code will set Start :: 16-04-2021
				else if ( mgrCode.trim().length() != 0 )
				{
					String teamMembersCode = checkNull(genericUtility.getColumnValue( "visited_with_code", dom, "1" ));
					defaultTeamList.add(teamMembersCode);
				}//Added By Nilesh if manager select the pophelp data in thar case self is seleced so in this case visited_with_code will set End :: 16-04-2021
			
				else if ( temp.length > 0 &&  mgrCode.trim().length()== 0 ) //Added By Nilesh for in case of SO scan input field then not get the ( ) it will get 5579 empcode Start 
				{
					for ( int i = 0; i < temp.length; i++ )
					{
						String visitTeam = temp[i];

						if( visitTeam.indexOf("(") == -1 && visitTeam.indexOf(")") == -1 )
						{
							defaultTeamList.add(visitTeam);
						}
						
					}
				}//Added By Nilesh for in case of SO scan input field then not get the ( ) it will get 5579 empcode End 
				else
				{
					String teamMembersCode = checkNull(genericUtility.getColumnValue( "visited_with_code", dom, "1" ));
					defaultTeamList.add(teamMembersCode);
				}
				//Added by Pooja S on [9-JAN-2020] - if visited_with without (emp_code) then pass code  End
				//System.out.println("defaultTeamList ="+defaultTeamList);

				String insertStrgMeetTeamSql = "insert into strg_meet_team(tran_id,line_no,role_code,sales_pers,dcr_id,design_code,strg_code) values(?,?,?,?,?,?,?)";
				pstmtInsertStrgMeetTeam = conn.prepareStatement(insertStrgMeetTeamSql);

				System.out.println("strgCodeList.size() =["+strgCodeList.size()+"]");
				//Inserting for each selected doctors in doctor selection screen
				if(strgCodeList.size() > 0)
				{
					for ( int ctr = 0; ctr < strgCodeList.size(); ctr++ )
					{
						String scCode = (String)strgCodeList.get(ctr);

						String teamListStr = "";
						ArrayList deSelectTeamList = null;

						if(deSelectTeamMap != null && deSelectTeamMap.containsKey(scCode))
						{
							teamListStr = (String)deSelectTeamMap.get(scCode);
							deSelectTeamList = new ArrayList<String>(Arrays.asList(teamListStr.split(":")));
						}
						System.out.println("deSelectTeamList ::"+deSelectTeamList);
						//Inserting for each selected team members in activity screen
						for (int i = 0; i < defaultTeamList.size(); i++ )
						{
							String reportTo = (String)defaultTeamList.get(i);
							System.out.println("reportTo======"+reportTo);
							if(deSelectTeamList != null && !deSelectTeamList.isEmpty() && deSelectTeamList.size() > 0 && deSelectTeamList.contains(reportTo))
							{
								continue;
							}
							pstmtInsertStrgMeetTeam.setString(1,tranID);
							pstmtInsertStrgMeetTeam.setInt(2, 0);
							pstmtInsertStrgMeetTeam.setString(3, roleCode);
							pstmtInsertStrgMeetTeam.setString(4, reportTo);
							pstmtInsertStrgMeetTeam.setString(5, dcrID);
							pstmtInsertStrgMeetTeam.setString(6, getEmployeeDesignation(reportTo, conn));//Employee Designation
							pstmtInsertStrgMeetTeam.setString(7, (String)strgCodeList.get(ctr));//Strg Code
							int insertCnt = pstmtInsertStrgMeetTeam.executeUpdate();
							pstmtInsertStrgMeetTeam.clearParameters();
							if( insertCnt > 0 )
							{
								System.out.println("Inserted sucessfully into strg_meet_team =["+insertCnt+"]");
							}
						}

					}//for loop
				}//if(strgCodeList.size() > 0)
			}//if ( teamMembers.length() > 0 )
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsStrgMeet !=null )
				{
					rsStrgMeet.close();
					rsStrgMeet = null;
				}
				if(pstmtStrgMeet != null)
				{
					pstmtStrgMeet.close();
					pstmtStrgMeet = null;
				}
				if(pstmtInsertStrgMeetTeam != null)
				{
					pstmtInsertStrgMeetTeam.close();
					pstmtInsertStrgMeetTeam = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return retString;
	}

	public String getObjNameFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	{
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
				break;

			}
			if(objName == null || objName.trim().length() == 0)
			{
				NodeList objNameList = dom.getElementsByTagName("objName");
				if(objNameList != null && objNameList.getLength() > 0)
				{
					Node objNameNode = objNameList.item(0);
					if(objNameNode != null && objNameNode.getFirstChild() != null)
					{
						objName = checkNull(objNameNode.getFirstChild().getNodeValue());
					}
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		return objName;
	}

	private ArrayList<String> getTeamList(String workWith) throws  ITMException
	{
		ArrayList<String> teamList = new ArrayList<String>();
		try
		{
			if ( workWith != null && workWith.trim().length() > 0 )
			{
				if(workWith.lastIndexOf(",")==-1)
				{
					workWith=workWith+",";
				}
				String searchIndex = ",";
				if ( workWith.indexOf("<BR/>") > 0 )
				{
					searchIndex = "<BR/>";
				}
				else if ( workWith.indexOf(",") > 0 )
				{
					searchIndex = ",";
				}
				System.out.println("searchIndex =["+searchIndex+"]");
				if ( workWith.indexOf(searchIndex) > 0 )
				{
					String workWitthTeam [] = workWith.split(searchIndex);
					if ( workWitthTeam != null && workWitthTeam.length > 0 )
					{
						String teamMember = "";

						for ( int i=0; i<workWitthTeam.length; i++)
						{
							teamMember = workWitthTeam[i];
							System.out.println("teamMember =["+teamMember+"]");
							int leftIndex = teamMember.indexOf("(");
							int rightIndex = teamMember.indexOf(")");
							String newStr = "";
							if (leftIndex >= 0 && rightIndex >= 0 )
							{
								newStr = teamMember.substring(leftIndex+1,teamMember.lastIndexOf(")"));
								System.out.println("leftIndex_rightIndex =["+newStr+"]");
							}
							else if (leftIndex >= 0 )
							{
								newStr = teamMember.substring(leftIndex+1);
								System.out.println("newStr_leftIndex =["+newStr+"]");
							}
							else if (rightIndex >= 0 )
							{
								newStr = teamMember.substring(0,rightIndex);
								System.out.println("newStr_rightIndex =["+newStr+"]");
							}
							teamList.add(newStr.trim());
						}

					}
				}
				else
				{
					teamList.add(workWith);
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("Team List ::"+teamList);
		return teamList;
	}

	private String getEmployeeDesignation( String emplCode, Connection conn ) throws ITMException
	{
		String designationCode = "";
		ResultSet rsDesign = null;
		PreparedStatement pstmtDesign = null;
		try
		{
			String getDesignationSql = "SELECT DESIGN_CODE FROM EMPLOYEE WHERE EMP_CODE = ?";
			pstmtDesign =  conn.prepareStatement( getDesignationSql );
			pstmtDesign.setString(1, emplCode);
			rsDesign = pstmtDesign.executeQuery();
			if ( rsDesign.next() )
			{
				designationCode = rsDesign.getString("DESIGN_CODE") != null ?rsDesign.getString("DESIGN_CODE").trim() :"";
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsDesign !=null )
				{
					rsDesign.close();
					rsDesign = null;
				}
				if(pstmtDesign != null)
				{
					pstmtDesign.close();
					pstmtDesign = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return designationCode;
	}
	//added by rupali on 15/09/17 for worked with field [end]

	// added by rupali on 09/01/18 for applying validation if brand is not selected [start]
	private String getModifiedErrorString(String errString, String modifiedString)
	{
		String xmlStr1 = "";
		String xmlStr2 = "";
		String xmlStr3 = "";
		try
		{
			if(errString.indexOf("<description>") != -1)
			{
				xmlStr1 = errString.substring(0,errString.indexOf("<description>"));
				xmlStr2 = errString.substring(errString.indexOf("</description>")+"</description>".length());
				xmlStr3 = errString.substring(errString.indexOf("<description>")+"<description>".length(),errString.indexOf("</description>"));
				modifiedString = modifiedString + " " +xmlStr3;
				modifiedString = "<description>" + modifiedString + "</description>";
				errString = xmlStr1 + modifiedString + xmlStr2;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		//System.out.println("getModifiedErrorString >> errString ::"+errString);
		return errString;
	}
	// added by rupali on 09/01/18 for applying validation if brand is not selected [end]

	// added by mrunalini sinkar on 10/02/18 for inserting event_time in strg_meet table(start)
	public String geteventTime()
	{
		Date date = new Date();
		String strDateFormat = "hh:mm a";
		DateFormat dateFormat = new SimpleDateFormat(strDateFormat);
		String formattedDate= dateFormat.format(date);
		System.out.println("Current time of the day using Date - 12 hour format: " + formattedDate);
		return formattedDate;
	}
	// added by mrunalini sinkar on 10/02/18 for inserting event_time in strg_meet table(end)

	// added by rupali on 12/09/18 for adding survey subform in DAR [start]
	private void updateStrgSurveyRes( Document dom, String dcrId,String scCode, Connection conn,String salesPers ) throws Exception
	{
		int updCnt = 0;
		PreparedStatement pstmt = null;
		String formNo = "";
		String updateFlag = "";
		try
		{
			//Changed by Prasad on 21/11/20 [to update SURV_STATUS while saving the survey details]
			//String updSurveySql = " UPDATE STRG_SURV_RES SET RESULT = ? WHERE DCR_ID = ? AND STRG_CODE = ? AND SURVEY_CODE = ? ";
			//commented by prachi on 200622 [W22CJOH003]
			String updSurveySql = " UPDATE STRG_SURV_RES SET RESULT = ?, SURV_STATUS = 'Y' WHERE DCR_ID = ? AND STRG_CODE = ? AND SURVEY_CODE = ? ";
			//comment reverted by prachi on 200622 [W22CJOH003]
			//String updSurveySql = " UPDATE STRG_SURV_RES SET RESULT = ? WHERE DCR_ID = ? AND STRG_CODE = ? AND SURVEY_CODE = ? ";
			pstmt = conn.prepareStatement( updSurveySql );

			String objName = getObjNameFromDom( dom, "objName" , 1);
			String winName = "w_"+objName;

			String objFormSql= "SELECT FORM_NAME, FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= ? AND FORM_NAME IN('survey') ";
			PreparedStatement pstmtForm = conn.prepareStatement(objFormSql);
			pstmtForm.setString(1, winName);
			ResultSet rsForm = pstmtForm.executeQuery();
			while(rsForm.next())
			{
				formNo = checkNull(rsForm.getString("FORM_NO"));
			}
			if(rsForm != null)
			{
				rsForm.close();
				rsForm = null;
			}
			if(pstmtForm != null)
			{
				pstmtForm.close();
				pstmtForm = null;
			}
			//Getting the survey detail list and update the result value :START
			Node currDetail = null;
			NodeList detail8List = null;
			NodeList currDetailList = null;
			detail8List = dom.getElementsByTagName("Detail"+formNo);
			int detailListLength = detail8List.getLength();

			boolean isSurveyStatUpdated = false;
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				String surveyCode = "";
				String resultType = "";
				String result1 = "";
				String result2 = "";
				String result3 = "";
				String result4 = "";		//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
				String result5 = "";
				String strgCode = "";
				String surveyTempl = "";//added by prachi on 11-07-22 [W22DJOH004]
				String resultFormat = "";	//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]

				currDetail = detail8List.item(ctr);
				currDetailList = currDetail.getChildNodes();
				int currDetailListLength = currDetailList.getLength();

				for ( int i=0; i< currDetailListLength; i++ )
				{
					Node childNode = currDetailList.item(i);
					String childNodeName = childNode.getNodeName();
					System.out.println("childNodeName :: ["+childNodeName+"]");
					/*if(childNode.getAttributes().getNamedItem("selected") != null)
					{*/
					if(childNodeName.equalsIgnoreCase("attribute"))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
							//System.out.println("updateFlag :: ["+updateFlag+"]");
						}
					}
					/*if(!updateFlag.equalsIgnoreCase("D"))
					{
						childNode = childList.item(ctr);
						if(childNode.getFirstChild() != null)
						{
								flg=false;
								break;
						}
					}*/
					else if (childNodeName.equalsIgnoreCase("survey_code"))
					{
						if(childNode.getFirstChild() != null)
						{
							surveyCode = childNode.getFirstChild().getNodeValue().trim();
							//System.out.println("surveyCode::::===="+surveyCode);
						}
					}
					else if (childNodeName.equalsIgnoreCase("survey_templ"))
					{
						if(childNode.getFirstChild() != null)
						{
							surveyTempl = childNode.getFirstChild().getNodeValue().trim();
							System.out.println("surveyTempl::::===="+surveyTempl);
						}
					}
					else if (childNodeName.equalsIgnoreCase("result_type"))
					{
						if(childNode.getFirstChild() != null)
						{
							resultType = childNode.getFirstChild().getNodeValue().trim();
							//System.out.println("resultType::::===="+resultType);
						}
					}
					//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]START
					else if (childNodeName.equalsIgnoreCase("result_format"))
					{
						if(childNode.getFirstChild() != null)
						{
							resultFormat = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]END
					else if (childNodeName.equalsIgnoreCase("result1"))
					{
						if(childNode.getFirstChild() != null)
						{
							result1 = childNode.getFirstChild().getNodeValue().trim();
							//System.out.println("result1::::===="+result1);
						}
					}
					else if (childNodeName.equalsIgnoreCase("result2"))
					{
						if(childNode.getFirstChild() != null)
						{
							result2 = childNode.getFirstChild().getNodeValue().trim();
							//System.out.println("result2::::===="+result2);
						}
					}
					else if (childNodeName.equalsIgnoreCase("result3"))
					{
						if(childNode.getFirstChild() != null)
						{
							result3 = childNode.getFirstChild().getNodeValue().trim();
							//System.out.println("result3::::===="+result3);
						}
					}
					//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]START
					else if (childNodeName.equalsIgnoreCase("result4"))
					{
						if(childNode.getFirstChild() != null)
						{
							result4 = childNode.getFirstChild().getNodeValue().trim();
							//System.out.println("result4::::===="+result4);
						}
					}
					//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]END
					//Added by Pooja S on 10/02/20 [Mini meethas related implementation] START
					else if (childNodeName.equalsIgnoreCase("result5"))
					{
						if(childNode.getFirstChild() != null)
						{
							result5 = childNode.getFirstChild().getNodeValue().trim();
							//System.out.println("result5::::===="+result5);
						}
					}
					//Added by Pooja S on 10/02/20 [Mini meethas related implementation] END
					else if (childNodeName.equalsIgnoreCase("strg_code"))
					{
						if(childNode.getFirstChild() != null)
						{
							if(scCode!=null && scCode.trim().length()>0)
							{
								strgCode=scCode.trim();
							}
							else
							{
								strgCode = childNode.getFirstChild().getNodeValue().trim();

							}
							//System.out.println("strgCode::::===="+strgCode);
						}
					}
					
				}
				if(!updateFlag.equalsIgnoreCase("D") && !"A".equalsIgnoreCase(resultType))
				{
					
					//comment reverted on[W22CJOH003,W22DJOH004]
					//Changed by Prasad on 21/11/20 [to update SURV_STATUS while saving the survey details] START
					if ( ! isSurveyStatUpdated )
					{
						//String updateSurveyStatSql = "UPDATE STRG_SURV_RES SET SURV_STATUS = 'N' WHERE STRG_CODE = ? AND SURV_STATUS = 'Y' ";
						//changes done by prachi on 11-jul-22 [W22DJOH004]
						String updateSurveyStatSql = "UPDATE STRG_SURV_RES SET SURV_STATUS = 'N' WHERE STRG_CODE = ? AND SURV_STATUS = 'Y' AND DCR_ID IN (SELECT DCR_ID FROM STRG_MEET WHERE STRG_CODE = ? AND SURVEY_TEMPL=? AND DCR_ID<>? AND SALES_PERS=?) ";
						
						PreparedStatement pstmt1 = conn.prepareStatement( updateSurveyStatSql );
						pstmt1.setString( 1, strgCode );
						pstmt1.setString( 2, strgCode );
						pstmt1.setString( 3, surveyTempl );
						pstmt1.setString( 4, dcrId );
						pstmt1.setString( 5, salesPers );

						int surveyStatCnt = pstmt1.executeUpdate();
						System.out.println( "updateSurveySql :: surveyStatCnt : ["+ surveyStatCnt +"]" );
						if ( pstmt1 != null )
						{
							pstmt1.close();
							pstmt1 = null;
						}
						isSurveyStatUpdated = true;
					}
					//Changed by Prasad on 21/11/20 [to update SURV_STATUS while saving the survey details] END
					
					if("N".equalsIgnoreCase(resultType))
					{
						if(result1 == null || result1.trim().length() == 0)
						{
							result1 = "NA";
						}
						pstmt.setString(1, result1);
					}
					//else if("L".equalsIgnoreCase(resultType))
					//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]START
					else if("L".equalsIgnoreCase(resultType) && "D".equalsIgnoreCase(resultFormat))
					{
						if(result4 == null || result4.trim().length() == 0)
						{
							result4 = "NA";
						}
						pstmt.setString(1, result4);
					}
					//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]END
					else if("D".equalsIgnoreCase(resultType) || "L".equalsIgnoreCase(resultType))
					{
						if(result2 == null || result2.trim().length() == 0)
						{
							result2 = "NA";
						}
						pstmt.setString(1, result2);
					}
					else if("T".equalsIgnoreCase(resultType))
					{
						if(result3 == null || result3.trim().length() == 0)
						{
							result3 = "NA";
						}
						pstmt.setString(1, result3);
					}
					else
					{
						if(result3 == null || result3.trim().length() == 0)
						{
							result3 = "NA";
						}
						pstmt.setString(1, result3);
					}
					pstmt.setString(2, dcrId);
					pstmt.setString(3, strgCode);
					pstmt.setString(4, surveyCode);

					updCnt = pstmt.executeUpdate();
					pstmt.clearParameters();
					//System.out.println("updateresultType ::: updCnt =["+updCnt+"]");
				}
			}
			//}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
	}
	// added by rupali on 12/09/18 for adding survey subform in DAR [end]

	//Added by Sainath T. on 09/10/2018 [to store details in doc_usage_log table]-START
	private void saveDocContentUsage( Document dom )
	{
		try
		{
			NodeList parentNodeList = null;
			NodeList childNodeList = null;
			Node parentNode = null;
			Node childNode = null;
			String childNodeName = "";
			int childNodeLength = 0, parentNodeLength = 0;
			//Changed by prasad sir on 08-03-19[start]
			//DocumentHandlerWrapperEJB docWrapperHandler = new DocumentHandlerWrapperEJB();
			DocumentHandlerWrapperEJB docWrapperHandler = null;
			//Changed by prasad sir on 08-03-19[end]

			parentNodeList = dom.getElementsByTagName("Detail2");
			parentNodeLength = parentNodeList.getLength();

			for( int i = 0 ; i < parentNodeLength; i++ )
			{
				parentNode = parentNodeList.item(i);
				childNodeList = parentNode.getChildNodes();
				childNodeLength = childNodeList.getLength();
				String updateFlag = "";
				String usageDetailData = "";
				for ( int ctr = 0; ctr < childNodeLength; ctr++ )
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if(childNodeName.equalsIgnoreCase("attribute"))
					{
						if( childNode.getAttributes().getNamedItem("updateFlag") != null )
						{
							updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
						}
					}
					if( ! updateFlag.equalsIgnoreCase("D") )
					{
						if( childNodeName.equalsIgnoreCase( "usage_detail_data" ) )
						{
							if ( childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null )
							{
								usageDetailData = checkNull(childNode.getFirstChild().getNodeValue()).trim();
							}
							//System.out.println( "usage_detail_data : ["+ usageDetailData +"]" );
							if ( usageDetailData.length() > 0 )
							{
								JSONArray usageDetailArr = new JSONArray( usageDetailData );
								//System.out.println( "detailslength : ["+ usageDetailArr.length() +"]" );
								for( int j = 0; j< usageDetailArr.length(); j++ )
								{
									JSONObject usageDetailJson = (JSONObject) usageDetailArr.get(j);
									String jsonStr = usageDetailJson.toString();
									//System.out.println( "jsonStr : ["+ jsonStr +"]" );
									//Changed by prasad sir on 08-03-19[start]
									if ( docWrapperHandler == null )
									{
										docWrapperHandler = new DocumentHandlerWrapperEJB();
									}
									//Changed by prasad sir on 08-03-19[end]
									docWrapperHandler.saveDocUsageData( jsonStr, getUserInfo() );
								}
							}
							break;
						}
					}
				}
			}
		}
		catch (DOMException e)
		{
			e.printStackTrace();
		}
		catch (JSONException e)
		{
			e.printStackTrace();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
	//Added by Sainath T. on 09/10/2018 [to store details in doc_usage_log table]-END

	public void updateStrgCode(String tranId, String strgCode, Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		try
		{
			int updtCount = 0;

			String updtMeetSql = "UPDATE STRG_MEET SET STRG_CODE = ? WHERE TRAN_ID = ?";
			pstmt =  conn.prepareStatement(updtMeetSql);
			pstmt.setString(1, strgCode);
			pstmt.setString(2, tranId);
			updtCount = pstmt.executeUpdate();
			pstmt.close(); pstmt = null;
			//System.out.println("Data From STRG_MEET is updated updtCount:["+updtCount+"]");

			String updtMeetItemSql = "UPDATE STRG_MEET_ITEMS SET STRG_CODE = ? WHERE TRAN_ID = ?";
			pstmt =  conn.prepareStatement(updtMeetItemSql);
			pstmt.setString(1, strgCode);
			pstmt.setString(2, tranId);
			updtCount = pstmt.executeUpdate();
			pstmt.close(); pstmt = null;
			//System.out.println("Data From STRG_MEET_ITEMS is updated updtCount:["+updtCount+"]");

			String updtMeetOrderSql = "UPDATE STRG_MEET_ORDER SET STRG_CODE = ? WHERE TRAN_ID = ?";
			pstmt =  conn.prepareStatement(updtMeetOrderSql);
			pstmt.setString(1, strgCode);
			pstmt.setString(2, tranId);
			updtCount = pstmt.executeUpdate();
			pstmt.close(); pstmt = null;
			//System.out.println("Data From STRG_MEET_ORDER is updated updtCount:["+updtCount+"]");

			String updtMeetTeamSql = "UPDATE STRG_MEET_TEAM SET STRG_CODE = ? WHERE TRAN_ID = ?";
			pstmt =  conn.prepareStatement(updtMeetTeamSql);
			pstmt.setString(1, strgCode);
			pstmt.setString(2, tranId);
			updtCount = pstmt.executeUpdate();
			pstmt.close(); pstmt = null;
			//System.out.println("Data From STRG_MEET_TEAM is updated updtCount:["+updtCount+"]");

			String updtMeetbrandSql = "UPDATE STRG_BRAND_PITCH SET SC_CODE = ? WHERE TRAN_ID = ?";
			pstmt =  conn.prepareStatement(updtMeetbrandSql);
			pstmt.setString(1, strgCode);
			pstmt.setString(2, tranId);
			updtCount = pstmt.executeUpdate();
			pstmt.close(); pstmt = null;
			//System.out.println("Data From STRG_BRAND_PITCH is updated updtCount:["+updtCount+"]");

			String updtMeetDisplSql = "UPDATE STRG_ITEM_DISPLAY SET STRG_CODE = ? WHERE TRAN_ID = ?";
			pstmt =  conn.prepareStatement(updtMeetDisplSql);
			pstmt.setString(1, strgCode);
			pstmt.setString(2, tranId);
			updtCount = pstmt.executeUpdate();
			pstmt.close(); pstmt = null;
			//System.out.println("Data From STRG_ITEM_DISPLAY is updated updtCount:["+updtCount+"]");

			String updtCustAddSql = "UPDATE STRG_CUST_ADD SET STRG_CODE = ? WHERE TRAN_ID = ?";
			pstmt =  conn.prepareStatement(updtCustAddSql);
			pstmt.setString(1, strgCode);
			pstmt.setString(2, tranId);
			updtCount = pstmt.executeUpdate();
			pstmt.close(); pstmt = null;
			//System.out.println("Data From STRG_CUST_ADD is updated updtCount:["+updtCount+"]");

			String updtSurveySql = "UPDATE STRG_BRAND_SURVEY SET STRG_CODE = ? WHERE TRAN_ID = ?";
			pstmt =  conn.prepareStatement(updtSurveySql);
			pstmt.setString(1, strgCode);
			pstmt.setString(2, tranId);
			updtCount = pstmt.executeUpdate();
			pstmt.close(); pstmt = null;
			//System.out.println("Data From STRG_BRAND_SURVEY is updated updtCount:["+updtCount+"]");

			String updtSurveySubSql = "UPDATE STRG_SURV_RES SET STRG_CODE = ? WHERE TRAN_ID = ?";
			pstmt =  conn.prepareStatement(updtSurveySubSql);
			pstmt.setString(1, strgCode);
			pstmt.setString(2, tranId);
			updtCount = pstmt.executeUpdate();
			pstmt.close(); pstmt = null;
			//System.out.println("Data From STRG_SURV_RES is updated updtCount:["+updtCount+"]");

		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception : RealTimeReportPos :updateStrgCode :finally==>");
				throw new ITMException(e);
			}
		}
	}

	private String generateCustomerCode( Connection conn ) throws ITMException
	{
		String uniqueKey = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			//System.out.println("RealTimeReportPos : Generating Primary Key ...........");

			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_wsfa_strg_customer' ";
			pstmt = conn.prepareStatement(keyStringQuery);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				String keyString = rs.getString("KEY_STRING");
				String keyCol = rs.getString("TRAN_ID_COL");
				String tranSer = rs.getString("REF_SER");
				String xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
				xmlValues = xmlValues + "<Header></Header>";
				xmlValues = xmlValues + "<Detail1>";
				xmlValues = xmlValues +        "<sc_code></sc_code>";
				xmlValues = xmlValues + "</Detail1></Root>";
				TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
				uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			}
			rs.close();	rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception exp)
		{
			System.out.println("Exception : RealTimeReportPos :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception : RealTimeReportPos :getUniqueKey :finally==>");
				throw new ITMException(e);
			}
		}
		System.out.println("Generated Primary Key :"+uniqueKey);
		return uniqueKey;
	}

	public void insertIntoDocTransactionLink(String refId,String refSer,Connection conn) throws ITMException
	{
		PreparedStatement pstmtInsert = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmtCnt = null;
		ResultSet rsCnt = null;
		ResultSet rs = null;
		int docCnt=0;
		try
		{
			//System.out.println("attachmentId::1832["+refId+"]");
			String docId = "",refCol="";
			String fileLoc = "",docTypeAttach ="";
			String fileTypeAttach="",refDescr ="",docuuId="",docPath="",dmstenant="";
			String ccaDocSql="SELECT DOC_ID,REF_SER,REF_ID,REF_COL,FILE_LOC,DOC_TYPE_ATTACH,FILE_TYPE_ATTACH,REF_DESCR,DOC_UUID,DOCUMENT_PATH,DMS_TENANT FROM DOC_TRANSACTION_LINK WHERE REF_ID= ? AND REF_SER = ?";
			pstmt = conn.prepareStatement(ccaDocSql);
			pstmt.setString(1, refId);
			pstmt.setString(2, refSer);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				docId = checkNull(rs.getString("DOC_ID"));
				refSer = checkNull(rs.getString("REF_SER"));
				refId = checkNull(rs.getString("REF_ID"));
				refCol = rs.getString("REF_COL");
				fileLoc = checkNull(rs.getString("FILE_LOC"));
				docTypeAttach = checkNull(rs.getString("DOC_TYPE_ATTACH"));
				fileTypeAttach = checkNull(rs.getString("FILE_TYPE_ATTACH"));
				refDescr = checkNull(rs.getString("REF_DESCR"));
				docuuId = checkNull(rs.getString("DOC_UUID"));
				docPath = checkNull(rs.getString("DOCUMENT_PATH"));
				dmstenant = checkNull(rs.getString("DMS_TENANT"));
				//System.out.println("refCol["+refCol+"]refSer["+refSer+"]docId["+docId+"]");

				String docIdSql="SELECT COUNT(*) AS COUNT FROM DOC_TRANSACTION_LINK WHERE REF_ID= ? AND REF_SER = ? AND DOC_ID = ? ";
				pstmtCnt = conn.prepareStatement(docIdSql);
				pstmtCnt.setString(1, refId);
				pstmtCnt.setString(2, "F-DCR");
				pstmtCnt.setString(3, docId);
				rsCnt = pstmtCnt.executeQuery();
				if(rsCnt.next())
				{
					docCnt = rsCnt.getInt("COUNT");
				}
				if(rsCnt != null)
				{
					rsCnt.close();
					rsCnt = null;
				}
				if(pstmtCnt != null)
				{
					pstmtCnt.close();
					pstmtCnt = null;
				}
				//System.out.println("docCnt::1848>>["+docCnt+"]");
				if(docCnt == 0)
				{
					String docInsertSql = "INSERT INTO DOC_TRANSACTION_LINK (DOC_ID,REF_SER,REF_ID,REF_COL,FILE_LOC,DOC_TYPE_ATTACH,FILE_TYPE_ATTACH,REF_DESCR,DOC_UUID,DOCUMENT_PATH,DMS_TENANT )" +
							" VALUES (?,?,?,?,?,?,?,?,?,?,?)";

					pstmtInsert = conn.prepareStatement(docInsertSql);
					pstmtInsert.setString(1, docId);
					pstmtInsert.setString(2, "F-DCR");
					pstmtInsert.setString(3, refId);
					pstmtInsert.setString(4, refCol);
					pstmtInsert.setString(5, fileLoc);
					pstmtInsert.setString(6, docTypeAttach);
					pstmtInsert.setString(7, fileTypeAttach);
					pstmtInsert.setString(8, refDescr);
					pstmtInsert.setString(9, docuuId);
					pstmtInsert.setString(10, docPath);
					pstmtInsert.setString(11, dmstenant);
					int insertCnt = pstmtInsert.executeUpdate();
					if(pstmtInsert != null)
					{
						pstmtInsert.close();
						pstmtInsert = null;
					}
					//System.out.println("insertCnt DocumentTranLink =["+insertCnt+"]");
				}
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}


		}
		catch(Exception e)
		{
			System.out.println("inside catch of insertDocTransLink");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmtInsert != null)
				{
					pstmtInsert.close();
					pstmtInsert = null;
				}
				if(rsCnt != null)
				{
					rsCnt.close();
					rsCnt = null;
				}
				if(pstmtCnt != null)
				{
					pstmtCnt.close();
					pstmtCnt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception ex)
			{

			}
		}
	}

	public String getSfaParmValue(String userId,String paramName,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		String empSite="";
		String itemSer="";
		String paramValue="";
		PreparedStatement allPstmt = null;
		ResultSet allRs = null;
		boolean isLocalConn =false;
		try
		{
			if(connectionObject == null)
			{

				connectionObject = getConnection();
				isLocalConn =true;
			}
			String sql = "SELECT SITE_CODE__DEF FROM USERS WHERE CODE = ? ";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				empSite  = checkNull(rs.getString("SITE_CODE__DEF"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}


			String getSalesPerData = " SELECT SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER LEFT OUTER JOIN SALES_PERS ON ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER "+
					" WHERE  SALES_PERS.SALES_PERS = ? ";

			pstmt = connectionObject.prepareStatement(getSalesPerData);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				itemSer  = checkNull(rs.getString("ITEM_SER"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			sql=" SELECT PARM_VALUE  "+
					" FROM SFAPARM  "+
					" WHERE ORG_UNIT =?  "+
					" AND ACTIVE='Y'  "+
					" AND PARM_NAME= ? ";

			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, empSite+"_"+itemSer);
			pstmt.setString(2, paramName);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				paramValue  = checkNull(rs.getString(1));
			}
			else
			{
				pstmt1 = connectionObject.prepareStatement(sql);
				pstmt1.setString(1, itemSer);
				pstmt1.setString(2, paramName);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					paramValue  = checkNull(rs1.getString(1));
				}
				else
				{
					allPstmt = connectionObject.prepareStatement(sql);
					allPstmt.setString(1, "ALL");
					allPstmt.setString(2, paramName);
					allRs = allPstmt.executeQuery();
					if(allRs.next())
					{
						paramValue  = checkNull(allRs.getString(1));
					}
				}
				if ( allRs != null )
				{
					allRs.close();
					allRs = null;
				}
				if ( allPstmt != null )
				{
					allPstmt.close();
					allPstmt = null;
				}
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch (SQLException e) {
				e.printStackTrace();
			}
		}
		return paramValue;
	}

	// Added by mrunalini sinakr to update Old Table Data(start)
	private void updateOldTableData(String dcrId,String eventDate,String salesPers ,int chemCnt,Connection conn) throws ITMException
	{
		PreparedStatement pstmtCust=null;
		PreparedStatement pstmt=null;

		ResultSet rsCust=null;
		String eventTimeStart="";
		String eventTimeEnd="";
		try
		{
			String minEventTimeSql="SELECT SM.EVENT_TIME_START AS EVENT_TIME_START FROM  STRG_MEET SM,STRG_CUSTOMER SC WHERE DCR_ID = ? AND STRG_TYPE ='C'  AND  SM.STRG_CODE=SC.SC_CODE AND SM.STRG_TYPE=SC.CUST_TYPE ORDER BY TO_CHAR(TO_DATE (SM.EVENT_TIME_START, 'HH:MI AM'),'HH24:MI:SS') ";
			pstmtCust = conn.prepareStatement( minEventTimeSql );
			pstmtCust.setString(1, dcrId);
			rsCust = pstmtCust.executeQuery();
			if (rsCust.next())
			{
				eventTimeStart= checkNull(rsCust.getString("EVENT_TIME_START"));
			}
			if ( rsCust != null )
			{
				rsCust.close();
				rsCust = null;
			}
			if ( pstmtCust != null )
			{
				pstmtCust.close();
				pstmtCust = null;
			}

			String maxEventTimeSql="SELECT SM.EVENT_TIME_END AS EVENT_TIME_END FROM  STRG_MEET SM,STRG_CUSTOMER SC WHERE DCR_ID = ? AND STRG_TYPE ='C'  AND  SM.STRG_CODE=SC.SC_CODE AND SM.STRG_TYPE=SC.CUST_TYPE ORDER BY TO_CHAR(TO_DATE (SM.EVENT_TIME_END, 'HH:MI AM'),'HH24:MI:SS') DESC ";
			pstmtCust = conn.prepareStatement( maxEventTimeSql );
			pstmtCust.setString(1, dcrId);
			rsCust = pstmtCust.executeQuery();
			if (rsCust.next())
			{
				eventTimeEnd= checkNull(rsCust.getString("EVENT_TIME_END"));
			}
			if ( rsCust != null )
			{
				rsCust.close();
				rsCust = null;
			}
			if ( pstmtCust != null )
			{
				pstmtCust.close();
				pstmtCust = null;
			}

			String sql1="UPDATE DR_CHEMIST_VISIT SET CHEMIST_VISIT_TIME=?,CHEM_LAST_VISIT_TIME=?,NOOF_CHEMIST=? WHERE WORK_DATE= ? AND SALES_PERS=? ";
			pstmt = conn.prepareStatement(sql1);
			pstmt.setString(1, eventTimeStart);
			pstmt.setString(2, eventTimeEnd);
			pstmt.setInt(3, chemCnt);
			pstmt.setTimestamp(4, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmt.setString(5, salesPers);


			int endTimeCnt= pstmt.executeUpdate();
			if(endTimeCnt > 0)
			{
				System.out.println("updates successfully DR_CHEMIST_VISIT table");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rsCust != null )
				{
					rsCust.close();
					rsCust = null;
				}
				if ( pstmtCust != null )
				{
					pstmtCust.close();
					pstmtCust = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{

			}
		}
	}
	//Added by mrunalini sinakr to update Old Table Data(end)

	//Added by Amey W. [to set coaching form values] on 11-12-2019
	private void updateCoachingDetail( Document dom, String dcrId, String scCode, Connection conn ) throws Exception
	{
		int updCnt = 0;
		PreparedStatement pstmt = null;
		String formNo = "";
		String updateFlag = "";
		try
		{
			String objName = getObjNameFromDom( dom, "objName" , 1);
			String winName = "w_"+objName;

			String objFormSql= "SELECT FORM_NAME, FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= ? AND FORM_NAME IN('coaching')";
			PreparedStatement pstmtForm = conn.prepareStatement(objFormSql);
			pstmtForm.setString(1, winName);
			ResultSet rsForm = pstmtForm.executeQuery();
			while(rsForm.next())
			{
				formNo = checkNull(rsForm.getString("FORM_NO"));
			}
			if(rsForm != null)
			{
				rsForm.close();
				rsForm = null;
			}
			if(pstmtForm != null)
			{
				pstmtForm.close();
				pstmtForm = null;
			}

			String updCoachingSql = "UPDATE SPRS_COACHING SET RESULT = ? WHERE DCR_ID = ? AND STRG_CODE = ? AND SURVEY_CODE = ?";
			pstmt = conn.prepareStatement( updCoachingSql );

			Node currDetail = null;
			NodeList detail8List = null;
			NodeList currDetailList = null;
			detail8List = dom.getElementsByTagName("Detail"+formNo);
			int detailListLength = detail8List.getLength();

			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				String surveyCode = "";
				String resultType = "";
				String result1 = "";
				String result2 = "";
				String result3 = "";
				String result4 = "";
				String result5 = "";
				String strgCode = "";
				String resultFormat = "";

				currDetail = detail8List.item(ctr);
				currDetailList = currDetail.getChildNodes();
				int currDetailListLength = currDetailList.getLength();

				for ( int i=0; i< currDetailListLength; i++ )
				{
					Node childNode = currDetailList.item(i);
					String childNodeName = childNode.getNodeName();
					System.out.println("childNodeName :: ["+childNodeName+"]");
					if(childNodeName.equalsIgnoreCase("attribute"))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
						}
					}
					else if (childNodeName.equalsIgnoreCase("survey_code"))
					{
						if(childNode.getFirstChild() != null)
						{
							surveyCode = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("result_type"))
					{
						if(childNode.getFirstChild() != null)
						{
							resultType = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("result_format"))
					{
						if(childNode.getFirstChild() != null)
						{
							resultFormat = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("result1"))
					{
						if(childNode.getFirstChild() != null)
						{
							result1 = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("result2"))
					{
						if(childNode.getFirstChild() != null)
						{
							result2 = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("result3"))
					{
						if(childNode.getFirstChild() != null)
						{
							result3 = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("result4"))
					{
						if(childNode.getFirstChild() != null)
						{
							result4 = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("result5"))
					{
						if(childNode.getFirstChild() != null)
						{
							result5 = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("strg_code"))
					{
						if(childNode.getFirstChild() != null)
						{
							if(scCode!=null && scCode.trim().length()>0)
							{
								strgCode=scCode.trim();
							}
							else
							{
								strgCode = childNode.getFirstChild().getNodeValue().trim();
							}
						}
					}
				}
				if(!updateFlag.equalsIgnoreCase("D"))
				{
					if("N".equalsIgnoreCase(resultType))
					{
						if(result1 == null || result1.trim().length() == 0)
						{
							result1 = "NA";
						}
						pstmt.setString(1, result1);
					}
					else if("L".equalsIgnoreCase(resultType) && "D".equalsIgnoreCase(resultFormat))
					{
						if(result4 == null || result4.trim().length() == 0)
						{
							result4 = "NA";
						}
						pstmt.setString(1, result4);
					}
					else if("D".equalsIgnoreCase(resultType) || "L".equalsIgnoreCase(resultType))
					{
						if(result2 == null || result2.trim().length() == 0)
						{
							result2 = "NA";
						}
						pstmt.setString(1, result2);
					}
					else if("T".equalsIgnoreCase(resultType))
					{
						if(result3 == null || result3.trim().length() == 0)
						{
							result3 = "NA";
						}
						pstmt.setString(1, result3);
					}
					else if("A".equalsIgnoreCase(resultType))
					{
						if(result5 == null || result5.trim().length() == 0)
						{
							result5 = "NA";
						}
						pstmt.setString(1, result5);
					}
					else
					{
						if(result3 == null || result3.trim().length() == 0)
						{
							result3 = "NA";
						}
						pstmt.setString(1, result3);
					}
					pstmt.setString(2, dcrId);
					pstmt.setString(3, strgCode);
					pstmt.setString(4, surveyCode);

					updCnt = pstmt.executeUpdate();
					System.out.println("updCnt = "+updCnt);
					pstmt.clearParameters();
				}
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(SQLException e)
		{
			System.out.println("SQLException :: updateCoachingDetail() EXCEPTION ==>"+e);
			//throw new ITMException(e);
		}
		catch(Exception e)
		{
			System.out.println("updateCoachingDetail() EXCEPTION ==>"+e);
			throw new ITMException(e);
		}
	}
	//Added by Amey W. [to set coaching form values] on 11-12-2019 END

	//Added by saiprasad G.on 27-12-19 For the coaching post save logic in user_tasks table using MasterStateFul[START]
	/*//Commented by sadique shaikh 02-01-2020 [We are performing below action after confirm] Start
	private void createUserTasks( Document dom, String xtraParams, Connection conn ) throws ITMException
	{
		StringBuffer xmlString = new StringBuffer();

		try
		{
			String objName = getObjNameFromDom( dom, "objName" , 1);
			String winName = "w_"+objName;
			String formNo = "";

			String objFormSql= "SELECT FORM_NAME, FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= ? AND FORM_NAME IN('coaching')";
			PreparedStatement pstmtForm = conn.prepareStatement(objFormSql);
			pstmtForm.setString(1, winName);
			ResultSet rsForm = pstmtForm.executeQuery();
			while(rsForm.next())
			{
				formNo = checkNull(rsForm.getString("FORM_NO"));
			}
			if(rsForm != null)
			{
				rsForm.close();
				rsForm = null;
			}
			if(pstmtForm != null)
			{
				pstmtForm.close();
				pstmtForm = null;
			}

			SimpleDateFormat sdfDBDateFormat = new SimpleDateFormat( genericUtility.getApplDateFormat() );
			Date currDate = new Date();
			String currDateStr = sdfDBDateFormat.format(currDate);

			String chgUser = "", chgTerm ="";
			chgUser = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			InetAddress ownIP = InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();

			String taskType = "P"; //Physical Activity
			String taskDomain = "SFA"; //SFA
			String taskCode = getTaskCode( taskDomain, conn ); //Action Plan
			String taskStatus = "P"; //Pending
			String taskDescr = "", assignedTo = "";

			NodeList childNodeList = null;
			Node parentNode = null, childNode = null;
			int childNodeCount = 0;

			NodeList parentNodeList = dom.getElementsByTagName( "Detail"+ formNo );
			int parenNodeListCount = parentNodeList.getLength();
			System.out.println( "parenNodeListCount : ["+ parenNodeListCount +"]" );
			for( int detailCount = 0; detailCount < parenNodeListCount; detailCount++ )
			{
				parentNode = parentNodeList.item( detailCount );
				childNodeList = parentNode.getChildNodes();
				childNodeCount = childNodeList.getLength();
				for( int rowCount = 0; rowCount < childNodeCount; rowCount++ )
				{
					childNode = childNodeList.item(rowCount);
					String childNodeName = childNode.getNodeName();
					if ( "result5".equalsIgnoreCase( childNodeName ) && childNode.getFirstChild() != null )
					{
						String result5 = childNode.getFirstChild().getNodeValue();

						JSONParser parser = new JSONParser();
						org.json.simple.JSONObject userTaskJson = null;
						try
						{
							userTaskJson = (org.json.simple.JSONObject) parser.parse( result5 );
						}
						catch (Exception e)
						{
							e.printStackTrace();
							continue;
						}
						System.out.println( "json: ["+ userTaskJson +"]" );

						taskDescr = (String) userTaskJson.get( "task_descr" ); //Prasad
						if( taskDescr != null && taskDescr.trim().length() > 0 )
						{
							assignedTo = (String) userTaskJson.get( "assigned_to" ); //Prasad

							xmlString.append("<Root>\r\n");
							xmlString.append("<Header0>\r\n");
							xmlString.append("<objName><![CDATA[user_tasks]]></objName>\r\n");
							xmlString.append("<pageContext><![CDATA[1]]></pageContext>\r\n");
							xmlString.append("<editFlag><![CDATA[A]]></editFlag>\r\n");
							xmlString.append("<focusedColumn><![CDATA[]]></focusedColumn>\r\n");
							xmlString.append("<action><![CDATA[SAVE]]></action>\r\n");
							xmlString.append("<elementName><![CDATA[]]></elementName>\r\n");
							xmlString.append("<taxKeyValue><![CDATA[]]></taxKeyValue>\r\n");
							xmlString.append("<taxInFocus><![CDATA[false]]></taxInFocus>\r\n");
							xmlString.append("<objContext><![CDATA[1]]></objContext>\r\n");
							xmlString.append("<forcedSave><![CDATA[true]]></forcedSave>\r\n");
							xmlString.append("<keyValue><![CDATA[1]]></keyValue>\r\n");
							xmlString.append("<pkValues><![CDATA[]]></pkValues>\r\n");
							xmlString.append("<description>Header0 members</description>\r\n");
							xmlString.append("</Header0>\r\n");
							xmlString.append("<description>Header0 members</description>\r\n");
							xmlString.append("<Detail1 objContext=\"1\" objName=\"user_tasks\" domID=\"1\" dbID=\"\" selected=\"Y\">\r\n");
							xmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");
							xmlString.append("<tran_id>").append("<![CDATA[]]>").append("</tran_id>\r\n");
							xmlString.append("<tran_date>").append("<![CDATA[").append( currDateStr ).append("]]>").append("</tran_date>\r\n");
							xmlString.append("<user_id>").append("<![CDATA[").append( chgUser ).append("]]>").append("</user_id>\r\n");
							xmlString.append("<task_descr>").append("<![CDATA[").append( taskDescr ).append("]]>").append("</task_descr>\r\n");
							xmlString.append("<task_type>").append("<![CDATA[").append( taskType ).append("]]>").append("</task_type>\r\n");
							xmlString.append("<task_domain>").append("<![CDATA[").append( taskDomain ).append("]]>").append("</task_domain>\r\n");
							xmlString.append("<task_code>").append("<![CDATA[").append( taskCode ).append("]]>").append("</task_code>\r\n");
							xmlString.append("<user_id__assigned>").append("<![CDATA[").append( assignedTo ).append("]]>").append("</user_id__assigned>\r\n");
							xmlString.append("<exp_compl_date>").append("<![CDATA[]]>").append("</exp_compl_date>\r\n");
							xmlString.append("<curr_status>").append("<![CDATA[").append( taskStatus ).append("]]>").append("</curr_status>\r\n");
							xmlString.append("<status_date>").append("<![CDATA[").append( currDateStr ).append("]]>").append("</status_date>\r\n");
							xmlString.append("<compl_remarks>").append("<![CDATA[]]>").append("</compl_remarks>\r\n");
							xmlString.append("<add_date>").append("<![CDATA[").append( currDateStr ).append("]]>").append("</add_date>\r\n");
							xmlString.append("<add_user>").append("<![CDATA[").append( chgUser ).append("]]>").append("</add_user>\r\n");
							xmlString.append("<add_term>").append("<![CDATA[").append( chgTerm ).append("]]>").append("</add_term>\r\n");
							xmlString.append("</Detail1>\r\n");
							xmlString.append("</Root>\r\n");

							String responseStr = callProcessRequest( xmlString.toString(), conn );
							System.out.println( "callProcessRequest :: responseStr :: ["+ responseStr +"]" );
						}
					}
				}
			}
		}
		catch(SQLException e)
		{
			System.out.println( "SQLException :: createUserTasks : ["+ e.getMessage() +"]" );
		}
		catch(Exception e)
		{
			System.out.println( "Exception :: createUserTasks : ["+ e.getMessage() +"]" );
			throw new ITMException(e);
		}
	}

	private String callProcessRequest( String xmlString, Connection conn ) throws ITMException
	{
		String retStr = "";
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext ctx = new InitialContext( appConnect.getProperty() );
			MasterStatefulLocal masterStateful = ( MasterStatefulLocal )ctx.lookup( "ibase/MasterStatefulEJB/local" );
			retStr = masterStateful.processRequest( getUserInfo(), xmlString.toString(), false, conn );
			masterStateful.remove();
			masterStateful = null;
		}
		catch (RemoteException e)
		{
			throw new ITMException(e);
		}
		catch (ITMException e)
		{
			throw e;
		}
		catch (NamingException e)
		{
			throw new ITMException(e);
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retStr;
	}

	private String getTaskCode( String taskDomain, Connection conn ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String taskCode = "";
		try
		{
			String sql  = "SELECT TASK_CODE FROM TASK WHERE TASK_DOMAIN = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, taskDomain);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				taskCode = checkNull(rs.getString("TASK_CODE"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(SQLException e)
		{
			System.out.println( "SQLException :: getTaskCode : ["+ e.getMessage() +"]" );
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return taskCode;
	}
	//Commented by sadique shaikh 02-01-2020 [We are performing below action after confirm] End*/
	//Added by saiprasad G.on 27-12-19 For the coaching post save logic in user_tasks table using MasterStateFul[START]
	// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
	private boolean updateSprsActivity( Connection conn, String salesPers, String dcrDate,String activityCode,  String tranId, Document dom, String visitTimeFr, String visitTimeTo ) throws ITMException
	{
		boolean isSuccess = false;
		PreparedStatement pstmtUpdSprsActTran=null;
		PreparedStatement pstmtUpdSprsActiviTy=null;
		ResultSet rs=null;
		String visitTimFrm = genericUtility.getColumnValue("event_time_start",dom);
		String visitTimTo = genericUtility.getColumnValue("event_time_end",dom);
		String remarks = genericUtility.getColumnValue("remarks",dom);
	
		try
		{

			
			
			SimpleDateFormat format = new SimpleDateFormat("hh:mm");
			java.util.Date date1 =  format.parse(visitTimFrm);
			java.util.Date date2 =  format.parse(visitTimTo);
			
			
			java.util.Date visitTimeFr1 =  format.parse(visitTimeFr);
			java.util.Date visitTimeTo1 =  format.parse(visitTimeTo);
			
			
			dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			System.out.println("updateSprsActTran is called...........");
			String updateStrgMeetSql ="UPDATE SPRS_ACTIVITY SET VISIT_TIME_FR = ? ,VISIT_TIME_TO = ? WHERE EVENT_DATE = ? AND SALES_PERS = ?  AND ACTIVITY_CODE = ?";
			pstmtUpdSprsActTran = conn.prepareStatement(updateStrgMeetSql);
			
			if(date1.getTime() < visitTimeFr1.getTime())
			{
				pstmtUpdSprsActTran.setString(1, visitTimFrm);
			}
			else
			{
				pstmtUpdSprsActTran.setString(1, visitTimeFr);
			}
			
			if(date2.getTime() > visitTimeTo1.getTime())
			{
				pstmtUpdSprsActTran.setString(2, visitTimTo);
			}
			else
			{
				pstmtUpdSprsActTran.setString(2, visitTimeTo);
			}
			//pstmtUpdSprsActTran.setTimestamp(3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmtUpdSprsActTran.setTimestamp(3, java.sql.Timestamp.valueOf(dcrDate));
			pstmtUpdSprsActTran.setString(4, salesPers);
			pstmtUpdSprsActTran.setString(5, activityCode);

			int Cnt= pstmtUpdSprsActTran.executeUpdate();
			if(Cnt > 0)
			{
				System.out.println("updates successfully SPRS_ACT_TRAN :: ["+Cnt+"]");
			}
			if(pstmtUpdSprsActTran != null)
			{
				pstmtUpdSprsActTran.close();
				pstmtUpdSprsActTran = null;
			}
		}
		catch(Exception exp)
		{
			System.out.println("Exception : updateSprsActTran ::==>\n");
			throw new ITMException(exp);
		}
		return isSuccess;
	}
	// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
	// added by shweta for updating entry_mode value in strg_meet table 20-05-21 (started)
			private void updateStrgMeetEntry(String dcrID, String tranId, Connection conn ) throws ITMException
			{
				PreparedStatement pstmt3=null;
				try
				{
					System.out.println("updateStrgMeetTeams is called...........");
					String updateStrgMeetSql ="UPDATE STRG_MEET SET ENTRY_MODE='A' WHERE DCR_ID = ?  AND TRAN_ID = ? ";
					pstmt3 = conn.prepareStatement(updateStrgMeetSql);
					pstmt3.setString(1, dcrID);
					//pstmt3.setString(2, "FW");
					pstmt3.setString(2, tranId);
					int cntStrgMeetCnt= pstmt3.executeUpdate();
					if(cntStrgMeetCnt > 0)
					{
						System.out.println("updates successfully updateStrgMeetEntry"+cntStrgMeetCnt);
					}

					if(pstmt3 != null)
					{
						pstmt3.close();
						pstmt3 = null;
					}
				}
				catch(Exception exp)
				{
					System.out.println("Exception : updateStrgMeetEntry ::==>\n");
					throw new ITMException(exp);
				}
				
			}
			// added by shweta for updating entry_mode value in strg_meet table 20-05-21 (end)
			public String getEmpReportTo( String empCode, Connection conn ) throws Exception
	{
		String selectSql = "";
		String reportTo = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			selectSql = "SELECT REPORT_TO FROM EMPLOYEE WHERE EMP_CODE = ? ";
			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				reportTo = checkNull(rs.getString("REPORT_TO"));
			}
		}
		catch ( Exception e)
		{
			throw e;
		}
		finally
		{
			try
			{
				System.out.println("Closing Connection.....");
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}catch(Exception e){}
		}
		System.out.println("gradeLev[getEmpGradeLevel] =["+reportTo+"]");
		return reportTo;
	}
	
	public String getRefser(String objName,Connection conn)
	{
		String refSer="",sql="";
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		try
		{
			sql="SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW=?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, "w_"+objName);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				refSer=checkNull(rs.getString("REF_SER"));
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}

		return refSer;
	}
 
 	public String sendMailStatus(String salesPers, String xmlString,String formatCode,String objName,String refSer,String reportTo,Connection conn) throws RemoteException ,ITMException
	{
		System.out.println("Inside sendMailStatus method:");
		String mailHeader = "";
		String infoType = "ITM";
		String returnstrFromSendMailMethod="";
		try
		{
			EMail em = new EMail();
			mailHeader = 	"<ROOT>"+
			"<TRANS_INFO>"+
			"<OBJ_NAME>"+objName+"</OBJ_NAME>"+
			"<REF_SER>"+refSer+"</REF_SER>"+
			"<LINE_NO>"+""+"</LINE_NO>"+
			"<XSL_FILE_NAME></XSL_FILE_NAME>"+
			"</TRANS_INFO>"+
			"<MAIL>"+
			"<SUBJECT></SUBJECT>"+
			"<ENTITY_CODE>"+reportTo.trim()+"</ENTITY_CODE>"+
			"<BODY_TEXT></BODY_TEXT>"+
			"<TO_ADD></TO_ADD>"+
			"<CC_ADD></CC_ADD>"+
			"<FORMAT_CODE>"+formatCode+"</FORMAT_CODE>"+
			"<ATTACHMENT><BODY></BODY><LOCATION></LOCATION></ATTACHMENT>"+
			"</MAIL>"+
			"<XML_DATA>"+xmlString+"</XML_DATA>"+
			"</ROOT>";

			returnstrFromSendMailMethod = em.sendMail(mailHeader, infoType,conn);
			System.out.println("@@@@ mail function called successfully : "+returnstrFromSendMailMethod);

		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		}

		return returnstrFromSendMailMethod;
	}
 	public void updatPOBValue(String tranId,String strgCode,Connection conn) throws ITMException
	{

		System.out.println("tranId is :- "+tranId);
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;

		String sum = "";
		try
		{
			String sql  = "SELECT SUM(VALUE) SUM FROM STRG_MEET_ORDER WHERE TRAN_ID= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);

			rs = pstmt.executeQuery();
			if (rs.next())
			{
				sum = checkNull(rs.getString("SUM"));
				System.out.println("sum++"+sum+"+++");
				String sql2 = "UPDATE STRG_MEET SET SKU_VALUE = ? WHERE TRAN_ID = ?";
				pstmt1 = conn.prepareStatement(sql2);
				pstmt1.setString(1, sum);
				pstmt1.setString(2, tranId);
				int i = pstmt1.executeUpdate();
				if( pstmt1 !=null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
				System.out.println("Updated row "+i);
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); 

		}
	}
 	public void updatPrefferdStockistValue(String tranId,String strgCode,String prefferdStockCode,Connection conn) throws ITMException
	{

		System.out.println("tranId is :- "+tranId);
		PreparedStatement pstmt1 = null;

		try
		{
				String sql2 = "UPDATE STRG_MEET_ORDER SET STOCKIST_CODE = ? WHERE TRAN_ID = ?";
				pstmt1 = conn.prepareStatement(sql2);
				pstmt1.setString(1, prefferdStockCode);
				pstmt1.setString(2, tranId);
				int i = pstmt1.executeUpdate();
				if( pstmt1 !=null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
				System.out.println("Updated row "+i);
			

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); 

		}
	}
 	public void updateInvoiceId(Document dom,String miniMumInvoiceID,String tranId,String collectionFormNo,String invoiceNo,Connection conn) throws ITMException
	{

		System.out.println("updateInvoiceId tranId is :- "+tranId);
		PreparedStatement pstmt = null;
		String updateFlag = "";

		try
		{
				
			Node currDetail = null;
			NodeList detail8List = null;
			NodeList currDetailList = null;
			detail8List = dom.getElementsByTagName("Detail"+collectionFormNo);
			int detailListLength = detail8List.getLength();
			String payMode = "";
			String refNo="";
			/*if(invoiceNo.indexOf("/")!=-1)
			{
				refNo=invoiceNo.split("/")[0];
			}
			System.out.println("refNo:::["+refNo+"]");
			if(refNo!=null && refNo.trim().length()>0)
			{
				miniMumInvoiceID=refNo+"/"+miniMumInvoiceID;
			}
			else
			{
				miniMumInvoiceID=miniMumInvoiceID;
			}*/
			miniMumInvoiceID=miniMumInvoiceID;
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				currDetail = detail8List.item(ctr);
				currDetailList = currDetail.getChildNodes();
				int currDetailListLength = currDetailList.getLength();

				for ( int i=0; i< currDetailListLength; i++ )
				{
					Node childNode = currDetailList.item(i);
					String childNodeName = childNode.getNodeName();

					if(childNodeName.equalsIgnoreCase("attribute"))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
						}
					}
					else if (childNodeName.equalsIgnoreCase("pay_mode"))
					{
						if(childNode.getFirstChild() != null)
						{
							payMode = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					
				}
				
			}
			if(!"C".equalsIgnoreCase(payMode))
			{
				String sql2 = "UPDATE STRG_MEET_INVOICE SET INVOICE_ID = ? WHERE TRAN_ID = ?";
				pstmt = conn.prepareStatement(sql2);
				pstmt.setString(1, miniMumInvoiceID);
				pstmt.setString(2, tranId);
				int i = pstmt.executeUpdate();
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("Updated row "+i);
			}

			

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); 

		}
	}
 	//Added by Bhagyashri t for team subform add [W21KJOH015][END]
 	public void insertentitycontact(String tranId,String strgCode,Connection conn) throws ITMException
	{

 		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmtMeet = null;
		ResultSet rsMeet = null;
		PreparedStatement pstmt1 = null;
		String entitycode ="", contactPers = "",contactPersName="",MobileNos="";
		try
		{
			String insertEntity =" INSERT INTO ENTITY_CONTACT(ENTITY_TYPE,ENTITY_CODE,CONTACT_PERS,CONTACT_PERS_NAME,MOBILE_NO) "+
								 "VALUES(?,?,?,?,?)";
			pstmt1 = conn.prepareStatement(insertEntity);
			String sql  = "SELECT SMT.SALES_PERS FROM STRG_MEET_TEAM SMT WHERE SMT.TRAN_ID= ? AND (SMT.SALES_PERS NOT IN(SELECT EMP_CODE FROM EMPLOYEE) AND trim(SMT.SALES_PERS) NOT IN(SELECT trim(CONTACT_PERS) FROM ENTITY_CONTACT))";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String salesPers = checkNull(rs.getString("SALES_PERS"));
				System.out.println("Sales person is::"+salesPers);
				String sqlMeet ="SELECT STRG_CODE AS ENTITY_CODE,SALES_PERS AS CONTACT_PERS,MEMBER_NAME AS CONTACT_PERS_NAME,TEAM_MOBILE_NO AS MOBILE_NO " + 
						"FROM STRG_MEET_TEAM SMT WHERE SMT.SALES_PERS=? AND SMT.TRAN_ID= ?";
				pstmtMeet = conn.prepareStatement(sqlMeet);
				pstmtMeet.setString(1, salesPers);
				pstmtMeet.setString(2, tranId);
				rsMeet = pstmtMeet.executeQuery();
				if(rsMeet.next())
				{
					entitycode =  checkNull(rsMeet.getString("ENTITY_CODE")).trim();
					contactPers =  checkNull(rsMeet.getString("CONTACT_PERS")).trim();
					contactPersName =  checkNull(rsMeet.getString("CONTACT_PERS_NAME")).trim();
					MobileNos =  checkNull(rsMeet.getString("MOBILE_NO")).trim();
				}
				if( rsMeet !=null )
				{
					rsMeet.close();
					rsMeet = null;
				}
				if( pstmtMeet !=null )
				{
					pstmtMeet.close();
					pstmtMeet = null;
				}
				//Changes made by Rahul P. on 27-Sep-2023 [Start] pass ENTITY_TYPE='R'
				//pstmt1.setString(1,"C");
				pstmt1.setString(1,"R");
				//Changes made by Rahul P. on 27-Sep-2023 [End]
				pstmt1.setString(2, entitycode);
				pstmt1.setString(3, contactPers);
				pstmt1.setString(4, contactPersName);
				pstmt1.setString(5, MobileNos);
				int insertentity = pstmt1.executeUpdate();
				System.out.println("inser into entity_contact =["+insertentity+"]");
				pstmt1.clearParameters();
				if(insertentity > 0)
				{
					System.out.println("Inserted into entity_contact from team =["+insertentity+"]");
				}
			}
			if( pstmt1 !=null )
			{
				pstmt1.close();
				pstmt1 = null;
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); 

		}
	}
 	//Added by Bhagyashri t for team subform add [W21KJOH015][END]
	//Added by bhagyashri For Lifescan Coaching issue[18/05/2022]start
	private String generateCAStrgcode( Connection conn,String activity) throws ITMException
	{
		String uniqueKey = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			System.out.println("RealTimeReportPos : Generating Primary Key CA activity...........");
			String nextSeq = "";
			String tempScCode = "0000000000";
			String keyStringQuery = "SELECT dr_coaching_act_seq.nextval AS NEXT_SEQ FROM DUAL";
			pstmt = conn.prepareStatement(keyStringQuery);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				nextSeq = rs.getString("NEXT_SEQ");
			}
			//System.out.println("Primary Key CA activity..."+nextSeq);
			tempScCode = tempScCode + nextSeq;
			//System.out.println("Primary Key CA activity tempScCode::"+tempScCode);
			uniqueKey = activity + tempScCode.substring(tempScCode.length()-8);
			//System.out.println("Primary Key CA activity uniqueKey::"+uniqueKey);
			rs.close();	rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception exp)
		{
			System.out.println("Exception : RealTimeReportPos :generateCaactCode :==>\n");
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception : RealTimeReportPos :getUniqueKey :finally==>");
				throw new ITMException(e);
			}
		}
		System.out.println("Generated Primary Key CA strgcode :"+uniqueKey);
		return uniqueKey;
	}
	//Added by bhagyashri For Lifescan Coaching issue[18/05/2022]End
	private String executepostSaveRec(Document dom,String invoiceTranId,String dcrDate, String salesPers,String xtraParams, Connection conn)throws RemoteException,ITMException
	{
		System.out.println("executepostSaveRec method ------");
		HashMap hashMap = new HashMap(); 
		String lineNo = "";
		String dcrId="";
		String tranSer = "S-DISS";
		String line = "";
		String siteCode = "", itemCode = "", quantity = "", locCode = "", lotNo = "", lotSl = "";
		DistStkUpd distStkUpd = null; 
		String updateStatus = "",tranId = "";
		String formNo=""; 
		String updateFlag="";
		ResultSet rs = null; 
		PreparedStatement pstmt = null;
		ResultSet rs1 = null; 
		PreparedStatement pstmt1 = null;
		String resString="";
		
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		int noOfChilds = 0;
		try
		{	
		/*	String formLineNo = getFormNo("strg_meet_dcr_realtime_wiz", "invoice", conn);
			//String invoiceTranId = checkNull(genericUtility.getColumnValue("tran_id", dom, lineNo));
			System.out.println("invoiceTranId===[ "+invoiceTranId);
		
			parentList = dom.getElementsByTagName("Detail"+ formLineNo);
			int parentNodeListLength = parentList.getLength();

			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
										
					String eventType = checkNull(genericUtility.getColumnValue( "tran_id" , dom ,formLineNo));
					System.out.println("eventType ===== { "+eventType);
					String quantit1y = genericUtility.getColumnValueFromNode("tran_id", parentNode);
					System.out.println("quantit1y ===== { "+quantit1y);
					
				}
			}*/
			
			
			ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
			String loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSite");

			String siteSql="SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE = ?";
			pstmt = conn.prepareStatement(siteSql);
			pstmt.setString(1,salesPers);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				loginSite=checkNull(rs.getString("EMP_SITE"));
			}
			if (rs != null)
			{
				rs.close();
				rs = null ;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null ;
			}
			
			String sql = "select item_code, quantity,TRAN_ID,LINE_NO from strg_meet_invoice WHERE TRAN_ID = ? ";	
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,invoiceTranId);
			//pstmt.setString(2,lineNo);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				itemCode	= checkNull(rs.getString("item_code"));
				/*locCode		= rs.getString("LOC_CODE");
				lotNo		= rs.getString("LOT_NO"); 
				lotSl		= rs.getString("LOT_SL");*/
				quantity	= checkNull(rs.getString("quantity"));
				tranId	= checkNull(rs.getString("TRAN_ID"));
				lineNo	= checkNull(rs.getString("LINE_NO"));
				
				
				String stockSql="SELECT LOT_NO,LOT_SL FROM STOCK WHERE SITE_CODE= ? AND ITEM_CODE= ? AND LOC_CODE = ?";
				pstmt1 = conn.prepareStatement(stockSql);
				pstmt1.setString(1,loginSite);
				pstmt1.setString(2,itemCode);
				pstmt1.setString(3,salesPers);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					lotNo=rs1.getString("LOT_NO");
					lotSl=rs1.getString("LOT_SL");
				}
				if (rs1 != null)
				{
					rs1.close();
					rs1 = null ;
				}
				if (pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null ;
				}
				if(lotNo.trim().length() == 0)
				{
					lotNo=" ";
				}
				if(lotSl.trim().length() == 0)
				{
					lotSl=" ";
				}	
				
				line = "    "+lineNo.trim();
				hashMap.put("tran_date", new java.sql.Date(System.currentTimeMillis()));			
				hashMap.put("ref_ser",tranSer);
				hashMap.put("ref_id", tranId);
				hashMap.put("ref_line", line.substring(line.length()-4));
				hashMap.put("item_code", itemCode);
				hashMap.put("site_code", loginSite);
				hashMap.put("loc_code",salesPers);
				hashMap.put("lot_no",lotNo);
				hashMap.put("lot_sl",lotSl);
				hashMap.put("alloc_qty", new Double(quantity.trim().length() == 0?"0":quantity));
				hashMap.put("chg_win","w_strg_meet_dcr_realtime_wiz");

				hashMap.put("chg_user", genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
				hashMap.put("chg_term", genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));
				BaseLogger.log("3", getUserInfo(), null,  "Calling DistStkUpdEJB.....");
				System.out.println("hashMap pos save ..........."+hashMap);
				distStkUpd = new DistStkUpd();
				if (distStkUpd.updAllocTrace(hashMap, conn) > 0)
				{	
					System.out.println("if ------");
					BaseLogger.log("3", getUserInfo(), null,  "distStkUpd.UpdAllocTrace(HashMap, Connection) : Sucessuful!");
				}
				else
				{
					System.out.println("else ------");						
				}
				distStkUpd = null;
				
				double stockQty=0;
				String sqlSelect = "SELECT (QUANTITY-ALLOC_QTY) AS QUANTITY FROM STOCK " +
						  "WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ?  AND LOT_NO = ? AND LOT_SL = ?";
				pstmt1 = conn.prepareStatement(sqlSelect);
				pstmt1.setString(1,itemCode);
				pstmt1.setString(2,loginSite);
				pstmt1.setString(3,salesPers);
				pstmt1.setString(4,lotNo);
				pstmt1.setString(5,lotSl);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					stockQty=rs1.getDouble("QUANTITY");
				}
				if (rs1 != null)
				{
					rs1.close();
					rs1 = null ;
				}
				if (pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null ;
				}
				System.out.println("stockQty :::="+stockQty);
				if(stockQty < 0 )
				{
					System.out.println("inside validation");
					resString = itmDBAccessLocal.getErrorString( "item_code", "VTINVTRN", salesPers );
					return resString;
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("3", getUserInfo(), null,  "Exception : AdjIssPosEJB : actionHandler :" +e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null ;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null ;
				}
				
			}
			catch(Exception e1)
			{}
		}
		return resString;
	}
	public String getFormNo(String objName, String formName, Connection connectionObject) throws ITMException
	{
		//Statement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String formNo = "";
		try
		{
			//String sql = "SELECT FORM_NO FROM OBJ_FORMS WHERE WIN_NAME = '"+"w_"+objName+"'AND FORM_NAME = '"+formName+"'";
			String winName = "w_"+objName;
			System.out.println("Window name is::"+winName);
			String sql = "SELECT FORM_NO FROM OBJ_FORMS WHERE WIN_NAME = ? AND FORM_NAME = ?";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1,winName);
			pstmt.setString(2, formName);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				formNo = checkNull(rs.getString("FORM_NO"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		return formNo;
	}
}