/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MapViewLocal;
import ibase.webitm.ejb.MapViewRemote;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class MapViewEJB
extends ValidatorEJB
implements MapViewRemote,
MapViewLocal {
    @Override
    public String getMapData(String mapXmlData, String xtraParams) throws ITMException {
        String returnMapData;
        block55: {
            BaseLogger.log("2", null, null, "MapViewEJB : getData Called ...");
            returnMapData = "";
            Connection conn = null;
            Statement pstmt = null;
            ResultSet rs = null;
            String transDB = null;
            E12GenericUtility genericUtility = new E12GenericUtility();
            try {
                AppConnectParm appConnect = new AppConnectParm();
                InitialContext ctx = new InitialContext(appConnect.getProperty());
                String objName = this.getAttribValue(mapXmlData, "1", "objName");
                Document dom = genericUtility.parseString(mapXmlData);
                String salesPers = genericUtility.getColumnValue("sales_pers", dom, "1", "1");
                String fromDate = genericUtility.getColumnValue("from_date", dom, "1", "1");
                String toDate = genericUtility.getColumnValue("to_date", dom, "1", "1");
                String mgrCode = genericUtility.getColumnValue("report_to", dom, "1", "1");
                String showRouteFlag = genericUtility.getColumnValue("show_travel_path", dom, "1", "1");
                String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
                String empCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
                String userType = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "userType");
                salesPers = E12GenericUtility.checkNull(salesPers);
                fromDate = E12GenericUtility.checkNull(fromDate);
                toDate = E12GenericUtility.checkNull(toDate);
                mgrCode = E12GenericUtility.checkNull(mgrCode);
                userId = E12GenericUtility.checkNull(userId);
                empCode = E12GenericUtility.checkNull(empCode);
                showRouteFlag = E12GenericUtility.checkNull(showRouteFlag);
                userType = "admin_route_map".equalsIgnoreCase(objName) ? "ADMIN" : userType;
                BaseLogger.log("3", null, null, "B4 userType[" + userType + "]userId [" + userId + "]empCode [" + empCode + "] mgrCode [" + mgrCode + "]fromDate [" + fromDate + "] toDate [" + toDate + "] salesPers [" + salesPers + "] showRouteFlag[" + showRouteFlag + "]");
                if ("ADMIN".equalsIgnoreCase(userType)) {
                    empCode = mgrCode;
                }
                ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
                CommonDBAccessEJB dbAccessRemote = new CommonDBAccessEJB();
                UserInfoBean userInfo = dbAccessRemote.createUserInfo(userId);
                if ("ADMIN".equalsIgnoreCase(userType) && mgrCode.length() == 0) {
                    String string = returnMapData = itmDBAccess.getErrorString("report_to", "INVMAPMGR", userId, userInfo);
                    return string;
                }
                if (salesPers.length() == 0) {
                    String string = returnMapData = itmDBAccess.getErrorString("sales_pers", "INVMAPUSER", userId, userInfo);
                    return string;
                }
                if (fromDate.length() == 0) {
                    String string = returnMapData = itmDBAccess.getErrorString("from_date", "INVMAPDATE", userId, userInfo);
                    return string;
                }
                if (toDate.length() == 0) {
                    String string = returnMapData = itmDBAccess.getErrorString("to_date", "INVMAPDATE", userId, userInfo);
                    return string;
                }
                SimpleDateFormat sdfFormat = new SimpleDateFormat(this.getApplDateFormat());
                java.util.Date dateFrom = sdfFormat.parse(fromDate);
                java.util.Date dateTo = sdfFormat.parse(toDate);
                long difference = dateTo.getTime() - dateFrom.getTime() + 86400000L;
                float daysBetween = difference / 86400000L;
                BaseLogger.log("3", userInfo, null, "Number of Days between dates: " + daysBetween);
                if (daysBetween > 7.0f) {
                    returnMapData = itmDBAccess.getErrorString("sales_pers", "INVMAPDAYS", userId);
                    BaseLogger.log("3", userInfo, null, "Days are exceded[" + returnMapData + "]");
                    String string = returnMapData;
                    return string;
                }
                try {
                    JSONObject routeJSONObj;
                    String salesPersCsv = this.getFormattedCSV(salesPers);
                    fromDate = genericUtility.getValidDateString(fromDate, genericUtility.getDispDateFormat(), genericUtility.getApplDateFormat());
                    toDate = genericUtility.getValidDateString(toDate, genericUtility.getDispDateFormat(), genericUtility.getApplDateFormat());
                    BaseLogger.log("3", userInfo, null, "objName[" + objName + "]After fromDate [" + fromDate + "] toDate [" + toDate + "] salesPersCsv [" + salesPersCsv + "] ");
                    String sql1 = " SELECT SC.FIRST_NAME ||' '|| SC.LAST_NAME  AS DOCTOR_NAME, SM.STRG_CODE AS DOCTOR_CODE, LOC.DESCR AS DOCTOR_LOCALITY, SM.LOCALITY_CODE AS LOCALITY_CODE, SM.EVENT_DATE AS VISIT_DATE, SM.EVENT_TIME_START AS VISIT_TIME, SM.EVENT_TIME_END AS VISIT_TIME_END, SM.SALES_PERS AS SALES_PERS, SP.SP_NAME AS SP_NAME, SM.ADD_GEOPOS AS ADD_GEOPOS, SM.CHG_GEOPOS AS CHG_GEOPOS, DENSE_RANK() OVER (ORDER BY SM.EVENT_DATE,SM.ADD_GEOPOS ASC) AS MARKER, ST.ORDER_OF_VISIT AS ORDER_OF_VISIT FROM STRG_MEET SM LEFT OUTER JOIN STRG_CUSTOMER SC ON SM.STRG_CODE = SC.SC_CODE, SALES_PERS SP LEFT OUTER JOIN EMPLOYEE EMP  ON SP.SALES_PERS = EMP.EMP_CODE, LOCALITY LOC ,SPRS_TRAVEL ST WHERE SM.SALES_PERS = SP.SALES_PERS AND SC.LOCALITY_CODE = LOC.LOCALITY_CODE  AND SM.SALES_PERS IN ( " + salesPersCsv + " ) AND SM.EVENT_DATE >= ? AND SM.EVENT_DATE <= ? " + " AND SM.ADD_GEOPOS IS NOT NULL AND( ( EMP.EMP_CODE = SM.SALES_PERS AND EMP.REPORT_TO = ? ) OR ( SM.SALES_PERS = ? ) ) " + " AND SM.SALES_PERS =  ST.SALES_PERS AND SM.EVENT_DATE = ST.TRAVEL_DATE AND SM.LOCALITY_CODE = ST.LOCALITY_CODE" + " ORDER BY SM.SALES_PERS, SM.EVENT_DATE, TO_CHAR(TO_DATE (SM.EVENT_TIME_START, 'HH:MI AM'),'HH24:MI:SS'), TO_CHAR(TO_DATE (SM.EVENT_TIME_END, 'HH:MI AM'),'HH24:MI:SS'),ST.ORDER_OF_VISIT";
                    ConnDriver connDriver = new ConnDriver();
                    transDB = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "transDB");
                    BaseLogger.log("3", userInfo, null, "getData..sql[" + sql1 + "]transDB..." + transDB);
                    conn = connDriver.getConnectDB(transDB);
                    pstmt = conn.prepareStatement(sql1);
                    fromDate = genericUtility.getValidDateString(fromDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
                    pstmt.setDate(1, Date.valueOf(fromDate));
                    toDate = genericUtility.getValidDateString(toDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
                    pstmt.setDate(2, Date.valueOf(toDate));
                    pstmt.setString(3, empCode);
                    pstmt.setString(4, empCode);
                    LinkedHashMap<String, String> teamMap = new LinkedHashMap<String, String>();
                    LinkedHashMap<String, String> geoPosGrpMap = new LinkedHashMap<String, String>();
                    LinkedHashMap<String, JSONArray> geoPosDetailMap = new LinkedHashMap<String, JSONArray>();
                    LinkedHashMap<String, JSONArray> geoPosRouteMap = new LinkedHashMap<String, JSONArray>();
                    LinkedHashMap<String, String> salesPersonMap = new LinkedHashMap<String, String>();
                    LinkedHashMap<String, String> localityMap = new LinkedHashMap<String, String>();
                    LinkedHashMap<String, String> orderOfVisitMap = new LinkedHashMap<String, String>();
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String markerID = E12GenericUtility.checkNull(rs.getString("MARKER"));
                        String addGeoPos = E12GenericUtility.checkNull(rs.getString("ADD_GEOPOS"));
                        String chgGeoPos = E12GenericUtility.checkNull(rs.getString("CHG_GEOPOS"));
                        String scName = E12GenericUtility.checkNull(rs.getString("DOCTOR_NAME"));
                        String scCode = E12GenericUtility.checkNull(rs.getString("DOCTOR_CODE"));
                        String localityDesc = E12GenericUtility.checkNull(rs.getString("DOCTOR_LOCALITY"));
                        String localityCode = E12GenericUtility.checkNull(rs.getString("LOCALITY_CODE"));
                        String spName = E12GenericUtility.checkNull(rs.getString("SP_NAME"));
                        String spCode = E12GenericUtility.checkNull(rs.getString("SALES_PERS"));
                        String orderOfVisit = E12GenericUtility.checkNull(rs.getString("ORDER_OF_VISIT"));
                        Date visitDate = rs.getDate("VISIT_DATE");
                        String eventDate = genericUtility.getValidDateString(visitDate, genericUtility.getApplDateFormat());
                        String visitTime = E12GenericUtility.checkNull(rs.getString("VISIT_TIME"));
                        String visitTimeEnd = E12GenericUtility.checkNull(rs.getString("VISIT_TIME_END"));
                        String geo_position = chgGeoPos.trim().length() > 0 ? chgGeoPos : addGeoPos;
                        String mapKey = String.valueOf(eventDate) + ":" + localityCode + ":" + geo_position;
                        StringBuffer detailXML = new StringBuffer();
                        JSONArray jsonDetailsArray = (JSONArray)((HashMap)geoPosDetailMap).get(geo_position);
                        if (jsonDetailsArray == null) {
                            jsonDetailsArray = new JSONArray();
                        }
                        detailXML.append("<sp_name>").append("<![CDATA[" + spName + "]]>").append("</sp_name>");
                        detailXML.append("<sales_pers>").append("<![CDATA[" + spCode + "]]>").append("</sales_pers>");
                        detailXML.append("<Detail>");
                        detailXML.append("<sc_name>").append("<![CDATA[" + scName + "]]>").append("</sc_name>");
                        detailXML.append("<sc_code>").append("<![CDATA[" + scCode + "]]>").append("</sc_code>");
                        if (mapKey != null && !localityMap.containsKey(mapKey)) {
                            detailXML.append("<locality_desc>").append("<![CDATA[" + localityDesc + "]]>").append("</locality_desc>");
                            detailXML.append("<locality_code>").append("<![CDATA[" + localityCode + "]]>").append("</locality_code>");
                            detailXML.append("<visit_date>").append("<![CDATA[" + eventDate + "]]>").append("</visit_date>");
                            localityMap.put(mapKey, localityCode);
                        } else {
                            detailXML.append("<locality_desc>").append("<![CDATA[]]>").append("</locality_desc>");
                            detailXML.append("<locality_code>").append("<![CDATA[]]>").append("</locality_code>");
                            detailXML.append("<visit_date>").append("<![CDATA[]]>").append("</visit_date>");
                        }
                        detailXML.append("<visit_time>").append("<![CDATA[" + visitTime + "]]>").append("</visit_time>");
                        detailXML.append("<visit_time_end>").append("<![CDATA[" + visitTimeEnd + "]]>").append("</visit_time_end>");
                        detailXML.append("<add_geopos>").append("<![CDATA[" + addGeoPos + "]]>").append("</add_geopos>");
                        detailXML.append("<chg_geopos>").append("<![CDATA[" + chgGeoPos + "]]>").append("</chg_geopos>");
                        detailXML.append("</Detail>");
                        JSONObject detailObj = new JSONObject();
                        detailObj.put("visit_date", (Object)eventDate);
                        detailObj.put("markerInfoXml", (Object)detailXML.toString());
                        jsonDetailsArray.put((Object)detailObj);
                        geoPosDetailMap.put(geo_position, jsonDetailsArray);
                        geoPosGrpMap.put(geo_position, markerID);
                        salesPersonMap.put(geo_position, spCode);
                        orderOfVisitMap.put(geo_position, orderOfVisit);
                        JSONArray jsonRoutesArray = (JSONArray)((HashMap)geoPosRouteMap).get(eventDate);
                        if (jsonRoutesArray == null) {
                            jsonRoutesArray = new JSONArray();
                        }
                        JSONObject routeObj = new JSONObject();
                        routeObj.put("geo_position", (Object)geo_position);
                        routeObj.put("marker_color", (Object)("pinColor" + markerID));
                        jsonRoutesArray.put((Object)routeObj);
                        geoPosRouteMap.put(eventDate, jsonRoutesArray);
                        teamMap.put(spCode, spName);
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    if (geoPosDetailMap.isEmpty()) {
                        returnMapData = itmDBAccess.getErrorString("sales_pers", "MAPDATNULL", userId);
                        BaseLogger.log("3", userInfo, null, "No Map Data Found[" + returnMapData + "]");
                        break block55;
                    }
                    JSONArray visitObjArray = new JSONArray();
                    for (String geoPosition : ((HashMap)geoPosDetailMap).keySet()) {
                        JSONArray jsonDetailsArray = (JSONArray)((HashMap)geoPosDetailMap).get(geoPosition);
                        JSONObject respJSONObj = new JSONObject();
                        respJSONObj.put("geo_position", (Object)geoPosition);
                        respJSONObj.put("sales_person", ((HashMap)salesPersonMap).get(geoPosition));
                        respJSONObj.put("order_of_visit", ((HashMap)orderOfVisitMap).get(geoPosition));
                        respJSONObj.put("disp_locality", (Object)"yes");
                        respJSONObj.put("marker_color", (Object)("pinColor" + (String)((HashMap)geoPosGrpMap).get(geoPosition)));
                        respJSONObj.put("details", (Object)jsonDetailsArray);
                        BaseLogger.log("3", userInfo, null, "geoPosition[" + geoPosition + "]respJSONObj :==>" + respJSONObj);
                        visitObjArray.put((Object)respJSONObj);
                    }
                    JSONArray routeObjArray = new JSONArray();
                    for (String eventDate : ((HashMap)geoPosRouteMap).keySet()) {
                        JSONArray jsonRoutesArray = (JSONArray)((HashMap)geoPosRouteMap).get(eventDate);
                        routeJSONObj = new JSONObject();
                        routeJSONObj.put("visit_date", (Object)eventDate);
                        routeJSONObj.put("routes", (Object)jsonRoutesArray);
                        BaseLogger.log("3", userInfo, null, "eventDate[" + eventDate + "]respJSONObj :==>" + routeJSONObj);
                        routeObjArray.put((Object)routeJSONObj);
                    }
                    if ("Y".equalsIgnoreCase(showRouteFlag)) {
                        try {
                            String sqlStr = "SELECT USER_ID, GEOPOS, DATETIME FROM GEOPOS WHERE USER_ID IN ( SELECT TRIM(CODE) FROM USERS WHERE EMP_CODE IN ( " + salesPersCsv + " )) " + "AND DATETIME >= ? AND DATETIME <= ? ORDER BY USER_ID, DATETIME";
                            pstmt = conn.prepareStatement(sqlStr);
                            pstmt.setDate(1, Date.valueOf(fromDate));
                            SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
                            SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getDBDateFormat());
                            java.util.Date date = sdf1.parse(toDate);
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(date);
                            calendar.add(5, 1);
                            java.util.Date nextDay = calendar.getTime();
                            String nextDate = sdf.format(nextDay);
                            nextDate = genericUtility.getValidDateString(nextDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
                            BaseLogger.log("3", userInfo, null, "toDate : [" + toDate + "], nextDate : [" + nextDate + "]");
                            pstmt.setDate(2, Date.valueOf(nextDate));
                            rs = pstmt.executeQuery();
                            JSONObject salesPersJSONObj = new JSONObject();
                            while (rs.next()) {
                                JSONArray gepPosArr;
                                String salesPersVal = E12GenericUtility.checkNull(rs.getString("USER_ID"));
                                String geoPosVal = E12GenericUtility.checkNull(rs.getString("GEOPOS"));
                                if ("0, 0".equalsIgnoreCase(geoPosVal.trim())) continue;
                                if (salesPersJSONObj.has(salesPersVal)) {
                                    gepPosArr = (JSONArray)salesPersJSONObj.get(salesPersVal);
                                    String previousVal = gepPosArr.getString(gepPosArr.length() - 1);
                                    if (!previousVal.equalsIgnoreCase(geoPosVal)) {
                                        gepPosArr.put((Object)geoPosVal);
                                    }
                                    salesPersJSONObj.put(salesPersVal, (Object)gepPosArr);
                                    continue;
                                }
                                gepPosArr = new JSONArray();
                                gepPosArr.put((Object)geoPosVal);
                                salesPersJSONObj.put(salesPersVal, (Object)gepPosArr);
                            }
                            routeObjArray.put((Object)salesPersJSONObj);
                            rs.close();
                            rs = null;
                            pstmt.close();
                            pstmt = null;
                        }
                        catch (Exception e) {
                            BaseLogger.log("3", userInfo, null, "Exception to get geopos data:::[" + e.getMessage() + "]");
                            rs.close();
                            rs = null;
                            pstmt.close();
                            pstmt = null;
                        }
                    }
                    JSONArray lastVisitGeoPosArray = new JSONArray();
                    for (String spCode : ((HashMap)teamMap).keySet()) {
                        CommonDBAccessEJB commonDBAccess = new CommonDBAccessEJB();
                        String lastVisitGeoPos = commonDBAccess.getGeoPosition(spCode, "2");
                        BaseLogger.log("3", userInfo, null, "spCode[" + spCode + "]lastVisitGeoPos[" + lastVisitGeoPos + "]");
                        JSONObject geoPosJSONObj = new JSONObject();
                        geoPosJSONObj.put("sales_pers", (Object)spCode);
                        geoPosJSONObj.put("sp_name", ((HashMap)teamMap).get(spCode));
                        geoPosJSONObj.put("last_geo_pos", (Object)lastVisitGeoPos);
                        if (salesPers.equalsIgnoreCase(userId)) continue;
                        lastVisitGeoPosArray.put((Object)geoPosJSONObj);
                    }
                    routeJSONObj = new JSONObject();
                    routeJSONObj.put("VISIT_INFO", (Object)visitObjArray);
                    routeJSONObj.put("ROUTE_INFO", (Object)routeObjArray);
                    routeJSONObj.put("LAST_GEO_POS_INFO", (Object)lastVisitGeoPosArray);
                    returnMapData = routeJSONObj.toString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                    }
                    catch (Exception ex) {
                        BaseLogger.log("0", null, null, "Exception MapViewEJB getData:" + ex.getMessage());
                        ex.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception MapViewEJB getData:" + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        return returnMapData;
    }

    private String getFormattedCSV(String commaSepString) {
        StringBuffer formattedString = new StringBuffer();
        if (!"".equalsIgnoreCase(commaSepString)) {
            String[] attachmentArr = commaSepString.split(",");
            int len = attachmentArr.length;
            int cntr = 0;
            while (cntr < len) {
                formattedString.append("'").append(E12GenericUtility.checkNull(attachmentArr[cntr])).append("'");
                if (cntr < len - 1) {
                    formattedString.append(",");
                }
                ++cntr;
            }
        }
        if ("".equalsIgnoreCase(formattedString.toString())) {
            formattedString.append("''");
        }
        BaseLogger.log("2", null, null, "getFormattedCSV :[" + formattedString.toString() + "]");
        return formattedString.toString();
    }

    private String getAttribValue(String formDetailXml, String formNo, String attribStr) {
        String attribValue = "";
        try {
            Document detailDom = new E12GenericUtility().parseString(formDetailXml);
            NodeList detailDomList = detailDom.getElementsByTagName("Detail" + formNo);
            Node detailNode = detailDomList.item(0);
            attribValue = this.getAttribValue(detailNode, attribStr);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getAttribValue :" + e.getMessage());
        }
        return attribValue;
    }

    private String getAttribValue(Node detailNode, String attribStr) {
        String attribValue = "";
        try {
            Node attribNode;
            if (detailNode != null && detailNode.getAttributes() != null && (attribNode = detailNode.getAttributes().getNamedItem(attribStr)) != null) {
                attribValue = this.checkNull(attribNode.getNodeValue());
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getAttribValue :" + e.getMessage());
        }
        return attribValue;
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    @Override
    public String valMapData(String mapXmlData, String xtraParams) throws ITMException {
        return "";
    }
}

