/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility.wiz;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wiz.Column;
import ibase.webitm.utility.wiz.Entities;
import ibase.webitm.utility.wiz.Form;
import ibase.webitm.utility.wiz.GroupBox;
import ibase.webitm.utility.wiz.TextObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class TransactionCoreModel
implements Serializable {
    private HashMap formNoMetaDataMap = null;
    private HashMap prevFormNoDataMap = null;
    private HashMap currFormNoDataMap = null;
    private HashMap formNoObjectMap = null;
    private HashMap objDetailMap = null;
    int transInfoSize = 3;
    boolean isGridStructure = false;
    public static HashMap formMetaDataMap = null;

    public TransactionCoreModel() throws ITMException {
        try {
            this.formNoMetaDataMap = new HashMap();
            this.currFormNoDataMap = new HashMap();
            this.prevFormNoDataMap = new HashMap();
            this.formNoObjectMap = new HashMap();
            formMetaDataMap = new HashMap();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :constructor :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public void loadMetaData(String transName, String transXmlStr, String objType) throws ITMException {
    }

    public String loadXMLData(String xmlDataFileName) throws ITMException {
        return null;
    }

    public Object getCurrData(String formNo, int recordNo, String fieldName) throws ITMException {
        Object dataObj = null;
        try {
            Column colObj = this.getColumn(formNo, fieldName);
            ArrayList rowList = this.getRowList(this.currFormNoDataMap, formNo, recordNo);
            if (rowList != null && colObj != null) {
                dataObj = rowList.get(colObj.getSQLPos() + this.transInfoSize);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getData :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return dataObj;
    }

    public Object getCurrData(String formNo, String domid, String fieldName) throws ITMException {
        Object dataObj = null;
        try {
            Column colObj = this.getColumn(formNo, fieldName);
            ArrayList rowList = this.getRowList(this.currFormNoDataMap, formNo, domid);
            if (rowList != null && colObj != null) {
                dataObj = rowList.get(colObj.getSQLPos() + this.transInfoSize);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getData :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return dataObj;
    }

    public Object getOriginalData(String formNo, int recordNo, String fieldName) throws ITMException {
        Object dataObj = null;
        return dataObj;
    }

    public Object getPrevData(String formNo, int recordNo, String fieldName) throws ITMException {
        Object dataObj = null;
        try {
            Column colObj = this.getColumn(formNo, fieldName);
            ArrayList rowList = this.getRowList(this.prevFormNoDataMap, formNo, recordNo);
            if (rowList != null && colObj != null) {
                dataObj = rowList.get(colObj.getSQLPos() + this.transInfoSize);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getNewData :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return dataObj;
    }

    protected boolean addNewForm(String formNo, Form frmObj) throws ITMException {
        boolean frmCreated = false;
        try {
            if (!this.formNoObjectMap.containsKey(formNo)) {
                this.formNoObjectMap.put(formNo, frmObj);
                this.formNoMetaDataMap.put(formNo, new HashMap());
                this.currFormNoDataMap.put(formNo, new ArrayList());
                this.prevFormNoDataMap.put(formNo, new ArrayList());
                formMetaDataMap.put(formNo, frmObj);
                frmCreated = true;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :addNewForm :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return frmCreated;
    }

    public void setCurrData(String formNo, int recordNo, String fieldName, Object fieldValue) throws ITMException {
        try {
            Column colObj = this.getColumn(formNo, fieldName);
            ArrayList rowList = this.getRowList(this.currFormNoDataMap, formNo, recordNo);
            if (rowList != null && colObj != null) {
                rowList.set(colObj.getSQLPos() + this.transInfoSize, fieldValue);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :setCurrData :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public void setPrevData(String formNo, int recordNo, String fieldName, Object fieldValue) throws ITMException {
        try {
            Column colObj = this.getColumn(formNo, fieldName);
            ArrayList rowList = this.getRowList(this.prevFormNoDataMap, formNo, recordNo);
            if (rowList != null && colObj != null) {
                rowList.set(colObj.getSQLPos() + this.transInfoSize, fieldValue);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :setPrevData :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public HashMap getRow(String formNo, int rowNo) throws ITMException {
        HashMap colLogicalNameDataMap = null;
        try {
            if (this.formNoMetaDataMap != null) {
                HashMap colLogicalNameObjMap = (HashMap)this.formNoMetaDataMap.get(formNo);
                ArrayList rowList = this.getRowList(this.currFormNoDataMap, formNo, rowNo);
                if (colLogicalNameObjMap != null && rowList != null) {
                    for (String colLogicalName : colLogicalNameObjMap.keySet()) {
                        if (!colLogicalNameObjMap.get(colLogicalName).getClass().isInstance(new Column())) continue;
                        Column colObj = (Column)colLogicalNameObjMap.get(colLogicalName);
                        if (colLogicalNameDataMap == null) {
                            colLogicalNameDataMap = new HashMap();
                        }
                        colLogicalNameDataMap.put(colLogicalName, rowList.get(colObj.getSQLPos() + this.transInfoSize));
                    }
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getRow :==>" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return colLogicalNameDataMap;
    }

    public HashMap getRow(String formNo, String rowIdentifier) throws ITMException {
        HashMap colLogicalNameDataMap = null;
        try {
            int rowNo = this.getRowNoForIdentifier(formNo, rowIdentifier);
            if (rowNo != -1) {
                colLogicalNameDataMap = this.getRow(formNo, rowNo);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getRow :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return colLogicalNameDataMap;
    }

    public HashMap getRow(String formNo, int rowNo, boolean isChangeUpdated) throws ITMException {
        HashMap colLogicalNameDataMap = null;
        try {
            if (this.formNoMetaDataMap != null) {
                HashMap colLogicalNameObjMap = (HashMap)this.formNoMetaDataMap.get(formNo);
                ArrayList rowList = this.getRowList(this.currFormNoDataMap, formNo, rowNo);
                if (colLogicalNameObjMap != null && rowList != null) {
                    for (String colLogicalName : colLogicalNameObjMap.keySet()) {
                        Column colObj;
                        if (!colLogicalNameObjMap.get(colLogicalName).getClass().isInstance(new Column()) || (colObj = (Column)colLogicalNameObjMap.get(colLogicalName)).isChangeUpdated() != isChangeUpdated) continue;
                        if (colLogicalNameDataMap == null) {
                            colLogicalNameDataMap = new HashMap();
                        }
                        colLogicalNameDataMap.put(colLogicalName, rowList.get(colObj.getSQLPos() + this.transInfoSize));
                    }
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getRow :==>" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return colLogicalNameDataMap;
    }

    public void setAllIsChangeUpdated(String formNo, boolean flag) throws ITMException {
        try {
            HashMap colLogicalNameObjMap;
            if (this.formNoMetaDataMap != null && (colLogicalNameObjMap = (HashMap)this.formNoMetaDataMap.get(formNo)) != null) {
                for (String colLogicalName : colLogicalNameObjMap.keySet()) {
                    if (!colLogicalNameObjMap.get(colLogicalName).getClass().isInstance(new Column())) continue;
                    Column colObj = (Column)colLogicalNameObjMap.get(colLogicalName);
                    colObj.setIsChangeUpdated(flag);
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :setAllIsChangeUpdated :==>" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    protected int insertRow(String formNo, int domID, char status, char updateFlag, HashMap fieldNameValueMap) throws ITMException {
        int rowNo = -1;
        HashMap colLogicalNameObjMap = null;
        try {
            if (fieldNameValueMap != null && this.formNoMetaDataMap != null) {
                ArrayList<Object> newRecordList = new ArrayList<Object>();
                int ctr = 0;
                while (ctr < fieldNameValueMap.size() + this.transInfoSize) {
                    newRecordList.add(null);
                    ++ctr;
                }
                colLogicalNameObjMap = (HashMap)this.formNoMetaDataMap.get(formNo);
                for (String colLogicalName : fieldNameValueMap.keySet()) {
                    Column colObj = (Column)colLogicalNameObjMap.get(colLogicalName);
                    if (colLogicalName.equalsIgnoreCase("barcode_input") || colObj.getSQLPos() == -1) continue;
                    newRecordList.set(colObj.getSQLPos() + this.transInfoSize, fieldNameValueMap.get(colLogicalName));
                }
                if (this.currFormNoDataMap != null) {
                    ((ArrayList)this.currFormNoDataMap.get(formNo)).add(newRecordList);
                    ((ArrayList)this.prevFormNoDataMap.get(formNo)).add(newRecordList);
                    newRecordList.set(0, new Integer(domID));
                    newRecordList.set(1, new Character(status));
                    newRecordList.set(2, new Character(updateFlag));
                    rowNo = ((ArrayList)this.currFormNoDataMap.get(formNo)).size() - 1;
                }
            }
        }
        catch (Exception e) {
            StringBuffer addnlMsgBuffer = new StringBuffer();
            addnlMsgBuffer.append("Form No. :[" + formNo + "]\n");
            addnlMsgBuffer.append("Col Logical Names :" + colLogicalNameObjMap.toString() + "\n");
            addnlMsgBuffer.append("Field Name Value Map :" + fieldNameValueMap.toString() + "\n");
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :insertRow :==>" + e.getMessage());
        }
        return rowNo;
    }

    protected void setRow(String formNo, int domId, char status, char updateFlag, HashMap fieldNameValueMap) throws ITMException {
        try {
            if (fieldNameValueMap != null && this.formNoMetaDataMap != null) {
                ArrayList<Constable> newRecordList = new ArrayList<Constable>();
                HashMap colLogicalNameObjMap = (HashMap)this.formNoMetaDataMap.get(formNo);
                int noOfRows = colLogicalNameObjMap.size() >= fieldNameValueMap.size() + this.transInfoSize ? colLogicalNameObjMap.size() : fieldNameValueMap.size() + this.transInfoSize;
                int ctr = 0;
                while (ctr < noOfRows) {
                    newRecordList.add(null);
                    ++ctr;
                }
                newRecordList.set(0, new Integer(domId));
                newRecordList.set(1, new Character(status));
                newRecordList.set(2, new Character(updateFlag));
                for (String colLogicalName : fieldNameValueMap.keySet()) {
                    Column colObj;
                    if (!colLogicalNameObjMap.containsKey(colLogicalName) || !colLogicalNameObjMap.get(colLogicalName).getClass().isInstance(new Column()) || (colObj = (Column)colLogicalNameObjMap.get(colLogicalName)) == null || colObj.getSQLPos() == -1) continue;
                    newRecordList.set(colObj.getSQLPos() + this.transInfoSize, (Constable)fieldNameValueMap.get(colLogicalName));
                }
                if (this.currFormNoDataMap != null && this.currFormNoDataMap.get(formNo) != null) {
                    int rowNo = -1;
                    ArrayList rowList = (ArrayList)this.currFormNoDataMap.get(formNo);
                    if (rowList != null && rowList.size() > 0) {
                        int rCnt = 0;
                        while (rCnt < rowList.size()) {
                            ArrayList recordList = (ArrayList)rowList.get(rCnt);
                            if (recordList != null && (Integer)recordList.get(0) == domId) {
                                rowNo = rCnt;
                                break;
                            }
                            if (recordList == null) {
                                rowNo = rCnt;
                                break;
                            }
                            ++rCnt;
                        }
                        ((ArrayList)this.currFormNoDataMap.get(formNo)).set(rowNo, newRecordList);
                        ((ArrayList)this.prevFormNoDataMap.get(formNo)).set(rowNo, newRecordList);
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException idxEx) {
            BaseLogger.log("0", null, null, "IndexOutOfBoundsException : TransactionMetaModel :setRow :==>" + idxEx.getMessage());
            idxEx.printStackTrace();
            throw new IndexOutOfBoundsException("Number of Columns in Metadata file doesn't match with SQL generated!!!");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :setRow :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    protected boolean deleteRow(String formNo, int rowNo) throws ITMException {
        boolean deleted = false;
        try {
            if (this.currFormNoDataMap != null && rowNo >= 0) {
                ArrayList recordList = (ArrayList)((ArrayList)this.currFormNoDataMap.get(formNo)).get(rowNo);
                if (((Character)recordList.get(1)).charValue() == 'N') {
                    ((ArrayList)this.currFormNoDataMap.get(formNo)).remove(rowNo);
                    ((ArrayList)this.prevFormNoDataMap.get(formNo)).remove(rowNo);
                } else if (((Character)recordList.get(1)).charValue() == 'O') {
                    recordList.set(2, new Character('D'));
                }
                deleted = true;
            }
        }
        catch (Exception e) {
            deleted = false;
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :deleteRow :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return deleted;
    }

    public boolean deleteRow(String formNo) throws ITMException {
        boolean deleted = false;
        try {
            if (this.currFormNoDataMap != null && (ArrayList)this.currFormNoDataMap.get(formNo) != null) {
                ((ArrayList)this.currFormNoDataMap.get(formNo)).clear();
                ((ArrayList)this.prevFormNoDataMap.get(formNo)).clear();
                deleted = true;
            }
        }
        catch (Exception e) {
            deleted = false;
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :deleteRow :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return deleted;
    }

    public boolean deleteAllRow() throws ITMException {
        boolean deleted = false;
        try {
            if (this.currFormNoDataMap != null) {
                int i = 1;
                while (i <= this.currFormNoDataMap.size()) {
                    if ((ArrayList)this.currFormNoDataMap.get(String.valueOf(i)) != null) {
                        ((ArrayList)this.currFormNoDataMap.get(String.valueOf(i))).clear();
                        ((ArrayList)this.prevFormNoDataMap.get(String.valueOf(i))).clear();
                    }
                    ++i;
                }
                deleted = true;
                BaseLogger.log("3", null, null, "Deleting All Rows........");
            }
        }
        catch (Exception e) {
            deleted = false;
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :deleteRow :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return deleted;
    }

    public boolean deleteRow(String formNo, String rowIdentifier) throws ITMException {
        boolean deleted = false;
        try {
            int rowNo = this.getRowNoForIdentifier(formNo, rowIdentifier);
            if (rowNo != -1) {
                this.deleteRow(formNo, rowNo);
                deleted = true;
            }
        }
        catch (Exception e) {
            deleted = false;
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :deleteRow :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return deleted;
    }

    public int getFormNos() {
        return this.currFormNoDataMap.size();
    }

    public boolean exportDataToXML(String fileName, String saveType) throws ITMException {
        boolean fileCreated = false;
        try {
            if (this.currFormNoDataMap != null) {
                File destFile = new File(fileName);
                destFile.createNewFile();
                FileOutputStream fos = new FileOutputStream(destFile);
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, CommonConstants.FILE_ENCODING));
                bw.write(this.exportDataToString(saveType));
                bw.flush();
                bw.close();
                fileCreated = true;
            }
        }
        catch (Exception e) {
            fileCreated = false;
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :exportDataToXML :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return fileCreated;
    }

    public String getFormData(String formNo, String saveType) throws ITMException {
        StringBuffer sb = new StringBuffer();
        try {
            if (this.currFormNoDataMap != null) {
                ArrayList recordList = (ArrayList)this.currFormNoDataMap.get(formNo);
                Column colObj = null;
                sb.append("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>");
                sb.append("<DocumentRoot>");
                sb.append("<description>Datawindow Root</description>");
                sb.append("<group0>");
                sb.append("<description>Group0 description</description>");
                sb.append("<Header0>");
                sb.append("<description>Header0 members</description>");
                int rowCtr = 0;
                while (rowCtr < recordList.size()) {
                    ArrayList rowList = (ArrayList)recordList.get(rowCtr);
                    String domId = "";
                    if (rowList != null) {
                        domId = rowList.get(0).toString();
                        sb.append("<Detail" + formNo);
                        sb.append(" objContext=\"" + formNo + "\" objName=\"" + CommonConstants.TRANS_INFO_NAME + "\"");
                        if (!saveType.equalsIgnoreCase("null") && saveType != null && saveType.length() > 0) {
                            sb.append(" domID=\"" + domId + "\" dbID=\"\"><attribute selected=\"N\" updateFlag=\"" + saveType + "\" status=\"N\" pkNames=\"\"/>");
                        } else {
                            sb.append(" domID=\"" + domId + "\" dbID=\"\"><attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
                        }
                        HashMap fieldValueMap = this.getRow(formNo, rowCtr);
                        ArrayList fieldNameList = this.getFieldNameSeqList(fieldValueMap, formNo, saveType);
                        int fieldNameCtr = 0;
                        while (fieldNameCtr < fieldNameList.size()) {
                            String fieldName = (String)fieldNameList.get(fieldNameCtr);
                            String fieldValueObj = "";
                            fieldValueObj = (String)fieldValueMap.get(fieldName);
                            if (fieldValueObj != null && fieldValueObj.length() > 0 && !fieldValueObj.equals(null)) {
                                if (saveType.equalsIgnoreCase("Template")) {
                                    colObj = this.getColumn(formNo, fieldName);
                                    if (colObj != null && colObj.isKey() && this.getColumn("1", colObj.getLogicalName()) != null) {
                                        sb.append("<" + fieldName + "/>");
                                    } else {
                                        sb.append("<" + fieldName + ">");
                                        sb.append("<![CDATA[" + fieldValueObj + "]]>");
                                        sb.append("</" + fieldName + ">");
                                    }
                                } else {
                                    sb.append("<" + fieldName + ">");
                                    sb.append("<![CDATA[" + fieldValueObj + "]]>");
                                    sb.append("</" + fieldName + ">");
                                }
                            } else {
                                sb.append("<" + fieldName + "/>");
                            }
                            ++fieldNameCtr;
                        }
                        sb.append("</Detail" + formNo + ">");
                    }
                    ++rowCtr;
                }
                sb.append("</Header0>");
                sb.append("</group0>");
                sb.append("</DocumentRoot>");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String exportDataToString(String saveType) throws ITMException {
        boolean fileCreated = false;
        StringBuffer sb = new StringBuffer();
        try {
            if (this.currFormNoDataMap != null) {
                sb.append("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>");
                sb.append("<DocumentRoot>");
                sb.append("<description>Datawindow Root</description>");
                sb.append("<group0>");
                sb.append("<description>Group0 description</description>");
                sb.append("<Header0>");
                sb.append("<description>Header0 members</description>");
                TreeMap tempTree = new TreeMap(this.currFormNoDataMap);
                Iterator iter = tempTree.keySet().iterator();
                Column colObj = null;
                ArrayList tempArray = new ArrayList();
                StringBuffer sb_temp = new StringBuffer();
                while (iter.hasNext()) {
                    String formNo = (String)iter.next();
                    ArrayList recordList = (ArrayList)this.currFormNoDataMap.get(formNo);
                    int rowCtr = 0;
                    while (rowCtr < recordList.size()) {
                        ArrayList rowList = (ArrayList)recordList.get(rowCtr);
                        String domId = "";
                        if (rowList != null) {
                            domId = rowList.get(0).toString();
                            sb.append("<Detail" + formNo);
                            sb.append(" objContext=\"" + formNo + "\" objName=\"" + CommonConstants.TRANS_INFO_NAME + "\" selected=\"N\"");
                            if (!saveType.equalsIgnoreCase("null") && saveType != null && saveType.length() > 0) {
                                sb.append(" domID=\"" + domId + "\" dbID=\"\"><attribute selected=\"N\" updateFlag=\"" + saveType + "\" status=\"N\" pkNames=\"\"/>");
                            } else {
                                sb.append(" domID=\"" + domId + "\" dbID=\"\"><attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
                            }
                            HashMap fieldValueMap = this.getRow(formNo, rowCtr);
                            ArrayList fieldNameList = this.getFieldNameSeqList(fieldValueMap, formNo, saveType);
                            int fieldNameCtr = 0;
                            while (fieldNameCtr < fieldNameList.size()) {
                                String fieldName = (String)fieldNameList.get(fieldNameCtr);
                                String fieldValueObj = "";
                                fieldValueObj = (String)fieldValueMap.get(fieldName);
                                if (fieldValueObj != null && fieldValueObj.length() > 0 && !fieldValueObj.equals(null)) {
                                    if (saveType.equalsIgnoreCase("Template")) {
                                        colObj = this.getColumn(formNo, fieldName);
                                        if (colObj != null && colObj.isKey() && this.getColumn("1", colObj.getLogicalName()) != null) {
                                            sb.append("<" + fieldName + "/>");
                                        } else {
                                            sb.append("<" + fieldName + ">");
                                            sb.append("<![CDATA[" + fieldValueObj + "]]>");
                                            sb.append("</" + fieldName + ">");
                                        }
                                    } else {
                                        sb.append("<" + fieldName + ">");
                                        sb.append("<![CDATA[" + fieldValueObj + "]]>");
                                        sb.append("</" + fieldName + ">");
                                    }
                                } else {
                                    sb.append("<" + fieldName + "/>");
                                }
                                ++fieldNameCtr;
                            }
                            sb.append("</Detail" + formNo + ">");
                        }
                        ++rowCtr;
                    }
                }
                sb.append("</Header0>");
                sb.append("</group0>");
                sb.append("</DocumentRoot>");
                fileCreated = true;
            }
        }
        catch (Exception e) {
            fileCreated = false;
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :exportDataToString :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return sb.toString();
    }

    public ArrayList getFieldNameSeqList(HashMap fieldValueMap, String formNo, String saveType) throws ITMException {
        ArrayList<String> fieldNameList = new ArrayList<String>();
        try {
            TreeMap<Integer, String> editableFieldNameSeqTree = new TreeMap<Integer, String>();
            Column colObj = null;
            for (String fieldName : fieldValueMap.keySet()) {
                colObj = this.getColumn(formNo, fieldName);
                if (colObj == null) continue;
                if (colObj.getTabSequence() != 0 && colObj.getTabSequence() != 32766 && colObj.getProtectedType() != 1) {
                    editableFieldNameSeqTree.put(new Integer(colObj.getTabSequence()), fieldName);
                    continue;
                }
                if (saveType.equalsIgnoreCase("Template") && colObj.getTabSequence() != 32766 && colObj.getText() != null && colObj.getText().trim().equalsIgnoreCase("")) {
                    fieldNameList.add(fieldName);
                    continue;
                }
                if (!saveType.equals("")) continue;
                fieldNameList.add(fieldName);
            }
            for (Object objKey : editableFieldNameSeqTree.keySet()) {
                if (objKey == null) continue;
                fieldNameList.add((String)editableFieldNameSeqTree.get(objKey));
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :exportDataToString :==>" + e.getMessage());
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "getFieldNameSeqList  fieldNameList  [" + fieldNameList + "] ");
        return fieldNameList;
    }

    public ArrayList getItemChangeColList(String formNo) throws ITMException {
        ArrayList<String> itemChangeColList = new ArrayList<String>();
        Object colObj = null;
        try {
            HashMap colLogicalNameObjMap;
            if (this.formNoMetaDataMap != null && (colLogicalNameObjMap = (HashMap)this.formNoMetaDataMap.get(formNo)) != null) {
                for (String colLogicalName : colLogicalNameObjMap.keySet()) {
                    if (!colLogicalNameObjMap.get(colLogicalName).getClass().isInstance(new Column()) || !((Column)colLogicalNameObjMap.get(colLogicalName)).getSrvCallOnChange()) continue;
                    itemChangeColList.add(colLogicalName);
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionCoreModel :getItemChangeColList :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return itemChangeColList;
    }

    public ArrayList getGroups(String formNo, boolean isSorted) throws ITMException {
        ArrayList grpList = null;
        try {
            HashMap logicalNameObjMap;
            if (this.formNoMetaDataMap != null && this.formNoMetaDataMap.containsKey(formNo) && (logicalNameObjMap = (HashMap)this.formNoMetaDataMap.get(formNo)) != null) {
                for (String logicalName : logicalNameObjMap.keySet()) {
                    if (!logicalNameObjMap.get(logicalName).getClass().isInstance(new GroupBox())) continue;
                    if (grpList == null) {
                        grpList = new ArrayList();
                    }
                    grpList.add(logicalNameObjMap.get(logicalName));
                }
                if (grpList != null && isSorted) {
                    grpList = this.sortGroupsByPos(grpList);
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getGroups :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return grpList;
    }

    public ArrayList getEntities(String formNo, boolean isSorted) throws ITMException {
        ArrayList entityList = null;
        try {
            HashMap logicalNameObjMap;
            if (this.formNoMetaDataMap != null && this.formNoMetaDataMap.containsKey(formNo) && (logicalNameObjMap = (HashMap)this.formNoMetaDataMap.get(formNo)) != null) {
                for (String logicalName : logicalNameObjMap.keySet()) {
                    if (logicalNameObjMap.get(logicalName).getClass().isInstance(new GroupBox())) continue;
                    if (entityList == null) {
                        entityList = new ArrayList();
                    }
                    entityList.add(logicalNameObjMap.get(logicalName));
                }
                if (entityList != null && isSorted) {
                    entityList = this.sortEntitiesByPos(entityList);
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getEntities :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return entityList;
    }

    public ArrayList getFormList() throws ITMException {
        ArrayList<String> formList = null;
        try {
            if (this.formNoObjectMap != null) {
                formList = new ArrayList<String>();
                Object[] formArray = new String[this.formNoObjectMap.size()];
                int formIndex = 0;
                Iterator iter = this.formNoObjectMap.keySet().iterator();
                while (iter.hasNext()) {
                    formArray[formIndex++] = (String)iter.next();
                }
                Arrays.sort(formArray);
                int i = 0;
                while (i < formArray.length) {
                    if (!((String)formArray[i]).equals(CommonConstants.TAX_FORM_NO)) {
                        formList.add(new String((String)formArray[i]));
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getFormList :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return formList;
    }

    public ArrayList getBrowColumnList(String formNo, boolean isSorted) throws ITMException {
        ArrayList<Column> browColList = null;
        try {
            HashMap logicalNameObjMap;
            if (this.formNoMetaDataMap != null && this.formNoMetaDataMap.containsKey(formNo) && (logicalNameObjMap = (HashMap)this.formNoMetaDataMap.get(formNo)) != null) {
                for (String logicalName : logicalNameObjMap.keySet()) {
                    Column colObj;
                    if (!logicalNameObjMap.get(logicalName).getClass().isInstance(new Column())) continue;
                    if (browColList == null) {
                        browColList = new ArrayList<Column>();
                    }
                    if ((colObj = (Column)logicalNameObjMap.get(logicalName)).getBrowPos() == -1) continue;
                    browColList.add(colObj);
                }
                if (browColList != null && isSorted) {
                    browColList = this.sortBrowColByPos(browColList);
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getBrowColumnList :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return browColList;
    }

    public boolean isItemChangeDefined(String formNo, String fieldName) throws ITMException {
        boolean isItemChange = false;
        try {
            if (fieldName != null && fieldName.startsWith("itm_default")) {
                isItemChange = fieldName.equalsIgnoreCase("itm_default") ? ((Form)this.formNoObjectMap.get(formNo)).isITMDefault() : ((Form)this.formNoObjectMap.get(formNo)).isITMDefaultEdit();
            } else {
                Column colObj = this.getColumn(formNo, fieldName);
                if (colObj != null) {
                    isItemChange = colObj.getSrvCallOnChange();
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :isItemChangeDefined :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return isItemChange;
    }

    private ArrayList sortGroupsByPos(ArrayList unSortedList) throws ITMException {
        ArrayList<GroupBox> sortedList = new ArrayList<GroupBox>(unSortedList);
        try {
            GroupBox grpBoxObj1;
            int ctr1;
            GroupBox grpBoxObj;
            int ctr = 0;
            while (ctr < sortedList.size()) {
                grpBoxObj = (GroupBox)sortedList.get(ctr);
                ctr1 = ctr;
                while (ctr1 < sortedList.size()) {
                    grpBoxObj1 = (GroupBox)sortedList.get(ctr1);
                    if (grpBoxObj1.getY() <= grpBoxObj.getY()) {
                        sortedList.set(ctr1, grpBoxObj);
                        sortedList.set(ctr, grpBoxObj1);
                        grpBoxObj = (GroupBox)sortedList.get(ctr);
                        grpBoxObj1 = (GroupBox)sortedList.get(ctr1);
                    }
                    ++ctr1;
                }
                ++ctr;
            }
            ctr = 0;
            while (ctr < sortedList.size()) {
                grpBoxObj = (GroupBox)sortedList.get(ctr);
                ctr1 = ctr;
                while (ctr1 < sortedList.size()) {
                    grpBoxObj1 = (GroupBox)sortedList.get(ctr1);
                    if (grpBoxObj.getY() == grpBoxObj1.getY() && grpBoxObj1.getX() < grpBoxObj.getX()) {
                        sortedList.set(ctr1, grpBoxObj);
                        sortedList.set(ctr, grpBoxObj1);
                        grpBoxObj = (GroupBox)sortedList.get(ctr);
                        grpBoxObj1 = (GroupBox)sortedList.get(ctr1);
                    }
                    ++ctr1;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :sortGroupsByPos :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return sortedList;
    }

    private ArrayList sortEntitiesByPos(ArrayList unSortedList) throws ITMException {
        ArrayList<Entities> sortedList = new ArrayList<Entities>(unSortedList);
        try {
            Entities entityObj1;
            int ctr1;
            Entities entityObj;
            int ctr = 0;
            while (ctr < sortedList.size()) {
                entityObj = (Entities)sortedList.get(ctr);
                ctr1 = ctr;
                while (ctr1 < sortedList.size()) {
                    entityObj1 = (Entities)sortedList.get(ctr1);
                    if (entityObj1.getY() <= entityObj.getY()) {
                        sortedList.set(ctr1, entityObj);
                        sortedList.set(ctr, entityObj1);
                        entityObj = (Entities)sortedList.get(ctr);
                        entityObj1 = (Entities)sortedList.get(ctr1);
                    }
                    ++ctr1;
                }
                ++ctr;
            }
            ctr = 0;
            while (ctr < sortedList.size()) {
                entityObj = (Entities)sortedList.get(ctr);
                ctr1 = ctr;
                while (ctr1 < sortedList.size()) {
                    entityObj1 = (Entities)sortedList.get(ctr1);
                    if (entityObj.getY() == entityObj1.getY() && entityObj1.getX() < entityObj.getX()) {
                        sortedList.set(ctr1, entityObj);
                        sortedList.set(ctr, entityObj1);
                        entityObj = (Entities)sortedList.get(ctr);
                        entityObj1 = (Entities)sortedList.get(ctr1);
                    }
                    ++ctr1;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :sortEntitiesByPos :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return sortedList;
    }

    private ArrayList sortBrowColByPos(ArrayList unSortedList) throws ITMException {
        ArrayList<Column> sortedList = new ArrayList<Column>(unSortedList);
        try {
            int ctr = 0;
            while (ctr < sortedList.size()) {
                Column colObj = (Column)sortedList.get(ctr);
                int ctr1 = ctr;
                while (ctr1 < sortedList.size()) {
                    Column colObj1 = (Column)sortedList.get(ctr1);
                    if (colObj1.getBrowPos() <= colObj.getBrowPos()) {
                        sortedList.set(ctr1, colObj);
                        sortedList.set(ctr, colObj1);
                        colObj = (Column)sortedList.get(ctr);
                        colObj1 = (Column)sortedList.get(ctr1);
                    }
                    ++ctr1;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :sortBrowColByPos :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return sortedList;
    }

    public Column getColumn(String formNo, String fieldName) throws ITMException {
        Column colObj = null;
        try {
            HashMap colLogicalNameObjMap;
            if (this.formNoMetaDataMap != null && fieldName != null && (colLogicalNameObjMap = (HashMap)this.formNoMetaDataMap.get(formNo)) != null && colLogicalNameObjMap.get(fieldName) != null && colLogicalNameObjMap.get(fieldName).getClass().isInstance(new Column())) {
                colObj = (Column)colLogicalNameObjMap.get(fieldName);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getColumn :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return colObj;
    }

    private ArrayList getPrimarykeyPosList(String formNo) throws ITMException {
        ArrayList<Float> pkPosList = null;
        try {
            HashMap colLogicalNameObjMap;
            if (this.formNoMetaDataMap != null && (colLogicalNameObjMap = (HashMap)this.formNoMetaDataMap.get(formNo)) != null) {
                for (String colLogicalName : colLogicalNameObjMap.keySet()) {
                    Column colObj;
                    if (!colLogicalNameObjMap.get(colLogicalName).getClass().isInstance(new Column()) || !(colObj = (Column)colLogicalNameObjMap.get(colLogicalName)).isKey()) continue;
                    if (pkPosList == null) {
                        pkPosList = new ArrayList<Float>();
                    }
                    pkPosList.add(new Float(colObj.getSQLPos()));
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getPrimarykeyPosList :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return pkPosList;
    }

    private int getRowNoForIdentifier(String formNo, String rowIdentifier) throws ITMException {
        int rowNo;
        block5: {
            rowNo = -1;
            try {
                if (this.currFormNoDataMap == null) break block5;
                ArrayList pkPosList = this.getPrimarykeyPosList(formNo);
                ArrayList recordList = (ArrayList)this.currFormNoDataMap.get(formNo);
                if (recordList == null) break block5;
                int ctr = 0;
                while (ctr < recordList.size()) {
                    ArrayList rowList = (ArrayList)recordList.get(ctr);
                    StringBuffer currIdentifierStrBuff = new StringBuffer();
                    int pkCtr = 0;
                    while (pkCtr < pkPosList.size()) {
                        currIdentifierStrBuff.append(String.valueOf((String)rowList.get(((Float)pkPosList.get(pkCtr)).intValue())) + ",");
                        ++pkCtr;
                    }
                    currIdentifierStrBuff.deleteCharAt(currIdentifierStrBuff.length() - 1);
                    if (currIdentifierStrBuff.toString().equals(rowIdentifier)) {
                        rowNo = ctr;
                        break;
                    }
                    ++ctr;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getRowNoForIdentifier :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return rowNo;
    }

    private ArrayList getRowList(HashMap formNoDataMap, String formNo, int rowNo) throws ITMException {
        ArrayList rowList = null;
        try {
            ArrayList recordList;
            if (formNoDataMap != null && (recordList = (ArrayList)formNoDataMap.get(formNo)) != null && recordList.size() > rowNo) {
                rowList = (ArrayList)recordList.get(rowNo);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getRowList :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return rowList;
    }

    private ArrayList getRowList(HashMap formNoDataMap, String formNo, String domId) throws ITMException {
        ArrayList rowList;
        block4: {
            rowList = null;
            int cnt = 0;
            try {
                if (formNoDataMap == null) break block4;
                ArrayList recordList = (ArrayList)formNoDataMap.get(formNo);
                while (cnt < recordList.size()) {
                    if (recordList != null && String.valueOf(((ArrayList)recordList.get(cnt)).get(0)).equals(domId)) {
                        rowList = (ArrayList)recordList.get(cnt);
                        break;
                    }
                    ++cnt;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getRowList :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return rowList;
    }

    protected ArrayList getRowList(String formNo, int rowNo) throws ITMException {
        ArrayList rowList = null;
        try {
            ArrayList recordList;
            if (this.currFormNoDataMap != null && (recordList = (ArrayList)this.currFormNoDataMap.get(formNo)) != null && recordList.size() > rowNo) {
                rowList = (ArrayList)recordList.get(rowNo);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getRowList :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return rowList;
    }

    public ArrayList getAllRowsForBrow(String formNo) throws ITMException {
        ArrayList titleDataList = null;
        try {
            if (this.currFormNoDataMap != null) {
                ArrayList recordList;
                ArrayList browColList = this.getBrowColumnList(formNo, true);
                ArrayList newRowList = new ArrayList();
                if (browColList != null) {
                    titleDataList = new ArrayList();
                    titleDataList.add(browColList);
                }
                if ((recordList = (ArrayList)this.currFormNoDataMap.get(formNo)) != null) {
                    int cRow = 0;
                    while (cRow < recordList.size()) {
                        ArrayList rowList = (ArrayList)recordList.get(cRow);
                        if (rowList != null) {
                            newRowList = new ArrayList();
                            newRowList.add(rowList.get(0));
                            newRowList.add(rowList.get(1));
                            newRowList.add(rowList.get(2));
                            int cCtr = 0;
                            while (cCtr < browColList.size()) {
                                newRowList.add(rowList.get(((Column)browColList.get(cCtr)).getSQLPos() + this.transInfoSize));
                                ++cCtr;
                            }
                            titleDataList.add(newRowList);
                        }
                        ++cRow;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException idxEx) {
            BaseLogger.log("0", null, null, "IndexOutOfBoundsException : TransactionMetaModel :setRow :==>" + idxEx.getMessage());
            throw new IndexOutOfBoundsException("Number of Columns in Metadata file doesn't match with SQL generated!!!");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getRowsForBrow :==>" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return titleDataList;
    }

    public ArrayList getRowForBrow(String formNo, int rowNo) throws ITMException {
        ArrayList dataList = null;
        try {
            if (this.currFormNoDataMap != null) {
                ArrayList browColList = this.getBrowColumnList(formNo, true);
                ArrayList recordList = (ArrayList)this.currFormNoDataMap.get(formNo);
                if (recordList != null && recordList.size() > 0) {
                    ArrayList rowList = (ArrayList)recordList.get(rowNo);
                    dataList = new ArrayList();
                    dataList.add(rowList.get(0));
                    dataList.add(rowList.get(1));
                    dataList.add(rowList.get(2));
                    int cCtr = 0;
                    while (cCtr < browColList.size()) {
                        dataList.add(rowList.get(((Column)browColList.get(cCtr)).getSQLPos() + this.transInfoSize));
                        ++cCtr;
                    }
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getRowForBrow :==>" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return dataList;
    }

    public ArrayList getTaxForBrow(String formNo, int rowNo) throws ITMException {
        ArrayList mainList = new ArrayList();
        try {
            if (this.currFormNoDataMap != null) {
                ArrayList browColList = this.getBrowColumnList(CommonConstants.TAX_FORM_NO, true);
                ArrayList recordList = (ArrayList)this.currFormNoDataMap.get(formNo);
                if (recordList != null && recordList.size() > 0) {
                    ArrayList taxesList;
                    ArrayList rowList = (ArrayList)recordList.get(rowNo);
                    ArrayList arrayList = taxesList = rowList.get(rowList.size() - 1) instanceof ArrayList ? (ArrayList)rowList.get(rowList.size() - 1) : null;
                    if (taxesList != null) {
                        int ctr = 0;
                        while (ctr < taxesList.size()) {
                            ArrayList taxList = new ArrayList();
                            ArrayList lineNoList = (ArrayList)taxesList.get(ctr);
                            taxList.add(lineNoList.get(0));
                            taxList.add(lineNoList.get(1));
                            taxList.add(lineNoList.get(2));
                            int cCtr = 0;
                            while (cCtr < browColList.size()) {
                                Column colObj = (Column)browColList.get(cCtr);
                                taxList.add(lineNoList.get(colObj.getSQLPos() + this.transInfoSize));
                                ++cCtr;
                            }
                            mainList.add(taxList);
                            ++ctr;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionCoreModel :getTaxForBrow :==>" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return mainList;
    }

    protected boolean addColumn(String formNo, String colName, Column colObj) throws ITMException {
        boolean colCreated = false;
        try {
            if (this.formNoMetaDataMap != null && this.formNoMetaDataMap.containsKey(formNo)) {
                HashMap<String, Column> colLogicalNameObjMap = (HashMap<String, Column>)this.formNoMetaDataMap.get(formNo);
                if (colLogicalNameObjMap == null) {
                    colLogicalNameObjMap = new HashMap<String, Column>();
                }
                if (!colLogicalNameObjMap.containsKey(colName)) {
                    colLogicalNameObjMap.put(colName, colObj);
                    colCreated = true;
                }
            }
        }
        catch (Exception e) {
            colCreated = false;
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :addColumn :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return colCreated;
    }

    protected boolean addGroupBox(String formNo, String grpName, GroupBox groupObj) throws ITMException {
        boolean grpCreated = false;
        try {
            if (this.formNoMetaDataMap != null && this.formNoMetaDataMap.containsKey(formNo)) {
                HashMap<String, GroupBox> grpLogicalNameObjMap = (HashMap<String, GroupBox>)this.formNoMetaDataMap.get(formNo);
                if (grpLogicalNameObjMap == null) {
                    grpLogicalNameObjMap = new HashMap<String, GroupBox>();
                }
                if (!grpLogicalNameObjMap.containsKey(grpName)) {
                    grpLogicalNameObjMap.put(grpName, groupObj);
                    grpCreated = true;
                }
            }
        }
        catch (Exception e) {
            grpCreated = false;
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :addGroupBox :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return grpCreated;
    }

    protected boolean addTextObject(String formNo, String textObjName, TextObject textObj) throws ITMException {
        boolean textObjCreated = false;
        try {
            if (this.formNoMetaDataMap != null && this.formNoMetaDataMap.containsKey(formNo)) {
                HashMap<String, TextObject> textObjLogicalNameObjMap = (HashMap<String, TextObject>)this.formNoMetaDataMap.get(formNo);
                if (textObjLogicalNameObjMap == null) {
                    textObjLogicalNameObjMap = new HashMap<String, TextObject>();
                }
                if (!textObjLogicalNameObjMap.containsKey(textObjName)) {
                    textObjLogicalNameObjMap.put(textObjName, textObj);
                    textObjCreated = true;
                }
            }
        }
        catch (Exception e) {
            textObjCreated = false;
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :addTextObject :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return textObjCreated;
    }

    protected boolean setDefaultRowToDataForm(String formNo, ArrayList domIdList) throws ITMException {
        boolean formCreated = false;
        try {
            ArrayList<ArrayList> newRowList = new ArrayList<ArrayList>();
            ArrayList<ArrayList> rowList = (ArrayList<ArrayList>)this.currFormNoDataMap.get(formNo);
            if (domIdList.size() > 0) {
                int defaultRows = domIdList.size();
                if (rowList != null && rowList.size() > 0) {
                    int rCnt = 0;
                    while (rCnt < rowList.size()) {
                        ArrayList recordList = (ArrayList)rowList.get(rCnt);
                        if (recordList != null && domIdList.contains((Integer)recordList.get(0))) {
                            newRowList.add(recordList);
                            --defaultRows;
                        }
                        ++rCnt;
                    }
                }
                rowList = null;
                rowList = newRowList;
                int row = 0;
                while (row < defaultRows) {
                    rowList.add(null);
                    ++row;
                }
            }
            this.currFormNoDataMap.put(formNo, new ArrayList(rowList));
            this.prevFormNoDataMap.put(formNo, new ArrayList(rowList));
            formCreated = true;
        }
        catch (Exception e) {
            formCreated = false;
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :setDefaultRowToDataForm :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return formCreated;
    }

    protected String getGroupNameForPos(String formNo, int x, int y) throws ITMException {
        String grpName;
        block3: {
            grpName = null;
            try {
                HashMap logicalNameObjMap;
                if (this.formNoMetaDataMap == null || !this.formNoMetaDataMap.containsKey(formNo) || (logicalNameObjMap = (HashMap)this.formNoMetaDataMap.get(formNo)) == null) break block3;
                for (String logicalName : logicalNameObjMap.keySet()) {
                    GroupBox grpBoxObj;
                    if (!logicalNameObjMap.get(logicalName).getClass().isInstance(new GroupBox()) || (grpBoxObj = (GroupBox)logicalNameObjMap.get(logicalName)).getX() > x || x > grpBoxObj.getX() + grpBoxObj.getWidth() || grpBoxObj.getY() > y || y > grpBoxObj.getY() + grpBoxObj.getHeight()) continue;
                    grpName = grpBoxObj.getName();
                    break;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getGroupNameForPos :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return grpName;
    }

    public boolean isTaxPresent(String formNo) throws ITMException {
        try {
            return ((Form)this.formNoObjectMap.get(formNo)).isTaxApplicable();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getGroupNameForPos :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    protected void insertTaxDetail(String formNo, int domId, ArrayList allTaxDataList) throws ITMException {
        try {
            ArrayList formInfoList = (ArrayList)this.currFormNoDataMap.get(formNo);
            ArrayList rowList = (ArrayList)formInfoList.get(domId - 1);
            rowList.add(allTaxDataList);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :insertTaxDetail :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public void setTaxDetail(String formNo, int currRowNo, ArrayList allTaxDataList) throws ITMException {
        try {
            ArrayList formInfoList = (ArrayList)this.currFormNoDataMap.get(formNo);
            ArrayList rowList = (ArrayList)formInfoList.get(currRowNo);
            if (!(rowList.get(rowList.size() - 1) instanceof ArrayList)) {
                rowList.add(new ArrayList());
            }
            rowList.set(rowList.size() - 1, allTaxDataList);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :setTaxDetail :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public void updatedCoreModelTax(String formNo, int rowNo, int taxRowNo, String colName, String colValue, boolean isChangeUpdated) throws ITMException {
        block4: {
            try {
                ArrayList taxesList;
                ArrayList formInfoList = (ArrayList)this.currFormNoDataMap.get(formNo);
                ArrayList rowList = (ArrayList)formInfoList.get(rowNo);
                ArrayList arrayList = taxesList = rowList.get(rowList.size() - 1) instanceof ArrayList ? (ArrayList)rowList.get(rowList.size() - 1) : null;
                if (taxesList == null || taxesList.size() <= 0) break block4;
                ArrayList taxDataList = (ArrayList)taxesList.get(taxRowNo);
                Column colObj = this.getColumn(CommonConstants.TAX_FORM_NO, colName);
                if (colObj == null || colObj.getSQLPos() == -1) break block4;
                int i = 0;
                while (i < taxDataList.size()) {
                    if (i == colObj.getSQLPos() + this.transInfoSize) {
                        taxDataList.set(i, colValue);
                        colObj.setIsChanged(!isChangeUpdated);
                        colObj.setIsChangeUpdated(isChangeUpdated);
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :updatedCoreModelTax :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
    }

    public Form getFormObject(String formNo) throws ITMException {
        try {
            return (Form)this.formNoObjectMap.get(formNo);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :getFormObject :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public int getTransInfoSize() {
        return this.transInfoSize;
    }

    public HashMap getColLogicalNameMap(String formNo) {
        return (HashMap)this.formNoMetaDataMap.get(formNo);
    }

    public int getNoOfRows(String formNo) {
        int currFormDataSize = 0;
        if (this.currFormNoDataMap.get(formNo) != null) {
            currFormDataSize = ((ArrayList)this.currFormNoDataMap.get(formNo)).size();
        }
        BaseLogger.log("2", null, null, "currFormDataSize[" + formNo + "][" + currFormDataSize + "]");
        return currFormDataSize;
    }

    protected void setObjDetailMapValue(String key, String value) throws ITMException {
        try {
            if (this.objDetailMap == null) {
                this.objDetailMap = new HashMap();
            }
            this.objDetailMap.put(key, value);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :setObjDetailMapValue :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    protected void identifyGroups(String formNo) throws ITMException {
        try {
            HashMap logicalNameObjMap;
            if (this.formNoMetaDataMap != null && this.formNoMetaDataMap.containsKey(formNo) && (logicalNameObjMap = (HashMap)this.formNoMetaDataMap.get(formNo)) != null) {
                for (String logicalName : logicalNameObjMap.keySet()) {
                    Entities entityObj;
                    if (logicalNameObjMap.get(logicalName).getClass().isInstance(new GroupBox()) || (entityObj = (Entities)logicalNameObjMap.get(logicalName)).getGrpName() != null) continue;
                    entityObj.setGrpName(this.getGroupNameForPos(formNo, entityObj.getX(), entityObj.getY()));
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :identifyGroups :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public String getObjDetailMapValue(String key) throws ITMException {
        try {
            if (this.objDetailMap != null && this.objDetailMap.containsKey(key)) {
                return this.objDetailMap.get(key).toString();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :setObjDetailMapValue :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return null;
    }

    protected void setGridStructure(boolean isGrid) {
        this.isGridStructure = isGrid;
    }

    public boolean isGridStructure() {
        return this.isGridStructure;
    }
}

