/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.webService.RestAPIService;
import ibase.webService.VisionOBJServiceUtility;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;

@Path(value="/VisionOBJService")
public class VisionOBJService
extends RestAPIService {
    @GET
    @Path(value="/getPageDetails")
    @Produces(value={"application/json"})
    public Response getExtServiceData(@QueryParam(value="APP_ID") String appId, @QueryParam(value="OBJ_NAME") String objName, @Context HttpServletRequest request, @Context HttpHeaders header) throws BaseException, Exception {
        try {
            VisionOBJServiceUtility visonOBJServiceUtility = new VisionOBJServiceUtility();
            return Response.ok((Object)visonOBJServiceUtility.getPageDetails(request, header, appId, objName)).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/getListPageData")
    @Produces(value={"application/json"})
    public Response getListPageData(@QueryParam(value="APP_ID") String appId, @QueryParam(value="OBJ_NAME") String objName, @QueryParam(value="ADV_QRY") String advQuery, @QueryParam(value="ARG_NAMES") String argFieldNames, @QueryParam(value="ARG_TYPES") String argFieldTypes, @QueryParam(value="ARG_VALUES") String argFieldValues, @QueryParam(value="SEARCH_PARAM") String searchParam, @QueryParam(value="OBJ_CONTEXT") String objContext, @QueryParam(value="PAGE_CONTEXT") String pageContext, @QueryParam(value="CURR_ROW_NUM") String currentRowNo, @QueryParam(value="UPTO_ROW_NUM") String upToRowNo, @QueryParam(value="DATA_FORMAT") String dataFormat, @Context HttpServletRequest request, @Context HttpHeaders header) throws BaseException, Exception {
        try {
            VisionOBJServiceUtility visonOBJServiceUtility = new VisionOBJServiceUtility();
            return Response.ok((Object)visonOBJServiceUtility.getListPageData(appId, objName, advQuery, argFieldNames, argFieldTypes, argFieldValues, searchParam, objContext, pageContext, currentRowNo, upToRowNo, dataFormat, request, header)).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/getPageMetadata")
    @Produces(value={"application/json"})
    public Response getPageMetadata(@QueryParam(value="APP_ID") String appId, @QueryParam(value="OBJ_NAME") String objName, @QueryParam(value="FORM_NAME") String formName, @QueryParam(value="OBJ_CONTEXT") String objContext, @QueryParam(value="PAGE_CONTEXT") String pageContext, @Context HttpServletRequest request, @Context HttpHeaders header) throws BaseException, Exception {
        try {
            VisionOBJServiceUtility visonOBJServiceUtility = new VisionOBJServiceUtility();
            return Response.ok((Object)visonOBJServiceUtility.getPageMetadata(request, header, appId, objName, formName, objContext, pageContext)).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/getFormalArgs")
    @Produces(value={"application/json"})
    public Response getPageFormalArgs(@QueryParam(value="APP_ID") String appId, @QueryParam(value="OBJ_NAME") String objName, @QueryParam(value="PAGE_NO") String pageNo, @QueryParam(value="FORM_NAME") String formName, @Context HttpServletRequest request, @Context HttpHeaders header) throws BaseException, Exception {
        try {
            VisionOBJServiceUtility visonOBJServiceUtility = new VisionOBJServiceUtility();
            return Response.ok((Object)visonOBJServiceUtility.getFormalArgs(request, header, appId, objName, pageNo, formName)).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="/getData")
    @Produces(value={"application/json"})
    public Response getData(@FormParam(value="OBJ_NAME") String objName, @FormParam(value="REF_ID") String refId, @FormParam(value="TOKEN_ID") String tokenId, @FormParam(value="DATA_FORMAT") String dataFormat, @FormParam(value="APP_ID") String appId, @Context HttpServletRequest request, @Context HttpHeaders header) throws BaseException, Exception {
        BaseLogger.log((String)"3", null, null, (Object)"Inside getData : VisonObjServiceUtility ");
        VisionOBJServiceUtility visonOBJServiceUtility = new VisionOBJServiceUtility();
        String result = visonOBJServiceUtility.getData(request, header, objName, refId, dataFormat, appId);
        return Response.status((int)200).entity((Object)result).build();
    }

    @POST
    @Path(value="/getReportArgs")
    @Produces(value={"application/json"})
    public Response getReportArgs(@FormParam(value="OBJ_NAME") String objName, @FormParam(value="DATA_FORMAT") String dataFormat, @FormParam(value="APP_ID") String appId, @FormParam(value="FORM_NAME") String formName, @Context HttpServletRequest request, @Context HttpHeaders header) throws BaseException, Exception {
        VisionOBJServiceUtility visonOBJServiceUtility = new VisionOBJServiceUtility();
        String result = visonOBJServiceUtility.getReportArgs(objName, dataFormat, appId, formName, request, header);
        return Response.status((int)200).entity((Object)result).build();
    }

    @POST
    @Path(value="/getReport")
    public Response getReport(@FormParam(value="APP_ID") String appId, @FormParam(value="OBJ_NAME") String objName, @FormParam(value="REPORT_SAVE_TYPE") String docType, @FormParam(value="DATA_FORMAT") String dataFormat, @FormParam(value="ARGUMENT") String reportArgument, @Context HttpServletRequest request, @Context HttpServletResponse response, @Context HttpHeaders header) throws BaseException, Exception {
        VisionOBJServiceUtility visonOBJServiceUtility = new VisionOBJServiceUtility();
        String result = visonOBJServiceUtility.getReport(objName, appId, dataFormat, docType, reportArgument, request, header, response);
        return Response.status((int)200).entity((Object)result).build();
    }

    @GET
    @Path(value="/getObjPopHelpInfoAll")
    @Produces(value={"application/json"})
    public Response getObjPopHelpInfoAll(@QueryParam(value="OBJ_NAME") String objName, @Context HttpServletRequest request, @Context HttpServletResponse response, @HeaderParam(value="TOKEN_ID") String tokenIDfromHeader) throws BaseException, Exception {
        VisionOBJServiceUtility visonOBJServiceUtility = new VisionOBJServiceUtility();
        String result = visonOBJServiceUtility.getObjPopHelpInfoAll(objName, tokenIDfromHeader);
        return Response.status((int)200).entity((Object)result).build();
    }

    @GET
    @Path(value="/downloadDataModelsList")
    @Produces(value={"application/json"})
    public Response downloadDataModelsList(@QueryParam(value="APPL_NAME") String applName, @QueryParam(value="DATA_MODEL_NAME") @DefaultValue(value="") String dataModelName, @QueryParam(value="SCOPE_PARAMS") @DefaultValue(value="") String scopeParameters, @QueryParam(value="DOWNLOAD_DM") @DefaultValue(value="") String dataModelToDownload, @QueryParam(value="RESPONSE_FORMAT") @DefaultValue(value="JSON") String responseFormat, @Context HttpServletRequest request, @Context HttpServletResponse response, @HeaderParam(value="TOKEN_ID") String tokenIDfromHeader) throws BaseException, Exception {
        VisionOBJServiceUtility visonOBJServiceUtility = new VisionOBJServiceUtility();
        String result = visonOBJServiceUtility.downloadDataModelsList(applName, dataModelName, scopeParameters, dataModelToDownload, responseFormat, tokenIDfromHeader);
        return Response.status((int)200).entity((Object)result).build();
    }
}

