/*
 * Decompiled with CFR 0.152.
 */
package ibase.wrkflw.utility;

import ibase.utility.BaseException;
import ibase.wrkflw.utility.WorkflowLogger;

public class WorkflowProcessIdGenerator {
    static String PROCESS_ID_SEP = ":";

    private WorkflowProcessIdGenerator() {
    }

    public static WorkflowProcessIdGenerator getInstance() throws BaseException {
        return new WorkflowProcessIdGenerator();
    }

    public String createProcessId(String processName) throws BaseException {
        String processId = null;
        try {
            processId = String.valueOf(processName) + PROCESS_ID_SEP + processName + PROCESS_ID_SEP + "1";
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return processId;
    }

    public String createProcessInstanceId(String processId, String instanceId, String activityId) throws BaseException {
        String processInstanceId = null;
        try {
            processInstanceId = String.valueOf(processId) + PROCESS_ID_SEP + instanceId + PROCESS_ID_SEP + activityId;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return processInstanceId;
    }

    public String createProcessInstanceId(String processId, String instanceId, String activityId, String seqId) throws BaseException {
        String processInstanceId = null;
        try {
            processInstanceId = String.valueOf(processId) + PROCESS_ID_SEP + instanceId + PROCESS_ID_SEP + activityId + PROCESS_ID_SEP + seqId;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return processInstanceId;
    }

    public String getProcessId(String processInstanceId) throws BaseException {
        String processId = null;
        try {
            processId = processInstanceId.substring(0, processInstanceId.indexOf(PROCESS_ID_SEP));
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return processId;
    }

    public String getInstanceId(String processInstanceId) throws BaseException {
        String instanceId = null;
        try {
            String afterProcessId = processInstanceId.substring(processInstanceId.indexOf(PROCESS_ID_SEP) + PROCESS_ID_SEP.length());
            instanceId = afterProcessId.substring(0, afterProcessId.indexOf(PROCESS_ID_SEP));
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return instanceId;
    }

    public String getActivityId(String processInstanceId) throws BaseException {
        String activityId = null;
        try {
            WorkflowLogger.info("processInstanceId [" + processInstanceId + "]");
            String afterProcessId = processInstanceId.substring(processInstanceId.indexOf(PROCESS_ID_SEP) + PROCESS_ID_SEP.length());
            WorkflowLogger.info("afterProcessId [" + afterProcessId + "]");
            String afterInstanceId = afterProcessId.substring(afterProcessId.indexOf(PROCESS_ID_SEP) + PROCESS_ID_SEP.length());
            WorkflowLogger.info("afterInstanceId [" + afterInstanceId + "]");
            activityId = afterInstanceId.substring(0, afterInstanceId.indexOf(PROCESS_ID_SEP));
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return activityId;
    }

    public String getSeqId(String processInstanceId) throws BaseException {
        String seqId = null;
        try {
            seqId = processInstanceId.substring(processInstanceId.lastIndexOf(PROCESS_ID_SEP) + PROCESS_ID_SEP.length());
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return seqId;
    }
}

