package ibase.webitm.servlet.wsfa;

import java.sql.*;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import ibase.system.config.ConnDriver;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BrandsServlet extends HttpServlet  {
	
	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	UserInfoBean userInfoBean = null; // added by rupali on 16/08/8 foe multi-tenancy related changes
	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		doPost(request,response);
	}
	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		System.out.println("##############IN BRANDS SERVLET#################");
	
		Date date=new Date(System.currentTimeMillis());
		Format formatter;
		 formatter = new SimpleDateFormat("dd-MMM-yyyy");
		 String currentDate=formatter.format(date);
		 System.out.println("#### Cur Date #### [ "+currentDate+" ]");
		 
		 
		//UserInfoBean userInfoBean = ( UserInfoBean ) request.getSession().getAttribute( "USER_INFO" ); // commentted by rupali on 16/08/8 foe multi-tenancy related changes [start]
		userInfoBean = ( UserInfoBean ) request.getSession().getAttribute( "USER_INFO" );
		System.out.println("userId ["+userInfoBean.getLoginCode()+"]");
		
		String returnStr="";
		try 
		{
			returnStr = getBrandsDetail("5", userInfoBean.getLoginCode(), currentDate, "", "");
		} 
		catch (Exception e) 
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println( returnStr );
		
		response.setContentType( "text/xml" );
		response.setHeader( "Cache-Control", "no-cache" );
		response.getWriter().write( returnStr );
	} 
	
	private String getBrandsDetail(String objContext, String salePersCode, String wrkDate, String scCode, String xtraParams) throws Exception  
	{
		System.out.println("getBrandsDetail Starts");
		ConnDriver connDriver = new ConnDriver();
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String returnStr = "";
		StringBuffer valueXmlString = new StringBuffer();
		ArrayList<String> brandCodeList = new ArrayList<String>();
		//ArrayList<String> selBrandCodeList = getSelectedBrands(salePersCode, wrkDate, scCode);
		HashMap<String, String> selBrandMap=null;
		try 
		{
			selBrandMap = getSelectedBrands(salePersCode, wrkDate, scCode);
		} 
		catch (ITMException e1) 
		{
			e1.printStackTrace();
		}
		int domID = 1;
		valueXmlString.append("<?xml version=\"1.0\" ?>");
		try
		{
			//Changed By Prajyot On 24-MAR-2012 [To Implement ITEM_SER in BRAND { BRAND.ITEM_SER = SALES_PERS.ITEM_SER} ]
			//String brandSql = "SELECT BRAND.* FROM BRAND, STRG_PRODUCT SP WHERE BRAND.CODE = SP.BRAND_CODE AND SP.SC_CODE ='" + scCode+ "'";//FIRST 
			//String brandSql = "SELECT BRAND.* FROM  BRAND , STRG_PRODUCT SP , SALES_PERS WHERE BRAND.CODE = SP.BRAND_CODE AND SP.SC_CODE ='" + scCode+ "' AND SALES_PERS.SALES_PERS ='" + salePersCode + "' AND  SALES_PERS.ITEM_SER = BRAND.ITEM_SER  ORDER  BY  BRAND.PITCH_PRIORITY  ";//SECOND

			// added by rupali on 16/08/8 foe multi-tenancy related changes [start]
			if( userInfoBean != null )
			{
				System.out.println("userInfo.getTransDB()["+userInfoBean.getTransDB());
				connectionObject = connDriver.getConnectDB(userInfoBean.getTransDB());
			}
			// added by rupali on 16/08/8 foe multi-tenancy related changes [end]
			valueXmlString.append( "<Root>\r\n" );
			
			String brandSql1 = "SELECT DISTINCT BRAND.*  FROM  BRAND, STRG_PRODUCT SP, SALES_PERS " +
					" WHERE BRAND.CODE = SP.BRAND_CODE AND  " +
					" SALES_PERS.SALES_PERS ='" + salePersCode + "' AND " +
					" SALES_PERS.ITEM_SER = BRAND.ITEM_SER " +
					" ORDER BY BRAND.PITCH_PRIORITY ";
			//connectionObject = connDriver.getConnectDB( "DriverITM" ); // commentted by rupali on 16/08/8 foe multi-tenancy related changes [start]
			pstmt = connectionObject.prepareStatement(brandSql1);						
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String brandCode = checkNull( rs.getString("CODE") );
				String brandDocId = checkNull( obtainDocId("product", brandCode) );
				System.out.println("brandCode["+brandCode+"]brandDocId["+brandDocId+"]");
				
				brandCodeList.add( brandCode.trim() );

				String tagName = "Detail" + objContext;
				if( selBrandMap.containsKey( brandCode.trim() ) )
				{
					valueXmlString.append( "<" + tagName + " domID='" + domID + "' selected = 'Y'>\r\n" );
					valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
					valueXmlString.append("<sc_code><![CDATA[").append( scCode ).append("]]></sc_code>\n");

					String[] splitArr = selBrandMap.get( brandCode.trim() ).split("~~");
					if( splitArr.length == 2 )
					{
						valueXmlString.append("<pitch_feedback><![CDATA[").append(checkNull( splitArr[0] )).append("]]></pitch_feedback>\n");
						valueXmlString.append("<pres_pattern><![CDATA[").append(checkNull( splitArr[1] )).append("]]></pres_pattern>\n");
					}
					else if( splitArr.length == 1 )
					{
						valueXmlString.append("<pitch_feedback><![CDATA[").append(checkNull( splitArr[0] )).append("]]></pitch_feedback>\n");
						valueXmlString.append("<pres_pattern><![CDATA[").append("]]></pres_pattern>\n");
					}
					else if( splitArr.length == 0 )
					{
						valueXmlString.append("<pitch_feedback><![CDATA[").append("]]></pitch_feedback>\n");
						valueXmlString.append("<pres_pattern><![CDATA[").append("]]></pres_pattern>\n");
					}
				}
				else
				{
					valueXmlString.append( "<" + tagName + " domID='" + domID + "' selected = 'N'>\r\n" );
				}
				valueXmlString.append("<brand_code><![CDATA[").append(checkNull(rs.getString("CODE"))).append("]]></brand_code>\n");
				
				valueXmlString.append("<brand_doc_id><![CDATA[").append( brandDocId ).append("]]></brand_doc_id>\n");
				
				valueXmlString.append("<description><![CDATA[").append(checkNull(rs.getString("DESCRIPTION"))).append("]]></description>\n");
				valueXmlString.append("<therapeutic_group><![CDATA[").append( checkNull(rs.getString("THERAPEUTIC_GROUP")) ).append("]]></therapeutic_group>\r\n");

				valueXmlString.append("<sales_pers><![CDATA[").append(checkNull(salePersCode)).append("]]></sales_pers>\n");
				valueXmlString.append("<work_date><![CDATA[").append(wrkDate).append( "]]></work_date>\r\n" );

				//Added By Prajyot On 24-MAR-2012 [To Implement ITEM_SER in BRAND { BRAND.ITEM_SER = SALES_PERS.ITEM_SER} ]
				valueXmlString.append("<item_ser><![CDATA[").append(checkNull(rs.getString("ITEM_SER"))).append("]]></item_ser>\n");
				valueXmlString.append("<pitch_priority><![CDATA[").append(checkNull(rs.getString("PITCH_PRIORITY"))).append("]]></pitch_priority>\n");

				valueXmlString.append( "</" + tagName + ">\r\n" );
				domID++;
			}
			
			pstmt = null;
			rs = null;
			
			System.out.println("\n brandCodeList[" + brandCodeList+"]\n");
			
			String brandSql2 = "SELECT DISTINCT BRAND.* FROM  BRAND, SALES_PERS " +
					" WHERE SALES_PERS.SALES_PERS ='" + salePersCode + "' AND " +
					" SALES_PERS.ITEM_SER = BRAND.ITEM_SER " +
					" ORDER BY BRAND.PITCH_PRIORITY "; 
			pstmt = connectionObject.prepareStatement(brandSql2);						
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String brandCode = checkNull( rs.getString("CODE") );
				String brandDocId = checkNull( obtainDocId("product", brandCode) );
				System.out.println("brandCode["+brandCode+"]brandDocId["+brandDocId+"]");
				
				if (! brandCodeList.contains( brandCode.trim() ) )
				{
				    String tagName = "Detail" + objContext;
					if( selBrandMap.containsKey( brandCode.trim() ) )
					{
						valueXmlString.append( "<" + tagName + " domID='" + domID + "' selected = 'Y'>\r\n" );
						valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
						valueXmlString.append("<sc_code><![CDATA[").append( scCode ).append("]]></sc_code>\n");
						
						String[] splitArr = selBrandMap.get( brandCode.trim() ).split("~~");
						if( splitArr.length == 2 )
						{
							valueXmlString.append("<pitch_feedback><![CDATA[").append(checkNull( splitArr[0] )).append("]]></pitch_feedback>\n");
							valueXmlString.append("<pres_pattern><![CDATA[").append(checkNull( splitArr[1] )).append("]]></pres_pattern>\n");
						}
						else if( splitArr.length == 1 )
						{
							valueXmlString.append("<pitch_feedback><![CDATA[").append(checkNull( splitArr[0] )).append("]]></pitch_feedback>\n");
							valueXmlString.append("<pres_pattern><![CDATA[").append("]]></pres_pattern>\n");
						}
						else if( splitArr.length == 0 )
						{
							valueXmlString.append("<pitch_feedback><![CDATA[").append("]]></pitch_feedback>\n");
							valueXmlString.append("<pres_pattern><![CDATA[").append("]]></pres_pattern>\n");
						}
					}
					else
					{
						valueXmlString.append( "<" + tagName + " domID='" + domID + "' selected = 'N'>\r\n" );
					}
 					valueXmlString.append("<brand_code><![CDATA[").append(checkNull(rs.getString("CODE"))).append("]]></brand_code>\n");
 					
 					valueXmlString.append("<brand_doc_id><![CDATA[").append( brandDocId ).append("]]></brand_doc_id>\n");

					valueXmlString.append("<description><![CDATA[").append(checkNull(rs.getString("DESCRIPTION"))).append("]]></description>\n");
					valueXmlString.append("<therapeutic_group><![CDATA[").append( checkNull(rs.getString("THERAPEUTIC_GROUP")) ).append("]]></therapeutic_group>\r\n");

					valueXmlString.append("<sales_pers><![CDATA[").append(checkNull(salePersCode)).append("]]></sales_pers>\n");
					valueXmlString.append("<work_date><![CDATA[").append(wrkDate).append( "]]></work_date>\r\n" );

					//Added By Prajyot On 24-MAR-2012 [To Implement ITEM_SER in BRAND { BRAND.ITEM_SER = SALES_PERS.ITEM_SER} ]
 					valueXmlString.append("<item_ser><![CDATA[").append(checkNull(rs.getString("ITEM_SER"))).append("]]></item_ser>\n");
					valueXmlString.append("<pitch_priority><![CDATA[").append(checkNull(rs.getString("PITCH_PRIORITY"))).append("]]></pitch_priority>\n");

					valueXmlString.append( "</" + tagName + ">\r\n" );
				}
				domID++;
			}
			
			
			valueXmlString.append( "</Root>\r\n" );			
			
			returnStr = valueXmlString.toString();
			
		}
		catch(Exception e)
		{
			System.out.println( "getBrandsDetail Exception :" + e.getMessage() );
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				System.out.println( "Exception :DcdetWizDataEJB :getCustomerDetail :==>\n"+e.getMessage());
				
			}
		}

		
		System.out.println("getBrandsDetail Ends");
		return returnStr;
	}
	private String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	private HashMap<String, String> getSelectedBrands(String salePersCode,	String wrkDate, String scCode) throws ITMException 
	{
		System.out.println("getSelectedBrands Starts");
		ConnDriver connDriver = new ConnDriver();
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//ArrayList<String> selBrandCodeList = new ArrayList<String>();
		//<KEY, VALUE> :: KEY - BRAND_CODE & VALUE -  PITCH_FEEDBACK + "~~" + PRES_PATTERN
		HashMap<String, String> selBrandMap = new HashMap<String, String>();
		try
		{
			// added by rupali on 16/08/8 foe multi-tenancy related changes [start]
			if( userInfoBean != null )
			{
				System.out.println("userInfo.getTransDB()["+userInfoBean.getTransDB());
				connectionObject = connDriver.getConnectDB(userInfoBean.getTransDB());
				System.out.println("connection["+connectionObject+"]");
			}
			// added by rupali on 16/08/8 foe multi-tenancy related changes [end]
			String brandSql = "SELECT DISTINCT BRAND_CODE, PITCH_FEEDBACK, PRES_PATTERN FROM STRG_BRAND_PITCH WHERE  SALES_PERS = '" + salePersCode + "' AND WORK_DATE = '" + wrkDate + "'  ";
			//connectionObject = connDriver.getConnectDB( "DriverITM" ); // commented by rupali on 16/08/8 foe multi-tenancy related changes [start]
			pstmt = connectionObject.prepareStatement(brandSql);						
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String brandCode = checkNull( rs.getString("BRAND_CODE") );
				String pitchFeedback = checkNull( rs.getString("PITCH_FEEDBACK") );
				String presPattern = checkNull( rs.getString("PRES_PATTERN") );
				//System.out.println("selBrandCode["+brandCode+"]");
				selBrandMap.put( brandCode.trim() , pitchFeedback + "~~" + presPattern );
			}
			pstmt = null;
			rs = null;
			System.out.println("\n selBrandMap[" + selBrandMap+"]\n");
		}
		catch(Exception e)
		{
			System.out.println( "getSelectedBrands Exception :" + e.getMessage() );
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				System.out.println( "Exception :DcdetWizDataEJB :getSelectedBrands :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("getSelectedBrands Ends");
		return selBrandMap;
	}
	
	//
	protected String obtainDocId( String objName, String refID ) throws Exception
	{
		StringBuffer docIDStrBuff = new StringBuffer();
		
		Connection connection = null;
		PreparedStatement statement = null;
		ResultSet resultSet = null;
		ConnDriver connDriver = new ConnDriver(); // added by rupali on 16/08/8 foe multi-tenancy related changes
		try
		{
			// added by rupali on 16/08/8 foe multi-tenancy related changes [start]
			if( userInfoBean != null )
			{
				System.out.println("userInfo.getTransDB()["+userInfoBean.getTransDB());
				connection = connDriver.getConnectDB(userInfoBean.getTransDB());
				System.out.println("connection["+connection+"]");
			}
			// added by rupali on 16/08/8 foe multi-tenancy related changes [end]
			String query = 
					"SELECT * FROM DOC_CONTENTS WHERE DOC_ID IN ("
				+ 		"SELECT ATTACHMENTS FROM COLLAB_POSTS WHERE (IS_APPROVED IS NULL OR IS_APPROVED = 'A') AND GROUP_ID__COLLAB IN ("
				+ 			"SELECT GROUP_ID FROM COLLAB_TAGS WHERE WIN_NAME = 'w_" + objName + "' AND TRIM( REF_NO ) IN ( '" + refID + "') "
				+ 		")"
				+ 	") ORDER BY DOC_ID DESC";
			// commentted by rupali on 16/08/8 foe multi-tenancy related changes [start]
			//ConnDriver driver = new ConnDriver();
			//connection = driver.getConnectDB( "DriverITM" );
			// commentted by rupali on 16/08/8 foe multi-tenancy related changes [end]
			statement = connection.prepareStatement( query );
			resultSet = statement.executeQuery();
			int i = 1;
			while( resultSet.next() )
			{
				String docID =  resultSet.getString( "DOC_ID" ) ;
				if( i == 1 ) //if while loop executes more than one time
				{
					docIDStrBuff.append( docID );
				}
				System.out.println("docID "+ i +"[" + docID + "]");
				i++;
			}
		}
		finally
		{
			try
			{
				if( resultSet != null )
				{
					resultSet.close();
				}
				if( statement != null )
				{
					statement.close();
				}
				if( connection != null )
				{
					connection.close();
				}
			}
			catch( SQLException e )
			{
				e.printStackTrace( System.err );
				// Continue
			}
		}
		
		return docIDStrBuff.toString();
	}
	
	protected <T> String toCSV( List< T > list )
	{
		StringBuilder s = new StringBuilder();
		for( T listItem : list )
		{
			s.append( "'" + listItem.toString() + "', " );
		}
		return s.toString().substring( 0, s.length() - 2 );
	}

}
