
package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.sql.*;
import java.util.ArrayList;

import org.w3c.dom.*;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;

//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].

public class StrgMeetMgrDcrWizPreSave extends ValidatorEJB  implements StrgMeetMgrDcrWizPreSaveLocal, StrgMeetMgrDcrWizPreSaveRemote
{
	public String preSave()throws RemoteException,ITMException
	{
		return "";
	}

	public String preSave( String domString, String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{
		System.out.println("inside the pre save method of manger reporting ");
		String retString = "";
		Document preSaveXmlDom = null;
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		ArrayList<String> sprsCodeList=new ArrayList<String>();
		StrgMeetMgrDCRWizard strgMeetMgrDCRWizard = null;

		try
		{
			strgMeetMgrDCRWizard = new StrgMeetMgrDCRWizard();
			GenericUtility genericUtility = GenericUtility.getInstance();
			preSaveXmlDom = genericUtility.parseString(domString);
			String userId = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode"));
			String sprscodeWW = checkNull(genericUtility.getColumnValue("sprs_code__ww", preSaveXmlDom, "1"));
			String eventDate = checkNull(genericUtility.getColumnValue("event_date", preSaveXmlDom, "1"));

			String objName = getObjNameFromDom( preSaveXmlDom, "objName" , 1);

			eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			String mainSprsCodeWW="";
			System.out.println("domString RealTimeReportPreSaveEJB ["+domString+"]userId is:["+userId+"]sprscodeWW["+sprscodeWW+"]eventDate["+eventDate+"]");

			String sql="SELECT SPRS_CODE__WW FROM SPRS_ACT_TRAN WHERE EVENT_DATE=? AND SALES_PERS=?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf(eventDate));
			pstmt.setString( 2, userId);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				mainSprsCodeWW=checkNull(rs.getString("SPRS_CODE__WW"));
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("mainSprsCodeWW["+mainSprsCodeWW+"]");

			if(sprscodeWW!=null && sprscodeWW.trim().length()>0)
			{
				String code[]=sprscodeWW.split(",");
				for(int i=0;i<code.length;i++)
				{
					sprsCodeList.add(code[i]);
				}
			}
			System.out.println("sprsCodeList["+sprsCodeList+"]");

			if(mainSprsCodeWW!=null && mainSprsCodeWW.trim().length()>0)
			{
				String sprsCode[]=mainSprsCodeWW.split(",");
				System.out.println("sprsCode["+sprsCode+"]");

				for(int i=0;i<sprsCode.length;i++)
				{
					String salesPers=sprsCode[i];
					System.out.println("salesPers["+salesPers+"]mainCodeList.contains(salesPers)["+sprsCodeList.contains(salesPers)+"]");

					if(!sprsCodeList.isEmpty() && !sprsCodeList.contains(salesPers))
					{
						System.out.println("inside dele condition["+salesPers+"]userId["+userId+"]eventDate["+eventDate+"]");

						deleteDataAginstSprsCodeWW(userId,salesPers,eventDate,conn);
					}
				}
			}
			if(editFlag.equalsIgnoreCase("E"))
			{
				ArrayList custVisitList = new ArrayList();
				String drVisit = "", chemVisit = "", stockVisit = "", othVisit = "";
				String localityCode = "", routeId = "", salesPersWW = "", tranId = "";
				String meetDate =  checkNull(genericUtility.getColumnValue( "event_date", preSaveXmlDom, "1" ));
				String salesPers = checkNull(genericUtility.getColumnValue( "sales_pers", preSaveXmlDom, "1" ));
				String activityCode = checkNull(genericUtility.getColumnValue( "activity_code", preSaveXmlDom, "1" ));
				String activityType = checkNull(strgMeetMgrDCRWizard.getActivityType(activityCode,  conn));
				System.out.println("activity code is:["+activityCode+"]activityType is:["+activityType+"]");
				int updateActivityCnt=updateActivityCodeInEditMode(salesPers,meetDate,activityCode,activityType,conn);
				String placeFormNo = checkNull(strgMeetMgrDCRWizard.getFormNo(objName, "place", conn));
				NodeList parentNodeList = preSaveXmlDom.getElementsByTagName("Detail"+placeFormNo);
				int nodeListLen = parentNodeList.getLength();
				for(int i = 0; i<nodeListLen; i++)
				{
					String updateFlag = "";
					Node parentNode = parentNodeList.item(i);

					NodeList childNodeList = parentNode.getChildNodes();
					int childListLen = childNodeList.getLength();
					for(int j = 0; j<childListLen; j++)
					{
						Node childNode = childNodeList.item(j);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}

						String nodeName = childNode.getNodeName();
						if("attribute".equalsIgnoreCase(nodeName) && childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							System.out.println("updateFlag =["+updateFlag+"]");
						}
						else if (nodeName.equalsIgnoreCase("locality_code"))
						{
							if(childNode.getFirstChild() != null)
							{
								localityCode = childNode.getFirstChild().getNodeValue().trim();
								System.out.println("localityCode::::===="+localityCode);
							}
						}
						else if (nodeName.equalsIgnoreCase("route_id"))
						{
							if(childNode.getFirstChild() != null)
							{
								routeId = childNode.getFirstChild().getNodeValue().trim();
								System.out.println("routeId::::===="+routeId);
							}
						}
						else if (nodeName.equalsIgnoreCase("sprs_code__ww"))
						{
							if(childNode.getFirstChild() != null)
							{
								salesPersWW = childNode.getFirstChild().getNodeValue().trim();
								System.out.println("salesPersWW::::===="+salesPersWW);
							}
						}
						else if (nodeName.equalsIgnoreCase("tran_id"))
						{
							if(childNode.getFirstChild() != null)
							{
								tranId = childNode.getFirstChild().getNodeValue().trim();
								System.out.println("tranId::::===="+tranId);
							}
						}
						else if (nodeName.equalsIgnoreCase("dr_visit"))
						{
							if(childNode.getFirstChild() != null)
							{
								drVisit = childNode.getFirstChild().getNodeValue().trim();
								System.out.println("drVisit::::===="+drVisit);
							}
						}
						else if (nodeName.equalsIgnoreCase("chem_visit"))
						{
							if(childNode.getFirstChild() != null)
							{
								chemVisit = childNode.getFirstChild().getNodeValue().trim();
								System.out.println("chemVisit::::===="+chemVisit);
							}
						}
						else if (nodeName.equalsIgnoreCase("stockist_visit"))
						{
							if(childNode.getFirstChild() != null)
							{
								stockVisit = childNode.getFirstChild().getNodeValue().trim();
								System.out.println("stockVisit::::===="+stockVisit);
							}
						}
						else if (nodeName.equalsIgnoreCase("other_visit"))
						{
							if(childNode.getFirstChild() != null)
							{
								othVisit = childNode.getFirstChild().getNodeValue().trim();
								System.out.println("othVisit::::===="+othVisit);
							}
						}

						
					}
					
					if(drVisit!=null && drVisit.trim().length()>0)
					{
						custVisitList.add(0, drVisit);
					}
					if(chemVisit!=null && chemVisit.trim().length()>0)
					{
						custVisitList.add(1, chemVisit);
					}
					if(stockVisit!=null && stockVisit.trim().length()>0)
					{
						custVisitList.add(2, stockVisit);
					}
					if(othVisit!=null && othVisit.trim().length()>0)
					{
						custVisitList.add(3, othVisit);
					}
					System.out.println("custVisitList is:::::====["+custVisitList+"]");
					if("D".equalsIgnoreCase(updateFlag))
					{
						deleteCustomerData(salesPers,meetDate,localityCode,routeId,salesPersWW,tranId,conn);
					}
					else
					{
						deleteCustomerDataCustTypeWise(salesPers,meetDate,localityCode,routeId,salesPersWW,tranId,custVisitList,conn);
					}
				}

			}

		}
		catch(Exception e)
		{
			System.out.println("Exception :RealTimeReportPreSaveEJB : :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{

			}
			catch(Exception e)
			{
				System.out.println("Exception :StrgMeetMgrDcrWizPreSave : :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("Return string :"+retString);
		return retString;
	}
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	private void deleteDataAginstSprsCodeWW(String userId, String sprsCodeWW, String eventDate, Connection conn) throws ITMException
	{
		System.out.println("inside the deleteDataAginstSprsCodeWW");
		PreparedStatement pstmtDel = null;
		PreparedStatement pstmt = null;
		ResultSet rs=null;
		int trvDelCnt=0,strgDelCnt=0;
		String dcrId = "", strgCode = "", tranId = "";
		String delSql="";
		try
		{

			String sql = "SELECT DCR_ID,TRAN_ID,STRG_CODE,SURVEY_TEMPL,SALES_PERS FROM STRG_MEET WHERE SALES_PERS = ? AND SPRS_CODE__WW = ? AND EVENT_DATE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, userId);
			pstmt.setString(2, sprsCodeWW);
			pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf(eventDate));
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				dcrId = checkNull(rs.getString("DCR_ID"));
				strgCode = checkNull(rs.getString("STRG_CODE"));
				tranId = checkNull(rs.getString("TRAN_ID"));


				//added by prachi on 29-sep-22 start
				
				String salesPerson=checkNull(rs.getString("SALES_PERS"));
				String surveyTempl=checkNull(rs.getString("SURVEY_TEMPL"));
				
				String SurveyStatus="";
				String surveryStatusSQL ="SELECT DISTINCT(SURV_STATUS) AS SURV_STATUS FROM STRG_SURV_RES WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
				PreparedStatement pSS = conn.prepareStatement(surveryStatusSQL);
				pSS.setString(1, dcrId);
				pSS.setString(2, strgCode);
				pSS.setString(3, tranId);
				ResultSet rSS = pSS.executeQuery();
				if(rSS.next())
				{
					SurveyStatus=checkNull(rSS.getString("SURV_STATUS"));
				}
				if( rSS != null )
				{
					rSS.close();
					rSS = null;
				}
				if( pSS != null )
				{
					pSS.close();
					pSS = null;
				}
				
				delSql = "DELETE FROM STRG_SURV_RES WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
				pstmtDel = conn.prepareStatement(delSql);
				pstmtDel.setString(1, dcrId);
				pstmtDel.setString(2, strgCode);
				pstmtDel.setString(3, tranId);
				int survyDelCnt = pstmtDel.executeUpdate();
				pstmtDel.close(); pstmtDel = null;
                System.out.println("STRG_SURV_RES delete count"+ survyDelCnt+" SurveyStatus:"+SurveyStatus);
                
                if(survyDelCnt>0 && SurveyStatus.equals("Y"))
				{
                	
					   String maxDCRID="";
					   String maxID="SELECT MAX(SM.DCR_ID) AS DCR_ID FROM STRG_MEET SM,STRG_SURV_RES SR WHERE SM.DCR_ID!=? AND SM.STRG_CODE=? AND SM.SURVEY_TEMPL=? AND SM.SALES_PERS=?"
									+ " SR.DCR_ID=SM.DCR_ID AND SR.STRG_CODE=SM.STRG_CODE AND SR.TRAN_ID=SM.TRAN_ID";
					   
					   PreparedStatement ps = conn.prepareStatement(maxID);
					   ps.setString(1, dcrId);
					   ps.setString(2, strgCode);
					   ps.setString(3, surveyTempl);
					   ps.setString(4, salesPerson);
					   ResultSet rs1=ps.executeQuery();
					   if(rs1.next())
						{
						  maxDCRID=checkNull(rs1.getString("DCR_ID"));
						  String updSurveySubSql = " UPDATE STRG_SURV_RES SET SURV_STATUS = 'Y' WHERE DCR_ID = ? AND STRG_CODE = ?";
						  PreparedStatement pstmtupdSurveySub =  conn.prepareStatement(updSurveySubSql);
						  pstmtupdSurveySub.setString(1, maxDCRID);
						  pstmtupdSurveySub.setString(2, strgCode);
						  int updCount = pstmtupdSurveySub.executeUpdate();
						  if(pstmtupdSurveySub!=null)
						  {
							  pstmtupdSurveySub.close(); 
							  pstmtupdSurveySub = null;
						  }
							System.out.println("STRG_SURV_RES is Updated updCount:["+updCount+"]");
						}
					    if( rs1 != null )
						{
							rs1.close();
							rs1 = null;
						}
						if( ps != null )
						{
							ps.close();
							ps = null;
						}
				}
				//end

				delSql = "DELETE FROM STRG_MEET_ORDER WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
				pstmtDel = conn.prepareStatement(delSql);
				pstmtDel.setString(1, dcrId);
				pstmtDel.setString(2, strgCode);
				pstmtDel.setString(3, tranId);
				strgDelCnt = pstmtDel.executeUpdate();
				pstmtDel.close(); pstmtDel = null;

				System.out.println("strg_meet delete count"+ strgDelCnt);
				
				//ADDED BY BHAGYASHRI T FOR DELETE DATA FROM INVOICE TABLE[04/08/2022]
				delSql = "DELETE FROM STRG_MEET_INVOICE WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
				pstmtDel = conn.prepareStatement(delSql);
				pstmtDel.setString(1, dcrId);
				pstmtDel.setString(2, strgCode);
				pstmtDel.setString(3, tranId);
				strgDelCnt = pstmtDel.executeUpdate();
				System.out.println("STRG_MEET_INVOICE delete count"+ strgDelCnt);
				pstmtDel.close(); pstmtDel = null;
				//ADDED BY BHAGYASHRI T FOR DELETE DATA FROM INVOICE TABLE[04/08/2022]
				
				//ADDED BY PRACHI K [W22EBAS005] ON 08-AUG-2022
				delSql = "DELETE FROM STRG_MEET_COLLECT WHERE DCR_ID= ? AND STRG_CODE = ?";
				pstmtDel = conn.prepareStatement(delSql);
				pstmtDel.setString(1, dcrId);
				pstmtDel.setString(2, strgCode);
				strgDelCnt = pstmtDel.executeUpdate();
				pstmtDel.close(); pstmtDel = null;

				System.out.println("STRG_MEET_COLLECT delete count"+ strgDelCnt);
				
				delSql = "DELETE FROM STRG_MEET_TEAM WHERE DCR_ID= ? AND STRG_CODE = ?";
				pstmtDel = conn.prepareStatement(delSql);
				pstmtDel.setString(1, dcrId);
				pstmtDel.setString(2, strgCode);
				strgDelCnt = pstmtDel.executeUpdate();
				pstmtDel.close(); pstmtDel = null;

				System.out.println("STRG_MEET_ORDER delete count"+ strgDelCnt);

				delSql = "DELETE FROM STRG_MEET_ITEMS WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
				pstmtDel = conn.prepareStatement(delSql);
				pstmtDel.setString(1, dcrId);
				pstmtDel.setString(2, strgCode);
				pstmtDel.setString(3, tranId);
				strgDelCnt = pstmtDel.executeUpdate();
				pstmtDel.close(); pstmtDel = null;

				System.out.println("STRG_MEET_ITEMS delete count"+ strgDelCnt);

				delSql = "DELETE FROM STRG_ITEM_DISPLAY WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
				pstmtDel = conn.prepareStatement(delSql);
				pstmtDel.setString(1, dcrId);
				pstmtDel.setString(2, strgCode);
				pstmtDel.setString(3, tranId);
				strgDelCnt = pstmtDel.executeUpdate();
				pstmtDel.close(); pstmtDel = null;

				System.out.println("STRG_ITEM_DISPLAY delete count"+ strgDelCnt);

				delSql = "DELETE FROM STRG_BRAND_PITCH WHERE DCR_ID= ? AND SC_CODE = ? AND TRAN_ID = ?";
				pstmtDel = conn.prepareStatement(delSql);
				pstmtDel.setString(1, dcrId);
				pstmtDel.setString(2, strgCode);
				pstmtDel.setString(3, tranId);
				strgDelCnt = pstmtDel.executeUpdate();
				pstmtDel.close(); pstmtDel = null;

				System.out.println("STRG_BRAND_PITCH delete count"+ strgDelCnt);

				

				delSql = "DELETE FROM STRG_BRAND_SURVEY WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
				pstmtDel = conn.prepareStatement(delSql);
				pstmtDel.setString(1, dcrId);
				pstmtDel.setString(2, strgCode);
				pstmtDel.setString(3, tranId);
				strgDelCnt = pstmtDel.executeUpdate();
				pstmtDel.close(); pstmtDel = null;
				System.out.println("STRG_BRAND_SURVEY delete count"+ strgDelCnt);

				delSql = "DELETE FROM STRG_MEET WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
				pstmtDel = conn.prepareStatement(delSql);
				pstmtDel.setString(1, dcrId);
				pstmtDel.setString(2, strgCode);
				pstmtDel.setString(3, tranId);
				strgDelCnt = pstmtDel.executeUpdate();
				pstmtDel.close(); pstmtDel = null;

				System.out.println("STRG_MEET delete count"+ strgDelCnt);

				delSql = "DELETE FROM STRG_CUST_ADD WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
				pstmtDel = conn.prepareStatement(delSql);
				pstmtDel.setString(1, dcrId);
				pstmtDel.setString(2, strgCode);
				pstmtDel.setString(3, tranId);
				strgDelCnt = pstmtDel.executeUpdate();
				pstmtDel.close(); pstmtDel = null;

				System.out.println("STRG_CUST_ADD delete count"+ strgDelCnt);
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}



			String delTrvSql="DELETE FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND SPRS_CODE__WW = ? AND TRAVEL_DATE = ?"; 
			pstmtDel = conn.prepareStatement(delTrvSql);
			pstmtDel.setString(1, userId);
			pstmtDel.setString(2, sprsCodeWW);
			pstmtDel.setTimestamp( 3, java.sql.Timestamp.valueOf(eventDate));
			trvDelCnt = pstmtDel.executeUpdate();
			pstmtDel.close(); pstmtDel = null;

			System.out.println("STRG_MEET delete count"+ trvDelCnt);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmtDel != null )
				{
					pstmtDel.close();
					pstmtDel = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception : StrgMeetDCRWizPosSave :deleteCustomerData :==>\n");
				throw new ITMException(e);
			}
		}
	}
	public String getObjNameFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	{
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
				break;

			}
			if(objName == null || objName.trim().length() == 0)
			{
				NodeList objNameList = dom.getElementsByTagName("objName");
				if(objNameList != null && objNameList.getLength() > 0)
				{
					Node objNameNode = objNameList.item(0);
					if(objNameNode != null && objNameNode.getFirstChild() != null)
					{
						objName = checkNull(objNameNode.getFirstChild().getNodeValue());
					}
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return objName;
	}
	private void deleteCustomerData(String salesPers, String eventDate, String localityCode, String routeId, String salesPersWW, String placeTranId, Connection conn) throws ITMException
	{
		System.out.println("inside deleteCustomerData::");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmtDel = null;
		String dcrId = "", strgCode = "", tranId = "";
		String delSql = "";
		int strgDelCnt = 0;
		PreparedStatement pstmtCheck = null;
		ResultSet rsCheck = null;
		PreparedStatement pstmtSel = null;
		ResultSet rsSel = null;
		ArrayList<String> strgList = new ArrayList<String>();

		try
		{
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			String sql = "SELECT DCR_ID,TRAN_ID,STRG_CODE,SURVEY_TEMPL,SALES_PERS FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE = ? AND LOCALITY_CODE = ? AND ROUTE_ID = ? AND SPRS_CODE__WW = ? AND REF_TRAN_ID = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(eventDate));
			pstmt.setString(3, localityCode);
			pstmt.setString(4, routeId);
			pstmt.setString(5, salesPersWW);
			pstmt.setString(6, placeTranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				dcrId = checkNull(rs.getString("DCR_ID"));
				strgCode = checkNull(rs.getString("STRG_CODE"));
				tranId = checkNull(rs.getString("TRAN_ID"));

				if(!strgList.contains(strgCode))
				{
					strgList.add(strgCode);

					/*String checkSql = "SELECT COUNT(*) AS COUNT FROM STRG_MEET WHERE DCR_ID = ? AND STRG_CODE = ?";
					pstmtCheck = conn.prepareStatement(checkSql);
					pstmtCheck.setString(1, dcrId);
					pstmtCheck.setString(2, strgCode);
					rsCheck = pstmtCheck.executeQuery();
					if(rsCheck.next() && rsCheck.getInt("COUNT") > 1)
					{
						String selectSql = "SELECT MIN(TRAN_ID) AS TRAN_ID FROM STRG_MEET WHERE DCR_ID = ? AND STRG_CODE = ?";
						pstmtSel = conn.prepareStatement(selectSql);
						pstmtSel.setString(1, dcrId);
						pstmtSel.setString(2, strgCode);
						rsSel = pstmtSel.executeQuery();
						if(rsCheck.next())
						{
							tranId = checkNull(rs.getString("TRAN_ID"));
						}
					}*/

					//added by prachi on 29-sep-2022 start
					String salesPerson=checkNull(rs.getString("SALES_PERS"));
					String surveyTempl=checkNull(rs.getString("SURVEY_TEMPL"));
					
					String SurveyStatus="";
					String surveryStatusSQL ="SELECT DISTINCT(SURV_STATUS) AS SURV_STATUS FROM STRG_SURV_RES WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
					PreparedStatement pSS = conn.prepareStatement(surveryStatusSQL);
					pSS.setString(1, dcrId);
					pSS.setString(2, strgCode);
					pSS.setString(3, tranId);
					ResultSet rSS = pSS.executeQuery();
					if(rSS.next())
					{
						SurveyStatus=checkNull(rSS.getString("SURV_STATUS"));
					}
					if( rSS != null )
					{
						rSS.close();
						rSS = null;
					}
					if( pSS != null )
					{
						pSS.close();
						pSS = null;
					}
					
					delSql = "DELETE FROM STRG_SURV_RES WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					int survyDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_SURV_RES delete count"+ survyDelCnt+" SurveyStatus:"+SurveyStatus);
					pstmtDel.close(); pstmtDel = null;
					
					if(survyDelCnt>0 && SurveyStatus.equals("Y"))
					{
						String maxDCRID="";
						String maxID="SELECT MAX(SM.DCR_ID) AS DCR_ID FROM STRG_MEET SM,STRG_SURV_RES SR WHERE SM.DCR_ID!=? AND SM.STRG_CODE=? AND SM.SURVEY_TEMPL=? AND SM.SALES_PERS=? AND"
						+ " SR.DCR_ID=SM.DCR_ID AND SR.STRG_CODE=SM.STRG_CODE AND SR.TRAN_ID=SM.TRAN_ID";
						   
						PreparedStatement ps = conn.prepareStatement(maxID);
						ps.setString(1, dcrId);
						ps.setString(2, strgCode);
						ps.setString(3, surveyTempl);
					    ps.setString(4, salesPerson);
						ResultSet rs1=ps.executeQuery();
						if(rs1.next())
						{
						  maxDCRID=checkNull(rs1.getString("DCR_ID"));
						  String updSurveySubSql = " UPDATE STRG_SURV_RES SET SURV_STATUS = 'Y' WHERE DCR_ID = ? AND STRG_CODE = ?";
						  PreparedStatement pstmtupdSurveySub =  conn.prepareStatement(updSurveySubSql);
						  pstmtupdSurveySub.setString(1, maxDCRID);
						  pstmtupdSurveySub.setString(2, strgCode);
						  int updCount = pstmtupdSurveySub.executeUpdate();
						  if(pstmtupdSurveySub!=null)
						  {
							  pstmtupdSurveySub.close(); 
							  pstmtupdSurveySub = null;
						  }
							System.out.println("STRG_SURV_RES is Updated updCount:["+updCount+"]");
						}
						if( rs1 != null )
						{
							rs1.close();
							rs1 = null;
						}
						if( ps != null )
						{
							ps.close();
							ps = null;
						}
						
					}

					//end
					
					delSql = "DELETE FROM STRG_MEET_ORDER WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("strg_meet delete count"+ strgDelCnt);
					pstmtDel.close(); pstmtDel = null;
					
					//ADDED BY BHAGYASHRI T FOR DELETE DATA FROM INVOICE TABLE[04/08/2022]
					delSql = "DELETE FROM STRG_MEET_INVOICE WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_MEET_INVOICE delete count"+ strgDelCnt);
					pstmtDel.close(); pstmtDel = null;
					//ADDED BY BHAGYASHRI T FOR DELETE DATA FROM INVOICE TABLE[04/08/2022]
					
					//ADDED BY PRACHI K [W22EBAS005] ON 08-AUG-2022
					delSql = "DELETE FROM STRG_MEET_COLLECT WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_MEET_COLLECT delete count"+ strgDelCnt);
					pstmtDel.close(); pstmtDel = null;
					//END
					
					delSql = "DELETE FROM STRG_MEET_TEAM WHERE DCR_ID= ? AND STRG_CODE = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_MEET_ORDER delete count"+ strgDelCnt);
					pstmtDel.close(); pstmtDel = null;

					delSql = "DELETE FROM STRG_MEET_ITEMS WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_MEET_ITEMS delete count"+ strgDelCnt);
					pstmtDel.close(); pstmtDel = null;

					delSql = "DELETE FROM STRG_ITEM_DISPLAY WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_ITEM_DISPLAY delete count"+ strgDelCnt);
					pstmtDel.close(); pstmtDel = null;

					delSql = "DELETE FROM STRG_BRAND_PITCH WHERE DCR_ID= ? AND SC_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_BRAND_PITCH delete count"+ strgDelCnt);
					pstmtDel.close(); pstmtDel = null;

					
					delSql = "DELETE FROM STRG_BRAND_SURVEY WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_BRAND_SURVEY delete count"+ strgDelCnt);
					pstmtDel.close(); pstmtDel = null;

					delSql = "DELETE FROM STRG_CUST_ADD WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_CUST_ADD delete count"+ strgDelCnt);
					pstmtDel.close(); pstmtDel = null;

					delSql = "DELETE FROM STRG_MEET WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_MEET delete count"+ strgDelCnt);

					if ( pstmtDel != null )
					{
						pstmtDel.close();
						pstmtDel = null;
					}
				}
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception exp)
		{
			System.out.println("Exception : StrgMeetDCRWizPosSave :deleteCustomerData :==>\n");
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if (pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmtDel != null )
				{
					pstmtDel.close();
					pstmtDel = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception : StrgMeetDCRWizPosSave :deleteCustomerData :==>\n");
				throw new ITMException(e);
			}
		}
	}

	private void deleteCustomerDataCustTypeWise(String salesPers, String eventDate, String localityCode, String routeId, String salesPersWW, String placeTranId,  ArrayList visitList, Connection conn) throws ITMException
	{
		System.out.println("inside deleteCustomerData::");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmtDel = null;
		String dcrId = "", strgCode = "", tranId = "";
		String delSql = "";
		int strgDelCnt = 0;
		PreparedStatement pstmtCheck = null;
		ResultSet rsCheck = null;
		PreparedStatement pstmtSel = null;
		ResultSet rsSel = null;
		ArrayList<String> strgList = new ArrayList<String>();
		String CustTypeList = "";
		String drVisit = "", chemVisit = "", stockVisit = "", othVisit = ""; 

		try
		{
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			String checkSql = "SELECT LOCALITY_CODE, ROUTE_ID, DR_VISIT, CHEM_VISIT, STOCKIST_VISIT, OTHER_VISIT FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE = ? AND LOCALITY_CODE = ? AND ROUTE_ID = ? AND SPRS_CODE__WW = ? AND TRAN_ID = ?";
			pstmt = conn.prepareStatement(checkSql);
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(eventDate));
			pstmt.setString(3, localityCode);
			pstmt.setString(4, routeId);
			pstmt.setString(5, salesPersWW);
			pstmt.setString(6, placeTranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				drVisit = rs.getString("DR_VISIT");
				chemVisit = rs.getString("CHEM_VISIT");
				stockVisit = rs.getString("STOCKIST_VISIT");
				othVisit = rs.getString("OTHER_VISIT");
			}
			//Added by Hariom S for connection close  -- 28-Dec-20 [Start]
			if (rs !=null )
			{
				rs.close();
				rs = null;
			}
			if (pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}
			//Added by Hariom S for connection close  -- 28-Dec-20 [End]
			if("N".equalsIgnoreCase((String)visitList.get(0)) && "Y".equalsIgnoreCase(drVisit))
			{
				if(CustTypeList == "" || CustTypeList.length() == 0)
				{
					CustTypeList = "'D'";
				}
				else
				{
					CustTypeList = CustTypeList +",'D'";
				}
			}
			if("N".equalsIgnoreCase((String)visitList.get(1)) && "Y".equalsIgnoreCase(chemVisit))
			{
				if(CustTypeList == "" || CustTypeList.length() == 0)
				{
					CustTypeList = "'C'";
				}
				else
				{
					CustTypeList = CustTypeList +",'C'";
				}
			}
			if("N".equalsIgnoreCase((String)visitList.get(2)) && "Y".equalsIgnoreCase(stockVisit))
			{
				if(CustTypeList == "" || CustTypeList.length() == 0)
				{
					CustTypeList = "'S'";
				}
				else
				{
					CustTypeList = CustTypeList +",'S'";
				}
			}
			if("N".equalsIgnoreCase((String)visitList.get(3)) && "Y".equalsIgnoreCase(othVisit))
			{
				if(CustTypeList == "" || CustTypeList.length() == 0)
				{
					CustTypeList = "'O'";
				}
				else
				{
					CustTypeList = CustTypeList +",'O'";
				}
			}

			if(CustTypeList == "" || CustTypeList.length() == 0)
			{
				CustTypeList = "'X'";
			}

			String sql = "SELECT DCR_ID,TRAN_ID,STRG_CODE,SURVEY_TEMPL,SALES_PERS FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE = ? AND LOCALITY_CODE = ? AND ROUTE_ID = ? AND SPRS_CODE__WW = ? AND REF_TRAN_ID = ? AND STRG_TYPE IN ("+CustTypeList+")";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(eventDate));
			pstmt.setString(3, localityCode);
			pstmt.setString(4, routeId);
			pstmt.setString(5, salesPersWW);
			pstmt.setString(6, placeTranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				dcrId = checkNull(rs.getString("DCR_ID"));
				strgCode = checkNull(rs.getString("STRG_CODE"));
				tranId = checkNull(rs.getString("TRAN_ID"));

				if(!strgList.contains(strgCode))
				{
					strgList.add(strgCode);

					/*String checkSql = "SELECT COUNT(*) AS COUNT FROM STRG_MEET WHERE DCR_ID = ? AND STRG_CODE = ?";
					pstmtCheck = conn.prepareStatement(checkSql);
					pstmtCheck.setString(1, dcrId);
					pstmtCheck.setString(2, strgCode);
					rsCheck = pstmtCheck.executeQuery();
					if(rsCheck.next() && rsCheck.getInt("COUNT") > 1)
					{
						String selectSql = "SELECT MIN(TRAN_ID) AS TRAN_ID FROM STRG_MEET WHERE DCR_ID = ? AND STRG_CODE = ?";
						pstmtSel = conn.prepareStatement(selectSql);
						pstmtSel.setString(1, dcrId);
						pstmtSel.setString(2, strgCode);
						rsSel = pstmtSel.executeQuery();
						if(rsCheck.next())
						{
							tranId = checkNull(rs.getString("TRAN_ID"));
						}
					}*/

					//added by prachi on 29-sep-22
					String salesPerson=checkNull(rs.getString("SALES_PERS"));
					String surveyTempl=checkNull(rs.getString("SURVEY_TEMPL"));
					
					delSql = "DELETE FROM STRG_SURV_RES WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					int survyDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_SURV_RES delete count"+ survyDelCnt);
					pstmtDel.close(); pstmtDel = null;

					if(survyDelCnt>0)
					{
						   String maxDCRID="";
						   String maxID="SELECT MAX(SM.DCR_ID) AS DCR_ID FROM STRG_MEET SM,STRG_SURV_RES SR WHERE SM.DCR_ID<(?) AND SM.STRG_CODE=? AND SM.SURVEY_TEMPL=? AND SM.SALES_PERS=? AND"
										+ " SR.DCR_ID=SM.DCR_ID AND SR.STRG_CODE=SM.STRG_CODE AND SR.TRAN_ID=SM.TRAN_ID";
						   
						   PreparedStatement ps = conn.prepareStatement(maxID);
						   ps.setString(1, dcrId);
						   ps.setString(2, strgCode);
						   ps.setString(3, surveyTempl);
						   ps.setString(4, salesPerson);
						   ResultSet rs1=ps.executeQuery();
						   if(rs1.next())
							{
							  maxDCRID=checkNull(rs1.getString("DCR_ID"));
							  String updSurveySubSql = " UPDATE STRG_SURV_RES SET SURV_STATUS = 'Y' WHERE DCR_ID = ? AND STRG_CODE = ?";
							  PreparedStatement pstmtupdSurveySub =  conn.prepareStatement(updSurveySubSql);
							  pstmtupdSurveySub.setString(1, maxDCRID);
							  pstmtupdSurveySub.setString(2, strgCode);
							  int updCount = pstmtupdSurveySub.executeUpdate();
							  if(pstmtupdSurveySub!=null)
							  {
								  pstmtupdSurveySub.close(); 
								  pstmtupdSurveySub = null;
							  }
								System.out.println("STRG_SURV_RES is Updated updCount:["+updCount+"]");
							}
						    if( rs1 != null )
							{
								rs1.close();
								rs1 = null;
							}
							if( ps != null )
							{
								ps.close();
								ps = null;
							}
						
					}
					//end
					
					delSql = "DELETE FROM STRG_MEET_ORDER WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("strg_meet delete count"+ strgDelCnt);
					pstmtDel.close(); pstmtDel = null;
					
					//ADDED BY BHAGYASHRI T FOR DELETE DATA FROM INVOICE TABLE[04/08/2022]
					delSql = "DELETE FROM STRG_MEET_INVOICE WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_MEET_INVOICE delete count"+ strgDelCnt);
					pstmtDel.close(); pstmtDel = null;
					//ADDED BY BHAGYASHRI T FOR DELETE DATA FROM INVOICE TABLE[04/08/2022]
					
					//added by prachi on 08-AUG-22 [W22EBAS005]
					delSql = "DELETE FROM STRG_MEET_COLLECT WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_MEET_COLLECT delete count"+ strgDelCnt);
					pstmtDel.close(); pstmtDel = null;
					//END
					
					delSql = "DELETE FROM STRG_MEET_TEAM WHERE DCR_ID= ? AND STRG_CODE = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_MEET_ORDER delete count"+ strgDelCnt);
					pstmtDel.close(); pstmtDel = null;

					delSql = "DELETE FROM STRG_MEET_ITEMS WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_MEET_ITEMS delete count"+ strgDelCnt);
					pstmtDel.close(); pstmtDel = null;

					delSql = "DELETE FROM STRG_ITEM_DISPLAY WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_ITEM_DISPLAY delete count"+ strgDelCnt);
					pstmtDel.close(); pstmtDel = null;

					delSql = "DELETE FROM STRG_BRAND_PITCH WHERE DCR_ID= ? AND SC_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_BRAND_PITCH delete count"+ strgDelCnt);
					pstmtDel.close(); pstmtDel = null;

					
					delSql = "DELETE FROM STRG_BRAND_SURVEY WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_BRAND_SURVEY delete count"+ strgDelCnt);
					pstmtDel.close(); pstmtDel = null;

					delSql = "DELETE FROM STRG_CUST_ADD WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_CUST_ADD delete count"+ strgDelCnt);
					pstmtDel.close(); pstmtDel = null;

					delSql = "DELETE FROM STRG_MEET WHERE DCR_ID= ? AND STRG_CODE = ? AND TRAN_ID = ?";
					pstmtDel = conn.prepareStatement(delSql);
					pstmtDel.setString(1, dcrId);
					pstmtDel.setString(2, strgCode);
					pstmtDel.setString(3, tranId);
					strgDelCnt = pstmtDel.executeUpdate();
					System.out.println("STRG_MEET delete count"+ strgDelCnt);

					if ( pstmtDel != null )
					{
						pstmtDel.close();
						pstmtDel = null;
					}
				}
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception exp)
		{
			System.out.println("Exception : StrgMeetDCRWizPosSave :deleteCustomerData :==>\n");
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if (pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmtDel != null )
				{
					pstmtDel.close();
					pstmtDel = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception : StrgMeetDCRWizPosSave :deleteCustomerData :==>\n");
				throw new ITMException(e);
			}
		}
	}
	private int updateActivityCodeInEditMode(String salesPers, String eventDate,String activityCode,String activityType,Connection conn) throws ITMException
	{
		int updateCnt=0;
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		try
		{
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			String oldActCode="";
			String oldActType="";
			String sql="SELECT SP.ACTIVITY_CODE,F.ACTIVITY_TYPE FROM SPRS_ACT_TRAN SP,FIELDACTIVITY F WHERE SALES_PERS=? AND EVENT_DATE=? AND SP.ACTIVITY_CODE=F.ACTIVITY_CODE";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(eventDate));
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				oldActCode=checkNull(rs.getString("ACTIVITY_CODE"));
				oldActType=checkNull(rs.getString("ACTIVITY_TYPE"));
			}
			if (rs !=null )
			{
				rs.close();
				rs = null;
			}
			if (pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}
			if(oldActType.equalsIgnoreCase(activityType) && !oldActCode.equalsIgnoreCase(activityCode)) 
			{
				int placeCnt=0;
				String placeSql="SELECT COUNT(*) AS COUNT FROM SPRS_TRAVEL WHERE SALES_PERS=? AND TRAVEL_DATE=? AND ACTIVITY_CODE<> 'JW' ";
				pstmt=conn.prepareStatement(placeSql);
				pstmt.setString(1, salesPers);
				pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(eventDate));
				rs=pstmt.executeQuery();
				if(rs.next())
				{
					placeCnt=rs.getInt("COUNT");
				}
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if (pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				if(placeCnt>0)
				{
					String updatePlaceSql="UPDATE SPRS_TRAVEL SET ACTIVITY_CODE=? WHERE SALES_PERS=? AND TRAVEL_DATE=? AND ACTIVITY_CODE<> 'JW' ";
					pstmt=conn.prepareStatement(updatePlaceSql);
					pstmt.setString(1, activityCode);
					pstmt.setString(2, salesPers);
					pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(eventDate));
					updateCnt=pstmt.executeUpdate();
					System.out.println("SPRS_TRAVEL update activity count"+ updateCnt);
					
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
				}
				
				int meetCnt=0;
				String meetSql="SELECT COUNT(*) AS COUNT FROM STRG_MEET WHERE SALES_PERS=? AND EVENT_DATE=? AND EVENT_TYPE<> 'JW' ";
				pstmt=conn.prepareStatement(meetSql);
				pstmt.setString(1, salesPers);
				pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(eventDate));
				rs=pstmt.executeQuery();
				if(rs.next())
				{
					meetCnt=rs.getInt("COUNT");
				}
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if (pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				if(meetCnt>0)
				{
					String updatePlaceSql="UPDATE STRG_MEET SET EVENT_TYPE=? WHERE SALES_PERS=? AND EVENT_DATE=? AND EVENT_TYPE<> 'JW' ";
					pstmt=conn.prepareStatement(updatePlaceSql);
					pstmt.setString(1, activityCode);
					pstmt.setString(2, salesPers);
					pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(eventDate));
					int updateCust=pstmt.executeUpdate();
					System.out.println("STRG_MEET update activity count"+ updateCust);
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
				}
				
			}
		}
		catch (Exception exp)
		{
			System.out.println("Exception : StrgMeetDCRWizreSave :updateActivityCodeInEditMode :==>\n");
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if (pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception : StrgMeetDCRWizPosSave :updateActivityCodeInEditMode :==>\n");
				throw new ITMException(e);
			}
		}
		return updateCnt;
	}

}
