package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;

public class StrgEventTrackWizConf extends ActionHandlerEJB
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	
	public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		String retString = "";
		boolean isError = false;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		boolean isLocalConn = false;
		int count = 0;
		String empCodeConf = "";
		Connection conn = null;	
	    String sql1="";
	    String currDate = "";
	    
		try
		{
			//System.out.println("tranId StrgEventTrackWizConf ::"+tranId);
			//System.out.println("StrgMeetDCRWizConf confirm method is called.........");
			if(conn == null)
			{
				conn = getConnection();
				isLocalConn = true;
				conn.setAutoCommit( false );
			}
			if(!xtraParams.contains("#"))
			{
				empCodeConf = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
			}
			else
			{
				String[] xtraParmArr = xtraParams.split("#");
				empCodeConf = xtraParmArr[0];
			}
			
			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );

			String pDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			//System.out.println("currDate ::>>>>>>["+currDate+"]");
			
			sql1 = "UPDATE STRG_EVENT_TRACK SET CONFIRMED = ?,CONF_DATE = ? WHERE TRAN_ID = ?";
			pStmt = conn.prepareStatement(sql1);
			pStmt.setString(1,"Y");
			pStmt.setTimestamp(2,java.sql.Timestamp.valueOf(pDate));
			pStmt.setString(3,tranId);
			count = pStmt.executeUpdate();
			
			if(pStmt!=null)
			{
				pStmt.close();
				pStmt = null;
			}
			
			System.out.println("updateStrgEventTrackWizActCnt........."+count);
			
			ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
			if(count>0)
			{
			  retString =	itmDBAccessEJB.getErrorString("","CONFSUCCAT","");
			}  
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("Exception :StrgEventTrackWizConf :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("isError ["+isError+"]");
				System.out.println("isLocalConn ["+isLocalConn+"]");
				if( conn != null )
				{

					if( isError )
					{
						conn.rollback();
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					if ( isLocalConn )
					{
						if ( ! isError )
						{
							conn.commit();
							System.out.println("StrgEventTrackWizConf Connection commited........");
						}
						conn.close();
						conn = null;
					}

				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :StrgEventTrackWizConf :confirm :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("[StrgEventTrackWizConf]Return string :"+retString);
		return retString;
	}
		
	private String checkNull(String value)
	{
	   if ( value == null )
	   {
		   value = "";
	   }
	   return value.trim();
	}

}
