package ibase.webitm.ejb.wsfa.transactions;

import ibase.webitm.utility.*;
import ibase.system.config.*;
import ibase.scheduler.utility.interfaces.Schedule;
import ibase.utility.CommonConstants;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;

import java.sql.*;
import java.util.*;
import java.text.*;
import java.io.*;
import ibase.utility.UserInfoBean;

public class StrgCustUploadSchedule implements Schedule
{
	String scheduleParamXML = "";
	public String schedule(HashMap map) throws Exception
    {
	 	System.out.println(schedule((String) map.get("PROCESS_NAME")));
	 	return schedule((String) map.get("PROCESS_NAME"));
    }

    public String schedule(String schedule) throws Exception
    {
    	System.out.println("^^^^^^^ inside schedule ^^^^^^^"+schedule);
    	this.scheduleParamXML = schedule; //Added by kailash on 08-12-18.
    	this.uploadCustomers();
    	return schedule;
    }

    public String schedulePriority(String arg0) throws Exception
    {
    	return null;
    }
	private void uploadCustomers() throws ITMException
    {
		boolean isError = false;
		Connection conn = null;
		
		try
        {
			//Added by kailash pal to remove hard code DriverITM(start)
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;*/
			UserInfoBean userInfo = new UserInfoBean(scheduleParamXML);
			if( userInfo != null && userInfo.getTransDB() != null )
			{
				String transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );
				System.out.println("transDB is:52"+transDB);
				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB(transDB);	
			}
			//Added by kailash pal to remove hard code DriverITM(end)
			conn.setAutoCommit(false);

			//changed by Rahul Barve on 3-sep-2014
			//GenericUtility genericUtility = GenericUtility.getInstance();
			 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			
			
            String selctSPDataSql = " SELECT DISTINCT(SALES_PERS) "+
									" FROM STRGCUST_UPLOAD " +
									" WHERE (ERROR_STATUS IS NULL OR ERROR_STATUS <> 'Y') AND (LOAD_STATUS IS NULL OR LOAD_STATUS <> 'Y') " ;
            PreparedStatement pstmtSPData = conn.prepareStatement( selctSPDataSql );
            
			ResultSet rsSPData = pstmtSPData.executeQuery();
			while ( rsSPData.next() )
			{
				String sprsCode = rsSPData.getString( "SALES_PERS" );
				insertNewCustomersDetail(sprsCode, "" , null ,conn);	//Added ScCode in method while uploading Customer[04-DEC-23]
				//Added userInfo in method while uploading customer
				//conn.commit();
			}
			rsSPData.close();rsSPData = null;
			pstmtSPData.close(); pstmtSPData = null;
			
        }
		catch (Exception e)
		{
			isError = true;
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null && !conn.isClosed())
				{
					if ( !isError )
					{
						conn.commit();
					}
					else
					{
						conn.rollback();
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e){}
		}
    }
	private String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input;
	}

	private String checkNullAndTrim(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	
	private String getNewRouteID(String sprsCode, Connection conn) throws Exception
	{
		String newRouteID = "1";
		String maxRoutesql = "SELECT MAX(TO_NUMBER(SPRS_ROUTE.ROUTE_ID))+1 FROM SPRS_ROUTE WHERE SPRS_CODE = ? ";
				
		ResultSet rsMaxRoute = null;
		PreparedStatement pstmtMaxRoute = null;
		try
		{
			pstmtMaxRoute = conn.prepareStatement(maxRoutesql);
					
			pstmtMaxRoute.setString(1,sprsCode);       
	
			rsMaxRoute = pstmtMaxRoute.executeQuery();
			if(rsMaxRoute.next())
			{
				newRouteID =  ""+rsMaxRoute.getInt(1);  
				System.out.println("********** Max Route_Id ******************" + newRouteID);
			}
			if ("0".equals(newRouteID.trim()))
			{
				newRouteID = "1";
			}
			rsMaxRoute.close();    
			rsMaxRoute = null;          
			pstmtMaxRoute.close();
			pstmtMaxRoute = null;

		}
		catch( Exception e )
		{
			throw e;
		}
		System.out.println("newRouteID =["+newRouteID+"]");
		return newRouteID;
	}
	
	//Added enterprise in method for Route Logic
	private String getRouteID( String tranID, String sprsCode, String  localityCode, String enterPrise, Connection conn ) throws Exception
	{
		ResultSet selectRouteRS = null;
		PreparedStatement pstmtSelectRoute = null;
		ResultSet rsSelectStrgCust = null;
		PreparedStatement pstmtSelectStrgCust = null;
		PreparedStatement pstmtInsertSprsRoute = null;
		String routeId = "",stationCode = "",stanCode = "",localityType = "",localitySubType = "",routeType = "";
		try
		{
			String selectRouteSql = "SELECT ROUTE_ID FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = ? ";
			pstmtSelectRoute = conn.prepareStatement(selectRouteSql);
			pstmtSelectRoute.setString(1, sprsCode);
			pstmtSelectRoute.setString(2, localityCode);
			
			selectRouteRS = pstmtSelectRoute.executeQuery();
			if( selectRouteRS.next() )
			{
				routeId = selectRouteRS.getString("ROUTE_ID");
			}
			else
			{
				//insert into sprsroute for the localities not found for the salesPerson.
				//INSERT INTO SPRS_ROUTE( , , ,  );
				routeId = getNewRouteID(sprsCode, conn) ;
				
				String localityDescr = "";
				String stationType = "";
				String chgUser="";
				
				//changed by Rahul Barve on 3-sep-2014
				//GenericUtility genericUtility = GenericUtility.getInstance();
				 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
				SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
				
				String currDate = sdf.format(new java.util.Date());
				currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

				String selectStrgCustSql = "SELECT LOCALITY_DESCR, STAN_TYPE ,STAN_CODE ,LOADED_BY FROM STRGCUST_UPLOAD WHERE TRAN_ID = ? AND LOCALITY_CODE = ? ";
				pstmtSelectStrgCust = conn.prepareStatement(selectStrgCustSql);
				pstmtSelectStrgCust.setString(1, tranID);
				pstmtSelectStrgCust.setString(2, localityCode);
				rsSelectStrgCust = pstmtSelectStrgCust.executeQuery();
				if(rsSelectStrgCust.next())
				{
					localityDescr = checkNull(rsSelectStrgCust.getString("LOCALITY_DESCR"));
					stationType = checkNull(rsSelectStrgCust.getString("STAN_TYPE"));
					stanCode = checkNull(rsSelectStrgCust.getString("STAN_CODE"));//Added to get stationCode
					chgUser = checkNull(rsSelectStrgCust.getString("LOADED_BY"));
				}
				rsSelectStrgCust.close(); rsSelectStrgCust = null;
				
				String selectStanCodeSql = "SELECT STAN_CODE,LOCALITY_TYPE,LOCALITY_SUBTYPE FROM LOCALITY WHERE LOCALITY_CODE = ? ";
				PreparedStatement pstmtStanCode = conn.prepareStatement(selectStanCodeSql);
				pstmtStanCode.setString(1,localityCode);
				ResultSet selectStanCodeRs = pstmtStanCode.executeQuery();
				if (selectStanCodeRs.next())
				{
					stationCode = checkNull(selectStanCodeRs.getString("STAN_CODE"));
					localityType = checkNull(selectStanCodeRs.getString("LOCALITY_TYPE"));//Added to get localityType
					localitySubType = checkNull(selectStanCodeRs.getString("LOCALITY_SUBTYPE"));//Added to get localitySubType
				}
				selectStanCodeRs.close();selectStanCodeRs = null;
				pstmtStanCode.close();pstmtStanCode = null;
				
				/*If stationCode is not null from strgcust_upload table then 
				consider that stationCode otherwise consider stationCode from above query*/
				if(stanCode != null && stanCode.trim().length() > 0)
				{
					stationCode = stanCode;
				}
				
				//Added to get RouteType from stanTypeMst aganist given StationType
				String routeTypeSql = "SELECT ROUTE_TYPE FROM STAN_TYPE_MST WHERE ENTERPRISE = ? AND LOCALITY_TYPE = ? "
			            + " AND LOCALITY_SUB_TYPE = ?  AND STAN_TYPE = ?  AND ACTIVE_YN = 'Y' ";
				PreparedStatement pstmtRouteType = conn.prepareStatement(routeTypeSql);
				pstmtRouteType.setString(1,enterPrise);
				pstmtRouteType.setString(2,localityType);
				pstmtRouteType.setString(3,localitySubType);
				pstmtRouteType.setString(4,stationType);
				ResultSet routeTypeRs = pstmtRouteType.executeQuery();
				if(routeTypeRs.next())
				{
					routeType = checkNull(routeTypeRs.getString("ROUTE_TYPE"));
				}
				if ( routeTypeRs != null )
				{
					routeTypeRs.close();
					routeTypeRs = null;
				}
				if ( pstmtRouteType != null )
				{
					pstmtRouteType.close();
					pstmtRouteType = null;
				}
				
				if(routeType == null || routeType.trim().length() == 0)
				{
					routeType = "H";
				}
				//Added to get RouteType from stanTypeMst aganist given StationType

				String insertSprsRouteSQL = "INSERT INTO SPRS_ROUTE(SPRS_CODE, ROUTE_ID, DESCR , SH_DESCR,REPLY_STATUS,"
											+ " CHG_DATE, CHG_USER, CHG_TERM , STAN_CODE, STATUS, LOCALITY_CODE ,STATION_TYPE, TRAN_ID__REF,ROUTE_TYPE) " +
											" VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
				
				String shDescrLocatlity = "";
				if (localityDescr.trim().length() > 14 )
				{
					shDescrLocatlity = localityDescr.substring(0,14);
				}
				else
				{
					shDescrLocatlity = localityDescr;
				}
				
				pstmtInsertSprsRoute = conn.prepareStatement(insertSprsRouteSQL);
				pstmtInsertSprsRoute.setString(1,sprsCode);
				pstmtInsertSprsRoute.setString(2,routeId);
				pstmtInsertSprsRoute.setString(3,localityDescr);
				pstmtInsertSprsRoute.setString(4,shDescrLocatlity);
				pstmtInsertSprsRoute.setString(5,"0");
				pstmtInsertSprsRoute.setTimestamp(6,java.sql.Timestamp.valueOf(currDate));
				pstmtInsertSprsRoute.setString(7,chgUser);
				pstmtInsertSprsRoute.setString(8,"SYSTEM");
				pstmtInsertSprsRoute.setString(9,stationCode);
				pstmtInsertSprsRoute.setString(10,"Y");
				pstmtInsertSprsRoute.setString(11,localityCode);
				pstmtInsertSprsRoute.setString(12,stationType);
				pstmtInsertSprsRoute.setString(13,tranID);
				pstmtInsertSprsRoute.setString(14,routeType);//Added by Bhagyashri t for fortune upload utility[13-01-22]
				int routeInsertCount = pstmtInsertSprsRoute.executeUpdate();
				
				pstmtInsertSprsRoute.close(); pstmtInsertSprsRoute = null;
				
				if ( routeInsertCount > 0 )
				{
					System.out.println("Inserted Successfully into sprs_route =["+routeInsertCount+"]");
				}
			}
						
		}
		catch( Exception e)
		{
			e.printStackTrace();
			throw e;
		}
		finally
		{
			try
			{
				if(selectRouteRS != null)
				{
					selectRouteRS.close();
					selectRouteRS = null;
				}
				if(rsSelectStrgCust != null)
				{
					rsSelectStrgCust.close();
					rsSelectStrgCust = null;
				}
				if(pstmtSelectRoute != null)
				{
					pstmtSelectRoute.close();
					pstmtSelectRoute = null;
				}
				if(pstmtSelectStrgCust != null)
				{
					pstmtSelectStrgCust.close();
					pstmtSelectStrgCust = null;
				}
				if(pstmtInsertSprsRoute != null)
				{
					pstmtInsertSprsRoute.close();
					pstmtInsertSprsRoute = null;
				}
			}
			catch(Exception e)
			{
				
			}
		}
		return routeId;
		
	}

	//Added ScCode in method while uploading Customer[04-DEC-23]
	//Added userInfo in method while customer upload
	public String insertNewCustomersDetail( String sprsCode, String scCode , UserInfoBean userInfo,Connection conn ) throws Exception
	{
		ResultSet selectMissingCustomerRS = null;
		PreparedStatement pstmtselectMissingCustomer = null;
		boolean isUploadError = false;
		String retString = "",selectMissingCustomerSql= "";
		String uploadID = "";
		try
		{
			//changed by Rahul Barve on 3-sep-2014
			//GenericUtility genericUtility = GenericUtility.getInstance();
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			
			//Added ScCode in SQL query to get single customer[04-DEC-23]
			if(scCode != null && scCode.trim().length() > 0)
			{
				selectMissingCustomerSql = "SELECT A.*, B.ITEM_SER FROM STRGCUST_UPLOAD A, SALES_PERS B "+
						"WHERE A.SALES_PERS = B.SALES_PERS AND A.SC_CODE NOT IN ( SELECT SC_CODE FROM STRG_CUSTOMER ) "+
						"AND A.SALES_PERS = ? AND A.SC_CODE = ? AND (A.ERROR_STATUS IS NULL OR A.ERROR_STATUS <> 'Y') "+
						"AND (A.LOAD_STATUS IS NULL OR A.LOAD_STATUS <> 'Y')";
			}
			else
			{
				selectMissingCustomerSql = "SELECT A.*, B.ITEM_SER FROM STRGCUST_UPLOAD A, SALES_PERS B "+
						"WHERE A.SALES_PERS = B.SALES_PERS AND A.SC_CODE NOT IN ( SELECT SC_CODE FROM STRG_CUSTOMER ) "+
						"AND A.SALES_PERS = ? AND (A.ERROR_STATUS IS NULL OR A.ERROR_STATUS <> 'Y') "+
						"AND (A.LOAD_STATUS IS NULL OR A.LOAD_STATUS <> 'Y')";
			}
			//Added ScCode in SQL query to get single customer[04-DEC-23]
			

			pstmtselectMissingCustomer = conn.prepareStatement(selectMissingCustomerSql);
			pstmtselectMissingCustomer.setString(1,sprsCode);
			//Added ScCode in SQL query to get single customer[04-DEC-23]
			if(scCode != null && scCode.trim().length() > 0)
			{
				pstmtselectMissingCustomer.setString(2,scCode);
			}
			//Added ScCode in SQL query to get single customer[04-DEC-23]
			selectMissingCustomerRS = pstmtselectMissingCustomer.executeQuery();
			while( selectMissingCustomerRS.next() )
			{
				String regNo = selectMissingCustomerRS.getString("REG_NO");
				System.out.println("reg_no >>["+regNo+ "]");
				//insert into STRG_CUSTOMER not found.
				//INSERT INTO STRG_CUSTOMER( , , ,  );
				String tranID = selectMissingCustomerRS.getString("TRAN_ID");
				
				uploadID = tranID;
				
				/*String insertStrgCustSql = "INSERT INTO STRG_CUSTOMER(SC_CODE, FIRST_NAME, MIDDLE_NAME, LAST_NAME," +
										" ADDRESS_AS, QUALIFICATION, ADDR1, ADDR2 , ADDR3, CITY, STAN_CODE ," +
										" STATE_CODE, PIN, COUNT_CODE,TELE1,MOBILE_NO,STATUS,NO_VISIT,SEX, " +
										" BIRTH_DATE,CLASS_CODE,EMAIL_ADDR,CHG_USER,CHG_DATE,CHG_TERM,WEDD_ANIV," +
										//" LOCALITY_CODE,CUST_TYPE,CLASS_CODE_DESCR, TRAN_ID__REF) VALUES (?, ?, ?, ?, ?, ?, ?," +// Commented by kailash.
										" LOCALITY_CODE,CUST_TYPE,CLASS_CODE_DESCR, TRAN_ID__REF, REG_NO) VALUES (?, ?, ?, ?, ?, ?, ?," + //Added REG_NO by kailash on 04-12-18 to incorporate reg_no[W18HMES003].
										" ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";*/  //Added REG_NO value by kailash on 04-12-18 to incorporate reg_no[W18HMES003].
				String insertStrgCustSql = "INSERT INTO STRG_CUSTOMER(SC_CODE, FIRST_NAME, MIDDLE_NAME, LAST_NAME," +
						" ADDRESS_AS, QUALIFICATION, ADDR1, ADDR2 , ADDR3, CITY, STAN_CODE ," +
						" STATE_CODE, PIN, COUNT_CODE,TELE1,MOBILE_NO,STATUS,NO_VISIT,SEX, " +
						" BIRTH_DATE,CLASS_CODE,EMAIL_ADDR,CHG_USER,CHG_DATE,CHG_TERM,WEDD_ANIV," +
						//" LOCALITY_CODE,CUST_TYPE,CLASS_CODE_DESCR, TRAN_ID__REF) VALUES (?, ?, ?, ?, ?, ?, ?," +// Commented by kailash.
						" LOCALITY_CODE,CUST_TYPE,CLASS_CODE_DESCR, TRAN_ID__REF, REG_NO,AGE) VALUES (?, ?, ?, ?, ?, ?, ?," + //Added REG_NO by kailash on 04-12-18 to incorporate reg_no[W18HMES003].
						" ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";  //Added by Bhagyashri for Age column [25-04-22][W22AGOC002]
				PreparedStatement pstmtInsertStrgCust = conn.prepareStatement(insertStrgCustSql);
				
				String addressAs = checkNull(selectMissingCustomerRS.getString("ADDRESS_AS"));
				String custType = checkNullAndTrim(selectMissingCustomerRS.getString("CUST_TYPE"));
				String statusC = checkNullAndTrim(selectMissingCustomerRS.getString("STATUS"));//Added by Bhagyashri t for fortune upload utility[13-01-22]
				String stationCode = "",stanCode = "";
				String stateCode = "";
				String city = "",cityFromSql = "";
				String countryCode = "";
				String localityCode = checkNull(selectMissingCustomerRS.getString("LOCALITY_CODE"));
				
				//Added to get stationCode from strgcust_upload master
				stanCode = checkNull(selectMissingCustomerRS.getString("STAN_CODE"));
				cityFromSql = checkNull(selectMissingCustomerRS.getString("CITY"));
				
				String selectStanCodeSql = "SELECT CITY, STAN_CODE, STATE_CODE, COUNT_CODE FROM LOCALITY WHERE LOCALITY_CODE = ? ";
				PreparedStatement pstmtStanCode = conn.prepareStatement(selectStanCodeSql);
				pstmtStanCode.setString(1,localityCode);
				ResultSet selectStanCodeRs = pstmtStanCode.executeQuery();
				if (selectStanCodeRs.next())
				{
					stationCode = checkNull(selectStanCodeRs.getString("STAN_CODE"));
					stateCode = checkNull(selectStanCodeRs.getString("STATE_CODE"));
					city = checkNull(selectStanCodeRs.getString("CITY"));
					countryCode = checkNull(selectStanCodeRs.getString("COUNT_CODE"));
				}
				selectStanCodeRs.close();selectStanCodeRs = null;
				pstmtStanCode.close();pstmtStanCode = null;
				
				/*If stationCode is not null from strgcust_upload table then 
				consider that stationCode otherwise consider stationCode from above query*/
				if(stanCode != null && stanCode.trim().length() > 0)
				{
					stationCode = stanCode;
				}
				
				if(cityFromSql != null && cityFromSql.trim().length() > 0)
				{
					city = cityFromSql.toUpperCase();
				}

				pstmtInsertStrgCust.setString(1, checkNull(selectMissingCustomerRS.getString("SC_CODE"))); 
				pstmtInsertStrgCust.setString(2, checkNull(selectMissingCustomerRS.getString("FIRST_NAME")));
				pstmtInsertStrgCust.setString(3, checkNull(selectMissingCustomerRS.getString("MIDDLE_NAME")));
				pstmtInsertStrgCust.setString(4, checkNull(selectMissingCustomerRS.getString("LAST_NAME")));
				pstmtInsertStrgCust.setString(5, addressAs);
				pstmtInsertStrgCust.setString(6, checkNull(selectMissingCustomerRS.getString("QUALIFICATION")));
				pstmtInsertStrgCust.setString(7, checkNull(selectMissingCustomerRS.getString("ADDR1")));
				pstmtInsertStrgCust.setString(8, checkNull(selectMissingCustomerRS.getString("ADDR2")));
				pstmtInsertStrgCust.setString(9, checkNull(selectMissingCustomerRS.getString("ADDR3")));
				pstmtInsertStrgCust.setString(10, city);
				pstmtInsertStrgCust.setString(11, stationCode);
				pstmtInsertStrgCust.setString(12, stateCode);
				pstmtInsertStrgCust.setString(13, checkNull(selectMissingCustomerRS.getString("PIN")));
				pstmtInsertStrgCust.setString(14, countryCode);
				pstmtInsertStrgCust.setString(15, checkNull(selectMissingCustomerRS.getString("TELE1")));
				pstmtInsertStrgCust.setString(16, checkNull(selectMissingCustomerRS.getString("MOBILE_NO")));
				//Added by Bhagyashri t for fortune upload utility[13-01-22][start]
				if(statusC !=null && statusC.trim().length()>0)
				{
					pstmtInsertStrgCust.setString(17, statusC);
				}
				else
				{
					pstmtInsertStrgCust.setString(17, "A");
				}
				//Added by Bhagyashri t for fortune upload utility[13-01-22][end]
				pstmtInsertStrgCust.setString(18, checkNull(selectMissingCustomerRS.getString("NO_VISIT")));
				pstmtInsertStrgCust.setString(19, checkNull(selectMissingCustomerRS.getString("SEX")));
				pstmtInsertStrgCust.setDate(20, selectMissingCustomerRS.getDate("BIRTH_DATE"));
				pstmtInsertStrgCust.setString(21, checkNull(selectMissingCustomerRS.getString("CLASS_CODE")));
				pstmtInsertStrgCust.setString(22, checkNull(selectMissingCustomerRS.getString("EMAIL_ADDR")));
				pstmtInsertStrgCust.setString(23, checkNull(selectMissingCustomerRS.getString("LOADED_BY")));
				pstmtInsertStrgCust.setTimestamp(24, java.sql.Timestamp.valueOf(currDate) );
				pstmtInsertStrgCust.setString(25, "SYSTEM");
				pstmtInsertStrgCust.setDate(26, selectMissingCustomerRS.getDate("WEDD_ANIV"));
				pstmtInsertStrgCust.setString(27, checkNull(selectMissingCustomerRS.getString("LOCALITY_CODE")));
				pstmtInsertStrgCust.setString(28, checkNull(selectMissingCustomerRS.getString("CUST_TYPE")));
				pstmtInsertStrgCust.setString(29, checkNull(selectMissingCustomerRS.getString("CLASS_CODE_DESCR")));
				pstmtInsertStrgCust.setString(30, checkNull(selectMissingCustomerRS.getString("TRAN_ID")));
				pstmtInsertStrgCust.setString(31, checkNull(selectMissingCustomerRS.getString("REG_NO")));//Added by kailash on 04-12-18 to incorporate reg_no[W18HMES003]. 
				pstmtInsertStrgCust.setString(32, checkNull(selectMissingCustomerRS.getString("AGE")));//Added by Bhagyashri for Age column [25-04-22][W22AGOC002]
				//Changed by Gulzar on 26/07/12
				//int updtStrgCustCnt = pstmtInsertStrgCust.executeUpdate();
				//pstmtInsertStrgCust.close(); pstmtInsertStrgCust = null;
				
				try
				{
					int updtStrgCustCnt = pstmtInsertStrgCust.executeUpdate();
					if ( updtStrgCustCnt > 0 )
					{
						System.out.println("Inserted Successfully into STRG_CUSTOMER =["+updtStrgCustCnt+"]");
					}
				}
				catch(Exception e)
				{
					conn.rollback();
					pstmtInsertStrgCust.close(); pstmtInsertStrgCust = null;
					generateLog( e, tranID );//Gulzar on 06/10/12
					e.printStackTrace();
					continue;
				}
				if ( pstmtInsertStrgCust != null )
				{
					pstmtInsertStrgCust.close(); pstmtInsertStrgCust = null;
				}
				//End changes by Gulzar on 26/07/12
				
				//Commented and changes by Gulzar on 16/07/12
				/*
				String routeID = getRouteID( tranID, sprsCode, localityCode, conn );
				*/
				String routeID = "";
				try
				{
					//get Enterprise from userInfo and pass it to below method
					String enterPrise = "";
					if(userInfo != null)
					{
						enterPrise = checkNull(userInfo.getEnterprise());
					}
					routeID = getRouteID( tranID, sprsCode, localityCode, enterPrise, conn );
				}
				catch(Exception e)
				{
					conn.rollback();
					generateLog( e, tranID );//Gulzar on 06/10/12
					continue;
				}
				
				//insert into STRG_SERIES not found.
				//INSERT INTO STRG_SERIES( , , ,  );
				
				String splDescr = checkNullAndTrim(selectMissingCustomerRS.getString("SPECIALITY_DESCR"));
				if (splDescr.length() > 0 )
				{
					splDescr = splDescr.split(",")[0];
					splDescr = splDescr.toUpperCase();
				}
				String splcode = "";
				String selectSplCodeSql = "SELECT SPL_CODE FROM SPECIALITY WHERE UPPER(TRIM(DESCR))= ?";
				PreparedStatement pstmtSelectSplCode = conn.prepareStatement(selectSplCodeSql);
				pstmtSelectSplCode.setString(1, splDescr);
				
				ResultSet selectSplCodeRs = pstmtSelectSplCode.executeQuery();
				if (selectSplCodeRs.next())
				{
					splcode = checkNull(selectSplCodeRs.getString("SPL_CODE"));
				}
				selectSplCodeRs.close(); selectSplCodeRs = null;
				pstmtSelectSplCode.close(); pstmtSelectSplCode = null;
				
				int noOfVisit = 0;
				int minIntervalVisit = 0;
				int maxInterValVisit = 0;
				String classCode = checkNull(selectMissingCustomerRS.getString("CLASS_CODE"));
				String selectStrgCustClassSql = "SELECT NO_VISIT, MIN_INTERVAL_VISIT, MAX_INTERVAL_VISIT FROM STRG_CUST_CLASS WHERE CUST_TYPE = ? AND CLASS_CODE = ?";
				PreparedStatement pstmtSelStrgCustClass = conn.prepareStatement(selectStrgCustClassSql);
				pstmtSelStrgCustClass.setString(1, custType);
				pstmtSelStrgCustClass.setString(2, classCode);
				ResultSet rsSelStrgCustClass = pstmtSelStrgCustClass.executeQuery();
				if (rsSelStrgCustClass.next())
				{
					noOfVisit = rsSelStrgCustClass.getInt("NO_VISIT");
					minIntervalVisit = rsSelStrgCustClass.getInt("MIN_INTERVAL_VISIT");
					maxInterValVisit = rsSelStrgCustClass.getInt("MAX_INTERVAL_VISIT");
				}
				rsSelStrgCustClass.close(); rsSelStrgCustClass = null;
				pstmtSelStrgCustClass.close(); pstmtSelStrgCustClass = null;
				
				//Added by ManishK to get itemSer from Department if null [START]
				String itemSer = checkNull(selectMissingCustomerRS.getString("ITEM_SER"));
				if(itemSer.trim().length() == 0)
				{
					String itemSerSql = "SELECT D.ITEM_SER AS ITEM_SER FROM DEPARTMENT D,EMPLOYEE E WHERE E.DEPT_CODE = D.DEPT_CODE AND E.EMP_CODE = ? ";
					PreparedStatement pstmtItemSer = conn.prepareStatement(itemSerSql);
					pstmtItemSer.setString(1, sprsCode);
					ResultSet rsItemSer = pstmtItemSer.executeQuery();
					if(rsItemSer.next())
					{
						itemSer = checkNull(rsItemSer.getString("ITEM_SER"));
					}
					if(rsItemSer != null)
					{
						rsItemSer.close();
						rsItemSer = null;
					}
					if(pstmtItemSer != null)
					{
						pstmtItemSer.close();
						pstmtItemSer = null;
					}
				}
				//Added by ManishK to get itemSer from Department if null [END]
				
				String insertStrgSerSql = "INSERT INTO STRG_SERIES(SC_CODE, ITEM_SER, SALES_PERS,CLASS_CODE,NO_VISIT,CHG_USER,CHG_DATE,CHG_TERM, "+
										"SHORT_ID, EFF_DATE, SPL_CODE ,REPLY_STATUS,ROUTE_ID,NO_VISIT_PER,CLASS_CODE_DESCR,CUST_TYPE,"+
										"STATUS,TRAN_ID__REF, MIN_INTERVAL_VISIT, MAX_INTERVAL_VISIT) " +
										"VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,?, ?, ?, ?, ?) "; 

				PreparedStatement pstmtInsertSS = conn.prepareStatement(insertStrgSerSql);
				
				java.sql.Timestamp effFrom = selectMissingCustomerRS.getTimestamp("EFF_FROM");
				
				pstmtInsertSS.setString(1, checkNull(selectMissingCustomerRS.getString("SC_CODE")));
				//Commented by ManishK to avoid passing itemser blank : START
				//pstmtInsertSS.setString(2, checkNull(selectMissingCustomerRS.getString("ITEM_SER")));
				pstmtInsertSS.setString(2, checkNull(itemSer));
				//Commented by ManishK to avoid passing itemser blank : END
				pstmtInsertSS.setString(3, checkNull(selectMissingCustomerRS.getString("SALES_PERS")));
				pstmtInsertSS.setString(4, checkNull(selectMissingCustomerRS.getString("CLASS_CODE")));
				pstmtInsertSS.setString(5, checkNull(selectMissingCustomerRS.getString("NO_VISIT")));
				pstmtInsertSS.setString(6, checkNull(selectMissingCustomerRS.getString("LOADED_BY")));
				pstmtInsertSS.setTimestamp(7, java.sql.Timestamp.valueOf(currDate));
				pstmtInsertSS.setString(8, "SYSTEM");
				pstmtInsertSS.setString(9, checkNull(selectMissingCustomerRS.getString("SHORT_ID")));
				pstmtInsertSS.setTimestamp(10, selectMissingCustomerRS.getTimestamp("EFF_FROM"));
				pstmtInsertSS.setString(11, splcode);
				pstmtInsertSS.setInt(12, 0);
				pstmtInsertSS.setString(13, routeID);
				pstmtInsertSS.setString(14, "M");
				pstmtInsertSS.setString(15, checkNull(selectMissingCustomerRS.getString("CLASS_CODE_DESCR")));
				pstmtInsertSS.setString(16, checkNull(selectMissingCustomerRS.getString("CUST_TYPE")));
				pstmtInsertSS.setString(17, "Y");
				pstmtInsertSS.setString(18, checkNull(selectMissingCustomerRS.getString("TRAN_ID")));
				pstmtInsertSS.setInt(19, minIntervalVisit);
				pstmtInsertSS.setInt(20, maxInterValVisit);
				
				//Commented and changes by Gulzar on 16/07/12
				/*
				int insertSSCount = pstmtInsertSS.executeUpdate();
				pstmtInsertSS.close(); pstmtInsertSS = null;
				
				if ( insertSSCount > 0 )
				{
					System.out.println("Inserted Successfully into STRG_SERIES =["+insertSSCount+"]");
				}
				*/
				
				try
				{
					int insertSSCount = pstmtInsertSS.executeUpdate();
					if ( insertSSCount > 0 )
					{
						System.out.println("Inserted Successfully into STRG_SERIES =["+insertSSCount+"]");
					}
				}
				catch(Exception e)
				{
					conn.rollback();
					pstmtInsertSS.close(); pstmtInsertSS = null;
					generateLog( e, tranID );//Gulzar on 06/10/12
					e.printStackTrace();
					continue;
				}
				if ( pstmtInsertSS != null )
				{
					pstmtInsertSS.close(); pstmtInsertSS = null;
				}
				//End changes by Gulzar on 26/07/12
				
				//Inserted into STRG_STATUS_HIST table
				
				//New tranid generation for STRG_STATUS_HIST 
				String tranIdStatHist = generateTranID( conn ) ;
				
				//Calculation of validupto
				Calendar cal = Calendar.getInstance();
				cal.setTime( effFrom );			
				cal.add( Calendar.YEAR , 10 );
				String validUpto = genericUtility.getValidDateTimeString(sdf.format(cal.getTime()), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
				
				String insertStrgStatHistSql ="INSERT INTO STRG_STATUS_HIST(TRAN_ID, TRAN_DATE, SALES_PERS, SC_CODE, CUST_TYPE, ITEM_SER, ROUTE_ID, "+
										"EFF_FROM , VALID_UPTO, STATUS, CHG_DATE , CHG_USER, CHG_TERM, EDITFLAG) "+
										"VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
				
				PreparedStatement pstmtInsertStrgStatHist = conn.prepareStatement(insertStrgStatHistSql);
				pstmtInsertStrgStatHist.setString(1, tranIdStatHist);
				pstmtInsertStrgStatHist.setTimestamp(2, java.sql.Timestamp.valueOf(currDate));
				pstmtInsertStrgStatHist.setString(3, checkNull(selectMissingCustomerRS.getString("SALES_PERS")));
				pstmtInsertStrgStatHist.setString(4, checkNull(selectMissingCustomerRS.getString("SC_CODE")));
				pstmtInsertStrgStatHist.setString(5, checkNull(selectMissingCustomerRS.getString("CUST_TYPE")));
				pstmtInsertStrgStatHist.setString(6, itemSer);//Added to pass correct itemSeries 
				pstmtInsertStrgStatHist.setString(7, routeID);
				pstmtInsertStrgStatHist.setTimestamp(8, effFrom);
				pstmtInsertStrgStatHist.setTimestamp(9, java.sql.Timestamp.valueOf(validUpto));
				pstmtInsertStrgStatHist.setString(10, "Y");
				pstmtInsertStrgStatHist.setTimestamp(11, java.sql.Timestamp.valueOf(currDate) );
				pstmtInsertStrgStatHist.setString(12, checkNull(selectMissingCustomerRS.getString("LOADED_BY")));
				pstmtInsertStrgStatHist.setString(13, "SYSTEM");
				pstmtInsertStrgStatHist.setString(14, "A");
				
				//Commented and changes by Gulzar on 16/07/12
				/*
				int insertStatusHistCount = pstmtInsertStrgStatHist.executeUpdate();
				
				pstmtInsertStrgStatHist.close();pstmtInsertStrgStatHist = null;
				
				if ( insertStatusHistCount > 0 )
				{
					System.out.println("Inserted Successfully into STRG_STATUS_HIST =["+insertStatusHistCount+"]");
				}
				*/
				
				try
				{
					int insertStatusHistCount = pstmtInsertStrgStatHist.executeUpdate();
					if ( insertStatusHistCount > 0 )
					{
						System.out.println("Inserted Successfully into STRG_STATUS_HIST =["+insertStatusHistCount+"]");
					}
				}
				catch(Exception e)
				{
					conn.rollback();
					pstmtInsertStrgStatHist.close();pstmtInsertStrgStatHist = null;
					generateLog( e, tranID );//Gulzar on 06/10/12 for generating the log
					e.printStackTrace();
					continue;
				}
				if ( pstmtInsertStrgStatHist != null )
				{
					pstmtInsertStrgStatHist.close();pstmtInsertStrgStatHist = null;
				}
				//End changes by Gulzar on 26/07/12
				
				//Update the status of strgcust_upload table
				try
				{
					updateStrgCustUpload( tranID, conn );
				}
				catch(Exception e)
				{
					conn.rollback();
					generateLog( e, tranID );//Gulzar on 06/10/12 for generating the log
					e.printStackTrace();
					continue;
				}
				conn.commit();
				
			}//while( selectMissingCustomerRS.next() )
						
		}
		catch( Exception e)
		{
			isUploadError = true;
			generateLog( e, uploadID );//Gulzar on 06/10/12 for generating the log
			e.printStackTrace();
			throw e;
		}
		finally
		{
			try
			{
				if(selectMissingCustomerRS != null)
				{
					selectMissingCustomerRS.close();
					selectMissingCustomerRS = null;
				}
				if(pstmtselectMissingCustomer != null)
				{
					pstmtselectMissingCustomer.close();
					pstmtselectMissingCustomer = null;
				}
				if(!isUploadError)
				{
					//conn.commit();
					retString = "";
				}
			}
			catch(Exception e)
			{}
		}
		
		return retString;
		
	}
	private void updateStrgCustUpload(String tranID, Connection conn)throws Exception
	{
		PreparedStatement pstmtUpdateStrgCustUpload = null;
		try
		{
			String updateStrgCustUploadSql = "UPDATE STRGCUST_UPLOAD SET LOAD_STATUS = 'Y' WHERE TRAN_ID = ?";
			pstmtUpdateStrgCustUpload = conn.prepareStatement(updateStrgCustUploadSql);
			pstmtUpdateStrgCustUpload.setString(1, tranID);
			int updateCount = pstmtUpdateStrgCustUpload.executeUpdate();
			if ( updateCount > 0 )
			{
				System.out.println("Load Status Updated Successfully into STRGCUST_UPLOAD =["+updateCount+"]");
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw e;
		}
		finally
		{
			try
			{
				if (pstmtUpdateStrgCustUpload != null)
				{
					pstmtUpdateStrgCustUpload.close();
					pstmtUpdateStrgCustUpload = null;
				}
			}
			catch(Exception e)
			{}
		}
	}
	private String generateTranID( Connection conn ) throws ITMException
	{
		String uniqueKey = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{

			System.out.println("StrgSerStatusHistBean : Generating Primary Key ...........");
						
			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 't_strg_series_st' ";
			pstmt = conn.prepareStatement(keyStringQuery);
			rs = pstmt.executeQuery();			
			
			if(rs.next())
			{
				String keyString = rs.getString("KEY_STRING");
				String keyCol = rs.getString("TRAN_ID_COL");
				String tranSer = rs.getString("REF_SER");
				TransIDGenerator tg = new TransIDGenerator("<Root></Root>", "BASE", CommonConstants.DB_NAME);
				//uniqueKey = tg.generateTranSeqID(tranSer, keyCol, "seq10", conn);
				uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);//changed keyString to pass value of keyString.
				
			}
			rs.close();	rs = null;
			pstmt.close();
			pstmt = null;

		}
		catch(Exception exp)
		{
			System.out.println("Exception : StrgSerStatusHistBean :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception : StrgSerStatusHistBean :getUniqueKey :finally==>");
				throw new ITMException(e);
			}
		}
		System.out.println("Generated Primary Key :"+uniqueKey);
		return uniqueKey; 
	}

	private void generateLog( Exception ex, String uploadID ) throws Exception
	{
		String logFile = "";
		String logDir = "";

		FileWriter fileWriter = null;

		File logFileDir = null;

		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
			String currDate = sdf.format(new java.util.Date( System.currentTimeMillis() ) );
			logDir = CommonConstants.JBOSSHOME  + File.separator + "log" + File.separator + "StrgCustUpload" + File.separator + currDate;
			logFileDir = new File(logDir);
			if ( !logFileDir.exists())
			{
				logFileDir.mkdirs();
			}
			logFile = logDir + File.separator + uploadID+ ".log";
			fileWriter = new FileWriter(logFile, true);
			StringWriter writerStr = new StringWriter();
			PrintWriter traceWriter = new PrintWriter(writerStr);
			ex.printStackTrace(traceWriter);
			String stackTraceStr = writerStr.toString();
			fileWriter.write( "-----------------------------------------------------------------------------------------");
			fileWriter.write( "\r\n" );
			fileWriter.write( stackTraceStr );
			fileWriter.write( "\r\n" );
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if ( fileWriter != null )
				{
					fileWriter.flush();
					fileWriter.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
	}

}