

package ibase.webitm.ejb.wsfa.transactions;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.utility.CommonConstants;

import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;

import org.w3c.dom.*;

import javax.ejb.Stateless;
import java.util.*;
import java.io.*;

import javax.ejb.EJBException;


//@Stateless		commented by Sagar M [22 Nov 2018].
public class StrgCustDeactivePos extends ValidatorEJB implements StrgCustDeactivePosLocal, StrgCustDeactivePosRemote
{

	public String postSave() throws RemoteException,ITMException
	{
		return "";
	}
	public String postSaveRec() throws RemoteException, ITMException
	{
		return "";
	}
	public String postSaveRec(String xmlString1, String domId, String objContext, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException
	{
		return "";
	}

	@Override
	public String postSave(String xmlStringAll, String tranID, String editFlag, String xtraParams, Connection conn) throws RemoteException,ITMException
	{

		String retString="";

		PreparedStatement pstmtIns = null;

		try
		{
			System.out.println("PostSave Action Called:::");
			String salePersCode = "";
			String deactDate = "";
			NodeList hdrDom = null;
			NodeList detail2dom = null;
			Document dom = null;
			int det2length = 0;

			//changed by Rahul Barve on 3-sep-2014
			//GenericUtility genericUtility = GenericUtility.getInstance();
			 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			System.out.println("xmlStringAll::"+xmlStringAll);

			dom = genericUtility.parseString(xmlStringAll);
			hdrDom = dom.getElementsByTagName("Detail1");
			detail2dom = dom.getElementsByTagName("Detail2");
			det2length = detail2dom.getLength();
			System.out.println("det2length =["+det2length+"]");

			String custType = "";
			String objName = checkNullAndTrim(getObjNameFromDom(dom, "objName","1"));
			System.out.println("objName =["+objName+"]");
			if ( "doctor_deact".equalsIgnoreCase(objName))
			{
				custType = "D";
			}
			else if ( "chemist_deact".equalsIgnoreCase(objName))
			{
				custType = "C";
			}

			deactDate = checkNull(genericUtility.getColumnValue("deact_date", dom, "1"));

			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date newCurrDate = new java.util.Date();

			newCurrDate = sdf.parse(sdf.format(newCurrDate));
			System.out.println("newDate =["+newCurrDate+"] and deactDate =["+deactDate+"]");

			///
			boolean deactivateToday = false;
			if ( newCurrDate.compareTo(sdf.parse(deactDate)) == 0 )
			{
				//updateDeactivateStatus( dom, editFlag, xtraParams, conn );
				deactivateToday = true;
			}
			System.out.println("deactivateToday =["+newCurrDate.compareTo(sdf.parse(deactDate))+"]");

			salePersCode = checkNull(genericUtility.getColumnValue("sales_pers",dom, "1"));
			deactDate = checkNull(genericUtility.getColumnValue("deact_date", dom, "1"));

			System.out.println("salePersCode =["+salePersCode+"] deactDate =["+deactDate+"]");

			deactDate = genericUtility.getValidDateTimeString( deactDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			System.out.println("tranID =["+tranID+"]");


			String insertSql = "insert into strgcust_deactive(tran_id, sales_pers, sc_code, locality_code, short_id, route_id, deact_date, status, "+
								"chg_date, chg_user, chg_term, tran_date, load_status, cust_type ) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			pstmtIns = conn.prepareStatement( insertSql );

			Timestamp currDate = new Timestamp(System.currentTimeMillis());

			String chgUser = checkNull(genericUtility.getColumnValue("chg_user",dom, "1"));
			String chgTerm = checkNull(genericUtility.getColumnValue("chg_term",dom, "1"));

			if (chgUser == null || chgUser.trim().length() == 0)
			{
				chgUser = "SYSTEM";
			}
			if (chgTerm == null || chgTerm.trim().length() == 0)
			{
				chgTerm = "SYSTEM";
			}

			int currDetailListLength = 0;
			int	detailListLength = 0;
			int count = 0;

			Node currDetail = null;
			NodeList detail2List = null;
			NodeList currDetailList = null;
			detail2List = dom.getElementsByTagName("Detail2");
			detailListLength = detail2List.getLength();
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				currDetail = detail2List.item(ctr);
				currDetailList = currDetail.getChildNodes();
				currDetailListLength = currDetailList.getLength();

				String attributeVal = "";
				String  scCode = "";
				String  localityCode = "";
				String  mplNo = "";
				String  routeId = "";

				for ( int i=0; i< currDetailListLength; i++ )
				{
					Node childNode = currDetailList.item(i);
					String nodeName = childNode.getNodeName();
					if (nodeName.equalsIgnoreCase("Attribute"))
					{
						attributeVal = checkNull(currDetailList.item(i).getAttributes().getNamedItem("selected").getNodeValue());
						System.out.println("attributeVal =["+attributeVal+"]");
					}//if (nodeName = Attribute
					else if (nodeName.equalsIgnoreCase("sc_code"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							scCode = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("locality_code"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							localityCode = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("short_id"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							mplNo = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("route_id"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							routeId = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("cust_type"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							custType = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
				}//End of inner for loop
				//if ( "Y".equalsIgnoreCase(attributeVal.trim()) )
				if ( salePersCode.length() > 0 && scCode.length() > 0 )
				{
					String newTranID = generateTranId("w_strgcust_deactive", conn);
					pstmtIns.setString(1, newTranID);
					pstmtIns.setString(2, salePersCode);
					pstmtIns.setString(3, scCode);
					pstmtIns.setString(4, localityCode);
					pstmtIns.setString(5, mplNo);
					pstmtIns.setString(6, routeId);
					pstmtIns.setTimestamp(7, java.sql.Timestamp.valueOf(deactDate));
					pstmtIns.setString(8, "Y");
					pstmtIns.setTimestamp(9, currDate);
					pstmtIns.setString(10, chgUser);
					pstmtIns.setString(11, chgTerm);
					pstmtIns.setTimestamp(12, currDate);
					pstmtIns.setString(13, "N");
					pstmtIns.setString(14, custType);
					pstmtIns.addBatch();
					pstmtIns.clearParameters();
					count++;
				}
			}//End of for loop
			if (count > 0)
			{
				int insertCnt[] = pstmtIns.executeBatch();
				System.out.println("no of record inserted =["+insertCnt.length+"]");
				/*
				if (deactivateToday)
				{
					retString = updateDeactivateStatus( dom, editFlag, xtraParams, conn );
					if (retString != null && retString.trim().length() > 0 )
					{
						conn.rollback();
					}
				}
				*/

			}
			pstmtIns.clearBatch();
		}
		catch(BatchUpdateException buex)
        {
			try
			{
				conn.rollback();
				int [] updateCounts = buex.getUpdateCounts();
				for (int i = 0; i < updateCounts.length; i++)
				{
					System.err.println("  Statement " + i + ":" + updateCounts[i]);
				}
				System.err.println(" Message: " + buex.getMessage());
				System.err.println(" SQLSTATE: " + buex.getSQLState());
				System.err.println(" Error code: " + buex.getErrorCode());
				SQLException ex = buex.getNextException();
				while (ex != null)
				{
					System.err.println("SQL exception:");
					System.err.println(" Message: " + ex.getMessage());
					System.err.println(" SQLSTATE: " + ex.getSQLState());
					System.err.println(" Error code: " + ex.getErrorCode());
					ex = ex.getNextException();
				}
			}
			catch ( Exception e)
			{
				e.printStackTrace();
			}
			throw new ITMException(buex);
        }
		catch( Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (pstmtIns !=null )
				{
					pstmtIns.close();
					pstmtIns = null;
				}
			}
			catch (Exception e)
			{
			}
		}
		return retString;
	}

	//to check if input is null or "null"
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input;
	}
	public String checkNullAndTrim(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	private String generateTranId( String windowName, Connection conn )throws ITMException
    {
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";
		String paySiteCode = "";
		String effectiveDate = "";

		java.sql.Date effDate = null;

		 try
         {
			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
					keyString = rs.getString("KEY_STRING");
					keyCol = rs.getString("TRAN_ID_COL");
					tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +        "<tran_id></tran_id>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);
         }
		catch (SQLException ex)
		{
			System.out.println("Exception ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e){}
		}
        return tranId;
     }//generateTranTd()
	public String updateDeactivateStatus( Document dom, String editFlag, String xtraParams, Connection conn )throws RemoteException, ITMException
    {
		String returnString = "";
		PreparedStatement pstmtUpdateStrgSeries = null;
		PreparedStatement pstmtUpdateDRChemStatus = null;
		PreparedStatement pstmtSelect = null;
		ResultSet rsSelect = null;
		boolean localConnection = false;
		boolean isError = false;

		try
        {
			if (conn == null)
			{
				ConnDriver connDriver = new ConnDriver();
				//conn = connDriver.getConnectDB("DriverITM");//Commented by kailash on 29-nov-18.
				conn = getConnection(); //Added by kailash on 29-nov-18.
				connDriver = null;
				conn.setAutoCommit(false);
				localConnection = true;
			}
			//changed by Rahul Barve on 3-sep-2014
			//GenericUtility genericUtility = GenericUtility.getInstance();
			 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());

			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			//////////////////////////////

			String salesPers="";
            String scCode="";
            String routeId="";
            String status="";
            String itemSer="";
            String sStatus="";
            String effDate="";
            String custType="";
            String deactDate="";
            String tranID = "";


			StrgSerStatusHist strgStatusHist= new StrgSerStatusHist();

			String updateStrgSeriesSql = "update strg_series set short_id = null , status ='N' where sales_pers = ? and sc_code = ? ";
			pstmtUpdateStrgSeries = conn.prepareStatement(updateStrgSeriesSql);

			String updateDRChemStatusSql = "update strgcust_deactive set load_status ='Y' where tran_id = ? ";
			pstmtUpdateDRChemStatus = conn.prepareStatement(updateDRChemStatusSql);

			String selectSql = "select a.tran_id, a.sales_pers, a.sc_code, a.route_id, a.deact_date, a.status, b.item_ser, c.status as series_status, c.eff_date, c.cust_type "+
								"from strgcust_deactive a, sales_pers b, strg_series c "+
								"where a.sales_pers = b.sales_pers "+
								"and a.sales_pers = c.sales_pers and a.sc_code = c.sc_code and c.item_ser = b.item_ser and a.route_id = c.route_id "+
								"and a.status ='Y' and a.load_status <> 'Y' and a.deact_date <= ? ";
			pstmtSelect = conn.prepareStatement(selectSql);

			pstmtSelect.setTimestamp(1, java.sql.Timestamp.valueOf(currDate));
			rsSelect = pstmtSelect.executeQuery();
			while ( rsSelect.next() )
			{
				tranID = checkNull(rsSelect.getString("tran_id"));
				salesPers = checkNull(rsSelect.getString("sales_pers"));
                scCode = checkNull(rsSelect.getString("sc_code"));
                routeId = checkNull(rsSelect.getString("route_id"));
                deactDate = checkNull(rsSelect.getString("deact_date"));
                if (deactDate == null || deactDate.trim().length() == 0)
    			{
                	deactDate = " ";
    			}
    			else
    			{
    				deactDate =  genericUtility.getValidDateString( deactDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat());
    			}
                status = checkNull(rsSelect.getString("status"));
                itemSer = checkNull(rsSelect.getString("item_ser"));
                sStatus = checkNull(rsSelect.getString("series_status"));
                effDate = checkNull(rsSelect.getString("eff_date"));
                if (effDate == null || effDate.trim().length() == 0)
    			{
                	effDate = " ";
    			}
    			else
    			{
    				effDate =  genericUtility.getValidDateString( effDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat());
    			}
                custType = checkNull(rsSelect.getString("cust_type"));

                returnString = strgStatusHist.setDrStatusHistory(salesPers, scCode, custType, routeId, itemSer, "N", deactDate, effDate, xtraParams, editFlag, conn);
                if (returnString != null && returnString.trim().length() > 0 )
                {
                	conn.rollback();
                }
                else
                {
                	//Updating the status of strg_series table
                	pstmtUpdateStrgSeries.setString(1, salesPers);
                	pstmtUpdateStrgSeries.setString(2, scCode);
                	int updSSCount = pstmtUpdateStrgSeries.executeUpdate();
                	pstmtUpdateStrgSeries.clearParameters();

                	//Updating the status of drchem_deact_status table
                	pstmtUpdateDRChemStatus.setString(1, tranID);
                	int updDRStatCount = pstmtUpdateDRChemStatus.executeUpdate();
                	pstmtUpdateDRChemStatus.clearParameters();
                	System.out.println("no of record updated in strg_series =["+updSSCount+"] and drchem_deact_status =["+updDRStatCount+"]");

                	if ( updSSCount > 0 && updDRStatCount > 0 && localConnection)
                	{
                		conn.commit();
                	}
                }

			}

			//////////////////////////////
        }
		catch (Exception e)
		{
			isError = true;
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsSelect != null)
				{
					rsSelect.close();
					rsSelect = null;
				}
				if (pstmtSelect != null)
				{
					pstmtSelect.close();
					pstmtSelect = null;
				}
				if (pstmtUpdateStrgSeries != null)
				{
					pstmtUpdateStrgSeries.close();
					pstmtUpdateStrgSeries = null;
				}
				if (localConnection && conn != null && !conn.isClosed())
				{
					if ( !isError )
					{
						conn.commit();
					}
					else
					{
						conn.rollback();
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e){}
		}
		return returnString;
    }
	private String getObjNameFromDom( Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node currDetail = null;
		String objName = "";
		int detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		System.out.println("objName =["+objName+"]");
		return objName;
	}
}// END OF MAIN CLASS