package ibase.webitm.ejb.wsfa.transactions;

import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.ejb.*;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.utility.GenericUtility;
import ibase.ejb.*;
import ibase.system.config.*;
import ibase.utility.*;

import java.util.*;
import java.sql.*;
import java.io.*;
import java.net.InetAddress;
import java.rmi.RemoteException;
import javax.ejb.*;
import javax.naming.InitialContext;
import java.text.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].

public class  DepthAndDisplayProcess extends ProcessEJB implements DepthAndDisplayProcessRemote,DepthAndDisplayProcessLocal//implements SessionBean
{
	SessionContext cSessionContext;
	protected static String database = CommonConstants.DB_NAME;
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	/*
 	public void ejbCreate() throws RemoteException, CreateException
	{
		try
		{
			System.out.println("DepthAndDisplayProcessEJB ejbCreate called.........");
		}
		catch (Exception e)
		{
			System.out.println("Exception :DepthAndDisplayProcessEJB :ejbCreate :==>"+e);
			throw new CreateException();
		}
	}

	public void ejbRemove()
	{
	}

	public void ejbActivate()
	{
	}

	public void ejbPassivate()
	{
	}
	*/
	public void setSessionContext(SessionContext mSessionContext)
	{
		try
		{
			CommonConstants.setIBASEHOME();
			ProcessEJB.DB_NAME = CommonConstants.DB_NAME;
			this.cSessionContext = mSessionContext;
		}
		catch (Exception e)
		{
			System.out.println("Exception :DepthAndDisplayProcessEJB :setSessionContext :==>"+e);
		}
	}

	public String process() throws RemoteException,ITMException
	{
		return "";
	}

	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String retStr = "";
		Document detailDom = null;
		Document headerDom = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			System.out.println("xmlString   ["+xmlString+"]");
			System.out.println("xmlString2  ["+xmlString2+"]");
			System.out.println("windowName   ["+windowName+"]");
			System.out.println("xtraParams   ["+xtraParams+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString);
			}
			if(xmlString2 != null && xmlString2.length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2);
			}
		    retStr = process(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{
			System.out.println("Exception :DepthAndDisplayProcessEJB :process(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retStr;
	}


	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{

		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rset = null ;

		String columnValue ="";
		String childNodeName = "";
		String insertSQL = "";
		String returnString = "";

		String workDate = "";
		String sprs = "";
		String custCode = "";
		//String classCodeDesc = "";
		String classCode = "";
		String totPOB = "";
		String item = "";
		String stckExp = "";
		String stckAvail = "";
		String itemPOB = "0";
		String units = "";
		String shelfStrip  = "";
		String poster  = "";
		String dangler = "";
		String othPos = "";
		boolean toSaved = true;
		String trnid = "";
		String currDate="";
		int updateCnt=0;

		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");

		String database = CommonConstants.DB_NAME;
		String dom = genericUtility.serializeDom(detailDom);
		System.out.println("detail dom ["+dom+"]");

		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");

			String tranID = generateTransID( conn, loginCode );

			Calendar cal = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			currDate=sdf.format(cal.getTime()).toString();

			InetAddress ownIP=InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();

			//Changed By Pragyan 13/11/09 as  To get The Total Sum of any Column [WS89NOV583].
			 totPOB =String.valueOf( getSUM(detailDom,"item_pob"));

			for(int noOfForm= 1; noOfForm <= 2; noOfForm++)
			{
				NodeList parentNodeList = detailDom.getElementsByTagName("Detail"+noOfForm);
				int parentNodeListLength = parentNodeList.getLength();
				for(int parent = 0; parent < parentNodeListLength; parent++)
				{
					Node parentNode = parentNodeList.item(parent);
					NodeList childNodeList = parentNode.getChildNodes();
					int childNodeListLength = childNodeList.getLength();
					for(int ctr = 0; ctr < childNodeListLength; ctr++)
					{
						Node childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						columnValue = "";
						if( childNode.getFirstChild() != null)
						{
							columnValue = checkNull( childNode.getFirstChild().getNodeValue() );
						}
						else
						{
							columnValue = "";
						}

						System.out.println("columnName ["+childNodeName+"] columnValue ["+columnValue+"]");

						if(childNodeName.equals("work_date"))
						{
								workDate = columnValue;
						}
						else if(childNodeName.equals("sales_pers"))
						{
								sprs = columnValue;
						}
						else if(childNodeName.equals("cust_code"))
						{
								custCode = columnValue;
						}
						else if(childNodeName.equals("class_code"))
						{
								classCode = columnValue;
						}
						//Changed By Pragyan 13/11/09 as  item-pob  column change to a text box  [WS89NOV588]
						/*else if(childNodeName.equals("total_pob"))
						{
								totPOB = columnValue;
						}*/
						else if(childNodeName.equals("item_code"))
						{
								item = columnValue;
						}
						else if(childNodeName.equals("stock_expc"))
						{
								stckExp = columnValue;
						}
						else if(childNodeName.equals("stock_avail"))
						{
								stckAvail = columnValue;
						}
						//Changed By Pragyan 13/11/09 as  item_units  column change to a check box  [WS89NOV588]
						/*else if(childNodeName.equals("item_units"))
						{
								units = columnValue;
						}*/
						else if(childNodeName.equals("item_pob"))
						{
								itemPOB = columnValue;
						}


						if(columnValue.equals("true"))
						{
							//Changed By Pragyan 13/11/09 as  item-pob  column change to a text box and item_units as check box  [WS89NOV588].start
							/*if(childNodeName.equals("item_pob"))
							{
									itemPOB = "1";
							}*/
							if(childNodeName.equals("item_units"))
							{
									units = "1";
							}
							////Changed By Pragyan 13/11/09 as  item-pob  column change to a text box and item_units as check box  [WS89NOV588].end
							else if(childNodeName.equals("item_shelf_strip"))
							{
									shelfStrip = "1";
							}
							else if(childNodeName.equals("item_poster"))
							{
									poster = "1";
							}
							else if(childNodeName.equals("item_dangler"))
							{
									dangler = "1";
							}
							else if(childNodeName.equals("item_oth_pos"))
							{
									othPos = "1";
							}
						}
						else if(columnValue.equals("false"))
						{
							//Changed By Pragyan 13/11/09 as  item-pob  column change to a text box and item_units as check box  [WS89NOV588].start
							/*if(childNodeName.equals("item_pob"))
							{
									itemPOB = "0";
							}*/
							if(childNodeName.equals("item_units"))
							{
									units = "0";
							}
							////Changed By Pragyan 13/11/09 as  item-pob  column change to a text box and item_units as check box  [WS89NOV588].end
							else if(childNodeName.equals("item_shelf_strip"))
							{
									shelfStrip = "0";
							}
							else if(childNodeName.equals("item_poster"))
							{
									poster = "0";
							}
							else if(childNodeName.equals("item_dangler"))
							{
									dangler = "0";
							}
							else if(childNodeName.equals("item_oth_pos"))
							{
									othPos = "0";
							}
						}
					}
					if( noOfForm == 1 && toSaved)
					{
						String selectQuery = "SELECT * FROM STRG_DND_HDR WHERE SALES_PERS = ? AND CUST_CODE = ? ";
						pstmt = conn.prepareStatement( selectQuery );
						pstmt.setString( 1, sprs);
						pstmt.setString( 2, custCode);
						rset = pstmt.executeQuery();
						if(rset.next())
						{
							trnid = rset.getString("TRAN_ID");
							System.out.println("TRAN_ID["+trnid+"]");
							String deleteQuery = "DELETE FROM STRG_DND_HDR WHERE SALES_PERS = ? AND CUST_CODE = ?";
							pstmt = conn.prepareStatement( deleteQuery );
							pstmt.setString( 1, sprs);
							pstmt.setString( 2, custCode);
							rset = pstmt.executeQuery();

							System.out.println("Records Deleted From STRG_DND_HDR For Sales_Pers: ["+sprs+"] AND cust_code:["+custCode+"}");

						}
						else{
						System.out.println("No record found");
						}


						String insertQuery = "INSERT INTO STRG_DND_HDR(TRAN_ID, SALES_PERS, WORK_DATE, CUST_CODE, CLASS_CODE, TOTAL_POB, CHG_DATE, CHG_USER, CHG_TERM) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
						pstmt = conn.prepareStatement( insertQuery );
						pstmt.setString( 1, tranID);
						pstmt.setString( 2, sprs);
						pstmt.setTimestamp( 3,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(workDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
						pstmt.setString( 4, custCode);
						pstmt.setString( 5, classCode);
						pstmt.setString( 6, totPOB);
						pstmt.setTimestamp( 7, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(currDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
						pstmt.setString( 8, loginCode);
						pstmt.setString( 9, chgTerm);
						rset = pstmt.executeQuery();
						toSaved = false;
					}
					else
					{
						System.out.println("item >>>>"+item+"<<<<<");
						String selectQuery = "SELECT * FROM STRG_DND_DET WHERE TRAN_ID = ? ";
						pstmt = conn.prepareStatement( selectQuery );
						pstmt.setString( 1, trnid);
						rset = pstmt.executeQuery();
						if(rset.next())
						{
							String deleteQuery = "DELETE FROM STRG_DND_DET WHERE TRAN_ID = ?";
							pstmt = conn.prepareStatement( deleteQuery );
							pstmt.setString( 1, trnid);
							rset = pstmt.executeQuery();

							System.out.println("Records Deleted From STRG_DND_DET");
							trnid = "";
						}
						else{
						System.out.println("No record found");
						}

						String insertQuery = "INSERT INTO STRG_DND_DET(TRAN_ID, ITEM_CODE, STOCK_EXPC, STOCK_AVAIL, ITEM_POB, ITEM_UNITS, ITEM_SHELF_STRIP, ITEM_POSTER, ITEM_DANGLER, ITEM_OTH_POS) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
						pstmt = conn.prepareStatement( insertQuery );
						pstmt.setString( 1, tranID);
						pstmt.setString( 2, item);
						pstmt.setString( 3, stckExp);
						pstmt.setString( 4, stckAvail);
						pstmt.setString( 5, itemPOB);
						pstmt.setString( 6, units);
						pstmt.setString( 7, shelfStrip);
						pstmt.setString( 8, poster);
						pstmt.setString( 9, dangler);
						pstmt.setString( 10, othPos);
						//rset = pstmt.executeQuery();
						updateCnt = pstmt.executeUpdate();
						stckAvail = "";
						units = "";
						if (updateCnt > 0)
						{
							returnString = "";
						}
						else
						{
							returnString = itmDBAccessEJB.getErrorString("","DBINSERR",loginCode);
							break;
						}

					}
				}
			}

			if (returnString != null && returnString.trim().length() > 0)
			{
				conn.rollback();
				conn.close();
				conn = null;
				return returnString;
			}
			else
			{
				conn.commit();
				conn.close();
				conn = null;
				String testStr = itmDBAccessEJB.getErrorString("","VTPRC1",loginCode);
				System.out.println(":testStr["+testStr+"]");
				returnString = tranID;
				return returnString;
			}

		}
		catch( Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
				}
				if( rset != null )
				{
					rset.close();
				}
				if( conn != null )
				{
					conn.commit();
					conn.close();
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}

		return returnString;

	}

	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String rtrStr = "";
		Document headerDom = null;
		Document detailDom = null;

		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{

			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2);
			}
			rtrStr = getData(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{
			System.out.println("Exception :DepthAndDisplayProcessEJB :getData(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			rtrStr = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		return rtrStr;
	}

	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;
		String sql = "";
		//boolean pob = false;//Changed By Pragyan 13/11/09 as  item-pob  column change to a text box  [WS89NOV588]
		boolean sstrip = false;
		boolean pster = false;
		boolean dnglr = false;
		boolean pos = false;
		boolean unit = false;//Changed By Pragyan 13/11/09 as  item_units column change to a check box and char type [WS89NOV588]

		ConnDriver connDriver = new ConnDriver();
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();


		StringBuffer valueXmlString  = null;
		int cnt = 0;
		try
		{
			conn = connDriver.getConnectDB( "DriverITM" );

			int i =2;

			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<DocumentRoot>\r\n<description>Datawindow Root</description>\r\n<group0>\r\n<description>Group0 description</description>\r\n<Header0>\r\n<description>Header0 members</description>\r\n");

			String sprs = genericUtility.getColumnValue( "sales_pers", headerDom );
			String chmst = genericUtility.getColumnValue( "cust_code", headerDom );
			String classCd = genericUtility.getColumnValue( "class_code", headerDom );;
			//Changed By Pragyan 11/6/2009 wordate need to check whether record exist or not [WS89NOV588]
			String workDate = genericUtility.getColumnValue( "work_date", headerDom );
			System.out.println("cust_code>>>"+chmst+"<<");

			//Changed By Pragyan 11/6/2009 include workdate need to check whether record exist or not [WS89NOV588]
			//String count = "SELECT COUNT(*) COUNT FROM STRG_DND_DET SD, STRG_DND_HDR SH WHERE SD.ITEM_CODE IN (SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ?) AND SH.TRAN_ID = SD.TRAN_ID AND SH.CUST_CODE = ?";
			String count = "SELECT COUNT(*) COUNT FROM STRG_DND_DET SD, STRG_DND_HDR SH WHERE SD.ITEM_CODE IN (SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ?) AND SH.TRAN_ID = SD.TRAN_ID AND SH.CUST_CODE = ? AND WORK_DATE =?";

			pstmt = conn.prepareStatement( count );
			pstmt.setString(1, sprs);
			pstmt.setString(2, chmst);
			pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(workDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));

			rSet = pstmt.executeQuery();
			while( rSet.next() )
			{
				cnt = rSet.getInt("COUNT");
			}

			if(cnt > 0)
			{
					sql = "SELECT SD.ITEM_CODE ITEM_CODE,I.DESCR DESCR, SD.STOCK_EXPC STOCK_EXPC, SD.STOCK_AVAIL STOCK_AVAIL, SD.ITEM_POB ITEM_POB, SD.ITEM_UNITS ITEM_UNITS, SD.ITEM_SHELF_STRIP ITEM_SHELF_STRIP, SD.ITEM_POSTER ITEM_POSTER, SD.ITEM_DANGLER ITEM_DANGLER, SD.ITEM_OTH_POS ITEM_OTH_POS FROM STRG_DND_DET SD, ITEM I, SPRS_ITEM SI, STRG_DND_HDR SH WHERE SD.ITEM_CODE = I.ITEM_CODE AND SH.TRAN_ID = SD.TRAN_ID AND SI.ITEM_CODE = I.ITEM_CODE AND SI.SALES_PERS = ? AND SH.CUST_CODE = ? AND WORK_DATE =? ";

					pstmt = conn.prepareStatement( sql );
					pstmt.setString(1, sprs);
					pstmt.setString(2, chmst);
					pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(genericUtility.getColumnValue( "work_date", headerDom ),genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
					rSet = pstmt.executeQuery();
					while( rSet.next() )
					{
						////Changed By Pragyan 13/11/09 as  item-pob  column change to a text box  [WS89NOV588]
						//pob = getDispValueChkBox(rSet.getString("ITEM_POB"));
						unit = getDispValueChkBox(rSet.getString("ITEM_UNITS"));
						sstrip = getDispValueChkBox(rSet.getString("ITEM_SHELF_STRIP"));
						pster = getDispValueChkBox(rSet.getString("ITEM_POSTER"));
						dnglr = getDispValueChkBox(rSet.getString("ITEM_DANGLER"));
						pos = getDispValueChkBox(rSet.getString("ITEM_OTH_POS"));

						valueXmlString.append("<Detail2 domID='"+i+"' >\r\n");
						valueXmlString.append("<attribute updateFlag='N' selected='N' />\r\n");
						valueXmlString.append("<item_code><![CDATA[").append(checkNull(rSet.getString("ITEM_CODE"))).append("]]></item_code>\r\n");
						valueXmlString.append("<item><![CDATA[").append(checkNull(rSet.getString("DESCR"))).append("]]></item>\r\n");
						valueXmlString.append("<stock_expc><![CDATA[").append(checkNull(rSet.getString("STOCK_EXPC"))).append("]]></stock_expc>\r\n");
						valueXmlString.append("<stock_avail><![CDATA[").append(checkNull(rSet.getString("STOCK_AVAIL"))).append("]]></stock_avail>\r\n");
						////Changed By Pragyan 13/11/09 as  item-pob  column change to a text box  [WS89NOV588]
						//valueXmlString.append("<item_pob><![CDATA[").append(pob).append("]]></item_pob>\r\n");
						valueXmlString.append("<item_pob><![CDATA[").append(checkNull(rSet.getString("ITEM_POB"))).append("]]></item_pob>\r\n");
						////Changed By Pragyan 13/11/09 as  item_units column change to a check box and char type [WS89NOV588]
						//valueXmlString.append("<item_units><![CDATA[").append(checkNull(rSet.getString("ITEM_UNITS"))).append("]]></item_units>\r\n");
						valueXmlString.append("<item_units><![CDATA[").append(unit).append("]]></item_units>\r\n");
						valueXmlString.append("<item_shelf_strip><![CDATA[").append(sstrip).append("]]></item_shelf_strip>\r\n");
						valueXmlString.append("<item_poster><![CDATA[").append(pster).append("]]></item_poster>\r\n");
						valueXmlString.append("<item_dangler><![CDATA[").append(dnglr).append("]]></item_dangler>\r\n");
						valueXmlString.append("<item_oth_pos><![CDATA[").append(pos).append("]]></item_oth_pos>\r\n");
						valueXmlString.append("</Detail2>\r\n");
						i++;
					}
			}
			else
			{


				String selectQuery = "SELECT D.ITEM_CODE ITEM_CODE, I.DESCR DESCR, D.STOCK_EXPC STOCK FROM ITEM I, STOCK_DND D, SPRS_ITEM SI WHERE D.ITEM_CODE = SI.ITEM_CODE AND I.ITEM_CODE = SI.ITEM_CODE AND SI.SALES_PERS = ? AND D.CLASS_CODE = ?";

				pstmt = conn.prepareStatement( selectQuery );
				pstmt.setString(1, sprs);
				pstmt.setString(2, classCd);
				rSet = pstmt.executeQuery();

				while (rSet.next())
				{
					//Changed By Pragyan 13/11/09 as  To get The Stock Expected for the partiular workate,item code and class code[WS89NOV583]
					String itemCode = checkNull(rSet.getString("ITEM_CODE"));
					String stockExpcd = getStockExpected(conn,workDate,itemCode,classCd,genericUtility);

					valueXmlString.append("<Detail2 domID='"+i+"' >\r\n");
					valueXmlString.append("<attribute updateFlag='N' selected='N' />\r\n");
					valueXmlString.append("<item_code><![CDATA[").append(checkNull(rSet.getString("ITEM_CODE"))).append("]]></item_code>\r\n");
					valueXmlString.append("<item><![CDATA[").append(checkNull(rSet.getString("DESCR"))).append("]]></item>\r\n");
					//Changed By Pragyan 13/11/09 as  item-pob  column change to a text box  [WS89NOV588].start
					//valueXmlString.append("<stock_expc><![CDATA[").append(checkNull(rSet.getString("STOCK"))).append("]]></stock_expc>\r\n");
					valueXmlString.append("<stock_expc><![CDATA[").append(stockExpcd).append("]]></stock_expc>\r\n");
					//valueXmlString.append("<item_pob><![CDATA[").append(false).append("]]></item_pob>\r\n");
					//valueXmlString.append("<stock_avail><![CDATA[").append("").append("]]></stock_avail>\r\n");
					valueXmlString.append("<stock_avail visible='1'><![CDATA[").append("0").append("]]></stock_avail>\r\n");
					valueXmlString.append("<item_pob><![CDATA[").append("0.00").append("]]></item_pob>\r\n");
					//valueXmlString.append("<item_units><![CDATA[").append("").append("]]></item_units>\r\n");
					valueXmlString.append("<item_units><![CDATA[").append(false).append("]]></item_units>\r\n");
					valueXmlString.append("<item_shelf_strip><![CDATA[").append(false).append("]]></item_shelf_strip>\r\n");
					valueXmlString.append("<item_poster><![CDATA[").append(false).append("]]></item_poster>\r\n");
					valueXmlString.append("<item_dangler><![CDATA[").append(false).append("]]></item_dangler>\r\n");
					valueXmlString.append("<item_oth_pos><![CDATA[").append(false).append("]]></item_oth_pos>\r\n");
					valueXmlString.append("</Detail2>\r\n");
					i++;
				}
			}
			valueXmlString.append("</Header0>\r\n");
			valueXmlString.append("</group0>\r\n");
			valueXmlString.append("</DocumentRoot>\r\n");
		}
		catch( Exception e)
		{
			e.printStackTrace();
		}
		//Changed by deepak on 19/08/09 for closing connection for [WS89NOV433] .Start
 		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
				}
				if( rSet != null )
				{
					rSet.close();
				}
				if( conn != null )
				{
					conn.close();
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		//Changed by deepak on 19/08/09 for closing connection for [WS89NOV433] .End
		return valueXmlString.toString();
	}

	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}

	//Changed By Pragyan 13/11/09 as  To get The Stock Expected for the partiular workate,item code and class code[WS89NOV583].start
	private String getStockExpected(Connection con,String  workDate,String itemCode,String classCode,E12GenericUtility genericUtility)
	{
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;
		String stockExpected = "";

		try
		{

			String selectQuery = "SELECT  D.STOCK_EXPC STOCK FROM STOCK_DND D WHERE D.ITEM_CODE =? AND D.CLASS_CODE = ?  AND D.DATE_TO >= ? AND D.DATE_FROM <= ?";

			pstmt = con.prepareStatement( selectQuery );

			pstmt.setString(1, itemCode);
			pstmt.setString(2, classCode);
			pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(workDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
			pstmt.setTimestamp(4, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(workDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));

			rSet=pstmt.executeQuery();

			if(rSet.next())
			{
				stockExpected = checkNull(rSet.getString(1));
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
				}
				if( rSet != null )
				{
					rSet.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return stockExpected;
	}
	//Changed By Pragyan 13/11/09 as  To get The Stock Expected for the partiular workate,item code and class code[WS89NOV583].end

	//Changed By Pragyan 13/11/09 as  To get The Total Sum of any Column [WS89NOV583].start
	private Double getSUM(Document doc,String ColumnName)
	{
		double totAmount=0.0;

		try
		{
				NodeList childNodeList = doc.getElementsByTagName(ColumnName);

				int nodeLength = childNodeList.getLength();

				for(int i=0;i<=nodeLength;i++)
				{
					Node childNode =  childNodeList.item(i);

					if(childNode != null && childNode.getNodeType() == childNode.ELEMENT_NODE && childNode.getFirstChild() != null)
					{
								totAmount = totAmount +
								Double.parseDouble(childNode.getFirstChild().getNodeValue());
					}
				}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		System.out.println("ColumnName["+ColumnName+"]:totAmount["+totAmount+"]");
		return totAmount;
	}
	//Changed By Pragyan 13/11/09 as  To get The Total Sum of any Column [WS89NOV583].end

	private String generateTransID( Connection connection, String loginCode ) throws ITMException
	{
		String uniqueKey = null;
		//Statement stmt = null;
		PreparedStatement pstmt=null;
		ResultSet rset = null;

		String tranSer = null;
		String keyString = null;
		String keyCol = null;

		try
		{

			System.out.println("DepthAndDisplayProcessEJB : Generating Primary Key ...........");

			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_depth_and_display ' ";
			 //Commented & Below Changes Done By Shahu Mali on 04-10-13
			//stmt = connection.createStatement();
			//rset = stmt.executeQuery( keyStringQuery );
			pstmt=connection.prepareStatement(keyStringQuery);
			rset = pstmt.executeQuery();
			if(rset.next())
			{
				keyString = rset.getString("KEY_STRING");
				keyCol = rset.getString("TRAN_ID_COL");
				tranSer = rset.getString("REF_SER");
			}
			//Added  By Shahu Mali on 04-10-13.START
			rset.close();rset=null;
			pstmt.close();pstmt=null;
			//Added  By Shahu Mali on 04-10-13.End

			TransIDGenerator tg = new TransIDGenerator("<Root></Root>", loginCode, database);
			uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, connection);
		}
		catch(Exception exp)
		{
			System.out.println("Exception : DepthAndDisplayProcessEJB :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				//Added  By Shahu Mali on 04-10-13.START
				/*if(stmt != null)
				{
					stmt.close();
					stmt = null;
				}*/
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				//Added  By Shahu Mali on 04-10-13.End
			}
			catch (Exception e)
			{
				System.out.println("Exception : DepthAndDisplayProcessEJB :getUniqueKey :finally==>");
				throw new ITMException(e);
			}
		}
		System.out.println("Generated Primary Key :"+uniqueKey);
		return uniqueKey;
	}

	private boolean getDispValueChkBox(String str )
	{
		if (str.equals("1"))
		{
			return true;
		}
		else
		{
			return false;
		}

	}


}
