package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class OrgStructureIC extends ValidatorEJB {

	E12GenericUtility genericUtility = new E12GenericUtility();

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag,
			String xtraParams, String formName) throws RemoteException, ITMException {
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;

		String errString = null;
		try {
			System.out.println("wfValData value of xmlString [" + xmlString + "]");
			System.out.println("wfValData value of xmlString [" + xmlString1 + "]");
			System.out.println("wfValData value of xmlString [" + xmlString2 + "]");
			if (xmlString != null && xmlString.trim().length() != 0) {
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) {
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams, formName);
			System.out.println("ErrString: " + errString);
		} catch (Exception e) {
			System.out.println("Exception: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("Returning from  wfValData");
		return (errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag,
			String xtraParams, String formName) throws RemoteException, ITMException {
		System.out.println("Validation is Called");
		System.out.println("Sanket D");

		String empCode = "", empFname = "", empMname = "", empLname = "";
		int currentFormNo = 0;

		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		SimpleDateFormat sdf = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String userId = "", errorCode = "", errorString = "";

		int ctr = 0, childNodeListLength = 0, count = 0;
		try {
			conn = getConnection();
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			sdf = new SimpleDateFormat("dd/MM/yy");
			if (objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext);
				System.out.println("current Form No:" + currentFormNo);
			}

			switch (currentFormNo) {
			case 1:
				parentNodeList = dom.getElementsByTagName("Detail1");
				int parentNodeListLen = parentNodeList.getLength();
				System.out.println("Number of nodes in parentNodeList : " + parentNodeListLen);
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				for (ctr = 0; ctr < childNodeListLength; ctr++) {
					childNode = childNodeList.item(ctr);
					childNodeName = checkNull(childNode.getNodeName());
					if (childNodeName.equalsIgnoreCase("emp_code")) {
						empCode = checkNull(genericUtility.getColumnValue("emp_code", dom));
						if (empCode == null || empCode.trim().length() == 0) {
							errorCode = "ORGSTUE";
							errorString = getErrorString("emp_code", errorCode, userId);
							break;
						}
						String sqlString = "SELECT count(*) as cnt FROM employee WHERE emp_code=?";
						pstmt = conn.prepareStatement(sqlString);
						pstmt.setString(1, empCode);
						rs = pstmt.executeQuery();
						if (rs.next()) {
							count = rs.getInt("cnt");
						}
						if (rs != null) {
							rs.close();
							rs = null;
						}
						if (pstmt != null) {
							pstmt.close();
							pstmt = null;
						}
						if (count == 0) {
							errorCode = "ORGSTUF";
							errorString = getErrorString("emp_code", errorCode, userId);
							break;
						}
						String countSql = "SELECT count(*) as cnt FROM org_structure WHERE emp_code=?";
						pstmt = conn.prepareStatement(countSql);
						pstmt.setString(1, empCode);
						rs = pstmt.executeQuery();
						if (rs.next()) {
							count = rs.getInt("cnt");
						}
						if (rs != null) {
							rs.close();
							rs = null;
						}
						if (pstmt != null) {
							pstmt.close();
							pstmt = null;
						}
						if (count > 0) {
							errorCode = "ORGSTUC";
							errorString = getErrorString("emp_code", errorCode, userId);
							break;
						}
					}
				}
			}
		} catch (Exception e) {
			System.out.println("In case of any exception...:");
			System.out.println("Exception ::" + e);
			e.printStackTrace();
			throw new ITMException(e);
		} finally {
			try {
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
				System.out.println("Excpetion closing" + e);
			}
		}
		return errorString;
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext,
			String currentColumn, String editFlag, String xtraParams, String formName)
			throws RemoteException, ITMException {
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;

		String valueXmlString = "";
		try {
			System.out.println("IssueConfirmation xmlString in itemChanged..::[" + xmlString + "]");
			System.out.println("IssueConfirmation xmlString1 in itemChanged..:: [" + xmlString1 + "]");
			System.out.println("IssueConfirmation xmlString2 in itemChanged..:: [" + xmlString2 + "]");

			if (xmlString != null && xmlString.length() > 0) {
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.length() > 0) {
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.length() > 0) {
				dom2 = genericUtility.parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams, formName);
			System.out.println("IssueConfirmation valueXmlString Returning at Stage 1[" + valueXmlString + "]");
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception :SordForm [:" + e.getMessage() + ":]");
			valueXmlString = genericUtility.createErrorString(e);
		}
		System.out.println("IssueConfirmation valueXmlString returning at Stage 2[" + valueXmlString + "]");
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn,
			String editFlag, String xtraParams, String formName) {
		System.out.println("Item Changed Called");
		Connection conn = null;
		java.sql.PreparedStatement pstmt = null;
		ResultSet rs = null;
		SimpleDateFormat sdf = null;
		String sqlString = "", empCode = "", empFname = "", empMname = "", empLname = "";
		;
		StringBuffer valueXmlString = null;
		int currentFormNo = 0, count = 0;
		try {
			conn = getConnection();
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Calendar currentDate = Calendar.getInstance();
			String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			String todayDate = sdf.format(currentDate.getTime());
			if (objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><Header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></Header>");
			System.out.println("Form No:::" + currentFormNo);
			System.out.println("Total form count " + objContext.length());
			switch (currentFormNo) {
			case 1:
				valueXmlString.append("<Detail1>");
				if ("emp_code".equalsIgnoreCase(currentColumn.trim())) {
					empCode = checkNull(genericUtility.getColumnValue("emp_code", dom));
					sqlString = "select emp_fname,emp_mname,emp_lname from employee where emp_code=?";
					pstmt = conn.prepareStatement(sqlString);
					pstmt.setString(1, empCode);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						empFname = checkNull(rs.getString("emp_fname"));
						empMname = checkNull(rs.getString("emp_mname"));
						empLname = checkNull(rs.getString("emp_lname"));
					}
					if (rs != null) {
						rs.close();
						rs = null;
					}

					if (pstmt != null) {
						pstmt.close();
						pstmt = null;
					}
					String name = empFname + " " + empMname + " " + empFname;
					valueXmlString.append("<emp_name>").append("<![CDATA[" + name + "]]>").append("</emp_name>");
				}
			}

		} catch (Exception e) {
			System.out.println("Exception" + e);
			e.printStackTrace();
		} finally {
			try {
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
				System.out.println("Excpetion closing" + e);
			}

		}
		valueXmlString.append("</Detail1>\r\n");
		valueXmlString.append("</Root>\r\n");
		System.out.println("IssueConfirmation :itemChanged(Document,String):return valueXmlString" + valueXmlString);
		return valueXmlString.toString();
	}

	public static String checkNull(String input) {
		if (input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input)) {
			input = "";
		}
		return input.trim();
	}
}
