package ibase.webitm.bean.wsfa;

import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.wsfa.transactions.StrgMeetOtcWizardRemote;
import ibase.webitm.ejb.wsfa.transactions.StrgMeetOtcWizardEJB;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;

import java.text.SimpleDateFormat;
import java.util.*;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.ResultSet;

import javax.naming.InitialContext;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OtcWizardBean
{

	private UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	private String objName = "";
	private String user_lang ="en"; 
	private String user_country = "US";


	public OtcWizardBean( String objName, HttpSession sessionCtx ) throws ITMException
	{
		try
		{
			this.objName = objName;
			this.sessionCtx = sessionCtx;
			this.userInfo = ( ibase.utility.UserInfoBean ) this.sessionCtx.getAttribute("USER_INFO");
			
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}		
	}

	public OtcWizardBean() throws ITMException
	{
	}
	
	//Added bys sachin satre on [14-nov-16] start
	public UserInfoBean getUserInfo()
	{
		return this.userInfo;
	}
	public void setUserInfo(UserInfoBean userInfo) 
	{
		System.out.println("getUserInfo"+userInfo);
		this.userInfo = userInfo;
		System.out.println("getUserInfo"+userInfo);
	}
	//Added bys sachin satre on [14-nov-16] end

	private String getXSLFileName( String xslFileName )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				throw new ITMException( new Exception("Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}
	

	public String getSalesPersItemList( String sprsCode,String workDate, String strgCode,String strgType, String selectedItem ) throws ITMException
	{
		//Form 4 defaultData()
		String sql = "";
		String sql1 = "";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		PreparedStatement pStmt = null;
		PreparedStatement pStmt1 = null;
		ResultSet rs = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String itemData="";
		int num =1 ;
		String xslFileName ="";
		HashMap itemMap = new HashMap();
		
		try
		{
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			//added by sachin satre on [14-nov-16] [start]
			connectionObject =getConnection();
			System.out.println("connectionObject"+connectionObject);
			//added by sachin satre on [14-nov-16] [end]
			
			workDate = genericUtility.getValidDateString( workDate , genericUtility.getApplDateFormat() , "dd-MMM-yyyy");
			valueXmlString.append( "<Root>\r\n" );
			if(strgType.equalsIgnoreCase("C"))
			{
					xslFileName = getXSLFileName( "strg_meet_otc_item_che_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );

					if ( selectedItem != null && selectedItem.trim().length() > 0 )
					{
						NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("strg_item");
						int nodeListLen = itemNodeList.getLength();
						for ( int i=0; i < nodeListLen ; i++ )
						{
							NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
							int innerNodeListLen = innerNodeList.getLength();
							String itemCode = "";
							String saleGroup = "";
							String pitch = "";
							String qty = "";
							String columnValue = "";
							String pob = "";

							for ( int j = 0; j < innerNodeListLen; j++ )
							{
								Node currNode = innerNodeList.item( j );
								System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");						
								if ( "item_code".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null)
									{
										itemCode = currNode.getFirstChild().getNodeValue().trim() ;
										itemCode = itemCode.trim();
									}
								}
								else if("sales_prod_grp".equals( currNode.getNodeName() ))
								{
									if(currNode.getFirstChild() != null)
									{
										saleGroup = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "briefed_descr".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null  )
									{
										pitch = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "quantity".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null )
									{
										qty = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "item_pob".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null )
									{
										pob = currNode.getFirstChild().getNodeValue().trim();
									}
								}
							}
							System.out.println("itemCode["+itemCode+"] pitch["+pitch+"] qty["+qty+"]" );
							itemMap.put( itemCode,pob);	
							
							System.out.println(" itemMap ["+itemMap+"]");
						}
					}

					//Remarked and Changed by Piyush - 19/05/2010
					//sql1 = "SELECT M.ITEM_CODE ITEM, M.DESCR DESCR,'0' QTY,'' PITCH,'' BRIEF,M.SALES_PROD_GRP SPRDG  FROM ITEM M, SALES_PROD_GRP SPG WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + )";
					//Commented And Below Changes Done By Shahu Mali on 07-10-13
					//sql1 = "SELECT M.ITEM_CODE ITEM, M.DESCR DESCR,'0' QTY,'' PITCH,'' BRIEF,M.SALES_PROD_GRP SPRDG  FROM ITEM M, SALES_PROD_GRP SPG WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ?  AND SPRS_ITEM.ITEM_CODE = M.ITEM_CODE ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + ) ";
					sql1 = "SELECT M.ITEM_CODE ITEM, M.DESCR DESCR,'0' QTY,'' PITCH,'' BRIEF,M.SALES_PROD_GRP SPRDG  FROM ITEM M, SALES_PROD_GRP SPG WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? AND SPRS_ITEM.STATUS='Y'  AND SPRS_ITEM.ITEM_CODE = M.ITEM_CODE ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + ) AND M.ACTIVE='Y' ";
					pStmt1 = connectionObject.prepareStatement(sql1);
					pStmt1.setString(1, sprsCode);
					rs = pStmt1.executeQuery();
			}
			else 
			{
				xslFileName = getXSLFileName( "strg_meet_otc_item_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );


				if ( selectedItem != null && selectedItem.trim().length() > 0 )
				{
						NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("strg_item");
						int nodeListLen = itemNodeList.getLength();
						for ( int i=0; i < nodeListLen ; i++ )
						{
							NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
							int innerNodeListLen = innerNodeList.getLength();
							String itemCode = "";
							String saleGroup = "";
							String pitch = "";
							String qty = "";
							String columnValue = "";
							String pob = "";
							String pitchBase = "";
							String pitchRate = "";
							String actualPitch = "";
							String sampleIss = "";
							String prescNo = "0"; // Added by AMit D 
							
							for ( int j = 0; j < innerNodeListLen; j++ )
							{
								Node currNode = innerNodeList.item( j );
								System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");						
								if ( "item_code".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null)
									{
										itemCode = currNode.getFirstChild().getNodeValue().trim() ;
										itemCode = itemCode.trim();
									}
								}
								else if("sales_prod_grp".equals( currNode.getNodeName() ))
								{
									if(currNode.getFirstChild() != null)
									{
										saleGroup = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "briefed_descr".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null  )
									{
										pitch = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "quantity".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null )
									{
										qty = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "item_pob".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null )
									{
										pob = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "pitch_base".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null )
									{
										pitchBase = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "pitch_rate".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null )
									{
										pitchRate = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "actual_pitch".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null )
									{
										actualPitch = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "sample_issue".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null )
									{
										sampleIss = currNode.getFirstChild().getNodeValue().trim();
									}
								}
							}
							// Remarked and changed bellow to add sales product group - 22/05/2010
							/*
							System.out.println("itemCode["+itemCode+"] pitchBase["+pitchBase+"] pitchRate["+pitchRate+"]actualPitch["+actualPitch );
							itemMap.put( itemCode,pitchBase+"~"+pitchRate+"~"+actualPitch );	
							*/
							System.out.println("saleGroup["+saleGroup+"] pitchBase["+pitchBase+"] pitchRate["+pitchRate+"]actualPitch["+actualPitch+"] prescNo ["+prescNo+"]" );
							itemMap.put( saleGroup,actualPitch+"~"+pitchBase+"~"+pitchRate+"~"+sampleIss+"~"+prescNo );	 // prescNo is Added by Amit D
							
							System.out.println(" itemMap ["+itemMap+"]");
						}
					}

				//Changed By Pragyan 1/19/2011 [WS01NOV010]	To filter the item data with subclass code
				/* Remarked and changed bellow by Piyush on 21/05/2010 (As per explanation/logic of master plan given by Suparna.
				sql = "SELECT M.ITEM_CODE ITEM,ITEM.DESCR DESCR, M.BRIEFED_DESCR PITCH,M.BRIEFED BRIEF,M.SALES_PROD_GRP SPRDG,M.QUANTITY QTY FROM MASTER_PLAN M,STRG_SERIES S ,SPRS_ITEM SPRS_ITEM , ITEM ITEM  WHERE DATE_TO >= ? AND DATE_FROM <= ?"
						+" AND M.CUST_TYPE = ? AND M.ACTIVE='Y'"
						+" AND M.CLASS_CODE = S.CLASS_CODE "
						+" AND M.SPL_CODE = S.SPL_CODE "
						+"AND M.ITEM_SER = S.ITEM_SER "
						+" AND S.SC_CODE =? AND S.SALES_PERS=?"
						+" AND S.SALES_PERS = SPRS_ITEM.SALES_PERS "
						+" AND SPRS_ITEM.ITEM_CODE = ITEM.ITEM_CODE"
						+" AND( ITEM.ITEM_CODE = M.ITEM_CODE     OR   ITEM.SALES_PROD_GRP = M.SALES_PROD_GRP  )";
				*/

				/*sql = "SELECT M.ITEM_CODE ITEM,SPG.DESCR DESCR, M.BRIEFED_DESCR PITCH,M.BRIEFED BRIEF,M.SALES_PROD_GRP SPRDG,M.QUANTITY QTY FROM MASTER_PLAN M,STRG_SERIES S ,SALES_PROD_GRP SPG WHERE DATE_TO >= ? AND DATE_FROM <= ? "
						+" AND M.CUST_TYPE = ? AND M.ACTIVE='Y'"
						+" AND M.CLASS_CODE = S.CLASS_CODE "
						+" AND M.SPL_CODE = S.SPL_CODE "
						+"AND M.ITEM_SER = S.ITEM_SER "
						+" AND S.SC_CODE =? AND S.SALES_PERS=?" 
						+" AND SPG.SALES_PROD_GRP = M.SALES_PROD_GRP";
				 */
				      // changeses by rakesh kumar
				sql = "SELECT M.ITEM_CODE ITEM,SPG.DESCR DESCR, M.BRIEFED_DESCR PITCH,M.BRIEFED BRIEF,M.SALES_PROD_GRP SPRDG,M.QUANTITY QTY FROM MASTER_PLAN M,STRG_SERIES S ,SALES_PROD_GRP SPG WHERE DATE_TO >= ? AND DATE_FROM <= ? "
						+" AND M.CUST_TYPE = ? AND M.ACTIVE='Y'"
						+" AND M.CLASS_CODE = S.CLASS_CODE "
						+" AND M.SUBCLASS_CODE = S.SUBCLASS_CODE "
						+" AND M.SPL_CODE = S.SPL_CODE "
						+" AND M.ITEM_SER = S.ITEM_SER "
						+" AND S.SC_CODE =? AND S.SALES_PERS=?" 
						+" AND SPG.SALES_PROD_GRP = M.SALES_PROD_GRP ORDER BY TO_NUMBER(SUBSTR(M.BRIEFED_DESCR,2,2))";
				
						pStmt = connectionObject.prepareStatement(sql);
						pStmt.setString(1, workDate);
						pStmt.setString(2, workDate);
						pStmt.setString(3, strgType);
						pStmt.setString(4, strgCode);
						pStmt.setString(5, sprsCode);
						rs = pStmt.executeQuery();

			}
			
			int i = 0; // Added by Piyush - 22/05/2010
			while(rs.next()) 
			{
				// Check null is added by Piyush to avoide null poonter exception - 21/05/2010
				String itemCode = (checkNull(rs.getString("ITEM"))).trim();
				System.out.println("itemCode["+itemCode+"]");
				String itemDescr = checkNull(rs.getString("DESCR"));
				String pitch = checkNull(rs.getString("PITCH"));
				String brief = checkNull(rs.getString("BRIEF"));
				String salesProdgrp = checkNull(rs.getString("SPRDG"));
				String qty = checkNull(rs.getString("QTY"));
				String pitchBase = "N";
				String pitchRate = "N";
				String actualPitch = "N";
				String sampleIss = "N";
				String prescNo = "0"; // Added by AMit D 
				
				if(strgType.equalsIgnoreCase("D"))
				{

					System.out.println("salesProdgrp["+salesProdgrp+"]"); // Added by Piyush
					// Remarked and changed bellow by Piyush - 22/05/2010
					//if ( itemMap.get( itemCode ) != null )
					if ( itemMap.get( salesProdgrp ) != null )
					{
						//Remarked and changed bellow by Piyush on 22/05/2010
						//String data = ( String ) itemMap.get( itemCode );
						String data = ( String ) itemMap.get( salesProdgrp );
						actualPitch = data.substring(0, data.indexOf("~") );
						data = data.substring( data.indexOf("~") + 1 );
						pitchBase = data.substring(0, data.indexOf("~") );
						data = data.substring( data.indexOf("~") + 1 );
						pitchRate = data.substring(0, data.indexOf("~") );
						data = data.substring( data.indexOf("~") + 1 ); // Added by AMit D 
						//sampleIss = data.substring( data.indexOf("~") + 1 ); // Comemted by AMit D 
						sampleIss = data.substring( 0,data.indexOf("~"));
						prescNo   = data.substring( data.indexOf("~") + 1 ); // Added by AMit D
					}
					actualPitch = pitch; 	// Added by Amit D to set Planned Pitch as Actual Pitch
					
					valueXmlString.append( "<Detail9 domID='" + num + "' selected = 'Y'>\r\n" );	
					valueXmlString.append("<item_descr><![CDATA[").append(itemDescr).append("]]></item_descr>\r\n");
					valueXmlString.append( "<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );					
					valueXmlString.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>\r\n");
					valueXmlString.append( "<sales_prod_grp><![CDATA[" ).append(salesProdgrp).append( "]]></sales_prod_grp>\r\n" );
					valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
					valueXmlString.append( "<briefed_descr><![CDATA[" ).append(pitch).append( "]]></briefed_descr>\r\n" );
					valueXmlString.append( "<item_pob><![CDATA[" ).append("").append( "]]></item_pob>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
					valueXmlString.append( "<pitch_base><![CDATA[").append(pitchBase).append("]]></pitch_base>\r\n" );
					valueXmlString.append( "<pitch_rate><![CDATA[").append(pitchRate).append("]]></pitch_rate>\r\n" );
					valueXmlString.append( "<plan_pitch><![CDATA[" ).append(pitch).append( "]]></plan_pitch>\r\n" );
					valueXmlString.append( "<actual_pitch><![CDATA[").append(actualPitch).append("]]></actual_pitch>\r\n" );
					valueXmlString.append( "<sample_issue><![CDATA[").append(sampleIss).append("]]></sample_issue>\r\n" );
					valueXmlString.append( "<presc_no><![CDATA[").append(prescNo).append("]]></presc_no>\r\n" ); // Added by AMit D 
					valueXmlString.append( "</Detail9>\r\n" );
				}
				else
				{

					String pob ="";

					//valueXmlString.append( "<Detail9 domID='" + num + "' selected = 'N'>\r\n" );	
					if ( itemMap.get( itemCode ) != null )
					{
						pob = ( String ) itemMap.get( itemCode );
						valueXmlString.append( "<Detail9 domID='" + num + "' selected = 'Y'>\r\n" );
					}
					else
					{
						valueXmlString.append( "<Detail9 domID='" + num + "' selected = 'N'>\r\n" );

					}
					valueXmlString.append("<item_descr><![CDATA[").append(itemDescr).append("]]></item_descr>\r\n");
					valueXmlString.append( "<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );					
					valueXmlString.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>\r\n");
					valueXmlString.append( "<sales_prod_grp><![CDATA[" ).append(salesProdgrp).append( "]]></sales_prod_grp>\r\n" );
					valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
					valueXmlString.append( "<briefed_descr><![CDATA[" ).append(pitch).append( "]]></briefed_descr>\r\n" );
					valueXmlString.append( "<item_pob><![CDATA[" ).append(pob).append( "]]></item_pob>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
					valueXmlString.append( "<actual_pitch><![CDATA[]]></actual_pitch>\r\n" );
					valueXmlString.append( "<pitch_base><![CDATA[]]></pitch_base>\r\n" );
					valueXmlString.append( "<pitch_rate><![CDATA[]]></pitch_rate>\r\n" );
					valueXmlString.append( "<plan_pitch><![CDATA[]]></plan_pitch>\r\n" );
					valueXmlString.append( "<sample_issue><![CDATA[]]></sample_issue>\r\n" );
					valueXmlString.append( "<presc_no><![CDATA[").append(prescNo).append("]]></presc_no>\r\n" ); // Added by AMit D 
					valueXmlString.append( "</Detail9>\r\n" );

				}



				num++;
				qty = "0";
				pitch = "";
			}
			rs.close();
			rs = null;
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			if(pStmt1 != null)
			{
				pStmt1.close();
				pStmt1 = null;
			}

			valueXmlString.append( "</Root>\r\n" );
			
			/*//Changed By Vidhya on 02/09/09[] Start
			sql = "SELECT DISTINCT SPG.SALES_PROD_GRP ITEM, SPG.DESCR DESCR FROM SALES_PROD_GRP SPG, ITEM M  WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + )";

			// sql = "SELECT SI.ITEM_CODE ITEM, I.DESCR DESCR FROM ITEM I, SPRS_ITEM SI  WHERE SI.ITEM_CODE = I.ITEM_CODE AND SI.SALES_PERS =? ";
			sql1 = "SELECT M.ITEM_CODE ITEM, M.DESCR DESCR FROM ITEM M, SALES_PROD_GRP SPG WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + )";
			//Changed By Vidhya on 02/09/09[] END
				
			System.out.println(" selectedItem ["+selectedItem+"]");
			
			HashMap itemMap = new HashMap();
			if ( selectedItem != null && selectedItem.trim().length() > 0 )
			{
				NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("strg_item");
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String itemCode = "";
					String pitch = "";
					String qty = "";
					String columnValue = "";

					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");						
						if ( "item_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if("sales_prod_grp".equals( currNode.getNodeName() ))
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim() + "-SPG";
							}
						}
						else if ( "briefed_descr".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								pitch = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "quantity".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								qty = currNode.getFirstChild().getNodeValue().trim();
							}
						}
					}
					System.out.println("itemCode["+itemCode+"] pitch["+pitch+"] qty["+qty+"]" );
					itemMap.put( itemCode, pitch+"~"+qty);	
					
					System.out.println(" itemMap ["+itemMap+"]");
				}
			}

			valueXmlString.append( "<Root>\r\n" );	
			String qty = "0";
			String pitch = "";

			//Changed By Vidhya on 02/09/09[] Start
			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString(1, sprsCode);
			rs = pstmt.executeQuery();
			while(rs.next()) 
			{
				String itemCode = (rs.getString("ITEM")).trim() + "-SPG";
				System.out.println("itemCode["+itemCode+"]");
				if ( itemMap.get( itemCode ) != null )
				{
					String data = ( String ) itemMap.get( itemCode );
					pitch = data.substring(0, data.indexOf("~") );
					qty = data.substring( data.indexOf("~") + 1 );
					valueXmlString.append( "<Detail9 domID='" + num + "' selected = 'Y'>\r\n" );
				}
				else
				{
					valueXmlString.append( "<Detail9 domID='" + num + "' selected = 'N'>\r\n" );
				}

				valueXmlString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
				valueXmlString.append( "<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );					valueXmlString.append("<item_code><![CDATA[").append("").append("]]></item_code>\r\n");
				valueXmlString.append( "<sales_prod_grp><![CDATA[" ).append(rs.getString("ITEM")).append( "]]></sales_prod_grp>\r\n" );
				valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
				valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
				//Changed By Vidhya on 29/07/09[WI89BAS023 | for new hidden fields added] Start
				valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
				valueXmlString.append( "<briefed_descr><![CDATA[" ).append(pitch).append( "]]></briefed_descr>\r\n" );
				valueXmlString.append( "<item_pob><![CDATA[" ).append("").append( "]]></item_pob>\r\n" );
				valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
				//Changed By Vidhya on 29/07/09[WI89BAS023 | for new hidden fields added] End
				valueXmlString.append( "</Detail9>\r\n" );
				num++;
				qty = "0";
				pitch = "";
			}
			//Changed By Vidhya on 02/09/09[]END	
			
			pstmt =  connectionObject.prepareStatement( sql1 );
			pstmt.setString(1, sprsCode);
			rs = pstmt.executeQuery();
			while(rs.next()) 
			{
				String itemCode = rs.getString("ITEM");
				if ( itemMap.get( itemCode.trim() ) != null )
				{
					String data = ( String ) itemMap.get( itemCode.trim() );
					qty = data.substring( data.indexOf("~") + 1 );
					valueXmlString.append("<Detail9 domID='"+num+"' selected = 'Y'>\r\n" );
				}
				else
				{
					valueXmlString.append("<Detail9 domID='"+num+"' selected = 'N'>\r\n" );
				}
				
				valueXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
				valueXmlString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
				valueXmlString.append( "<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );		
				valueXmlString.append("<item_code><![CDATA[").append( rs.getString("ITEM") ).append("]]></item_code>\r\n");			
				valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
				valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
				valueXmlString.append( "<briefed_descr><![CDATA[" ).append("Promo Material").append( "]]></briefed_descr>\r\n" );
				valueXmlString.append( "<sales_prod_grp><![CDATA[" ).append("").append( "]]></sales_prod_grp>\r\n" );
				valueXmlString.append( "<item_pob><![CDATA[" ).append("").append( "]]></item_pob>\r\n" );
				valueXmlString.append( "</Detail9>\r\n" );
				qty = "0";
				num++;
			}//end of while
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			num = 1;
		

			valueXmlString.append( "</Root>\r\n" );
			*/

			
			itemData = valueXmlString.toString();
			//changed by Rahul Barve on 3-sep-2014
			//itemData = (    ibase.webitm.utility. GenericUtility.getInstance()  ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			itemData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
			
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return itemData;
	}

   /* Start Added By Shahu Mali on 11-12-12
    *  Provision to be given to select  sample and gift from the pop help  in Doctor  Meeting Screen of OTC Medical Reporting .
    *  Request ID :WS2INOV004*/

	public String getSampleItemList( String sprsCode,String workDate, String strgCode,String strgType, String selectedItem ) throws ITMException
	{
		System.out.println("sprsCode=>"+sprsCode+"workDate=>"+workDate+"strgCode=>"+strgCode+"strgType=>"+strgType+"selectedItem=>"+selectedItem); 
		//Form 4 defaultData()
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		PreparedStatement pStmt = null;
		PreparedStatement pStmt1 = null;
		ResultSet rs = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String sampleData="";
		int num =1 ;
		String xslFileName ="";
		HashMap itemMap = new HashMap();
		
		try
		{
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			//added by sachin satre on [14-nov-16] [start]
			connectionObject =getConnection();
			System.out.println("connectionObject"+connectionObject);
			//added by sachin satre on [14-nov-16] [end]
			 		
			workDate = genericUtility.getValidDateString( workDate , genericUtility.getApplDateFormat() , "dd-MMM-yyyy");
			valueXmlString.append( "<Root>\r\n" );
		
			if ( selectedItem != null && selectedItem.trim().length() > 0 )
			{  
				xslFileName = getXSLFileName( "strg_meet_otc_sampleitems_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" ); 
				NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("strg_item");
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String itemCode = "";
					String itemDescr = "";
					String qty = "";
					String columnValue = "";
							
					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");						
						if ( "item_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim() ;
								itemCode = itemCode.trim();
							}
						}
						else if("item_descr".equals( currNode.getNodeName() ))
						{
							if(currNode.getFirstChild() != null)
							{
								itemDescr = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "quantity".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null )
							{
								qty = currNode.getFirstChild().getNodeValue().trim();
							}
						}
					}
					System.out.println("itemCode["+itemCode+"] itemDescr["+itemDescr+"] qty["+qty+"]" );
					itemMap.put( itemCode,"~"+qty);	
					System.out.println(" itemMap ["+itemMap+"]");
				
				}
			}
				sql = "SELECT ITEM_CODE,DESCR "
					  +" FROM ITEM_OWN   "
					  +" WHERE ITEM_TYPE='S' ";
				pStmt = connectionObject.prepareStatement(sql);
				rs = pStmt.executeQuery();		
				String qty = "0";
				int i = 0; 
				while(rs.next()) 
				{
					String itemCode = (checkNull(rs.getString("ITEM_CODE"))).trim();
					System.out.println("itemCode["+itemCode+"]");
					String itemDescr = checkNull(rs.getString("DESCR"));
            		if ( itemMap.get( itemCode.trim() ) != null )
            		{
            			String data = ( String ) itemMap.get( itemCode.trim() );
            			qty = data.substring( data.indexOf("~") + 1 );
            			valueXmlString.append("<Detail10 domID='"+num+"' selected = 'Y'>\r\n" );
            		}
            		else
            		{
            			valueXmlString.append("<Detail10 domID='"+num+"' selected = 'N'>\r\n" );
            		}	
        		 	valueXmlString.append("<item_descr><![CDATA[").append(itemDescr).append("]]></item_descr>\r\n");
        		    valueXmlString.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>\r\n");
        		 	valueXmlString.append( "<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );
					valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
					valueXmlString.append( "</Detail10>\r\n" );
					num++;
					qty = "0";
				}
				System.out.println("strgCode>>>>"+strgCode+"NUM>>>>>"+num);
				rs.close();
				rs = null;
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			valueXmlString.append( "</Root>\r\n" );	
			sampleData = valueXmlString.toString();
			System.out.println( "xslFileName======> :"+xslFileName );	
			//changed by Rahul Barve on 3-sep-2014
			//sampleData = (   ibase.webitm.utility. GenericUtility.getInstance()  ).transformToString( xslFileName, sampleData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			sampleData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, sampleData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );


		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :ITMWizardStatefulEJB :getSampleItemList(String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSampleItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
			
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return sampleData;
	}
	/* Start Added By Shahu Mali on 11-12-12
	    *  Provision to be given to select  sample and gift from the pop help  in Doctor  Meeting Screen of OTC Medical Reporting .
	    *  Request ID :WS2INOV004*/

/***getGiftItemList**/
	public String getGiftItemList( String sprsCode,String workDate, String strgCode,String strgType, String selectedItem ) throws ITMException
	{
		
	    System.out.println("sprsCode=>"+sprsCode+"workDate=>"+workDate+"strgCode=>"+strgCode+"strgType=>"+strgType+"selectedItem=>"+selectedItem);
		//Form 4 defaultData()
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		PreparedStatement pStmt = null;
		PreparedStatement pStmt1 = null;
		ResultSet rs = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String giftData="";
		int num =1 ;
		String xslFileName ="";
		HashMap itemMap = new HashMap();
		try
		{
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			//added by sachin satre on [14-nov-16] [start]
			connectionObject =getConnection();
			System.out.println("connectionObject"+connectionObject);
			//added by sachin satre on [14-nov-16] [end]
			
			workDate = genericUtility.getValidDateString( workDate , genericUtility.getApplDateFormat() , "dd-MMM-yyyy");
			valueXmlString.append( "<Root>\r\n" );
		
			if ( selectedItem != null && selectedItem.trim().length() > 0 )
			{	
				xslFileName = getXSLFileName( "strg_meet_otc_giftitems_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
				NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("strg_item");
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String itemCode = "";
					String itemDescr = "";
					String qty = "";
					String columnValue = "";
					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						System.out.println("COLUMN NAME ["+ currNode.getNodeName()+"] COLUMN VALUE["+currNode.getFirstChild()+"] ");						
						if ( "item_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim() ;
								itemCode = itemCode.trim();
							}
						}
						else if("item_descr".equals( currNode.getNodeName() ))
						{
							if(currNode.getFirstChild() != null)
							{
								itemDescr = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "quantity".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null )
							{
								qty = currNode.getFirstChild().getNodeValue().trim();
							}
						}
					}
					System.out.println("itemCode["+itemCode+"] itemDescr["+itemDescr+"] qty["+qty+"]" );
					itemMap.put( itemCode,"~"+qty);	
					System.out.println(" itemMap ["+itemMap+"]");
				}
			}
			
			String itemSer = "";
			String hobby1 = "";
			String applicableTo = "";
			String sqlEmp = "select  a.item_ser, b.hobby1 from sales_pers a, employee b where a.sales_pers = b.emp_code and b.emp_code='"+sprsCode+"'";
			PreparedStatement pstmtEmp =  connectionObject.prepareStatement(sqlEmp);  
			ResultSet rsEmp = pstmtEmp.executeQuery();       
			if(rsEmp.next())                        
			{   
				itemSer = rsEmp.getString("item_ser")==null ? "":rsEmp.getString("item_ser").trim();
				hobby1 = rsEmp.getString("hobby1")==null ? "":rsEmp.getString("hobby1").trim();
			}
			rsEmp.close();rsEmp = null;
			pstmtEmp.close();pstmtEmp = null;
			
			if( hobby1.equalsIgnoreCase("RSR") && itemSer.equalsIgnoreCase("OTC"))
			{
				applicableTo = "R";
			}
			else if( itemSer.equalsIgnoreCase("OTC"))
			{
				applicableTo = "M";
			}
			
			sql = "SELECT DISTINCT B.ITEM_CODE,A.DESCR,A.ITEM_TYPE,C.SPL_CODE "
					  +"FROM ITEM_OWN A,ITEM_OWN_VALIDITY B,STRG_SPECIALITY C "
					  +"WHERE A.ITEM_CODE=B.ITEM_CODE "
					  +"AND B.SPL_CODE=C.SPL_CODE "
			    	  +"AND A.ITEM_TYPE='G' "
			    	  +"AND C.SC_CODE= ? "
			    	  +"AND A.APPLICABLE_TO = ? "
					  +"AND VALID_FROM <= ? "
					  +"AND VALID_UPTO >= ? ";
				pStmt = connectionObject.prepareStatement(sql);
				pStmt.setString(1, strgCode);
				pStmt.setString(2, applicableTo);
				pStmt.setString(3, workDate);
				pStmt.setString(4, workDate);
				rs = pStmt.executeQuery();	
				String qty = "0";
				int i = 0; 
				while(rs.next()) 
				{
					String itemCode = (checkNull(rs.getString("ITEM_CODE"))).trim();
					System.out.println("itemCode["+itemCode+"]");
					String itemDescr = checkNull(rs.getString("DESCR"));
					String SplCode=checkNull(rs.getString("SPL_CODE"));
            		if ( itemMap.get( itemCode.trim() ) != null )
            		{
            			String data = ( String ) itemMap.get( itemCode.trim() );
            			qty = data.substring( data.indexOf("~") + 1 );
            			valueXmlString.append("<Detail11 domID='"+num+"' selected = 'Y'>\r\n" );
            		}
            		else
            		{
            			valueXmlString.append("<Detail11 domID='"+num+"' selected = 'N'>\r\n" );
            		}	
        			valueXmlString.append("<item_descr><![CDATA[").append(itemDescr).append("]]></item_descr>\r\n");
        			valueXmlString.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>\r\n");
        			valueXmlString.append( "<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );
        			valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
        			valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
        			valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
        			valueXmlString.append( "</Detail11>\r\n" );
        			num++;
        			qty = "0";
				}
				System.out.println("strgCode>>>>"+strgCode+"NUM>>>>>"+num);
				rs.close();
				rs = null;
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			
			valueXmlString.append( "</Root>\r\n" );	
			giftData = valueXmlString.toString();
			System.out.println( "xslFileName======> :"+xslFileName );
			//changed by Rahul Barve on 3-sep-2014
			//giftData = (  ibase.webitm.utility. GenericUtility.getInstance()  ).transformToString( xslFileName, giftData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			giftData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, giftData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :ITMWizardStatefulEJB :getGiftItemList(String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getGiftItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
			
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return giftData;
	}

   /*End Added By Shahu Mali on 08-12-12*/	

	public String getSalesPersTeamList( String salesPers, String strgCode, String selectedTeam ) throws ITMException
	{
		System.out.println("In side MGRTeam getSalesPersTeamList().... ");
		String sql = "";
		String [] team = new String [25];
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSet rset = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		String teamData = "";
		int num = 1;
		try
		{
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			//added by sachin satre on [14-nov-16] [start]
			connectionObject =getConnection();
			System.out.println("connectionObject"+connectionObject);
			//added by sachin satre on [14-nov-16] [end]

			selectedTeam = ( selectedTeam != null ) ? selectedTeam.trim() : selectedTeam;
			team = selectedTeam.split(",");
			System.out.println("Team selected ["+Arrays.asList(team)+"] strgCode["+strgCode+"]");
			sql = "SELECT SQL_STR FROM POPHELP WHERE FIELD_NAME='SALES_PERS' AND MOD_NAME='W_STRG_MEET'";
			pstmt =  connectionObject.prepareStatement( sql );
			rs = pstmt.executeQuery();
		
			if (rs.next())
			{
				sql = rs.getString("SQL_STR").trim().replace("'?'", "?");
				pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, salesPers);
				rs = pstmt.executeQuery();
				while(rs.next()) 
				{
					String reportTo = rs.getString("REPORT_TO");
					String desgn= rs.getString("DESIGNATION");
					System.out.println("reportTo["+reportTo+"] desgn ["+desgn+"]");
					reportTo = ( reportTo != null ) ? reportTo.trim() : reportTo;
					if ( new ArrayList<String>(Arrays.asList(team)).contains( reportTo ) )
					{
						
						valueXmlString.append( "<Detail6 domID='" + num + "' selected = 'Y'>\r\n" );
					}
					else
					{
						valueXmlString.append( "<Detail6 domID='" + num + "' selected = 'N'>\r\n" );
					}
					
					valueXmlString.append("<sales_pers><![CDATA[").append( reportTo ).append("]]></sales_pers>\r\n");
					valueXmlString.append("<name><![CDATA[").append( rs.getString("NAME") ).append("]]></name>\r\n");
					valueXmlString.append("<designation><![CDATA[").append( rs.getString("DESIGNATION")).append("]]></designation>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
					valueXmlString.append("<role_code><![CDATA[]]></role_code>\r\n");

					sql = "SELECT DESIGN_CODE FROM EMPLOYEE WHERE EMP_CODE = ?";
					pstmt =  connectionObject.prepareStatement( sql );
					pstmt.setString(1, reportTo);
					rset = pstmt.executeQuery();
					if ( rset.next())
					{
						String desgnCode = rset.getString("DESIGN_CODE") != null ?rset.getString("DESIGN_CODE").trim() :"";
						valueXmlString.append("<design_code><![CDATA[").append( desgnCode ).append("]]></design_code>\r\n");
					}
					
					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "</Detail6>\r\n" );
					num++;
				}
			}

			rs.close();
			rs = null;

			rset.close();
			rset = null;

			pstmt.close();
			pstmt = null;

			valueXmlString.append( "</Root>\r\n" );


			teamData = valueXmlString.toString();
			String xslFileName = getXSLFileName( "strg_meet_mgr_team_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//changed by Rahul Barve on 3-sep-2014
			//teamData = (  ibase.webitm.utility. GenericUtility.getInstance() ).transformToString( xslFileName, teamData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			teamData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, teamData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );


			
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :OtcWizardBean :getSalesPersTeamList(String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}

				if ( rset != null )
				{
					rset.close();
					rset = null;
				}

				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :OtcWizardBean :getSalesPersTeamList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		
		System.out.println( "\n****teamData :" + teamData );
		return teamData;
		
	}

	
	public String getActivityCodeList( String salesPers, String selectedActCode ) throws ITMException
	{
		// Code MOdified by AMit D on 17 Sept 13

		String sql = "";
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String activityCodeData = "";
		try 
		{
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverITM");*/
			//added by sachin satre on [14-nov-16] [start]
			connectionObject =getConnection();
			System.out.println("connectionObject"+connectionObject);
			//added by sachin satre on [14-nov-16] [end]
			sql = "SELECT ACTIVITY_CODE, DESCR , ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE <> 'JW' AND STATUS = 'Y'";
			System.out.println(" selectteam sql [" + sql + "]");
			pstmt = connectionObject.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int num = 1;
			while (rs.next()) 
			{
				String actCode = rs.getString("ACTIVITY_CODE");
				selectedActCode = (selectedActCode != null) ? selectedActCode.trim() : selectedActCode;
				actCode = (actCode != null) ? actCode.trim() : actCode;
				if (selectedActCode.equals(actCode)) 
				{
					valueXmlString.append("<ACTIVITY domID='" + num	+ "' selected = 'Y'>\r\n");
				} 
				else 
				{
					valueXmlString.append("<ACTIVITY domID='" + num	+ "' selected = 'N'>\r\n");
				}

				valueXmlString.append("<ACTIVITY_CODE><![CDATA[").append(actCode).append("]]></ACTIVITY_CODE>\r\n");
				valueXmlString.append("<ACTIVITY_DESCR><![CDATA[").append(rs.getString("DESCR")).append("]]></ACTIVITY_DESCR>\r\n");
				valueXmlString.append("<ACTIVITY_TYPE><![CDATA[").append(rs.getString("ACTIVITY_TYPE")).append("]]></ACTIVITY_TYPE>\r\n");
				valueXmlString.append("</ACTIVITY>\r\n");
				num++;
			}
			valueXmlString.append("</Root>\r\n");
			activityCodeData = valueXmlString.toString();
			String xslFileName = getXSLFileName( "strg_meet_otc_act_code_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//changed by Rahul Barve on 3-sep-2014
			//activityCodeData = (  ibase.webitm.utility. GenericUtility.getInstance() ).transformToString( xslFileName, activityCodeData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			activityCodeData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, activityCodeData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

			
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String):"	+ e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		} 
		finally 
		{
			try 
			{
				if (connectionObject != null && !connectionObject.isClosed()) 
				{					
					connectionObject.close();
					connectionObject = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String) :==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
	
		return activityCodeData;
	
	}

	private String getClassCode(String strgCode ,String salesPers,Connection con)
	{
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String sql = "SELECT CLASS_CODE FROM STRG_SERIES WHERE SC_CODE=? AND SALES_PERS=?";
		String clasCode = "";
		try
		{
			pStmt = con.prepareStatement(sql);
			pStmt.setString(1,strgCode);
			pStmt.setString(2,salesPers);
			rs = pStmt.executeQuery();

			if(rs.next())
			{
				clasCode = rs.getString(1);
			}
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}

		return clasCode;
	}

	// Method adde by Piyush - 21/05/2010
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}

	// End addition Piyush - 21/05/2010
	
	public String getSalesPersAdmItemList( String sprsCode, String strgCode, String selectedItem ) throws ITMException
	{
		//Form 4 defaultData()
		String sql = "";
		String sql1 = "";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int num =1 ;
		String itemData = "";
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String xslFileName = "";

		try
		{

			xslFileName = getXSLFileName( "strg_meet_admin_item_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );

			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			//added by sachin satre on [14-nov-16] [start]
			connectionObject =getConnection();
			System.out.println("connectionObject"+connectionObject);
			//added by sachin satre on [14-nov-16] [end]

			sql = "SELECT DISTINCT SPG.SALES_PROD_GRP ITEM, SPG.DESCR DESCR FROM SALES_PROD_GRP SPG, ITEM M  WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + )";
			sql1 = "SELECT M.ITEM_CODE ITEM, M.DESCR DESCR FROM ITEM M, SALES_PROD_GRP SPG WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + )";
			
			System.out.println(" getSalesPersAdmItemList ["+selectedItem+"]");
			
			HashMap itemMap = new HashMap();
			if ( selectedItem != null && selectedItem.trim().length() > 0 )
			{
				NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("strg_item");
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String itemCode = "";
					String pitch = "";
					String qty = "";
					String columnValue = "";

					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");						
						if ( "item_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if("sales_prod_grp".equals( currNode.getNodeName() ))
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim() + "-SPG";
							}
						}
						else if ( "briefed_descr".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								pitch = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "quantity".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								qty = currNode.getFirstChild().getNodeValue().trim();
							}
						}
					}
					System.out.println("itemCode["+itemCode+"] pitch["+pitch+"] qty["+qty+"]" );
					itemMap.put( itemCode, pitch+"~"+qty);	
					
					System.out.println(" itemMap ["+itemMap+"]");
				}
			}

			valueXmlString.append( "<Root>\r\n" );	
			String qty = "0";
			String pitch = "";

			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString(1, sprsCode);
			rs = pstmt.executeQuery();
			while(rs.next()) 
			{
				String itemCode = (rs.getString("ITEM")).trim() + "-SPG";
				System.out.println("itemCode["+itemCode+"]");
				if ( itemMap.get( itemCode ) != null )
				{
					String data = ( String ) itemMap.get( itemCode );
					pitch = data.substring(0, data.indexOf("~") );
					qty = data.substring( data.indexOf("~") + 1 );
					valueXmlString.append( "<Detail5 domID='" + num + "' selected = 'Y'>\r\n" );
				}
				else
				{
					valueXmlString.append( "<Detail5 domID='" + num + "' selected = 'N'>\r\n" );
				}

				valueXmlString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
				valueXmlString.append( "<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );					valueXmlString.append("<item_code><![CDATA[").append("").append("]]></item_code>\r\n");
				valueXmlString.append( "<sales_prod_grp><![CDATA[" ).append(rs.getString("ITEM")).append( "]]></sales_prod_grp>\r\n" );
				valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
				valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
				valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
				valueXmlString.append( "<briefed_descr><![CDATA[" ).append(pitch).append( "]]></briefed_descr>\r\n" );
				valueXmlString.append( "<item_pob><![CDATA[" ).append("").append( "]]></item_pob>\r\n" );
				valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
				valueXmlString.append( "</Detail5>\r\n" );
				num++;
				qty = "0";
				pitch = "";
			}			
			pstmt =  connectionObject.prepareStatement( sql1 );
			pstmt.setString(1, sprsCode);
			rs = pstmt.executeQuery();
			while(rs.next()) 
			{
				String itemCode = rs.getString("ITEM");
				if ( itemMap.get( itemCode.trim() ) != null )
				{
					String data = ( String ) itemMap.get( itemCode.trim() );
					qty = data.substring( data.indexOf("~") + 1 );
					valueXmlString.append("<Detail5 domID='"+num+"' selected = 'Y'>\r\n" );
				}
				else
				{
					valueXmlString.append("<Detail5 domID='"+num+"' selected = 'N'>\r\n" );
				}
				
				valueXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
				valueXmlString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
				valueXmlString.append( "<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );		
				valueXmlString.append("<item_code><![CDATA[").append( rs.getString("ITEM") ).append("]]></item_code>\r\n");			
				valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
				valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
				valueXmlString.append( "<briefed_descr><![CDATA[" ).append("Promo Material").append( "]]></briefed_descr>\r\n" );
				valueXmlString.append( "<sales_prod_grp><![CDATA[" ).append("").append( "]]></sales_prod_grp>\r\n" );
				valueXmlString.append( "<item_pob><![CDATA[" ).append("").append( "]]></item_pob>\r\n" );
				valueXmlString.append( "</Detail5>\r\n" );
				qty = "0";
				num++;
			}//end of while
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			num = 1;
			valueXmlString.append( "</Root>\r\n" );

			itemData = valueXmlString.toString();
			//changed by Rahul Barve on 3-sep-2014
			//itemData = (  ibase.webitm.utility.GenericUtility.getInstance() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			itemData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );


		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :OtcWizardBean :getSalesPersAdmItemList(String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :OtcWizardBean :getSalesPersAdmItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
			
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return itemData;
	}
	//Changed by Pawan on 2/16/2011 to get Sales person list.start
	//public String getSalesPersList( String objName, String selectedItem ) throws ITMException
	public String getSalesPersList( String objName, String enteredSprsStr,String selectedSprsCode) throws ITMException
	{
		String sprsCode = "";
		String sprsName = "";
		String dsigCode = "";
		String itemSer = "";
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		Connection connectionObject = null;
		Statement stmt = null;
		ResultSet rs = null;
		System.out.println("*************Inside getSalesPersList******************");
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String sprsData = "";
		int num = 1;
		try
		{
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			//added by sachin satre on [14-nov-16] [start]
			connectionObject =getConnection();
			System.out.println("connectionObject"+connectionObject);
			//added by sachin satre on [14-nov-16] [end]
			
		
				//selectedSprs = ( selectedSprs != null ) ? selectedSprs.trim() : "";
				//sprs = selectedSprs.split(",");3
						System.out.println("*************filter Token *****************["+enteredSprsStr+"]");
				//Changed by Pawan on 2/24/2011.start
				String sqlStr = "SELECT SQL_STR FROM POPHELP WHERE FIELD_NAME='SALES_PERS' AND MOD_NAME='W_STRG_MEET_ADMIN_WIZ'";
				stmt = connectionObject.createStatement();
				rs =  stmt.executeQuery(sqlStr);
				if(rs.next())
				{
					sqlStr = rs.getString("SQL_STR");
					System.out.println("sqlStr is : "+sqlStr);
					if(enteredSprsStr != null && enteredSprsStr.trim().length() > 0)
					{
						sql = sqlStr.trim() + " AND SP_NAME LIKE '%"+enteredSprsStr+"%' ";
					}
					else
					{
						sql = sqlStr.trim();
					}
				}
				System.out.println("sql is : "+sql);
				/*if(enteredSprsStr != null && enteredSprsStr.trim().length() > 0)
				{
					sql = "SELECT SALES_PERS,SP_NAME FROM SALES_PERS WHERE SP_NAME LIKE '%"+enteredSprsStr+"%'";
				}
				else
				{
					sql = "SELECT SALES_PERS,SP_NAME FROM SALES_PERS";
				}*/
				//Changed by Pawan on 2/24/2011.end
				stmt =  connectionObject.createStatement();
				rs = stmt.executeQuery(sql);

				while(rs.next()) 
				{
					sprsCode = rs.getString("SALES_PERS");
					sprsName= rs.getString("SP_NAME");
					itemSer= rs.getString("ITEM_SER");
					dsigCode= rs.getString("DESIGNATION");
					System.out.println("SALES_PERS ["+sprsCode+"] SP_NAME ["+sprsName+"]");		
					if ( selectedSprsCode.equals( sprsCode ) )
					{	
						valueXmlString.append( "<sprslist domID='" + num + "' selected = 'Y'>\r\n" );
					}
					else
					{
						valueXmlString.append( "<sprslist domID='" + num + "' selected = 'N'>\r\n" );
					}
					valueXmlString.append("<sales_pers><![CDATA[").append( checkNull(sprsCode) ).append("]]></sales_pers>\r\n");
					valueXmlString.append("<sp_name><![CDATA[").append( checkNull(sprsName) ).append("]]></sp_name>\r\n");
					valueXmlString.append("<item_ser><![CDATA[").append( checkNull(itemSer) ).append("]]></item_ser>\r\n");
					valueXmlString.append("<design_code><![CDATA[").append( checkNull(dsigCode) ).append("]]></design_code>\r\n");
					valueXmlString.append( "</sprslist>\r\n" );
					num++;
				}
			


			if(rs != null)
			{
				rs.close();
				rs = null;
			}

			if(stmt != null)
			{
				stmt.close();
				stmt = null;
			}

			valueXmlString.append( "</Root>\r\n" );

			sprsData = valueXmlString.toString();
			String xslFileName = getXSLFileName( "strg_meet_admin_wiz_sprs_list_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//changed by Rahul Barve on 3-sep-2014
			//sprsData = (  ibase.webitm.utility.GenericUtility.getInstance() ).transformToString( xslFileName, sprsData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			sprsData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, sprsData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :OtcWizardBean :getSalesPersList(String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}

				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception :OtcWizardBean :getSalesPersList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}	
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return sprsData;
		
	}
	
	//Changed by Pawan on 2/16/2011 to get Sales person list.end
	public String getAdmSalesPersTeamList( String salesPers, String strgCode, String selectedTeam ) throws ITMException
	{
		String sql = "";
		String [] team = new String [25];
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSet rset = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String teamData = "";

		try
		{
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			//added by sachin satre on [14-nov-16] [start]
			connectionObject =getConnection();
			System.out.println("connectionObject"+connectionObject);
			//added by sachin satre on [14-nov-16] [end]

			selectedTeam = ( selectedTeam != null ) ? selectedTeam.trim() : selectedTeam;
			team = selectedTeam.split(",");
			System.out.println("Team selected ["+Arrays.asList(team)+"] strgCode["+strgCode+"]");
			sql = "SELECT SQL_STR FROM POPHELP WHERE FIELD_NAME='SALES_PERS' AND MOD_NAME='W_STRG_MEET'";
			pstmt =  connectionObject.prepareStatement( sql );
			rs = pstmt.executeQuery();
			int num = 1;
			if (rs.next())
			{
				sql = rs.getString("SQL_STR").trim().replace("'?'", "?");
				pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, salesPers);
				rs = pstmt.executeQuery();
				while(rs.next()) 
				{
					String reportTo = rs.getString("REPORT_TO");
					String desgn= rs.getString("DESIGNATION");
					System.out.println("reportTo["+reportTo+"] desgn ["+desgn+"]");
					reportTo = ( reportTo != null ) ? reportTo.trim() : reportTo;
					if ( new ArrayList<String>(Arrays.asList(team)).contains( reportTo ) )
					{
						
						valueXmlString.append( "<Detail6 domID='" + num + "' selected = 'Y'>\r\n" );
					}
					else
					{
						valueXmlString.append( "<Detail6 domID='" + num + "' selected = 'N'>\r\n" );
					}
					
					valueXmlString.append("<sales_pers><![CDATA[").append( reportTo ).append("]]></sales_pers>\r\n");
					valueXmlString.append("<name><![CDATA[").append( rs.getString("NAME") ).append("]]></name>\r\n");
					valueXmlString.append("<designation><![CDATA[").append( rs.getString("DESIGNATION")).append("]]></designation>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
					valueXmlString.append("<role_code><![CDATA[]]></role_code>\r\n");

					sql = "SELECT DESIGN_CODE FROM EMPLOYEE WHERE EMP_CODE = ?";
					pstmt =  connectionObject.prepareStatement( sql );
					pstmt.setString(1, reportTo);
					rset = pstmt.executeQuery();
					if ( rset.next())
					{
						String desgnCode = rset.getString("DESIGN_CODE") != null ?rset.getString("DESIGN_CODE").trim() :"";
						valueXmlString.append("<design_code><![CDATA[").append( desgnCode ).append("]]></design_code>\r\n");
					}
					
					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "</Detail6>\r\n" );
					num++;
				}
			}

			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			
			if(rset != null)
			{
				rset.close();
				rset = null;
			}

			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			valueXmlString.append( "</Root>\r\n" );
			teamData = valueXmlString.toString();
			String xslFileName = getXSLFileName( "strg_meet_admin_team_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//changed by Rahul Barve on 3-sep-2014
			//teamData = ( ibase.webitm.utility.GenericUtility.getInstance()).transformToString( xslFileName, teamData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			teamData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, teamData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );


			
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :OtcWizardBean :getAdmSalesPersTeamList(String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}

				if ( rset != null )
				{
					rset.close();
					rset = null;
				}

				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return teamData;
		
	}
	
	public String getSubordinateList( String salesPers, String strgCode, String selectedTeam) throws ITMException
	{
		String [] team = new String [25];
		String sprsCodeWW = "";
		String sprsName = "";
		String dsigCode = "";
		String itemSer = "";
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int i = 1;
		String salpersDetail = "";
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		HashMap teamMap = null;
		HashMap travelMap = null;
		ArrayList sprsList = new  ArrayList();
		ArrayList wrkList = new  ArrayList();
		
		try
		{
			
					
				System.out.println("The getSubordinateList selecteditem["+selectedTeam+"]");
			
			
				selectedTeam = ( selectedTeam != null ) ? selectedTeam.trim() : selectedTeam;
				team = selectedTeam.split(",");
				
				sql = "SELECT SALES_PERS , SP_NAME ,ITEM_SER ,GET_EMP_DESIGNATION(SALES_PERS)AS DESIGNATION FROM SALES_PERS WHERE SALES_PERS IN (SELECT EMP_CODE  FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR REPORT_TO = EMP_CODE AND REPORT_TO IS NOT NULL)";
				/*ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
				//added by sachin satre on [14-nov-16] [start]
				connectionObject =getConnection();
				System.out.println("connectionObject"+connectionObject);
				//added by sachin satre on [14-nov-16] [end]
				pstmt =  connectionObject.prepareStatement(sql);
				
				pstmt.setString(1, salesPers);
				rs = pstmt.executeQuery();
				
								
				while(rs.next()) 
				{
					sprsCodeWW = rs.getString("SALES_PERS");
					sprsName= rs.getString("SP_NAME");
					itemSer= rs.getString("ITEM_SER");
					dsigCode= rs.getString("DESIGNATION");
					System.out.println("sprsCodeWW ["+sprsCodeWW+"] SP_NAME ["+sprsName+"]");
					sprsCodeWW =sprsCodeWW != null?sprsCodeWW.trim():sprsCodeWW;
					
					if ( new ArrayList<String>(Arrays.asList(team)).contains( sprsCodeWW ) )
					{
						valueXmlString.append( "<Detail6 domID='" + i + "' selected = 'Y'>\r\n" );
					}
					else
					{
						valueXmlString.append( "<Detail6 domID='" + i + "' selected = 'N'>\r\n" );
					}					
					valueXmlString.append("<sales_pers><![CDATA[").append( checkNull(sprsCodeWW) ).append("]]></sales_pers>\r\n");
					valueXmlString.append("<name><![CDATA[").append(sprsName ).append("]]></name>\r\n");
					valueXmlString.append("<designation><![CDATA[").append(dsigCode).append("]]></designation>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
					valueXmlString.append("<role_code><![CDATA[]]></role_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "</Detail6>\r\n" );
					i++;
				}
			valueXmlString.append( "</Root>\r\n" );
			salpersDetail = valueXmlString.toString();
			System.out.println( "\n****salpersDetail :" + salpersDetail + ":********" );
			String xslFileName = getXSLFileName( "flm_idp_strg_meet__wiz_sprs_list_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//changed by Rahul Barve on 3-sep-2014
			//salpersDetail = (  ibase.webitm.utility.GenericUtility.getInstance() ).transformToString( xslFileName, salpersDetail, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			salpersDetail = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, salpersDetail, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );


			
			if(rs != null)
			{
				rs.close();
				rs = null;
			}

			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			
			
		}
		catch (Exception e)
		{
			e.printStackTrace();
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}

				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception : :getSalesPersList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}	
		System.out.println( "\n****salpersDetail :" + salpersDetail.toString() + ":********" );
		return salpersDetail;
		
	}
	public String getManagerTeamList( String mgrCode ) throws ITMException
	{
		System.out.println("Manager id in getSalesPersonList =["+mgrCode+"]");
		String salesPerspList = "";
		StrgMeetOtcWizardRemote strgMeetOtcWizardRemote = null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			//strgMeetOtcWizardRemote = (ibase.webitm.ejb.wsfa.transactions.StrgMeetOtcWizardRemote)ctx.lookup("ibase/StrgMeetOtcWizardEJB/remote");
			salesPerspList = new StrgMeetOtcWizardEJB().getManagerTeamList( mgrCode );

			String xslFileName = getXSLFileName( "manager_team_member_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//changed by Rahul Barve on 3-sep-2014
			//salesPerspList = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, salesPerspList, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			salesPerspList = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, salesPerspList, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( strgMeetOtcWizardRemote != null )
			{
				strgMeetOtcWizardRemote = null;
			}
		}
		return salesPerspList;
	}
	
	
	// Added by AMit D on 16 Sept 13 Start
	
	public String getSalesPersItemList( String sprsCode,String workDate, String strgCode,String strgType, String selectedItem, String formNo ) throws ITMException
	{
		//Form 4 defaultData()
		String sql = "";
		String sql1 = "";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		PreparedStatement pStmt = null;
		PreparedStatement pStmt1 = null;
		ResultSet rs = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String itemData="";
		int num =1 ;
		String xslFileName ="";
		HashMap itemMap = new HashMap();
		
		try
		{
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			//added by sachin satre on [14-nov-16] [start]
			connectionObject =getConnection();
			System.out.println("connectionObject"+connectionObject);
			//added by sachin satre on [14-nov-16] [end]
			
			workDate = genericUtility.getValidDateString( workDate , genericUtility.getApplDateFormat() , "dd-MMM-yyyy");
			valueXmlString.append( "<Root>\r\n" );
			if(strgType.equalsIgnoreCase("C"))
			{
					xslFileName = getXSLFileName( "strg_meet_otc_item_che_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );

					if ( selectedItem != null && selectedItem.trim().length() > 0 )
					{
						NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("strg_item");
						int nodeListLen = itemNodeList.getLength();
						for ( int i=0; i < nodeListLen ; i++ )
						{
							NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
							int innerNodeListLen = innerNodeList.getLength();
							String itemCode = "";
							String saleGroup = "";
							String pitch = "";
							String qty = "";
							String columnValue = "";
							String pob = "";

							for ( int j = 0; j < innerNodeListLen; j++ )
							{
								Node currNode = innerNodeList.item( j );
								System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");						
								if ( "item_code".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null)
									{
										itemCode = currNode.getFirstChild().getNodeValue().trim() ;
										itemCode = itemCode.trim();
									}
								}
								else if("sales_prod_grp".equals( currNode.getNodeName() ))
								{
									if(currNode.getFirstChild() != null)
									{
										saleGroup = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "briefed_descr".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null  )
									{
										pitch = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "quantity".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null )
									{
										qty = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "item_pob".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null )
									{
										pob = currNode.getFirstChild().getNodeValue().trim();
									}
								}
							}
							System.out.println("itemCode["+itemCode+"] pitch["+pitch+"] qty["+qty+"]" );
							itemMap.put( itemCode,pob);	
							
							System.out.println(" itemMap ["+itemMap+"]");
						}
					}

					//Remarked and Changed by Piyush - 19/05/2010
					//sql1 = "SELECT M.ITEM_CODE ITEM, M.DESCR DESCR,'0' QTY,'' PITCH,'' BRIEF,M.SALES_PROD_GRP SPRDG  FROM ITEM M, SALES_PROD_GRP SPG WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + )";
					//Commented And Below Changes Done By Shahu Mali on 07-10-13
					//sql1 = "SELECT M.ITEM_CODE ITEM, M.DESCR DESCR,'0' QTY,'' PITCH,'' BRIEF,M.SALES_PROD_GRP SPRDG  FROM ITEM M, SALES_PROD_GRP SPG WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ?  AND SPRS_ITEM.ITEM_CODE = M.ITEM_CODE ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + ) ";
					sql1 = "SELECT M.ITEM_CODE ITEM, M.DESCR DESCR,'0' QTY,'' PITCH,'' BRIEF,M.SALES_PROD_GRP SPRDG  FROM ITEM M, SALES_PROD_GRP SPG WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? AND STATUS='Y' AND SPRS_ITEM.ITEM_CODE = M.ITEM_CODE ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + ) AND M.ACTIVE='Y' ";
					pStmt1 = connectionObject.prepareStatement(sql1);
					pStmt1.setString(1, sprsCode);
					rs = pStmt1.executeQuery();
			}
			else 
			{
				xslFileName = getXSLFileName( "strg_meet_otc_item_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );


				if ( selectedItem != null && selectedItem.trim().length() > 0 )
				{
						NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("strg_item");
						int nodeListLen = itemNodeList.getLength();
						for ( int i=0; i < nodeListLen ; i++ )
						{
							NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
							int innerNodeListLen = innerNodeList.getLength();
							String itemCode = "";
							String saleGroup = "";
							String pitch = "";
							String qty = "";
							String columnValue = "";
							String pob = "";
							String pitchBase = "";
							String pitchRate = "";
							String actualPitch = "";
							String sampleIss = "";
							String prescNo = "0";
							for ( int j = 0; j < innerNodeListLen; j++ )
							{
								Node currNode = innerNodeList.item( j );
								System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");						
								if ( "item_code".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null)
									{
										itemCode = currNode.getFirstChild().getNodeValue().trim() ;
										itemCode = itemCode.trim();
									}
								}
								else if("sales_prod_grp".equals( currNode.getNodeName() ))
								{
									if(currNode.getFirstChild() != null)
									{
										saleGroup = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "briefed_descr".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null  )
									{
										pitch = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "quantity".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null )
									{
										qty = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "item_pob".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null )
									{
										pob = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "pitch_base".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null )
									{
										pitchBase = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "pitch_rate".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null )
									{
										pitchRate = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "actual_pitch".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null )
									{
										actualPitch = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "sample_issue".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null )
									{
										sampleIss = currNode.getFirstChild().getNodeValue().trim();
									}
								}
								else if ( "presc_no".equals( currNode.getNodeName() ) )
								{
									if(currNode.getFirstChild() != null )
									{
										prescNo = currNode.getFirstChild().getNodeValue().trim();
									}
								}
							}
		
							System.out.println("saleGroup["+saleGroup+"] pitchBase["+pitchBase+"] pitchRate["+pitchRate+"]actualPitch["+actualPitch+"] prescNo ["+prescNo+"]" );
							itemMap.put( saleGroup,actualPitch+"~"+pitchBase+"~"+pitchRate+"~"+sampleIss+"~"+prescNo );	 
							
							System.out.println(" itemMap ["+itemMap+"]");
						}
					}

				sql = "SELECT M.ITEM_CODE ITEM,SPG.DESCR DESCR, M.BRIEFED_DESCR PITCH,M.BRIEFED BRIEF,M.SALES_PROD_GRP SPRDG,M.QUANTITY QTY FROM MASTER_PLAN M,STRG_SERIES S ,SALES_PROD_GRP SPG WHERE DATE_TO >= ? AND DATE_FROM <= ? "
						+" AND M.CUST_TYPE = ? AND M.ACTIVE='Y'"
						+" AND M.CLASS_CODE = S.CLASS_CODE "
						+" AND M.SUBCLASS_CODE = S.SUBCLASS_CODE "
						+" AND M.SPL_CODE = S.SPL_CODE "
						+" AND M.ITEM_SER = S.ITEM_SER "
						+" AND S.SC_CODE =? AND S.SALES_PERS=?" 
						+" AND SPG.SALES_PROD_GRP = M.SALES_PROD_GRP ORDER BY TO_NUMBER(SUBSTR(M.BRIEFED_DESCR,2,2))";
				
						pStmt = connectionObject.prepareStatement(sql);
						pStmt.setString(1, workDate);
						pStmt.setString(2, workDate);
						pStmt.setString(3, strgType);
						pStmt.setString(4, strgCode);
						pStmt.setString(5, sprsCode);
						rs = pStmt.executeQuery();

			}
			
			int i = 0; // Added by Piyush - 22/05/2010
			while(rs.next()) 
			{
				// Check null is added by Piyush to avoide null poonter exception - 21/05/2010
				String itemCode = (checkNull(rs.getString("ITEM"))).trim();
				System.out.println("itemCode["+itemCode+"]");
				String itemDescr = checkNull(rs.getString("DESCR"));
				String pitch = checkNull(rs.getString("PITCH"));
				String brief = checkNull(rs.getString("BRIEF"));
				String salesProdgrp = checkNull(rs.getString("SPRDG"));
				String qty = checkNull(rs.getString("QTY"));
				String pitchBase = "N";
				String pitchRate = "N";
				String actualPitch = "N";
				String sampleIss = "N";
				String prescNo = "0"; // Added by AMit D 
				
				if(strgType.equalsIgnoreCase("D"))
				{

					System.out.println("salesProdgrp["+salesProdgrp+"]"); // Added by Piyush
					// Remarked and changed bellow by Piyush - 22/05/2010
					//if ( itemMap.get( itemCode ) != null )
					if ( itemMap.get( salesProdgrp ) != null )
					{
						//Remarked and changed bellow by Piyush on 22/05/2010
						//String data = ( String ) itemMap.get( itemCode );
						String data = ( String ) itemMap.get( salesProdgrp );
						actualPitch = data.substring(0, data.indexOf("~") );
						data = data.substring( data.indexOf("~") + 1 );
						pitchBase = data.substring(0, data.indexOf("~") );
						data = data.substring( data.indexOf("~") + 1 );
						pitchRate = data.substring(0, data.indexOf("~") );
						data = data.substring( data.indexOf("~") + 1 ); // Added by AMit D 
						//sampleIss = data.substring( data.indexOf("~") + 1 ); // Comemted by AMit D 
						sampleIss = data.substring( 0,data.indexOf("~"));
						prescNo   = data.substring( data.indexOf("~") + 1 ); // Added by AMit D
					}
					actualPitch = pitch; 	// Added by Amit D to set Planned Pitch as Actual Pitch
				
					valueXmlString.append( "<Detail"+formNo+" domID='" + num + "' selected = 'Y'>\r\n" );	
					valueXmlString.append("<item_descr><![CDATA[").append(itemDescr).append("]]></item_descr>\r\n");
					valueXmlString.append( "<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );					
					valueXmlString.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>\r\n");
					valueXmlString.append( "<sales_prod_grp><![CDATA[" ).append(salesProdgrp).append( "]]></sales_prod_grp>\r\n" );
					valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
					valueXmlString.append( "<briefed_descr><![CDATA[" ).append(pitch).append( "]]></briefed_descr>\r\n" );
					valueXmlString.append( "<item_pob><![CDATA[" ).append("").append( "]]></item_pob>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
					valueXmlString.append( "<pitch_base><![CDATA[").append(pitchBase).append("]]></pitch_base>\r\n" );
					valueXmlString.append( "<pitch_rate><![CDATA[").append(pitchRate).append("]]></pitch_rate>\r\n" );
					valueXmlString.append( "<plan_pitch><![CDATA[" ).append(pitch).append( "]]></plan_pitch>\r\n" );
					valueXmlString.append( "<actual_pitch><![CDATA[").append(actualPitch).append("]]></actual_pitch>\r\n" );
					valueXmlString.append( "<sample_issue><![CDATA[").append(sampleIss).append("]]></sample_issue>\r\n" );
					valueXmlString.append( "<presc_no><![CDATA[").append(prescNo).append("]]></presc_no>\r\n" ); // Added by AMit D 
					valueXmlString.append( "</Detail"+formNo+">\r\n" );
				}
				else
				{

					String pob ="";

					//valueXmlString.append( "<Detail9 domID='" + num + "' selected = 'N'>\r\n" );	
					if ( itemMap.get( itemCode ) != null )
					{
						pob = ( String ) itemMap.get( itemCode );
						valueXmlString.append( "<Detail"+formNo+" domID='" + num + "' selected = 'Y'>\r\n" );
					}
					else
					{
						valueXmlString.append( "<Detail"+formNo+" domID='" + num + "' selected = 'N'>\r\n" );

					}
					valueXmlString.append("<item_descr><![CDATA[").append(itemDescr).append("]]></item_descr>\r\n");
					valueXmlString.append( "<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );					
					valueXmlString.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>\r\n");
					valueXmlString.append( "<sales_prod_grp><![CDATA[" ).append(salesProdgrp).append( "]]></sales_prod_grp>\r\n" );
					valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
					valueXmlString.append( "<briefed_descr><![CDATA[" ).append(pitch).append( "]]></briefed_descr>\r\n" );
					valueXmlString.append( "<item_pob><![CDATA[" ).append(pob).append( "]]></item_pob>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
					valueXmlString.append( "<actual_pitch><![CDATA[]]></actual_pitch>\r\n" );
					valueXmlString.append( "<pitch_base><![CDATA[]]></pitch_base>\r\n" );
					valueXmlString.append( "<pitch_rate><![CDATA[]]></pitch_rate>\r\n" );
					valueXmlString.append( "<plan_pitch><![CDATA[]]></plan_pitch>\r\n" );
					valueXmlString.append( "<sample_issue><![CDATA[]]></sample_issue>\r\n" );
					valueXmlString.append( "<presc_no><![CDATA[").append(prescNo).append("]]></presc_no>\r\n" ); // Added by AMit D 
					valueXmlString.append( "</Detail"+formNo+">\r\n" );

				}



				num++;
				qty = "0";
				pitch = "";
			}
			rs.close();
			rs = null;
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			if(pStmt1 != null)
			{
				pStmt1.close();
				pStmt1 = null;
			}

			valueXmlString.append( "</Root>\r\n" );
			itemData = valueXmlString.toString();
			//changed by Rahul Barve on 3-sep-2014
			//itemData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			itemData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
			
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return itemData;
	}
	// Amit D End on 16 Sept 13
	
	//Add By Bhushan on 26-10-15 :Start[For MGR Item Pophelp]
	public String getSalesPersMGRItemList( String sprsCode, String strgCode, String selectedItem, String eventDate ) throws ITMException
	{
		System.out.println("In side getSalesPersMGRItemList()....ss.");
		String sql = "";
		String sql1 = "";
		String priceList="";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int domId =1 ;
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		String itemData = "";
		String xslFileName = "";
		
		
		HashMap stockistMap = new HashMap();
		HashMap stockistNameMap = new HashMap();
		boolean isMasterPitchFound = false;
		try
		{
			valueXmlString.append( "<Root>\r\n" );	
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			//added by sachin satre on [14-nov-16] [start]
			connectionObject =getConnection();
			System.out.println("connectionObject"+connectionObject);
			//added by sachin satre on [14-nov-16] [end]

			xslFileName = getXSLFileName( "strg_meet_mgr_item_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			System.out.println("xslFileNamess::::>>"+xslFileName);
			
			System.out.println("sprsCode:ss:"+sprsCode+"strgCodess:"+strgCode+"selectedItemss::"+selectedItem);
				
	//Changed by sachin satre on 22-Aug-2016 for price list [end]
			/* sql =" SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR FROM  ITEM ITEM, STRG_CUSTOMER SC ,PRICELIST  PM "+
					"WHERE ITEM.ITEM_CODE = PM.ITEM_CODE AND SC.STATE_CODE = PM.PRICE_LIST "+
					"AND SC.SC_CODE= ? "+
					"ORDER BY ITEM.SH_DESCR ";
			*/
             /*   sql="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR FROM ITEM ITEM, STRG_CUSTOMER SC ,PRICELIST  PM , STATE STATE " +
              		"WHERE ITEM.ITEM_CODE = PM.ITEM_CODE AND " +
              		"SC.STATE_CODE=STATE.STATE_CODE AND " +
              		"STATE.PRICE_LIST=PM.PRICE_LIST AND" +
              		" SC.SC_CODE= ?  ORDER BY ITEM.DESCR ";
              */
			sql="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR " +
		      		"FROM ITEM ITEM, STRG_CUSTOMER SC ,PRICELIST  PM,SPRS_ITEM SI " +
		      		"WHERE ITEM.ITEM_CODE = PM.ITEM_CODE AND " +
		      		"SI.ITEM_CODE=PM.ITEM_CODE AND " +
		      		"SC.SC_CODE= ? AND SI.SALES_PERS = ? ORDER BY ITEM.DESCR ";
              
    //Changed by sachin satre on 22-Aug-2016 for price list [end]         
			HashMap itemMap = new HashMap();

			if ( selectedItem != null && selectedItem.trim().length() > 0 )
			{
				NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("strg_item");
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();  
					int innerNodeListLen = innerNodeList.getLength();
					String itemCode = "";
					String pitch = "";
					String qty = "";
					String columnValue = "";
					String itemDescr = "";
					for ( int j = 0; j < innerNodeListLen; j++ )       
					{
						Node currNode = innerNodeList.item( j );
						System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");						
						if ( "item_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if("scheme_code".equals( currNode.getNodeName() ))
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = checkNull(currNode.getFirstChild().getNodeValue());
								itemCode = itemCode.trim();
							}
						}
						else if ( "item_descr".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemDescr = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						else if ( "quantity".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								qty = currNode.getFirstChild().getNodeValue().trim();
							}
						}
					}
					System.out.println("itemCodes["+itemCode+"] pitchs["+pitch+"] sqty["+qty+"]" );
					itemMap.put( itemCode, pitch+"~"+qty);	

					System.out.println(" itemMap ["+itemMap+"]");
				}
			}

			String qty = "0";
			String pitch = "";
			int num = 1;
			double value = 0d;
			double rate = 0d;
			
			//if( ! isMasterPitchFound )
			{
				pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, strgCode);
				pstmt.setString(2, sprsCode);
				rs = pstmt.executeQuery();
				while(rs.next()) 
				{
					String itemCode = (checkNull(rs.getString("ITEM_CODE"))).trim();
					System.out.println("itemCode["+itemCode+"]");
					String itemDescr = checkNull(rs.getString("DESCR"));
					String itemShDescr = checkNull(rs.getString("SH_DESCR"));
					
		//Changed by sachin satre on 22-Aug-2016 for price list [start]
					
					System.out.println("stockCode ss= ["+strgCode+"], itemCodess = ["+itemCode+"]");
					priceList = getPriceList(strgCode, connectionObject);
					//rate = getProductRate(priceList, evtDate, itemCode, connectionObject);
					rate = getProductRate( priceList,  itemCode,  0 , "",  eventDate,  connectionObject);
					System.out.println("Chemist ::ss Ratess ==== ["+rate+"],ss priceList = ["+priceList+"]");
					//rate = getLandingRate( strgCode, itemCode, eventDate, sprsCode, connectionObject);
					
		//Changed by sachin satre on 22-Aug-2016 for price list [end]
					
					System.out.println("RATE:::ss==["+rate+"]");
	        		if ( itemMap.get( itemCode.trim() ) != null )
	        		{
	        			String data = ( String ) itemMap.get( itemCode.trim() );
	        			qty = data.substring( data.indexOf("~") + 1 );
	        			valueXmlString.append("<Detail5 domID='"+domId+"' selected = 'Y'>\r\n" );
	        			
	        		}
	        		else
	        		{
	        			valueXmlString.append("<Detail5 domID='"+domId+"' selected = 'N'>\r\n" );
	        		}	
					valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
	    		    valueXmlString.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>\r\n");
	    		 	valueXmlString.append("<item_descr><![CDATA[").append(itemDescr).append("]]></item_descr>\r\n");
	    		 	valueXmlString.append("<tooltip_descr><![CDATA[").append(itemDescr).append("]]></tooltip_descr>\r\n");
	    		 	valueXmlString.append("<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );
	    		 	//valueXmlString.append("<landing_rate><![CDATA[" ).append( landingRate ).append( "]]></landing_rate>\r\n" );
	    		 	valueXmlString.append("<landing_rate><![CDATA[" ).append( rate ).append( "]]></landing_rate>\r\n" );
	    		 	value = Integer.parseInt(qty) * rate;
	    		 	System.out.println("value::::ss==["+value+"]");
	    		 	//value = Integer.parseInt(qty) * landingRate;
	    		 	
	    		 	valueXmlString.append("<value><![CDATA[" ).append(value).append( "]]></value>\r\n" );
					valueXmlString.append("<dcr_id><![CDATA[]]></dcr_id>\r\n");
					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append("<sales_pers><![CDATA[").append(sprsCode).append("]]></sales_pers>\r\n");
					valueXmlString.append("<stockist_code><![CDATA[").append("").append("]]></stockist_code>\r\n");
					valueXmlString.append("<stockist_name><![CDATA[").append("").append("]]></stockist_name>\r\n");
					valueXmlString.append("</Detail5>\r\n" );
					
					domId++;
					qty = "0";
				}
				if(rs != null)
				{
					rs.close(); rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close(); pstmt = null;
				}
			}

			num = 1;
			
			valueXmlString.append( "</Root>\r\n" );

			itemData = valueXmlString.toString();
			
			itemData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :getSalesPersMGRItemList(String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		
		System.out.println( "\n****itemData :" + itemData );
		
		return itemData;
		
	}
	//Add By Bhushan On 26-10-15 [To find itemRate From PriceList table]
	private double getLandingRate(String strgCode, String itemCode, String workDate, String sprsCode, Connection connectionObject) throws Exception 
	{
		System.out.println("Inside getLandingRate()::::::" );
		double rate = 0d;
		String sql = "";
		String stateCode = "";
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		
		try
		{
			System.out.println("strgCode:::>>>>[" + strgCode +"]" );
			sql = "SELECT STATE_CODE FROM STRG_CUSTOMER WHERE SC_CODE= ? ";
			
			pStmt = connectionObject.prepareStatement(sql);
			pStmt.setString(1, strgCode);
			rs = pStmt.executeQuery();
			
			if(rs.next()) 
			{
				stateCode= (checkNull(rs.getString("STATE_CODE"))).trim();
			}
			
			System.out.println("stateCode:::>>>>[" + stateCode +"]");
			DistCommon distComn = new DistCommon();
			rate = distComn.pickRate(stateCode, workDate, itemCode, connectionObject);
			 
			System.out.println("getLandingRate_RATE::>>>>["+itemCode+"] [" + rate +"]");
			
			
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :getLandingRate(String):" + e.getMessage() + ":" );
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				
				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				
			}
			catch(Exception e)
			{
				System.out.println( "Exception getLandingRate(String) :==>\n"+e.getMessage());
			}
		}
		
		return rate;
	}
	//Add By Bhushan on 26-10-15 :End
	
	// Added by sachin satre on 22-aug-2016 for getting price list and product rate [start]
	
	public String getPriceList(String stockCode, Connection conn) throws Exception
	{
		System.out.println("inside getPriceList getPriceList otc:"+stockCode);
		String priceList = "";
		String priceListSql = "";
		String custType ="";
		PreparedStatement pstmtGetPriceList = null;
		PreparedStatement pstmtSfaParm = null;
		ResultSet rsGetPriceList = null;
		ResultSet rsSfaParm = null;
		try
		{
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			
			//String getPriceListSql = " SELECT S.PRICE_LIST FROM STRG_CUSTOMER SC, STATE S WHERE S.STATE_CODE=SC.STATE_CODE AND SC.SC_CODE = ? ";
			String getPriceListSql = "SELECT PRICE_LIST,CUST_TYPE FROM STRG_CUSTOMER  WHERE SC_CODE = ? ";
			pstmtGetPriceList = conn.prepareStatement(getPriceListSql);
			pstmtGetPriceList.setString(1, stockCode);
			rsGetPriceList = pstmtGetPriceList.executeQuery();
			System.out.println("getPriceListSqlss getPriceListSql if:"+getPriceListSql);
			if(rsGetPriceList.next())
			{
				priceList = (rsGetPriceList.getString("PRICE_LIST") == null) ?"" : rsGetPriceList.getString("PRICE_LIST");
				custType = (rsGetPriceList.getString("CUST_TYPE") == null) ?"" : rsGetPriceList.getString("CUST_TYPE");
				System.out.println("priceList priceList if:"+priceList+":custType custTypess:"+custType);
				
			}
			rsGetPriceList.close(); rsGetPriceList = null;
			pstmtGetPriceList.close(); pstmtGetPriceList = null;
			
			if( priceList==null || priceList.trim().length()==0 )
			{
				if(custType.equalsIgnoreCase("D"))
				{
					priceListSql="SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='PTD' AND ? BETWEEN EFF_FROM AND VALID_UPTO AND ACTIVE='Y' ";
				}
				else if(custType.equalsIgnoreCase("C"))
				{
					priceListSql="SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='PTR' AND ? BETWEEN EFF_FROM AND VALID_UPTO AND ACTIVE='Y' ";
				}
				else if(custType.equalsIgnoreCase("S"))
				{
					priceListSql="SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='PTS' AND ? BETWEEN EFF_FROM AND VALID_UPTO AND ACTIVE='Y' ";
				}	
				else if(!custType.equalsIgnoreCase("S") || !custType.equalsIgnoreCase("D") || !custType.equalsIgnoreCase("C"))
				{
					priceListSql="SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='PTO' AND ? BETWEEN EFF_FROM AND VALID_UPTO AND ACTIVE='Y' ";
				}
				System.out.println("BASE_OUT SQL:"+priceListSql);

				pstmtSfaParm =  conn.prepareStatement( priceListSql );
				pstmtSfaParm.setTimestamp(1, java.sql.Timestamp.valueOf(currDate));
				rsSfaParm = pstmtSfaParm.executeQuery();
			    if(rsSfaParm.next())
			    {
			    	priceList=rsSfaParm.getString("PARM_VALUE");
			    	System.out.println("parm_value priceList if:"+priceList);
			    }
			    rsSfaParm.close(); rsSfaParm = null;
			    pstmtSfaParm.close(); pstmtSfaParm = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try
			{
				if(rsGetPriceList != null)
				{
					rsGetPriceList.close(); rsGetPriceList = null;
				}
				if(pstmtGetPriceList != null)
				{
					pstmtGetPriceList.close(); pstmtGetPriceList = null;
				}				
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetOTCGwtWizardComp :getPriceList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("priceLists inotc wizard =["+priceList+"]");
		return priceList;
	}
	
	public double getProductRate( String priceList, String itemCode, double quantity, String unit, String quotDate, Connection conn) throws Exception
	{
		double rateClg = 0d;
		try   
		{
			System.out.println("priceList =["+ priceList +"], itemCode =["+itemCode+"], quantity = ["+quantity+"], unit = ["+unit+"], quotDate =["+quotDate+"]");
			int pricelistCount = 0;
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			String listType = getPriceListType( priceList, conn);

			if(unit == null || unit.trim().length() == 0)
			{
				String unitSql = "SELECT UNIT FROM ITEM WHERE ITEM_CODE = ?";
				PreparedStatement pstmtUnit = conn.prepareStatement(unitSql);
				pstmtUnit.setString(1, itemCode);
				ResultSet rsUnit = pstmtUnit.executeQuery();
				if(rsUnit.next())
				{
					unit = rsUnit.getString("UNIT");
				}
				rsUnit.close(); rsUnit = null;
				pstmtUnit.close(); pstmtUnit = null;
			}
			System.out.println("unit ==["+ unit +"]");

			DistCommon distCommom = new DistCommon();

			String quotDateDb = genericUtility.getValidDateTimeString(quotDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());

			String countSql = " select count(1) as count from pricelist"
					+ " where price_list  = ?"
					+ " and item_code = ?"
					+ " and unit = ?"
					+ " and list_type = ?"
					+ " and eff_from  <= ?"
					+ " and valid_upto  >= ?"
					+ " and min_qty <= ?" 
					+ " and max_qty >= ?"
					+ " and (ref_no is not null) ";	

			PreparedStatement pstmtCount = conn.prepareStatement(countSql);
			pstmtCount.setString(1, priceList);
			pstmtCount.setString(2, itemCode);
			pstmtCount.setString(3, unit);
			pstmtCount.setString(4, listType);
			pstmtCount.setTimestamp(5, java.sql.Timestamp.valueOf(quotDateDb));
			pstmtCount.setTimestamp(6, java.sql.Timestamp.valueOf(quotDateDb));
			pstmtCount.setDouble(7, quantity);
			pstmtCount.setDouble(8, quantity);
			ResultSet rsCount = pstmtCount.executeQuery(); 
			if(rsCount.next())
			{
				pricelistCount = rsCount.getInt("count");
			}
			rsCount.close(); rsCount = null;
			pstmtCount.close(); pstmtCount = null;

			String maxRefNo = "";
			if (pricelistCount >= 1)
			{
				String pricelistSql = "select lot_no__from, lot_no__to from pricelist"
						+ " where price_list   = ? "
						+ " and 	item_code = ? "
						+ " and 	unit  = ? "
						+ " and 	list_type = ? "
						+ " and 	eff_from    <= ? "
						+ " and 	valid_upto  >= ? "
						+ " and 	min_qty <= ? "
						+ " and 	max_qty >= ? "
						+ " and 	(ref_no is not null) "
						+ " and ref_no = ( select max(ref_no) from pricelist "
						+ " where price_list   = ? "
						+ " and 	item_code = ? "
						+ " and 	unit  = ? "
						+ " and 	list_type = ? "
						+ " and 	eff_from    <= ? "
						+ " and 	valid_upto  >= ? "
						+ " and 	min_qty <= ? "
						+ " and 	max_qty >= ? "
						+ " and 	(ref_no is not null) ) ";	
				PreparedStatement pstmtPricelist = conn.prepareStatement(pricelistSql);
				pstmtPricelist.setString(1, priceList);
				pstmtPricelist.setString(2, itemCode);
				pstmtPricelist.setString(3, unit);
				pstmtPricelist.setString(4, listType);
				pstmtPricelist.setTimestamp(5, java.sql.Timestamp.valueOf(quotDateDb));
				pstmtPricelist.setTimestamp(6, java.sql.Timestamp.valueOf(quotDateDb));
				pstmtPricelist.setDouble(7, quantity);
				pstmtPricelist.setDouble(8, quantity);

				pstmtPricelist.setString(9, priceList);
				pstmtPricelist.setString(10, itemCode);
				pstmtPricelist.setString(11, unit);
				pstmtPricelist.setString(12, listType);
				pstmtPricelist.setTimestamp(13, java.sql.Timestamp.valueOf(quotDateDb));
				pstmtPricelist.setTimestamp(14, java.sql.Timestamp.valueOf(quotDateDb));
				pstmtPricelist.setDouble(15, quantity);
				pstmtPricelist.setDouble(16, quantity);

				ResultSet rsPricelist = pstmtPricelist.executeQuery(); 
				if(rsPricelist.next())
				{
					maxRefNo  = (rsPricelist.getString("lot_no__from") == null) ? "" : rsPricelist.getString("lot_no__from");
				}
				System.out.println("maxRefNo =["+ maxRefNo + "]");
				rsPricelist.close(); rsPricelist = null;
				pstmtPricelist.close(); pstmtPricelist = null;

			}
			rateClg = distCommom.pickRate(priceList, quotDate, itemCode, maxRefNo, listType, quantity, conn);
		}
		catch(Exception e)
		{
			throw e;
		}
		System.out.println("rateClg =["+rateClg+"]");
		return rateClg;
	}
	
	private String getPriceListType( String priceList, Connection conn) throws Exception
	{
		String listType = "";
		try
		{
			String getListTypeSql = "SELECT LIST_TYPE FROM PRICELIST WHERE PRICE_LIST = ? ";
			PreparedStatement pstmtGetListType = conn.prepareStatement(getListTypeSql);
			pstmtGetListType.setString(1, priceList);
			ResultSet rsGetListType = pstmtGetListType.executeQuery();
			if(rsGetListType.next())
			{
				listType = (rsGetListType.getString("LIST_TYPE") == null) ?"" : rsGetListType.getString("LIST_TYPE");
			}
			rsGetListType.close(); rsGetListType = null;
			pstmtGetListType.close(); pstmtGetListType = null;

		}
		catch(Exception e)
		{
			throw e;
		}
		return listType;
	}
	
	// Added by sachin satre on 22-aug-2016 for getting price list and product rate [end]
	
	//Added by sachin satre on [14-nov-16] [start] 
	public Connection getConnection()
	{
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{
			System.out.println(" In OtvWizardBean :: getConnection() :: ["+this.userInfo+"]");
			//System.out.println(" In StrgMeetwizardBean :: getConnection() :: ["+this.userInfoBean+"]");
			if(this.userInfo != null)
			{
				String transDB = this.userInfo.getTransDB();
				System.out.println(" OtvWizardBean getConnection :: transDB :: ["+transDB+"]");
				
				if( transDB != null && transDB.trim().length() > 0 && !"null".equalsIgnoreCase(transDB))
				{
					conn = connDriver.getConnectDB(transDB);
					connDriver = null;
					System.out.println(" OtvWizardBean getConnection :: transDB :: on if condition :["+transDB+"]");
				}
				else
				{
					System.out.println(" OtvWizardBean :: transDB is null :: So that creating connection using DriverITM....");					
					conn = connDriver.getConnectDB("DriverITM");
					connDriver = null;
				}
			}
			else
			{
				System.out.println(" OtvWizardBean :: UserInfo is null :: So that creating connection using DriverITM....");
				conn = connDriver.getConnectDB("DriverITM");
				connDriver = null;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : [OtvWizardBean][getConnection] :==>\n"+e.getMessage());
			e.printStackTrace();
			
		}
		return conn;
	}
	//Added by sachin satre on [14-nov-16] [start] 

}