/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.ejb.CommonDBAccessEJB;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class SQLMaker {
    ArrayList tableList = new ArrayList();
    HashMap tableMap = new HashMap();
    ArrayList tableJoinList = new ArrayList();
    ArrayList tableAddedAsMaster = new ArrayList();
    ArrayList columnList = new ArrayList();
    ArrayList joinList = new ArrayList();
    ArrayList whereList = new ArrayList();
    ArrayList groupList = new ArrayList();
    ArrayList orderList = new ArrayList();
    ArrayList havingList = new ArrayList();
    ArrayList argList = new ArrayList();
    String strTable = "";
    String strColumns = "";
    String strJoin = "";
    String strWhere = "";
    String strGroup = "";
    String strArg = "";
    String strOrder = "";
    String strHaving = "";
    String oracle_joins = "";
    String database = "oracle";
    String sqlStr = "";
    String main = "";
    boolean andFlag = false;
    int andCount = 0;
    ArrayList aliasTables = new ArrayList();
    boolean DB2 = false;

    public SQLMaker(String database, UserInfoBean userInfo) {
        if (userInfo != null) {
            CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
            try {
                String dbName = E12GenericUtility.checkNull(commonDBAccessEJB.getDBColumnValue("ENTERPRISE", "DB_NAME", "WHERE ENTERPRISE = '" + userInfo.getEnterprise() + "'", userInfo.getTransDB()));
                if (dbName.length() > 0) {
                    System.out.println("SQLMaker.SQLMaker() DB_NAME AGAINST ENTERPRISE : [" + dbName + "]");
                    database = dbName;
                }
            }
            catch (ITMException e) {
                e.printStackTrace();
            }
        }
        if (database.equalsIgnoreCase("DB2") || database.equalsIgnoreCase("mysql") || database.equalsIgnoreCase("pgsql")) {
            this.DB2 = true;
        }
        this.database = database;
    }

    private void parseSQL(String xmlFileName, boolean isAlassRequired) throws ITMException {
        try {
            DocumentBuilder dbf = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = dbf.parse(xmlFileName);
            NodeList SqlList = document.getElementsByTagName("retrieve");
            if (SqlList.item(0) != null) {
                String strSQL = SqlList.item(0).getFirstChild().getNodeValue();
                System.out.println("SQLMaker.parseSQL() strSQL:[" + strSQL + "]");
                if (strSQL.indexOf("PBSELECT") != -1) {
                    if (strSQL.indexOf("TABLE(") != -1) {
                        this.strTable = strSQL.substring(strSQL.indexOf("TABLE("), strSQL.indexOf(")", strSQL.lastIndexOf("TABLE(")));
                        this.fillTableDetails(this.strTable);
                    }
                    if (strSQL.indexOf("COLUMN") != -1) {
                        this.strColumns = strSQL.indexOf("JOIN") != -1 ? strSQL.substring(strSQL.indexOf(")", strSQL.lastIndexOf("TABLE(")) + 1, strSQL.indexOf("JOIN")) : (strSQL.indexOf("WHERE") != -1 ? strSQL.substring(strSQL.indexOf(")", strSQL.lastIndexOf("TABLE(")) + 1, strSQL.indexOf("WHERE")) : strSQL.substring(strSQL.indexOf("COLUMN"), strSQL.indexOf(")", strSQL.lastIndexOf("COLUMN") + 2)));
                        this.fillColumnsDetails(this.strColumns.trim(), isAlassRequired);
                    }
                    if (strSQL.indexOf("WHERE") != -1) {
                        this.strWhere = strSQL.indexOf("GROUP(") != -1 ? strSQL.substring(strSQL.indexOf("WHERE"), strSQL.indexOf("GROUP(")) : (strSQL.indexOf("HAVING") != -1 ? strSQL.substring(strSQL.indexOf("WHERE"), strSQL.indexOf("HAVING")) : (strSQL.indexOf("ORDER(") != -1 ? strSQL.substring(strSQL.indexOf("WHERE"), strSQL.indexOf("ORDER(")) : (strSQL.indexOf("ARG(") != -1 ? strSQL.substring(strSQL.indexOf("WHERE"), strSQL.indexOf("ARG(")) : strSQL.substring(strSQL.indexOf("WHERE"), strSQL.length()))));
                        BaseLogger.log("3", null, null, "strWhere [" + this.strWhere + "]");
                        this.fillWhereDetails(this.strWhere);
                    }
                    if (strSQL.indexOf("JOIN") != -1) {
                        this.strJoin = strSQL.substring(strSQL.indexOf("JOIN"), strSQL.indexOf(")", strSQL.lastIndexOf("JOIN")));
                        this.fillJoinDetails(this.strJoin);
                    }
                    if (strSQL.indexOf("GROUP(") != -1) {
                        this.strGroup = strSQL.substring(strSQL.indexOf("GROUP("), strSQL.indexOf(")", strSQL.lastIndexOf("GROUP(")));
                        this.fillGroupDetails(this.strGroup);
                    }
                    if (strSQL.indexOf("ORDER(") != -1) {
                        this.strOrder = strSQL.substring(strSQL.indexOf("ORDER("), strSQL.indexOf(")", strSQL.lastIndexOf("ORDER(")));
                        this.fillOrderDetails(this.strOrder);
                    }
                    if (strSQL.indexOf("HAVING") != -1) {
                        this.strHaving = strSQL.indexOf("ARG(") != -1 ? strSQL.substring(strSQL.indexOf("HAVING"), strSQL.indexOf("ARG(")) : strSQL.substring(strSQL.indexOf("HAVING"), strSQL.length());
                        this.fillHavingDetails(this.strHaving);
                    }
                    if (strSQL.indexOf("ARG(") != -1) {
                        this.strArg = strSQL.substring(strSQL.indexOf("ARG("), strSQL.indexOf(")", strSQL.lastIndexOf("ARG(")));
                        this.fillArgDetails(this.strArg);
                    }
                } else {
                    this.sqlStr = strSQL;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :SQLMaker :parseSQL :==>" + e);
            throw new ITMException(e);
        }
    }

    private void fillTableDetails(String strTable) {
        StringTokenizer stkTable = new StringTokenizer(strTable, "(");
        try {
            while (stkTable.hasMoreTokens()) {
                String strEachTable = stkTable.nextToken();
                if (strEachTable.indexOf("NAME") == -1) continue;
                if (strEachTable.indexOf("ALIAS") != -1) {
                    String strAlias = strEachTable.substring(strEachTable.indexOf("\"") + 1, strEachTable.indexOf("ALIAS=") - 2);
                    strAlias = String.valueOf(strAlias) + " " + strEachTable.substring(strEachTable.indexOf("ALIAS=") + 7, strEachTable.lastIndexOf("\""));
                    this.tableList.add(strAlias);
                    String tblName = strEachTable.substring(strEachTable.indexOf("\"") + 1, strEachTable.indexOf("ALIAS=") - 2);
                    String alias = strEachTable.substring(strEachTable.indexOf("ALIAS=") + 7, strEachTable.lastIndexOf("\""));
                    this.tableMap.put(alias, tblName);
                    continue;
                }
                String tableName = strEachTable.substring(strEachTable.indexOf("\"") + 1, strEachTable.lastIndexOf("\""));
                this.tableList.add(String.valueOf(tableName) + "  " + tableName);
                this.tableMap.put(tableName, tableName);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "exception in fillColumnsDetails method: " + e.getMessage());
        }
    }

    private void fillColumnsDetails(String strColumns, boolean isAlassRequired) {
        strColumns = String.valueOf(strColumns) + ")";
        String strEachColumns = null;
        try {
            while (strColumns.length() > 0) {
                int lastIndexColumn = strColumns.indexOf("COLUMN(", "COLUMN(".length());
                int lastIndexCompute = strColumns.indexOf("COMPUTE(", "COMPUTE(".length());
                lastIndexColumn = lastIndexColumn == -1 ? strColumns.length() : lastIndexColumn;
                lastIndexCompute = lastIndexCompute == -1 ? strColumns.length() : lastIndexCompute;
                int lastIndex = lastIndexColumn < lastIndexCompute ? lastIndexColumn : lastIndexCompute;
                strEachColumns = strColumns.substring(0, lastIndex);
                while (strEachColumns.indexOf("~\"") != -1) {
                    StringBuffer strEachColumnsBuff = new StringBuffer(strEachColumns);
                    int idx = strEachColumns.indexOf("~\"");
                    strEachColumnsBuff.replace(idx, idx + 2, "\"");
                    strEachColumns = strEachColumnsBuff.toString();
                }
                if (isAlassRequired) {
                    String columnName = strEachColumns.substring(strEachColumns.indexOf("\"") + 1, strEachColumns.lastIndexOf("\""));
                    if (columnName.indexOf(".") != -1 && !columnName.toUpperCase().startsWith("CASE") && columnName.toUpperCase().indexOf("AS ") == -1) {
                        String[] arr = columnName.split("\\.");
                        String columnStrg = arr[1];
                        String columnAsAlass = String.valueOf(columnStrg) + " AS " + columnStrg.substring(columnStrg.indexOf(".") + 1) + new Random().nextInt(1000);
                        columnName = String.valueOf(arr[0]) + "." + columnAsAlass.toUpperCase();
                    }
                    this.columnList.add(columnName);
                } else {
                    this.columnList.add(strEachColumns.substring(strEachColumns.indexOf("\"") + 1, strEachColumns.lastIndexOf("\"")));
                }
                strColumns = strColumns.substring(lastIndex);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in fillColumnsDetails method: " + e.getMessage());
        }
    }

    private void fillWhereDetails(String strWhere) {
        ArrayList<String> tempList = new ArrayList<String>();
        int index = 0;
        int lastIndex = strWhere.indexOf("WHERE", index);
        String eachWhere = null;
        String tempWhere = null;
        try {
            if (lastIndex == -1) {
                tempList.add(strWhere);
            }
            while (lastIndex != -1) {
                tempWhere = strWhere.substring(index, lastIndex);
                tempList.add(tempWhere);
                if (tempWhere.indexOf("and") != -1) {
                    ++this.andCount;
                }
                if ((lastIndex = strWhere.indexOf("WHERE", index = lastIndex + 1)) != -1) continue;
                tempWhere = strWhere.substring(index, strWhere.length());
                tempList.add(tempWhere);
                if (tempWhere.indexOf("and") == -1) continue;
                ++this.andCount;
            }
            if (this.andCount >= 1) {
                this.andFlag = true;
            }
            boolean count = false;
            int i = 0;
            while (i < tempList.size()) {
                eachWhere = tempList.get(i).toString();
                BaseLogger.log("3", null, null, "\n\neachWhere :\n" + eachWhere + "\n\n");
                if (eachWhere != null) {
                    int startIdx;
                    String strTemp = "";
                    String bindVariable = "";
                    if (eachWhere.indexOf("EXP1") != -1 && eachWhere.indexOf("OP =") != -1) {
                        bindVariable = eachWhere.substring(eachWhere.indexOf("EXP1 =") + 7, eachWhere.indexOf("OP ="));
                        if (bindVariable.startsWith("fn_") || bindVariable.startsWith("FN_") || bindVariable.startsWith("ddf_") || bindVariable.startsWith("DDF_")) {
                            String bindVariableFields;
                            startIdx = bindVariable.indexOf("(");
                            String oldString = bindVariableFields = bindVariable.substring(startIdx + 1, bindVariable.lastIndexOf(")"));
                            String[] bindVariableFieldsArray = bindVariableFields.split(",");
                            int j = 0;
                            while (j < bindVariableFieldsArray.length) {
                                if (bindVariableFieldsArray[j].startsWith(":") || bindVariableFieldsArray[j].startsWith(" :")) {
                                    bindVariableFields = bindVariableFields.replace(bindVariableFieldsArray[j], "?");
                                }
                                ++j;
                            }
                            bindVariable = bindVariable.replace(oldString, bindVariableFields);
                            strTemp = String.valueOf(strTemp) + bindVariable;
                        } else {
                            strTemp = bindVariable.indexOf(":") != -1 ? String.valueOf(strTemp) + " ? " : String.valueOf(strTemp) + bindVariable;
                        }
                    }
                    if (eachWhere.indexOf("OP =") != -1 && eachWhere.indexOf("EXP2") != -1) {
                        strTemp = String.valueOf(strTemp) + eachWhere.substring(eachWhere.indexOf("OP =") + 5, eachWhere.indexOf("EXP2"));
                    }
                    if (eachWhere.indexOf("EXP2") != -1 && eachWhere.indexOf("LOGIC") != -1) {
                        bindVariable = eachWhere.substring(eachWhere.indexOf("EXP2 =") + 7, eachWhere.indexOf("LOGIC"));
                        if (bindVariable.indexOf(":") != -1) {
                            strTemp = String.valueOf(strTemp) + " ? ";
                            int endBraceIdx = bindVariable.indexOf(")");
                            while (endBraceIdx != -1) {
                                strTemp = String.valueOf(strTemp) + ")";
                                endBraceIdx = bindVariable.indexOf(")", endBraceIdx + 1);
                            }
                        } else {
                            strTemp = String.valueOf(strTemp) + bindVariable;
                        }
                    }
                    BaseLogger.log("3", null, null, "DDDDD33333 strTemp [" + strTemp + "]");
                    BaseLogger.log("3", null, null, "DDDDD33333 bindVariable [" + bindVariable + "]");
                    if (eachWhere.indexOf("LOGIC") != -1) {
                        strTemp = String.valueOf(strTemp) + "#~#";
                        strTemp = String.valueOf(strTemp) + eachWhere.substring(eachWhere.indexOf("LOGIC") + 7, eachWhere.lastIndexOf("\""));
                        if (eachWhere.indexOf("and") != -1) {
                            this.andCount -= this.andCount;
                        }
                    } else if (eachWhere.indexOf("EXP2") != -1) {
                        bindVariable = eachWhere.substring(eachWhere.indexOf("EXP2 =") + 7, eachWhere.lastIndexOf("\""));
                        BaseLogger.log("3", null, null, "After EXP2 bindVariable [" + bindVariable + "]");
                        if (bindVariable.indexOf(":") != -1) {
                            StringBuffer bindVarBuff = new StringBuffer();
                            bindVarBuff.append(bindVariable);
                            while (bindVariable.indexOf(":") != -1) {
                                int startIdx2 = bindVariable.indexOf(":");
                                int lastIdx = bindVariable.indexOf(" ", startIdx2) != -1 ? bindVariable.indexOf(" ") : bindVariable.length() - 1;
                                BaseLogger.log("3", null, null, "lastIdx " + lastIdx);
                                if (lastIdx == 0) {
                                    lastIdx = bindVariable.indexOf(" ", startIdx2);
                                }
                                bindVarBuff.replace(startIdx2, lastIdx + 1, " ? ");
                                BaseLogger.log("3", null, null, "bindVarBuff " + bindVarBuff.toString());
                                bindVariable = bindVarBuff.toString();
                            }
                        }
                        strTemp = String.valueOf(strTemp) + bindVariable;
                        startIdx = eachWhere.indexOf(":");
                        if (startIdx == -1) {
                            startIdx = eachWhere.indexOf("'");
                        }
                        if (startIdx != -1) {
                            String endBraceStr = eachWhere.substring(startIdx, eachWhere.lastIndexOf("\""));
                            BaseLogger.log("3", null, null, "endBraceStr [" + endBraceStr + "]");
                            BaseLogger.log("3", null, null, "strTemp [" + strTemp + "]");
                            int endBraceIdx = endBraceStr.indexOf(")");
                            int startBraceCnt = this.charCount(strTemp, '(');
                            int endBraceCnt = this.charCount(endBraceStr, ')');
                            BaseLogger.log("3", null, null, "startBraceCnt [" + startBraceCnt + "]");
                            BaseLogger.log("3", null, null, "endBraceCnt [" + endBraceCnt + "]");
                            if (startBraceCnt != endBraceCnt) {
                                while (endBraceIdx != -1) {
                                    strTemp = String.valueOf(strTemp) + ")";
                                    endBraceIdx = endBraceStr.indexOf(")", endBraceIdx + 1);
                                }
                            }
                        }
                    }
                    strTemp = strTemp.replace('\"', ' ');
                    BaseLogger.log("3", null, null, "\n\nstrTemp 3 [" + strTemp + "]");
                    if (i == tempList.size() - 1 && this.andCount == 0 && this.andFlag && strTemp.indexOf("(") != -1) {
                        this.andFlag = false;
                    }
                    this.whereList.add(strTemp);
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "exception in fillWhereDetails method: " + e.getMessage());
        }
    }

    private void fillJoinDetails(String strJoin) {
        StringTokenizer stkJoin = new StringTokenizer(strJoin, ")");
        try {
            while (stkJoin.hasMoreTokens()) {
                String eachJoin = stkJoin.nextToken();
                if (eachJoin == null || eachJoin.indexOf("JOIN") == -1) continue;
                String tempJoin = eachJoin.substring(eachJoin.indexOf("JOIN (") + 6);
                tempJoin = tempJoin.replace('\"', ' ');
                this.joinList.add(tempJoin);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "exception in fillJoinDetails method: " + e.getMessage());
        }
    }

    private void fillGroupDetails(String strGroup) {
        StringTokenizer stkGroup = new StringTokenizer(strGroup, "=");
        try {
            while (stkGroup.hasMoreTokens()) {
                String strEachGroup = stkGroup.nextToken();
                if (strEachGroup.indexOf("\"") == -1) continue;
                this.groupList.add(strEachGroup.substring(strEachGroup.indexOf("\"") + 1, strEachGroup.lastIndexOf("\"")));
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "exception in fillGroupDetails method: " + e.getMessage());
        }
    }

    private void fillOrderDetails(String strOrder) {
        StringTokenizer stkOrder = new StringTokenizer(strOrder, "(");
        try {
            while (stkOrder.hasMoreTokens()) {
                String eachOrder = stkOrder.nextToken();
                String str = "";
                if (eachOrder.indexOf("=") == -1) continue;
                str = String.valueOf(str) + eachOrder.substring(eachOrder.indexOf("\"") + 1, eachOrder.lastIndexOf("\""));
                boolean flag = eachOrder.substring(eachOrder.lastIndexOf("=") + 1).trim().equalsIgnoreCase("YES");
                BaseLogger.log("3", null, null, "flag>>>>>>> [" + flag + "]");
                str = flag ? String.valueOf(str) + " ASC" : String.valueOf(str) + " DESC";
                this.orderList.add(str);
                BaseLogger.log("3", null, null, "orderList ========>" + this.orderList.toString());
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "exception in fillOrderDetails method: " + e.getMessage());
        }
    }

    private void fillHavingDetails(String strHaving) {
        ArrayList<String> tempList = new ArrayList<String>();
        int index = 0;
        int lastIndex = strHaving.indexOf("HAVING", index + 1);
        try {
            if (lastIndex == -1) {
                tempList.add(strHaving);
            }
            while (lastIndex != -1) {
                String StrTemp = strHaving.substring(index, lastIndex);
                tempList.add(StrTemp);
                index = lastIndex + 1;
                lastIndex = strHaving.indexOf("HAVING", index);
                if (lastIndex != -1) continue;
                tempList.add(strHaving.substring(index, strHaving.length()));
            }
            int i = 0;
            while (i < tempList.size()) {
                if (tempList.get(i) != null) {
                    String str = "";
                    String strTemp = tempList.get(i).toString();
                    str = String.valueOf(str) + "( ";
                    str = String.valueOf(str) + strTemp.substring(strTemp.indexOf("EXP1 =") + 7, strTemp.indexOf("OP =") - 2);
                    str = String.valueOf(str) + strTemp.substring(strTemp.indexOf("OP =") + 5, strTemp.indexOf("EXP2 =") - 2);
                    str = String.valueOf(str) + strTemp.substring(strTemp.indexOf("EXP2 =") + 7, strTemp.indexOf("LOGIC") - 2);
                    str = String.valueOf(str) + " )";
                    String strLogic = strTemp.substring(strTemp.indexOf("LOGIC") + 8, strTemp.lastIndexOf("\""));
                    if (strLogic.length() > 1) {
                        str = String.valueOf(str) + "and\n";
                    }
                    this.havingList.add(str);
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "exception in fillHavingDetails method: " + e.getMessage());
        }
    }

    private void fillArgDetails(String strArg) {
        StringTokenizer stkArg = new StringTokenizer(strArg, ")");
        try {
            while (stkArg.hasMoreTokens()) {
                String strEachArg = stkArg.nextToken();
                if (strEachArg.indexOf("\"") == -1) continue;
                StringBuffer tempArg = new StringBuffer();
                tempArg.append(strEachArg.substring(strEachArg.indexOf("\"") + 1, strEachArg.lastIndexOf("\"")));
                tempArg.append("~");
                tempArg.append(strEachArg.substring(strEachArg.lastIndexOf("=") + 1).trim());
                this.argList.add(tempArg.toString());
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "exception in fillArgDetails method: " + e.getMessage());
        }
    }

    public String makeSQL(String xmlFileName, boolean isAlassRequired) throws ITMException {
        StringBuffer sqlBuffer = new StringBuffer();
        String sqlQry = "";
        try {
            String windowName = xmlFileName.substring(xmlFileName.lastIndexOf(File.separator) + 1, xmlFileName.lastIndexOf(46));
            String dbName = this.database;
            String sqlFileName = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "sql" + File.separator + dbName + File.separator + windowName + ".sql";
            File queryFile = new File(sqlFileName);
            if (queryFile.exists()) {
                sqlQry = this.readFile(sqlFileName);
            } else {
                if (!queryFile.getParentFile().exists()) {
                    queryFile.getParentFile().mkdirs();
                }
                this.parseSQL(xmlFileName, isAlassRequired);
                if (this.sqlStr != null && this.sqlStr.length() > 0) {
                    sqlBuffer.append(this.sqlStr);
                } else {
                    sqlBuffer.append(this.makeSelect());
                    if (!this.DB2) {
                        sqlBuffer.append(this.makeFrom());
                    } else {
                        sqlBuffer.append(this.makeFromANSI());
                    }
                    sqlBuffer.append(this.makeWhere());
                    sqlBuffer.append(this.makeGroup());
                    sqlBuffer.append(this.makeOrder());
                    sqlBuffer.append(this.makeHaving());
                    if (this.database.equalsIgnoreCase("pgsql")) {
                        String tempStr = sqlBuffer.toString();
                        tempStr = tempStr.replace("\"", "");
                        sqlBuffer = new StringBuffer();
                        sqlBuffer.append(tempStr);
                    }
                }
                FileWriter sqlWriter = new FileWriter(sqlFileName);
                sqlWriter.write(sqlBuffer.toString());
                sqlWriter.close();
                sqlQry = this.readFile(sqlFileName);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : SQLMaker : readFile :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return sqlQry;
    }

    private String readFile(String file) throws ITMException {
        String sqlQry = "";
        BufferedReader br = null;
        try {
            try {
                FileInputStream fin = new FileInputStream(file);
                br = new BufferedReader(new InputStreamReader(fin));
                String tempStr = "";
                while ((tempStr = br.readLine()) != null) {
                    sqlQry = String.valueOf(sqlQry) + tempStr;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : SQLMaker : readFile :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                    br = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in releasing file resource :");
                e.printStackTrace();
            }
        }
        return sqlQry;
    }

    private String makeSelect() {
        StringBuffer sbSelect = new StringBuffer("SELECT ");
        int i = 0;
        while (i < this.columnList.size()) {
            if (this.columnList.get(i) != null) {
                sbSelect.append(this.columnList.get(i));
                if (i != this.columnList.size() - 1) {
                    sbSelect.append(",");
                }
            }
            ++i;
        }
        return String.valueOf(sbSelect.toString()) + "\n";
    }

    private String makeFrom() {
        String str = "";
        String strFrom = "";
        StringBuffer sbFrom = new StringBuffer();
        String strJoins = this.makeJoin();
        ArrayList tempColumns = new ArrayList();
        StringBuffer sbFrom_oracle = new StringBuffer();
        ArrayList tableNames = new ArrayList();
        int i = 0;
        while (i < this.tableList.size()) {
            if (this.tableList.get(i) != null) {
                sbFrom_oracle.append(this.tableList.get(i));
                if (i != this.tableList.size() - 1) {
                    sbFrom_oracle.append(",");
                }
                tableNames.add(this.tableList.get(i));
                boolean flag = false;
                int j = 0;
                while (j < this.tableJoinList.size()) {
                    if (this.tableJoinList.get(j) != null && this.tableList.get(i).equals(this.tableJoinList.get(j))) {
                        flag = true;
                    }
                    ++j;
                }
                if (!flag) {
                    String tempTableString = "";
                    boolean addFlag = false;
                    int count = 0;
                    while (count < this.aliasTables.size()) {
                        tempTableString = this.tableList.get(i).toString();
                        String tableName = tempTableString.substring(0, tempTableString.indexOf(" "));
                        boolean isAdded = this.tableAddedAsMaster.contains(tableName);
                        if (tempTableString.indexOf(this.aliasTables.get(count).toString()) != -1 || tempTableString.indexOf(this.main) != -1 || isAdded) {
                            addFlag = true;
                        }
                        ++count;
                    }
                    if (!addFlag) {
                        tempColumns.add(this.tableList.get(i));
                    }
                }
            }
            ++i;
        }
        int k = 0;
        while (k < tempColumns.size()) {
            if (tempColumns.get(k) != null && strJoins.indexOf(tempColumns.get(k).toString()) == -1) {
                sbFrom.append(tempColumns.get(k));
                if (k != tempColumns.size() - 1) {
                    sbFrom.append(",");
                }
            }
            ++k;
        }
        str = !this.DB2 ? String.valueOf(str) + " FROM " + sbFrom_oracle.toString() + "\n" : (strJoins.length() > 0 && sbFrom.length() > 0 ? String.valueOf(str) + " FROM " + strJoins + "," + sbFrom.toString() + "\n" : (strJoins.length() > 0 && sbFrom.length() < 1 ? String.valueOf(str) + " FROM " + strJoins + "\n" : String.valueOf(str) + " FROM " + sbFrom.toString() + "\n"));
        BaseLogger.log("2", null, null, "str [" + str + "]");
        return str;
    }

    private String makeWhere() {
        String str = "";
        String strInnerJoin = "";
        StringBuffer sb = new StringBuffer();
        StringBuffer sbInnerJoin = new StringBuffer();
        boolean checkAnd = true;
        int i = 0;
        while (i < this.whereList.size()) {
            if (this.whereList.get(i) != null) {
                String strLogic = null;
                String temp = this.whereList.get(i).toString();
                if (temp.indexOf("#~#") != -1) {
                    sb.append(temp.substring(0, temp.indexOf("#~#")));
                    strLogic = temp.substring(temp.indexOf("#~#") + 3, temp.length());
                } else if (temp.toLowerCase().indexOf(" in ") != -1) {
                    String inStr = new String(temp);
                    int indexOfIn = temp.indexOf(" in ");
                    inStr = inStr.substring(0, indexOfIn + 3);
                    inStr = String.valueOf(inStr) + '(';
                    inStr = String.valueOf(inStr) + temp.substring(indexOfIn + 3);
                    inStr = String.valueOf(inStr) + ')';
                    sb.append(inStr);
                } else {
                    sb.append(temp);
                }
                if (strLogic != null) {
                    sb.append(" " + strLogic + " ");
                    sb.append("\n");
                }
            }
            ++i;
        }
        int j = 0;
        while (j < this.joinList.size()) {
            String temp;
            checkAnd = true;
            if (this.joinList.get(j) != null && (temp = this.joinList.get(j).toString()).indexOf("OUTER") == -1) {
                sbInnerJoin.append("( ");
                sbInnerJoin.append(temp.substring(temp.indexOf("LEFT") + 6, temp.indexOf("OP")));
                sbInnerJoin.append(temp.substring(temp.indexOf("OP =") + 4, temp.indexOf("RIGHT")));
                sbInnerJoin.append(temp.substring(temp.indexOf("RIGHT=") + 7));
                sbInnerJoin.append(" )");
                if (j != this.joinList.size() - 1) {
                    sbInnerJoin.append(" AND ");
                    sbInnerJoin.append("\n");
                    checkAnd = false;
                }
            }
            ++j;
        }
        if (this.oracle_joins.length() > 0) {
            if (sbInnerJoin.length() > 0 && checkAnd) {
                sbInnerJoin.append(" AND \n");
            }
            sbInnerJoin.append(this.oracle_joins);
        }
        if (sbInnerJoin.length() > 0 && sb.length() > 0) {
            str = " WHERE " + sbInnerJoin.toString() + "\n" + " AND " + sb.toString() + "\n";
        } else if (sbInnerJoin.length() > 0 && sb.length() < 1) {
            str = " WHERE " + sbInnerJoin.toString() + "\n";
        } else if (sb.length() > 0) {
            str = " WHERE " + sb.toString() + "\n";
        }
        if (str.indexOf("~") != -1) {
            str = str.replace('~', ' ');
        }
        return str;
    }

    private String makeJoin() {
        ArrayList<String> left = new ArrayList<String>();
        ArrayList<String> right = new ArrayList<String>();
        ArrayList<String> operator = new ArrayList<String>();
        ArrayList<String> outer = new ArrayList<String>();
        ArrayList<String> mainTable = new ArrayList<String>();
        ArrayList<String> joinType = new ArrayList<String>();
        int max = 0;
        String str = "";
        this.oracle_joins = "";
        String newTableName = "";
        String aliasTableName = "";
        try {
            int i = 0;
            while (i < this.joinList.size()) {
                String temp;
                if (this.joinList.get(i) != null && (temp = this.joinList.get(i).toString()).indexOf("OUTER") != -1) {
                    left.add(temp.substring(temp.indexOf("LEFT") + 6, temp.indexOf("OP")).trim());
                    operator.add(temp.substring(temp.indexOf("OP =") + 4, temp.indexOf("RIGHT")).trim());
                    right.add(temp.substring(temp.indexOf("RIGHT") + 6, temp.indexOf("OUTER")).trim());
                    outer.add(temp.substring(temp.indexOf("OUTER") + 9, temp.length()).trim());
                    mainTable.add(temp.substring(temp.indexOf("OUTER") + 9, temp.lastIndexOf(".")).trim());
                    joinType.add(temp.substring(temp.indexOf("OUTER"), temp.lastIndexOf("=")).trim());
                }
                ++i;
            }
            int j = 0;
            while (j < mainTable.size()) {
                int count = 0;
                if (mainTable.get(j) != null) {
                    String temp = mainTable.get(j).toString();
                    int k = 0;
                    while (k < mainTable.size()) {
                        if (temp.equals(mainTable.get(k))) {
                            ++count;
                        }
                        ++k;
                    }
                    if (count > max) {
                        max = count;
                        this.main = mainTable.get(j).toString();
                    }
                }
                ++j;
            }
            this.tableJoinList.add(this.main);
            boolean sameTables = false;
            boolean firstColumn = true;
            String curLeft = null;
            String curRight = null;
            String nextLeft = null;
            String nextRight = null;
            int ctr = 0;
            while (ctr < outer.size()) {
                String tempTable = "";
                String temp = "";
                String outerType = joinType.get(ctr).toString();
                String master = mainTable.get(ctr).toString();
                if (left.get(ctr).toString().indexOf(master) == -1) {
                    temp = left.get(ctr).toString();
                    tempTable = temp.substring(0, temp.indexOf("."));
                    this.tableJoinList.add(tempTable);
                } else if (right.get(ctr).toString().indexOf(master) == -1) {
                    temp = right.get(ctr).toString();
                    tempTable = temp.substring(0, temp.indexOf("."));
                    this.tableJoinList.add(tempTable);
                }
                int tableCnt = 0;
                while (tableCnt < this.tableList.size()) {
                    String tableString = (String)this.tableList.get(tableCnt);
                    int tokenCount = 0;
                    tableString.trim();
                    if (tableString.indexOf(" ") != -1) {
                        StringTokenizer st = new StringTokenizer(tableString, " ");
                        while (st.hasMoreTokens()) {
                            ++tokenCount;
                            st.nextToken();
                        }
                    }
                    if (tableString.indexOf(tempTable) != -1 && tokenCount == 2) {
                        newTableName = tableString.substring(0, tableString.indexOf(" "));
                        newTableName = (String)this.tableMap.get(tempTable);
                        aliasTableName = tableString.substring(tableString.indexOf(" "), tableString.length());
                        aliasTableName = tempTable;
                        this.aliasTables.add(aliasTableName);
                    }
                    ++tableCnt;
                }
                if (!this.DB2) {
                    this.oracle_joins = outerType.equals("OUTER1") ? String.valueOf(this.oracle_joins) + "( " + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + "(+))" : String.valueOf(this.oracle_joins) + "( " + left.get(ctr).toString() + "(+) " + operator.get(ctr).toString() + right.get(ctr).toString() + " ) ";
                    this.oracle_joins = ctr != outer.size() - 1 ? String.valueOf(this.oracle_joins) + " AND \n" : String.valueOf(this.oracle_joins) + "\n";
                } else {
                    if (outerType.equals("OUTER1")) {
                        if ("".equalsIgnoreCase(newTableName)) {
                            if (!sameTables || sameTables && firstColumn) {
                                if (tempTable.equals("") || tempTable.equals(" ")) {
                                    str = String.valueOf(str) + " LEFT OUTER JOIN " + right.get(ctr).toString().substring(0, right.get(ctr).toString().indexOf(".")) + " ON (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " ";
                                    curLeft = left.get(ctr).toString().substring(0, left.get(ctr).toString().indexOf("."));
                                    curRight = right.get(ctr).toString().substring(0, right.get(ctr).toString().indexOf("."));
                                } else {
                                    str = String.valueOf(str) + " LEFT OUTER JOIN " + tempTable + " ON (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " ";
                                    curLeft = left.get(ctr).toString().substring(0, left.get(ctr).toString().indexOf("."));
                                    curRight = tempTable;
                                }
                            } else if (sameTables && !firstColumn) {
                                if (tempTable.equals("") || tempTable.equals(" ")) {
                                    str = String.valueOf(str) + " AND " + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " ";
                                    curLeft = left.get(ctr).toString().substring(0, left.get(ctr).toString().indexOf("."));
                                    curRight = right.get(ctr).toString().substring(0, right.get(ctr).toString().indexOf("."));
                                } else {
                                    str = String.valueOf(str) + " AND " + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " ";
                                    curLeft = left.get(ctr).toString().substring(0, left.get(ctr).toString().indexOf("."));
                                    curRight = right.get(ctr).toString().substring(0, right.get(ctr).toString().indexOf("."));
                                }
                            }
                        } else {
                            if (str.length() > 0 && str.indexOf(" " + master + " ") == -1 && !this.main.trim().equalsIgnoreCase(master)) {
                                str = String.valueOf(str) + ", " + master + " ";
                                this.tableAddedAsMaster.add(master);
                            }
                            if (!sameTables || sameTables && firstColumn) {
                                curLeft = left.get(ctr).toString().substring(0, left.get(ctr).toString().indexOf("."));
                                curRight = newTableName == null || newTableName.trim().length() == 0 ? right.get(ctr).toString().substring(0, right.get(ctr).toString().indexOf(".")) : newTableName;
                                str = String.valueOf(str) + " LEFT OUTER JOIN " + curRight + "  " + aliasTableName + " ON (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " ";
                            } else if (sameTables && !firstColumn) {
                                str = String.valueOf(str) + " AND " + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " ";
                                curLeft = left.get(ctr).toString().substring(0, left.get(ctr).toString().indexOf("."));
                                curRight = right.get(ctr).toString().substring(0, right.get(ctr).toString().indexOf("."));
                            }
                        }
                    } else if (newTableName.equalsIgnoreCase("")) {
                        if (!sameTables || sameTables && firstColumn) {
                            if (tempTable.equals("") || tempTable.equals(" ")) {
                                str = String.valueOf(str) + " RIGHT OUTER JOIN " + right.get(ctr).toString().substring(0, right.get(ctr).toString().indexOf(".")) + " ON (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " ";
                                curLeft = left.get(ctr).toString().substring(0, left.get(ctr).toString().indexOf("."));
                                curRight = right.get(ctr).toString().substring(0, right.get(ctr).toString().indexOf("."));
                            } else {
                                str = String.valueOf(str) + " RIGHT OUTER JOIN " + tempTable + " ON (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " ";
                                curLeft = left.get(ctr).toString().substring(0, left.get(ctr).toString().indexOf("."));
                                curRight = tempTable;
                            }
                        }
                    } else {
                        str = String.valueOf(str) + " RIGHT OUTER JOIN " + newTableName + " ON (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " ";
                        curLeft = left.get(ctr).toString().substring(0, left.get(ctr).toString().indexOf("."));
                        curRight = newTableName;
                    }
                    if (ctr >= outer.size() - 1) {
                        sameTables = false;
                        firstColumn = true;
                        str = String.valueOf(str) + " )";
                    } else {
                        nextLeft = left.get(ctr + 1).toString().substring(0, left.get(ctr + 1).toString().indexOf("."));
                        nextRight = right.get(ctr + 1).toString().substring(0, right.get(ctr + 1).toString().indexOf("."));
                        if (curLeft.trim().equalsIgnoreCase(nextLeft.trim()) && curRight.trim().equalsIgnoreCase(nextRight.trim())) {
                            sameTables = true;
                            firstColumn = false;
                        } else {
                            sameTables = false;
                            firstColumn = true;
                            str = String.valueOf(str) + " )";
                        }
                    }
                    str = String.valueOf(str) + "\n";
                }
                ++ctr;
            }
            if (str.length() > 0) {
                str = !this.DB2 ? "" : String.valueOf(this.main) + str;
            }
            return str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return str;
        }
    }

    private String makeJoinOld() {
        String temp;
        ArrayList<String> left = new ArrayList<String>();
        ArrayList<String> right = new ArrayList<String>();
        ArrayList<String> operator = new ArrayList<String>();
        ArrayList<String> outer = new ArrayList<String>();
        ArrayList<String> mainTable = new ArrayList<String>();
        ArrayList<String> joinType = new ArrayList<String>();
        int max = 0;
        String str = "";
        this.oracle_joins = "";
        String newTableName = "";
        String aliasTableName = "";
        int i = 0;
        while (i < this.joinList.size()) {
            String temp2;
            if (this.joinList.get(i) != null && (temp2 = this.joinList.get(i).toString()).indexOf("OUTER") != -1) {
                left.add(temp2.substring(temp2.indexOf("LEFT") + 6, temp2.indexOf("OP")).trim());
                operator.add(temp2.substring(temp2.indexOf("OP =") + 4, temp2.indexOf("RIGHT")).trim());
                right.add(temp2.substring(temp2.indexOf("RIGHT") + 6, temp2.indexOf("OUTER")).trim());
                outer.add(temp2.substring(temp2.indexOf("OUTER") + 9, temp2.length()).trim());
                mainTable.add(temp2.substring(temp2.indexOf("OUTER") + 9, temp2.lastIndexOf(".")).trim());
                joinType.add(temp2.substring(temp2.indexOf("OUTER"), temp2.lastIndexOf("=")).trim());
            }
            ++i;
        }
        int j = 0;
        while (j < mainTable.size()) {
            int count = 0;
            if (mainTable.get(j) != null) {
                temp = mainTable.get(j).toString();
                int k = 0;
                while (k < mainTable.size()) {
                    if (temp.equals(mainTable.get(k))) {
                        ++count;
                    }
                    ++k;
                }
                if (count > max) {
                    max = count;
                    this.main = mainTable.get(j).toString();
                }
            }
            ++j;
        }
        this.tableJoinList.add(this.main);
        int ctr = 0;
        while (ctr < outer.size()) {
            String tempTable = "";
            temp = "";
            String outerType = joinType.get(ctr).toString();
            String master = mainTable.get(ctr).toString();
            if (left.get(ctr).toString().indexOf(master) == -1) {
                temp = left.get(ctr).toString();
                tempTable = temp.substring(0, temp.indexOf("."));
                this.tableJoinList.add(tempTable);
            } else if (right.get(ctr).toString().indexOf(master) == -1) {
                temp = right.get(ctr).toString();
                tempTable = temp.substring(0, temp.indexOf("."));
                this.tableJoinList.add(tempTable);
            }
            int tableCnt = 0;
            while (tableCnt < this.tableList.size()) {
                String tableString = (String)this.tableList.get(tableCnt);
                int tokenCount = 0;
                tableString.trim();
                if (tableString.indexOf(" ") != -1) {
                    StringTokenizer st = new StringTokenizer(tableString, " ");
                    while (st.hasMoreTokens()) {
                        ++tokenCount;
                        st.nextToken();
                    }
                }
                if (tableString.indexOf(tempTable) != -1 && tokenCount == 2) {
                    newTableName = tableString.substring(0, tableString.indexOf(" "));
                    newTableName = (String)this.tableMap.get(tempTable);
                    aliasTableName = tableString.substring(tableString.indexOf(" "), tableString.length());
                    aliasTableName = tempTable;
                    this.aliasTables.add(aliasTableName);
                }
                ++tableCnt;
            }
            if (!this.DB2) {
                this.oracle_joins = outerType.equals("OUTER1") ? String.valueOf(this.oracle_joins) + "( " + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + "(+))" : String.valueOf(this.oracle_joins) + "( " + left.get(ctr).toString() + "(+) " + operator.get(ctr).toString() + right.get(ctr).toString() + " ) ";
                this.oracle_joins = ctr != outer.size() - 1 ? String.valueOf(this.oracle_joins) + " AND \n" : String.valueOf(this.oracle_joins) + "\n";
            } else {
                if (outerType.equals("OUTER1")) {
                    if (newTableName.equalsIgnoreCase("")) {
                        str = tempTable.equals("") || tempTable.equals(" ") ? String.valueOf(str) + " LEFT OUTER JOIN " + right.get(ctr).toString().substring(0, right.get(ctr).toString().indexOf(".")) + " ON (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " )" : String.valueOf(str) + " LEFT OUTER JOIN " + tempTable + " ON (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " )";
                    } else {
                        if (str.length() > 0 && str.indexOf(" " + master + " ") == -1 && !this.main.trim().equalsIgnoreCase(master)) {
                            str = String.valueOf(str) + ", " + master + " ";
                            this.tableAddedAsMaster.add(master);
                        }
                        str = String.valueOf(str) + " LEFT OUTER JOIN " + newTableName + "  " + aliasTableName + " ON (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " )";
                    }
                } else {
                    str = newTableName.equalsIgnoreCase("") ? (tempTable.equals("") || tempTable.equals(" ") ? String.valueOf(str) + " RIGHT OUTER JOIN " + right.get(ctr).toString().substring(0, right.get(ctr).toString().indexOf(".")) + " ON (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " )" : String.valueOf(str) + " RIGHT OUTER JOIN " + tempTable + " ON (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " )") : String.valueOf(str) + " RIGHT OUTER JOIN " + newTableName + " ON (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " )";
                }
                str = String.valueOf(str) + "\n";
            }
            ++ctr;
        }
        if (str.length() > 0) {
            str = !this.DB2 ? "" : String.valueOf(this.main) + str;
        }
        return str;
    }

    private String makeGroup() {
        StringBuffer sb = new StringBuffer();
        String str = "";
        int i = 0;
        while (i < this.groupList.size()) {
            if (this.groupList.get(i) != "") {
                sb.append(this.groupList.get(i));
                if (i != this.groupList.size() - 1) {
                    sb.append(",");
                    sb.append("\n");
                }
            }
            ++i;
        }
        if (sb.length() > 0) {
            str = " GROUP BY " + sb.toString() + "\n";
        }
        return str;
    }

    private String makeOrder() {
        String str = "";
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.orderList.size()) {
            if (this.orderList.get(i) != "") {
                sb.append(this.orderList.get(i).toString());
                if (i != this.orderList.size() - 1) {
                    sb.append(",");
                }
                sb.append("\n");
            }
            ++i;
        }
        if (sb.length() > 0) {
            str = " ORDER BY " + sb.toString() + "\n";
        }
        return str;
    }

    private String makeHaving() {
        String str = "";
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.havingList.size()) {
            sb.append(this.havingList.get(i));
            if (i != this.havingList.size() - 1) {
                sb.append(",");
            }
            sb.append("\n");
            ++i;
        }
        if (sb.length() > 0) {
            str = " HAVING " + sb.toString() + "\n";
        }
        return str;
    }

    private int charCount(String targetStr, char findChar) {
        int count = 0;
        try {
            int idx = targetStr.indexOf(findChar);
            while (idx != -1) {
                ++count;
                idx = targetStr.indexOf(findChar, idx + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public ArrayList getTableList(String filename) {
        try {
            this.parseSQL(filename, false);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : SQLMaker : getTableList :==>" + e.getMessage());
        }
        BaseLogger.log("2", null, null, "SQLMaker tableList[" + this.tableList + "]");
        return this.tableList;
    }

    public HashMap<String, String> getComputeColumns(String filename) {
        HashMap<String, String> computColumns = new HashMap<String, String>();
        int computeColvalueIndex = 0;
        try {
            this.parseSQL(filename, false);
            BaseLogger.log("3", null, null, "columnList ::" + this.columnList);
            int cl = 0;
            while (cl < this.columnList.size()) {
                String computeColvalue = (String)this.columnList.get(cl);
                BaseLogger.log("3", null, null, "computeColvalue[" + computeColvalue + "]");
                if (computeColvalue.toUpperCase().indexOf("CASE") == -1 && computeColvalue.toUpperCase().indexOf("NVL(") == -1) {
                    String COMPUTE_COL = "";
                    if (computeColvalue.toUpperCase().indexOf("SELECT ") != -1) {
                        BaseLogger.log("3", null, null, "computeColvalue [SELECT SUB QUERY]>>>>>[" + computeColvalue + "]");
                    } else {
                        if (computeColvalue.toUpperCase().indexOf(" AS ") != -1) {
                            COMPUTE_COL = computeColvalue.substring(computeColvalue.toUpperCase().indexOf(" AS ") + 4, computeColvalue.lastIndexOf("")).replace(" ", "");
                            BaseLogger.log("3", null, null, "COMPUTE_COL [IF]>>>>>[" + COMPUTE_COL + "]");
                            computeColvalueIndex = computeColvalue.toUpperCase().indexOf(" AS ");
                            computeColvalue = computeColvalue.substring(0, computeColvalueIndex);
                            BaseLogger.log("3", null, null, "computeColvalue [IF]>>>>>[" + computeColvalue + "]");
                        } else if (computeColvalue.indexOf(")") != -1) {
                            COMPUTE_COL = computeColvalue.substring(computeColvalue.lastIndexOf(")") + 1, computeColvalue.lastIndexOf("")).replace(" ", "");
                            BaseLogger.log("3", null, null, "COMPUTE_COL [ELSE IF] = [" + COMPUTE_COL + "]");
                            computeColvalueIndex = computeColvalue.indexOf(")");
                            computeColvalue = computeColvalue.substring(0, computeColvalueIndex);
                            BaseLogger.log("3", null, null, "computeColvalue [ELSE IF] = [" + computeColvalue + "]");
                        }
                        computeColvalue = computeColvalue.replace(" ", "");
                        if (computeColvalue.indexOf("||''||") != -1) {
                            computeColvalue = computeColvalue.replace("||''||", "~COLSEP~");
                        }
                        if (computeColvalue.indexOf("||") != -1) {
                            computeColvalue = computeColvalue.replace("||", "~COLSEP~");
                        }
                        if (computeColvalue.indexOf("(") != -1) {
                            computeColvalue = computeColvalue.replace("(", "");
                        }
                        if (computeColvalue.indexOf(")") != -1) {
                            computeColvalue = computeColvalue.replace(")", "");
                        }
                        if (computeColvalue.toUpperCase().indexOf("RTRIM") != -1) {
                            computeColvalue = computeColvalue.toUpperCase().replace("RTRIM", "");
                        }
                        if (computeColvalue.toUpperCase().indexOf("LTRIM") != -1) {
                            computeColvalue = computeColvalue.toUpperCase().replace("LTRIM", "");
                        }
                        computeColvalue = computeColvalue.replaceAll("\"", "");
                        BaseLogger.log("3", null, null, "\n\n@@@@@@@@@computeColvalue---" + computeColvalue + "\n\n");
                        if (COMPUTE_COL != null && COMPUTE_COL.trim().length() > 0) {
                            if (COMPUTE_COL.indexOf("\"") != -1) {
                                int indexFirst = COMPUTE_COL.indexOf("\"");
                                int indexLast = COMPUTE_COL.lastIndexOf("\"");
                                COMPUTE_COL = COMPUTE_COL.substring(indexFirst + 1, indexLast);
                            }
                            computColumns.put(this.checkNull(COMPUTE_COL).toLowerCase(), this.checkNull(computeColvalue));
                        }
                    }
                }
                ++cl;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : SQLMaker : getComputeColumns :==>" + e.getMessage());
        }
        BaseLogger.log("2", null, null, "SQLMaker computColumnsMap[" + computColumns.toString() + "]");
        return computColumns;
    }

    private String checkNull(String value) {
        value = value == null || value.trim().length() == 0 ? "" : value.trim();
        return value;
    }

    private String makeFromANSI() {
        String str = "";
        String strFrom = "";
        StringBuffer sbFrom = new StringBuffer();
        String strJoins = this.makeJoinANSI();
        BaseLogger.log("3", null, null, "SQLMaker.makeFrom() strJoins : [ " + strJoins + "]");
        ArrayList tempColumns = new ArrayList();
        StringBuffer sbFrom_oracle = new StringBuffer();
        ArrayList tableNames = new ArrayList();
        BaseLogger.log("3", null, null, "SQLMaker.makeFrom() tableList : [" + this.tableList.toString() + "]");
        BaseLogger.log("3", null, null, "SQLMaker.makeFrom() tableJoinList : [" + this.tableJoinList.toString() + "]");
        BaseLogger.log("3", null, null, "SQLMaker.makeFrom() aliasTables : [" + this.aliasTables.toString() + "]");
        BaseLogger.log("3", null, null, "SQLMaker.makeFrom() tableAddedAsMaster : [" + this.tableAddedAsMaster.toString() + "]");
        int i = 0;
        while (i < this.tableList.size()) {
            BaseLogger.log("3", null, null, "SQLMaker.makeFrom() tableList.get( i ).toString() : [" + this.tableList.get(i).toString() + "]");
            if (this.tableList.get(i) != null) {
                sbFrom_oracle.append(this.tableList.get(i));
                if (i != this.tableList.size() - 1) {
                    sbFrom_oracle.append(",");
                }
                tableNames.add(this.tableList.get(i));
                boolean flag = false;
                int j = 0;
                while (j < this.tableJoinList.size()) {
                    BaseLogger.log("3", null, null, "SQLMaker.makeFrom() tableJoinList.get( j ).toString() : [" + this.tableJoinList.get(j).toString() + "]");
                    if (this.tableJoinList.get(j) != null && this.tableList.get(i).equals(this.tableJoinList.get(j))) {
                        flag = true;
                    }
                    ++j;
                }
                if (!flag) {
                    String tempTableString = "";
                    boolean addFlag = false;
                    int count = 0;
                    while (count < this.aliasTables.size()) {
                        tempTableString = this.tableList.get(i).toString();
                        String tableName = tempTableString.substring(0, tempTableString.indexOf(" "));
                        boolean isAdded = this.tableAddedAsMaster.contains(tableName);
                        BaseLogger.log("3", null, null, "  **** 001.Start **** ");
                        BaseLogger.log("3", null, null, "SQLMaker.makeFrom() tempTableString : [" + tempTableString.toString() + "]");
                        BaseLogger.log("3", null, null, "SQLMaker.makeFrom() aliasTables.get( count ).toString() : [" + this.aliasTables.get(count).toString() + "]");
                        BaseLogger.log("3", null, null, "SQLMaker.makeFrom() tempTableString.indexOf( main ) : [" + tempTableString.indexOf(this.main) + "]");
                        BaseLogger.log("3", null, null, "SQLMaker.makeFrom() isAdded : [" + isAdded + "]");
                        BaseLogger.log("3", null, null, "SQLMaker.makeFrom() tempTableString.indexOf( aliasTables.get( count ).toString() ) : [" + tempTableString.indexOf(this.aliasTables.get(count).toString()) + "]");
                        BaseLogger.log("3", null, null, "  **** 001.End **** ");
                        String[] tempTableList = tempTableString.split(" ");
                        boolean aliasTableIntempTableList = false;
                        if (this.aliasTables.get(count) != null && this.aliasTables.get(count).toString().trim().length() > 0) {
                            int e1 = 0;
                            while (e1 < tempTableList.length) {
                                if (tempTableList[e1] != null && tempTableList[e1].trim().length() > 0) {
                                    tempTableList[e1] = tempTableList[e1].trim();
                                    if (this.aliasTables.get(count).toString().equalsIgnoreCase(tempTableList[e1])) {
                                        aliasTableIntempTableList = true;
                                    }
                                }
                                ++e1;
                            }
                        }
                        if (aliasTableIntempTableList || tempTableString.indexOf(String.valueOf(this.main.trim()) + " ") != -1 || tempTableString.trim().equalsIgnoreCase(this.main.trim()) || isAdded) {
                            addFlag = true;
                            BaseLogger.log("3", null, null, "  **** 002.Start **** ");
                            BaseLogger.log("3", null, null, "SQLMaker.makeFrom() tempTableString : [" + tempTableString.toString() + "]");
                            BaseLogger.log("3", null, null, "SQLMaker.makeFrom() aliasTables.get( count ).toString() : [" + this.aliasTables.get(count).toString() + "]");
                            BaseLogger.log("3", null, null, "SQLMaker.makeFrom() tempTableString.indexOf( main ) : [" + tempTableString.indexOf(this.main) + "]");
                            BaseLogger.log("3", null, null, "SQLMaker.makeFrom() addFlag (setting true) : [" + addFlag + "]");
                            BaseLogger.log("3", null, null, "SQLMaker.makeFrom() tableList.get( i ).toString() : [" + this.tableList.get(i).toString() + "]");
                            BaseLogger.log("3", null, null, "  **** 002.End **** ");
                        }
                        ++count;
                    }
                    if (!addFlag) {
                        tempColumns.add(this.tableList.get(i));
                    }
                }
            }
            ++i;
        }
        BaseLogger.log("3", null, null, "SQLMaker.makeFrom() tempColumns : [" + tempColumns.toString() + "]");
        int k = 0;
        while (k < tempColumns.size()) {
            if (tempColumns.get(k) != null && strJoins.indexOf(tempColumns.get(k).toString()) == -1) {
                sbFrom.append(tempColumns.get(k));
                if (k != tempColumns.size() - 1) {
                    sbFrom.append(",");
                }
            }
            ++k;
        }
        BaseLogger.log("3", null, null, "SQLMaker.makeFrom() tempColumns : [" + tempColumns.toString() + "]");
        BaseLogger.log("3", null, null, "SQLMaker.makeFrom() strJoins : [" + strJoins.toString() + "]");
        BaseLogger.log("3", null, null, "SQLMaker.makeFrom() sbFrom : [" + sbFrom.toString() + "]");
        str = !this.DB2 ? String.valueOf(str) + " FROM " + sbFrom_oracle.toString() + "\n" : (strJoins.length() > 0 && sbFrom.length() > 0 ? String.valueOf(str) + " FROM " + strJoins + "," + sbFrom.toString() + "\n" : (strJoins.length() > 0 && sbFrom.length() < 1 ? String.valueOf(str) + " FROM " + strJoins + "\n" : String.valueOf(str) + " FROM " + sbFrom.toString() + "\n"));
        BaseLogger.log("2", null, null, "str [" + str + "]");
        return str;
    }

    private String makeJoinANSI() {
        ArrayList<String> left = new ArrayList<String>();
        ArrayList<String> right = new ArrayList<String>();
        ArrayList<String> operator = new ArrayList<String>();
        ArrayList<String> outer = new ArrayList<String>();
        ArrayList<String> mainTable = new ArrayList<String>();
        ArrayList<String> joinType = new ArrayList<String>();
        int max = 0;
        String str = "";
        this.oracle_joins = "";
        String newTableName = "";
        Object aliasTableName = "";
        HashMap<String, String> pendingLeftJoin = new HashMap<String, String>();
        boolean addCloseBrackate = true;
        HashMap<String, String> masterTableList = new HashMap<String, String>();
        try {
            BaseLogger.log("3", null, null, "SQLMaker.makeJoin() joinList : [" + this.joinList.toString() + "]");
            int i = 0;
            while (i < this.joinList.size()) {
                String temp;
                BaseLogger.log("3", null, null, "SQLMaker.makeJoin() joinList.get( i ) : [" + this.joinList.get(i) + "]");
                if (this.joinList.get(i) != null && (temp = this.joinList.get(i).toString()).indexOf("OUTER") != -1) {
                    left.add(temp.substring(temp.indexOf("LEFT") + 6, temp.indexOf("OP")).trim());
                    operator.add(temp.substring(temp.indexOf("OP =") + 4, temp.indexOf("RIGHT")).trim());
                    right.add(temp.substring(temp.indexOf("RIGHT") + 6, temp.indexOf("OUTER")).trim());
                    outer.add(temp.substring(temp.indexOf("OUTER") + 9, temp.length()).trim());
                    mainTable.add(temp.substring(temp.indexOf("OUTER") + 9, temp.lastIndexOf(".")).trim());
                    joinType.add(temp.substring(temp.indexOf("OUTER"), temp.lastIndexOf("=")).trim());
                }
                ++i;
            }
            BaseLogger.log("3", null, null, "SQLMaker.makeJoin() left : [" + left + "]");
            BaseLogger.log("3", null, null, "SQLMaker.makeJoin() operator : [" + operator + "]");
            BaseLogger.log("3", null, null, "SQLMaker.makeJoin() right : [" + right + "]");
            BaseLogger.log("3", null, null, "SQLMaker.makeJoin() outer : [" + outer + "]");
            BaseLogger.log("3", null, null, "SQLMaker.makeJoin() joinType : [" + joinType + "]");
            BaseLogger.log("3", null, null, "SQLMaker.makeJoin() mainTable : [" + mainTable + "]");
            int j = 0;
            while (j < mainTable.size()) {
                int count = 0;
                if (mainTable.get(j) != null) {
                    String temp = mainTable.get(j).toString();
                    int k = 0;
                    while (k < mainTable.size()) {
                        if (temp.equals(mainTable.get(k))) {
                            ++count;
                        }
                        ++k;
                    }
                    if (count > max) {
                        max = count;
                        this.main = mainTable.get(j).toString();
                    }
                }
                ++j;
            }
            BaseLogger.log("3", null, null, "SQLMaker.makeJoin() main : [" + this.main + "]");
            this.tableJoinList.add(this.main);
            BaseLogger.log("3", null, null, "DB2 left [" + left.toString() + "]");
            BaseLogger.log("3", null, null, "DB2 operator [" + operator.toString() + "]");
            BaseLogger.log("3", null, null, "DB2 right [" + right.toString() + "]");
            BaseLogger.log("3", null, null, "DB2 outer [" + outer.toString() + "]");
            BaseLogger.log("3", null, null, "DB2 mainTable [" + mainTable.toString() + "]");
            BaseLogger.log("3", null, null, "DB2 joinType [" + joinType.toString() + "]");
            BaseLogger.log("3", null, null, "DB2 tableJoinList [" + this.tableJoinList.toString() + "]");
            BaseLogger.log("3", null, null, "DB2 main [" + this.main.toString() + "]");
            BaseLogger.log("3", null, null, "DB2 tableList [" + this.tableList.toString() + "]");
            boolean sameTables = false;
            boolean firstColumn = true;
            String curLeft = null;
            Object curRight = null;
            String nextLeft = null;
            String nextRight = null;
            int ctr = 0;
            while (ctr < outer.size()) {
                Object tempTable = "";
                String temp = "";
                String outerType = joinType.get(ctr).toString();
                String master = mainTable.get(ctr).toString();
                BaseLogger.log("3", null, null, "SQLMaker.makeJoin() outerType : [" + outerType + "]");
                BaseLogger.log("3", null, null, "SQLMaker.makeJoin() master : [" + master + "]");
                addCloseBrackate = true;
                temp = left.get(ctr).toString();
                if (temp != null && temp.trim().length() > 0) {
                    tempTable = temp.substring(0, temp.indexOf("."));
                }
                if (tempTable != null && ((String)tempTable).trim().length() > 0 && !((String)tempTable).trim().equalsIgnoreCase(master)) {
                    this.tableJoinList.add(((String)tempTable).trim());
                } else {
                    temp = right.get(ctr).toString();
                    if (temp != null && temp.trim().length() > 0) {
                        tempTable = temp.substring(0, temp.indexOf("."));
                    }
                    if (tempTable != null && ((String)tempTable).trim().length() > 0 && !((String)tempTable).trim().equalsIgnoreCase(master)) {
                        this.tableJoinList.add(((String)tempTable).trim());
                    }
                }
                BaseLogger.log("3", null, null, "SQLMaker.makeJoin() tableJoinList : [" + this.tableJoinList + "]");
                BaseLogger.log("3", null, null, "SQLMaker.makeJoin() tableList : [" + this.tableList + "]");
                int tableCnt = 0;
                while (tableCnt < this.tableList.size()) {
                    String tableString = (String)this.tableList.get(tableCnt);
                    int tokenCount = 0;
                    tableString.trim();
                    if (tableString.indexOf(" ") != -1) {
                        StringTokenizer st = new StringTokenizer(tableString, " ");
                        while (st.hasMoreTokens()) {
                            ++tokenCount;
                            st.nextToken();
                        }
                    }
                    if (tableString.indexOf((String)tempTable) != -1 && tokenCount == 2) {
                        newTableName = tableString.substring(0, tableString.indexOf(" "));
                        newTableName = (String)this.tableMap.get(tempTable);
                        aliasTableName = tableString.substring(tableString.indexOf(" "), tableString.length());
                        aliasTableName = tempTable;
                        this.aliasTables.add(aliasTableName);
                    }
                    ++tableCnt;
                }
                if (!this.DB2) {
                    this.oracle_joins = outerType.equals("OUTER1") ? String.valueOf(this.oracle_joins) + "( " + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + "(+))" : String.valueOf(this.oracle_joins) + "( " + left.get(ctr).toString() + "(+) " + operator.get(ctr).toString() + right.get(ctr).toString() + " ) ";
                    this.oracle_joins = ctr != outer.size() - 1 ? String.valueOf(this.oracle_joins) + " AND \n" : String.valueOf(this.oracle_joins) + "\n";
                } else {
                    BaseLogger.log("3", null, null, "SQLMaker.makeJoin() outerType : [" + outerType + "]");
                    BaseLogger.log("3", null, null, "SQLMaker.makeJoin() DB2 sameTables : [" + sameTables + "]");
                    BaseLogger.log("3", null, null, "SQLMaker.makeJoin() DB2 firstColumn : [" + firstColumn + "]");
                    BaseLogger.log("3", null, null, "SQLMaker.makeJoin() DB2 tempTable : [" + (String)tempTable + "]");
                    BaseLogger.log("3", null, null, "SQLMaker.makeJoin() DB2 MASTER : [" + master + "]");
                    BaseLogger.log("3", null, null, "SQLMaker.makeJoin() DB2 ORDER TYPE : [" + outerType + "]");
                    BaseLogger.log("3", null, null, "SQLMaker.makeJoin() DB2 newTableName : [" + newTableName + "]");
                    if (outerType.equals("OUTER1")) {
                        if ("".equalsIgnoreCase(newTableName)) {
                            if (!sameTables || sameTables && firstColumn) {
                                if (((String)tempTable).equals("") || ((String)tempTable).equals(" ")) {
                                    str = String.valueOf(str) + " LEFT OUTER JOIN " + right.get(ctr).toString().substring(0, right.get(ctr).toString().indexOf(".")) + " ON (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " ";
                                    curLeft = left.get(ctr).toString().substring(0, left.get(ctr).toString().indexOf("."));
                                    curRight = right.get(ctr).toString().substring(0, right.get(ctr).toString().indexOf("."));
                                } else {
                                    str = String.valueOf(str) + " LEFT OUTER JOIN " + (String)tempTable + " ON (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " ";
                                    curLeft = left.get(ctr).toString().substring(0, left.get(ctr).toString().indexOf("."));
                                    curRight = tempTable;
                                }
                            } else if (sameTables && !firstColumn) {
                                if (((String)tempTable).equals("") || ((String)tempTable).equals(" ")) {
                                    str = String.valueOf(str) + " AND " + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " ";
                                    curLeft = left.get(ctr).toString().substring(0, left.get(ctr).toString().indexOf("."));
                                    curRight = right.get(ctr).toString().substring(0, right.get(ctr).toString().indexOf("."));
                                } else {
                                    str = String.valueOf(str) + " AND " + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " ";
                                    curLeft = left.get(ctr).toString().substring(0, left.get(ctr).toString().indexOf("."));
                                    curRight = right.get(ctr).toString().substring(0, right.get(ctr).toString().indexOf("."));
                                }
                            }
                        } else {
                            String str0;
                            boolean newMaster = false;
                            if (str.length() > 0 && str.indexOf(" " + master + " ") == -1 && !this.main.trim().equalsIgnoreCase(master)) {
                                if (!masterTableList.containsKey(master.trim())) {
                                    newMaster = true;
                                }
                                this.tableAddedAsMaster.add(master);
                                BaseLogger.log("3", null, null, "SQLMaker.makeJoin() MASTER TABLE ADDED : [" + master + "]");
                            }
                            if (!sameTables || sameTables && firstColumn) {
                                curLeft = left.get(ctr).toString().substring(0, left.get(ctr).toString().indexOf("."));
                                curRight = newTableName == null || newTableName.trim().length() == 0 ? right.get(ctr).toString().substring(0, right.get(ctr).toString().indexOf(".")) : newTableName;
                                str0 = "";
                                String str1 = "";
                                if (newMaster) {
                                    if (pendingLeftJoin.containsKey(master.trim())) {
                                        str1 = pendingLeftJoin.get(master.trim()).toString();
                                    }
                                    str1 = String.valueOf(str1) + " LEFT OUTER JOIN " + (String)curRight + "  " + (String)aliasTableName + " ON (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " )\n";
                                    pendingLeftJoin.put(master.trim(), str1);
                                    BaseLogger.log("3", null, null, "SQLMaker.makeJoin() Added in Pending Map : [" + master + " >>> " + str1 + "]");
                                    addCloseBrackate = false;
                                } else {
                                    str = String.valueOf(str) + " LEFT OUTER JOIN " + (String)curRight + "  " + (String)aliasTableName + " ON (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " ) \n";
                                    str1 = "";
                                    BaseLogger.log("3", null, null, "SQLMaker.makeJoin()pendingLeftJoin.containsKey(aliasTableName.trim()) : [" + (String)aliasTableName + " >>> " + pendingLeftJoin.containsKey(((String)aliasTableName).trim()) + "]");
                                    if (pendingLeftJoin.containsKey(((String)aliasTableName).trim())) {
                                        str1 = pendingLeftJoin.get(((String)aliasTableName).trim()).toString();
                                        str = String.valueOf(str) + str1;
                                        pendingLeftJoin.remove(((String)aliasTableName).trim());
                                    }
                                    addCloseBrackate = false;
                                    masterTableList.put(master.trim(), "Added");
                                }
                            } else if (sameTables && !firstColumn) {
                                curLeft = left.get(ctr).toString().substring(0, left.get(ctr).toString().indexOf("."));
                                curRight = right.get(ctr).toString().substring(0, right.get(ctr).toString().indexOf("."));
                                str0 = "";
                                String str1 = "";
                                if (newMaster) {
                                    if (pendingLeftJoin.containsKey(master.trim())) {
                                        str1 = pendingLeftJoin.get(master.trim()).toString();
                                    }
                                    str1 = String.valueOf(str1) + " AND (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " )";
                                    BaseLogger.log("3", null, null, "SQLMaker.makeJoin() Added in Pending Map : [" + master + " >>> " + str1 + "]");
                                    addCloseBrackate = false;
                                } else {
                                    str = String.valueOf(str) + " AND (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " )";
                                    str1 = "";
                                    BaseLogger.log("3", null, null, "SQLMaker.makeJoin()pendingLeftJoin.containsKey(aliasTableName.trim()) : [" + (String)aliasTableName + " >>> " + pendingLeftJoin.containsKey(((String)aliasTableName).trim()) + "]");
                                    if (pendingLeftJoin.containsKey(((String)aliasTableName).trim())) {
                                        str1 = pendingLeftJoin.get(((String)aliasTableName).trim()).toString();
                                        str = String.valueOf(str) + str1;
                                        pendingLeftJoin.remove(((String)aliasTableName).trim());
                                    }
                                    addCloseBrackate = false;
                                    masterTableList.put(master.trim(), "Added");
                                }
                            }
                        }
                    } else if (newTableName.equalsIgnoreCase("")) {
                        if (!sameTables || sameTables && firstColumn) {
                            if (((String)tempTable).equals("") || ((String)tempTable).equals(" ")) {
                                str = String.valueOf(str) + " RIGHT OUTER JOIN " + right.get(ctr).toString().substring(0, right.get(ctr).toString().indexOf(".")) + " ON (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " ";
                                curLeft = left.get(ctr).toString().substring(0, left.get(ctr).toString().indexOf("."));
                                curRight = right.get(ctr).toString().substring(0, right.get(ctr).toString().indexOf("."));
                            } else {
                                str = String.valueOf(str) + " RIGHT OUTER JOIN " + (String)tempTable + " ON (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " ";
                                curLeft = left.get(ctr).toString().substring(0, left.get(ctr).toString().indexOf("."));
                                curRight = tempTable;
                            }
                        }
                    } else {
                        str = String.valueOf(str) + " RIGHT OUTER JOIN " + newTableName + " ON (" + left.get(ctr).toString() + operator.get(ctr).toString() + right.get(ctr).toString() + " ";
                        curLeft = left.get(ctr).toString().substring(0, left.get(ctr).toString().indexOf("."));
                        curRight = newTableName;
                    }
                    if (ctr >= outer.size() - 1) {
                        sameTables = false;
                        firstColumn = true;
                        if (addCloseBrackate) {
                            str = String.valueOf(str) + " )";
                        }
                    } else {
                        nextLeft = left.get(ctr + 1).toString().substring(0, left.get(ctr + 1).toString().indexOf("."));
                        nextRight = right.get(ctr + 1).toString().substring(0, right.get(ctr + 1).toString().indexOf("."));
                        if (curLeft.trim().equalsIgnoreCase(nextLeft.trim()) && ((String)curRight).trim().equalsIgnoreCase(nextRight.trim())) {
                            sameTables = true;
                            firstColumn = false;
                        } else {
                            sameTables = false;
                            firstColumn = true;
                            if (addCloseBrackate) {
                                str = String.valueOf(str) + " )";
                            }
                        }
                    }
                    str = String.valueOf(str) + "\n";
                }
                ++ctr;
            }
            BaseLogger.log("3", null, null, "SQLMaker.makeJoin() EOJ Started >>>>");
            BaseLogger.log("3", null, null, "SQLMaker.makeJoin() EOJ tableList : [ " + this.tableList.toString() + " ]");
            BaseLogger.log("3", null, null, "SQLMaker.makeJoin() EOJ pendingLeftJoin : [ " + pendingLeftJoin.toString() + " ]");
            BaseLogger.log("3", null, null, "SQLMaker.makeJoin() EOJ str before pendingjoinlist [ " + str + " ]");
            if (this.DB2 && pendingLeftJoin.size() > 0) {
                for (Object keyObj : pendingLeftJoin.keySet()) {
                    String str1 = pendingLeftJoin.get(keyObj).toString();
                    str = String.valueOf(str) + ", " + keyObj.toString() + " " + str1;
                    pendingLeftJoin.remove(keyObj);
                }
            }
            BaseLogger.log("3", null, null, "SQLMaker.makeJoin() EOJ str after pendingjoinlist [ " + str + " ]");
            if (str.length() > 0) {
                if (!this.DB2) {
                    str = "";
                } else {
                    BaseLogger.log("3", null, null, "SQLMaker.makeJoin() EOJ main [ " + this.main + " ]");
                    if (this.main.trim().indexOf(" ") == -1) {
                        int i2 = 0;
                        while (i2 < this.tableList.size()) {
                            String tmp = this.tableList.get(i2).toString();
                            String[] tmp1 = tmp.split(" ");
                            BaseLogger.log("3", null, null, "SQLMaker.makeJoin() EOJ tmp [ " + tmp + " ]");
                            BaseLogger.log("3", null, null, "SQLMaker.makeJoin() EOJ tmp1 [ " + tmp1 + " ]");
                            if (tmp1.length > 1) {
                                BaseLogger.log("3", null, null, "SQLMaker.makeJoin() EOJ tmp1[1] [ " + tmp1[1] + " ]");
                                if (this.main.trim().equalsIgnoreCase(tmp1[1].trim())) {
                                    BaseLogger.log("3", null, null, "SQLMaker.makeJoin() EOJ main  = tmp1[1] [ " + this.main + " = " + tmp1[1] + " ]");
                                    this.main = tmp;
                                    break;
                                }
                            }
                            ++i2;
                        }
                    }
                    str = String.valueOf(this.main) + str;
                    BaseLogger.log("3", null, null, "SQLMaker.makeJoin() EOJ Returned str [ " + str + " ]");
                    BaseLogger.log("3", null, null, "SQLMaker.makeJoin() EOJ Ended >>>>");
                }
            }
            return str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return str;
        }
    }
}

