package ibase.webitm.ejb.wsfa.transactions;

import java.net.InetAddress;
import java.rmi.RemoteException;

import javax.naming.InitialContext;

import java.sql.*;
import java.text.*;
import java.util.*;
import java.util.Date;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.AppConnectParm;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.CommonConstants;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

public class SprsCampgnWiz extends ValidatorEJB
{

	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}
	// For Next action
	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException,ITMException
	{
		//System.out.println("**********************Inside the wfValData method  1******************************");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			//System.out.println("xmlString::::: ["+xmlString+"]");
			//System.out.println("xmlString:::::1 ["+xmlString1+"]");
			//System.out.println("xmlString:::::2 ["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
				//System.out.println("xmlString::::: dom ["+xmlString+"]");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
				//System.out.println("xmlString::::1 dom1 ["+xmlString+"]");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
				//System.out.println("xmlString::::1 dom2 ["+xmlString+"]");
			}
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams,formName);
			//System.out.println ( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			//System.out.println ( "Exception:SprsCampgnWiz:wfValData(String xmlString): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		//System.out.println ( "Returning from Exception:SprsCampgnWiz:wfValData" );
		return (errString);
	}

	E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams,  String formName) throws ITMException
	{

		//System.out.println("**********************Inside the wfValData method  2******************************");
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
		String errString = "";
		String sql = "";
		int cnt = 0;
		Connection conn=null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		boolean isLocalConn=false;  

		String campgnId="";

		String currDate="";
		String datetime="";
		String brandSql="";


		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			String columnValue = "";
			int currentFormNo = 0;
			//String updateFlag = "";
			conn = getConnection();
			conn.setAutoCommit(false);
			int noOfChilds = 0;
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			userId = getEmpCode(userId, conn);

			// salesPers = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			// salesPers = getEmpCode(userId, conn);

			//userId = getEmpCode(userId, conn);

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			DateFormat dateTimeFormat = new SimpleDateFormat(genericUtility.getApplDateTimeFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );
			datetime=dateTimeFormat.format( date );
			//Date sysDate=Timestamp.valueOf(currDate);


			////System.out.println("value of salesPers *******************  "+salesPers);
			//System.out.println("value of userId *******************  "+userId);
			//System.out.println("value of chgDate *******************  "+currDate);
			//System.out.println("value of datetime *******************  "+datetime);
			////System.out.println("value of sysDate *******************  "+sysDate);

			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}


		/*	if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			} */
			if("header".equalsIgnoreCase(formName))
			{
				//System.out.println("**********************Inside header form  method  2******************************");
				String updateFlag="";
				parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}

						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						childNodeName = childNode.getNodeName();


						if ( "campgn_id".equalsIgnoreCase(childNodeName) )     // Campgn id not null
						{ 
							if(childNode.getFirstChild() == null && "campgn_id".equalsIgnoreCase(childNodeName))
							{
								errString = getErrorString("campgn_id","CAMPGNNULL",userId);
								break;
							}

							else
							{
								campgnId = checkNull(genericUtility.getColumnValue( "campgn_id", dom ));
								//System.out.println("********************* campgn id stored *****************************" +campgnId);
								cnt = 0;
								//sql="SELECT COUNT(1) AS COUNT FROM STRG_CAMPAIGN WHERE CAMPGN_ID=?";
								//Added by mrunalini SInkar for grace period chages
								int graceDays=0;

								sql = "SELECT GRACE_DAYS FROM STRG_CAMPAIGN  WHERE CAMPGN_ID = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, campgnId);
								rs = pstmt.executeQuery();
								if ( rs.next() )
								{
									graceDays = rs.getInt("GRACE_DAYS");

								}
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								DateFormat sdtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
								Calendar calendar = Calendar.getInstance();
								String currentDate  = sdtFormat.format(calendar.getTime());
								currentDate =  genericUtility.getValidDateString(currentDate,  genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
								System.out.println("currentDate => " + currentDate);
								
								sql = "SELECT COUNT(1) AS COUNT FROM STRG_CAMPAIGN WHERE CAMPGN_ID=? and ? between eff_from and valid_upto+? and item_ser =(select item_ser from sales_pers where sales_pers =?)";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, campgnId);
								pstmt.setDate(2,java.sql.Date.valueOf(currentDate));
								pstmt.setInt(3, graceDays);
								pstmt.setString(4, userId);
								//pstmt.setString(3, userId);

								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									cnt = rs.getInt("COUNT");
								}
								if(rs!=null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								if(cnt== 0)
								{

									errString = getErrorString("campgn_id","CAMPGNINV",userId); // invalid
									break;

								}

							}

						}
						else if ( "brand_code".equalsIgnoreCase(childNodeName) )    // brand_code not null validation 
						{
							if(childNode.getFirstChild() == null )
							{
								errString = getErrorString("brand_code","BRNDCODNUL",userId);
								break;

							}
							else
							{
								int brandCnt = 0;
								String brandCodeList="";
								brandCodeList = checkNull(childNode.getFirstChild().getNodeValue());
								if (brandCodeList != null && brandCodeList.length() > 0) 
								{
									String brandArr [] = brandCodeList.split(",");
									int brandArrLen = brandArr.length;
									
									brandSql = "SELECT COUNT(*) AS COUNT FROM brand WHERE brand_code= ?";
									pstmt = conn.prepareStatement(brandSql);
									
									if (brandArrLen > 0 )
									{
										for (int i = 0; i < brandArrLen; i++)
										{
											brandCnt = 0;
											String brandCode = brandArr[i];
											pstmt.setString(1, brandCode);
											rs = pstmt.executeQuery();
											if (rs.next())
											{
												brandCnt = rs.getInt("COUNT");
											}
											if (rs != null) 
											{
												rs.close();
												rs = null;
											}
											pstmt.clearParameters();
											if (brandCnt == 0) 
											{
												errString = getErrorString("brand_code__list", "INVBRAND", userId); // invalide brand
																													// code .
												break;
											}
											
											
										}  // end inside for 

									} // end inside if
									if (pstmt != null) 
									{
										pstmt.close();
										pstmt = null;
									}
									if(errString != null && errString.trim().length() > 0)
									{
										break;
									}
								} // end outer if
			                 }

						}


					}
					if(errString != null && errString.trim().length() > 0)
					{
						break;
					}
				}
			}

			else if("doctor".equalsIgnoreCase(formName))
			{

				//System.out.println("**********************Inside header form  method  2******************************");
				String updateFlag="";
				parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}

						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						childNodeName = childNode.getNodeName();

						if ( "strg_code".equalsIgnoreCase(childNodeName) )    // strg_code not null validation 
						{
							if(childNode.getFirstChild() == null )
							{
								errString = getErrorString("strg_code","STRCODNUL",userId);
								break;

							}
						}
						else if ( "brand_code".equalsIgnoreCase(childNodeName) )    // strg_code not null validation 
						{
							if(childNode.getFirstChild() == null )
							{
								errString = getErrorString("brand_code","BRNDCODNUL",userId);
								break;

							}
							else
							{
								int brandCnt = 0;
								String brandCodeList="";
								brandCodeList = checkNull(childNode.getFirstChild().getNodeValue());
								if (brandCodeList != null && brandCodeList.length() > 0) 
								{
									String brandArr [] = brandCodeList.split(",");
									int brandArrLen = brandArr.length;
									
									brandSql = "SELECT COUNT(*) AS COUNT FROM brand WHERE brand_code= ?";
									pstmt = conn.prepareStatement(brandSql);
									
									if (brandArrLen > 0 )
									{
										for (int i = 0; i < brandArrLen; i++)
										{
											brandCnt = 0;
											String brandCode1 = brandArr[i];
											pstmt.setString(1, brandCode1);
											rs = pstmt.executeQuery();
											if (rs.next())
											{
												brandCnt = rs.getInt("COUNT");
											}
											if (rs != null) 
											{
												rs.close();
												rs = null;
											}
											pstmt.clearParameters();
											if (brandCnt == 0) 
											{
												errString = getErrorString("brand_codes", "INVBRAND", userId); // invalide brand
																													// code .
												break;
											}
											
											
										}  // end inside for 

									} // end inside if
									if (pstmt != null) 
									{
										pstmt.close();
										pstmt = null;
									}
									if(errString != null && errString.trim().length() > 0)
									{
										break;
									}
								} // end outer if
			                 }
						}

					}
					if(errString != null && errString.trim().length() > 0)
					{
						break;
					}
				}

			}

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;

				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;

				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				//System.out.println( "Exception :SprsCampgnWiz:wfValData :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return errString;
	}
	// For Done action
	public String wfValOnDone(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams,String formName) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		//System.out.println("*******************Inside wfValOnDone Method 1*******************************");
		try
		{
			//System.out.println("wfValOnDonexmlStringaaaaaaaa ["+xmlString+"]");
			//System.out.println("wfValOnDone:xmlString1bbbbbb["+xmlString1+"]");
			//System.out.println("wfValData:xmlString2cccccccc["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString);
			}
			else
			{
				//System.out.println("wfValOnDone000is null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1);
			}
			else
			{
				//System.out.println("wfValOnDoneis1111 null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				//System.out.println("xmlstring2222222222 is null");
			}
			//System.out.println("Before call valdata formName:- "+formName);
			errString = wfValOnDone(dom,dom1,dom2,objContext,editFlag,xtraParams,formName);
		}
		catch(Exception e)
		{
			//System.out.println("Exception : [SprsCampgnWiz][wfValData(String xmlString)] : ==>\n"+e.getMessage());
		}
		return (errString);
	}
	// For Done action changes method on [01-04-2021]
	public String wfValOnDone(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException,ITMException
	{
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		//System.out.println("*******************Inside wfValOnDone Method 2*******************************");
		Connection conn = null;
		String errString = "";
		String sql="";
		//boolean isLocalConn= false; commeted by shwtea for ditry connetion
		int count = 0;
		int ctr,currentFormNo=0;
		int childNodeListLength;
		String childNodeName = "";
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String brandCode = "";
		
		int noOfChilds = 0;
		String columnValue="";
		String doctorName="";
		NodeList parentList = null;
		NodeList childList = null;
	/*	if(conn==null)                              commented by shweta for dirty connection issue
		{
			conn = getConnection();
			isLocalConn=true;
		}
		if(objContext != null && objContext.trim().length()>0)
		{
			currentFormNo = Integer.parseInt(objContext);
		}
		ITMDBAccessEJB itmDBAccessLocal = null;
		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode"); */
		
		try
		{
			// added by shweta for solving dirty connection issue[24/05/21] (started)
			conn = getConnection();      
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			ITMDBAccessEJB itmDBAccessLocal = null;
			String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			// added by shweta for solving dirty connection issue[24/05/21] (endeed)
			SimpleDateFormat sdf = new SimpleDateFormat(getApplDateFormat());
			itmDBAccessLocal = new ITMDBAccessEJB();
			
				if("doctor".equalsIgnoreCase(formName))
				{
					//System.out.println("*******************Inside wfValOnDone doctor form*******************************");
					int selectedFlagCnt = 0;
					int updateFlagCnt = 0;
					parentList = dom1.getElementsByTagName("Detail"+ currentFormNo);
					int parentNodeListLength = parentList.getLength();
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{
						String selectedFlag = "";
						String updateFlag = "";

						Node currDetail = parentList.item(prntCtr);
						if(currDetail.getAttributes().getNamedItem("selected") != null)
						{
							selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
						}
						if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
						{
							selectedFlagCnt++;
						}

						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						for (ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();
							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
								}
							}
						}
						if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
						{
							updateFlagCnt++;
						}
					}
					
					if(selectedFlagCnt > 0)
					{
						//System.out.println("*******************Inside wfValOnDone selected doctor form*******************************");
						for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
						{
							parentNode = parentList.item(prntCtr);
							childList = parentNode.getChildNodes();
							noOfChilds = childList.getLength();
							
							for (ctr = 0; ctr < noOfChilds; ctr++)
							{
								childNode = childList.item(ctr);
								if( childNode.getNodeType() != Node.ELEMENT_NODE )
								{
									continue;
								}

								if ( childNode != null && childNode.getFirstChild() != null )
								{
									columnValue = childNode.getFirstChild().getNodeValue();
								}
								childNodeName = childNode.getNodeName();
								
								if(childNodeName.equalsIgnoreCase("brand_code"))
								{
									/* commented by shweta for validation not work 13-05-21
									brandCode = checkNull(genericUtility.getColumnValue("brand_code", dom2, objContext));
									doctorName = checkNull(genericUtility.getColumnValueFromNode("strg_descr", parentNode));
									//System.out.println("brandCode ssssss:::::["+brandCode+"]doctorName::::::["+doctorName);

									if(childNode.getFirstChild() == null)				
									{
											errString = itmDBAccessLocal.getErrorString( "brand_code", "CMPBRNDNUL", userId );
											break;

									}

									else
									{
										if(brandCode != null && brandCode.trim().length() > 0)
										{
											if ( brandCode.indexOf(",")  != -1)
											{
												sql = " SELECT COUNT(*) CNT FROM BRAND WHERE BRAND_CODE in "+ E12GenericUtility.getFormattedProfileId(brandCode)+"";
												pstmt = conn.prepareStatement(sql);
												rs = pstmt.executeQuery();
												while (rs.next())
												{
													count = rs.getInt("CNT");
													//System.out.println("BRAND count::["+count+"]");
												}
												if ( rs != null )
												{
													rs.close();
													rs = null;
												}
												if ( pstmt != null )
												{
													pstmt.close();
													pstmt = null;
												}
												if(count == 0)
												{
													errString = itmDBAccessLocal.getErrorString( "brand_code", "INVSTRGBRD", userId );
													break;
												}
											}
											else
											{
												sql = "SELECT COUNT(*) BRAND FROM BRAND WHERE BRAND_CODE = ? ";
												pstmt = conn.prepareStatement(sql);
												pstmt.setString(1, brandCode);
												rs = pstmt.executeQuery();
												if ( rs.next() )
												{
													count = rs.getInt("BRAND");
													//System.out.println("BRAND count::["+count+"]");
												}
												if ( rs != null )
												{
													rs.close();
													rs = null;
												}
												if ( pstmt != null )
												{
													pstmt.close();
													pstmt = null;
												}
												if(count == 0)
												{
													errString = itmDBAccessLocal.getErrorString( "brand_code", "INVSTRGBRD", userId );
													break;
												}
											}

										}
									} */


									// change for validation shweta m 13-05-21 started

									if(childNode.getFirstChild() == null )
									{
										errString = getErrorString("brand_code","BRNDCODNUL",userId);
										break;

									}
									else
									{
										int brandCnt = 0;
										String brandCodeList="";
										brandCodeList = checkNull(childNode.getFirstChild().getNodeValue());
										if (brandCodeList != null && brandCodeList.length() > 0) 
										{
											String brandArr [] = brandCodeList.split(",");
											int brandArrLen = brandArr.length;

											String	brandSql = "SELECT COUNT(*) AS COUNT FROM brand WHERE brand_code= ?";
											pstmt = conn.prepareStatement(brandSql);

											if (brandArrLen > 0 )
											{
												for (int i = 0; i < brandArrLen; i++)
												{
													brandCnt = 0;
													String brandCode1 = brandArr[i];
													pstmt.setString(1, brandCode1);
													rs = pstmt.executeQuery();
													if (rs.next())
													{
														brandCnt = rs.getInt("COUNT");
													}
													if (rs != null) 
													{
														rs.close();
														rs = null;
													}
													if (pstmt != null) 
													{
														pstmt.close();
														pstmt = null;
													}
													if (brandCnt == 0) 
													{
														errString = getErrorString("brand_code__list", "INVBRAND", userId); // invalide brand
														// code .
														break;
													}


												} 

											} 

										} 
									}
									// change for validation shweta m 13-05-21 started

								}
								else if(childNodeName.equalsIgnoreCase("description"))
								{
									doctorName = checkNull(genericUtility.getColumnValueFromNode("strg_descr", parentNode));
									if(childNode.getFirstChild() == null)				
									{
										errString = itmDBAccessLocal.getErrorString( "description", "BRDESCNULL", userId );
										break;
									}
								}
							}
						}
					}
				}
				
				
			}
		catch(Exception e)
		{

			//System.out.println("Exception ::"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				/*if ( isLocalConn && conn != null && ! conn.isClosed())
				{
					conn.close();
					conn = null; 
				}*/     //commented and added by shweta for dirty connetion changes 24-05-21
				if (conn != null && ! conn.isClosed())         
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}			
		}
		return (errString);
	}

	// For Previous action start
	/*public String wfValOnPrevious(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException,ITMException
	{
		//System.out.println("**********************Inside the wfValOnPrevious method  1******************************");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";

		try
		{
			//System.out.println("wfValData:xmlStringaaaaaaaa ["+xmlString+"]");
			//System.out.println("wfValData:xmlString1bbbbbb["+xmlString1+"]");
			//System.out.println("wfValData:xmlString2cccccccc["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString);
			}
			else
			{
				//System.out.println("xmlstring is null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1);
			}
			else
			{
				//System.out.println("xmlstring1 is null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				//System.out.println("xmlstring2 is null");
			}
			//System.out.println("Before call valdata");
			errString = wfValOnPrevious(dom,dom1,dom2,objContext,editFlag,xtraParams,formName);
		}
		catch(Exception e)
		{
			//System.out.println("Exception : [StrgMeetDCRWiz][wfValData(String xmlString)] : ==>\n"+e.getMessage());
		}
		return (errString);
	}
	// For Previous action start 
	public String wfValOnPrevious(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException,ITMException
	{

		//System.out.println("**********************Inside the wfValOnPrevious method  2******************************");

		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		String errString = "";

		int currentFormNo = 0;

		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
		String columnValue = "";
		String checkSQL = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		PreparedStatement actPstmt = null;
		ResultSet actRs = null;
		ResultSet rSet = null;

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.
		int noOfChilds = 0;
		try
		{
			connectionObject = getConnection();
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);

			itmDBAccessLocal = new ITMDBAccessEJB();

			userId = getEmpCode(userId, connectionObject);



			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
			String locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
			String mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));

			if("doctor".equalsIgnoreCase(formName))
			{
				String CheckUpdateFlag = "";
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				ArrayList drVisitList = new ArrayList();

				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					////System.out.println("noOfChilds["+noOfChilds+"]");
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						////System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
					}
					if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
					{
						updateFlagCnt++;
					}
				}

				if(selectedFlagCnt > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{

						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						////System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							////System.out.println("childNodeName :: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();


							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{

									CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
								}
							}
						}

					}
				}
			}



		}
		catch(Exception e)
		{
			e.printStackTrace();
			errString = "";

			errString = genericUtility.createErrorString( e ) ;
			String messageValue="",message = "";

			if( errString.indexOf("<Errors>")!=-1 )
			{
				if( errString.length() > 0 )
				{

					StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
					valueXmlErrorString.append( "</Root>\r\n" );
					errString =valueXmlErrorString.toString();
				}

			}
		}
		finally
		{
			try
			{
				if (rSet != null)
				{
					rSet.close();
					rSet = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				////System.out.println( "Exception :StrgMeetDCRWiz :defaultDataWiz :==>\n"+e.getMessage());
				errString = "";

				errString = genericUtility.createErrorString( e ) ;
				////System.out.println( "errString :Dipak:" +errString + ":" );
				String messageValue="",message = "";

				if( errString.indexOf("<Errors>")!=-1 )
				{
					if( errString.length() > 0 )
					{

						StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
						valueXmlErrorString.append("</Header>\r\n");
						valueXmlErrorString.append( "</Root>\r\n" );
						errString =valueXmlErrorString.toString();

					}
				}
			}
		}
		//System.out.println("errString ["+errString+"]");
		return errString;
	} */// For Previous action end

	// For Finish action
	public String wfValOnFinish(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException,ITMException
	{
		//System.out.println("**********************Inside the wfValOnFinish method  1******************************");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";

		try
		{
			//System.out.println("wfValData:xmlStringaaaaaaaa ["+xmlString+"]");
			//System.out.println("wfValData:xmlString1bbbbbb["+xmlString1+"]");
			//System.out.println("wfValData:xmlString2cccccccc["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString);
			}
			else
			{
				//System.out.println("xmlstring is null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1);
			}
			else
			{
				//System.out.println("xmlstring1 is null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				//System.out.println("xmlstring2 is null");
			}
			//System.out.println("Before call valdata");
			errString = wfValOnFinish(dom,dom1,dom2,objContext,editFlag,xtraParams,formName);
		}
		catch(Exception e)
		{
			//System.out.println("Exception : [StrgMeetDCRWiz][wfValData(String xmlString)] : ==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return (errString);
	}
	// For Finish action
	public String wfValOnFinish(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException,ITMException
	{

		System.out.println("**********************Inside the wfValOnFinish method  2******************************");
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String errString = "";

		int currentFormNo = 0;

		NodeList parentList = null;
		NodeList childList = null;
		Node childNode = null;
		String childNodeName = "";
		String columnValue = "";
		String strgCode="",sqlStrgCode="",salesPerson="";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		PreparedStatement actPstmt = null;
		ResultSet rs=null;
		String campaignId="",sqlTranId="",rxMaxTranID="",selStrgCode="",brandcodeheader="";
		ArrayList rxDoctorList = new ArrayList();
		ArrayList strgcodelist = new ArrayList();

		int noOfChilds = 0;
		try
		{
			connectionObject = getConnection();

			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			campaignId = checkNull(genericUtility.getColumnValue( "campgn_id",dom2 ,"1"));
			salesPerson = checkNull(genericUtility.getColumnValue( "sales_pers",dom2 ,"1"));
			brandcodeheader = checkNull(genericUtility.getColumnValue( "brand_code",dom2 ,"1"));

			System.out.println("Inside wfValOnFinish method campaignId............................:-"+campaignId);
			System.out.println("Inside wfValOnFinish method salesPerson............................:-"+salesPerson);
			
			//Added by mtunalini SInkar fro grade day
			int graceDays=0;

			String sql = "SELECT GRACE_DAYS FROM STRG_CAMPAIGN  WHERE CAMPGN_ID = ? ";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, campaignId);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				graceDays = rs.getInt("GRACE_DAYS");

			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			

			sqlTranId="select max(SC.tran_id) as tran_id from SPRS_CAMPGN SC,SPRS_CAMPGN_STRG SCMPS "
					+ " where SC.tran_date =(select max(a.tran_date) from SPRS_CAMPGN a, STRG_CAMPAIGN b, SPRS_CAMPGN_STRG c where a.CAMPGN_ID = b.CAMPGN_ID and a.tran_date between b.eff_from and b.valid_upto+? and a.sales_pers =? AND a.TRAN_ID=c.TRAN_ID AND c.BRAND_CODE=? and b.CAMPGN_ID=?) and sales_pers = ? and tran_type= ? "
					+ " AND SC.tran_id=SCMPS.tran_id AND SCMPS.BRAND_CODE=? AND SC.CAMPGN_ID = ?";
			pstmt =  connectionObject.prepareStatement(sqlTranId);
            pstmt.setInt(1, graceDays);
            pstmt.setString(2, salesPerson);
            pstmt.setString(3, brandcodeheader);
			pstmt.setString(4, campaignId);
			pstmt.setString(5, salesPerson);
			pstmt.setString(6, "P");
			pstmt.setString(7, brandcodeheader);
			pstmt.setString(8, campaignId);

			rs = pstmt.executeQuery();
			if (rs.next())                           
			{
				rxMaxTranID=checkNull(rs.getString("tran_id"));

			}
			//System.out.println("Inside wfValOnFinish method tranID............................:-"+rxMaxTranID);
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

			sqlStrgCode="SELECT  SCMPS.STRG_CODE  FROM SPRS_CAMPGN_STRG SCMPS,SPRS_CAMPGN SCMP WHERE SCMPS.TRAN_ID = SCMP.TRAN_ID AND SCMP.TRAN_ID = ? AND SCMP.CAMPGN_ID = ? AND SCMPS.BRAND_CODE=? AND SCMP.TRAN_TYPE='P' AND SCMP.SALES_PERS = ?";
			pstmt =  connectionObject.prepareStatement(sqlStrgCode);
			pstmt.setString(1, rxMaxTranID);
			pstmt.setString(2, campaignId);
			pstmt.setString(3, brandcodeheader);
			pstmt.setString(4, salesPerson);
			rs = pstmt.executeQuery();
			while (rs.next()) 
			{
				selStrgCode=checkNull(rs.getString("STRG_CODE"));

				rxDoctorList.add(selStrgCode);
			}
			//System.out.println("Here doctor  added in arraylist wfValOnFinish method ====="+rxDoctorList);
			if (rs != null) 
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
            }
            System.out.println("rxDoctorList BEFORE::"+rxDoctorList);
			if("doctor".equalsIgnoreCase(formName))
			{   

				if(rxDoctorList != null && rxDoctorList.size() > 0 )
				{
					System.out.println("**********************Inside header form wfValOnFinish  method  2******************************");

					parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
					int parentNodeListLength = parentList.getLength();

					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{

						Node parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							columnValue = "";
							childNodeName = "";
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();
							System.out.println("childNodeName =["+childNodeName+"]");

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = checkNull(childNode.getFirstChild().getNodeValue());
							}

							System.out.println("selected strg_code====="+columnValue);
							if(childNodeName.equalsIgnoreCase("strg_code"))
							{
								System.out.println("inside strg_code====="+columnValue);
								if(rxDoctorList.contains(columnValue))
								{
									rxDoctorList.remove(columnValue);
								}
							}
						}
					}
					System.out.println("rxDoctorList AFTER::"+rxDoctorList);
					if(rxDoctorList != null  && rxDoctorList.size() > 0)
					{
						errString = getErrorString("strg_code","STRGDELNA",salesPerson);
						////System.out.println("error on strg_code====="+columnValue);
					}
				}
			}

		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{}
		}
		//System.out.println("errString ["+errString+"]");
		return errString;
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams,String formName) throws RemoteException, ITMException
	{
		//System.out.println("*******************Inside Itemchange Method*******************************");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		try
		{
			//System.out.println ( "xmlString :" + xmlString);
			//System.out.println ( "xmlString1 :" + xmlString1);
			//System.out.println ( "xmlString2 :" + xmlString2);
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams ,formName);
			////System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			String errString1 = "";
			StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
			//System.out.println( "Exception :SprsCampgnWiz :defaultDataWiz(String,String):" + e.getMessage() + ":" );
			errString1 = genericUtility.createErrorString( e ) ;
		//	//System.out.println( "errString :Exception :SprsCampgnWiz :defaultDataWiz(String,String)::" +errString1 + ":" );

			if ( errString != null && errString.length() > 0) //changes by shraddha M for null pointer exception[13/10/2020]
			{
				String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
				bifurErrString =bifurErrString;
				bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
				errStringXml.append(bifurErrString);
				//System.out.println("errStringXml .........."+errStringXml);
				errString1 = "";
			}
			errStringXml.append("</Errors></Root>\r\n");
			errString = errStringXml.toString();

			throw new ITMException(e);
		}
		////System.out.println ( "returning from WsfaMgrDsrMobWizEJB defaultDataWiz" );
		return errString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams,String formName) throws RemoteException,ITMException
	{
		//System.out.println("*******************Inside Itemchange Method 2*******************************");
		String returnStr="";
		try
		{

			returnStr = defaultDataWiz(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams, formName);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return returnStr;
	}

	public String defaultDataWiz() throws RemoteException, ITMException
	{
		return "";
	}

	private String defaultDataWiz( Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams, String formName ) throws RemoteException,ITMException
	{
		//System.out.println("*******************Inside defaultDataWiz Method*******************************");
		ResultSet rs = null;
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		String chgTerm ="";
		String userId = "";
		String currDate = "";
		String brandDescr = "";
		String datetime ="";
		StringBuffer valueXmlString = new StringBuffer();
		int currentFormNo = 0;

		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			InetAddress ownIP=InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();

			connectionObject = getConnection();
			userId=checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" ));

			userId = getEmpCode(userId, connectionObject);

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			DateFormat dateTimeFormat = new SimpleDateFormat(genericUtility.getApplDateTimeFormat());


			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );
			datetime = dateTimeFormat.format( date );

			////System.out.println("value of currDate*******************"+currDate);


			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			int domID=1;
			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
			valueXmlString.append( editFlag ).append( "</editFlag>\r\n</Header>\r\n<Errors>\r\n</Errors>\r\n" );
			//String salesPers = checkNull(genericUtility.getColumnValue( "sales_pers" , dom2 ,"1"));
			String campaignID = checkNull(genericUtility.getColumnValue( "campgn_id" , dom2 ,"1"));
			String brandCode = checkNull(genericUtility.getColumnValue( "brand_code", dom2 ,"1"));
			////System.out.println(" brandCode[" +brandCode+"] :: campaignID[" +campaignID+"]");

			//userId = (salesPers == null) ? userId : salesPers;

			if("header".equalsIgnoreCase(formName))
			{
				////System.out.println("inside header form in default data******************  ");
				if( currentColumn.equalsIgnoreCase( "itm_default" ))
				{

					String sql="";
					String spName="";


					sql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ?";
					pstmt =  connectionObject.prepareStatement(sql);
					pstmt.setString(1, userId);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						spName = checkNull(rs.getString("SP_NAME"));

					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}

					valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>");
					valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
                    valueXmlString.append("<tran_date><![CDATA[").append(currDate).append("]]></tran_date>\r\n");
                    valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
					// Added By Nilesh form anguler component itshould display Start :: 12-02-2021
					if(campaignID !=null && campaignID.trim().length()>0)
					{
						
						String campignDescr="";
						String effFormDate="",validUptoDate="";	
						
						sql = "SELECT DESCR,EFF_FROM,VALID_UPTO FROM STRG_CAMPAIGN WHERE CAMPGN_ID= ? ";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, campaignID);
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							campignDescr =checkNull(rs.getString("DESCR"));
							effFormDate =checkNull(rs.getString("EFF_FROM"));
							validUptoDate =checkNull(rs.getString("VALID_UPTO"));
						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						
						//System.out.println(" ::: data[" +campignDescr+"]["+effFormDate+"]["+validUptoDate+"]");
						
						if( (effFormDate != "")  || (validUptoDate !="") )
						{
							////System.out.println("Inside....");
							effFormDate = genericUtility.getValidDateString(effFormDate.toString(),genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
							validUptoDate = genericUtility.getValidDateString(validUptoDate.toString(),genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
						}

						valueXmlString.append("<campgn_id><![CDATA[").append(campaignID).append("]]></campgn_id>\r\n");
						valueXmlString.append("<descr><![CDATA[" ).append(campignDescr).append( "]]></descr>\r\n" );
						valueXmlString.append("<eff_from><![CDATA[" ).append(effFormDate).append( "]]></eff_from>\r\n" );
						valueXmlString.append("<valid_upto><![CDATA[").append(validUptoDate).append("]]></valid_upto>\r\n");
					}
					else
					{   
						
						valueXmlString.append("<campgn_id><![CDATA[").append(campaignID).append("]]></campgn_id>\r\n");
						valueXmlString.append("<descr><![CDATA[" ).append("").append( "]]></descr>\r\n" );
						valueXmlString.append("<eff_from><![CDATA[" ).append("").append( "]]></eff_from>\r\n" );
						valueXmlString.append("<valid_upto><![CDATA[").append("").append("]]></valid_upto>\r\n");
					}
					
					if(brandCode !=null && brandCode.trim().length()>0)
					{
						sql = "SELECT DESCRIPTION FROM BRAND WHERE BRAND_CODE in "+E12GenericUtility.getFormattedProfileId(brandCode);
						pstmt =  connectionObject.prepareStatement(sql);
						rs = pstmt.executeQuery();
						if ( brandCode.indexOf(",")  != -1)
						{
							while( rs.next() )
							{	
								brandDescr = brandDescr + checkNull(rs.getString("DESCRIPTION")) + ", ";
								////System.out.println("Description of brand ========>"+brandDescr);
							}

						}

						else
						{	
							if( rs.next() )
							{
								brandDescr = checkNull(rs.getString("DESCRIPTION"));
								////System.out.println(" else if loop :::: ="+brandDescr);
							}
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						
						valueXmlString.append("<brand_code><![CDATA[").append(brandCode).append("]]></brand_code>\r\n");
						valueXmlString.append("<brand_descr><![CDATA[").append(brandDescr).append("]]></brand_descr>\r\n");

					}
					
					// Added By Nilesh form anguler component itshould display End :: 12-02-2021
					
					
					valueXmlString.append("<tran_type><![CDATA[").append("D").append("]]></tran_type>\r\n");
					valueXmlString.append("<sales_pers><![CDATA[").append(userId).append("]]></sales_pers>\r\n");
					valueXmlString.append("<sp_name><![CDATA[").append(checkNull(spName)).append("]]></sp_name>\r\n");
					valueXmlString.append("</Detail"+objContext+">");
				}

				else if( currentColumn.equalsIgnoreCase( "campgn_id" ))
				{

				//	//System.out.println("inside the campgn_id itemchange  ");
					String campaignId = "";
					String campignDescr="";
					String sql="";
					String effFormDate="",validUptoDate="";	
					//Date effFromDate = null,validUpto=null;
					campaignId = checkNull(genericUtility.getColumnValue( "campgn_id", dom ));
					//System.out.println("campaignId[" +campaignId+"]");
					if(campaignId !=null && campaignId.trim().length()>0)
					{
						sql = "SELECT DESCR,EFF_FROM,VALID_UPTO FROM STRG_CAMPAIGN WHERE CAMPGN_ID= ? ";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, campaignId);
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							campignDescr =checkNull(rs.getString("DESCR"));
							effFormDate =checkNull(rs.getString("EFF_FROM"));
							validUptoDate =checkNull(rs.getString("VALID_UPTO"));
						}
						////System.out.println("data[" +campignDescr+"]["+effFormDate+"]["+validUptoDate+"]");
						if((effFormDate != "")  || (validUptoDate !=""))
						{
							//System.out.println("Inside....");
							effFormDate = genericUtility.getValidDateString(effFormDate.toString(),genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
							validUptoDate = genericUtility.getValidDateString(validUptoDate.toString(),genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
						}

					//	//System.out.println("Eff form only date dd/mm/yy format for selected campgn id ***************"+effFormDate);
						valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>");
					//	//System.out.println("data:::::::::::::::::::::::;;");
						valueXmlString.append("<descr><![CDATA[" ).append(campignDescr).append( "]]></descr>\r\n" );
						valueXmlString.append("<eff_from><![CDATA[" ).append(effFormDate).append( "]]></eff_from>\r\n" );
						valueXmlString.append("<valid_upto><![CDATA[").append(validUptoDate).append("]]></valid_upto>\r\n");
					}
					else
					{ 
						////System.out.println("data:e::::::::::::::::::::::;;");
					valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>");
					valueXmlString.append("<descr><![CDATA[" ).append("").append( "]]></descr>\r\n" );
					valueXmlString.append("<eff_from><![CDATA[" ).append("").append( "]]></eff_from>\r\n" );
					valueXmlString.append("<valid_upto><![CDATA[").append("").append("]]></valid_upto>\r\n");
                    }
                    
					if(rs!=null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}

					valueXmlString.append("</Detail"+objContext+">");
				}
				else if( currentColumn.equalsIgnoreCase("brand_code" ))
				{
					////System.out.println("inside the brand_code itemchange  ");
					//String brandCode = "";
					String sql="";
					brandCode = checkNull(genericUtility.getColumnValue( "brand_code", dom ));

					////System.out.println("brandCode[" +brandCode+"]");

					if(brandCode !=null && brandCode.trim().length()>0)
					{
						sql = "SELECT DESCRIPTION FROM BRAND WHERE BRAND_CODE in "+E12GenericUtility.getFormattedProfileId(brandCode);
						pstmt =  connectionObject.prepareStatement(sql);
						//pstmt.setString(1, brandCode);
						rs = pstmt.executeQuery();
						if ( brandCode.indexOf(",")  != -1)
						{
							while( rs.next() )
							{	
								brandDescr = brandDescr + checkNull(rs.getString("DESCRIPTION")) + ", ";
								////System.out.println("Description of brand ========>"+brandDescr);
							}

						}

						else
						{	
							if( rs.next() )
							{
								brandDescr = checkNull(rs.getString("DESCRIPTION"));
								////System.out.println(" else if loop :::: ="+brandDescr);
							}
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}

					}
					valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>");
					valueXmlString.append("<brand_code><![CDATA[").append(brandCode).append("]]></brand_code>\r\n");
					valueXmlString.append("<brand_descr><![CDATA[").append(brandDescr).append("]]></brand_descr>\r\n");
					valueXmlString.append("</Detail"+objContext+">");
				}
			}
			else if("doctor".equalsIgnoreCase(formName))
			{            
				////System.out.println("*************** Inside the doctor form  default data********************************");
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					////System.out.println("*************** Inside itm_default method in doctor form  ***************");
			           
					String custDetail="";
					/*if( currentColumn.equalsIgnoreCase( "campgn_id" ))
							{
								String  campaignId = checkNull(genericUtility.getColumnValue( "campgn_id",dom ,"1"));
								 //System.out.println("*************** Inside itm_default campgn_id in doctor form  ***************" +campaignId);
							}
							else if(currentColumn.equalsIgnoreCase( "brand_code" ))
							{
								String  brand_code = checkNull(genericUtility.getColumnValue( "brand_code",dom ,"1"));
								 //System.out.println("*************** Inside itm_default brand_code in doctor form  ***************" +brand_code);
							}
							else
							{*/
					custDetail = getCustomerDetail(dom2,userId,formName,objContext, connectionObject);  

					valueXmlString.append( custDetail );
				}
				else if( currentColumn.equalsIgnoreCase("brand_code" ))
				{
					////System.out.println("*************** Inside itm_default method in doctor form  ***************");
					////System.out.println("inside the brand_code itemchange  ");
					String sql="";
					brandCode = checkNull(genericUtility.getColumnValue( "brand_code", dom1 ));         //changes by shweta[01-04-2021]

					////System.out.println("brandCode inside doctor form[" +brandCode+"]");

					if(brandCode !=null && brandCode.trim().length()>0)
					{
						sql = "SELECT DESCRIPTION FROM BRAND WHERE BRAND_CODE in "+E12GenericUtility.getFormattedProfileId(brandCode);
						pstmt =  connectionObject.prepareStatement(sql);
						//pstmt.setString(1, brandCode);
						rs = pstmt.executeQuery();
						if ( brandCode.indexOf(",")  != -1)
						{
							while( rs.next() )
							{	
								brandDescr = brandDescr + checkNull(rs.getString("DESCRIPTION")) + ", ";
								//System.out.println("Description of brand ========>"+brandDescr);
							}

						}

						else
						{	
							if( rs.next() )
							{
								brandDescr = checkNull(rs.getString("DESCRIPTION"));
								////System.out.println(" else if loop :::: ="+brandDescr);
							}
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}

					}
					valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>");
					valueXmlString.append("<brand_code><![CDATA[").append(brandCode).append("]]></brand_code>\r\n");
					valueXmlString.append("<brand_description><![CDATA[").append(brandDescr).append("]]></brand_description>\r\n");
					valueXmlString.append("</Detail"+objContext+">");
				}
			}

			// valueXmlString.append("</Detail"+objContext+">\r\n" );
			valueXmlString.append("</Root>\r\n");

		}
		catch(Exception e)
		{
			////System.out.println( "Exception :EventConfigEJB:itemChanged(Document,String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				//System.out.println( "Exception :SprsCampgnwiz :==>\n"+e.getMessage());

			}
		}
		return valueXmlString.toString();

	}
	private String checkNull(String input)
	{
		if (input == null)
		{
			input="";
		}
		return input.trim();
	}
	public String getEmpCode(String userId,Connection connectionObject)throws ITMException
	{
		String empCode="";
		String entityCode="";
		boolean isLocalConn =false;
		PreparedStatement pstmtSelect = null;
		ResultSet resultSelect = null ;
		try
		{
			if(connectionObject == null)
			{
				connectionObject = getConnection();
				isLocalConn =true;
			}
			String selectMsgDescrSql = "SELECT EMP_CODE,ENTITY_CODE FROM USERS WHERE CODE= ? ";
			pstmtSelect = connectionObject.prepareStatement(selectMsgDescrSql);
			pstmtSelect.setString(1, userId);
			resultSelect = pstmtSelect.executeQuery();
			if(resultSelect.next())
			{
				empCode = checkNull(resultSelect.getString("EMP_CODE"));
				entityCode = checkNull(resultSelect.getString("ENTITY_CODE"));
			}
			if(empCode == null || empCode.trim().length() == 0)
			{
				empCode = entityCode;
			}

		}
		catch(Exception e)
		{
			//System.out.println( "Exception :StrgMeetWizardEJB:getMsgDescr():==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(resultSelect != null)
				{
					resultSelect.close();
					resultSelect = null;
				}
				if(pstmtSelect != null)
				{
					pstmtSelect.close();
					pstmtSelect = null;
				}
				if(isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch (Exception e)
			{
				e.getMessage();
			}
		}
		return empCode;
	}
	public String getObjNameFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	{
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				if( currDetail.getAttributes().getNamedItem(attribute) != null )
				{
					objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
					break;
				}
			}
			if( (objName == null || objName.trim().length() == 0) && currFormNo != 1 )
			{
				detailList = dom.getElementsByTagName("Detail1");
				detailListLength = detailList.getLength();
				for (int ctr = 0;ctr < detailListLength;ctr++)
				{
					currDetail = detailList.item(ctr);
					if( currDetail.getAttributes().getNamedItem(attribute) != null )
					{
						objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
						break;
					}
				}
			}
			if(objName == null || objName.trim().length() == 0)
			{
				NodeList objNameList = dom.getElementsByTagName("objName");
				if(objNameList != null && objNameList.getLength() > 0)
				{
					Node objNameNode = objNameList.item(0);
					if(objNameNode != null && objNameNode.getFirstChild() != null)
					{
						objName = checkNull(objNameNode.getFirstChild().getNodeValue());
					}
				}
			}
		}
		catch(Exception e)
		{
			//System.out.println("Exception Inside getObjNameFromDom ::["+e.getMessage()+"]");
			e.printStackTrace();
		}
		return objName;
	}
	public String getFormNo(String objName, String formName, Connection connectionObject) throws ITMException
	{
		Statement stmt = null;
		ResultSet rs = null;
		String formNo = "";
		try
		{
			String sql = "SELECT FORM_NO FROM OBJ_FORMS WHERE WIN_NAME = '"+"w_"+objName+"'AND FORM_NAME = '"+formName+"'";
			stmt = connectionObject.createStatement();
			rs = stmt.executeQuery(sql);
			if( rs.next() )
			{
				formNo = checkNull(rs.getString("FORM_NO"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( stmt !=null )
			{
				stmt.close();
				stmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		return formNo;
	}
	public String getCustomerDetail(Document domAll, String userId,String formName,String objContext, Connection connectionObject) throws ITMException 
	{
		System.out.println("Inside getCustomerDetail methods.............................:-  ");
		ResultSet rs = null;
		PreparedStatement pstmt = null;

		String strgCode = "";
		String strgName="",strgLocality="",strgLocalityDescr="",strgQualification="",strgSpecility="",strgSpecilitydescr="";
		int currentFormNo=0;
		int domID = 1;
		int lineNumber=1;
		String sqlTranId="";

		String sqlStrgCode="";
		String sqlSelected="";
		String brandCode="";
		String brandDescr="";
		String tranID="";
		String selStrgCode = "";
		String selBrandCode = "",brandCodeheader;
        String category="";
		String stateCode="";
		String doctors="";
		String classCode="";
		String stateDescr="",sqlNonSelected="";
		StringBuffer valueXmlString = new StringBuffer();
		GenericUtility genericUtility = GenericUtility.getInstance();
		ArrayList customers = new ArrayList();

		StringBuffer custBuff = new StringBuffer();
		HashMap selStrgMap = new HashMap();
		if( objContext != null && objContext.trim().length() > 0 )
		{
			currentFormNo = Integer.parseInt( objContext );
		}

		////System.out.println("*******currentFormNo***********************" +currentFormNo);
		try 
		{

			brandCodeheader = checkNull(genericUtility.getColumnValue( "brand_code" , domAll ,"1"));
			String brandCodeDoctor = checkNull(genericUtility.getColumnValue( "brand_code" , domAll));
			String salesPerson = getEmpCode(userId, connectionObject);
			String  campaignId = checkNull(genericUtility.getColumnValue( "campgn_id",domAll ,"1"));
			
			System.out.println("Inside getCustomerDetail method campaignId............................:-"+campaignId);
			System.out.println("Inside getCustomerDetail from header method brandCode............................:-"+brandCodeheader);
		System.out.println("Inside getCustomerDetail method brandCodeDoctor............................:-"+brandCodeDoctor);

		//Added by mtunalini SInkar fro grade day
		int graceDays=0;

		String sql = "SELECT GRACE_DAYS FROM STRG_CAMPAIGN  WHERE CAMPGN_ID = ? ";
		pstmt = connectionObject.prepareStatement(sql);
		pstmt.setString(1, campaignId);
		rs = pstmt.executeQuery();
		if ( rs.next() )
		{
			graceDays = rs.getInt("GRACE_DAYS");

		}
		if ( rs != null )
		{
			rs.close();
			rs = null;
		}
		if ( pstmt != null )
		{
			pstmt.close();
			pstmt = null;
		}
		
		
		
			sqlTranId="select max(SC.tran_id)  as tran_id from SPRS_CAMPGN SC,SPRS_CAMPGN_STRG SCMPS "
					+ "where tran_date =(select max(a.tran_date) from SPRS_CAMPGN a, STRG_CAMPAIGN b, SPRS_CAMPGN_STRG c where a.CAMPGN_ID = b.CAMPGN_ID and a.tran_date between b.eff_from and b.valid_upto+? and a.sales_pers =? and a.tran_type='D' AND c.TRAN_ID=a.TRAN_ID AND c.BRAND_CODE=? and b.CAMPGN_ID=? ) "
					+ "and sales_pers = ? and tran_type= ? and campgn_id=? AND SC.tran_id=SCMPS.tran_id AND SCMPS.BRAND_CODE=?";  // adding campaignId 3032021 issue raised by qc then changes
			pstmt =  connectionObject.prepareStatement(sqlTranId);
            pstmt.setInt(1, graceDays);
			pstmt.setString(2, salesPerson);
            pstmt.setString(3, brandCodeheader);
            pstmt.setString(4,campaignId);       // adding campaignId 3032021 issue raised by qc then changes
			pstmt.setString(5, salesPerson);
            pstmt.setString(6, "D");
            pstmt.setString(7,campaignId);       // adding campaignId 3032021 issue raised by qc then changes
            pstmt.setString(8,brandCodeheader);       // adding campaignId 3032021 issue raised by qc then changes

			rs = pstmt.executeQuery();
			if (rs.next())                           
			{
				tranID=checkNull(rs.getString("tran_id"));
			    System.out.println("Inside getCustomerDetail method tranID............................:-"+tranID);

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

			 if( tranID != null && tranID.trim().length()>0 )    //added by shweta issue raised by QC 25-03-2021 
			 {
				 sqlStrgCode="select strg_code, brand_code from sprs_campgn_strg where tran_id =? and brand_code=?";
				 pstmt =  connectionObject.prepareStatement(sqlStrgCode);
				 pstmt.setString(1, tranID);
				 pstmt.setString(2, brandCodeheader);

				 rs = pstmt.executeQuery();
				 while(rs.next())
				 {
					 selStrgCode=checkNull(rs.getString("strg_code"));
					 selBrandCode=checkNull(rs.getString("brand_code"));
					System.out.println("Inside getCustomerDetail method doctor............................:-"+selStrgCode);
					 System.out.println("Inside getCustomerDetail method brand Code............................:-"+selBrandCode);
					 selStrgMap.put(selStrgCode, selBrandCode);
					 //customers.add(selStrgCode);
					 if( custBuff.length() == 0)
					 {
						 custBuff.append("'").append(selStrgCode).append("'");
					 }
					 else
					 {
						 custBuff.append(",'").append(selStrgCode).append("'");
					 }


				 }

				 if (rs!= null)
				 {
					 rs.close();
					 rs = null;
				 }
				 if(pstmt!=null)
				 {
					 pstmt.close();
					 pstmt = null;
				 }


				 if( doctors == null || doctors.length() == 0 )
				 {
					 doctors = "'x'";
				 }

				 custBuff.toString();

				 //	//System.out.println("customers::::["+customers);
				System.out.println("custBuff::::["+custBuff);
				System.out.println("doctors::::["+doctors);


				/* sqlSelected="SELECT DISTINCT(SC.SC_CODE) CODE,UPPER(SC.FIRST_NAME)||' '||UPPER(SC.MIDDLE_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME, " +
						 "SC.QUALIFICATION,SP.SPL_CODE,SC.STATE_CODE,SS.CLASS_CODE,SP.DESCR,L.LOCALITY_CODE,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) LOC_DESCR " +
						 "FROM STRG_CUSTOMER SC,SPRS_CAMPGN_STRG SPCS,LOCALITY L,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE " +
						 "LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS ON SS.CLASS_CODE=SCS.SUBCLASS_CODE AND SS.CUST_TYPE=SCS.CUST_TYPE " +
						 "AND SS.SUBCLASS_CODE=SCS.SUBCLASS_CODE,SPRS_ROUTE SR " +
						 "WHERE SS.SC_CODE = SC.SC_CODE AND SR.SPRS_CODE=SS.SALES_PERS AND SR.ROUTE_ID=SS.ROUTE_ID " +
						 "AND SR.LOCALITY_CODE=L.LOCALITY_CODE AND (SC.LOCALITY_CODE=L.LOCALITY_CODE OR SC.RES_LOCALITY_CODE=L.LOCALITY_CODE) " +
						 "AND SS.SALES_PERS = ? AND SS.STATUS IN('Y','A') AND SR.STATUS='Y' AND SC.SC_CODE NOT IN("+doctors+") ORDER BY SC_NAME ";  */
				
				/* Commented by prachi on 03- March- 2022
				 sqlSelected="SELECT DISTINCT(SC.SC_CODE) CODE,UPPER(SC.FIRST_NAME)||' '||UPPER(SC.MIDDLE_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME, " +
						 "SC.QUALIFICATION,SP.SPL_CODE,SC.STATE_CODE,SS.CLASS_CODE,SP.DESCR,L.LOCALITY_CODE,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) LOC_DESCR " +
						 "FROM STRG_CUSTOMER SC,LOCALITY L,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE " +
						 "LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS ON SS.CLASS_CODE=SCS.SUBCLASS_CODE AND SS.CUST_TYPE=SCS.CUST_TYPE " +
						 "AND SS.SUBCLASS_CODE=SCS.SUBCLASS_CODE,SPRS_ROUTE SR " +
						 "WHERE SS.SC_CODE = SC.SC_CODE AND SR.SPRS_CODE=SS.SALES_PERS AND SR.ROUTE_ID=SS.ROUTE_ID " +
						 "AND SR.LOCALITY_CODE=L.LOCALITY_CODE AND SC.LOCALITY_CODE=L.LOCALITY_CODE  " +    // removing OR SC.RES_LOCALITY_CODE=L.LOCALITY_CODE for preventing double customer in list done by shweta m 13-05-21
						 "AND SS.SALES_PERS = ? AND SS.STATUS IN('Y','A') AND SR.STATUS='Y' AND SC.SC_CODE NOT IN("+doctors+") AND SC.CUST_TYPE='D'  ORDER BY SC_NAME ";
				 */
				System.out.println("PK SQL 1");
				 sqlSelected="SELECT DISTINCT(SC.SC_CODE) CODE,UPPER(SC.FIRST_NAME)||' '||UPPER(SC.MIDDLE_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME, " +
						 "SC.QUALIFICATION,SP.SPL_CODE,SC.STATE_CODE,SS.CLASS_CODE,SP.DESCR,SS.CATEGORY,L.LOCALITY_CODE,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) LOC_DESCR " +
						 "FROM STRG_CUSTOMER SC,LOCALITY L,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE " +
						 "LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS ON SS.CLASS_CODE=SCS.SUBCLASS_CODE AND SS.CUST_TYPE=SCS.CUST_TYPE " +
						 "AND SS.SUBCLASS_CODE=SCS.SUBCLASS_CODE,SPRS_ROUTE SR " +
						 "WHERE SS.SC_CODE = SC.SC_CODE AND SR.SPRS_CODE=SS.SALES_PERS AND SR.ROUTE_ID=SS.ROUTE_ID " +
						 "AND SR.LOCALITY_CODE=L.LOCALITY_CODE AND SC.LOCALITY_CODE=L.LOCALITY_CODE  " +    // removing OR SC.RES_LOCALITY_CODE=L.LOCALITY_CODE for preventing double customer in list done by shweta m 13-05-21
						 "AND SS.SALES_PERS = ? AND SS.STATUS IN('Y','A') AND SR.STATUS='Y' AND SC.SC_CODE NOT IN("+doctors+") AND SC.CUST_TYPE='D'  ORDER BY SC_NAME ";

				 pstmt =  connectionObject.prepareStatement( sqlSelected );
				 pstmt.setString(1, checkNull(userId));
				 rs=pstmt.executeQuery();
				 while(rs.next())
				 {
					 strgCode = checkNull(rs.getString("CODE"));
					 strgName= checkNull(rs.getString("SC_NAME"));
					 strgLocality= checkNull(rs.getString("LOCALITY_CODE"));
					 strgLocalityDescr= checkNull(rs.getString("LOC_DESCR"));
					 strgQualification = checkNull(rs.getString("QUALIFICATION"));
					 strgSpecility = checkNull(rs.getString("SPL_CODE"));
					 strgSpecilitydescr=checkNull(rs.getString("DESCR"));
					 stateCode=checkNull(rs.getString("STATE_CODE"));
					 classCode=checkNull(rs.getString("CLASS_CODE"));
					 category=checkNull(rs.getString("CATEGORY"));


					 if(selStrgMap != null &&  selStrgMap.containsKey(strgCode))
					 {
						 valueXmlString.append( "<Detail"+currentFormNo+" domID='"+domID+"' selected = 'Y' formName='"+formName+"'>\r\n" );
						 valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");

						 brandCode = (String)selStrgMap.get(strgCode);
						 System.out.println("brand Code inside if............................:-"+brandCode);

						 brandDescr = getBrandDescr(brandCode, connectionObject);
						 stateDescr=getStateDescr(stateCode,connectionObject);

						System.out.println("brand Code descr............................:-"+brandDescr);
						System.out.println("state Code descr............................:-"+stateDescr);

						 valueXmlString.append( "<line_no><![CDATA[" ).append(lineNumber).append( "]]></line_no>\r\n" );
						 valueXmlString.append( "<strg_code><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
						 valueXmlString.append( "<strg_descr><![CDATA[" ).append(strgName).append( "]]></strg_descr>\r\n" );
						 valueXmlString.append( "<locality><![CDATA[" ).append(strgLocality).append( "]]></locality>\r\n" );
						 valueXmlString.append( "<locality_descr><![CDATA[" ).append(strgLocalityDescr).append( "]]></locality_descr>\r\n" );
						 valueXmlString.append( "<qualification><![CDATA[" ).append(strgQualification).append( "]]></qualification>\r\n" );
						 valueXmlString.append( "<specility><![CDATA[" ).append(strgSpecilitydescr).append( "]]></specility>\r\n" );
						 valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
                         valueXmlString.append( "<brand_code><![CDATA[").append(brandCode).append("]]></brand_code>\r\n");
                         valueXmlString.append( "<brand_description><![CDATA[").append(brandDescr).append("]]></brand_description>\r\n");
                         valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
						 valueXmlString.append( "<class_code><![CDATA[").append(classCode).append("]]></class_code>\r\n");
						 valueXmlString.append( "<state><![CDATA[").append(stateDescr).append("]]></state>\r\n");
						 //ADDED BY PRACHI
						 valueXmlString.append( "<category><![CDATA[").append(category).append("]]></category>\r\n");
						 valueXmlString.append("</Detail"+currentFormNo+">\r\n");
						 lineNumber++;
						 domID++;


					 }
					 /*else
				{
					valueXmlString.append( "<Detail"+currentFormNo+" domID='"+domID+"' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
				}
				valueXmlString.append( "<line_no><![CDATA[" ).append(lineNumber).append( "]]></line_no>\r\n" );
				valueXmlString.append( "<strg_code><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
				valueXmlString.append( "<strg_descr><![CDATA[" ).append(strgName).append( "]]></strg_descr>\r\n" );
				valueXmlString.append( "<locality><![CDATA[" ).append(strgLocality).append( "]]></locality>\r\n" );
				valueXmlString.append( "<locality_descr><![CDATA[" ).append(strgLocalityDescr).append( "]]></locality_descr>\r\n" );
				valueXmlString.append( "<qualification><![CDATA[" ).append(strgQualification).append( "]]></qualification>\r\n" );
				valueXmlString.append( "<specility><![CDATA[" ).append(strgSpecilitydescr).append( "]]></specility>\r\n" );
				valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
				valueXmlString.append( "<brand_code><![CDATA[").append(brandCode).append("]]></brand_code>\r\n");
				valueXmlString.append( "<brand_description><![CDATA[").append(brandDescr).append("]]></brand_description>\r\n");
				valueXmlString.append( "<class_code><![CDATA[").append(classCode).append("]]></class_code>\r\n");
				valueXmlString.append( "<state><![CDATA[").append(stateDescr).append("]]></state>\r\n");
				valueXmlString.append("</Detail"+currentFormNo+">\r\n");
				lineNumber++;
				domID++;*/
				 }
				 if (rs!= null)
				 {
					 rs.close();
					 rs = null;
				 }
				 if(pstmt!=null)
				 {
					 pstmt.close();
					 pstmt = null;
				 }

				 /*brandCode = (String)selStrgMap.get(strgCode);
			//System.out.println("brand Code "+brandCode);*/

				 brandDescr = getBrandDescr(brandCodeheader, connectionObject);
				 stateDescr=getStateDescr(stateCode,connectionObject);

				 ////System.out.println("brand Code descr::::::["+brandDescr);
				 ////System.out.println("state Code descr::::::["+stateDescr);

				/* sqlNonSelected="SELECT DISTINCT(SC.SC_CODE) CODE,UPPER(SC.FIRST_NAME)||' '||UPPER(SC.MIDDLE_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME, " +
						 "SC.QUALIFICATION,SP.SPL_CODE,SC.STATE_CODE,SS.CLASS_CODE,SP.DESCR,L.LOCALITY_CODE,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) LOC_DESCR " +
						 "FROM STRG_CUSTOMER SC,SPRS_CAMPGN_STRG SPCS,LOCALITY L,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE " +
						 "LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS ON SS.CLASS_CODE=SCS.SUBCLASS_CODE AND SS.CUST_TYPE=SCS.CUST_TYPE " +
						 "AND SS.SUBCLASS_CODE=SCS.SUBCLASS_CODE,SPRS_ROUTE SR " +
						 "WHERE SS.SC_CODE = SC.SC_CODE AND SR.SPRS_CODE=SS.SALES_PERS AND SR.ROUTE_ID=SS.ROUTE_ID " +
						 "AND SR.LOCALITY_CODE=L.LOCALITY_CODE AND (SC.LOCALITY_CODE=L.LOCALITY_CODE OR SC.RES_LOCALITY_CODE=L.LOCALITY_CODE) " +
						 "AND SS.SALES_PERS = ? AND SS.STATUS IN('Y','A') AND SR.STATUS='Y' AND SC.SC_CODE NOT IN("+custBuff+") ORDER BY SC_NAME "; */ // commented by shweta 13-05-21
                 
				 //SS.CATEGORY in sql added by prachi
				 System.out.println("PK SQL 2");
				 sqlNonSelected="SELECT DISTINCT(SC.SC_CODE) CODE,UPPER(SC.FIRST_NAME)||' '||UPPER(SC.MIDDLE_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME, " +
						 "SC.QUALIFICATION,SP.SPL_CODE,SS.CATEGORY,SC.STATE_CODE,SS.CLASS_CODE,SP.DESCR,L.LOCALITY_CODE,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) LOC_DESCR " +
						 "FROM STRG_CUSTOMER SC,LOCALITY L,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE " +
						 "LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS ON SS.CLASS_CODE=SCS.SUBCLASS_CODE AND SS.CUST_TYPE=SCS.CUST_TYPE " +
						 "AND SS.SUBCLASS_CODE=SCS.SUBCLASS_CODE,SPRS_ROUTE SR " +
						 "WHERE SS.SC_CODE = SC.SC_CODE AND SR.SPRS_CODE=SS.SALES_PERS AND SR.ROUTE_ID=SS.ROUTE_ID " +
						 "AND SR.LOCALITY_CODE=L.LOCALITY_CODE AND SC.LOCALITY_CODE=L.LOCALITY_CODE " +    // removing OR SC.RES_LOCALITY_CODE=L.LOCALITY_CODE for prevting double customer list done by shweta 13-05-21
						 "AND SS.SALES_PERS = ? AND SS.STATUS IN('Y','A') AND SR.STATUS='Y' AND SC.SC_CODE NOT IN("+custBuff+") AND SC.CUST_TYPE='D' ORDER BY SC_NAME ";
				 pstmt =  connectionObject.prepareStatement( sqlNonSelected );
				 pstmt.setString(1, checkNull(userId));
				 rs=pstmt.executeQuery();
				 while(rs.next())
				 {
					 strgCode = checkNull(rs.getString("CODE"));
					 strgName= checkNull(rs.getString("SC_NAME"));
					 strgLocality= checkNull(rs.getString("LOCALITY_CODE"));
					 strgLocalityDescr= checkNull(rs.getString("LOC_DESCR"));
					 strgQualification = checkNull(rs.getString("QUALIFICATION"));
					 strgSpecility = checkNull(rs.getString("SPL_CODE"));
					 strgSpecilitydescr=checkNull(rs.getString("DESCR"));
					 stateCode=checkNull(rs.getString("STATE_CODE"));
					 classCode=checkNull(rs.getString("CLASS_CODE"));
					 category=checkNull(rs.getString("CATEGORY"));


					 valueXmlString.append( "<Detail"+currentFormNo+" domID='"+domID+"' selected = 'N' formName='"+formName+"'>\r\n" );
					 valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					 valueXmlString.append( "<line_no><![CDATA[" ).append(lineNumber).append( "]]></line_no>\r\n" );
					 valueXmlString.append( "<strg_code><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
					 valueXmlString.append( "<strg_descr><![CDATA[" ).append(strgName).append( "]]></strg_descr>\r\n" );
					 valueXmlString.append( "<locality><![CDATA[" ).append(strgLocality).append( "]]></locality>\r\n" );
					 valueXmlString.append( "<locality_descr><![CDATA[" ).append(strgLocalityDescr).append( "]]></locality_descr>\r\n" );
					 valueXmlString.append( "<qualification><![CDATA[" ).append(strgQualification).append( "]]></qualification>\r\n" );
					 valueXmlString.append( "<specility><![CDATA[" ).append(strgSpecilitydescr).append( "]]></specility>\r\n" );
					 valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
					 valueXmlString.append( "<brand_code><![CDATA[").append(brandCodeheader).append("]]></brand_code>\r\n");
                     valueXmlString.append( "<brand_description><![CDATA[").append(brandDescr).append("]]></brand_description>\r\n");
                     valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
					 valueXmlString.append( "<class_code><![CDATA[").append(classCode).append("]]></class_code>\r\n");
					 valueXmlString.append( "<state><![CDATA[").append(stateDescr).append("]]></state>\r\n");
					 
					 valueXmlString.append( "<category><![CDATA[").append(category).append("]]></category>\r\n");
					 
					 valueXmlString.append("</Detail"+currentFormNo+">\r\n");
					 lineNumber++;
					 domID++;

				 }
				 if (rs!= null)
				 {
					 rs.close();
					 rs = null;
				 }
				 if(pstmt!=null)
				 {
					 pstmt.close();
					 pstmt = null;
				 }
			 }                                // added by shweta issue raised by 25-03-2021  start
           else
           {

        	   brandDescr = getBrandDescr(brandCodeheader, connectionObject);
        	   stateDescr=getStateDescr(stateCode,connectionObject);

        	  // //System.out.println("brand Code descr::::::["+brandDescr);
        	   ////System.out.println("state Code descr::::::["+stateDescr);
        	   
        	 /*  String doctorList="select distinct(SC.SC_CODE) CODE,UPPER(SC.FIRST_NAME)||' '||UPPER(SC.MIDDLE_NAME)||' '||UPPER(SC.LAST_NAME) as SC_NAME, " + 
        			   "SC.QUALIFICATION,SP.SPL_CODE,L.LOCALITY_CODE,SC.STATE_CODE,SS.CLASS_CODE,SP.DESCR,L.LOCALITY_CODE, " + 
        			   "(case when SR.ROUTE_DESCR is not null then SR.ROUTE_DESCR else SR.DESCR end ) LOC_DESCR  " + 
        			   "from STRG_CUSTOMER SC, SPRS_CAMPGN SPC, LOCALITY L,STRG_SERIES SS left outer join SPECIALITY SP on SP.SPL_CODE = SS.SPL_CODE  " + 
        			   "left outer join STRG_CUST_SUBCLASS SCS on SS.CLASS_CODE=SCS.SUBCLASS_CODE and SS.CUST_TYPE=SCS.CUST_TYPE  " + 
        			   "and SS.SUBCLASS_CODE=SCS.SUBCLASS_CODE,SPRS_ROUTE SR  " + 
        			   "where SS.SC_CODE = SC.SC_CODE and SR.SPRS_CODE=SS.SALES_PERS and SR.ROUTE_ID=SS.ROUTE_ID " + 
        			   "and SR.LOCALITY_CODE=L.LOCALITY_CODE and (SC.LOCALITY_CODE=L.LOCALITY_CODE or SC.RES_LOCALITY_CODE=L.LOCALITY_CODE)  " +
        			   "and SR.LOCALITY_CODE=L.LOCALITY_CODE and (SC.LOCALITY_CODE=L.LOCALITY_CODE )  " +   
        			   "and SS.SALES_PERS =?  and SS.STATUS in('Y','A') and SR.STATUS='Y' ORDER BY SC_NAME "; */ // commented by shweta m 13-05-21
        	   System.out.println("PK SQL 3");
        	   String doctorList="select distinct(SC.SC_CODE) CODE,UPPER(SC.FIRST_NAME)||' '||UPPER(SC.MIDDLE_NAME)||' '||UPPER(SC.LAST_NAME) as SC_NAME, " + 
        			   "SC.QUALIFICATION,SP.SPL_CODE,SS.CATEGORY,L.LOCALITY_CODE,SC.STATE_CODE,SS.CLASS_CODE,SP.DESCR,L.LOCALITY_CODE, " + 
        			   "(case when SR.ROUTE_DESCR is not null then SR.ROUTE_DESCR else SR.DESCR end ) LOC_DESCR  " + 
        			   "from STRG_CUSTOMER SC, LOCALITY L,STRG_SERIES SS left outer join SPECIALITY SP on SP.SPL_CODE = SS.SPL_CODE  " + 
        			   "left outer join STRG_CUST_SUBCLASS SCS on SS.CLASS_CODE=SCS.SUBCLASS_CODE and SS.CUST_TYPE=SCS.CUST_TYPE  " + 
        			   "and SS.SUBCLASS_CODE=SCS.SUBCLASS_CODE,SPRS_ROUTE SR  " + 
        			   "where SS.SC_CODE = SC.SC_CODE and SR.SPRS_CODE=SS.SALES_PERS and SR.ROUTE_ID=SS.ROUTE_ID " + 
        			   "and SR.LOCALITY_CODE=L.LOCALITY_CODE and SC.LOCALITY_CODE=L.LOCALITY_CODE  " +  // removing  or SC.RES_LOCALITY_CODE=L.LOCALITY_CODE for duplicate customer show in list done by shweta m 13-05-21
        			   "and SS.SALES_PERS =?  and SS.STATUS in('Y','A') and SR.STATUS='Y' AND SC.CUST_TYPE='D' ORDER BY SC_NAME ";
        	   pstmt =  connectionObject.prepareStatement(doctorList);
        	 //  pstmt.setString(1, campaignId);  // commeted by shweta after qc issue 30-03-2021
        	   pstmt.setString(1, salesPerson);
        	   rs = pstmt.executeQuery();
        	   while(rs.next())
        	   {
        		   strgCode = checkNull(rs.getString("CODE"));
        		   strgName= checkNull(rs.getString("SC_NAME"));
        		   strgLocality= checkNull(rs.getString("LOCALITY_CODE"));
        		   strgLocalityDescr= checkNull(rs.getString("LOC_DESCR"));
        		   strgQualification = checkNull(rs.getString("QUALIFICATION"));
        		   strgSpecility = checkNull(rs.getString("SPL_CODE"));
        		   strgSpecilitydescr=checkNull(rs.getString("DESCR"));
        		   stateCode=checkNull(rs.getString("STATE_CODE"));
        		   classCode=checkNull(rs.getString("CLASS_CODE"));
        		   category=checkNull(rs.getString("CATEGORY"));

        		   valueXmlString.append( "<Detail"+currentFormNo+" domID='"+domID+"' selected = 'N' formName='"+formName+"'>\r\n" );
        		   valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
        		   valueXmlString.append( "<line_no><![CDATA[" ).append(lineNumber).append( "]]></line_no>\r\n" );
        		   valueXmlString.append( "<strg_code><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
        		   valueXmlString.append( "<strg_descr><![CDATA[" ).append(strgName).append( "]]></strg_descr>\r\n" );
        		   valueXmlString.append( "<locality><![CDATA[" ).append(strgLocality).append( "]]></locality>\r\n" );
        		   valueXmlString.append( "<locality_descr><![CDATA[" ).append(strgLocalityDescr).append( "]]></locality_descr>\r\n" );
        		   valueXmlString.append( "<qualification><![CDATA[" ).append(strgQualification).append( "]]></qualification>\r\n" );
        		   valueXmlString.append( "<specility><![CDATA[" ).append(strgSpecilitydescr).append( "]]></specility>\r\n" );
        		   valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
        		   valueXmlString.append( "<brand_code><![CDATA[").append(brandCodeheader).append("]]></brand_code>\r\n");
                   valueXmlString.append( "<brand_description><![CDATA[").append(brandDescr).append("]]></brand_description>\r\n");
                   valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
        		   valueXmlString.append( "<class_code><![CDATA[").append(classCode).append("]]></class_code>\r\n");
        		   valueXmlString.append( "<state><![CDATA[").append(stateDescr).append("]]></state>\r\n");
        		   valueXmlString.append( "<category><![CDATA[").append(category).append("]]></category>\r\n");
        		   
        		   valueXmlString.append("</Detail"+currentFormNo+">\r\n");
        		   lineNumber++;
        		   domID++;

        	   }
        	   if (rs!= null)
        	   {
        		   rs.close();
        		   rs = null;
        	   }
        	   if(pstmt!=null)
        	   {
        		   pstmt.close();
        		   pstmt = null;
        	   }

           }// added by shweta issue raised by 25-03-2021 end






		}
		catch(Exception e)
		{
			//System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getCustomerDetail():" + e.getMessage() + ":" );
			e.printStackTrace();
			throw new ITMException(e); 
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				//System.out.println( "Exception :SprsCampgnWiz :getCustomerDetail :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();

	}
	public String getBrandDescr(String brandCode, Connection connectionObject) throws ITMException 
	{
		////System.out.println("Inside getBrandDescr method.............................  ");
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String sql="";
		String brandDescr="";
		try 
		{
			////System.out.println("Inside getBrandDescr method.............................:"+brandCode);
			if (brandCode != null && brandCode.trim().length()>0)
			{
				////System.out.println("Inside if brandcode .............................:"+brandCode);
				//brandCode = brandCode.replaceAll(",", "','");
				//brandCode = "'" + brandCode + "'";

				sql = "SELECT DESCRIPTION FROM BRAND WHERE BRAND_CODE in"+E12GenericUtility.getFormattedProfileId(brandCode);
				pstmt =  connectionObject.prepareStatement(sql);
				// pstmt.setString(1, brandCode);
				rs = pstmt.executeQuery();
				if ( brandCode.indexOf(",")  != -1)
				{
					while( rs.next() )
					{	
						brandDescr = brandDescr + checkNull(rs.getString("DESCRIPTION")) + ", ";
						////System.out.println("Description of brand ========>"+brandDescr);
					}

				}

				else
				{	
					if( rs.next() )
					{
						brandDescr = checkNull(rs.getString("DESCRIPTION"));
						////System.out.println(" else if loop :::: ="+brandDescr);
					}
				}

				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

			}

		}
		catch(Exception e)
		{
			////System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getCustomerDetail():" + e.getMessage() + ":" );
			//e.printStackTrace();
			throw new ITMException(e); 
		}

		return brandDescr;

	}
	public String getStateDescr(String stateCode, Connection connectionObject) throws ITMException 
	{
		//System.out.println("Inside getBrandDescr method.............................  ");
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String sql="";
		String stateDescr="";
		try 
		{
			//System.out.println("Inside getBrandDescr method.............................:"+stateCode);
			if (stateCode != null && stateCode.trim().length()>0)
			{
				//System.out.println("Inside if brandcode .............................:"+stateCode);
				//brandCode = brandCode.replaceAll(",", "','");
				//brandCode = "'" + brandCode + "'";

				sql = "SELECT DESCR FROM STATE WHERE STATE_CODE =?";
				pstmt =  connectionObject.prepareStatement(sql);
				pstmt.setString(1, stateCode);
				rs = pstmt.executeQuery();

				if( rs.next() )
				{
					stateDescr = checkNull(rs.getString("DESCR"));
					//System.out.println(" state descr in statedescription method ="+stateDescr);
				}
			}

			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			//System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getCustomerDetail():" + e.getMessage() + ":" );
			e.printStackTrace();
			throw new ITMException(e); 
		}

		return stateDescr;

	}
	private String getAttributeVal(Node parentNode, String attribName)throws ITMException
	{
		String attribVal = "";
		try
		{
			NodeList childList = parentNode.getChildNodes();
			int noOfChilds = childList.getLength();

			for (int ctr = 0; ctr < noOfChilds; ctr++)
			{
				Node childNode = childList.item( ctr );
				String childNodeName = childNode.getNodeName();
				if("attribute".equalsIgnoreCase(childNodeName))
				{
					if(childNode.getAttributes().getNamedItem(attribName) != null)
					{
						attribVal = childNode.getAttributes().getNamedItem(attribName).getNodeValue();
						break;
					}
				}
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		//System.out.println("attribVal = ["+attribVal+"]");
		return attribVal;
	}

}