package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.util.*;
import java.util.Date;
import java.text.DateFormat;
import java.sql.*;

import javax.ejb.*;
import javax.naming.InitialContext;
import org.w3c.dom.*;

import javax.xml.parsers.*;
import java.text.SimpleDateFormat;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;
import ibase.system.config.*;
import ibase.webitm.utility.ITMException;
import ibase.utility.E12GenericUtility;
//import ibase.webitm.utility.GenericUtility;


//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].

public class MeetAndTravelPos extends ValidatorEJB implements  MeetAndTravelPosRemote,MeetAndTravelPosLocal // implements SessionBean
{


	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	public String postSave(String tranId,String editFlag, String xtraParams, Connection conn, String domString) throws RemoteException,ITMException
	{
		//changed by Rahul Barve on 3-sep-2014
		//Document dom =  GenericUtility.getInstance().parseString(domString);
		Document dom = new ibase.utility.E12GenericUtility().parseString(domString);

		try
		{

			System.out.println("Total Dom Str++++++++++++++++["+domString+"]");
			processDelOperation(dom,dom, "W_MEETANDTRAVELPROCESS", xtraParams, conn);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}

		return "";
	}


	public String processDelOperation(Document dom, Document dom2, String windowName, String xtraParams,Connection conn) throws RemoteException,ITMException
	{
		String returnString = "";
		String userId  =  "";

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			if(conn != null)
			{
				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB( "DriverITM" );
			}

			ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			HashMap objDetailMap = null;
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext initialContext = new InitialContext(appConnect.getProperty());
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//ITMDBAccessRemote itmDBAccess = (ITMDBAccessRemote)initialContext.lookup("ibase/ITMDBAccessEJB/remote");
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			String eventDate = checkNull(genericUtility.getColumnValue( "event_date", dom2 ));
			String salesPers = checkNull(genericUtility.getColumnValue( "sales_pers", dom2 ));
			System.out.println("In process MeetAndTravelProcessEJB ["+eventDate+"]["+salesPers+"]");
			if(eventDate == "")
			{
				returnString = itmDBAccess.getErrorString("","EVNTDTBLNK",userId);
			}
			else
			{
				String query = "SELECT SALES_PERS FROM SALES_PERS WHERE SALES_PERS = ?";
				pstmt =  conn.prepareStatement(query);
				pstmt.setString(1, salesPers);
				rs = pstmt.executeQuery();
				if( !rs.next() )
				{
					returnString = itmDBAccess.getErrorString("","INVSLSPERS",userId);
				}
				else
				{
					String sql = "SELECT TOUR_ID FROM TOUR WHERE ? BETWEEN DATE_FROM AND DATE_TO AND EMP_CODE = ?";
					pstmt =  conn.prepareStatement(sql);
					pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
					pstmt.setString(2, salesPers);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						returnString = itmDBAccess.getErrorString("","METCNBEDLT",userId);
					}
					else
					{
						String sql0 = "SELECT TRAN_ID FROM STRG_MEET WHERE EVENT_DATE = ? AND SALES_PERS = ?";
						pstmt =  conn.prepareStatement(sql0);
						pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
						pstmt.setString(2, salesPers);
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							String tranId= rs.getString("TRAN_ID");
							String sql3 = "DELETE FROM STRG_MEET_ITEMS WHERE TRAN_ID = ? ";
							pstmt =  conn.prepareStatement(sql3);
							pstmt.setString(1, tranId);
							pstmt.executeQuery();
							String sql4 = "DELETE FROM STRG_MEET_TEAM WHERE TRAN_ID = ? ";
							pstmt =  conn.prepareStatement(sql4);
							pstmt.setString(1, tranId);
							pstmt.executeQuery();
							while(rs.next())
							{
								tranId= rs.getString("TRAN_ID");
								pstmt =  conn.prepareStatement(sql3);
								pstmt.setString(1, tranId);
								pstmt.executeQuery();
								pstmt =  conn.prepareStatement(sql4);
								pstmt.setString(1, tranId);
								pstmt.executeQuery();
							}
							String sql1 = "DELETE FROM SPRS_TRAVEL WHERE TRAVEL_DATE = ? AND SALES_PERS = ?";
							String sql2 = "DELETE FROM STRG_MEET WHERE EVENT_DATE = ? AND SALES_PERS = ?";
							pstmt =  conn.prepareStatement(sql1);
							pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
							pstmt.setString(2, salesPers);
							rs = pstmt.executeQuery();
							pstmt =  conn.prepareStatement(sql2);
							pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
							pstmt.setString(2, salesPers);
							rs = pstmt.executeQuery();
							//changed by deepak for deleting data from SPRS_ACT_TRAN table for request id [WS89NOV541] .Start
							String sql5 = "DELETE FROM SPRS_ACT_TRAN WHERE EVENT_DATE = ? AND SALES_PERS =? ";
							pstmt =  conn.prepareStatement(sql5);
							pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
							pstmt.setString(2, salesPers);
							rs = pstmt.executeQuery();
							System.out.println("Data From SPRS_ACT_TRAN is deleted");
							//changed by deepak for deleting data from SPRS_ACT_TRAN table for request id [WS89NOV541] .End

							returnString = itmDBAccess.getErrorString("","METATRADLT",userId);
						}
						else
						{
							returnString = itmDBAccess.getErrorString("","NODTTOTDLT",userId);
						}
					}
				}
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( conn != null )
				{
					conn.close();
				}
				if ( pstmt != null )
				{
					pstmt.close();
				}
				if ( rs != null )
				{
					rs.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return returnString;
	}

	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}

}

