/*
 * Decompiled with CFR 0.152.
 */
package ibase.system.config.jca;

import ibase.system.config.ConnDriver;
import ibase.system.config.jca.BaseDBConnection;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import org.jboss.jca.adapters.jdbc.WrappedConnection;

public class ConnDriverJCA
extends ConnDriver {
    public ConnDriverJCA() {
        this.data_source_name = "";
        this.driver_name = "";
        this.driver_url = "";
        this.database_username = "";
        this.database_password = "";
        this.database_autocommit = "";
    }

    @Override
    public Connection getConnectDB() throws Exception {
        Connection connection = null;
        try {
            connection = this.getConnectDB("Driver");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Connection Not Established");
            BaseLogger.log("0", null, null, "Exception: ConnDriver: getConnectDB: Generic Exception==>\n" + e);
            throw e;
        }
        return connection;
    }

    @Override
    public Connection getConnectDB(String dataPropFileName) throws Exception {
        BaseDBConnection connection = null;
        this.setDatabaseVariable(dataPropFileName);
        try {
            BaseLogger.log("3", null, null, "Is Pool :" + this.isPool);
            if (!this.isPool) {
                connection = new BaseDBConnection(this.driver_name, this.driver_url, this.database_username, this.database_password, this.database_autocommit);
            } else {
                BaseLogger.log("3", null, null, "Datasource Name :" + this.data_source_name);
                connection = new BaseDBConnection(this.data_source_name, this.database_autocommit, dataPropFileName);
            }
        }
        catch (ClassNotFoundException cfe) {
            BaseLogger.log("0", null, null, "Connection Not Established([" + this.driver_name + "][" + this.driver_url + "][" + this.database_username + "] ?????????");
            BaseLogger.log("0", null, null, "Exception: ConnDriver: getConnectDB(String): Class Not Found==>\n" + cfe);
            cfe.printStackTrace();
            throw cfe;
        }
        catch (SQLException sqle) {
            BaseLogger.log("0", null, null, "Connection Not Established([" + this.driver_name + "][" + this.driver_url + "][" + this.database_username + "] ?????????");
            BaseLogger.log("0", null, null, "Exception: ConnDriver: getConnectDB(String): SQLException==>\n" + sqle);
            sqle.printStackTrace();
            throw sqle;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Connection Not Established([" + this.driver_name + "][" + this.driver_url + "][" + this.database_username + "] ?????????");
            BaseLogger.log("0", null, null, "Exception: ConnDriver: getConnectDB(String): Generic Exception==>\n" + e);
            e.printStackTrace();
            throw e;
        }
        BaseLogger.log("2", null, null, "Connection Established");
        return connection;
    }

    @Override
    public Connection getConnectDB(String dataPropFileName, int logLevel) throws Exception {
        BaseDBConnection connection = null;
        this.setDatabaseVariable(dataPropFileName);
        try {
            if (!this.isPool) {
                connection = new BaseDBConnection(this.driver_name, this.driver_url, this.database_username, this.database_password, this.database_autocommit);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Connection Not Established([" + this.driver_name + "][" + this.driver_url + "][" + this.database_username + "] ?????????");
            BaseLogger.log("0", null, null, "Exception: ConnDriver: getConnectDB( String ): Generic Exception==>\n" + e);
            e.printStackTrace();
            throw e;
        }
        BaseLogger.log("2", null, null, "Connection Established");
        return connection;
    }

    @Override
    public Connection getConnectDB(String dataPropFileName, boolean isInMemory) throws Exception {
        BaseDBConnection connection = null;
        this.setDatabaseVariable(dataPropFileName);
        try {
            if (!this.isPool) {
                connection = new BaseDBConnection(this.driver_name, this.driver_url, this.database_username, this.database_password, this.database_autocommit, this.data_pstmtSupported, isInMemory);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Connection Not Established for inMemory ([" + this.driver_name + "][" + this.driver_url + "][" + this.database_username + "] ?????????");
            BaseLogger.log("0", null, null, "Exception: ConnDriver: getConnectDB( dataPropFileName, isInMemory): Generic Exception==>\n" + e);
            e.printStackTrace();
            throw e;
        }
        BaseLogger.log("2", null, null, "Connection Established");
        return connection;
    }

    @Override
    public Connection getConnectDB(String dbPropFileName, String xlsFileName) throws Exception {
        BaseDBConnection connection = null;
        this.setDatabaseVariable(dbPropFileName);
        try {
            BaseLogger.log("3", null, null, "----------- ConnDriver::getConnectDB : dbPropFileName[" + dbPropFileName + "]");
            BaseLogger.log("3", null, null, "----------- ConnDriver::getConnectDB :this.driver_url :[" + this.driver_url + "]");
            BaseLogger.log("3", null, null, "----------- ConnDriver::getConnectDB : xlsFileName[" + xlsFileName + "]");
            if (!this.isPool) {
                String dirName = "";
                if (CommonConstants.J2EE_VERSION.equals("1")) {
                    dirName = new File(String.valueOf(CommonConstants.UPLOAD_LOC) + File.separator + "webapps" + File.separator + "ibase").getParentFile().getParent();
                    BaseLogger.log("3", null, null, "dirName[" + dirName + "]");
                } else if (CommonConstants.J2EE_VERSION.equals("2")) {
                    dirName = new File(CommonConstants.JBOSSHOME) + File.separator + "dump";
                }
                String xlsFilePath = String.valueOf(dirName) + File.separator + xlsFileName;
                BaseLogger.log("3", null, null, "----------- ConnDriver::getConnectDB : xlsFilePath[" + xlsFilePath + "]");
                StringBuffer driverURLBuff = new StringBuffer(this.driver_url);
                driverURLBuff.replace(this.driver_url.indexOf("[?]"), this.driver_url.indexOf("[?]") + 3, xlsFilePath);
                this.driver_url = driverURLBuff.toString();
                connection = new BaseDBConnection(this.driver_name, this.driver_url, this.database_username, this.database_password, this.database_autocommit);
            } else {
                connection = new BaseDBConnection(this.data_source_name, this.database_autocommit, dbPropFileName);
            }
        }
        catch (ClassNotFoundException cfe) {
            BaseLogger.log("0", null, null, "Connection Not Established([" + this.driver_name + "][" + this.driver_url + "][" + this.database_username + "] ?????????");
            BaseLogger.log("0", null, null, "Exception: ConnDriver: getConnectDB(String): Class Not Found==>\n" + cfe);
        }
        catch (SQLException sqle) {
            BaseLogger.log("0", null, null, "Connection Not Established([" + this.driver_name + "][" + this.driver_url + "][" + this.database_username + "] ?????????");
            BaseLogger.log("0", null, null, "Exception: ConnDriver: getConnectDB(String): SQLException==>\n" + sqle);
            sqle.printStackTrace();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Connection Not Established([" + this.driver_name + "][" + this.driver_url + "][" + this.database_username + "] ?????????");
            BaseLogger.log("0", null, null, "Exception: ConnDriver: getConnectDB(String): Generic Exception==>\n" + e);
        }
        BaseLogger.log("2", null, null, "Connection Established");
        return connection;
    }

    @Override
    public OracleConnection getOracleConnection(String dataPropFileName) throws Exception {
        OracleConnection oracleConnection = null;
        this.setDatabaseVariable(dataPropFileName);
        try {
            BaseLogger.log("2", null, null, "Creating Oracle connection for pool [" + this.isPool + "]");
            if (!this.isPool) {
                oracleConnection = (OracleConnection)DriverManager.getConnection(this.driver_url, this.database_username, this.database_password);
            } else {
                BaseLogger.log("3", null, null, "dataSourceName [" + this.data_source_name + "]");
                InitialContext ctx = new InitialContext();
                DataSource ds = (DataSource)ctx.lookup("java:/" + this.data_source_name);
                WrappedConnection wConnection = (WrappedConnection)ds.getConnection();
                oracleConnection = (OracleConnection)wConnection.getUnderlyingConnection();
                oracleConnection.setAutoCommit(false);
                BaseLogger.log("3", null, null, "oracleConnection establish....");
            }
        }
        catch (SQLException sqle) {
            BaseLogger.log("0", null, null, "Connection Not Established([" + this.driver_name + "][" + this.driver_url + "][" + this.database_username + "] ?????????");
            BaseLogger.log("0", null, null, "Exception: ConnDriver: getConnectDB(String,boolean): SQLException==>\n" + sqle);
            sqle.printStackTrace();
            throw sqle;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Connection Not Established([" + this.driver_name + "][" + this.driver_url + "][" + this.database_username + "] ?????????");
            BaseLogger.log("0", null, null, "Exception: ConnDriver: getConnectDB(String,boolean): Generic Exception==>\n" + e);
            e.printStackTrace();
            throw e;
        }
        BaseLogger.log("2", null, null, "Connection Established for OracleConnection...");
        return oracleConnection;
    }

    @Override
    public Connection getConnectDB(UserInfoBean userInfo) throws Exception {
        BaseDBConnection connection = null;
        String dataPropFileName = userInfo.getTransDB();
        if (dataPropFileName != null && dataPropFileName.trim().length() > 0 && !"null".equalsIgnoreCase(dataPropFileName)) {
            this.setDatabaseVariable(dataPropFileName);
        }
        try {
            connection = !this.isPool ? new BaseDBConnection(this.driver_name, this.driver_url, this.database_username, this.database_password, this.database_autocommit, userInfo) : new BaseDBConnection(this.data_source_name, this.database_autocommit, userInfo, dataPropFileName);
        }
        catch (ClassNotFoundException cfe) {
            BaseLogger.log("0", null, null, "Connection Not Established([" + this.driver_name + "][" + this.driver_url + "][" + this.database_username + "] ?????????");
            BaseLogger.log("0", null, null, "Exception: ConnDriver: getConnectDB(String): Class Not Found==>\n" + cfe);
            cfe.printStackTrace();
            throw cfe;
        }
        catch (SQLException sqle) {
            BaseLogger.log("0", null, null, "Connection Not Established([" + this.driver_name + "][" + this.driver_url + "][" + this.database_username + "] ?????????");
            BaseLogger.log("0", null, null, "Exception: ConnDriver: getConnectDB(String): SQLException==>\n" + sqle);
            sqle.printStackTrace();
            throw sqle;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Connection Not Established([" + this.driver_name + "][" + this.driver_url + "][" + this.database_username + "] ?????????");
            BaseLogger.log("0", null, null, "Exception: ConnDriver: getConnectDB(String): Generic Exception==>\n" + e);
            e.printStackTrace();
            throw e;
        }
        BaseLogger.log("2", null, null, "Connection Established");
        return connection;
    }
}

