<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <html>

        <head>
            <SCRIPT language="Javascript" type="text/javascript" src="/ibase/scheduler/js/date-picker.js"></SCRIPT>
            <SCRIPT language="Javascript" type="text/javascript" src="/ibase/webitm/js/ValidateDate.js"></SCRIPT>
            <SCRIPT language="Javascript" type="text/javascript" src="/ibase/qms/js/DateValidator.js"></SCRIPT>
            <script language="JavaScript" type="text/javascript">
            </script>
            <SCRIPT language="Javascript" type="text/javascript"
                src="/ibase/webitm/js/EmpResignationPortal.js"></SCRIPT>
            <SCRIPT language="Javascript" type="text/javascript" src="/ibase/webitm/js/ComplainFeedback.js"></SCRIPT>
            <SCRIPT language="Javascript" type="text/javascript" src="/ibase/webitm/js/StatelessItemChange.js"></SCRIPT>
            <SCRIPT language="Javascript" type="text/javascript">
                function openTransaction() {
                    //alert("Opening Transaction");
                    console.log("Opening Transaction");
                    var data = {
                        "actionInfo": "data",
                        "pkFieldValue": "pkFieldValue",
                        "objName": "obj_name",
                        "isAnyRowSelected": true,
                        "feedData": "jsonStr"
                    }
                    invokeDashboardLink(data);
                }
            </SCRIPT>
            <link type="text/css" rel="stylesheet" href="/ibase/E12MOBILE/css/workflowsign.css" />
            <link type="text/css" rel="stylesheet" href="/ibase/E12MOBILE/css/expandy.css" />
            <link type="text/css" rel="stylesheet" href="/ibase/webitm/css/fonts.css" />
            <link type="text/css" rel="stylesheet" href="/ibase/E12MOBILE/css/hr_portal1.css" />
        </head>

        <body>
            <INPUT type="hidden" name="OBJ_NAME" id="OBJ_NAME" value='asset_transfer' />
            <INPUT type='hidden' name='OBJ_CONTEXT' value='1' />
            <INPUT type='hidden' name='EDIT_FLAG' value='A' />
            <INPUT type='hidden' name='DOM_ID' value='{@domID}' />
            <INPUT type='hidden' name='DB_ID' value='{@dbID}' />
            <xsl:for-each select="//Detail1">
                <xsl:variable name="dbID">
                    <xsl:value-of select="@dbID" />
                </xsl:variable>
                <xsl:variable name="tran_id">
                    <xsl:value-of select="tran_id" />
                </xsl:variable>
                <xsl:variable name="site_code__from">
                    <xsl:value-of select="site_code__from" />
                </xsl:variable>
                <xsl:variable name="site_code__to">
                    <xsl:value-of select="site_code__to" />
                </xsl:variable>
                <xsl:variable name="tran_id__iss">
                    <xsl:value-of select="tran_id__iss" />
                </xsl:variable>
                <xsl:variable name="asset_type">
                    <xsl:value-of select="asset_type" />
                </xsl:variable>
                <xsl:variable name="supp_name">
                    <xsl:value-of select="supp_name" />
                </xsl:variable>
                <xsl:variable name="item_code">
                    <xsl:value-of select="item_code" />
                </xsl:variable>

        <xsl:variable name="detail2" select="//Detail2" />
        
        <!-- Extracting values from Detail2 -->
        <xsl:variable name="asset_code__from" select="$detail2/asset_code__from" />
        <xsl:variable name="asset_code__to" select="$detail2/asset_code__to" />
        
        <!-- Output the extracted values -->

                        <input type="hidden" id="assetCode" value="{$asset_code__from}" ></input>
                <div style="width: 98%; overflow-x: auto; position: relative; margin: 2px">

<div style="display: flex; justify-content: center; align-items: center; padding: 22px;">
    <img id="documentImage" style="display: none; width: auto; height: 400px;" alt="Document Image"></img>
</div>
                    <!-- Transfer Details Section -->
                    <div style="font-weight: bold; padding: 11px; border-top: #f9f9f9 3px solid;">Transfer Details</div>

                    <div style="display: flex; gap: 20px; flex-wrap: wrap;">
                        <div class="container">
                            <div class="row">
                           
        <div class="field">Transferred ID: <span class="value"><xsl:value-of select="tran_id" /></span></div>
                                <div class="field">Transferred From: <span class="value"><xsl:value-of
                                            select="$asset_code__from" /></span></div>
                            </div>
                            <div class="row">
                                <div class="field">Transferred To: <span class="value"><xsl:value-of
                                            select="$asset_code__to" /></span></div>
                                <div class="field">Assigned To: <div
                                        style="display: flex;width: -webkit-fill-available;position: relative;">
                                        <input class="tInputStyleR" type="text"
                                            id="Detail2.{normalize-space(@dbID)}.ASSIGNED_TO"
                                            name="Detail2.{normalize-space(@dbID)}.ASSIGNED_TO" value=""
                                            POPUPEXISTS="true" POPUPPARAMETERS="" ISCHANGED="true"
                                            SRVCALLONCHANGE="true" isServerCallOnChange="true" onblur="gotBlur(this)"
                                            onkeyup="return autoCaps(this)" onkeydown="return onKeyDownFun(this,event)"
                                            ispopup="true" size="10" title="Assigned To"
                                            style="vertical-align: middle; margin-left: 495px; border:0px; background-color: #e8f0f9;" />
                                    </div>
                                    <div style="display: flex; height: 36px; width: 36px; position: absolute; right: 0; top: 95px; 
           align-items: center; justify-content: center;">
                                        <span class="inputStyle">
                                            <img src="/ibase/webitm/images/pop_help_image.png" width="11px"
                                                height="13px" name="PopUpAltReas" id="PopUpAltReas"
                                                onclick="getListOfValuesResignation(this.id,'asset_transfer',{normalize-space(@dbID)});"
                                                border="0" background="#eeeeee00" z-index="1" CUR_POPUP_PARAM=""
                                                CUR_FIELD_NAME="Detail2.{normalize-space(@dbID)}.ASSIGNED_TO" />
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                     <!-- Asset Details Section -->
                     <div style="font-weight: bold; padding: 11px; border-top: #f9f9f9 3px solid;">Asset Details
                    </div>
                    <div style="display: flex; gap: 20px; flex-wrap: wrap;">
                        <div class="container">
                            <!-- Asset Details Here -->
                            <div id="assetDetailsContainer"></div>
                        </div>
                    </div>
                </div>

                <style>
                    .container {
                        width: 100%;
                    }

                    .row {
                        display: flex;
                        justify-content: space-between;
                        width: 100%;
                        margin-bottom: 12px;
                        /* Space between rows */
                    }

                    .field {
                        flex: 1;
                        font-weight: bold;
                        padding: 10px;
                        background-color: #e8f0f9;
                        border-radius: 8px;
                        display: flex;
                        justify-content: space-between;
                        white-space: nowrap;
                        margin-right: 15px;
                        /* Space between fields */
                    }

                    .field:last-child {
                        margin-right: 0;
                        /* Remove margin for last field */
                    }

                    .value {
                        font-weight: normal;
                        text-align: right;
                        flex: 1;
                    }
                </style>
               <script>
                    var assetCode = "<xsl:value-of select='asset_code__from' />";
               </script>
                <script src="/ibase/E12MOBILE/js/jquery-1.11.1.min.js"></script>
                <script src="/ibase/E12MOBILE/js/expandy.min.js"></script>
                <script>
                    $('.container1').makeExpander({
                        toggleElement: 'h2',
                        jqAnim: true,
                        showFirst: false,
                        accordion: true,
                        speed: 400,
                        /*indicator:
                    'triangle'*/
                    });
                    $('.container2').makeExpander({
                        toggleElement: 'h2',
                        jqAnim: true,
                        showFirst: true,
                        accordion: false,
                        speed: 400,
                        indicator: 'plusminus'
                    });
                    $('.container3').makeExpander({
                        toggleElement: 'h2',
                        jqAnim: true,
                        showFirst: true,
                        accordion: false,
                        speed: 1400,
                        indicator: 'arrow'
                    });
                </script>
            </xsl:for-each>
        </body>

        </html>
    </xsl:template>
</xsl:stylesheet>
