package ibase.webitm.bean.wsfa;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

import ibase.webitm.utility.wsfa.DBOperations;
import ibase.webitm.utility.wsfa.DateUtilities;
import ibase.webitm.utility.wsfa.SavexException;
import ibase.webitm.utility.wsfa.Utilities;

import ibase.system.config.ConnDriver;
import ibase.utility.UserInfoBean;

//import sun.security.action.GetLongAction;

/**
 * Class PSR - <br>
 * This class consists of all Queries related to MedRep
 *
 * @author 
 * @version 1.0
 * @since Feb 13, 2002
 * History of change
 * Date           Person       Change  
 */

public class MedRep
{
	private String salesCode;
	private String empName;
	private String designation;
	private String level1Code;
	private String level2Code;
	private String level3Code;
	private Vector townCode;
	private Vector routeId;
	private Vector townName;
	private Vector doctorCode;
	private Vector doctorName;
	private Vector sampleCode;
	private Vector sampleName;
	private Vector stockistCode;
	private Vector stockistName;
	private Vector stockistSpCd;
	private Vector conCode;
	private Vector VShortID;
	private Vector conName;
	private Vector psrDetail;
	private Vector class_code;
	private Vector splcode;
	private Vector novisit;
	private String activityName;
	private String activityType;
	private String dateOfJoin;
	private String dateOfRelieve;
	private String dateOfResign;
	private String strStr="";
	private String lvlLvl="";
	private int nameFormat = 2;
	private Vector spCdName;
	private Vector psrName;
	private Vector divCodes;
	private Vector divDesc;
	//snehasish added to send the locality & localitycode in the required jsps
	private Vector doctorLocCodeDescr;
	private Vector salesPersList;//Added by Radheshyam[30/04/2015].start

	private Connection con = null;
	UserInfoBean userInfo = null;

	public MedRep( UserInfoBean userInfo ) throws Exception
	{	
		
		this.userInfo = userInfo;
		/*try
		{
			ConnDriver connDriver = new ConnDriver();
			if ( con == null )
			{
				con = connDriver.getConnectDB( userInfo.getTransDB() );
			}
		}
		catch( Exception ex )
		{
			ex.printStackTrace();
		}*/
	}
	/*public MedRep() throws Exception
	{
		try
		{
			if ( con == null )
			{
				DBConnection dbCon = new DBConnection();
				con = dbCon.getConnection();
			}
		}
		catch(Exception e)
		{
			throw e;
		}
	}*/

	/** 
	Member Functions The access metods for member variables
	 */

	/** 
	 * This method sets the value for member variable nameFormat
	 *
	 * @param   nameFormat   
	 */
	public void setNameFormat(int nameFormat)
	{
		this.nameFormat = nameFormat ;
	}

	/** 
	 * This method returns the value for member variable townCode
	 *
	 * @return   townCode			returns the value of townCode which is Vector 
	 */
	public Vector getTownCode()
	{
		return townCode;
	}

	/** 
	 * This method returns the value for member variable routeId
	 *
	 * @return   routeId			returns the value of routeId which is Vector 
	 */
	public Vector getRouteID()
	{
		return routeId;
	}

	/** 
	 * This method returns the value for member variable townName
	 *
	 * @return   townName			returns the value of townName which is Vector 
	 */
	public Vector getTownName()
	{
		return townName;
	}

	/** 
	 * This method returns the value for member variable doctorCode
	 *
	 * @return   doctorCode			returns the value of doctorCode which is Vector 
	 */
	public Vector getDoctorCode()
	{
		return doctorCode;
	}


	/** 
	 * This method returns the value for member variable doctorName
	 *
	 * @return   doctorName			returns the value of doctorName which is Vector 
	 */
	public Vector getDoctorName()
	{
		return doctorName;
	}

	public Vector getsplcode()
	{
		return splcode;
	}
	public Vector getnovisit()
	{
		return novisit;
	}
	public Vector getclass_code()
	{
		return class_code;
	}
	//get formated doctor-PSR

	public Vector getSpCdName()
	{
		return spCdName;
	}
	/** 
	 * This method returns the value for member variable empName
	 *
	 * @return   empName			returns the value of empName which is String 
	 */
	public String getEmpName()
	{
		return empName;
	}
	/** 
	 * This method returns the value for member variable level1Code
	 *
	 * @return   level1Code			returns the value of level1Code which is String 
	 */
	public String getLevel1Code()
	{
		return level1Code;
	}
	/** 
	 * This method returns the value for member variable level2Code
	 *
	 * @return   level2Code			returns the value of level2Code which is String 
	 */
	public String getLevel2Code()
	{
		return level2Code;
	}
	/** 
	 * This method returns the value for member variable level3Code
	 *
	 * @return   level3Code			returns the value of level3Code which is String 
	 */
	public String getLevel3Code()
	{
		return level3Code;
	}

	/** 
	 * This method returns the value for member variable sampleCode
	 *
	 * @return   sampleCode			returns the value of sampleCode which is Vector 
	 */
	public Vector getSampleCode()
	{
		return sampleCode;
	}
	/** 
	 * This method returns the value for member variable sampleName
	 *
	 * @return   sampleName			returns the value of sampleName which is Vector 
	 */
	public Vector getSampleName()
	{
		return sampleName;
	}

	public Vector getPsrName ()
	{
		return psrName;
	}
	/** 
	 * This method returns the value for member variable stockistCode
	 *
	 * @return   stockistCode			returns the value of stockistCode which is Vector 
	 */
	public Vector getStockistCode()
	{
		return stockistCode;
	}
	/** 
	 * This method returns the value for member variable stockistName
	 *
	 * @return   stockistName			returns the value of stockistName which is Vector 
	 */
	public Vector getStockistName()
	{
		return stockistName;
	}

	// This method returns the value for member variable PSR NAME-SALES_PERS
	// @return   stockistSpCd	

	public Vector getStockistSpCd()
	{
		return stockistSpCd;
	}
	/** 
	 * This method returns the value for member variable conCode
	 *
	 * @return   conCode			returns the value of conCode which is Vector 
	 */
	public Vector getConCode()
	{
		return conCode;
	}

	/** 
	 * This method returns the value for member variable conName
	 *
	 * @return   conName			returns the value of conName which is Vector 
	 */
	public Vector getConName()
	{
		return conName;
	}

	/** 
	 * This method returns the value for member variable activityName
	 *
	 * @return   empName			returns the value of activityName which is String 
	 */
	public String getActivityName()
	{
		return activityName;
	}
	public String getActivityType()
	{
		return activityType;
	}

	public String getDateOfJoin()
	{
		return dateOfJoin;
	}

	public String getDateOfRelieve()
	{
		return dateOfRelieve;
	}

	public String getDateOfResign()
	{
		return dateOfResign;
	}

	/** 
	 * snehasish added 08/02/2006
	 * This method returns the Vector for the doctors locality code & location description
	 *
	 */
	public Vector getDoctorLocCodeDescr()
	{
		return doctorLocCodeDescr;
	}




	/** 
	 * This method select record from the table SALES PERS
	 * This method gets the general information like name from the database          
	 *
	 * @param   connection   
	 */
	public void selectGenInfo ( String salesCd) throws Exception
	{	
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String selectGIQuery =  " SELECT LTRIM(RTRIM(EMP_FNAME))||'   '||LTRIM(RTRIM(EMP_LNAME)) NAME, "+ 
				" TO_CHAR(DATE_JOIN,'DD-MON-YYYY') DATE_JOIN, "+
				" TO_CHAR(RELIEVE_DATE,'DD-MON-YYYY') RELIEVE_DATE, "+
				" TO_CHAR(RESI_DATE ,'DD-MON-YYYY')RESI_DATE FROM EMPLOYEE where EMP_CODE = '"+ salesCd+"'";				

		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectGIQuery);
			while(rs.next())
			{		
				empName = Utilities.checkNull(rs.getString("NAME"));
				dateOfJoin=Utilities.checkNull(rs.getString("DATE_JOIN"));
				dateOfRelieve=Utilities.checkNull(rs.getString("RELIEVE_DATE"));
				dateOfResign = Utilities.checkNull(rs.getString("RESI_DATE"));  
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
	}

	/**
	 * This method return level of a employee(i.e. fsm/zsm/rsm)
	 *
	 * @return level_no 
	 */
	public String getLevels( String salesCode ) throws Exception
	{
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String strlvl="";
		String selectQuery = " SELECT B.LEVEL_NO FROM EMPLOYEE A, GRADE B "+
				" WHERE A.EMP_CODE ='"+salesCode +"'"+
				" AND   A.GRADE = B.GRADE_CODE ";
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectQuery);
			while(rs.next())
			{		
				strlvl = String.valueOf(rs.getInt("level_no"));
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			//System.out.println("Exception :"+e);
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		return strlvl;
	}


	/** 
	 * This method select division from the table SALES PERS
	 * This method gets the general information like name from the database
	 *
	 * @param   connection   
	 * @param   salescode
	 * @return  divisionCode   
	 */
	public String selectDivision (String salesCd) throws Exception
	{	
		//System.out.println("\nMedRep--selectDivision");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String divCode = "";
		String selectGIQuery = "SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = '"+ salesCd+"'";
		////System.out.println("selectGIQuery :" +selectGIQuery);
		//Logger.writeDBLog("selectDivision query "+ selectGIQuery, Logger.LOG_LEVEL_DEBUG, "MedRep.java", "selectDivision");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectGIQuery);
			while(rs.next())
			{		
				divCode = Utilities.checkNull(rs.getString("ITEM_SER"));
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		return divCode;
	}

	public Vector selectAllDivision (String loginEmpCode) throws Exception
	{	
		//System.out.println("\nMedRep--selectDivision");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String strDivDesc="";
		Vector divDesc = new Vector();
		Vector divDescInsert = new Vector();

		//Modified by Aadesh on [31/03/2015][To handle the functionality in case of accParm is "HIERARCHY"][Start]
		String mgrDivCode = "";
		Vector divMgrDesc = new Vector();
		//Modified by Aadesh on [31/03/2015][To handle the functionality in case of accParm is "HIERARCHY"][End]

		//Changed by Nazia on 12-Apr-2008 [Removed 'MIN_INV_AMT <> 0 AND' from SQL as per Nilesh Parikh requirment WS89SUN002 ]
		/*String selectDivision =  " SELECT ITEM_SER, SH_DESCR FROM ITEMSER "+
										" WHERE MIN_INV_AMT <> 0 AND PRODUCT_LINE = 'DOM' ORDER  BY SH_DESCR ";*/
		String selectDivision =   " SELECT ITEM_SER, SH_DESCR FROM ITEMSER " +
				" WHERE PRODUCT_LINE = 'DOM' ORDER  BY SH_DESCR ";	

		try
		{
			stmt =con.createStatement();
			rs = stmt.executeQuery(selectDivision);

			while(rs.next())
			{		
				strDivDesc=Utilities.checkNull(rs.getString("ITEM_SER")+"-"+rs.getString("SH_DESCR"));
				divDesc.addElement(strDivDesc);
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}


		//		Modified by radheshyam on [18/03/2015] [updated for acc_parm1 column in users] [Start]

		System.out.println("loginEmpCode is"+loginEmpCode);
		loginEmpCode = loginEmpCode == null ? "":loginEmpCode.trim();

		Vector divDescInsertHir = new Vector();
		String fldStaffSiteString = "";
		fldStaffSiteString = getFldStaffSiteList();
		System.out.println("Inside [MedRep][getAllPSRData()]fldStaffSiteString::["+fldStaffSiteString+"]");
		String accParm = getAccPerm1Value(loginEmpCode);
		String actVal = "",actVal1="";
		System.out.println("VALUE OF ACC_PARM1 IS "+accParm);
		System.out.println("VALUES IN divVector IS "+divDesc.toString());

		//Modified by Aadesh on [31/03/2015][To handle the functionality in case of accParm is "HIERARCHY"][Start]
		//if(accParm.equalsIgnoreCase("ALL") || accParm.equalsIgnoreCase("HIERARCHY"))
		if(accParm.equalsIgnoreCase("ALL"))
			//Modified by Aadesh on [31/03/2015][To handle the functionality in case of accParm is "HIERARCHY"][End]
		{
			System.out.println("divDesc");
			return divDesc;
		}
		//Modified by Aadesh on [31/03/2015][To handle the functionality in case of accParm is "HIERARCHY"][Start]
		else if(accParm.equalsIgnoreCase("HIERARCHY"))
		{
			//mgrDivCode =  selectDivision (dbCon ,loginEmpCode);
			//System.out.println("Manager divCode is @@@" + mgrDivCode);
			//divMgrDesc =  selectMgrDivision(dbCon,mgrDivCode); Commented by Vishakha [22.05.2015]
			String emp_code = getEmpEntityCode(loginEmpCode);
			System.out.println("emp_code----"+emp_code);
			divMgrDesc =  selectMgrHierarcyDivision(mgrDivCode,emp_code); //  Added  by Vishakha [22.05.2015] to change the functionality in case of accParm is "HIERARCHY" [Start]
			System.out.println("Manager divMgrDesc is @@@" + divMgrDesc);
			return divMgrDesc;
		}
		//Modified by Aadesh on [31/03/2015][To handle the functionality in case of accParm is "HIERARCHY"][End]
		else
		{
			for(int psr = 0;psr<divDesc.size(); psr++)
			{
				actVal = divDesc.get(psr).toString();
				actVal1 = actVal.substring(0,2);
				System.out.println("VALUE OF ACC_PARM1 IS "+accParm+" AND ACT VALUE "+actVal);
				System.out.println("value of actVal1 is @@@@@ " + actVal1);

				if(accParm.contains(actVal1))
				{
					divDescInsert.addElement(actVal);
					System.out.println("divDescInsert is in else   @@@@ " + divDescInsert );
				}
			}

		}
		//		Modified by radheshyam on [18/03/2015] [updated for acc_parm1 column in users] [Start]

		System.out.println("divDescInsert @@@@ @@ :::" + divDescInsert);
		return divDescInsert; 
	}


	/** 
	 * This method select Head Quarter from the table SALES PERS
	 * This method gets the general information like name from the database
	 *
	 * @param   connection   
	 * @param   salescode
	 * @return  divisionCode   
	 */
	public String selectHQ (String salesCd) throws Exception
	{	
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String hq = "";
		String selectHQQuery = "SELECT ST.DESCR  FROM STATION ST , EMPLOYEE EMP " +
				" WHERE EMP.EMP_CODE = '" + salesCd +"' AND EMP.STAN_CODE__HQ = ST.STAN_CODE";
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectHQQuery);
			while(rs.next())
			{		
				hq = Utilities.checkNull(rs.getString("DESCR"));
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				
			}
		}
		return hq;
	}

	/** 
	 * This method get the information(like salesCode and Name) of the superior
	 * @param   connection   
	 * @param   salesCode
	 */
	public void selectSuperior(String salesCode) throws Exception
	{
		level1Code = "";
		level2Code = "";
		level3Code = "";

		String levelCode = selectSuperSalesCode(salesCode);
		////System.out.println("selectSuperior : levelCode :"+levelCode+": lvlLvl :"+lvlLvl);
		if (levelCode.length() > 0 && levelCode != null)
		{
			selectLevel(levelCode);
		}
		if(lvlLvl.equalsIgnoreCase("1"))
		{
			level1Code="";
			level2Code="";
			level3Code = strStr;
		}
		else if(lvlLvl.equalsIgnoreCase("2"))
		{
			level1Code = "";
			level2Code = strStr;
			////System.out.println("\nMedRep : selectSuperior : level2Code :" +level2Code+":\n");
			String lvlCode = selectSuperSalesCode(strStr);
			if (lvlCode.length() >0 && lvlCode != null)
			{
				////System.out.println("\nMedRep : selectSuperior : lvlCode :" +lvlCode+":\n");
				selectLevel(lvlCode);
				if(lvlLvl.equalsIgnoreCase("1"))
				{
					level3Code = strStr;
				}
				/*else commented by Danish 14/05/2005 -- no need to find superior if superior is not their for Level2
				{
					String lvl1Code = selectSuperSalesCode(con,strStr);
					//System.out.println("\nMedRep : selectSuperior : lvl1Code :" +lvl1Code+":\n");
					if (lvl1Code.length() > 0 && lvlCode == null )
					{
						selectLevel(lvl1Code);
					}
					level3Code =strStr;
				}*/
			}
		}
		else if(lvlLvl.equalsIgnoreCase("3"))
		{
			level1Code = strStr;
			String lvlCode = selectSuperSalesCode(strStr);
			if(lvlCode.length() > 0 && lvlCode != null )
			{
				//System.out.println("\nMedRep : selectSuperior : lvlCode :" +lvlCode+":\n");
				selectLevel(lvlCode);
				if(lvlLvl.equalsIgnoreCase("2"))
				{
					level2Code = strStr;
					String lvl1Code = selectSuperSalesCode(strStr);
					//System.out.println("\nMedRep : selectSuperior : lvl1Code :" +lvl1Code+":\n");
					if (lvl1Code.length() > 0 && lvl1Code != null)
					{
						selectLevel(lvl1Code);
					}
					if(lvlLvl.equalsIgnoreCase("1"))
					{
						level3Code = strStr;	
					}
					/*else commented by Danish 14/05/2005 -- no need to find superior if superior is not their for Level2
					{
						String lvl2Code = selectSuperSalesCode(con,strStr);
						if (lvl2Code.length()>0 && lvl2Code != null)
						{
								//System.out.println("\nMedRep : selectSuperior : lvl2Code :" +lvl2Code+":\n");
								selectLevel(lvl2Code);
						}
						level3Code = strStr;
					}*/
				}
				else if(lvlLvl.equalsIgnoreCase("1"))
				{
					level2Code = "";
					level3Code = strStr;
				}
			}
		}
		//System.out.println("\nMedRep : selectSuperior : level1 :"+level1Code+" : level2 :"+level2Code+": level3 :"+level3Code+":\n");
	}

	/*
	 *This method sepaarates the level & salesPersCode from given Input
	 *
	 */
	public void selectLevel(String levelCode) throws Exception
	{
		int pos = levelCode.indexOf('-');
		strStr = levelCode.substring(0,pos);
		////System.out.println("selectLevel : strStr :"+strStr);
		lvlLvl = levelCode.substring(pos+1,levelCode.length());
	}


	/** 
	 * This method get the towns which comes under the territory of the PSR 
	 * This function is used to populate the town dropdown
	 *
	 * @param   connection   
	 * @param   String salesCode whose towns are required
	 */
	public void selectTowns(String salesCd)throws SavexException, Exception
	{
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		DateUtilities dut = new DateUtilities();
		dut.setFormatString("dd/MMM/yyyy");
		String todaysDate = dut.getCurrentDate();
		townCode = new Vector();
		townName = new Vector();
		routeId = new Vector();
		String strSprs_code = "";
		String strSp_name = "";
		String strTownCode = "", strRouteId ="", strTownName = "";
		String whereClause = "";
		String station_type = "";//snehasish added 04/12/2006
		String route_type = "";//Nazia added 5-Jun-2007

		if(salesCd.indexOf(",") != -1)
		{
			StringTokenizer salesCdTokens = new StringTokenizer(salesCd, ",");
			String salesCdStr = "";
			while(salesCdTokens.hasMoreTokens())
			{
				salesCdStr += "'"+salesCdTokens.nextToken().trim()+"',";
			}
			whereClause = "SP.SALES_PERS IN (" + salesCdStr.substring(0,salesCdStr.length()-1) + ")";
		}
		else
		{
			whereClause = "SP.SALES_PERS = '"+salesCd+"'";
		}
		String selectTownQuery = 
				" SELECT SR.ROUTE_ID, SR.SH_DESCR, SR.STAN_CODE, SP.SALES_PERS, " +
						//snehasish added SR.STATION_TYPE to show the type in case of So  login 04/12/2006
						" SP.SP_NAME, SR.STATION_TYPE, " +
						" SR.ROUTE_TYPE" + //Nazia added sr.route_type to display route type in case of So  login 5-Jun-2007
						" FROM SPRS_ROUTE SR, SALES_PERS SP"+
						" WHERE	SP.SALES_PERS = SR.SPRS_CODE AND "+ whereClause +
						" AND STATUS = 'Y' ORDER BY SR.SH_DESCR ";

		System.out.println("\nMedRep : selectTowns : selectTownQuery :" +selectTownQuery+":\n");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectTownQuery);
			while(rs.next())
			{
				strRouteId = Utilities.checkNull(rs.getString("ROUTE_ID"));
				routeId.addElement(strRouteId);
				strTownName = Utilities.checkNull(rs.getString("SH_DESCR"));
				strTownCode = Utilities.checkNull(rs.getString("STAN_CODE"));
				strSprs_code = Utilities.checkNull(rs.getString("SALES_PERS"));
				strSp_name = Utilities.checkNull(rs.getString("SP_NAME"));
				//snehasish added 04/12/2006
				station_type = Utilities.checkNull(rs.getString("STATION_TYPE"));
				//Nazia 5-Jun-2007
				route_type = Utilities.checkNull(rs.getString("ROUTE_TYPE"));
				//added by Nazia  display route type in case of So  login 5-Jun-2007
				//Changed by Nazia on 8/11/2008 [Removed route_type as per request WS89SUN009]
				//townName.addElement(strTownName+" , "+strSp_name+"("+strSprs_code+")"+route_type );
				townName.addElement(strTownName+" , "+strSp_name+"("+strSprs_code+")" );
				/* commented by Nazia  display route type in case of So  login 5-Jun-2007
				townName.addElement(strTownName+" , "+strSp_name+"("+strSprs_code+")"+station_type);*/
				townCode.addElement(strTownCode+"-"+strTownName+","+strSprs_code);
			}
			if (rs!=null)
			{
				rs.close();
			}
			if (stmt!=null)
			{
				stmt.close();
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{	
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		if(townCode.size()==0)
		{
			throw new SavexException("No Towns for this PSR");
		}	
	}

	/** 
	 * This method get the towns which comes under the territory of the PSR 
	 * This function is used to populate the town dropdown
	 *
	 * @param   connection   
	 * @param   String salesCode whose towns are required
	 * Method OverLoaded ...
	 */
	public void selectTownsForUnlistedDoctor (String salesCd) throws SavexException,Exception
	{	
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		//getting todays date 
		DateUtilities dut = new DateUtilities();
		dut.setFormatString("dd/MMM/yyyy");
		String todaysDate = dut.getCurrentDate();

		townCode = new Vector();
		townName = new Vector();
		String strTownCode = "", strTownName = "";
		String strStateDesc = "", townState = "";
		String selectTownQuery = " SELECT  HIERARCHY.STAN_CODE STAN, STATION.DESCR STANDESC, STATE.DESCR STATEDESC"+
				" FROM STATION,HIERARCHY,HIERARCHY_DET,STATE "+
				" WHERE HIERARCHY_DET.LEVEL_CODE = HIERARCHY.LEVEL_CODE "+
				" AND HIERARCHY_DET.LEVEL_CODE__PARENT = HIERARCHY.LEVEL_CODE__PARENT "+
				" AND HIERARCHY_DET.TABLE_NO = HIERARCHY.TABLE_NO " +
				" AND HIERARCHY_DET.SALES_PERS = '"+salesCd+"' " +
				" AND HIERARCHY_DET.VERSION_ID = HIERARCHY.VERSION_ID " +
				" AND HIERARCHY_DET.VERSION_ID = ( SELECT MAX(VERSION_ID) FROM VERSION " +
				" WHERE VERSION.VERSION_ID = HIERARCHY.VERSION_ID " +
				" AND SYSDATE BETWEEN VERSION.EFF_FROM AND VERSION.VALID_UPTO) "+  
				" AND   SYSDATE BETWEEN HIERARCHY.EFF_FROM AND HIERARCHY.VALID_UPTO"+
				" AND   HIERARCHY.LEVEL_NO = '5' " +
				" AND   HIERARCHY.STAN_CODE = STATION.STAN_CODE "+
				" AND  STATE.STATE_CODE(+) = STATION.STATE_CODE ";

		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectTownQuery);

			while(rs.next())
			{
				strTownCode = Utilities.checkNull(rs.getString("STAN"));
				townCode.addElement(strTownCode);
				strTownName = Utilities.checkNull(rs.getString("STANDESC"));
				strStateDesc = Utilities.checkNull(rs.getString("STATEDESC"));
				if(strStateDesc.length() !=0)
				{
					townState = strTownName+"-"+strStateDesc;
				}
				else
				{
					townState = strTownName;
				}
				townName.addElement(townState);
			}
			if (rs!=null)
			{
				rs.close();
			}
			if (stmt!=null)
			{
				stmt.close();
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		if(townCode.size()==0)
		{
			throw new SavexException("No Towns for this PSR");
		}
	}

	/** 
	 * This method get the doctors which comes under the territory of the PSR 
	 * This function is used to populate the doctor dropdown
	 *
	 * @param   connection   
	 * @param   salesCode whose doctors are required
	 * @param   doctorCat		"C" - for call list doctor
	 *							"N" - for non call list doctor
	 * @param  townCodes in the comma separated  form
	 */
	public void selectDoctors ( String salesCd , String doctorCat, String townCodes, String workDate, String salesPers) throws SavexException,Exception
	{
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();

		// Throw exception if no towns selected
		if(townCodes.equals(""))
		{
			throw new SavexException("NoTownsSelected");
		}
		String whereClause = "( ";

		String whereClauseForTown = "";

		doctorCode = new Vector();
		doctorName = new Vector();
		splcode	= new Vector();
		novisit = new Vector();
		class_code = new Vector();
		spCdName = new Vector();
		//snehasish added 08/02/2006
		doctorLocCodeDescr = new Vector();
		String tableName = "";
		//snehasish added ,doctorLocality ="" 08/02/2006
		String strDoctorCode = "", strDoctorName = "", firstName = "", middleName = "", lastName = "", sortID = "" ,doctorLocality ="";
		String selectDoctorQuery = "";
		String strsplcode = "", strnovisit = "", strclass_code = "", strSpCdName = "",locCodeDesc = "", locCode ="",routId="";//snehasish added ,locCode&Desc = "", locCode ="" 08/02/2006

		try
		{		
			if(doctorCat.equalsIgnoreCase("C"))
			{

				selectDoctorQuery =  " SELECT  DISTINCT"+ //NAZIA ADDED DISTINCT 9-JUN-2007
						" SHORT_ID, SC.SC_CODE, FIRST_NAME, MIDDLE_NAME, LAST_NAME, "+
						" SS.CLASS_CODE, SS.NO_VISIT, SS.SPL_CODE, SP.SP_NAME, SP.SALES_PERS "+
						//snehasish added 08/02/2006	 to select localityCode & LocalityDescr to be shown with Doctor's Name
						" ,LO.LOCALITY_CODE,LO.DESCR ,DTD.WORK_ROUTE_ID"+
						" FROM  "+
						" STRG_CUSTOMER SC, STRG_SERIES SS, SALES_PERS SP, "+
						//snehasish added 08/02/2006	 to select localityCode & LocalityDescr to be shown with Doctor's Name
						" DR_TRAVEL_DETAILS DTD, LOCALITY LO ,SPRS_ROUTE SR"+
						" WHERE " +
						" SC.SC_CODE = SS.SC_CODE "+
						" AND   DTD.SALES_PERS = '"+salesPers+"' "+
						" AND   DTD.WORK_DATE = '"+workDate+"' "+
						//snehasish added 08/02/2006	 to select localityCode & LocalityDescr to be shown with Doctor's Name
						" AND   DTD.SALES_PERS_MGR = SS.SALES_PERS "+
						" AND   SP.SALES_PERS = SS.SALES_PERS"+
						" AND   DTD.WORK_ROUTE_ID = SS.ROUTE_ID "+
						" AND   SS.STATUS = 'Y' "+
						//snehasish added 08/02/2006	 to select localityCode & LocalityDescr to be shown with Doctor's Name Start
						"  AND   DTD.SALES_PERS_MGR = SR.SPRS_CODE "+
						"  AND   DTD.WORK_ROUTE_ID = SR.ROUTE_ID "+
						"  AND   SR.LOCALITY_CODE =  LO.LOCALITY_CODE "+
						//snehasish added 08/02/2006	 to select localityCode & LocalityDescr to be shown with Doctor's Name End
						" ORDER BY FIRST_NAME, MIDDLE_NAME, LAST_NAME ";
				//System.out.println ("MedRep  selectDoctors ()::selectDoctorQuery ["+selectDoctorQuery+"]");
				stmt = con.createStatement();
				rs = stmt.executeQuery(selectDoctorQuery);				
				while(rs.next())
				{					
					sortID = Utilities.checkNull(rs.getString("SHORT_ID"));
					strDoctorCode = Utilities.checkNull(rs.getString("SC_CODE"))+"-"+rs.getString("SALES_PERS");
					doctorCode.addElement(strDoctorCode);
					firstName = Utilities.checkNull(rs.getString("FIRST_NAME"));
					middleName = Utilities.checkNull( rs.getString("MIDDLE_NAME"));
					lastName = Utilities.checkNull(rs.getString("LAST_NAME"));
					//snehasish added 08/02/2006
					doctorLocality =  Utilities.checkNull(rs.getString("DESCR"));
					//snehasish added doctorLocality 08/02/2006
					strDoctorName = getFormatedName(firstName,middleName,lastName,doctorLocality,sortID,"C");
					doctorName.addElement(strDoctorName);
					routId = Utilities.checkNull(rs.getString("WORK_ROUTE_ID"));
					//snehasish added 08/02/2006
					locCode = Utilities.checkNull(rs.getString("LOCALITY_CODE"));
					//snehasish added 08/02/2006
					locCodeDesc = doctorLocality+"~"+locCode+"#"+routId;
					//snehasish added 08/02/2006
					doctorLocCodeDescr.addElement(locCodeDesc);
					strclass_code=Utilities.checkNull(rs.getString("CLASS_CODE"));
					class_code.addElement(strclass_code);
					strnovisit=Utilities.checkNull( String.valueOf(rs.getInt("NO_VISIT")) );
					novisit.addElement( strnovisit );
					strsplcode=Utilities.checkNull( rs.getString("SPL_CODE") );
					splcode.addElement( strsplcode );

					strSpCdName=Utilities.checkNull( " , "+rs.getString("SP_NAME")+"("+rs.getString("SALES_PERS")+")" );
					spCdName.addElement( strSpCdName );
				}
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				
			}
			else if( doctorCat.equalsIgnoreCase( "N" ) )
			{
				selectDoctorQuery = " SELECT " + 
						" SC_CODE, FIRST_NAME, MIDDLE_NAME, LAST_NAME, STAN_CODE " +
						" FROM  NCL_STRG_CUSTOMER " +
						" WHERE " + 
						" STAN_CODE "+whereClauseForTown+" ORDER BY LAST_NAME ";

				stmt = con.createStatement();
				rs = stmt.executeQuery(selectDoctorQuery);
				while(rs.next())
				{
					strDoctorCode = Utilities.checkNull( rs.getString("SC_CODE") );
					doctorCode.addElement( strDoctorCode );
					firstName = Utilities.checkNull( rs.getString("FIRST_NAME") );
					middleName = Utilities.checkNull( rs.getString("MIDDLE_NAME") );
					lastName = Utilities.checkNull( rs.getString("LAST_NAME") );
					//snehasish added doctorLocality 08/02/2006
					strDoctorName = getFormatedName( firstName, middleName, lastName, doctorLocality, strDoctorCode, "N" );
					doctorName.addElement(strDoctorName);
				}
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
			}
			// Throw exception if there are no doctors

			//System.out.println ("MedRep selectDoctors ()::	BEFORE THROWING EXCEPTION doctorCode.size()["+doctorCode.size()+"]");
			if(doctorCode.size()==0)
			{
				throw new SavexException("No Doctor In Town");
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
	}

	/** 
	 * This method gives the format in which the name to be displayed
	 *
	 *
	 * @param   connection   
	 * @param   String firstName 
	 * @param   String middleName
	 * @param   String lastName
	 * @param   String doctorCode
	 */
	//snehasish added localityDescr 08/02/2006
	String  getFormatedName( String firstName, String  middleName, String lastName , String localityDescr, String doctorCode, String formatCode )
	{
		String retName = "";
		if( formatCode.equals("C") )
		{
			switch ( nameFormat )
			{
			case 1: retName =  firstName + " " + middleName + " "  + lastName;
			break;	
			//snehasish added localityDescr 08/02/2006
			case 2: retName =  firstName + "  "  + middleName + " " + lastName  +"  -  "+localityDescr+ " ("+doctorCode+")" ;

			break;	
			default: retName = lastName + " " + firstName + " "  + middleName;
			}		
		}	
		else
		{
			switch ( nameFormat )
			{
			case 1: retName =  firstName + " " + middleName + " "  + lastName;
			break;	
			case 2: retName =  firstName + "  "  + middleName + " " + lastName  ;

			break;	
			default: retName = lastName + " " + firstName + " "  + middleName;
			}		

		}
		return retName;
	}

	/** 
	 * This method get the sample which PSR can distribute
	 * For the phase-1 this method will populate all the samples that are related to its division
	 * For the phase-2 this method will populate all the samples that are having +ve inventory at PSR
	 * This function is used to populate the product dropdown
	 *
	 * @param   connection   
	 * @param   String salesCode whose samples are required
	 * @param   String sampleType 
				sampleType = "ITEM"  for items and
				sampleType = "GIFT"  for gifts 
	 */

	public void selectSamples ( String salesCode, String sampleType) throws SavexException,Exception
	{	
		ResultSet rs = null;
		Statement stmt = null;
		ResultSet rs1 = null;
		Statement stmt1 = null;

		Connection con = getConnection();
		String whereClause = "";

		String sampleMatch = "";
		String selectSampleQuery = "";
		String itemUsageType = "";
		//Changed by Nazia on 17-Oct-2008 [Now pick up item_usage from property table WS89SUN031]start
		if(sampleType.equalsIgnoreCase("ITEM"))
		{
			//Changed by Nazia on 17-Oct-2008[To support in sql query ITEM_USAGE 17-Oct-2008 where is copaired as ITEM_USAGE IN WS89SUN031]
			//sampleMatch = "S";
			sampleMatch = "'S'";
		}
		else if (sampleType.equalsIgnoreCase("GIFT"))
		{
			//Changed by Nazia on 17-Oct-2008[Display book/literatur along with Gifts WS89SUN031]
			//sampleMatch = "G";
			sampleMatch = "'G','B'";
		}

		if(salesCode.indexOf(",") != -1)
		{
			StringTokenizer salesCdTokens = new StringTokenizer(salesCode, ",");
			String salesCdStr = "";
			while(salesCdTokens.hasMoreTokens())
			{
				salesCdStr+= "'"+salesCdTokens.nextToken().trim()+"',";
			}
			whereClause = "SP.SALES_PERS IN (" + salesCdStr.substring(0,salesCdStr.length()-1).trim() + ")";
			////System.out.println("whereClause:"+whereClause);
		}
		else
		{
			whereClause = "SP.SALES_PERS = '"+salesCode.trim()+"'";
			////System.out.println("whereClause:"+whereClause);
		}

		selectSampleQuery =	" SELECT DISTINCT ITEM_CODE,SP_NAME,SALES_PERS,DESCR FROM "+
				" (SELECT I.ITEM_CODE,SP.SP_NAME,SP.SALES_PERS ,REPLACE(I.DESCR,'\','\\\') DESCR "+
				" FROM "+
				" ITEM I, SPRS_ITEM S ,SALES_PERS SP "+
				" WHERE " +
				" S.ITEM_CODE= I.ITEM_CODE"+
				//Changed by Nazia on 17-Oct-2008[Display book/literatur along with Gifts WS89SUN031]
				//" AND I.ITEM_USAGE = '"+sampleMatch+"'" +
				" AND I.ITEM_USAGE in( "+sampleMatch +")"+
				" AND NVL(S.STATUS,'Y')='Y'"+
				" AND SP.SALES_PERS = S.SALES_PERS"+
				" AND "+whereClause+")"+
				" ORDER BY DESCR ";
		System.out.println(" MedRep: selectSampleQuery ["+selectSampleQuery+"]");
		sampleCode = new Vector();
		sampleName = new Vector();
		psrName = new Vector();
		String strSampleCode = "", strSampleName = "",strPsrName="";

		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectSampleQuery);

			while(rs.next())
			{
				strSampleCode = Utilities.checkNull(rs.getString("ITEM_CODE"));
				sampleCode.addElement(strSampleCode);
				strSampleName = Utilities.checkNull(rs.getString("DESCR"));
				sampleName.addElement(strSampleName);
				strPsrName =Utilities.checkNull("-"+rs.getString("SP_NAME")+"("+rs.getString("SALES_PERS")+")");
				psrName.addElement(strPsrName);
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(stmt !=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		if(sampleCode.size()==0)
		{
			//throw new SavexException("No Samples in the database for the division of this  PSR");
		}
	}

	/** 
	 * This method get the stockist under the territory of the PSR 
	 * @param   connection   
	 * @param   String salesCode whose stockist are required
	 * @param  townCodes in the comma separated  form
	 */
	public void selectStockists ( String salesCode ,String townCodes,String workDate,String salesPers ) throws SavexException,Exception
	{	
		//System.out.println("\nMedRep---selectStockists " );
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String  formattedTownCodes = "",strTownCd = "";
		//formatting the townCodes 
		StringTokenizer st = new StringTokenizer(townCodes,",");
		if(st.hasMoreTokens())
		{
			strTownCd = st.nextToken();
			formattedTownCodes = " A.ROUTE_ID = '" + strTownCd + "'";
		}
		while (st.hasMoreTokens())
		{
			strTownCd = st.nextToken();
			formattedTownCodes = formattedTownCodes + " OR A.ROUTE_ID = '" + strTownCd + "'";
		}

		String formattedSalesCodes = "",strSalesCd = "",salesCodes="",strSalesCd1="";
		//formatting the salesCodes 
		StringTokenizer st1 = new StringTokenizer(salesCode,",");
		if(st1.hasMoreTokens())
		{
			strSalesCd = st1.nextToken();
			formattedSalesCodes = " A.SPRS_CODE ='" + strSalesCd.trim() + "'";
		}
		while (st1.hasMoreTokens())
		{
			strSalesCd = st1.nextToken();
			if(strSalesCd.equalsIgnoreCase("-1"))
				continue;
			formattedSalesCodes = formattedSalesCodes + " OR  A.SPRS_CODE ='" + strSalesCd.trim() + "'";
		}
		StringTokenizer st2 = new StringTokenizer(salesCode,",");
		if(st2.hasMoreTokens())
		{
			strSalesCd1 = st2.nextToken();
			salesCodes = "'" + strSalesCd1.trim() + "'";

		}
		while (st2.hasMoreTokens())
		{
			strSalesCd1 = st2.nextToken();
			if(strSalesCd1.equalsIgnoreCase("-1"))
				continue;
			salesCodes = salesCodes + ",'"  + strSalesCd1.trim() + "'";
		}

		stockistCode = new Vector();
		stockistName = new Vector();
		stockistSpCd = new Vector();
		String strStockistCode = "", strStockistName = "", strstockistSpCd="" ,strSprs_code="";
		//System.out.println("MedRep : selecting stockist .....");
		String selectStockistQuery= " SELECT A.CUST_CODE,B.CUST_NAME,SP.SALES_PERS,SP.SP_NAME "+
				" FROM SPRS_STOCKIST A, "+
				" CUSTOMER B, "+
				" SALES_PERS SP , DR_TRAVEL_DETAILS DTD "+
				" WHERE "+
				" SP.SALES_PERS = A.SPRS_CODE "+
				" AND   DTD.SALES_PERS = '"+salesPers+"'" +
				" AND   DTD.WORK_DATE = '"+workDate+"'" +
				" AND   DTD.SALES_PERS_MGR = A.SPRS_CODE "+ 
				" AND   DTD.WORK_ROUTE_ID = A.ROUTE_ID "+
				" AND A.CUST_CODE=B.CUST_CODE "+
				" AND A.STATUS='Y' " +
				" AND B.CUST_TYPE IN('T','I') AND B.BLACK_LISTED <> 'Y' ";
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectStockistQuery);

			while(rs.next())
			{
				if (!stockistCode.contains(Utilities.checkNull(rs.getString("CUST_CODE"))))
				{
					strStockistCode = Utilities.checkNull(rs.getString("CUST_CODE"));
					stockistCode.addElement(strStockistCode);
					strStockistName = Utilities.checkNull(rs.getString("CUST_NAME"));
					strSprs_code=Utilities.checkNull(rs.getString("SALES_PERS"));
					stockistName.addElement(strStockistName);
					strstockistSpCd= Utilities.checkNull(rs.getString("SP_NAME"));
					stockistSpCd.addElement("-"+strstockistSpCd+"-"+"("+strSprs_code+")");
				}
			}
			if(rs!=null)
			{
				rs.close();
			}
			if (stmt!=null)
			{
				stmt.close();
			}
		}
		catch(SQLException e)
		{
			throw e;
		}
		catch(NullPointerException e)
		{
			throw e;
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}			
		}

		if(stockistCode.size()==0)
		{
			throw new SavexException("No Stockists selected towns of the PSR");
		}
	}

	/** 
	 * This method get the Supervisor name 
	 * @param   connection, sales person code of the supervisor   
	 * @param   String name of supervisor whose code is entered as argument
	 */
	public String selectSuperSalesName ( String superSalesCode) throws SavexException,Exception
	{
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();

		String superSalesName = "";
		String selSuperName = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+superSalesCode+"' ";
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selSuperName);
			if(rs.next())
				superSalesName = rs.getString(1);

			if(rs!=null)
			{
				rs.close();
			}
			if (stmt!=null)
			{
				stmt.close();
			}				
		}
		catch(SQLException e)
		{
			throw e;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw e;
		}
		finally
		{	
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("\nMedRep : selectSuperSalesName :superSalesCode ["+superSalesCode+"]");
		//System.out.println("\nMedRep : selectSuperSalesName : superSalesName :"+superSalesName+":\n");
		return superSalesName;
	}

	/** 
	 * This method get the Supervisor Code 
	 * @param   connection, sales person code 
	 * @return  String code of supervisor whose code is entered as argument
	 */
	public String selectSuperSalesCode (String salesCode) throws SavexException,Exception
	{
		String superSalesCode = "";
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();

		String selSuperCode =	" SELECT A.REPORT_TO, C.LEVEL_NO "+
				" FROM "+
				" EMPLOYEE A, EMPLOYEE B, GRADE C "+
				" WHERE "+
				" A.EMP_CODE = '"+salesCode +"'"+
				" AND A.REPORT_TO = B.EMP_CODE "+
				" AND B.GRADE = C.GRADE_CODE ";
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selSuperCode);
			while(rs.next())
			{
				superSalesCode = Utilities.checkNull(rs.getString("REPORT_TO"))+"-"+Utilities.checkNull(rs.getString("LEVEL_NO"));
			}
			if(rs!=null)
			{
				rs.close();
			}
			if (stmt!=null)
			{
				stmt.close();
			}
		}
		catch(SQLException e)
		{
			throw e;
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return superSalesCode;
	}

	public Vector getAllPSRData( String salesCode, String divCode, String empVal) throws Exception
	{
		Vector PSRVECTOR = new Vector();
		Vector PSRVECTOR1 = new Vector();
		String query = null;
		String query1 = null;
		Connection con = getConnection();
		////System.out.println("MedRep : getAllPSRData : divCode :" +divCode+": empVal :" +empVal);

		//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]

		String fldStaffSiteString = "";
		fldStaffSiteString = getFldStaffSiteList();
		System.out.println("Inside [MedRep][getAllPSRData()]fldStaffSiteString::["+fldStaffSiteString+"]");

		//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]

		if(divCode != null && divCode.length() > 0)
		{

			//System.out.println("MedRep :  HOUSER : Y ");
			if(!empVal.equalsIgnoreCase("true"))
			{

				//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]

				/*	
				query =	" SELECT TRIM(EP.EMP_CODE) ,LTRIM(RTRIM(EP.EMP_FNAME))||''||LTRIM(RTRIM(EP.EMP_MNAME))||' '||LTRIM(RTRIM(EP.EMP_LNAME)) NAME , GR.SH_DESCR "+
						" FROM "+
							" EMPLOYEE EP,GRADE GR "+
						" WHERE "+
							" EP.GRADE = GR.GRADE_CODE  AND EP.EMP_CODE IN "+
								" (SELECT SALES_PERS FROM SALES_PERS WHERE ITEM_SER = '"+divCode+"' ) AND EP.EMP_SITE "+
								" IN ('SP876','ST876','MP876','SP878','SP895') AND EP.RELIEVE_DATE IS NULL ORDER BY NAME ";//EP.EMP_CODE ";
				//snehasish commented & added Name to make sorting alphabetically in hologin 08/12/2006
				 */

				query =	" SELECT TRIM(EP.EMP_CODE) ,LTRIM(RTRIM(EP.EMP_FNAME))||''||LTRIM(RTRIM(EP.EMP_MNAME))||' '||LTRIM(RTRIM(EP.EMP_LNAME)) NAME , GR.SH_DESCR "+" FROM "+" EMPLOYEE EP,GRADE GR "+" WHERE "+" EP.GRADE = GR.GRADE_CODE  AND EP.EMP_CODE IN "+" (SELECT SALES_PERS FROM SALES_PERS WHERE ITEM_SER = '"+divCode+"' ) AND EP.EMP_SITE "+" IN ("+getFormattedStringBuff( fldStaffSiteString )+") AND EP.RELIEVE_DATE IS NULL ORDER BY NAME ";

				//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]

			}
			else
			{
				//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]

				/*				query =  " SELECT TRIM(EP.EMP_CODE), LTRIM(RTRIM(EP.EMP_FNAME))||''||LTRIM(RTRIM(EP.EMP_MNAME))||' '||LTRIM(RTRIM(EP.EMP_LNAME)) NAME ,GR.SH_DESCR  "+
							" FROM "+
								" EMPLOYEE EP,GRADE GR "+
							" WHERE "+
								/* Changed by Nazia on  09-Mar-2009 [Added new AND EP.STATUS<>'S' to avoid retrieval of Employee whose seperation has been done WS89SUN087]"
								EP.GRADE=GR.GRADE_CODE  AND EP.EMP_CODE IN "+*/
				/*								" EP.GRADE=GR.GRADE_CODE AND EP.STATUS<>'S' AND EP.EMP_CODE IN "+
									" (SELECT SALES_PERS FROM SALES_PERS WHERE ITEM_SER = '"+divCode+"' ) AND EP.EMP_SITE IN "+
										" ('SP876','ST876','MP876','SP878','SP895') ORDER  BY NAME ";//EP.EMP_CODE ";
				//snehasish commented & added Name to make sorting alphabetically in hologin 08/12/2006

				 */
				query =  " SELECT TRIM(EP.EMP_CODE), LTRIM(RTRIM(EP.EMP_FNAME))||''||LTRIM(RTRIM(EP.EMP_MNAME))||' '||LTRIM(RTRIM(EP.EMP_LNAME)) NAME ,GR.SH_DESCR  "+" FROM "+" EMPLOYEE EP,GRADE GR "+" WHERE "+" EP.GRADE=GR.GRADE_CODE AND EP.STATUS<>'S' AND EP.EMP_CODE IN "+" (SELECT SALES_PERS FROM SALES_PERS WHERE ITEM_SER = '"+divCode+"' ) AND EP.EMP_SITE IN "+" ("+getFormattedStringBuff( fldStaffSiteString )+") ORDER  BY NAME ";

				//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]
			}
		}
		else
		{
			if((empVal==null) || (!empVal.equalsIgnoreCase("true")))
			{
				//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]

				/*
				query ="SELECT A.EMP_CODE, "
							+"	 LTRIM(RTRIM(A.EMP_FNAME))||''||LTRIM(RTRIM(A.EMP_MNAME))||' '||LTRIM(RTRIM(A.EMP_LNAME)) NAME, "
							+"	 B.SH_DESCR, B.LEVEL_NO FROM EMPLOYEE A, GRADE B "
							+"	 WHERE A.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE "
							+"	 WHERE EMP_SITE IN ('SP876','ST876','MP876','SP878','SP895')  "
							+"  AND RELIEVE_DATE IS NULL "
							+"	  START WITH EMP_CODE = '"+salesCode+"'"
							+ "  CONNECT BY PRIOR EMP_CODE = REPORT_TO) "
							//Changed by Nazia on 12-Mar-2009 [Keep order by NAME first then GRADE_CODE WS89SUN075]
							//+"		AND A.GRADE = B.GRADE_CODE  ORDER BY B.GRADE_CODE, A.EMP_CODE  ";
							+"		AND A.GRADE = B.GRADE_CODE  ORDER BY NAME,B.GRADE_CODE ";
				 */

				query ="SELECT A.EMP_CODE, "
						+"	 LTRIM(RTRIM(A.EMP_FNAME))||''||LTRIM(RTRIM(A.EMP_MNAME))||' '||LTRIM(RTRIM(A.EMP_LNAME)) NAME, "
						+"	 B.SH_DESCR, B.LEVEL_NO FROM EMPLOYEE A, GRADE B "
						+"	 WHERE A.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE "
						+"	 WHERE EMP_SITE IN ("+getFormattedStringBuff( fldStaffSiteString )+")  "
						+"  AND RELIEVE_DATE IS NULL "
						+"	  START WITH EMP_CODE = '"+salesCode+"'"
						+ "  CONNECT BY PRIOR EMP_CODE = REPORT_TO) "
						+"		AND A.GRADE = B.GRADE_CODE  ORDER BY NAME,B.GRADE_CODE ";

				//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]
			}
			else
			{
				//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]				
				/*
				query="SELECT A.EMP_CODE, "
								+" LTRIM(RTRIM(A.EMP_FNAME))||''||LTRIM(RTRIM(A.EMP_MNAME))||' '||LTRIM(RTRIM(A.EMP_LNAME)) NAME, "
								+" B.SH_DESCR, B.LEVEL_NO FROM EMPLOYEE A, GRADE B "
								+" WHERE A.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE "
								+" WHERE EMP_SITE IN ('SP876','ST876','MP876','SP878','SP895') "
								+" START WITH EMP_CODE = '"+salesCode+"'"
								+" CONNECT BY PRIOR EMP_CODE = REPORT_TO) "
								//Changed by Nazia on 12-Mar-2009 [Keep order by NAME first then GRADE_CODE WS89SUN075]
								//+" AND A.GRADE = B.GRADE_CODE ORDER BY B.GRADE_CODE, A.EMP_CODE ";
								+" AND A.GRADE = B.GRADE_CODE ORDER BY NAME,B.GRADE_CODE ";
				 */

				query="SELECT A.EMP_CODE, "
						+" LTRIM(RTRIM(A.EMP_FNAME))||''||LTRIM(RTRIM(A.EMP_MNAME))||' '||LTRIM(RTRIM(A.EMP_LNAME)) NAME, "
						+" B.SH_DESCR, B.LEVEL_NO FROM EMPLOYEE A, GRADE B "
						+" WHERE A.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE "
						+" WHERE EMP_SITE IN ("+getFormattedStringBuff( fldStaffSiteString )+") "
						+" START WITH EMP_CODE = '"+salesCode+"'"
						+" CONNECT BY PRIOR EMP_CODE = REPORT_TO) "
						+" AND A.GRADE = B.GRADE_CODE ORDER BY NAME,B.GRADE_CODE ";

				//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]
			}
		}
		//System.out.println(" divCode ["+divCode+"]");
		//System.out.println(" empVal  ["+empVal+"]");
		System.out.println(" getAllPSRData SQL  ["+query+"]");
		try
		{
			DBOperations dbOpr = new DBOperations( con );
			PSRVECTOR = dbOpr.selectVector(query);
			dbOpr.removeCon();
		}
		catch(Exception e)
		{
			//System.out.println("The Error"+e.getMessage());
		}
		finally
		{
			try
			{
				if(con !=null)
				{
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return PSRVECTOR;
	}

	public Vector getAllStanCode() throws Exception
	{
		//System.out.println("\nMedRep---getAllStanCode");
		Vector SCVECTOR = new Vector();
		Connection con = getConnection();

		String query ="SELECT STAN_cODE FROM STATION ORDER BY STAN_cODE";
		try
		{
			DBOperations dbOpr = new DBOperations( con );
			SCVECTOR = dbOpr.selectVector(query);
			dbOpr.removeCon();
		}
		catch(Exception e)
		{
			//System.out.println("The Error"+e.getMessage());
		}
		
		return SCVECTOR;
	}

	public Vector getAllEmployee(String stanCode) throws Exception
	{
		Vector EMPVECTOR = new Vector();
		stanCode = stanCode.substring(1,stanCode.length()-1);
		Connection con = getConnection();

		//System.out.println("\n\nMedRep : getAllEmployee : stanCode after SubString :" +stanCode+":");

		String query ="SELECT EMP_CODE FROM EMPLOYEE WHERE STAN_CODE = '"+stanCode+"'  ORDER BY EMP_CODE";

		try
		{
			DBOperations dbOpr = new DBOperations( con );
			EMPVECTOR = dbOpr.selectVector(query);
			dbOpr.removeCon();
			////System.out.println("\n\n\nMedRep---getAllEmployee :  EMPVECTOR.toString() :" +EMPVECTOR.toString());
		}
		catch(Exception e)
		{
			//System.out.println("The Error"+e.getMessage());
		}
		return EMPVECTOR;
	}

	/** 
	 * This method get the consignment under the territory of the PSR 
	 * @param   connection   
	 * @param   String salesCode whose consignment are required
	 */
	public void selectCons( String salesCode) throws SavexException,Exception
	{	
		//System.out.println("\nMedRep---selectCons");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();

		conCode = new Vector();
		conName = new Vector();
		String strConCode = "", strConName = "";

		String selectConQuery =	" SELECT CONS_ISSUE FROM CONSUME_ISS"+
				" WHERE EMP_CODE = '"+salesCode+"'"+
				" AND NVL(DELIVERED,'N') ='N'"; 

		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectConQuery);
			while(rs.next())
			{
				strConCode = Utilities.checkNull(rs.getString("CONS_ISSUE"));
				conCode.addElement(strConCode);
				strConName = Utilities.checkNull(rs.getString("CONS_ISSUE"));
				conName.addElement(strConName);
			}

			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		if(conCode.size()==0)
		{
			//throw new SavexException("No consignment in the database for the division of this  PSR");
		}

	}

	// Method to check whether stockist is available in selected route or not
	public String countStockist(String salesCode ,String routeStock) throws SavexException,Exception
	{
		Vector routeVec = new Vector();
		String rouToken ="";
		String routeCodes ="";
		StringTokenizer routeSt = new StringTokenizer(routeStock,",");
		while (routeSt.hasMoreTokens())
		{
			rouToken =routeSt.nextToken().trim();
			//System.out.println("rouToken"+rouToken+":");
			if(!routeVec.contains(rouToken))
			{
				routeVec.addElement(rouToken.trim());
			}
		} 
		routeCodes=routeVec.toString();
		routeCodes=routeCodes.substring(1,routeCodes.length()-1);

		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String  stkFlag = "false";
		String  formattedRouteCodes = "",strTownCd = "";

		StringTokenizer st = new StringTokenizer(routeCodes,",");
		if(st.hasMoreTokens())
		{
			strTownCd = st.nextToken().trim();
			formattedRouteCodes = " A.ROUTE_ID = '" + strTownCd + "'";
		}
		while (st.hasMoreTokens())
		{
			strTownCd = st.nextToken().trim();
			formattedRouteCodes = formattedRouteCodes + " OR A.ROUTE_ID = '" + strTownCd.trim() + "'";
		}

		String  formatSalesCodes = "",strSalesCd = "",salesCodes="",strSalesCd1="";
		//formatting the salesCodes 
		StringTokenizer st1 = new StringTokenizer(salesCode,",");
		if(st1.hasMoreTokens())
		{
			strSalesCd = st1.nextToken();
			formatSalesCodes = " A.SPRS_CODE ='" + strSalesCd.trim() + "'";
		}
		while (st1.hasMoreTokens())
		{
			strSalesCd = st1.nextToken();
			if(strSalesCd.equalsIgnoreCase("-1"))
				continue;
			formatSalesCodes = formatSalesCodes + " OR  A.SPRS_CODE ='" + strSalesCd.trim() + "'";
		}
		StringTokenizer st2 = new StringTokenizer(salesCode,",");
		if(st2.hasMoreTokens())
		{
			strSalesCd1 = st2.nextToken();
			salesCodes = "'" + strSalesCd1.trim() + "'";
		}
		while (st2.hasMoreTokens())
		{
			strSalesCd1 = st2.nextToken();
			if(strSalesCd1.equalsIgnoreCase("-1"))
				continue;
			salesCodes = salesCodes + ",'"  + strSalesCd1.trim() + "'";
		}
		String countStockistQuery =  " SELECT COUNT(*) STOCKCOUNT "+
				" FROM SPRS_STOCKIST A, "+
				" CUSTOMER B, SALES_PERS SP "+
				" WHERE ("+formattedRouteCodes +") "+
				" AND ("+formatSalesCodes +") " +			
				" AND SP.SALES_PERS IN ("+salesCodes +") "+
				" AND A.CUST_CODE=B.CUST_CODE "+
				" AND A.STATUS='Y' " +
				" AND B.CUST_TYPE IN('T','I') AND B.BLACK_LISTED <> 'Y' ";

		try
		{
			stmt=con.createStatement();
			rs= stmt.executeQuery(countStockistQuery);
			while(rs.next())
			{
				if(rs.getInt("STOCKCOUNT") >0)
				{
					stkFlag ="true";
				}
			}	
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		//System.out.println("While Returning Value :Final stkFlag:"+stkFlag+":");
		return stkFlag;
	}

	/*
	 *This method is used to find the Doctors Avilability in the selected Routes for the salesPers
	 */
	public String checkDoctors(String salesCode ,String routeStock) throws Exception
	{
		Vector routeVec = new Vector();
		String rouToken ="";
		String routeCodes ="";
		StringTokenizer routeSt = new StringTokenizer(routeStock,",");
		while (routeSt.hasMoreTokens())
		{
			rouToken =routeSt.nextToken().trim();
			//System.out.println("rouToken"+rouToken+":");
			if(!routeVec.contains(rouToken))
			{
				routeVec.addElement(rouToken.trim());
			}
		} 
		routeCodes=routeVec.toString();
		routeCodes=routeCodes.substring(1,routeCodes.length()-1);
		//System.out.println("\nMedRep : checkDoctors : routeCodes :"+routeCodes+":\n");

		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String  docFlag = "false";
		String  formattedRouteCodes = "",strTownCd = "";

		StringTokenizer st = new StringTokenizer(routeCodes,",");
		if(st.hasMoreTokens())
		{
			strTownCd = st.nextToken().trim();
			formattedRouteCodes = " SS.ROUTE_ID = '" + strTownCd + "'";
		}
		while (st.hasMoreTokens())
		{
			strTownCd = st.nextToken().trim();
			formattedRouteCodes = formattedRouteCodes + " OR SS.ROUTE_ID = '" + strTownCd.trim() + "'";
		}

		String  formatSalesCodes = "",strSalesCd = "",salesCodes="",strSalesCd1="";
		//formatting the salesCodes 
		StringTokenizer st1 = new StringTokenizer(salesCode,",");
		if(st1.hasMoreTokens())
		{
			strSalesCd = st1.nextToken();
			formatSalesCodes = " SS.SALES_PERS  ='" + strSalesCd.trim() + "'";
		}
		while (st1.hasMoreTokens())
		{
			strSalesCd = st1.nextToken();
			if(strSalesCd.equalsIgnoreCase("-1"))
				continue;
			formatSalesCodes = formatSalesCodes + " OR  SS.SALES_PERS  ='" + strSalesCd.trim() + "'";
		}
		StringTokenizer st2 = new StringTokenizer(salesCode,",");
		if(st2.hasMoreTokens())
		{
			strSalesCd1 = st2.nextToken();
			salesCodes = "'" + strSalesCd1.trim() + "'";
		}
		while (st2.hasMoreTokens())
		{
			strSalesCd1 = st2.nextToken();
			if(strSalesCd1.equalsIgnoreCase("-1"))
				continue;
			salesCodes = salesCodes + ",'"  + strSalesCd1.trim() + "'";
		}
		String checkDoctorsQuery = " SELECT  COUNT(*) DOCCOUNT "+
				" FROM  STRG_CUSTOMER SC,STRG_SERIES SS ,SALES_PERS SP " +
				" WHERE"+
				" SC.SC_CODE = SS.SC_CODE" +
				" AND	SP.SALES_PERS = SS.SALES_PERS" +
				" AND  ("+ formattedRouteCodes +")"+
				" AND  ("+ formatSalesCodes +")"+
				" AND SS.STATUS = 'Y'" ;
		try
		{
			stmt=con.createStatement();
			rs= stmt.executeQuery(checkDoctorsQuery);
			while(rs.next())
			{
				if(rs.getInt("DOCCOUNT") >0)
				{
					docFlag ="true";
				}
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		//System.out.println("While Returning Value :Final docFlag:"+docFlag+":");
		return docFlag;
	}

	/*
	 *	This Method will return the maximum dayas allowed for reporting.
	 */
	//Changed by Nazia on 18-Aug-2008[Added new argument to Apply property values depending on Division WS89SUN007]
	//	public String maxAllowPrd(DBConnection dbCon) throws Exception // Show the status only 
	public String maxAllowPrd( String salesCode ) throws Exception // Show the status only 
	{
		//System.out.println("\n Inside  method maxAllowPrd");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String alwdPrd = "-1";
		String statusQuery ="";

		//Changed by Nazia on 18-Aug-2008[to store Division WS89SUN007]
		//MedRep mr = new MedRep();
		//String itemSer = mr.selectDivision(dbCon,salesCode);
		String itemSer = selectDivision(salesCode);
		System.out.println("MedRep.java : MR.selectDivision()= itemSer ["+itemSer+"]");		
		//Changed by nazia on 07-05-09[ALLWD_DELAY_PRD column is shifted in SALE_PERS table.Changes done to get value from SALES_PERS table.WS89SUN098]
		/*if (!isPresentPropDiv(dbCon,"ALLWD_DELAY_PRD",salesCode))
		{
			statusQuery =" SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME ='ALLWD_DELAY_PRD' AND upper(ITEM_SER) ='ALL'";
		}
		else
		{*/
		//statusQuery =" SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME ='ALLWD_DELAY_PRD'AND ITEM_SER ='"+itemSer+"' ";
		statusQuery =" SELECT ALLWD_DELAY_PRD FROM SALES_PERS WHERE SALES_PERS='"+salesCode+"'";
		//}
		System.out.println(" statusQuery ALLWD_DELAY_PRD " +statusQuery );
		try
		{
			stmt = con.createStatement();
			rs=stmt.executeQuery(statusQuery);
			while(rs.next())
			{
				//Changed by nazia on 07-05-09[WS89SUN098]
				//alwdPrd =rs.getString("PROP_VALUE");
				alwdPrd =rs.getString("ALLWD_DELAY_PRD");
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
			System.out.println("MedRep:: alwdPrd ["+alwdPrd+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		return alwdPrd;
	}
	/* start
	 * This method checks days for missing report
	 Author:Nazia 9-Jun-2007
	 */
	public String msgReportDays() throws Exception 
	{	
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String msgReportDaysQuery = "";
		String msgReportDays = "";

		msgReportDaysQuery = " SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME ='MSG_REPORT_DAYS'";
		try
		{
			stmt = con.createStatement();
			rs=stmt.executeQuery(msgReportDaysQuery);
			while(rs.next())
			{
				msgReportDays = rs.getString("PROP_VALUE");
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		return msgReportDays;
	}

	/* end Nazia 9-Jun-2007



	/*
	 * This method checks the status of PSR [allowed to enter the report or not]
	 */
	public String chkPSRAllow( String salesCode) throws Exception 
	{
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String psrStatus ="";
		String updateQuery ="";
		String statusQuery ="";
		String chkStatus ="true";

		statusQuery =" SELECT LOCK_STATUS FROM SALES_PERS WHERE SALES_PERS='"+salesCode+"'" ;
		try
		{
			stmt = con.createStatement();
			rs=stmt.executeQuery(statusQuery);
			while(rs.next())
			{
				psrStatus =rs.getString("LOCK_STATUS");
			}

			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
			//System.out.println("\n MedRep chkPSRAllow :psrStatus:"+psrStatus+":");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		if(psrStatus.equals("0"))
		{
			try
			{
				stmt = con.createStatement();
				updateQuery = "UPDATE SALES_PERS SET LOCK_STATUS = '1'  WHERE SALES_PERS='"+salesCode+"'";
				int countRec = stmt.executeUpdate(updateQuery);

				con.commit();

				if (stmt!=null)
				{
					stmt.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
			finally
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			}
		}
		else if(psrStatus.equals("2"))
		{
			try
			{
				stmt = con.createStatement();
				updateQuery = "UPDATE SALES_PERS SET LOCK_STATUS = '0'  WHERE SALES_PERS='"+salesCode+"'";
				int cntRec = stmt.executeUpdate(updateQuery);

				con.commit();

				if (stmt!=null)
				{
					stmt.close();
				}

			}

			catch(Exception e)
			{
				e.printStackTrace();
			}
			finally
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			}
		}
		return psrStatus;
	}

	public String chkPSRAllowStatus(String salesCode) throws Exception // Show the status only 
	{
		//System.out.println("\n Inside  method chkPSRAllow");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String psrStatus ="";
		String updateQuery ="";
		String statusQuery ="";
		String chkStatus ="true";

		statusQuery =" SELECT LOCK_STATUS FROM SALES_PERS WHERE SALES_PERS='"+salesCode+"'" ;
		try
		{
			stmt = con.createStatement();
			rs=stmt.executeQuery(statusQuery);
			while(rs.next())
			{
				psrStatus =rs.getString("LOCK_STATUS");
			}	
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return psrStatus;
	}


	/** 
	 * This method select record from the table FIELDACTIVITY
	 *
	 * @param   connection   
	 */
	public void selectActivityCode (String salesCd,String workDate) throws Exception
	{	
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String query = " SELECT A.ACTIVITY_CODE, B.ACTIVITY_TYPE "
				+" B.DESCR FROM DR_TRAVEL_DETAILS A, FIELDACTIVITY B "	
				+" WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND "
				+ " A.SALES_PERS = '"+salesCd+"' AND A.WORK_DATE = '"+workDate+"' ";
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(query);
			while(rs.next())
			{		
				activityName = Utilities.checkNull(rs.getString("DESCR"));
				activityType=Utilities.checkNull(rs.getString("ACTIVITY_TYPE"));
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}

	}

	/*
	 * Returns the Code for the given Activity
	 */
	public Vector selectvActivityCode (String salesCd,String workDate) throws Exception
	{	
		Vector vtSelactivity = new Vector();
		Connection con = getConnection();
		try
		{
			DBOperations dbOpr = new DBOperations(  con  );	
			String query =  " SELECT A.ACTIVITY_CODE, B.ACTIVITY_CODE , "
					+" B.DESCR FROM DR_TRAVEL_DETAILS A, FIELDACTIVITY B "	
					+" WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND "
					+" A.SALES_PERS = '"+salesCd+"' AND A.WORK_DATE = '"+workDate+"'";
			vtSelactivity = dbOpr.selectVector(query);
			dbOpr.removeCon();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return vtSelactivity;
	}

	//to get the level of the selected Employee
	public String selfLevel ( String salesCode) throws SavexException,Exception//snehasish 05/16/2006
	{
		String SalesCodeLevel = "";
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();

		String selSuperCode =	" SELECT  G.LEVEL_NO "+
				" FROM "+
				" EMPLOYEE E, GRADE G  "+
				" WHERE "+
				" E.EMP_CODE = '"+salesCode +"'"+
				" AND E.GRADE = G.GRADE_CODE ";
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selSuperCode);
			while(rs.next())
			{
				SalesCodeLevel = Utilities.checkNull(rs.getString("LEVEL_NO"));
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(SQLException e)
		{
			throw e;
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return SalesCodeLevel;
	}//snehasish 05/16/2006

	//snehasish added to get the default sample & gifts;

	//Changed by Nazia on 18-Aug-2008[New function to Find that this property is depends on Division WS89SUN007]
	boolean isPresentPropDiv(String propName,String salesCode)throws Exception
	{
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		boolean isPresentPropDiv = false;
		String itemSer = selectDivision(salesCode);
		System.out.println("MedRep.java : MR.selectDivision()= itemSer ["+itemSer+"]");

		String record ="";

		String sql =  "SELECT ITEM_SER FROM PROPERTIES WHERE PROP_NAME ='"+propName+"'";
		System.out.println("isPresentPropDiv() sql["+sql+"]");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(sql);
			while (rs.next())
			{				
				record = checkNull(rs.getString("ITEM_SER")).trim();
				if ((itemSer).equalsIgnoreCase(record) )
				{					
					isPresentPropDiv = true;
				}				
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{	
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("return isPresentPropDiv ["+isPresentPropDiv+"]");
		return isPresentPropDiv;		
	}
	//Changed by Nazia on 18-Aug-2008[Find that this property is depends on Division WS89SUN007]


	//Changed by Nazia on 18-Aug-2008[Added new argument to Apply property values depending on Division WS89SUN007]
	//	 public HashMap selectDefaultItem(DBConnection dbCon) throws Exception
	public HashMap selectDefaultItem(String salesCode) throws Exception
	{
		//System.out.println("DailyVisit.java : getting unconfirm report limit ....");

		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String propName = "";
		String PropVal = "";
		HashMap Hm = new HashMap();

		//Changed by Nazia on 18-Aug-2008[to store Division WS89SUN007]
		//MedRep mr = new MedRep();
		//String itemSer = mr.selectDivision(dbCon,salesCode);
		String itemSer = selectDivision(salesCode);
		String selectMaxLimit = "";

		System.out.println("MEDREP.java : MR.selectDivision()= itemSer ["+itemSer+"]");

		if (  isPresentPropDiv("DEFAULT_GIFT",salesCode)||isPresentPropDiv("DEFAULT_ITEM",salesCode))
		{
			selectMaxLimit =  "SELECT PROP_NAME,PROP_VALUE FROM PROPERTIES WHERE PROP_NAME IN('DEFAULT_GIFT', 'DEFAULT_ITEM') AND ITEM_SER ='"+itemSer+"'";
		}
		else
		{
			selectMaxLimit =  "SELECT PROP_NAME,PROP_VALUE FROM PROPERTIES WHERE PROP_NAME IN('DEFAULT_GIFT', 'DEFAULT_ITEM') AND upper(ITEM_SER) ='ALL'";
		}
		////System.out.println("selectMaxLimit"+selectMaxLimit);
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectMaxLimit);
			while(rs.next())
			{
				propName= rs.getString("PROP_NAME");
				PropVal = rs.getString("PROP_VALUE");
				Hm.put (propName,PropVal);
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}

		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return Hm;
	}
	//snehasish added to get the employees Division 08/30/2006
	public String selectEmpDivision(String salesCode) throws Exception  
	{
		//System.out.println("\n Inside  method divitionSelecton");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String empDivision ="";
		String empDivisionQuery ="";
		String chkStatus ="true";

		empDivisionQuery =" SELECT IT.ITEM_SER,IT.SH_DESCR "+
				"	FROM ITEMSER IT,sales_pers SP  "+
				"	WHERE SP.SALES_PERS = '"+salesCode+"'"+
				"	AND  SP.ITEM_SER = IT.ITEM_SER ";
		try
		{
			stmt = con.createStatement();
			rs=stmt.executeQuery(empDivisionQuery);
			while(rs.next())
			{
				empDivision =rs.getString("ITEM_SER");
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return empDivision;
	}
	//snehasish end 08/30/2006

	//Changed by nazia on 11-05-09[New function added to get parameterised message WS89SUN098]Start

	public String getParameterMessage(String salesCode,String parameter)throws  Exception
	{
		//System.out.println("\n Inside  method maxAllowPrd");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();		
		String query ="";
		String message = "";		
		String itemSer = selectDivision(salesCode);
		System.out.println("MedRep.java : MR.selectDivision()= itemSer ["+itemSer+"]");		
		if (!isPresentPropDiv(parameter,salesCode))
		{
			query =" SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME ='"+parameter+"' AND UPPER(ITEM_SER) ='ALL'";
		}
		else
		{
			query =" SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME ='"+parameter+"'AND ITEM_SER ='"+itemSer+"' ";			
		}
		System.out.println(" MedRep:: getParameterMessage():: "+parameter+" query::" +query );
		try
		{
			stmt = con.createStatement();
			rs=stmt.executeQuery(query);
			while(rs.next())
			{				
				message =Utilities.checkNull(rs.getString("PROP_VALUE"));
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
			System.out.println("MedRep:: getParameterMessage()::PROP_VALUE ::["+message+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try {
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return message;
	}


	//Changed by nazia on 11-05-09[WS89SUN098]End

	public String checkNull(String returnStr)
	{
		returnStr = returnStr == null?"":returnStr;
		return returnStr;
	}


	public void removeCon() throws Exception
	{
		try
		{
			if ( con != null )
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
	}

	/*public static void main(String[] args) throws Exception
	{
		//System.out.println("***** MedRep.java *****");
		DBConnection con = new DBConnection();
		try
		{
			MedRep me = new MedRep();
		}
		catch(Exception e)
		{
			 //System.out.println("The exception is"+e.getMessage());
		}
		finally
		{
			con.conClose();
        }
	}*/

	//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]

	public String getFldStaffSiteList()
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String fldStaffSiteString = "";
		String sql = "";
		Connection con = getConnection();
		try
		{
			sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'FIELDSTAFF_SITELIST' AND ITEM_SER = 'ALL'";
			pstmt = con.prepareStatement(sql);
			rs = pstmt.executeQuery();
			System.out.println("Inside [MedRep][getFldStaffSiteList]sql::>"+sql);

			if (rs.next())
			{
				fldStaffSiteString = rs.getString("PROP_VALUE");
				fldStaffSiteString = (fldStaffSiteString == null)? "" : fldStaffSiteString.trim();
				System.out.println("Inside [MedRep][getFldStaffSiteList]fldStaffSiteString::["+fldStaffSiteString+"]");
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}

		}
		catch (Exception exp)
		{
			System.out.println("Inside Exception catch [MedRep][getFldStaffSiteList]Exception:>>"+exp.getMessage());
			exp.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}				
			}
			catch (Exception e)
			{
				System.out.println("Inside Exception finally [MedRep][getFldStaffSiteList]Exception:>>"+e.getMessage());
				e.printStackTrace();
			}
		}
		System.out.println("Returning from [MedRep][getFldStaffSiteList]["+fldStaffSiteString+"]");
		return fldStaffSiteString;
	}

	public String getFormattedStringBuff( String data )
	{
		StringBuffer dataString = new StringBuffer();
		try
		{
			String[] dataArr = null;

			if ( data.indexOf(",") == -1 )
			{
				dataString.append( "'"+data+"'" );
			}
			else
			{
				dataArr = data.split(",");
				for (int i=0; i < dataArr.length; i++ )
				{
					if ( i == 0 )
					{
						dataString.append( "'"+dataArr[i]+"'" );
					}
					else
					{ 
						dataString.append( "," );
						dataString.append( "'"+dataArr[i]+"'" );
					}										
				}
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}	
		return dataString.toString();
	}

	//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]
	//Added by Radheshyam[18/03/2015][to get acc_perm1 values].start
	public String getAccPerm1Value( String userId )
	{
		String accParm = "";
		String actVal = "",actVal1="";
		ResultSet rs =null;
		PreparedStatement pstmt = null;
		Connection con = getConnection();
		System.out.println("new change in medrep");
		try
		{

			String sql = "SELECT UPPER(ACC_PARM1) AS ACC_PARM1 FROM USERS WHERE CODE = ?";
			pstmt =  con.prepareStatement(sql);
			pstmt.setString(1, userId);
			rs = pstmt.executeQuery();
			if(rs.next()) 
			{
				accParm = checkNull(rs.getString("ACC_PARM1")).trim();
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			} 

		}
		catch(Exception e)
		{
			e.printStackTrace();	
		}
		finally 
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			} catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}

		System.out.println("return VALUE OF ACC_PARM1 IS "+accParm);	
		return accParm;
	}



	// Added new method by Vishakha [25.05.2015] [Start]]
	public String getEmpEntityCode( String userId )
	{
		String empCode = "";
		String actVal = "",actVal1="";
		ResultSet rs =null;
		PreparedStatement pstmt = null;
		Connection con = getConnection();
		System.out.println("new change in medrep getEmpEntityCode() ");
		try
		{

			String sql = "SELECT UPPER(EMP_CODE) AS EMP_CODE FROM USERS WHERE CODE = ?";
			pstmt =  con.prepareStatement(sql);
			pstmt.setString(1, userId);
			rs = pstmt.executeQuery();
			if(rs.next()) 
			{
				empCode = checkNull(rs.getString("EMP_CODE")).trim();
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt !=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();	
		}
		finally
		{
			try {
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}

		System.out.println("return VALUE OF empCode IS "+empCode);	
		return empCode;
	}
	// Added new method by Vishakha [25.05.2015] [Start]
	public Vector getAllPSRData(String salesCode, String divCode, String empVal, String userId) throws Exception
	{
		Vector PSRVECTOR = new Vector();
		Vector PSRVECTOR1 = new Vector();
		String query = null;
		String query1 = null;
		String accParm = "";
		Connection con = getConnection();

		String fldStaffSiteString = "";
		fldStaffSiteString = getFldStaffSiteList();
		System.out.println("Inside [MedRep][getAllPSRData()]fldStaffSiteString::["+fldStaffSiteString+"]");
		System.out.println("Called the overloaded method of getAllPSRData");//Added by Aadesh on [31/03/20215]
		System.out.println("empVal is @@@@" + empVal);
		System.out.println("userId is @@@@" + userId);
		accParm = getAccPerm1Value(userId.trim() );
		if(accParm.equalsIgnoreCase("HIERARCHY")&& accParm!= ""&& accParm!= null)
		{
			if((empVal==null) || (!empVal.equalsIgnoreCase("true")))
			{
				// Commented by Vishakha [22.05.2015] [Start]		
				/*query ="SELECT A.EMP_CODE, "
							+"	 LTRIM(RTRIM(A.EMP_FNAME))||''||LTRIM(RTRIM(A.EMP_MNAME))||' '||LTRIM(RTRIM(A.EMP_LNAME)) NAME, "
							+"	 B.SH_DESCR, B.LEVEL_NO FROM EMPLOYEE A, GRADE B "
							+"	 WHERE A.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE "
							+"	 WHERE EMP_SITE IN ("+getFormattedStringBuff( fldStaffSiteString )+")  "
							+"  	 AND RELIEVE_DATE IS NULL "
							+"	 START WITH EMP_CODE = '"+salesCode+"'"
							+"  	 CONNECT BY PRIOR EMP_CODE = REPORT_TO) "
							+"	 AND A.GRADE = B.GRADE_CODE  ORDER BY NAME,B.GRADE_CODE "; */

				// Commented by Vishakha [22.05.2015] [End]

				query = " SELECT A.EMP_CODE, "
						+"	 LTRIM(RTRIM(A.EMP_FNAME))||''||LTRIM(RTRIM(A.EMP_MNAME))||' '||LTRIM(RTRIM(A.EMP_LNAME)) NAME, "
						+"	 B.SH_DESCR, B.LEVEL_NO FROM EMPLOYEE A, GRADE B , SALES_PERS S "
						+"	 WHERE A.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE "
						+"	 WHERE EMP_SITE IN ("+getFormattedStringBuff( fldStaffSiteString )+")  "
						+"  	 AND RELIEVE_DATE IS NULL "
						+"	 START WITH EMP_CODE = '"+salesCode+"'"
						+"  	 CONNECT BY PRIOR EMP_CODE = REPORT_TO) "
						+"	 AND A.GRADE = B.GRADE_CODE  "
						+"	 AND A.EMP_CODE=S.SALES_PERS "
						+"	 AND s.item_ser='"+divCode+"'	"				
						+"	 ORDER BY NAME,B.GRADE_CODE ";


			}
			else
			{
				//// Commented by Vishakha [22.05.2015] [Start]

				/*query="SELECT A.EMP_CODE, "
								+" LTRIM(RTRIM(A.EMP_FNAME))||''||LTRIM(RTRIM(A.EMP_MNAME))||' '||LTRIM(RTRIM(A.EMP_LNAME)) NAME, "
								+" B.SH_DESCR, B.LEVEL_NO FROM EMPLOYEE A, GRADE B "
								+" WHERE A.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE "
								+" WHERE EMP_SITE IN ("+getFormattedStringBuff( fldStaffSiteString )+") "
								+" START WITH EMP_CODE = '"+salesCode+"'"
								+" CONNECT BY PRIOR EMP_CODE = REPORT_TO) "
								+" AND A.GRADE = B.GRADE_CODE ORDER BY NAME,B.GRADE_CODE "; */

				//// Commented by Vishakha [22.05.2015] [End]				


				query=" SELECT A.EMP_CODE, "
						+" LTRIM(RTRIM(A.EMP_FNAME))||''||LTRIM(RTRIM(A.EMP_MNAME))||' '||LTRIM(RTRIM(A.EMP_LNAME)) NAME, "
						+" B.SH_DESCR, B.LEVEL_NO FROM EMPLOYEE A, GRADE B , SALES_PERS S "
						+" WHERE A.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE "
						+" WHERE EMP_SITE IN ("+getFormattedStringBuff( fldStaffSiteString )+") "
						+" START WITH EMP_CODE = '"+salesCode+"'"
						+" CONNECT BY PRIOR EMP_CODE = REPORT_TO) "
						+" AND A.GRADE = B.GRADE_CODE "
						+" AND A.EMP_CODE=S.SALES_PERS "
						+" AND s.item_ser='"+divCode+"' "
						+" ORDER BY NAME,B.GRADE_CODE ";
			}
		}
		else
		{
			if(divCode != null && divCode.length() > 0)
			{

				if(!empVal.equalsIgnoreCase("true"))
				{
					query =	" SELECT TRIM(EP.EMP_CODE) ,LTRIM(RTRIM(EP.EMP_FNAME))||''||LTRIM(RTRIM(EP.EMP_MNAME))||' '||LTRIM(RTRIM(EP.EMP_LNAME)) NAME , GR.SH_DESCR "+" FROM "+" EMPLOYEE EP,GRADE GR "+" WHERE "+" EP.GRADE = GR.GRADE_CODE  AND EP.EMP_CODE IN "+" (SELECT SALES_PERS FROM SALES_PERS WHERE ITEM_SER = '"+divCode+"' ) AND EP.EMP_SITE "+" IN ("+getFormattedStringBuff( fldStaffSiteString )+") AND EP.RELIEVE_DATE IS NULL ORDER BY NAME ";
				}
				else
				{
					query =  " SELECT TRIM(EP.EMP_CODE), LTRIM(RTRIM(EP.EMP_FNAME))||''||LTRIM(RTRIM(EP.EMP_MNAME))||' '||LTRIM(RTRIM(EP.EMP_LNAME)) NAME ,GR.SH_DESCR  "+" FROM "+" EMPLOYEE EP,GRADE GR "+" WHERE "+" EP.GRADE=GR.GRADE_CODE AND EP.STATUS<>'S' AND EP.EMP_CODE IN "+" (SELECT SALES_PERS FROM SALES_PERS WHERE ITEM_SER = '"+divCode+"' ) AND EP.EMP_SITE IN "+" ("+getFormattedStringBuff( fldStaffSiteString )+") ORDER  BY NAME ";
				}
			}
		}
		System.out.println(" getAllPSRData SQL  ["+query+"]");
		try
		{
			if(query != null)
			{
				DBOperations dbOpr = new DBOperations( con );
				PSRVECTOR = dbOpr.selectVector(query);
				dbOpr.removeCon();
				
			}
		}
		catch(Exception e)
		{
			System.out.println("The Error"+e.getMessage());
		}		
		//System.out.println(" PSRVECTOR in meddddreeeeeeeep"+PSRVECTOR+"]");
		return PSRVECTOR;
	}
	//Added by Radheshyam[18/03/2015][to get acc_perm1 values].end
	//Modified by Aadesh on [31/03/2015][To handle the functionality in case of accParm is "HIERARCHY"][Start]
	public Vector selectMgrDivision(String mgrDivCode) throws Exception
	{	

		ResultSet rs = null;
		Statement stmt = null;
    
		String strDivDesc="";
		Vector divDesc = new Vector();
		Connection con = getConnection();

		String selectDivision =   " SELECT ITEM_SER, SH_DESCR FROM ITEMSER " +
				" WHERE PRODUCT_LINE = 'DOM' AND ITEM_SER = '"+mgrDivCode+"'" + "ORDER  BY SH_DESCR ";	

		try
		{
			stmt = con.createStatement();
			rs=stmt.executeQuery(selectDivision);

			if(rs.next())
			{		
				strDivDesc=Utilities.checkNull(rs.getString("ITEM_SER")+"-"+rs.getString("SH_DESCR"));
				divDesc.addElement(strDivDesc);
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt !=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try 
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt !=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
		return divDesc;
	}
	//Modified by Aadesh on [31/03/2015][To handle the functionality in case of accParm is "HIERARCHY"][End]



	//Modified by Vishakha on [22.05.2015][To handle the functionality in case of accParm is "HIERARCHY" for Division][Start]
	public Vector selectMgrHierarcyDivision(String mgrDivCode,String empCode) throws Exception
	{	
		System.out.println("iN selectMgrHierarcyDivision()...");
		ResultSet rs = null;
		Statement stmt = null;
		Vector PSRVECTOR = new Vector();
		String strDivDesc="";
		Vector divDesc = new Vector();
		String fldStaffSiteString = "";
		Connection con = getConnection();
	
		fldStaffSiteString = getFldStaffSiteList();
		System.out.println("Inside [MedRep][selectMgrHierarcyDivision()]fldStaffSiteString::["+fldStaffSiteString+"]");

		String selectDivision =   " SELECT Distinct s.ITEM_SER,I.SH_DESCR "+
				" FROM EMPLOYEE A, GRADE B  , SALES_PERS S, itemser I "+
				" WHERE A.EMP_CODE IN (SELECT EMP_CODE  "+
				" FROM EMPLOYEE "+         
				" WHERE EMP_SITE IN ("+getFormattedStringBuff( fldStaffSiteString )+") AND "+
				" RELIEVE_DATE IS NULL "+     
				" START WITH EMP_CODE = '"+empCode+"' "+
				" CONNECT BY PRIOR EMP_CODE = REPORT_TO)    "+  
				" AND A.GRADE = B.GRADE_CODE "+
				" AND A.EMP_CODE=S.SALES_PERS "+
				" AND s.item_ser=i.item_ser ";
		//" ORDER BY NAME,B.GRADE_CODE; ";	

		try
		{
			stmt = con.createStatement();
			rs=stmt.executeQuery(selectDivision);

			while(rs.next())
			{		
				strDivDesc=Utilities.checkNull(rs.getString("ITEM_SER")+"-"+rs.getString("SH_DESCR"));
				divDesc.addElement(strDivDesc);
				//DBOperations dbOpr = new DBOperations( con );
				//SCVECTOR = dbOpr.selectVector(query);
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt !=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try 
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt !=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
		return divDesc;
	}
	//Modified by Vishakha on [22.05.2015][To handle the functionality in case of accParm is "HIERARCHY" for Division][End]



	//Modified by Aadesh on [01/04/2015][To validate the empCode entered in textbox][Start]
	public String getEmployeeCount( String userId, String loginCode, String empVal )
	{
		String ret = "";
		int count = 0;
		String accParm = "";

		ResultSet rs =null;
		PreparedStatement pstmt = null;
		Connection con = getConnection();
		System.out.println("new change in medrep for employeeCount"+userId);
		System.out.println("new change in medrep for loginCode"+loginCode);
		try
		{
			String sql = "SELECT COUNT(*)AS COUNT FROM sales_pers WHERE sales_pers = ?";
			pstmt =  con.prepareStatement(sql);
			pstmt.setString(1, userId);
			rs = pstmt.executeQuery();
			if(rs.next()) 
			{
				count = rs.getInt("COUNT");
				System.out.println("value of count is @@@@" + count);
			}
			if (rs!= null)       
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)    
			{
				pstmt.close();
				pstmt = null; 
			}  
			if(count>0)
			{
				accParm	= getAccPerm1Value(loginCode);
				if(accParm.equalsIgnoreCase("ALL"))
				{
					System.out.println("accParm    "+accParm);
					count = 2;
				}
				else if(accParm.equalsIgnoreCase("HIERARCHY"))
				{
					System.out.println("accParm    "+accParm);
					int getCont = 0;
					getCont = getHierarchyData(empVal, userId, loginCode);
					if(getCont == 1)
					{
						count = 2;
					}
				}
				else
				{
					String itemSer = "";
					sql = "select item_ser from sales_pers where sales_pers = ?";
					pstmt =  con.prepareStatement(sql);
					pstmt.setString(1, userId);
					rs = pstmt.executeQuery();
					if(rs.next()) 
					{
						itemSer = checkNull(rs.getString("item_ser")).trim();
						System.out.println("value of count is @@@@" + itemSer);
					}
					if (rs!=null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt !=null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(con !=null)
					{
						con.close();
						con = null;
					}
					//System.out.println("itemSer>>>>>>>>>>" + itemSer);
					System.out.println("accParm>>>>>>>>>>" + accParm.contains(itemSer));
					if(accParm.contains(itemSer))
					{
						count = 2;
					}
				}
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();	
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				
			}
		}
		ret = String.valueOf(count);
		System.out.println("return VALUE OF ret IS "+ret);
		return ret ;
	}
	public int getHierarchyData(String empVal, String userId, String loginCode) throws Exception
	{
		
		String query = null;
		int cont = 0;
		ResultSet rs =null;
		PreparedStatement pstmt = null;
		Connection con = getConnection();

		String fldStaffSiteString = "";
		fldStaffSiteString = getFldStaffSiteList();
		if((empVal==null) || (!empVal.equalsIgnoreCase("true")))
		{
			query ="SELECT COUNT(*) AS CNT FROM EMPLOYEE A, GRADE B  WHERE A.EMP_CODE IN  " +
					" (SELECT EMP_CODE  FROM EMPLOYEE " +
					" WHERE EMP_SITE IN ("+getFormattedStringBuff( fldStaffSiteString )+") " +
					" AND RELIEVE_DATE IS NULL   " +
					" START WITH EMP_CODE = (select entity_code from users where code = '"+loginCode+"') " +
					"  CONNECT BY PRIOR EMP_CODE = REPORT_TO) AND A.GRADE = B.GRADE_CODE AND " +
					" A.EMP_CODE = '"+userId+"'";

		}
		else
		{
			query="SELECT COUNT(*) AS CNT FROM EMPLOYEE A, GRADE B  WHERE A.EMP_CODE IN " +
					" (SELECT EMP_CODE  FROM EMPLOYEE " +
					"  WHERE EMP_SITE IN ("+getFormattedStringBuff( fldStaffSiteString )+") " +
					"  START WITH EMP_CODE = (select entity_code from users where code = '"+loginCode+"') " +
					" CONNECT BY PRIOR EMP_CODE = REPORT_TO)  AND A.GRADE = B.GRADE_CODE AND A.EMP_CODE = '"+userId+"'";
		}
		try
		{
			pstmt =  con.prepareStatement(query);
			rs = pstmt.executeQuery();
			if(rs.next()) 
			{
				cont = rs.getInt("CNT");
				System.out.println("get cont in getHierarchyData>>"+cont);
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt !=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			System.out.println("The Error"+e.getMessage());
		}
		finally
		{
			try 
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
		return cont;
	}
	//Modified by Aadesh on [01/04/2015][To validate the empCode entered in textbox][End]
	
	private Connection getConnection()
	{
		Connection con = null;
		ConnDriver connDriver = new ConnDriver();

		if( userInfo !=null )
		{
			try 
			{
				con = connDriver.getConnectDB(userInfo.getTransDB());
			}
			catch (Exception e) 
			{
				e.printStackTrace();
				System.out.println("In DailyVisit GetConnetion Exception : ["+ e.getMessage() +"]");
			}
		}
		return con;
	}
}//end of class