package ibase.webitm.ejb.wsfa.masters;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


public class WsfaDndDealEjb extends ValidatorEJB implements WsfaDndDealEjbRemote, WsfaDndDealEjbLocal
{

 	public String wfValData() throws RemoteException, ITMException
 	{
 		return "";
 	}

 	/**
 	 * This method used for validation.
	 *
 	 */
 	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			System.out.println("xmlString ["+xmlString+"]");
			System.out.println("xmlString1 ["+xmlString1+"]");
			System.out.println("xmlString2 ["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println ( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println ( "Exception:WsfaDndDealEjb:wfValData(String xmlString): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println ( "Returning from WsfaDndDealEjb:wfValData" );
		return (errString);
	}

 	/**
 	 * This method used for validation.
 	 */
 	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String errString = "";
		String sql = "";
		int cnt = 0;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String salesPers="";
		String scCode="";
		String effFromDom="";
		String validUptoDom="";
		int intDtRet = 0;
		Date dtEff = null;
		Date dtVal = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			String columnValue = "";
			int currentFormNo = 0;
			String updateFlag = "";
			conn = getConnection();
			conn.setAutoCommit(false);
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );

			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			switch ( currentFormNo )
			{
				case 1:
				{
					NodeList parentList = dom.getElementsByTagName( "Detail" + currentFormNo );
					NodeList childList = parentList.item( 0 ).getChildNodes();
					int noOfChilds = childList.getLength();
					System.out.println("noOfChilds::::::"+noOfChilds);
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						Node childNode = childList.item( ctr );
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						String childNodeName = childNode.getNodeName();
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						if( "tran_date".equalsIgnoreCase( childNodeName ) )
						{
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString("tran_date","TRANDTBLK",userId);
								break ;
							}
						}
						else if( "sales_pers".equalsIgnoreCase( childNodeName ) )
						{
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString("sales_pers","VMSALESPER",userId);
								break ;
							}
							else if(childNode.getFirstChild() != null)
							{
								salesPers = genericUtility.getColumnValue("sales_pers", dom1);
								sql = "select count(1) from sales_pers where sales_pers = ?";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,salesPers);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt =  rs.getInt(1);
								}
								if(rs != null)
								{
									rs.close(); 
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}

								if(cnt == 0)
								{
									errString = getErrorString("sales_pers","SLPNOTEXT",userId);
									break ;
								}
							}
						}
						else if( "strg_code".equalsIgnoreCase( childNodeName ) )
						{
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString("strg_code","VTNULCUST",userId);
								break ;
							}
							else if(childNode.getFirstChild() != null)
							{
								salesPers = genericUtility.getColumnValue("sales_pers", dom1);
								scCode = genericUtility.getColumnValue("strg_code", dom1);
								sql = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER SC, STRG_SERIES SS WHERE SS.SC_CODE = SC.SC_CODE AND SS.SALES_PERS =  ? AND SC.SC_CODE = ? ";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,salesPers);
								pstmt.setString(2,scCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt =  rs.getInt("COUNT");
								}
								if(rs != null)
								{
									rs.close(); 
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}

								if(cnt == 0)
								{
									errString = getErrorString("strg_code","CUSTNOTEXT",userId);
									break ;
								}
								//Added by Sachin Satre on [21-Jan-19] for checking the same customer is exists in workflow [start]
								System.out.println("editFlag::["+editFlag+"]");
								if(editFlag != null && "A".equalsIgnoreCase(editFlag))
								{
									int wrkFlwCnt = 0 ;
									//sql = "SELECT COUNT(*) AS COUNT FROM DND_DEAL WHERE SALES_PERS = ?  AND STRG_CODE = ?  AND WF_STATUS = 'S'  AND APRV_STAT = 'P' ";
									sql = "SELECT COUNT(*) AS COUNT FROM DND_DEAL WHERE SALES_PERS = ?  AND STRG_CODE = ?  AND APRV_STAT = 'P' ";
									pstmt =  conn.prepareStatement(sql);
									pstmt.setString(1,salesPers);
									pstmt.setString(2,scCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										wrkFlwCnt =  rs.getInt("COUNT");
									}
									if(rs != null)
									{
										rs.close(); 
										rs = null;
									}
									if(pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									System.out.println("wrkFlwCnt::["+wrkFlwCnt+"]");
									if ( wrkFlwCnt > 0)
									{
										errString = getErrorString("strg_code","RECEXTDNDL",userId);
										break ;
									}	
									//Added by Sachin Satre on [21-Jan-19] for checking the same customer is exists in workflow [start]
								}	
							}
						}
						else if( "eff_from".equalsIgnoreCase( childNodeName ) )
						{
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString("eff_from","VTDATEFF",userId);
								break ;
							}
						}
						else if( "valid_upto".equalsIgnoreCase( childNodeName ) )
						{
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString("valid_upto","VTDATE26",userId);
								break ;
							}
							else if(childNode.getFirstChild() != null)
							{
								effFromDom		= genericUtility.getColumnValue("eff_from",dom1);
								validUptoDom	= genericUtility.getColumnValue("valid_upto",dom1);
								dtEff			= genericUtility.getDateObject(effFromDom);
								dtVal			= genericUtility.getDateObject(validUptoDom);
								intDtRet = dtEff.compareTo(dtVal);
								System.out.println("intDtRet["+intDtRet+"]");
								if (intDtRet > 0)
								{
									errString = getErrorString("valid_upto","VEFFDTVLER",userId);
									break;
								}
							}
						}
						//Added by kailash on 28-02-19 [start]
						else if( "wf_status".equalsIgnoreCase( childNodeName ) )
						{
							if(childNode.getFirstChild() != null)
							{
								String tranId	= checkNull(genericUtility.getColumnValue("tran_id",dom));
								String wfStatus = checkNull(genericUtility.getColumnValue("wf_status",dom));
								String aprvStatus = checkNull(genericUtility.getColumnValue("aprv_stat",dom));
								System.out.println("tranId>>>["+tranId+"]");
								String wfStatusDB ="";
								String aprvStatusDB ="";
								if( tranId != null && tranId.trim().length() > 0 )
								{
									String sqlDnd = "SELECT WF_STATUS , APRV_STAT FROM DND_DEAL WHERE TRAN_ID = ? ";
									pstmt = conn.prepareStatement(sqlDnd);
									pstmt.setString(1,tranId);
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										wfStatusDB = checkNull(rs.getString("WF_STATUS"));
										aprvStatusDB = checkNull(rs.getString("APRV_STAT"));
										System.out.println("wfStatusDB>>["+wfStatusDB+"]aprvStatusDB["+aprvStatusDB+"]");
									}
									if(rs != null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if( (wfStatusDB != null && wfStatusDB.trim().length() > 0 ) && (aprvStatusDB != null && aprvStatusDB.trim().length() > 0 ) )
									{
										if( (wfStatus != null && wfStatus.trim().length() > 0 ) && (aprvStatus != null && aprvStatus.trim().length() > 0 ) )
										{
										   if( (wfStatusDB.equalsIgnoreCase(wfStatus) && "S".equalsIgnoreCase(wfStatusDB) ) && (aprvStatusDB.equalsIgnoreCase(aprvStatus) && "R".equalsIgnoreCase(aprvStatusDB) ) )
										   {
											   errString = getErrorString( "wf_status", "ALREADYREJ", userId );
											   break;
										   } 
											
										}
									}
								}
							}
						}
						//Added by kailash on 28-02-19 [end]
					}
					if(errString != null && errString.trim().length() > 0)
					{
						break;
					}
				}//case1
				break;
				case 2:
				{
					ArrayList brandList = new ArrayList();
					NodeList parentList = dom2.getElementsByTagName( "Detail" + currentFormNo );
					int parentListLen = parentList.getLength();

					for (int pCtr = 0; pCtr < parentListLen; pCtr++)
					{
						updateFlag = "";
						columnValue = "";
						String brandCode = "";
						Node parentNode = parentList.item( pCtr );
						NodeList childList = parentNode.getChildNodes();
						int noOfChilds = childList.getLength();
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							Node childNode = childList.item( ctr );
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							String childNodeName = childNode.getNodeName();
							if("attribute".equalsIgnoreCase(childNodeName))
							{
								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
								}
							}
							else if ( "brand_code".equalsIgnoreCase(childNodeName) )
							{
								if ( childNode.getFirstChild() == null )
								{
									errString = getErrorString("brand_code","NULLBRAND",userId);
									break;
								}
								else
								{
									brandCode = checkNull(childNode.getFirstChild().getNodeValue());
							    	String buCode = genericUtility.getColumnValue("item_ser", dom2,"1");
							    	System.out.println("bucode is::["+buCode+"]brandCode"+brandCode);

									int brandCnt = 0;
									//sql="SELECT COUNT(*) AS COUNT FROM BRAND WHERE BRAND_CODE = ? AND ITEM_SER=?";
									sql="SELECT COUNT(*) AS COUNT FROM BRAND WHERE BRAND_CODE = ? ";
									System.out.println("sql>>>>>>["+sql+"]");
									pstmt = conn.prepareStatement(sql);
									System.out.println("pstmt["+pstmt+"]");
									pstmt.setString(1, brandCode);
									///pstmt.setString(2, buCode);
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										brandCnt = rs.getInt("COUNT");
									}
									if( rs != null )
									{
										rs.close();
										rs = null;
									}
									if( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}

									if(brandCnt == 0)
									{
										errString = getErrorString("brand_code","INVBRAND",userId);
										break;
									}

									updateFlag = getAttributeVal(parentNode, "updateFlag");
									if(!"D".equalsIgnoreCase(updateFlag) && brandList.contains(brandCode))
									{
										errString = getErrorString("descr","DUPBRAND",userId);
										break;
									}

								}
							}
							else if ( childNodeName.equalsIgnoreCase("remarks") )
							{
								if ( childNode.getFirstChild() == null )
								{
									errString = getErrorString("remarks","BLNKREMARK",userId);
									break;
								}
							}
						}
						if(!"D".equalsIgnoreCase(updateFlag) && brandCode.length() > 0)
						{
							brandList.add(brandCode);
						}
						if(errString != null && errString.trim().length() > 0)
						{
							break;
						}
					}
				}//case2 end
				break;
			} // End of Switch block
		}
		catch (Exception e)
		{
			System.out.println ( "Exception: WsfaDndDealEjb:wfValData(Document dom): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;

				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;

				}
				if( conn != null )
				{
					conn.close();
					conn = null;

				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDndDealEjb:wfValData :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return (errString);
	}

 	public String itemChanged() throws RemoteException, ITMException
 	{
 		return "";
 	}

 	/**
 	 * This method used for item change.
 	 */
 	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1 ["+xmlString1+"]");
		System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :WsfaDndDealEjb:itemChanged(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ( "returning from WsfaDndDealEjb:itemChanged" );
		return errString;
	}
 	/**
 	 * This method used for item change.
 	 */
 	public String itemChanged( Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{
		String resultString = "";
		String userId = "";
		String salesPers = "";
		String chgTerm = "";
		String sql = "";
		String spName = "";
		String chgDate = "";
		int currentFormNo = 0;
		PreparedStatement pstmt = null;
		Connection connectionObject = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer();

		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			connectionObject = getConnection();
			connectionObject.setAutoCommit(false);
			//userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			String loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");//Added by Sachin Satre [18-Jan-19]
			System.out.println("userId:::::::::"+userId);
			sql =" SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ? ";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, userId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				spName = checkNull(rs.getString("SP_NAME"));
			}
			if(rs != null)
			{
				rs.close();
				rs= null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt= null;
			}
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			chgDate = sdf.format(new java.util.Date());

			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
            valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
			valueXmlString.append( editFlag ).append( "</editFlag>\r\n</Header>\r\n" );
            System.out.println("currentFormNo=========================["+currentFormNo+"]");
            //Added by Sachin Satre on [18-Jan-19] start
            boolean isEmpCodeHO = false ;
			isEmpCodeHO = checkHOEmployee(loginEmpCode ,connectionObject ) ;
			//Added by Sachin Satre on [18-Jan-19] End
			switch ( currentFormNo )
			{
			  	case 1:

					valueXmlString.append( "<Detail1 domID='1' >\r\n" );
					if("itm_default".equalsIgnoreCase(currentColumn))
					{
						System.out.println("value of chgDate"+chgDate);
						valueXmlString.append("<tran_date><![CDATA[").append(checkNull(chgDate)).append("]]></tran_date>\r\n");
						valueXmlString.append("<aprv_stat><![CDATA[").append("P").append("]]></aprv_stat>\r\n");
						//valueXmlString.append("<aprv_stat_descr>").append("<![CDATA[" + "PENDING" + "]]>").append("</aprv_stat_descr>");
						valueXmlString.append("<wf_status><![CDATA[").append("D").append("]]></wf_status>\r\n");
						valueXmlString.append("<ho_approval><![CDATA[").append("N").append("]]></ho_approval>");
						if (isEmpCodeHO ==  true )
						{	
							valueXmlString.append("<sales_pers protect='0'><![CDATA[").append("").append("]]></sales_pers>\r\n");
							valueXmlString.append("<sp_name><![CDATA[").append("").append("]]></sp_name>\r\n");
						}
						else
						{
							valueXmlString.append("<sales_pers protect='1' ><![CDATA[").append(userId).append("]]></sales_pers>\r\n");
							valueXmlString.append("<sp_name protect='1' ><![CDATA[").append(spName).append("]]></sp_name>\r\n");
						}	
					}
					else if("itm_defaultedit".equalsIgnoreCase(currentColumn))
					{/*
						System.out.println("inside in itm_defaultedit");
						String empCodeAprv = checkNull(genericUtility.getColumnValue("emp_code__aprv", dom));
						System.out.println("inside in empCodeAprv"+empCodeAprv);
						if (empCodeAprv != null && empCodeAprv.trim().length() > 0)
						{
							sql = "SELECT (EMP_FNAME || ' ' || EMP_MNAME || ' ' || EMP_MNAME ) AS APPROVER_NAME FROM EMPLOYEE E, USERS U WHERE E.EMP_CODE = U.CODE AND U.CODE = ? ";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, empCodeAprv);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								valueXmlString.append("<approver_name>").append("<![CDATA[" + rs.getString("APPROVER_NAME") + "]]>").append("</approver_name>");
							}
							else
							{
								valueXmlString.append("<approver_name>").append("<![CDATA[" + "" + "]]>").append("</approver_name>");
							}
							if(rs != null)
							{
								rs.close();
								rs= null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt= null;
							}
						}
						String aprvstatus= "";
						String aprvStatus = checkNull(genericUtility.getColumnValue("aprv_stat", dom));
						String tranId = checkNull(genericUtility.getColumnValue("tran_id", dom));
						System.out.println("inside in tranId"+tranId +"aprvStatus["+aprvStatus+"]");
						if (aprvStatus != null && aprvStatus.trim().length() > 0 && tranId != null && tranId.trim().length() > 0)
						{
							sql = "SELECT APRV_STAT AS APRV_STAT FROM DND_DEAL WHERE TRAN_ID = ? ";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, tranId);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								aprvstatus = rs.getString("APRV_STAT");
								if (aprvstatus != null && aprvstatus.trim().length() > 0)
								{
									if(aprvstatus.equalsIgnoreCase("P"))
									{
										valueXmlString.append("<aprv_stat_descr>").append("<![CDATA[" + "Pending" + "]]>").append("</aprv_stat_descr>");
									}
									if(aprvstatus.equalsIgnoreCase("A"))
									{
										valueXmlString.append("<aprv_stat_descr>").append("<![CDATA[" + "Approved" + "]]>").append("</aprv_stat_descr>");
									}
									if(aprvstatus.equalsIgnoreCase("R"))
									{
										valueXmlString.append("<aprv_stat_descr>").append("<![CDATA[" + "Rejected" + "]]>").append("</aprv_stat_descr>");
									}
								}
								
							}
							else
							{
								valueXmlString.append("<aprv_stat_descr>").append("<![CDATA[" + "" + "]]>").append("</aprv_stat_descr>");
							}
							if(rs != null)
							{
								rs.close();
								rs= null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt= null;
							}
						}
					*/
						//Added by kailash on 28-02-19 [start]
						String wfStatus = checkNull(genericUtility.getColumnValue("wf_status",dom));
						String aprvStat = checkNull(genericUtility.getColumnValue("aprv_stat",dom));
						System.out.println("wfStatus["+wfStatus+"]aprvStat["+aprvStat+"]");
						if( wfStatus != null && wfStatus.trim().length() > 0 && aprvStat != null && aprvStat.trim().length() > 0 
								&& "S".equalsIgnoreCase(wfStatus) && "R".equalsIgnoreCase(aprvStat))
						{
							valueXmlString.append("<wf_status protect='1'><![CDATA[").append(wfStatus).append("]]></wf_status>\r\n");
						}
						//Added by kailash on 28-02-19 [end]
					}
					//Added by Sachin Satre on [18-Jan-19]for if login by HO [Start] 
					else if(currentColumn.trim().equalsIgnoreCase("sales_pers"))
					{
						salesPers = genericUtility.getColumnValue("sales_pers", dom);
						sql =" SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ? ";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, salesPers);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							valueXmlString.append("<sp_name>").append("<![CDATA[" + rs.getString("SP_NAME") + "]]>").append("</sp_name>");
						}
						else
						{
							valueXmlString.append("<sp_name>").append("<![CDATA[" + "" + "]]>").append("</sp_name>");
						}
						if(rs != null)
						{
							rs.close();
							rs= null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
					}
					//Added by Sachin Satre on [18-Jan-19]for if login by HO [End]
					else if(currentColumn.trim().equalsIgnoreCase("strg_code"))
					{
						String strgCode = genericUtility.getColumnValue("strg_code", dom);
						sql =" SELECT (STRG_CUSTOMER.FIRST_NAME || ' ' || STRG_CUSTOMER.MIDDLE_NAME || ' ' || STRG_CUSTOMER.LAST_NAME) AS STRG_NAME FROM STRG_CUSTOMER WHERE SC_CODE = ? ";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, strgCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							valueXmlString.append("<strg_name>").append("<![CDATA[" + rs.getString("STRG_NAME") + "]]>").append("</strg_name>");
						}
						else
						{
							valueXmlString.append("<strg_name>").append("<![CDATA[" + "" + "]]>").append("</strg_name>");
						}
						if(rs != null)
						{
							rs.close();
							rs= null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
					}
					else if(currentColumn.trim().equalsIgnoreCase("emp_code__aprv"))
					{
						
						
					}
					else if(currentColumn.trim().equalsIgnoreCase("aprv_stat"))
					{
						
					}
					//Added by Sachin Satre on [18-Jan-19] start
					else if(currentColumn.trim().equalsIgnoreCase("wf_status"))
					{
						String wfStatus = genericUtility.getColumnValue("wf_status", dom);
						String aprvStatus = genericUtility.getColumnValue("aprv_stat", dom);
						System.out.println("wfStatus:::["+wfStatus+"]::aprvStatus:["+aprvStatus+"]::isEmpCodeHO::["+isEmpCodeHO+"]");
						if( isEmpCodeHO == true)
						{
							if( wfStatus != null && "S".equalsIgnoreCase(wfStatus))
							{	
								//valueXmlString.append("<aprv_stat><![CDATA[").append("A").append("]]></aprv_stat>\r\n");
								//valueXmlString.append("<aprv_stat_descr>").append("<![CDATA[" + "APPROVED" + "]]>").append("</aprv_stat_descr>");
								valueXmlString.append("<ho_approval><![CDATA[").append("Y").append("]]></ho_approval>");
								valueXmlString.append("<approval_status><![CDATA[").append("A").append("]]></approval_status>");
								valueXmlString.append("<status_date><![CDATA[").append(chgDate).append("]]></status_date>\r\n");//emp_code__aprv
								valueXmlString.append("<emp_code__aprv><![CDATA[").append(userId).append("]]></emp_code__aprv>\r\n");//
								//valueXmlString.append("<wf_status><![CDATA[").append("D").append("]]></wf_status>\r\n");//status_date
								//valueXmlString.append("<sales_pers><![CDATA[").append(userId).append("]]></sales_pers>\r\n");
								//valueXmlString.append("<sp_name><![CDATA[").append(spName).append("]]></sp_name>\r\n");
							}
							else
							{
								valueXmlString.append("<ho_approval><![CDATA[").append("N").append("]]></ho_approval>");
								valueXmlString.append("<approval_status><![CDATA[").append("P").append("]]></approval_status>");
								valueXmlString.append("<aprv_stat><![CDATA[").append("P").append("]]></aprv_stat>\r\n");
								//valueXmlString.append("<aprv_stat_descr>").append("<![CDATA[" + "PENDING" + "]]>").append("</aprv_stat_descr>");
								valueXmlString.append("<status_date><![CDATA[").append("").append("]]></status_date>\r\n");
								valueXmlString.append("<emp_code__aprv><![CDATA[").append("").append("]]></emp_code__aprv>\r\n");//
							}	
						}
						else
						{
							valueXmlString.append("<ho_approval><![CDATA[").append("N").append("]]></ho_approval>");
						}
						
					}
					//Added by Sachin Satre on [18-Jan-19] End
					valueXmlString.append("</Detail1>\r\n");
					break;
			  case 2 :
				    valueXmlString.append("<Detail2>");
				    
				    if("brand_code".equalsIgnoreCase(currentColumn))
				    {
				    	String Descr="";
				    	String brand = genericUtility.getColumnValue("brand_code", dom);
				    	sql = "SELECT DESCRIPTION FROM BRAND WHERE BRAND_CODE = ?";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, brand);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							Descr = checkNull(rs.getString("DESCRIPTION"));
							valueXmlString.append("<brand_description>").append("<![CDATA[" + Descr + "]]>").append("</brand_description>");
						}
						else
						{
							valueXmlString.append("<brand_description>").append("<![CDATA[" + "" + "]]>").append("</brand_description>");
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
				    }
				    else if("itm_default".equalsIgnoreCase(currentColumn))
					{

					}
				    valueXmlString.append("</Detail2>\r\n");
				    break;


			}//switch statement ends here
			valueXmlString.append("</Root>\r\n");
		}//try block ends here
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaDndDealEjb:itemChanged(Document,String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDndDealEjb:itemChanged :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		resultString = valueXmlString.toString();
		System.out.println("resultString[itemchanged].....::["+resultString+"]");

		return resultString;
	}

 	/**
 	 * For check input string for null
 	 * @param input
 	 * @return
 	 */
 	private String checkNull(String input)
    {
        if (input == null)
        {
            input="";
        }
        return input.trim();
    }
 	private String getAttributeVal(Node parentNode, String attribName)throws ITMException
 	{
 		String attribVal = "";
 		try
 		{
 			NodeList childList = parentNode.getChildNodes();
			int noOfChilds = childList.getLength();

			for (int ctr = 0; ctr < noOfChilds; ctr++)
			{
				Node childNode = childList.item( ctr );
				String childNodeName = childNode.getNodeName();
				if("attribute".equalsIgnoreCase(childNodeName))
				{
					if(childNode.getAttributes().getNamedItem(attribName) != null)
					{
						attribVal = childNode.getAttributes().getNamedItem(attribName).getNodeValue();
						break;
					}
				}
			}
 		}
 		catch(Exception e)
 		{
 			throw new ITMException(e);
 		}
 		System.out.println("attribVal = ["+attribVal+"]");
 		return attribVal;
 	}
 	//Added by Sachin Satre on [18-Jan-19] [Start]
 	private boolean checkHOEmployee( String empCode, Connection conn ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeHO = "";
		String selectSql = "";
		boolean isHo = false ;
		try
		{
			selectSql = "SELECT EMP_CODE FROM USERS A, USER_RIGHTS B " + 
			"WHERE A.EMP_CODE = ? " + 
			"AND A.PROFILE_ID = B.PROFILE_ID " +
			"AND B.APPLICATION = 'MRO' " +
			"AND B.MENU_ROW = 1 " +       
			"AND B.MENU_COL = 1 " +       
			"AND B.MENU_SUBCOL = 1 " +
			"AND B.LEVEL_4 = 1 " +        
			"AND B.LEVEL_5 = 1 " +        
			"AND B.MENU_NAME = 'MR Online Application' ";

			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString( 1, empCode.trim() );
			rs = pstmt.executeQuery();	
			if(rs.next())
			{
				empCodeHO = checkNull(rs.getString("EMP_CODE"));	
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if( empCodeHO != null && empCodeHO.trim().length() > 0 )
			{
				isHo = true ;
			}	
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e1){}
		}
		return isHo;
	}
 	//Added by Sachin Satre on [18-Jan-19] [End]
}


