package ibase.webitm.ejb.wsfa.masters;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.ejb.*;
import javax.naming.InitialContext;
import javax.xml.parsers.*;
import org.w3c.dom.*;

import ibase.ejb.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException; 
import ibase.utility.CommonConstants;

@Stateless
public class SprsStockistStatusChgGWT extends ValidatorEJB 
{
	protected static String database = CommonConstants.DB_NAME;
	GenericUtility genericUtility = GenericUtility.getInstance();
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println("@@@@ ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println("@@@@ Exception: SprsStockistStatusChg: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("@@@@ Returning from SprsStockistStatusChg wfValData");
		return (errString); 
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		System.out.println("@@@@  Sprs_stockist in function wfValData(dom,dom1,dom2)");
		String columnName = "";
		String columnValue = "";
		String userId = "";
		String errString = "";
		String sql = "";
		String salesPerson = "";
		String status = "";
		String statusOld = "";
		String custCode = "";
		String selectSql = "";
		String routeID = "";
		String routeStatus = "";

		String chkStatus = null;
		String chkStatusx = null;

		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		NodeList parentList = null;
		NodeList childList = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;

		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;

		int ctr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;
		int parentNodeListLength =0;
		int childNodeListLength = 0;
		int cntrCust = 0;

		Boolean isErrStringFound = false;

		try
		{
			//ITMDBAccessLocal itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup( "ibase/ITMDBAccessEJB/local" );
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();

			/*	ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			connectionObject = getConnection();


			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1:
				parentList = dom.getElementsByTagName("Detail" + currentFormNo);
				parentNode = parentList.item(0);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for(ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					childNodeName = childNode.getNodeName();

					if(childNodeName.equalsIgnoreCase("sprs_code"))
					{
						if(childNode.getFirstChild() == null)				
						{
							errString = itmDBAccess.getErrorString("sprs_code","NULSPRCODE",userId,errString,connectionObject);	
							break;
						}
						else
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
							if(columnValue != null)
							{	
								sql = "SELECT * FROM SPRS_STOCKIST WHERE SPRS_CODE =?";
								pstmt = connectionObject.prepareStatement(sql);

								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if(!rs.next())
								{
									errString = itmDBAccess.getErrorString("sprs_code","VSPRSCODE",userId,errString,connectionObject);
									break;
								}
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
							}								
						}							
					}
				}
				break;
			case 2:

				parentNodeList = dom2.getElementsByTagName("Detail2");
				parentNodeListLength = parentNodeList.getLength();
				for (int parentListRow = 0; parentListRow < parentNodeListLength; parentListRow++)
				{
					parentNode = parentNodeList.item(parentListRow);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					chkStatus = "";
					chkStatusx = "";

					for (int childListRow = 0; childListRow < childNodeListLength; childListRow++)
					{
						childNode = childNodeList.item(childListRow);
						childNodeName = childNode.getNodeName();

						if (childNodeName.equals("status"))
						{
							if(childNode.getFirstChild()!=null)
							{
								chkStatus = childNode.getFirstChild().getNodeValue();
							}
						}
						if(childNodeName.equals("status_old"))
						{
							if(childNode.getFirstChild()!=null)
							{
								chkStatusx = childNode.getFirstChild().getNodeValue();
							}
						}

					}
					if( !chkStatus.equalsIgnoreCase(chkStatusx) )
					{
						if((!chkStatus.equalsIgnoreCase("Y") && !chkStatus.equalsIgnoreCase("N")))
						{
							isErrStringFound = true;
							errString = itmDBAccess.getErrorString("status","VSTKSTATUS",userId,errString,connectionObject);
							break;
						}
					}

				} 
				if( isErrStringFound == false )
				{
					for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
					{
						parentNode = parentNodeList.item(selectedRow);
						childNodeList = parentNode.getChildNodes();
						childNodeListLength = childNodeList.getLength();

						for (int childRow = 0; childRow < childNodeListLength; childRow++)
						{
							childNode = childNodeList.item(childRow);
							childNodeName = childNode.getNodeName(); 
							if (childNodeName.equals("sprs_code"))
							{
								if(childNode.getFirstChild()!=null)
								{
									salesPerson = childNode.getFirstChild().getNodeValue();
								}
							}
							if (childNodeName.equals("cust_code"))
							{
								if (childNode.getFirstChild()!=null)
								{
									custCode = childNode.getFirstChild().getNodeValue();
								}
							}
							if (childNodeName.equals("status")) 
							{
								if (childNode.getFirstChild()!=null)
								{
									if (childNode.getFirstChild().getNodeValue()!=null)
									{
										status = childNode.getFirstChild().getNodeValue();
									}
								}
							}
							if (childNodeName.equals("status_old"))
							{
								if (childNode.getFirstChild()!=null)
								{
									if (childNode.getFirstChild().getNodeValue()!=null)
									{
										statusOld = childNode.getFirstChild().getNodeValue();
									}
								}
							}
						}
						if ( !status.equals(statusOld) )
						{
							if ( status.equals("Y") || status.equals("N") )
							{
								if ( status.equals("Y") )
								{
									selectSql = "SELECT COUNT(*) FROM CUSTOMER WHERE CUST_CODE = ? AND BLACK_LISTED = 'Y' ";
									pstmt = connectionObject.prepareStatement(selectSql);
									pstmt.setString(1, custCode);
									rs = pstmt.executeQuery();
									if ( rs.next() )
									{
										cntrCust = rs.getInt(1);
									}
									if ( rs != null )
									{
										rs.close();
										rs = null;
									}
									if ( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}
									if (cntrCust > 0)
									{							
										errString = itmDBAccess.getErrorString("status","CUSTBLKLST",userId,errString,connectionObject);
										break;
									}
									selectSql = "SELECT ROUTE_ID FROM SPRS_STOCKIST WHERE SPRS_CODE = ? AND CUST_CODE = ? ";
									pstmt = connectionObject.prepareStatement(selectSql);
									pstmt.setString(1, salesPerson);
									pstmt.setString(2, custCode);

									rs = pstmt.executeQuery();
									if ( rs.next() )
									{
										routeID = rs.getString("ROUTE_ID");
									}
									if ( rs != null )
									{
										rs.close();
										rs = null;
									}
									if ( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}
									selectSql =  "SELECT STATUS FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND ROUTE_ID = ? ";
									pstmt = connectionObject.prepareStatement(selectSql);
									pstmt.setString(1, salesPerson);
									pstmt.setString(2, routeID);
									rs = pstmt.executeQuery();
									if ( rs.next() )
									{
										routeStatus = rs.getString("STATUS");
									}
									if ( rs != null )
									{
										rs.close();
										rs = null;
									}
									if ( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}
									if ( routeStatus != null && routeStatus.trim().equalsIgnoreCase("N"))
									{
										errString = itmDBAccess.getErrorString("status","ROOTINACTV",userId,errString,connectionObject);
										break;
									}
								}
							}
						}
					}
				}
				break;
			}
		}
		catch(SQLException se)
		{
			System.out.println("@@@@ Exception: SprsStockistStatusChg: wfValData(Document dom): " + se.getMessage() + ":");
			errString = genericUtility.createErrorString(se);
		}
		catch(Exception e)
		{
			System.out.println("@@@@ Exception: SprsStockistStatusChg: wfValData(Document dom): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
				}
			}
			catch(Exception e){}
		}
		return (errString);
	}

	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				System.out.println("@@@@ SprsStockistStatusChgGWT :: itemChanged() : xmlString : "+xmlString);
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				System.out.println("@@@@ SprsStockistStatusChgGWT :: itemChanged() : xmlString1 : "+xmlString1);
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				System.out.println("@@@@ SprsStockistStatusChgGWT :: itemChanged() : xmlString2 : "+xmlString2);
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("@@@@ SprsStockistStatusChgGWT :: itemChanged() : ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception :SprsStockistStatusChg :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("returning from SprsStockistStatusChgGWT itemChanged");
		return errString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("@@@@ ITEMCHANGE is called...............................");
		String columnValue = "";				
		Connection connectionObject = null;		
		//Statement stmt = null; 
		PreparedStatement pstmt=null;
		ResultSet rs = null;		
		StringBuffer valueXmlString = new StringBuffer();

		String salesPers = "";
		String salesPersName = "";
		String selectSql = "";
		String objNameDefault = "";
		String loginSite = "";
		String userId = "";

		String userType = ""; // Prashant

		int currentFormNo = 0;
		userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
		String loginCode=genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
		String windowName = "w_sprsstockist_statuschg_gwt";
		try
		{
			/*ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			connectionObject = getConnection();


			columnValue =checkNull(genericUtility.getColumnValue(currentColumn,dom));


			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='UTF-8'?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");


			objNameDefault  = checkNull(getObjNameFromDom( dom2 , "objName" , currentFormNo));
			// Prashant


			userType = getUserType(userId,loginCode,connectionObject);

			// Prashant
			switch (currentFormNo)
			{
			case 1:
				valueXmlString.append( "<Detail1 dbID='' domID='1' objContext='"+currentFormNo+"' objName='"+objNameDefault+"' selected='N'>\r\n" );
				valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n");

				if (currentColumn.trim().equalsIgnoreCase("itm_default")) 
				{
					salesPers = checkNull(genericUtility.getColumnValue("sprs_code",dom));	
					if(salesPers != null && !salesPers.trim().equals("") && !"".equals(salesPers.trim()))
					{
						selectSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ?";
					}
					else
					{
						salesPers = userId.trim();
						selectSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ? ";
					}
					pstmt = connectionObject.prepareStatement(selectSql);
					pstmt.setString(1, salesPers);
					rs = pstmt.executeQuery();
					if ( rs.next() )
					{
						salesPersName = checkNull(rs.getString("SP_NAME"));
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					if(userType != null && !((userType.trim().equalsIgnoreCase("M") || userType.trim().equalsIgnoreCase("H"))))
					{
						valueXmlString.append("<sprs_code protect= '1'>").append("<![CDATA["+salesPers.toUpperCase()+"]]>").append("</sprs_code>\r\n");
						valueXmlString.append("<sp_name>").append("<![CDATA["+salesPersName.trim()+"]]>").append("</sp_name>\r\n");
					}
					else if( userType != null && userType.trim().equalsIgnoreCase("M"))
					{
						valueXmlString.append("<sprs_code>").append("<![CDATA["+salesPers.toUpperCase()+"]]>").append("</sprs_code>\r\n");
						valueXmlString.append("<sp_name>").append("<![CDATA["+salesPersName.trim()+"]]>").append("</sp_name>\r\n");
					}
					else
					{
						valueXmlString.append("<sprs_code>").append("").append("</sprs_code>\r\n");
						valueXmlString.append("<sp_name><![CDATA[").append("").append("]]></sp_name>\r\n");
					}


				}
				else if (currentColumn.trim().equalsIgnoreCase("sprs_code")) 
				{
					columnValue = checkNull(genericUtility.getColumnValue(currentColumn,dom));	
					System.out.println("columnValue=="+columnValue);
					selectSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ?";
					valueXmlString.append("<sprs_code>").append("<![CDATA["+columnValue.toUpperCase()+"]]>").append("</sprs_code>\r\n");
					pstmt = connectionObject.prepareStatement(selectSql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if ( rs.next() )
					{
						salesPersName = checkNull(rs.getString("SP_NAME"));
						valueXmlString.append("<sp_name>").append("<![CDATA["+salesPersName+"]]>").append("</sp_name>\r\n");
					}
					else
					{
						valueXmlString.append("<sp_name><![CDATA[").append("").append("]]></sp_name>\r\n");							
					}

					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}				
				}
				valueXmlString.append("</Detail1>\r\n");
				break;
			case 2 :
			{
				if (currentColumn.trim().equalsIgnoreCase("itm_default")) 
				{
					NodeList parentList = null;
					parentList = dom2.getElementsByTagName("Detail2");						
					String sprsStckstStatChgData = getData(dom1,dom,windowName,xtraParams,connectionObject);

					valueXmlString.append(sprsStckstStatChgData);
				}
			}
			break;
			}
		}
		catch(SQLException se)
		{
			System.out.println("@@@@ Exception: SprsStockistStatusChgGWT: itemChanged(Document,String): " + se.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(se));
		}
		catch(Exception e)
		{
			System.out.println("@@@@ Exception :SprsStockistStatusChgGWT :itemChanged(Document,String):" + e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e){}
		}
		valueXmlString.append("</Root>\r\n");	
		System.out.println("@@@@ \n****ValueXmlString :" + valueXmlString + ":********");
		return valueXmlString.toString();
	}
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("@@@@ ITMException :[SprsStockistStatusChgGWT] :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("@@@@ Exception :[SprsStockistStatusChgGWT] :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}

	private String getObjNameFromDom( Document dom, String attribute , int currFormNo) throws RemoteException,ITMException
	{
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null;			
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return objName;
	}
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams,Connection conn) throws RemoteException,ITMException
	{
		String salesPerson = "";
		String resultString = "";
		String selectSql = "";
		String errString = "";
		int cnt = 0;

		ResultSet rs = null;
		Statement stmt = null;
		PreparedStatement pstmt = null;
		StringBuffer retTabSepStrBuff = new StringBuffer();
		boolean isLocalConn=false;

		
		try
		{  
			if(conn == null)
			{
				conn = getConnection();
				isLocalConn=true;
			}
			
			//Modified by Radheshyam[18/01/2014][to get application date format][Start]
			DateFormat DOB = new SimpleDateFormat(getApplDateFormat());
			//Modified by Radheshyam[18/01/2014][to get application date format][End]

			salesPerson =checkNull(genericUtility.getColumnValue("sprs_code",headerDom));
			StringBuffer valueXmlString = new StringBuffer("<DocumentRoot>\r\n<description>Datawindow Root</description>\r\n<group0>\r\n<description>Group0 description</description>\r\n<Header0>\r\n<description>Header0 members</description>\r\n");
			selectSql = "  SELECT SPRS_STOCKIST.SPRS_CODE,SPRS_STOCKIST.CUST_CODE,SPRS_STOCKIST.STATUS,SPRS_STOCKIST.CHG_USER,SPRS_STOCKIST.CHG_DATE,SPRS_STOCKIST.CHG_TERM,"
					+" CUSTOMER.CUST_NAME,LOCALITY.DESCR,SPRS_STOCKIST.STATUS STATUS_OLD FROM CUSTOMER,"
					+" SPRS_STOCKIST,LOCALITY WHERE ( CUSTOMER.CUST_CODE = SPRS_STOCKIST.CUST_CODE ) AND "
					+" ( CUSTOMER.LOCALITY_CODE = LOCALITY.LOCALITY_CODE ) AND ( SPRS_STOCKIST.SPRS_CODE = '"+ salesPerson +"' )";
			System.out.println("selectSql :: "+selectSql);
			stmt = conn.createStatement();
			rs = stmt.executeQuery(selectSql);
			int domID = 2;
			String chgDate = "";
			java.util.Date chgDateConvert = null;
			while (rs.next())
			{
				chgDateConvert = rs.getTimestamp("CHG_DATE");
				System.out.println("value of change date:"+chgDate);
				chgDate = genericUtility.getValidDateString(chgDateConvert.toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
				System.out.println("value of chgDateConvert:::"+chgDate);
				valueXmlString.append("<Detail2 dbID='' domID='"+domID+"' objContext='"+2+"' objName='sprsstockist_statuschg_gwt' selected='N'>\r\n" );
				valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n");

				//valueXmlString.append("<attribute updateFlag='N' selected='N' />\r\n");
				valueXmlString.append("<cust_code><![CDATA[").append(checkNull(rs.getString("CUST_CODE"))).append("]]></cust_code>\r\n");
				valueXmlString.append("<cust_name><![CDATA[").append(checkNull(rs.getString("CUST_NAME"))).append("]]></cust_name>\r\n");
				valueXmlString.append("<status><![CDATA[").append(checkNull(rs.getString("STATUS"))).append("]]></status>\r\n");
				valueXmlString.append("<locality_descr><![CDATA[").append(checkNull(rs.getString("DESCR"))).append("]]></locality_descr>\r\n");
				valueXmlString.append("<sprs_code><![CDATA[").append(checkNull(rs.getString("SPRS_CODE"))).append("]]></sprs_code>\r\n");
				valueXmlString.append("<status_old><![CDATA[").append(checkNull(rs.getString("STATUS_OLD"))).append("]]></status_old>\r\n");
				valueXmlString.append("<chg_user><![CDATA[").append(checkNull(rs.getString("CHG_USER"))).append("]]></chg_user>\r\n");
				//Modified by Radheshyam[18/01/2014][to get application date format][Start]
				//valueXmlString.append("<chg_date><![CDATA[").append(checkNull(rs.getString("CHG_DATE"))).append("]]></chg_date>\r\n");
				valueXmlString.append("<chg_date><![CDATA[").append(chgDate).append("]]></chg_date>\r\n");
				//Modified by Radheshyam[18/01/2014][to get application date format][End]
				valueXmlString.append("<chg_term><![CDATA[").append(checkNull(rs.getString("CHG_TERM"))).append("]]></chg_term>\r\n");
				valueXmlString.append("</Detail2>\r\n");	
				domID++;

				cnt = cnt + 1;
			}
			rs.close();rs = null;
			stmt.close();stmt = null;

			valueXmlString.append("</Header0>\r\n");
			valueXmlString.append("</group0>\r\n");	
			valueXmlString.append("</DocumentRoot>\r\n");

			System.out.println("@@@@ SprsStockistStatusChgGWT : cnt :: "+cnt);
			System.out.println("@@@@ SprsStockistStatusChgGWT : valueXmlString:::::::::::::"+valueXmlString);
			resultString = valueXmlString.toString();
		}
		catch (SQLException e)
		{
			System.out.println("@@@@ SQLException :SprsStockistStatusChgGWT :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		catch (Exception e)
		{
			System.out.println("@@@@ Exception :SprsStockistStatusChgGWT :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("@@@@ SprsStockistStatusChgGWT : Closing Connection..............");
				retTabSepStrBuff = null;
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (stmt != null)
				{
					stmt.close();
					stmt = null;
				}
				if(isLocalConn &&  conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				errString = e.getMessage();
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("@@@@ resultString from SprsStockistStatusChgGWT : getData() "+resultString);
		return resultString;	
	}//END OF GETDATA

	// Modified by Prashant [28/11/2013][To identify login employee is manager or Ho][Start]

	private String getUserType(String empCode,String loginCode,Connection conn) throws ITMException
	{
		System.out.println("In getUserType() method");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeMGR = "";
		String empCodeHO = "";
		String userType1 = "";
		String selectSql = "";
		boolean isEmpMgr = false;
		try
		{
			selectSql = "SELECT A.EMP_CODE AS EMP_CODE FROM EMPLOYEE A, GRADE B " +
					"WHERE A.EMP_CODE = ? " + 
					"AND A.GRADE = B.GRADE_CODE " + 
					"AND B.GRADE_TYPE = 'M' ";

			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString( 1, empCode );
			System.out.println("[StrgSeriesPsrCopy][getUserType()][selectSQL >>]"+selectSql);
			rs = pstmt.executeQuery();	
			if(rs.next())
			{
				empCodeMGR = checkNull(rs.getString("EMP_CODE"));	
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if (empCodeMGR != null && empCodeMGR.trim().length() > 0)
			{
				userType1 = "M";
				isEmpMgr = true;
			}
			if (isEmpMgr == false)
			{
				selectSql = "SELECT EMP_CODE FROM USERS A, USER_RIGHTS B " + 
						"WHERE A.CODE = ? " + 
						"AND A.PROFILE_ID = B.PROFILE_ID " +
						"AND B.APPLICATION = 'MRO' " +
						"AND B.MENU_ROW = 1 " +       
						"AND B.MENU_COL = 1 " +       
						"AND B.MENU_SUBCOL = 1 " +
						"AND B.LEVEL_4 = 1 " +        
						"AND B.LEVEL_5 = 1 " +        
						"AND B.MENU_NAME = 'MR Online Application' ";

				pstmt = conn.prepareStatement(selectSql);
				pstmt.setString( 1, loginCode );
				System.out.println("[StrgSeriesPsrCopy][getUserType()][selectSQL for HO >>] "+selectSql);
				rs = pstmt.executeQuery();	
				if(rs.next())
				{
					empCodeHO = checkNull(rs.getString("EMP_CODE"));	
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if (empCodeHO != null && empCodeHO.trim().length() > 0)
				{
					userType1 = "H";				
				}
			}	
			System.out.println("[StrgSeriesPsrCopy][getUserType()][userType1 >>]"+userType1);
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e1){}
		}
		return userType1.trim();		
	}
	// Modified by Prashant [28/11/2013][To identify login employee is manager or Ho][End]

}