package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.util.*;
import java.util.Date;
import java.text.DateFormat;
import java.sql.*;

import javax.ejb.*;
import javax.naming.InitialContext;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import java.text.SimpleDateFormat;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;
import ibase.system.config.*;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;
import ibase.utility.CommonConstants;
//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].

public class SalesBudGWTPreSaveEJB extends ValidatorEJB //implements SessionBean
{

	public String preSave()throws RemoteException,ITMException
	{
		return "";
	}

	public String preSave( String domString, String editFlag, String xtraParams,Connection conn ) throws RemoteException,ITMException
	{
		String retString = "";
		String objName = "";
		String tranID = "";
		String sprsCode = "";
		Document dom = null;

		boolean isError = false;

		int deleteSalesBud = 0;
		int deleteSalesBudDet = 0;
		PreparedStatement pstmt = null;
		PreparedStatement delPstmt = null;
		ResultSet rs = null;

		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB( "DriverValidator" );

			GenericUtility genericUtility = GenericUtility.getInstance();
			dom = genericUtility.parseString(domString);
			objName  = getObjNameFromDom( dom, "objName");
			System.out.println("objName["+objName+"]");

			System.out.println("domString SalesBudGWTPreSaveEJB....["+domString+"]");
			tranID = genericUtility.getColumnValue("tran_id", dom, "1", "");
			String prdCode = genericUtility.getColumnValue("prd_code", dom, "1", "");
			String salesPers = genericUtility.getColumnValue("sales_pers__mgr", dom, "1", "");
			System.out.println("prdCode....."+prdCode+"salesPers....."+salesPers);

			String sql = "SELECT TRAN_ID FROM TD_SALES_BUD WHERE SALES_PERS__MGR = ? AND PRD_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,salesPers);
			pstmt.setString(2,prdCode);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				String delSql = "DELETE FROM TD_SALES_BUD_DET WHERE TRAN_ID = ?";
				delPstmt = conn.prepareStatement(delSql);
				delPstmt.setString( 1,rs.getString("TRAN_ID"));
				deleteSalesBudDet = delPstmt.executeUpdate();

				String deleteSql = "DELETE FROM TD_SALES_BUD WHERE TRAN_ID = ?";
				PreparedStatement deletePstmt = conn.prepareStatement(deleteSql);
				deletePstmt.setString( 1,rs.getString("TRAN_ID"));
				deleteSalesBud = deletePstmt.executeUpdate();
				//conn.commit();
				System.out.println("deleteSalesBud......"+deleteSalesBud+", deleteSalesBudDet...."+deleteSalesBudDet);

			}

		}
		catch(Exception e)
        {
            System.out.println("Exception in [SalesBudGWT][preSave] ==>>");
            try {
                conn.rollback();
            } catch (SQLException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            }
            e.printStackTrace();
            throw new ITMException(e);
        }

		finally
		{
			try
			{

				if(rs != null)
				{
					rs.close(); rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close(); pstmt = null;
				}
				if(delPstmt != null)
				{
					delPstmt.close(); delPstmt = null;
				}
				/*if (conn != null)
				{
					conn.close();
					conn = null;
				}	*/

			}
			catch(Exception e)
			{
				System.out.println("Exception :SalesBudGWTPresSave : :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("Return string :"+retString);
		return retString;
	}

	private String getObjNameFromDom( Document dom, String attribute ) throws RemoteException,ITMException
	{
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail1");
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return objName;
	}

	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}


}
