package ibase.webitm.ejb.wsfa.masters;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.InitialContext;
import javax.xml.parsers.*;
import org.w3c.dom.*;

import ibase.ejb.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
//import oracle.jdbc.driver.OraclePreparedStatement;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;

//@Stateless		commented by Sagar M [22 Nov 2018].
public class SprsRoute extends ValidatorEJB implements SprsRouteLocal,SprsRouteRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	protected static String database = CommonConstants.DB_NAME;

	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println("ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception: SprsRouteEJB: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("Returning from SprsRouteEJB wfValData");
		return (errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String columnName = "";
		String columnValue = "";
		String userId = "";
		String errString = "";
		String errCode = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		Statement stmt = null; //Added by jaimin on 13/08/2008 (SY78SUN030)
		ResultSet rs = null;
		String status = "";//Added by Raj- (SY78SUN030) on 26/03/2008
		String localityCode = "";//Added by Raj- (SY78SUN030) on 26/03/2008
		String routeStatus = ""; //Gulzar - 17/09/08
		String sprsCode = "";
		String routeID = "";

		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;

		int intDtRet = 0;
		int ctr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;
		int count = 0;

		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level

		try
		{
			//InitialContext ctx = getInitialContext();
			//ITMDBAccessLocal itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup( "ibase/ITMDBAccessEJB/local" );
			//Commented by vinayak on [11/07/2016] [start]
			/*ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			//Commented by vinayak on [11/07/2016] [end]
			connectionObject = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentList.item(0);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			for(ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item(ctr);
				childNodeName = childNode.getNodeName();
				switch(currentFormNo)
				{
					case 1:
						if(childNodeName.equalsIgnoreCase("sprs_code"))
						{
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString( "sprs_code", "NULSPRCODE", userId );
							}
							else
							{
								String loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode").trim();
								String validateSalesPersSql = "SELECT * FROM SALES_PERS WHERE SALES_PERS = ? AND SALES_PERS IN ( SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR EMP_CODE = REPORT_TO )";
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								pstmt = connectionObject.prepareStatement(validateSalesPersSql);
								pstmt.setString(1, columnValue);
								//pstmt.setString(2, loginCode); //Gulzar - 19/01/2009
								pstmt.setString(2, columnValue); //Gulzar - 19/01/2009
								//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
								rs = pstmt.executeQuery();
								if ( !rs.next() )
								{
									errString = getErrorString( "sprs_code", "SLPNOTVAL", userId );
								}
								if(pstmt != null)
								{
									pstmt.close();
								}
							}
						}
						else if (childNodeName.equalsIgnoreCase("locality_code"))
						{
							routeStatus = genericUtility.getColumnValue("status",dom); //Gulzar - 17/09/08
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString( "locality_code", "NULLOCCODE", userId );
							}
							if(childNode.getFirstChild() != null)
							{
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								if( columnValue != null )
								{
									//String sql = "SELECT LOCALITY_CODE FROM LOCALITY WHERE LOCALITY_CODE = ?"; //Remarked by Raj- (SY78SUN030) on 26/03/2008
									String sql = "SELECT LOCALITY_CODE, STATUS FROM LOCALITY WHERE LOCALITY_CODE = ?"; //Added by Raj- (SY78SUN030) on 26/03/2008
									System.out.println("sql :: "+sql);//Added by jaimin on 11/08/2008 (SY78SUN030)
									pstmt = connectionObject.prepareStatement(sql);
									pstmt.setString(1, columnValue);
									//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
									System.out.println("localityCode :: "+columnValue);//Added by jaimin on 11/08/2008 (SY78SUN030)
									rs = pstmt.executeQuery();
									if ( !rs.next() )
									{
										System.out.println("No record for lacoality code :: "+columnValue);//Added by jaimin on 11/08/2008 (SY78SUN030)
										errString = getErrorString( "locality_code", "LOCNOTEXT", userId );
									}
									//else condition added by Raj- (SY78SUN030) on 26/03/2008
									else
									{
										status = rs.getString(2);
										System.out.println("Status ::"+status+":");//Added by jaimin on 11/08/2008 (SY78SUN030)
										//if (status.equals("N"))//Commented by jaimin on 13/08/2008 (SY78SUN030)
										if ( status != null && status.trim().equals("N") &&  routeStatus.equalsIgnoreCase("Y") )//Addeed by jaimin on 13/08/2008 (SY78SUN030)
										{
											System.out.println("locality Code :: "+columnValue);//Added by jaimin on 11/08/2008 (SY78SUN030)
											errCode = "VTLODEACT";
											errString = getErrorString( "locality_code", errCode, userId );
										}
									}
									if(pstmt != null)
									{
										pstmt.close();
									}
								}
							}
						}
						//Changed by Rajesh 25/02/08 [Reference validation of route Type field added].Start
						else if (childNodeName.equalsIgnoreCase("route_type"))
						{
							if(childNode.getFirstChild() != null)
							{
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								if( columnValue != null )
								{
									String sql = "SELECT FLD_VALUE, DESCR FROM GENCODES WHERE FLD_NAME='ROUTE_TYPE' and mod_name ='W_SPRS_ROUTE' AND FLD_VALUE= ? ";
									pstmt = connectionObject.prepareStatement(sql);
									pstmt.setString(1, columnValue);
									//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
									rs = pstmt.executeQuery();
									if ( !rs.next() )
									{
										errString = getErrorString( "route_type", "RTNOTEXIT", userId );
									}
									if(pstmt != null)
									{
										pstmt.close();
									}
								}
							}
						}
						//Changed by Rajesh 25/02/08 [Reference validation of route Type field added].End
						//changed by rajesh 16/01/2008.[Added Station type column as per requirement from sun].start
						else if(childNodeName.equalsIgnoreCase("station_type"))
						{
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString( "station_type", "NULLSTTYPE", userId );
							}
							else
							{
								String sql = "SELECT STAN_TYPE FROM STANTYPE WHERE STAN_TYPE = ? ";
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								String stanType = genericUtility.getColumnValue("station_type",dom1);
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, stanType);
								//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
								rs = pstmt.executeQuery();
								if ( !rs.next() )
								{
									errString = getErrorString( "station_type", "STNNOTEXIT" ,userId );
								}
								if(pstmt != null)
								{
									pstmt.close();
								}
							}
						}
						//changed by rajesh 16/01/2008.[Added Station type column as per requirement from sun].end
						//Case added by Raj- (SY78SUN030) on 26/03/2008
						/*else if (childNodeName.equalsIgnoreCase("status"))//case Commented by jaimin on 13/08/2008 (SY78SUN030)
						{
							status = genericUtility.getColumnValue("status",dom);
							localityCode = genericUtility.getColumnValue("locality_code",dom);
							stmt = connectionObject.createStatement(); //Added by jaimin on 13/08/2008 (SY78SUN030)
							if (status != null && status.trim().length() > 0 && status.equals("Y"))
							{
								String sql = "SELECT STATUS FROM LOCALITY WHERE LOCALITY_CODE = '" +localityCode+ "' ";
								//rs = pstmt.executeQuery(sql);//Commneted by jaimin on 13/08/2008 (SY78SUN030)
								System.out.println("SQL :: "+sql);// Added by jaimin on 13/08/2008 (SY78SUN030)
								rs = stmt.executeQuery(sql); // Added by jaimin on 13/08/2008 (SY78SUN030)
								if ( !rs.next() )
								{
									errString = getErrorString( "locality_code", "LOCNOTEXT", userId );
								}
								else
								{
									status = rs.getString(1);
									if (status.equals("N"))
									{
										errCode = "VTLODEACT";
										errString = getErrorString( "locality_code", errCode, userId );
									}
								}
								 //Commneted by jaimin on 13/08/2008 (SY78SUN030)
								if(pstmt != null)
								{
									pstmt.close();
								}

								stmt.close(); // Added by jaimin on 13/08/2008 (SY78SUN030)
							}
						}
						*/
						//Start - Added by jaimin on 13/08/2008 (SY78SUN030)
						else if (childNodeName.equalsIgnoreCase("status"))
						{
							String statusDom = genericUtility.getColumnValue("status",dom);
							sprsCode = genericUtility.getColumnValue("sprs_code",dom);
							routeID = genericUtility.getColumnValue("route_id",dom);
							System.out.println("statusDom :: "+statusDom);
							stmt = connectionObject.createStatement();
							localityCode = genericUtility.getColumnValue("locality_code",dom);
							if (statusDom != null && statusDom.trim().length() > 0 && editFlag.equals("E"))
							{
								String sql = "SELECT STATUS FROM LOCALITY WHERE LOCALITY_CODE = '" +localityCode+ "' ";
								System.out.println("SQL :: "+sql);
								rs = stmt.executeQuery(sql);
								if (rs.next())
								{
									status = rs.getString("STATUS");
									System.out.println("status :: "+status);
								}
								rs.close();
								if (status != null && status.trim().length()>0 && status.trim().equals("N") && statusDom.trim().equals("Y"))
								{
									errCode = "VTLODEACT";
									errString = getErrorString( "locality_code", errCode, userId );
									return errString;
								}
							}
							if ( statusDom != null && statusDom.trim().length() > 0 && "N".equalsIgnoreCase(statusDom) )
							{
								String sql = "SELECT COUNT(1) AS COUNT FROM STRG_SERIES WHERE SALES_PERS = '" +sprsCode+ "'  AND ROUTE_ID = '"+routeID+"'  AND STATUS = 'Y' ";
								System.out.println("SQL :: "+sql);
								rs = stmt.executeQuery(sql);
								if (rs.next())
								{
									count = rs.getInt("COUNT");
								}
								rs.close();
								if ( count > 0 )
								{
									errCode = "SERIESSTAT";
									errString = getErrorString( "status", errCode, userId );
									return errString;
								}
								sql = "SELECT COUNT(1) AS COUNT FROM SPRS_STOCKIST WHERE SPRS_CODE = '" +sprsCode+ "'  AND ROUTE_ID = '"+routeID+"'  AND STATUS = 'Y' ";
								System.out.println("SQL :: "+sql);
								rs = stmt.executeQuery(sql);
								if (rs.next())
								{
									count = rs.getInt("COUNT");
								}
								rs.close();
								if ( count > 0 )
								{
									errCode = "STOKSTSTAT";
									errString = getErrorString( "status", errCode, userId );
									return errString;
								}
								sql = "SELECT COUNT(1) AS COUNT FROM SPRS_CHEMIST WHERE SPRS_CODE = '" +sprsCode+ "'  AND ROUTE_ID = '"+routeID+"'  AND STATUS = 'Y' ";
								System.out.println("SQL :: "+sql);
								rs = stmt.executeQuery(sql);
								if (rs.next())
								{
									count = rs.getInt("COUNT");
								}
								rs.close();
								if ( count > 0 )
								{
									errCode = "CHMSTSTAT";
									errString = getErrorString( "status", errCode, userId );
									return errString;
								}
							}
						}
						//End - Added by jaimin on 13/08/2008 (SY78SUN030)
				}
				if (errString != null && errString.trim().length()>0)
				{
					break;
				}
			}
		}
		catch(SQLException se)//Gulzar - 04/09/08 Req ID :SY89SUN019
		{
			System.out.println("Exception: SprsRouteEJB: wfValData(Document dom): " + se.getMessage() + ":");
			errString = genericUtility.createErrorString(se);
		}
		catch(Exception e)
		{
			System.out.println("Exception: SprsRouteEJB: wfValData(Document dom): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e); //added by Kailash on 11-04-2018.
		}
		finally //Gulzar - 04/09/08 Req ID :SY89SUN019
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e){}
		}
		return (errString);
	}

	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception :SprsRouteEJB :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("returning from SprsRouteEJB itemChanged");
		return errString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("SPRS ROUTE EJB ITEMCHANGE");
		String columnValue = "";
		String returnString = "";
		String stanCodeDescr = "";
		String localityDescr ="";
		String stanCode = "";
		String routeId = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer();

		int currentFormNo = 0;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			//Commented by vinayak on [11/07/2016] [start]
			/*ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			//Commented by vinayak on [11/07/2016] [end]
			connectionObject = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			columnValue = genericUtility.getColumnValue(currentColumn,dom);
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][Start]
            //valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='UTF-8'?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
          //Modified by Ganesh [16/05/2013][To add utf-8 in xml format][End]
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			switch (currentFormNo)
			{
				case 1:
					valueXmlString.append("<Detail>\r\n");
					if (currentColumn.trim().equalsIgnoreCase("itm_default"))
					{
						System.out.println("*******************xtraParams["+xtraParams+"]");
						//String salesPers = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"Sprs_code").trim(); //Gulzar - 14/02/09
						String salesPers = genericUtility.getColumnValue("sprs_code",dom); //Gulzar - 14/02/09
						System.out.println("salesPers...........::"+salesPers);
						salesPers = (salesPers == null || salesPers.length() == 0) ? genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode"):salesPers;

						String selSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ?";
						String spName = "";
						String selRouteIdSql ="";

						pstmt = connectionObject.prepareStatement(selSql);
						/*--Commented and Changes below - Gulzar - 04/09/08 Req ID :SY89SUN019
						if ( this.database.toUpperCase().startsWith( "ORACLE" ) )
						{
							((OraclePreparedStatement)pstmt).setFixedCHAR(1,salesPers);
						}
						else
						{
							pstmt.setString(1, salesPers);
						}*/
						pstmt.setString(1, salesPers);
						//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
						rs = pstmt.executeQuery();
						if( rs.next())
						{
							spName = checkNull(rs.getString("SP_NAME"));
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							/*valueXmlString.append("<sprs_code protect='1'>").append(salesPers).append("</sprs_code>\r\n");
							valueXmlString.append("<sp_name>").append(spName).append("</sp_name>\r\n");	*/
							valueXmlString.append("<sprs_code protect='1'><![CDATA[").append(salesPers).append("]]></sprs_code>\r\n");
							valueXmlString.append("<sp_name><![CDATA[").append(spName).append("]]></sp_name>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						else
						{
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							/*valueXmlString.append("<sprs_code protect='1'>").append(salesPers).append("</sprs_code>\r\n");
							valueXmlString.append("<sp_name>").append("").append("</sp_name>\r\n");	*/
							valueXmlString.append("<sprs_code protect='1'><![CDATA[").append(salesPers).append("]]></sprs_code>\r\n");
							valueXmlString.append("<sp_name><![CDATA[").append("").append("]]></sp_name>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						if(pstmt != null)
						{
							pstmt.close();
						}
						/*--Commented and Changes below - Gulzar - 04/09/08 Req ID :SY89SUN019
						if ( this.database.toUpperCase().startsWith( "ORACLE" ) )
						{
							selRouteIdSql = "SELECT MAX(TO_NUMBER(ROUTE_ID)) FROM SPRS_ROUTE WHERE SPRS_CODE = ? ";
							pstmt = connectionObject.prepareStatement(selRouteIdSql);
							((OraclePreparedStatement)pstmt).setFixedCHAR(1,salesPers);
						}
						else
						{
							selRouteIdSql = "SELECT MAX(INTEGER(ROUTE_ID)) FROM SPRS_ROUTE WHERE SPRS_CODE = ? ";
							pstmt = connectionObject.prepareStatement(selRouteIdSql);
							pstmt.setString(1,salesPers);
						}*/
						//selRouteIdSql = "SELECT MAX(INTEGER(ROUTE_ID)) FROM SPRS_ROUTE WHERE SPRS_CODE = ? "; //Gulzar - 9/18/2008
						selRouteIdSql = "SELECT MAX(TO_NUMBER(ROUTE_ID))  FROM SPRS_ROUTE WHERE SPRS_CODE = ? "; //Gulzar - 9/18/2008
						pstmt = connectionObject.prepareStatement(selRouteIdSql);
						pstmt.setString(1,salesPers);
						//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
						rs = pstmt.executeQuery();
						if( rs.next())
						{
							routeId = rs.getString(1);
						}
						if(pstmt != null)
						{
							pstmt.close();
						}
						int routeIdValue = 0;
						if ( routeId != null  && routeId.length() !=0 )
						{
							routeIdValue = (Integer.parseInt(routeId.trim()) + 1);
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<route_id protect='1'>").append(routeIdValue).append("</route_id>\r\n");
							valueXmlString.append("<route_id protect='1'><![CDATA[").append(routeIdValue).append("]]></route_id>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						else
						{
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<route_id protect='1'>").append("").append("</route_id>\r\n");
							valueXmlString.append("<route_id protect='1'><![CDATA[").append("").append("]]></route_id>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}

					}
					else if(currentColumn.trim().equalsIgnoreCase("itm_defaultedit")) //Case added by Gulzar - 18/08/08 Req ID:SY78SUN030
					{
						columnValue = genericUtility.getColumnValue("locality_code",dom);
						//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
						//valueXmlString.append("<locality_code protect = '1'>").append(columnValue).append("</locality_code>\r\n");
						valueXmlString.append("<locality_code protect = '1'><![CDATA[").append(columnValue).append("]]></locality_code>\r\n");
						//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
					}
					else if(currentColumn.trim().equalsIgnoreCase("sprs_code"))
					{
						columnValue = genericUtility.getColumnValue(currentColumn,dom);
						String selSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ?";
						String spName = "";
						String selRouteIdSql ="";

						pstmt = connectionObject.prepareStatement(selSql);
						/*--Commented and Changes below - Gulzar - 04/09/08 Req ID :SY89SUN019
						if ( this.database.toUpperCase().startsWith( "ORACLE" ) )
						{
							((OraclePreparedStatement)pstmt).setFixedCHAR(1,columnValue);
						}
						else
						{
							pstmt.setString(1, columnValue);
						}*/
						pstmt.setString(1, columnValue);
						//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
						rs = pstmt.executeQuery();
						if( rs.next())
						{
							spName = checkNull(rs.getString("SP_NAME"));
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<sp_name>").append(spName).append("</sp_name>\r\n");
							valueXmlString.append("<sp_name><![CDATA[").append(spName).append("]]></sp_name>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						else
						{
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<sp_name>").append("").append("</sp_name>\r\n");
							valueXmlString.append("<sp_name><![CDATA[").append("").append("]]></sp_name>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						if(pstmt != null)
						{
							pstmt.close();
						}
						/*--Commented and Changes below - Gulzar - 04/09/08 Req ID :SY89SUN019
						if ( this.database.toUpperCase().startsWith( "ORACLE" ) )
						{
							selRouteIdSql = "SELECT MAX(TO_NUMBER(ROUTE_ID)) FROM SPRS_ROUTE WHERE SPRS_CODE = ? ";
							pstmt = connectionObject.prepareStatement(selRouteIdSql);
							((OraclePreparedStatement)pstmt).setFixedCHAR(1,columnValue);
						}
						else
						{
							selRouteIdSql = "SELECT MAX(INTEGER(ROUTE_ID)) FROM SPRS_ROUTE WHERE SPRS_CODE = ? ";
							pstmt = connectionObject.prepareStatement(selRouteIdSql);
							pstmt.setString(1,columnValue);
						}*/
						selRouteIdSql = "SELECT MAX(LPAD(TRIM(ROUTE_ID),2,' ')) FROM SPRS_ROUTE WHERE SPRS_CODE = ? ";
						pstmt = connectionObject.prepareStatement(selRouteIdSql);
						pstmt.setString(1,columnValue);
						//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
						rs = pstmt.executeQuery();
						if( rs.next())
						{
							routeId = rs.getString(1);
						}
						if(pstmt != null)
						{
							pstmt.close();
						}
						int routeIdValue = 0;
						if ( routeId != null  && routeId.length() !=0 )
						{
							routeIdValue = (Integer.parseInt(routeId.trim()) + 1);
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<route_id>").append(routeIdValue).append("</route_id>\r\n");
							valueXmlString.append("<route_id><![CDATA[").append(routeIdValue).append("]]></route_id>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						else
						{
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<route_id>").append("").append("</route_id>\r\n");
							valueXmlString.append("<route_id><![CDATA[").append("").append("]]></route_id>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
					}

					else if(currentColumn.trim().equalsIgnoreCase("locality_code"))
					{
						columnValue = genericUtility.getColumnValue(currentColumn,dom);
						String selLocSql = " SELECT LOCALITY.DESCR,LOCALITY.STAN_CODE,STATION.DESCR  FROM LOCALITY,STATION  WHERE LOCALITY_CODE = ?  AND LOCALITY.STAN_CODE = STATION.STAN_CODE";
						pstmt = connectionObject.prepareStatement(selLocSql);
						/*--Commented and Changes below - Gulzar - 04/09/08 Req ID :SY89SUN019
						if ( this.database.toUpperCase().startsWith( "ORACLE" ) )
						{
							((OraclePreparedStatement)pstmt).setFixedCHAR(1,columnValue);
						}
						else
						{
							pstmt.setString(1, columnValue);
						}*/
						pstmt.setString(1, columnValue);
						//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
						rs = pstmt.executeQuery();
						if( rs.next())
						{
							localityDescr = checkNull( rs.getString(1) );
							stanCode = checkNull( rs.getString(2) );
							stanCodeDescr =checkNull( rs.getString(3) );
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							/*valueXmlString.append("<locality_descr>").append(localityDescr).append("</locality_descr>\r\n");
							valueXmlString.append("<stan_code>").append(stanCode).append("</stan_code>\r\n");
							valueXmlString.append("<station_descr>").append(stanCodeDescr).append("</station_descr>\r\n");
							valueXmlString.append("<descr>").append(localityDescr).append("</descr>\r\n");	//Gulzar - 9/26/2008
							valueXmlString.append("<sh_descr>").append(localityDescr).append("</sh_descr>\r\n");	//Gulzar - 9/26/2008 */
							valueXmlString.append("<locality_descr><![CDATA[").append(localityDescr).append("]]></locality_descr>\r\n");
							valueXmlString.append("<stan_code><![CDATA[").append(stanCode).append("]]></stan_code>\r\n");
							valueXmlString.append("<station_descr><![CDATA[").append(stanCodeDescr).append("]]></station_descr>\r\n");
							valueXmlString.append("<descr><![CDATA[").append(localityDescr).append("]]></descr>\r\n");	//Gulzar - 9/26/2008
							valueXmlString.append("<sh_descr><![CDATA[").append(localityDescr).append("]]></sh_descr>\r\n");	//Gulzar - 9/26/2008
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						else
						{
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							/*valueXmlString.append("<locality_descr>").append("").append("</locality_descr>\r\n");
							valueXmlString.append("<stan_code>").append("").append("</stan_code>\r\n");
							valueXmlString.append("<station_descr>").append("").append("</station_descr>\r\n");
							valueXmlString.append("<descr>").append("").append("</descr>\r\n");	//Gulzar - 9/26/2008
							valueXmlString.append("<sh_descr>").append("").append("</sh_descr>\r\n");	//Gulzar - 9/26/2008*/
							valueXmlString.append("<locality_descr><![CDATA[").append("").append("]]></locality_descr>\r\n");
							valueXmlString.append("<stan_code><![CDATA[").append("").append("]]></stan_code>\r\n");
							valueXmlString.append("<station_descr><![CDATA[").append("").append("]]></station_descr>\r\n");
							valueXmlString.append("<descr><![CDATA[").append("").append("]]></descr>\r\n");	//Gulzar - 9/26/2008
							valueXmlString.append("<sh_descr><![CDATA[").append("").append("]]></sh_descr>\r\n");	//Gulzar - 9/26/2008
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						if(pstmt != null)
						{
							pstmt.close();
						}
					}
					valueXmlString.append("</Detail>\r\n");
			}
		}
		catch(SQLException se)//Gulzar - 04/09/08 Req ID :SY89SUN019
		{
			System.out.println("Exception: SprsRouteEJB: itemChanged(Document,String): " + se.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(se));
		}
		catch(Exception e)
		{
			System.out.println("Exception :SprsRouteEJB :itemChanged(Document,String):" + e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
			throw new ITMException(e); //added by Kailash on 11-04-2018.
		}
		finally //Gulzar - 04/09/08 Req ID :SY89SUN019
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
				}
			}
			catch(Exception e){}

		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString :" + valueXmlString + ":********");
		return valueXmlString.toString();
	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :[EmpITDeclNewServlet] :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :[EmpITDeclNewServlet] :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}
}