import com.google.gson.Gson;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;
import org.telegram.telegrambots.meta.TelegramBotsApi;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.updatesreceivers.DefaultBotSession;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MyTelegramBot extends TelegramLongPollingBot {

    private Map<Long, Boolean> firstMessages = new HashMap<>();
    private Set<Long> processedChatIds = new HashSet<>();

    @Override
    public void onUpdateReceived(Update update) {
        if (update.hasMessage() && update.getMessage().hasText()) {
            Message message = update.getMessage();
            Long chatId = message.getChatId();

            // Print the chat ID only once
            System.out.println("New Chat_Id: " + chatId);

            String text = message.getText().trim().toLowerCase();

            // Respond to the user's message
            SendMessage response = new SendMessage();
            response.setChatId(chatId.toString());

            if (text.equals("send table")) {
                // Check if the table has already been sent to this chat ID
                if (processedChatIds.contains(chatId)) {
                    // If the table has already been sent, do not send it again
                    response.setText("Table has already been sent to this chat.");
                } else {
                    // Example JSON data string
                    String jsonData = "{\n" +
                            "  \"data\": [\n" +
                            "    {\"Intents\": \"Area Sales\", \"Invocation\": \"Customer outstanding\"},\n" +
                            "    {\"Intents\": \"Current GL balance of an account\", \"Invocation\": \"What is the outstanding for customer\"},\n" +
                            "    {\"Intents\": \"Customer Sales\", \"Invocation\": \"Show Customer Sales\"},\n" +
                            "    {\"Intents\": \"Division Sale\", \"Invocation\": \"Show Division Sales\"}\n" +
                            "  ]\n" +
                            "}";
                    // Format JSON data into tabular form
                    SendMessage tabularResponse = formatJsonToTable(jsonData);
                    try {
                        execute(tabularResponse);
                        // Add the chat ID to the set of processed chat IDs
                        processedChatIds.add(chatId);
                    } catch (TelegramApiException e) {
                        e.printStackTrace();
                    }
                    return; // Exit the method to prevent sending duplicate responses
                }
            } else {
                response.setText("You say: " + text);
            }

            // Send the response
            try {
                execute(response);
            } catch (TelegramApiException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getBotUsername() {
        return "Telegmtestingbot";
    }

    @Override
    public String getBotToken() {
    	 return "7171570219:AAGkJ9wQEJyJ1f2f2y_eTPQWEaWrn-6fLf0";
    }

    public static void main(String[] args) {
        MyTelegramBot bot = new MyTelegramBot();

        try {
            TelegramBotsApi botsApi = new TelegramBotsApi(DefaultBotSession.class);
            botsApi.registerBot(bot);
        } catch (TelegramApiException e) {
            e.printStackTrace();
        }
    }

    // Format JSON data into tabular form
    public SendMessage formatJsonToTable(String jsonData) {
        SendMessage response = new SendMessage();
        response.setParseMode("HTML");

        // Parse JSON string into Java objects
        Gson gson = new Gson();
        Data data = gson.fromJson(jsonData, Data.class);

        // Format data into a tabular structure
        StringBuilder table = new StringBuilder();
        table.append("<b>Table:</b>\n\n");
        table.append("<pre>");
        table.append("Intents    | Invocation\n");
        table.append("--------|-------\n");
        for (Row row : data.getData()) {
            table.append(String.format("%-8s| %-6d\n", row.getName(), row.getNumber()));
        }
        table.append("</pre>");

        // Set the tabular data as the message text
        response.setText(table.toString());

        return response;
    }

    // Define classes to represent JSON data
    static class Data {
        private List<Row> data;

        public List<Row> getData() {
            return data;
        }

        public void setData(List<Row> data) {
            this.data = data;
        }
    }

    static class Row {
        private String Name;
        private int Number;

        public String getName() {
            return Name;
        }

        public void setName(String name) {
            Name = name;
        }

        public int getNumber() {
            return Number;
        }

        public void setNumber(int number) {
            Number = number;
        }
    }
}
