/********************************************************
	Title : DeleteMeetingPosSave
	Date  : 04/12/12
	Developer:Rakesh kumar
 ********************************************************/

package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessRemote;
import ibase.webitm.ejb.ValidatorEJB;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

//@Stateless		commented by Sagar M [22 Nov 2018].
public class DeleteMeetingPosSave extends ValidatorEJB implements  DeleteMeetingPosSaveLocal,DeleteMeetingPosSaveRemote
{
	public String postSave() throws RemoteException,ITMException
	{
		return "";
	}

	@Override
	public String postSave(String xmlStringAll, String editFlag, String xtraParams, Connection conn) throws RemoteException,ITMException
	{


		String retString="";
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		String userId=null;
		int recordsDeleted = 0;//Added By Dipak On 17 Aug 13
		try
		{
			System.out.println("PostSave Action Called:::");
			NodeList hdrDom = null;
			NodeList detail2dom = null;
			Document dom = null;

			//changed by Rahul Barve on 3-sep-2014
			//GenericUtility genericUtility = GenericUtility.getInstance();
			 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();


			System.out.println("xmlStringAll::"+xmlStringAll);

			dom = genericUtility.parseString(xmlStringAll);
			hdrDom = dom.getElementsByTagName("Detail1");

			String eventDate = checkNull(genericUtility.getColumnValue("event_date", dom, "1"));
			String salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom, "1"));

			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverITM" );
			conn.setAutoCommit(false);
			ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			HashMap objDetailMap = null;
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext initialContext = new InitialContext(appConnect.getProperty());
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//ITMDBAccessRemote itmDBAccess = (ITMDBAccessRemote)initialContext.lookup("ibase/ITMDBAccessEJB/remote");
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]
			System.out.println("In process DeleteMeetingProcessEJB ["+eventDate+"]["+salesPers+"]");

			String dcrID= "";
			String meetSql = "SELECT DCR_ID FROM STRG_MEET WHERE EVENT_DATE = ? AND SALES_PERS = ?";
			pstmt =  conn.prepareStatement(meetSql);
			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
			pstmt.setString(2, salesPers);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				dcrID= rs.getString("DCR_ID");
			}
			if(dcrID != null && dcrID.trim().length() > 0)
			{
				String delActTranSql = "DELETE FROM SPRS_ACT_TRAN WHERE EVENT_DATE = ? AND SALES_PERS =? ";
				PreparedStatement pstmtDelActTran =  conn.prepareStatement(delActTranSql);
				pstmtDelActTran.setTimestamp(1, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
				pstmtDelActTran.setString(2, salesPers);
				pstmtDelActTran.executeUpdate();
				pstmtDelActTran.close(); pstmtDelActTran = null;
				System.out.println("Data From SPRS_ACT_TRAN is deleted");

				String delTravelSql = "DELETE FROM SPRS_TRAVEL WHERE TRAVEL_DATE = ? AND SALES_PERS = ?";

				PreparedStatement pstmtDelTravel =  conn.prepareStatement(delTravelSql);
				pstmtDelTravel.setTimestamp(1, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
				pstmtDelTravel.setString(2, salesPers);
				pstmtDelTravel.executeUpdate();
				pstmtDelTravel.close(); pstmtDelTravel = null;

				String delMeetSql = "DELETE FROM STRG_MEET WHERE EVENT_DATE = ? AND SALES_PERS = ?";

				PreparedStatement pstmtDelMeet =  conn.prepareStatement(delMeetSql);
				pstmtDelMeet.setTimestamp(1, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
				pstmtDelMeet.setString(2, salesPers);
				pstmtDelMeet.executeUpdate();
				pstmtDelMeet.close(); pstmtDelMeet = null;

				String delMeetItemSql = "DELETE FROM STRG_MEET_ITEMS WHERE DCR_ID = ? ";
				PreparedStatement pstmtDelItem =  conn.prepareStatement(delMeetItemSql);
				pstmtDelItem.setString(1, dcrID);
				pstmtDelItem.executeUpdate();
				pstmtDelItem.close(); pstmtDelItem = null;

				String delMeetTeamSql = "DELETE FROM STRG_MEET_TEAM WHERE DCR_ID = ? ";
				PreparedStatement pstmtDelTeam =  conn.prepareStatement(delMeetTeamSql);
				pstmtDelTeam.setString(1, dcrID);
				pstmtDelTeam.executeUpdate();
				pstmtDelTeam.close(); pstmtDelTeam = null;

				//Deleting from old DCR tables
				{
					String deleteDrMainSql = "DELETE FROM DR_MAIN WHERE SALES_PERS= ? AND WORK_DATE=? ";
					pstmt =  conn.prepareStatement(deleteDrMainSql);
					pstmt.setString(1, salesPers);
					pstmt.setTimestamp(2 ,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
					pstmt.executeUpdate();
					pstmt.close(); pstmt = null;//Added By Dipak On 17 Aug 13

					String deleteTravelDetailSql="DELETE FROM DR_TRAVEL_DETAILS WHERE SALES_PERS= ? AND WORK_DATE=? ";
					pstmt =  conn.prepareStatement(deleteTravelDetailSql);
					pstmt.setString(1, salesPers);
					pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
					pstmt.executeUpdate();
					pstmt.close(); pstmt = null;//Added By Dipak On 17 Aug 13


					//String deleteDrChemistVisitSql="DELETE FROM DR_CHEMIST_VISIT WHERE DCR_ID = ? ";
					String deleteDrDoctorVisitSql="DELETE FROM DR_DOCTOR_VISIT WHERE SALES_PERS= ?  AND WORK_DATE=?  ";
					pstmt =  conn.prepareStatement(deleteDrDoctorVisitSql);
					pstmt.setString(1, salesPers);
					pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
					pstmt.executeUpdate();
					pstmt.close(); pstmt = null;//Added By Dipak On 17 Aug 13

					/*Added By Dipak On 17 Aug 2013 Start*/
					String deleteDrChemistVisitSql="DELETE FROM DR_CHEMIST_VISIT WHERE SALES_PERS = ?  AND WORK_DATE=? ";
					pstmt =  conn.prepareStatement(deleteDrChemistVisitSql);
					pstmt.setString(1, salesPers);
					pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
					recordsDeleted = pstmt.executeUpdate();
					System.out.println("["+ recordsDeleted +"] Records deleted from [DR_CHEMIST_VISIT]");
					pstmt.close(); pstmt = null;
					/*Ended By Dipak On 17 Aug 2013*/

					String deleteDrSampleDistributedSql="DELETE FROM DR_SAMPLE_DISTRIBUTED WHERE SALES_PERS = ?  AND WORK_DATE=? ";
					pstmt =  conn.prepareStatement(deleteDrSampleDistributedSql);
					pstmt.setString(1, salesPers);
					pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
					pstmt.executeUpdate();
					pstmt.close(); pstmt = null;//Added By Dipak On 17 Aug 13

				}
				//Returning the success delete message
				retString = itmDBAccess.getErrorString("","METATRADLT",userId);
			}
			else
			{
				//Returning the failure delete message
				retString = itmDBAccess.getErrorString("","NODTTOTDLT",userId);
			}

		}
		catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch(Exception e1){}
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				/*Added By Dipak On 17 Aug 13 Start*/
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				/*Ended By Dipak On 17 Aug 13*/

				if ( conn != null )
				{
					conn.commit();
					conn.close();conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return retString;


		}
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input;
	}
	public String checkNullAndTrim(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	private String getObjNameFromDom( Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node currDetail = null;
		String objName = "";
		int detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		System.out.println("objName =["+objName+"]");
		return objName;
	}

}// END OF MAIN CLASS


