package ibase.webitm.utility.wsfa;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.bean.wsfa.StrgMeetWizardBean;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.utility.ITMException;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
/**
 * This class contains business logic for getting data from org structure.
 * 
 * @author Mrunalini S.
 *
 */
public class WSFACommon
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	public HashMap<String,String> getVisitData(String  salesPers,String itemSer, Connection conn)
	{
		System.out.println("INSIDE getVisitData (()salesPers:::["+salesPers+"]::newDrVisits:::["+itemSer+"]");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		HashMap<String,String> docVisitCntHM=  new HashMap<String, String>();
		
		try
		{			
			SimpleDateFormat sdfs = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime(); 
			String currDates = sdfs.format( date ); 
			String gradeLevelNo = "";
			String empSite= "";
			String maxStrgVisit ="";
			String maxStrgCustomr ="";
			boolean  isRecExists = false ;
			
			sql="SELECT  MAX_STRG_VISITS,MAX_STRG_CUST  FROM STRG_SER_VISIT WHERE SALES_PERS = ? AND ? BETWEEN EFF_FROM AND VALID_UPTO AND  APPL_VISIT = 'N'";										
		
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDates , genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			rs = pstmt.executeQuery();					
			if(rs.next() )
			{
				maxStrgVisit= checkNull(rs.getString("MAX_STRG_VISITS")); 
				maxStrgCustomr= checkNull(rs.getString("MAX_STRG_CUST")); 
				docVisitCntHM.put(maxStrgCustomr, maxStrgVisit);
				isRecExists = true;	
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("isRecExists1 is:"+isRecExists);
		
			if(isRecExists == false)
			{	
				sql = "SELECT LEVEL_NO FROM GRADE WHERE GRADE_CODE = (SELECT GRADE FROM EMPLOYEE WHERE EMP_CODE = ? )";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, salesPers);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					gradeLevelNo = checkNull(rs.getString("LEVEL_NO"));
				}
				if(rs != null)
				{
					rs.close(); 
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				
				sql = "SELECT SITE_CODE__DEF FROM USERS WHERE CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, salesPers);
				
				rs = pstmt.executeQuery();					
				if( rs.next() )
				{
					empSite  = checkNull(rs.getString("SITE_CODE__DEF"));
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				String siteDiv = empSite.trim() + itemSer.trim();
				System.out.println("siteDiv is:["+siteDiv+"]");
				
				sql="SELECT  MAX_STRG_VISITS ,MAX_STRG_CUST  FROM STRG_SER_VISIT WHERE ENTERPRISE  = ? AND LEVEL_NO = ?  AND APPL_VISIT = 'Y' AND ? BETWEEN EFF_FROM AND VALID_UPTO ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteDiv );
				pstmt.setString(2,gradeLevelNo);
				pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDates , genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				rs = pstmt.executeQuery();
				System.out.println("before calculating all data");
				if(rs.next())
				{
					maxStrgVisit= checkNull(rs.getString("MAX_STRG_VISITS")); 
					maxStrgCustomr= checkNull(rs.getString("MAX_STRG_CUST")); 
					docVisitCntHM.put(maxStrgCustomr, maxStrgVisit);
					isRecExists = true;
				}
				if(rs != null)
				{
					rs.close(); 
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("isRecExists2 is:"+isRecExists);

				if(isRecExists == false  )
				{	
					sql="SELECT  MAX_STRG_VISITS ,MAX_STRG_CUST  FROM STRG_SER_VISIT WHERE ENTERPRISE  = ? AND LEVEL_NO = ?  AND APPL_VISIT = 'Y' AND ? BETWEEN EFF_FROM AND VALID_UPTO ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, itemSer );
					pstmt.setString(2,gradeLevelNo);
					pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDates , genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						maxStrgVisit= checkNull(rs.getString("MAX_STRG_VISITS")); 
						maxStrgCustomr= checkNull(rs.getString("MAX_STRG_CUST")); 
						docVisitCntHM.put(maxStrgCustomr, maxStrgVisit);
						isRecExists = true;
						
					}
					if(rs != null)
					{
						rs.close(); 
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}	
				
				System.out.println("isRecExists3 is:"+isRecExists);

				if(isRecExists == false  )
				{	
					sql="SELECT  MAX_STRG_VISITS ,MAX_STRG_CUST  FROM STRG_SER_VISIT WHERE ENTERPRISE  = ? AND APPL_VISIT = 'Y' AND ? BETWEEN EFF_FROM AND VALID_UPTO AND LEVEL_NO IS NULL";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, itemSer );
					pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDates , genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						maxStrgVisit= checkNull(rs.getString("MAX_STRG_VISITS")); 
						maxStrgCustomr= checkNull(rs.getString("MAX_STRG_CUST")); 
						docVisitCntHM.put(maxStrgCustomr, maxStrgVisit);
						isRecExists = true;
						
					}
					if(rs != null)
					{
						rs.close(); 
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}	
			}	
		}
		catch(Exception e)
		{
			e.printStackTrace();

		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				
			}
			catch (Exception e1){}
		}
		System.out.println("docVisitCntHM::SDF::["+docVisitCntHM+"]");
		return docVisitCntHM;
	}
	public String findValue(Connection conn, String columnName ,String tableName, String columnName2, String value) throws  ITMException
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ;
		String sql = "";
		String findValue = "";
		try
		{
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				findValue = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception e)
		{
			System.out.println("Exception in findValue ");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning String from findValue " + findValue);
		return findValue;
	}
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	//Added by Gulzar to copy the log file on 16/11/12
	public int randomNumberBetween(int start, int end)
	{
		int randomNumber = 0;
		randomNumber = (int) ( ( end - start  + 1 ) * Math.random() + start ) ;
		return randomNumber;
	}
	public void copyLogFile()
	{
		String errDirName = "SLOG" + randomNumberBetween(0, 99999);
		String serverLogPath = CommonConstants.JBOSSHOME + File.separator + "server" +  File.separator + "default" +  File.separator + "log" ;

		File errDir = new File( serverLogPath + File.separator + errDirName );
		if( errDir != null && ! errDir.exists() )
		{
			errDir.mkdir();
		}
		else
		{
			errDirName = "SLOG" + randomNumberBetween(0, 99999);
			errDir = new File( serverLogPath + File.separator + errDirName );
			errDir.mkdir();
		}

		String[] fileList = {"server.log"};

		for(String fileName : fileList)
		{
			try
			{
				File logFile = new File(serverLogPath + File.separator + fileName);
				if( logFile.exists() )
				{
					FileUtils.copyFileToDirectory( logFile ,  new File(serverLogPath + File.separator + errDirName), true);
				}

			} catch (IOException e) {
				e.printStackTrace();
			}

		}
	}
	//End changes by Gulzar to copy the log file on 16/11/12
	public String getPropertiesVal(Connection conn, String propName) throws Exception
	{
		String propVal = "";
		PreparedStatement pstmtProp = null;
		ResultSet rsProp = null;
		try
		{
			String propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ?";
			pstmtProp = conn.prepareStatement(propSql);
			pstmtProp.setString(1,propName);
			rsProp = pstmtProp.executeQuery();
			if(rsProp.next())
			{
				propVal = (rsProp.getString("PROP_VALUE") == null) ?"":rsProp.getString("PROP_VALUE");
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try
			{
				if(rsProp != null)
				{
					rsProp.close(); rsProp = null;
				}
				if(pstmtProp != null)
				{
					pstmtProp.close(); pstmtProp = null;
				}
			}
			catch(Exception e){}
		}
		//System.out.println("propVal for "+propName+" =["+propVal+"]");
		return propVal;
	}
	public String getMsgDescr(String messageCode,Connection connectionObject)throws ITMException
	{
		System.out.println(">>>>>>>>>>getMsgDescr()<<<<<<<<<<<<");
		String returnString="";
		String msgDescr="";
		boolean isLocalConn =false;
		try
		{
			//Connection connectionObject = null;
			PreparedStatement pstmtSelect = null;
			ResultSet resultSelect = null ;
			if(connectionObject == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
					connectionObject = connDriver.getConnectDB("DriverValidator");*/
				//connectionObject = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
				isLocalConn =true;
			}
			String selectMsgDescrSql = "SELECT MSG_DESCR FROM MESSAGES WHERE MSG_NO= ? ";
			pstmtSelect = connectionObject.prepareStatement(selectMsgDescrSql);
			pstmtSelect.setString(1, messageCode);
			resultSelect = pstmtSelect.executeQuery();
			if(resultSelect.next())
			{
				msgDescr = (resultSelect.getString("MSG_DESCR") == null)?"":resultSelect.getString("MSG_DESCR").trim();
			}
			returnString=msgDescr;
			resultSelect.close();
			resultSelect=null;
			pstmtSelect.close();
			pstmtSelect=null;

		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetWizardEJB:getMsgDescr():==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch (Exception e)
			{
				e.getMessage();
			}
		}
		return returnString;
	}
	public String getHoltblno (String emplCode, String eventDate, Connection conn ) throws Exception
	{
		int count = 0;
		int cnt = 0;
		String sql = null;
		String sqlCnt = null;
		String holTblNo = null;
		String sqlTbl = null;
		String sqlTblNo = null;
		PreparedStatement pstmtCount = null;
		ResultSet rsCount = null;
		PreparedStatement pstmtCnt = null;
		ResultSet rsCnt = null;
		PreparedStatement pstmtSet = null;
		ResultSet rsSet = null;
		PreparedStatement pstmtTbl = null;
		ResultSet rsTbl = null;
		PreparedStatement pstmtTblno = null;
		ResultSet rsTblno = null;

		try
		{
			sql = " SELECT COUNT(*) AS COUNT FROM EMP_EMPLOY_EVENTS WHERE EMP_CODE = ? AND CONFIRMED = 'Y'";
			pstmtCount = conn.prepareStatement(sql);
			pstmtCount.setString(1, emplCode);
			rsCount = pstmtCount.executeQuery();

			if(rsCount.next())
			{
				count = rsCount.getInt("COUNT");
			}
			//System.out.println("EMP_EMPLOY_EVENTS count =["+count+"]");
			if(count > 0 )
			{
				String sql1 = " SELECT COUNT(*) AS COUNT FROM EMP_EMPLOY_EVENTS WHERE EMP_CODE = ? AND EFF_DATE = (SELECT MAX(EFF_DATE) FROM EMP_EMPLOY_EVENTS WHERE EMP_CODE = ? AND CONFIRMED =  'Y'AND EFF_DATE <= ?) AND CONFIRMED = 'Y'";
				pstmtCnt = conn.prepareStatement(sql1);
				pstmtCnt.setString(1, emplCode);
				pstmtCnt.setString(2, emplCode);
				pstmtCnt.setTimestamp(3, java.sql.Timestamp.valueOf(eventDate));
				rsCnt = pstmtCnt.executeQuery();

				if(rsCnt.next())
				{
					cnt = rsCnt.getInt("COUNT");
				}
				System.out.println("EMP_EMPLOY_EVENTS cnt =["+cnt+"]");
				if(cnt > 0 )
				{
					sqlCnt = " SELECT AA.HOL_TBLNO__TO AS HOL_TBLNO FROM EMP_EMPLOY_EVENTS AA WHERE AA.EMP_CODE = ? AND AA.CONFIRMED = 'Y' AND AA.TRAN_ID = ( SELECT MAX(BB.TRAN_ID) FROM EMP_EMPLOY_EVENTS BB WHERE BB.EMP_CODE = AA.EMP_CODE AND BB.EFF_DATE = ( SELECT MAX(CC.EFF_DATE) FROM EMP_EMPLOY_EVENTS CC WHERE CC.EMP_CODE = AA.EMP_CODE AND CC.EFF_DATE <= ? AND CC.CONFIRMED = 'Y' ) AND BB.CONFIRMED = 'Y')";
				}
				else
				{
					sqlCnt = " SELECT AA.HOL_TBLNO__FR AS HOL_TBLNO FROM EMP_EMPLOY_EVENTS AA WHERE AA.EMP_CODE = ? AND AA.CONFIRMED = 'Y' AND AA.TRAN_ID = ( SELECT MIN(BB.TRAN_ID) FROM EMP_EMPLOY_EVENTS BB WHERE BB.EMP_CODE = AA.EMP_CODE AND BB.EFF_DATE = ( SELECT MIN(CC.EFF_DATE) FROM EMP_EMPLOY_EVENTS CC WHERE CC.EMP_CODE = AA.EMP_CODE AND CC.EFF_DATE > ? AND CC.CONFIRMED = 'Y' ) AND BB.CONFIRMED = 'Y')";
				}
				pstmtSet = conn.prepareStatement(sqlCnt);
				pstmtSet.setString(1, emplCode);
				pstmtSet.setTimestamp(2, java.sql.Timestamp.valueOf(eventDate));
				rsSet = pstmtSet.executeQuery();
				if(rsSet.next())
				{
					holTblNo = rsSet.getString("HOL_TBLNO");
				}
			}

			if(holTblNo == null || (holTblNo).trim().length() == 0  )
			{
				String workSite = "";
				sqlTbl = "SELECT HOL_TBLNO, WORK_SITE FROM EMPLOYEE WHERE EMP_CODE = ? ";
				pstmtTbl = conn.prepareStatement(sqlTbl);
				pstmtTbl.setString(1, emplCode);
				rsTbl = pstmtTbl.executeQuery();
				if(rsTbl.next())
				{
					holTblNo = rsTbl.getString("HOL_TBLNO");
					workSite = rsTbl.getString("WORK_SITE");
				}

				if(holTblNo == null || (holTblNo).trim().length() == 0  )
				{
					sqlTblNo = "SELECT HOL_TBLNO FROM SITE WHERE SITE_CODE = ? ";
					pstmtTblno = conn.prepareStatement(sqlTblNo);
					pstmtTblno.setString(1, workSite);
					rsTblno = pstmtTblno.executeQuery();

					if(rsTblno.next())
					{
						holTblNo = rsTblno.getString("HOL_TBLNO");
					}
				}
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsCount != null)
				{
					rsCount.close();
					rsCount = null;
				}
				if(pstmtCount !=null)
				{
					pstmtCount.close();
					pstmtCount = null;
				}
				if (rsCnt != null)
				{
					rsCnt.close();
					rsCnt = null;
				}
				if(pstmtCnt !=null)
				{
					pstmtCnt.close();
					pstmtCnt = null;
				}
				if (rsSet != null)
				{
					rsSet.close();
					rsSet = null;
				}
				if(pstmtSet !=null)
				{
					pstmtSet.close();
					pstmtSet = null;
				}
				if (rsTbl != null)
				{
					rsTbl.close();
					rsTbl = null;
				}
				if(pstmtTbl !=null)
				{
					pstmtTbl.close();
					pstmtTbl = null;
				}
				if (rsTblno != null)
				{
					rsTblno.close();
					rsTblno = null;
				}
				if(pstmtTblno !=null)
				{
					pstmtTblno.close();
					pstmtTblno = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("holTblNo =["+holTblNo+"]");
		return holTblNo;
	}
	public String getNextDate( String EventDate ) throws ITMException
	{
		java.util.Date uDate1 = null;
		String nextEventDate = null;
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());

			Calendar calObject = Calendar.getInstance();
			calObject.setTime( sdf.parse(EventDate));
			calObject.add( calObject.DATE, 1 );
			uDate1 = calObject.getTime();
			nextEventDate =  sdf.format(uDate1.getTime() );
			calObject = null;
		}
		catch( Exception e )
		{
			throw new ITMException(e);
		}
		return nextEventDate;
	}
	public String getModifiedErrorString(String errString, String modifiedString)
	{
		String xmlStr1 = "";
		String xmlStr2 = "";
		//String xmlStr3 = "";
		try
		{
			if(errString.indexOf("<trace>") != -1)
			{
				xmlStr1 = errString.substring(0,errString.indexOf("<trace>"));
				//xmlStr3 = errString.substring(errString.indexOf("<description>")+"<description>".length(),errString.indexOf("</description>"));
				xmlStr2 = errString.substring(errString.indexOf("</trace>")+"</trace>".length());

				modifiedString = "<trace>" + modifiedString + "</trace>";

				errString = xmlStr1 + modifiedString + xmlStr2;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		//System.out.println("getModifiedErrorString >> errString ::"+errString);
		return errString;
	}
	public boolean validVisitTime(String timeStr) 
    {
		String p1 = "";
		String p2 = "";
		String p3 = "";
		String p4 = "";
		String p5 = "";
		boolean retFlag = false;

		try
		{
			if (timeStr != null && timeStr.trim().length() == 8)
			{
				timeStr = timeStr.trim();
				p1 = timeStr.substring(0 , 2); // 2digit hours
				p2 = timeStr.substring(2 , 3); // :
				p3 = timeStr.substring(3 , 5); // 2digit min
				p4 = timeStr.substring(5 , 6); // white space
				p5 = timeStr.substring(6 , 8); // 2 char AM/PM
		
				
				int ip1 = Integer.parseInt(p1);
				int ip3 = Integer.parseInt(p3);
				if ( (p1.trim().length() == 2 && p3.trim().length() == 2) 
					&& (ip1 >= 1 && ip1 <= 12 ) 
					&& p2 .equals(":") 
					&& ( ip3 >= 0 && ip3 <= 59) 
					&& p4 .equals(" ") && (p5 .equals("AM") || p5.equals ("PM")))
				{
					retFlag = true;
				}
				else
				{
					retFlag = false;
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			//throw new ITMException(e);
		}
		finally
		{
		}	
		return retFlag;
	}
	// Added by Harion S for fortune server -18-May-2021 [End]
	public String getDescrModifiedErrorString(String errString, String modifiedString)
	{
		String xmlStr1 = "";
		String xmlStr2 = "";
		String xmlStr3 = "";
		try
		{
			if(errString.indexOf("<description>") != -1)
			{
				xmlStr1 = errString.substring(0,errString.indexOf("<description>"));
				xmlStr2 = errString.substring(errString.indexOf("</description>")+"</description>".length());
				xmlStr3 = errString.substring(errString.indexOf("<description>")+"<description>".length(),errString.indexOf("</description>"));
				System.out.println("xmlStr3:::::::["+xmlStr3+"]");
				modifiedString = xmlStr3+ " "+modifiedString ;
				System.out.println("modifiedString:::::::["+modifiedString+"]");
				modifiedString = "<description>" + modifiedString + "</description>";
				System.out.println("modifiedString:::::test::["+modifiedString+"]");

				errString = xmlStr1 + modifiedString + xmlStr2;
				System.out.println("errString:::::test::["+errString+"]");

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		//System.out.println("getModifiedErrorString >> errString ::"+errString);
		return errString;
	}
	public String getFldStaffSiteList(Connection conn)
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String fldStaffSiteString = "";
		String sql = "";
		try
		{
			sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'FIELDSTAFF_SITELIST' AND ITEM_SER = 'ALL'";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			 if (rs.next())
			 {
				fldStaffSiteString = checkNull(rs.getString("PROP_VALUE"));
			 }
			 if (rs!=null)
			 {
				 rs.close();
				 rs = null;
			 }
			 if (pstmt!=null)
			 {
				 pstmt.close();
				 pstmt = null;
			 }

		}
		catch (Exception exp)
		{
			System.out.println("Inside Exception catch [SavexWizardBean][getFldStaffSiteList]Exception:>>"+exp.getMessage());
			exp.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
				 rs.close();
				 rs = null;
				}
				if (pstmt!=null)
				{
				 pstmt.close();
				 pstmt = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		return fldStaffSiteString;
	}
	public String getLoadNo(String salesPers, Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String loadNo = "";
		try
		{
			String loadNoSql = "SELECT MAX(TO_NUMBER(CASE WHEN LOAD_NO IS NULL THEN '0' ELSE LOAD_NO END)) AS LOAD_NO FROM SPRS_DAY_SUMM WHERE SALES_PERS =? AND EVENT_DATE = (SELECT MAX(EVENT_DATE) FROM SPRS_DAY_SUMM WHERE SALES_PERS= ?)";
			
			pstmt = conn.prepareStatement(loadNoSql);
			pstmt.setString(1, salesPers);
			pstmt.setString(2, salesPers);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				loadNo = checkNull(rs.getString("LOAD_NO"));
			}
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				
			}
		}
		System.out.println("Load No =["+loadNo +"]");
		return loadNo;
	}
	public String getFormattedList( ArrayList dataList )
	{
		String salesPersData = "";
		try
		{
			for (int i = 0; i < dataList.size(); i++) 
			{
				String data = (String) dataList.get(i);
				if(salesPersData == null || salesPersData.trim().length() == 0)
				{
					salesPersData = "'"+data+"'";
				}
				else
				{
					salesPersData = salesPersData + "," + "'"+data+"'";
				}
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}	
		return salesPersData;
	}

}
//Added by sachin satre on [04-dec-17] for request id :W17ISUN002 [end]
