/*
 * Decompiled with CFR 0.152.
 */
package ibase.scheduler.bean;

import ibase.scheduler.ejb.ScheduleInfoEJB;
import ibase.scheduler.ejb.ScheduleInfoRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.ApplicationMetadata;
import ibase.utility.ApplicationParams;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchedulerBean
implements Serializable {
    private ArrayList scheduleNamesList = null;
    private ArrayList scheduleIdList = null;
    private ArrayList activityList = new ArrayList();
    private String scheduleId = null;
    private String pageContx = null;
    InitialContext ctx = null;

    private InitialContext getInitialContext() throws Exception {
        try {
            AppConnectParm appConnect = new AppConnectParm();
            this.ctx = new InitialContext(appConnect.getProperty());
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return this.ctx;
    }

    private ScheduleInfoRemote getSchedulerInfo() throws Exception {
        ScheduleInfoEJB scheduleInfo = null;
        try {
            if (this.ctx == null) {
                this.ctx = this.getInitialContext();
            }
            BaseLogger.log("3", null, null, "Looking Up for ScheduleInfoEJB ......");
            scheduleInfo = new ScheduleInfoEJB();
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return scheduleInfo;
    }

    public void getAllScheduleId() throws BaseException {
        try {
            this.scheduleNamesList = new ArrayList();
            this.scheduleIdList = new ArrayList();
            ScheduleInfoRemote scheduleInfo = this.getSchedulerInfo();
            ArrayList allScheduleIdList = scheduleInfo.getAllScheduleNameList();
            if (allScheduleIdList != null) {
                int noOfSchdl = allScheduleIdList.size();
                int schdlCtr = 0;
                while (schdlCtr < noOfSchdl) {
                    String allScheduleIdStr = (String)allScheduleIdList.get(schdlCtr);
                    int indexOfSep = allScheduleIdStr.indexOf("~");
                    if (indexOfSep != -1) {
                        this.scheduleIdList.add(allScheduleIdStr.substring(0, indexOfSep));
                        this.scheduleNamesList.add(allScheduleIdStr.substring(indexOfSep + 1));
                    }
                    ++schdlCtr;
                }
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public void getAllScheduleId(String owner) throws BaseException {
        BaseLogger.log("2", null, null, "<SchedulerBean><getAllScheduleId()>Start");
        try {
            this.scheduleNamesList = new ArrayList();
            this.scheduleIdList = new ArrayList();
            ScheduleInfoRemote scheduleInfo = this.getSchedulerInfo();
            String allScheduleStr = scheduleInfo.getSchedulesNameAfterReg(owner);
            ArrayList allScheduleIdList = new E12GenericUtility().getTokenList(allScheduleStr, ",");
            if (allScheduleIdList != null) {
                int noOfSchdl = allScheduleIdList.size();
                int schdlCtr = 0;
                while (schdlCtr < noOfSchdl) {
                    String allScheduleIdStr = (String)allScheduleIdList.get(schdlCtr);
                    int indexOfSep = allScheduleIdStr.indexOf("~");
                    if (indexOfSep != -1) {
                        this.scheduleIdList.add(allScheduleIdStr.substring(0, indexOfSep));
                        this.scheduleNamesList.add(allScheduleIdStr.substring(indexOfSep + 1));
                    }
                    ++schdlCtr;
                }
            }
        }
        catch (BaseException be) {
            BaseLogger.log("0", null, null, "BaseException:<SchedulerBean><getSchedulerInfo(owner)>" + be.getMessage());
            throw be;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception:<SchedulerBean><getSchedulerInfo(owner)>" + e.getMessage());
            throw new BaseException(e);
        }
        BaseLogger.log("3", null, null, "<SchedulerBean><getAllScheduleId(owner)>End");
    }

    public ArrayList getScheduleNamesList() {
        return this.scheduleNamesList;
    }

    public ArrayList getScheduleIdList() {
        return this.scheduleIdList;
    }

    public String setActivityList(String activityName, String scheduleId, String pgContx) throws Exception {
        String nameStr = activityName;
        ArrayList activityListTemp = null;
        try {
            if (!pgContx.equals(this.pageContx) && this.pageContx != null) {
                this.activityList.clear();
            } else if (!scheduleId.equals(this.scheduleId) && this.scheduleId != null) {
                this.activityList.clear();
            }
            this.pageContx = pgContx;
            this.scheduleId = scheduleId;
            ApplicationParams appParam = null;
            ApplicationMetadata appMetaData = new ApplicationMetadata();
            activityListTemp = appMetaData.getSchedulableActivities();
            int noOfActivity = activityListTemp.size();
            int actCtr = 0;
            while (actCtr < noOfActivity) {
                appParam = (ApplicationParams)activityListTemp.get(actCtr);
                if (appParam.getApplnName().equals(activityName)) {
                    this.activityList.add(appParam);
                    break;
                }
                ++actCtr;
            }
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return nameStr;
    }

    public ArrayList getActivityList() {
        return this.activityList;
    }

    public String getActivityInfo(String activityName) {
        String url = "";
        int actSize = this.activityList.size();
        ApplicationParams appParam = null;
        StringBuffer activityStringBuf = null;
        int actCtr = 0;
        while (actCtr < actSize) {
            appParam = (ApplicationParams)this.activityList.get(actCtr);
            if (appParam.getApplnName().equals(activityName)) {
                url = appParam.getInputEditor();
                activityStringBuf = new StringBuffer();
                activityStringBuf.append("<ACTIVITY>");
                activityStringBuf.append("<ACTUALPARAMETERS>");
                ArrayList actualParamList = appParam.getParamList();
                HashMap paramMap = null;
                int paramCtr = 0;
                while (paramCtr < actualParamList.size()) {
                    paramMap = (HashMap)actualParamList.get(paramCtr);
                    activityStringBuf.append("<ACTUALPARAMETER>");
                    activityStringBuf.append("<![CDATA[");
                    activityStringBuf.append(paramMap.get("PARAM_VALUE"));
                    activityStringBuf.append("]]>");
                    activityStringBuf.append("</ACTUALPARAMETER>");
                    ++paramCtr;
                }
                activityStringBuf.append("</ACTUALPARAMETERS>");
                activityStringBuf.append("<TYPE>");
                activityStringBuf.append("<![CDATA[");
                activityStringBuf.append(appParam.getApplnType());
                activityStringBuf.append("]]>");
                activityStringBuf.append("</TYPE>");
                activityStringBuf.append("<CLASS_NAME>");
                activityStringBuf.append("<![CDATA[");
                activityStringBuf.append(appParam.getCompName());
                activityStringBuf.append("]]>");
                activityStringBuf.append("</CLASS_NAME>");
                activityStringBuf.append("<URL>");
                activityStringBuf.append("<![CDATA[");
                activityStringBuf.append(appParam.getInputEditor());
                activityStringBuf.append("]]>");
                activityStringBuf.append("</URL>");
                activityStringBuf.append("</ACTIVITY>");
                break;
            }
            ++actCtr;
        }
        return activityStringBuf.toString();
    }

    public String deleteActivity(String activityName) {
        String actName = "";
        int actSize = this.activityList.size();
        ApplicationParams appParam = null;
        int actCtr = 0;
        while (actCtr < actSize) {
            appParam = (ApplicationParams)this.activityList.get(actCtr);
            if (appParam.getApplnName().equals(activityName)) {
                this.activityList.remove(actCtr);
                actName = activityName;
                break;
            }
            ++actCtr;
        }
        return actName;
    }

    public ArrayList getallSchSummaryInfo() throws BaseException {
        ArrayList allSchSummList = null;
        try {
            ScheduleInfoRemote scheduleInfo = this.getSchedulerInfo();
            String allScheduleXmlStr = scheduleInfo.getAllSchSummary();
            Document allSchDom = new E12GenericUtility().parseString(allScheduleXmlStr);
            allSchSummList = this.parseSchProp(allSchDom);
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception exp) {
            throw new BaseException(exp);
        }
        return allSchSummList;
    }

    public ArrayList getallSchSummaryInfo(String owner) throws BaseException {
        ArrayList allSchSummList = null;
        try {
            ScheduleInfoRemote scheduleInfo = this.getSchedulerInfo();
            String allScheduleXmlStr = scheduleInfo.getAllSchSummary(owner);
            Document allSchDom = new E12GenericUtility().parseString(allScheduleXmlStr);
            allSchSummList = this.parseSchProp(allSchDom);
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception exp) {
            throw new BaseException(exp);
        }
        return allSchSummList;
    }

    private ArrayList parseSchProp(Document allSchDom) throws Exception {
        ArrayList allSchSummList = new ArrayList();
        HashMap<String, String> schMap = null;
        NodeList allSchNodeList = allSchDom.getElementsByTagName("SCHEDULE");
        int noOfSch = allSchNodeList.getLength();
        int schCtr = 0;
        while (schCtr < noOfSch) {
            schMap = new HashMap<String, String>();
            Node schNode = allSchNodeList.item(schCtr);
            NodeList schldNodePropList = schNode.getChildNodes();
            if (schNode.getAttributes() != null && schNode.getAttributes().getNamedItem("id") != null) {
                schMap.put("ID", allSchNodeList.item(schCtr).getAttributes().getNamedItem("id").getNodeValue());
            }
            int schedulePropLen = schldNodePropList.getLength();
            int schedulePropCtr = 0;
            while (schedulePropCtr < schedulePropLen) {
                Node schldPropNode = schldNodePropList.item(schedulePropCtr);
                if (schldPropNode != null && schldPropNode.getNodeType() == 1) {
                    String nodeValue = "";
                    if (schldPropNode.getFirstChild() != null && schldPropNode.getFirstChild().getNodeValue() != null) {
                        nodeValue = schldPropNode.getFirstChild().getNodeValue();
                    }
                    schMap.put(schldPropNode.getNodeName(), nodeValue);
                }
                ++schedulePropCtr;
            }
            allSchSummList.add(schMap);
            ++schCtr;
        }
        return allSchSummList;
    }

    public LinkedHashMap getScheduleList() throws ITMException {
        return this.getScheduleList(null);
    }

    public LinkedHashMap getScheduleList(UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("2", null, null, "inside getScheduleList.........");
        LinkedHashMap scheduleMap = null;
        try {
            ScheduleInfoEJB scheduleInfo = new ScheduleInfoEJB();
            scheduleMap = scheduleInfo.getSchedulesInfoList(userInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "scheduleMap ::::::" + scheduleMap);
        return scheduleMap;
    }

    public HashMap getAllScheduleDetails(String scheduleID) {
        return this.getAllScheduleDetails(scheduleID, null);
    }

    public HashMap getAllScheduleDetails(String scheduleID, UserInfoBean userInfo) {
        BaseLogger.log("2", null, null, "getAllScheduleDetails  ::  scheduleID :: [" + scheduleID + "]");
        HashMap schedule = new HashMap();
        try {
            ScheduleInfoEJB scheduleInfo = new ScheduleInfoEJB();
            schedule = scheduleInfo.getAllScheduleDetails(scheduleID, userInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return schedule;
    }

    public ArrayList<String> getBusinessEventList(UserInfoBean userInfo) throws ITMException {
        System.out.println("SchedulerBean.getBusinessEventList()");
        ArrayList<String> busiEventList = new ArrayList();
        try {
            ScheduleInfoEJB scheduleInfo = new ScheduleInfoEJB();
            busiEventList = scheduleInfo.getBusinessEventList(userInfo);
        }
        catch (Exception e) {
            System.out.println("SchedulerBean.getBusinessEventList() Exception:[" + E12GenericUtility.getStackTrace(e) + "]");
            throw new ITMException(e);
        }
        System.out.println("SchedulerBean.getBusinessEventList() busiEventList:[" + busiEventList + "]");
        return busiEventList;
    }
}

