/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import java.io.File;
import java.util.LinkedHashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MetadataPropertyParser
extends DefaultHandler {
    LinkedHashMap<String, LinkedHashMap<String, String>> propertyMap = null;
    boolean isTableColumn = false;
    boolean isTextObject = false;
    boolean isColumnObject = false;
    boolean isEditStyle = false;
    String tempVal = "";
    String tempText = "";
    String tempName = "";
    String tempTabsequence = "";
    String tempProtect = "";
    String tempFormat = "";
    String tempMask = "";
    String tempWidth = "";
    String tempX = "";
    String tempY = "";
    String tempVisible = "";
    boolean isGroupObject = false;
    private String tempRequired = "";

    public LinkedHashMap<String, LinkedHashMap<String, String>> parse(File profileFile) throws Exception {
        this.propertyMap = new LinkedHashMap();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(profileFile, (DefaultHandler)this);
        return this.propertyMap;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
        this.tempVal = "";
        if (name.equalsIgnoreCase("table_column")) {
            this.tempName = "";
            this.isTableColumn = true;
        } else if (name.equalsIgnoreCase("TextObject")) {
            this.isTextObject = true;
            this.tempText = "";
            this.tempName = "";
            this.tempVisible = "";
        } else if (name.equalsIgnoreCase("ColumnObject")) {
            this.isColumnObject = true;
            this.tempName = "";
            this.tempTabsequence = "";
            this.tempProtect = "";
            this.tempWidth = "";
            this.tempX = "";
            this.tempY = "";
            this.tempVisible = "";
        } else if (name.equalsIgnoreCase("EditStyle")) {
            this.isEditStyle = true;
            this.tempFormat = "";
            this.tempMask = "";
            this.tempRequired = "";
        } else if (name.equalsIgnoreCase("GroupBox")) {
            this.isGroupObject = true;
            this.tempName = "";
            this.tempVisible = "";
            this.tempText = "";
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (name.equalsIgnoreCase("name")) {
            if (this.isTableColumn) {
                this.tempName = this.tempVal;
                this.addPropertyValue(this.tempName, null, null);
            } else if (this.isTextObject) {
                int i = this.tempVal.lastIndexOf("_t");
                if (i != -1) {
                    this.tempName = this.tempVal.substring(0, i);
                }
            } else if (this.isColumnObject) {
                this.tempName = this.tempVal;
            } else if (this.isGroupObject) {
                this.tempName = this.tempVal;
            }
        } else if (name.equalsIgnoreCase("table_column")) {
            this.isTableColumn = false;
        } else if (name.equalsIgnoreCase("text")) {
            if (this.isTextObject) {
                this.tempText = this.tempVal;
            } else if (this.isGroupObject) {
                this.tempText = this.tempVal;
            }
        } else if (name.equalsIgnoreCase("TextObject")) {
            this.addPropertyValue(this.tempName, "TextObject." + this.tempName + "_t.text", this.tempText);
            this.addPropertyValue(this.tempName, "TextObject." + this.tempName + "_t.visible", "1");
            this.isTextObject = false;
        } else if (name.equalsIgnoreCase("tabsequence")) {
            if (this.isColumnObject) {
                this.tempTabsequence = this.tempVal;
            }
        } else if (name.equalsIgnoreCase("protect")) {
            if (this.isColumnObject) {
                this.tempProtect = this.tempVal;
            }
        } else if (name.equalsIgnoreCase("visible")) {
            if (this.isColumnObject) {
                this.tempVisible = this.tempVal;
            } else if (this.isTextObject) {
                int i = this.tempVal.lastIndexOf("_t");
                if (i != -1) {
                    this.tempName = this.tempVal.substring(0, i);
                }
            } else if (this.isGroupObject) {
                this.tempVisible = this.tempVal;
            }
        } else if (name.equalsIgnoreCase("GroupBox")) {
            this.addPropertyValue(this.tempName, "GroupBox." + this.tempName + ".text", this.tempText);
            this.addPropertyValue(this.tempName, "GroupBox." + this.tempName + ".visible", "1");
        } else if (name.equalsIgnoreCase("format")) {
            if (this.isEditStyle) {
                this.tempFormat = this.tempVal;
            }
        } else if (name.equalsIgnoreCase("mask")) {
            if (this.isEditStyle) {
                this.tempMask = this.tempVal;
            }
        } else if (name.equalsIgnoreCase("required")) {
            if (this.isEditStyle) {
                this.tempRequired = this.tempVal;
            }
        } else if (name.equalsIgnoreCase("width")) {
            if (this.isColumnObject) {
                this.tempWidth = this.tempVal;
            }
        } else if (name.equalsIgnoreCase("x")) {
            if (this.isColumnObject) {
                this.tempX = this.tempVal;
            }
        } else if (name.equalsIgnoreCase("y")) {
            if (this.isColumnObject) {
                this.tempY = this.tempVal;
            }
        } else if (name.equalsIgnoreCase("ColumnObject")) {
            this.addPropertyValue(this.tempName, "ColumnObject." + this.tempName + ".tabsequence", this.tempTabsequence);
            this.addPropertyValue(this.tempName, "ColumnObject." + this.tempName + ".protect", this.tempProtect);
            this.addPropertyValue(this.tempName, "ColumnObject." + this.tempName + ".width", this.tempWidth);
            this.addPropertyValue(this.tempName, "ColumnObject." + this.tempName + ".x", this.tempX);
            this.addPropertyValue(this.tempName, "ColumnObject." + this.tempName + ".y", this.tempY);
            this.addPropertyValue(this.tempName, "ColumnObject." + this.tempName + ".visible", this.tempVisible);
            this.isColumnObject = false;
        } else if (name.equalsIgnoreCase("EditStyle")) {
            this.addPropertyValue(this.tempName, "ColumnObject." + this.tempName + ".EditStyle.format", this.tempFormat);
            this.addPropertyValue(this.tempName, "ColumnObject." + this.tempName + ".EditStyle.mask", this.tempMask);
            this.addPropertyValue(this.tempName, "ColumnObject." + this.tempName + ".EditStyle.required", this.tempRequired);
            this.isEditStyle = false;
        } else if (name.equalsIgnoreCase("initial") && this.isTableColumn) {
            this.addPropertyValue(this.tempName, "TableDefinition.table_column." + this.tempName + ".initial", this.tempVal);
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.tempVal = new String(buf, offset, len);
    }

    private void addPropertyValue(String colName, String property, String value) {
        LinkedHashMap<String, String> pMap = this.propertyMap.get(colName);
        if (pMap == null) {
            pMap = new LinkedHashMap();
            if (property != null && property.indexOf("GroupBox") != -1) {
                pMap.put("GroupBox." + colName + ".text", "");
                pMap.put("GroupBox." + colName + ".visible", "");
            } else {
                pMap.put("TextObject." + colName + "_t.text", "");
                pMap.put("TextObject." + colName + "_t.visible", "");
                pMap.put("ColumnObject." + colName + ".tabsequence", "");
                pMap.put("ColumnObject." + colName + ".protect", "");
                pMap.put("TableDefinition.table_column." + colName + ".initial", "");
                pMap.put("ColumnObject." + colName + ".EditStyle.format", "");
                pMap.put("ColumnObject." + colName + ".EditStyle.mask", "");
                pMap.put("ColumnObject." + colName + ".EditStyle.required", "");
                pMap.put("ColumnObject." + colName + ".width", "");
                pMap.put("ColumnObject." + colName + ".x", "");
                pMap.put("ColumnObject." + colName + ".y", "");
                pMap.put("ColumnObject." + colName + ".visible", "");
            }
            this.propertyMap.put(colName, pMap);
        }
        if (property != null) {
            pMap.put(property, value);
        }
    }
}

